// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_Metrics_h
#define mozilla_Metrics_h

#include "mozilla/glean/bindings/MetricTypes.h"
#include "mozilla/Maybe.h"
#include "nsTArray.h"
#include "nsPrintfCString.h"

#include <tuple>

namespace mozilla::glean {
struct NoExtraKeys;
enum class DynamicLabel: uint16_t { };

namespace privacy_sanitize {
  /**
   * generated from privacy.sanitize.clear
   */
    struct ClearExtra {
      mozilla::Maybe<bool> cache;
      mozilla::Maybe<nsCString> context;
      mozilla::Maybe<bool> cookiesAndStorage;
      mozilla::Maybe<bool> historyFormDataDownloads;
      mozilla::Maybe<bool> siteSettings;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (cache) {
          extraKeys.AppendElement()->AssignASCII("cache");
          extraValues.AppendElement()->AssignASCII(cache.value() ? "true" : "false");
        }
        if (context) {
          extraKeys.AppendElement()->AssignASCII("context");
          extraValues.EmplaceBack(context.value());
        }
        if (cookiesAndStorage) {
          extraKeys.AppendElement()->AssignASCII("cookies_and_storage");
          extraValues.AppendElement()->AssignASCII(cookiesAndStorage.value() ? "true" : "false");
        }
        if (historyFormDataDownloads) {
          extraKeys.AppendElement()->AssignASCII("history_form_data_downloads");
          extraValues.AppendElement()->AssignASCII(historyFormDataDownloads.value() ? "true" : "false");
        }
        if (siteSettings) {
          extraKeys.AppendElement()->AssignASCII("site_settings");
          extraValues.AppendElement()->AssignASCII(siteSettings.value() ? "true" : "false");
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Dispatched when the dialog is accepted (to clear)
   */
  constexpr impl::EventMetric<ClearExtra> clear(1);

  /**
   * generated from privacy.sanitize.clearing_time_span_selected
   */
    struct ClearingTimeSpanSelectedExtra {
      mozilla::Maybe<nsCString> timeSpan;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (timeSpan) {
          extraKeys.AppendElement()->AssignASCII("time_span");
          extraValues.EmplaceBack(timeSpan.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * The time span range selected to sanitize
   */
  constexpr impl::EventMetric<ClearingTimeSpanSelectedExtra> clearing_time_span_selected(2);

  /**
   * generated from privacy.sanitize.dialog_open
   */
    struct DialogOpenExtra {
      mozilla::Maybe<nsCString> context;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (context) {
          extraKeys.AppendElement()->AssignASCII("context");
          extraValues.EmplaceBack(context.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Dispatched when one of the sanitize dialogs opens
   */
  constexpr impl::EventMetric<DialogOpenExtra> dialog_open(3);

  /**
   * generated from privacy.sanitize.load_time
   */
  /**
   * How much time was spent to open the dialog, including loading data sizes
   */
  constexpr impl::TimingDistributionMetric load_time(4);

}
namespace browser_backup {
  /**
   * generated from browser.backup.browser_extension_data_size
   */
  /**
   * The total size of the current profiles storage.local legacy JSON backend in the
     * browser-extension-data directory, rounded to the nearest 10 kilobytes.
   */
  constexpr impl::QuantityMetric browser_extension_data_size(5);

  /**
   * generated from browser.backup.cookies_size
   */
  /**
   * The total file size of the cookies.sqlite db located in the current profile
     * directory, in kilobytes.
   */
  constexpr impl::QuantityMetric cookies_size(6);

  /**
   * generated from browser.backup.credentials_data_size
   */
  /**
   * The total size of logins, payment method, and form autofill related files in
     * the current profile directory, in kilobytes.
   */
  constexpr impl::QuantityMetric credentials_data_size(7);

  /**
   * generated from browser.backup.extension_store_permissions_data_size
   */
  /**
   * The file size of the current profiles extension-store-permissions/data.safe.bin
     * file, rounded to the nearest 10 kilobytes.
   */
  constexpr impl::QuantityMetric extension_store_permissions_data_size(8);

  /**
   * generated from browser.backup.extensions_json_size
   */
  /**
   * The total file size of the current profiles extensions metadata files, rounded
     * to the nearest 10 kilobytes. Files included are:
     *   - extensions.json
     *   - extension-settings.json
     *   - extension-preferences.json
     *   - addonStartup.json.lz4
   */
  constexpr impl::QuantityMetric extensions_json_size(9);

  /**
   * generated from browser.backup.extensions_storage_size
   */
  /**
   * The total size of all extensions storage directories, rounded to the nearest 10
     * kilobytes.
   */
  constexpr impl::QuantityMetric extensions_storage_size(10);

  /**
   * generated from browser.backup.extensions_xpi_directory_size
   */
  /**
   * The total size of the current profiles extensions directory, rounded to the
     * nearest 10 kilobytes.
   */
  constexpr impl::QuantityMetric extensions_xpi_directory_size(11);

  /**
   * generated from browser.backup.favicons_size
   */
  /**
   * The total file size of the favicons.sqlite db located in the current profile
     * directory, in kilobytes.
   */
  constexpr impl::QuantityMetric favicons_size(12);

  /**
   * generated from browser.backup.form_history_size
   */
  /**
   * The file size of the formhistory.sqlite db located in the current profile
     * directory, in kilobytes.
   */
  constexpr impl::QuantityMetric form_history_size(13);

  /**
   * generated from browser.backup.misc_data_size
   */
  /**
   * The total size of files for telemetry, site storage, media device origin
     * mapping, chrome privileged IndexedDB databases, and Mozilla Accounts in the
     * current profile directory, rounded to the nearest tenth kilobyte.
   */
  constexpr impl::QuantityMetric misc_data_size(14);

  /**
   * generated from browser.backup.places_size
   */
  /**
   * The total file size of the places.sqlite db located in the current profile
     * directory, in kilobytes.
   */
  constexpr impl::QuantityMetric places_size(15);

  /**
   * generated from browser.backup.preferences_size
   */
  /**
   * The total size of files relating to user preferences and permissions in the
     * current profile directory, in kilobytes.
   */
  constexpr impl::QuantityMetric preferences_size(16);

  /**
   * generated from browser.backup.prof_d_disk_space
   */
  /**
   * The total disk space available on the storage device that the profile directory
     * is stored on. To reduce fingerprintability, we round to the nearest 10
     * megabytes and return the result in kilobytes.
   */
  constexpr impl::QuantityMetric prof_d_disk_space(17);

  /**
   * generated from browser.backup.security_data_size
   */
  /**
   * The total size of files needed for NSS initialization parameters and security
     * certificate settings in the current profile directory, in kilobytes.
   */
  constexpr impl::QuantityMetric security_data_size(18);

  /**
   * generated from browser.backup.session_store_backups_directory_size
   */
  /**
   * The total size of the session store backups directory, in kilobytes.
   */
  constexpr impl::QuantityMetric session_store_backups_directory_size(19);

  /**
   * generated from browser.backup.session_store_size
   */
  /**
   * The size of uncompressed session store json, in kilobytes.
   */
  constexpr impl::QuantityMetric session_store_size(20);

  /**
   * generated from browser.backup.storage_sync_size
   */
  /**
   * The file size of the current profiles storage-sync-v2.sqlite db, rounded to the
     * nearest 10 kilobytes.
   */
  constexpr impl::QuantityMetric storage_sync_size(21);

}
namespace background_update {
  /**
   * generated from background_update.reasons_to_not_update
   */
  /**
   * Records which error was causing the background updater to fail. This list
     * supercedes the `background-update.reason` in `mozapps/update/metrics.yaml`
   */
  constexpr impl::StringListMetric reasons_to_not_update(22);

  /**
   * generated from background_update.time_last_update_scheduled
   */
  /**
   * Last time the background update was triggered.
   */
  constexpr impl::DatetimeMetric time_last_update_scheduled(23);

  /**
   * generated from background_update.automatic_restart_attempted
   */
  /**
   * True if the background update task successfully attempted an automatic restart.
   */
  constexpr impl::BooleanMetric automatic_restart_attempted(24);

  /**
   * generated from background_update.automatic_restart_success
   */
  /**
   * True if the background update task successfully restarted after an automatic
     * restart.
   */
  constexpr impl::BooleanMetric automatic_restart_success(25);

  /**
   * generated from background_update.client_id
   */
  /**
   * The legacy Telemetry client ID of this installation's default profile.
     * The default profile is as determined by the Profile Service, namely
     * `nsIToolkitProfileService.defaultProfile`.  The majority of users have only one
     * Firefox installation and only one profile, so the default profile is their
     * regular browsing profile.
     * It is possible for a Firefox installation to not have a default profile, but in
     * such cases the background update task will abort before sending any telemetry;
     * therefore, the legacy Telemetry client ID should always be present.
   */
  constexpr impl::UuidMetric client_id(26);

  /**
   * generated from background_update.exit_code_exception
   */
  /**
   * True if the exit code/status of the background update task is 3, which means an
     * exception was thrown.
   */
  constexpr impl::BooleanMetric exit_code_exception(27);

  /**
   * generated from background_update.exit_code_success
   */
  /**
   * True if the exit code/status of the background update task is 0, which means
     * success.
   */
  constexpr impl::BooleanMetric exit_code_success(28);

  /**
   * generated from background_update.final_state
   */
  /**
   * String description of the final state the update state machine reached.
   */
  constexpr impl::StringMetric final_state(29);

  /**
   * generated from background_update.reasons
   */
  /**
   * List of reasons that the background update task did not run.
   */
  constexpr impl::StringListMetric reasons(30);

  /**
   * generated from background_update.states
   */
  /**
   * Ordered list of string descriptions of the states that the update state machine
     * reached.
   */
  constexpr impl::StringListMetric states(31);

  /**
   * generated from background_update.targeting_env_current_date
   */
  /**
   * The `environment.currentDate` of the default profile's serialized targeting
     * snapshot.
   */
  constexpr impl::DatetimeMetric targeting_env_current_date(32);

  /**
   * generated from background_update.targeting_env_firefox_version
   */
  /**
   * The `environment.firefoxVersion` of the default profile's serialized targeting
     * snapshot.  At the time of writing, this version is an integer representing the
     * Firefox major version, e.g., `109`.
   */
  constexpr impl::QuantityMetric targeting_env_firefox_version(33);

  /**
   * generated from background_update.targeting_env_profile_age
   */
  /**
   * The `environment.profileAgeCreated` of the default profile's serialized
     * targeting snapshot.
   */
  constexpr impl::DatetimeMetric targeting_env_profile_age(34);

  /**
   * generated from background_update.targeting_exception
   */
  /**
   * True if the default profile had a targeting snapshot serialized to disk, but an
     * exception was thrown reading it.
   */
  constexpr impl::BooleanMetric targeting_exception(35);

  /**
   * generated from background_update.targeting_exists
   */
  /**
   * True if the default profile had a targeting snapshot serialized to disk, and
     * there was no exception thrown reading it.
   */
  constexpr impl::BooleanMetric targeting_exists(36);

  /**
   * generated from background_update.targeting_version
   */
  /**
   * If the default profile had a targeting snapshot serialized to disk, the
     * `version` of the snapshot.
     * This version number does not have a physical unit: it's only useful to compare
     * between versions.
   */
  constexpr impl::QuantityMetric targeting_version(37);

}
namespace browser_launched_to_handle {
  /**
   * generated from browser.launched_to_handle.system_notification
   */
    struct SystemNotificationExtra {
      mozilla::Maybe<nsCString> action;
      mozilla::Maybe<nsCString> name;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (action) {
          extraKeys.AppendElement()->AssignASCII("action");
          extraValues.EmplaceBack(action.value());
        }
        if (name) {
          extraKeys.AppendElement()->AssignASCII("name");
          extraValues.EmplaceBack(name.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when Firefox launches to complete a native notification popped by a
     * system (chrome privileged) alert.  Windows-only at the time of writing.
   */
  constexpr impl::EventMetric<SystemNotificationExtra> system_notification(38);

}
namespace browser_migration {
  /**
   * generated from browser.migration.matched_extensions
   */
  /**
   * Records a list of the Chrome extension IDs that were successfully matched to
     * Firefox equivalents from the list downloaded from AMO.
   */
  constexpr impl::StringListMetric matched_extensions(39);

  /**
   * generated from browser.migration.unmatched_extensions
   */
  /**
   * Records a list of the Chrome extension IDs that were unsuccessfully matched to
     * Firefox equivalents from the list downloaded from AMO.
   */
  constexpr impl::StringListMetric unmatched_extensions(40);

}
namespace messaging_system {
  /**
   * generated from messaging_system.addon_version
   */
  /**
   * Used to hold the system addon's version, now is almost certainly an echo of the
     * app's build id.
   */
  constexpr impl::StringMetric addon_version(41);

  /**
   * generated from messaging_system.browser_session_id
   */
  /**
   * The Legacy Telemetry browser "session id". Identifies a specific period from
     * application start to shutdown. See [the "main" ping docs](https://firefox-
     * source-docs.mozilla.org/toolkit/components/telemetry/data/main-ping.html) for
     * details.
   */
  constexpr impl::UuidMetric browser_session_id(42);

  /**
   * generated from messaging_system.bucket_id
   */
  /**
   * A name shared between multiple messages that may individually be too targetted.
     * e.g. a message that gets shown on specific websites or a message asking about
     * personal information.
   */
  constexpr impl::StringMetric bucket_id(43);

  /**
   * generated from messaging_system.client_id
   */
  /**
   * The client_id according to Telemetry.
     * Might not always have a value due to policy around specific types of
     * ping being sent. Value may be the canary client id
     * `c0ffeec0-ffee-c0ff-eec0-ffeec0ffeec0`
     * in pings near when the data upload pref is disabled (if Telemetry gets
     * to go first), or between when a client_id has been removed and when it
     * has been regenerated.
     * Present only in some circumstances (see
     * [bug 1484035]https://bugzilla.mozilla.org/show_bug.cgi?id=1484035)).
   */
  constexpr impl::UuidMetric client_id(44);

  /**
   * generated from messaging_system.event
   */
  /**
   * The type of event. Any user defined string (e.g. “IMPRESSION”, “CLICK_BUTTON”,
     * "INDEXEDDB_OPEN_FAILED", “SESSION_END”)
   */
  constexpr impl::StringMetric event(45);

  /**
   * generated from messaging_system.event_context
   */
  /**
   * The stringified JSON of `event_context`.
   */
  constexpr impl::TextMetric event_context(46);

  /**
   * generated from messaging_system.event_context_parse_error
   */
  /**
   * How often we failed to parse event_context as JSON.
   */
  constexpr impl::CounterMetric event_context_parse_error(47);

  /**
   * generated from messaging_system.event_page
   */
  /**
   * The event_context's `page`. Almost always "about:welcome".
   */
  constexpr impl::StringMetric event_page(48);

  /**
   * generated from messaging_system.event_reason
   */
  /**
   * The event_context's `reason`. Likely something like
     * "welcome-window-closed" or "app-shut-down",.
   */
  constexpr impl::StringMetric event_reason(49);

  /**
   * generated from messaging_system.event_screen_family
   */
  /**
   * A string identifier of the message family derived from the message id
     * (e.g. MR_WELCOME_DEFAULT).
   */
  constexpr impl::TextMetric event_screen_family(50);

  /**
   * generated from messaging_system.event_screen_id
   */
  /**
   * A string identifier of the message screen id
     * (e.g. AW_MOBILE_DOWNLOAD).
   */
  constexpr impl::TextMetric event_screen_id(51);

  /**
   * generated from messaging_system.event_screen_index
   */
  /**
   * A number identifier of the screen index in a sequence of screens
     * (e.g. 0 for first message).
   */
  constexpr impl::QuantityMetric event_screen_index(52);

  /**
   * generated from messaging_system.event_screen_initials
   */
  /**
   * A string identifier of the message screen initials
     * (e.g. 'EMAG' for EASY_SETUP, MOBILE_DOWNLOADS, AMO, GRATITUDE).
   */
  constexpr impl::TextMetric event_screen_initials(53);

  /**
   * generated from messaging_system.event_source
   */
  /**
   * The event_context's `source`. Likely something like "primary_button".
   */
  constexpr impl::StringMetric event_source(54);

  /**
   * generated from messaging_system.glean_ping_for_ping_failures
   */
  /**
   * How often something went awry within
     * `AboutWelcome.submitGleanPingForPing`, preventing ping submission.
   */
  constexpr impl::CounterMetric glean_ping_for_ping_failures(55);

  /**
   * generated from messaging_system.impression_id
   */
  /**
   * The unique impression identifier for a specific client.
   */
  constexpr impl::UuidMetric impression_id(56);

  /**
   * generated from messaging_system.invalid_nested_data
   */
  /**
   * We received a ping with non-scalar data on a field of this name.
     * If this is existing pre-PingCentre-replacement data, you may need to
     * augment the logic in
     * `AboutWelcome.submitGleanPingForPing` like the other `handledKeys`.
     * If this is for new, post-PingCentre-replacement data, you should
     * probably prefer a flat structure.
     * If you're unsure, please ask in
     * [the #glean channel](https://chat.mozilla.org/#/room/#glean:mozilla.org).
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> invalid_nested_data(57);

  /**
   * generated from messaging_system.locale
   */
  /**
   * The locale as supplied to the messaging system by
     * `Services.locale.appLocaleAsBCP47`.
   */
  constexpr impl::StringMetric locale(58);

  /**
   * generated from messaging_system.message_id
   */
  /**
   * A string identifier of the message in Activity Stream Router.
   */
  constexpr impl::TextMetric message_id(59);

  /**
   * generated from messaging_system.ping_type
   */
  /**
   * Type of event the ping is capturing. e.g. "cfr", "onboarding"
   */
  constexpr impl::StringMetric ping_type(60);

  /**
   * generated from messaging_system.source
   */
  /**
   * The source of the interaction described by the other metrics. e.g.
     * "frecent_links", "newtab", "CFR"
   */
  constexpr impl::StringMetric source(61);

  /**
   * generated from messaging_system.unknown_key_count
   */
  /**
   * The sum of all unknown keys counted.
     * Useful for testing.
     * Can be removed after bug 1600008 is resolved.
   */
  constexpr impl::CounterMetric unknown_key_count(62);

  /**
   * generated from messaging_system.unknown_keys
   */
  /**
   * Ping keys supplied to the messaging system for which
     * we did not have a corresponding metric mapped to how often they attempted
     * to be recorded.
     * You may have forgotten to define an appropriate metric in
     * `browser/components/newtab/metrics.yaml`.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> unknown_keys(63);

}
namespace messaging_system_attribution {
  /**
   * generated from messaging_system.attribution.campaign
   */
  /**
   * Attribution's campaign, possibly derived from the utm parameter of the
     * same name.
   */
  constexpr impl::StringMetric campaign(64);

  /**
   * generated from messaging_system.attribution.content
   */
  /**
   * Attribution's content, possibly derived from the utm parameter of the
     * same name.
   */
  constexpr impl::StringMetric content(65);

  /**
   * generated from messaging_system.attribution.dlsource
   */
  /**
   * Mozilla-specific download "source" name. Could be something like
     * "mozillaci" to identify that the installer came from
     * `{archive|ftp}.mozilla.org`.
   */
  constexpr impl::StringMetric dlsource(66);

  /**
   * generated from messaging_system.attribution.dltoken
   */
  /**
   * String representation of the dltoken identifying the particular
     * installer used to install this Firefox.
     * Likely a UUID, if present.
   */
  constexpr impl::StringMetric dltoken(67);

  /**
   * generated from messaging_system.attribution.experiment
   */
  /**
   * Attribution's experiment key.
   */
  constexpr impl::StringMetric experiment(68);

  /**
   * generated from messaging_system.attribution.medium
   */
  /**
   * Attribution's medium, possibly derived from the utm parameter of the same
     * name.
   */
  constexpr impl::StringMetric medium(69);

  /**
   * generated from messaging_system.attribution.msstoresignedin
   */
  /**
   * Either the string "true" or the string "false" to indicate whether the
     * attributed install came from the Microsoft store and, if so, whether the
     * user was signed in at the time.
   */
  constexpr impl::StringMetric msstoresignedin(70);

  /**
   * generated from messaging_system.attribution.source
   */
  /**
   * Attribution's source, possibly derived from the utm parameter of the same
     * name.
   */
  constexpr impl::StringMetric source(71);

  /**
   * generated from messaging_system.attribution.ua
   */
  /**
   * Attribution's ua key.
   */
  constexpr impl::StringMetric ua(72);

  /**
   * generated from messaging_system.attribution.unknown_keys
   */
  /**
   * Attribution keys supplied to the messaging system for which
     * we did not have a corresponding metric, and the count of how
     * often that happened.
     * Either add this key to a list of known attribution keys in
     * `AboutWelcomeTelemetry` to suppress or define an appropriate metric in
     * `browser/components/newtab/metrics.yaml` to collect.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> unknown_keys(73);

  /**
   * generated from messaging_system.attribution.variation
   */
  /**
   * Attribution's variation key.
   */
  constexpr impl::StringMetric variation(74);

}
namespace newtab {
  /**
   * generated from newtab.blocked_sponsors
   */
  /**
   * The advertiser names that have been dismissed by the user.
   */
  constexpr impl::StringListMetric blocked_sponsors(75);

  /**
   * generated from newtab.closed
   */
    struct ClosedExtra {
      mozilla::Maybe<nsCString> newtabVisitId;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (newtabVisitId) {
          extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
          extraValues.EmplaceBack(newtabVisitId.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when newtab UI is closed by * navigation * closing the tab
     * Doesn't mean that the newtab was ever visible to a user.
   */
  constexpr impl::EventMetric<ClosedExtra> closed(76);

  /**
   * generated from newtab.homepage_category
   */
  /**
   * The current setting of the home page. One of ["enabled", "disabled",
     * "extension"] or any value from SiteClassifier like "known-hijacker" or "social-
     * media". Similar to Activity Stream's PAGE_TAKEOVER_DATA event's
     * `home_url_category`. Sampled once after newtab init.
   */
  constexpr impl::StringMetric homepage_category(77);

  /**
   * generated from newtab.locale
   */
  /**
   * The application's locale as of when newtab's TelemetryFeed was init. Comes from
     * `Services.local.appLocaleAsBCP47`. Looks like `en-US`.
   */
  constexpr impl::StringMetric locale(78);

  /**
   * generated from newtab.newtab_category
   */
  /**
   * The current setting of the newtab page. One of ["enabled", "disabled",
     * "extension"] or any value from SiteClassifier like "known-hijacker" or "social-
     * media". Similar to Activity Stream's PAGE_TAKEOVER_DATA event's
     * `newtab_url_category`. Sampled once after newtab init.
   */
  constexpr impl::StringMetric newtab_category(79);

  /**
   * generated from newtab.opened
   */
    struct OpenedExtra {
      mozilla::Maybe<nsCString> newtabVisitId;
      mozilla::Maybe<nsCString> source;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (newtabVisitId) {
          extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
          extraValues.EmplaceBack(newtabVisitId.value());
        }
        if (source) {
          extraKeys.AppendElement()->AssignASCII("source");
          extraValues.EmplaceBack(source.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when newtab UI is opened via `about:newtab` or `about:home` or
     * `about:welcome` and has been made visible (see `visibility_event_rcvd_ts` in
     * [detect-user-session-start.js](https://searchfox.org/mozilla-
     * central/source/browser/components/newtab/content-src/lib/detect-user-session-
     * start.js)).
   */
  constexpr impl::EventMetric<OpenedExtra> opened(80);

  /**
   * generated from newtab.sov_allocation
   */
  /**
   * The partner group assignment for sov
   */
  constexpr impl::StringListMetric sov_allocation(81);

  /**
   * generated from newtab.tooltip_click
   */
    struct TooltipClickExtra {
      mozilla::Maybe<nsCString> feature;
      mozilla::Maybe<nsCString> newtabVisitId;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (feature) {
          extraKeys.AppendElement()->AssignASCII("feature");
          extraValues.EmplaceBack(feature.value());
        }
        if (newtabVisitId) {
          extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
          extraValues.EmplaceBack(newtabVisitId.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when a feature highlight tooltip is opened.
   */
  constexpr impl::EventMetric<TooltipClickExtra> tooltip_click(82);

  /**
   * generated from newtab.wallpaper_category_click
   */
    struct WallpaperCategoryClickExtra {
      mozilla::Maybe<nsCString> newtabVisitId;
      mozilla::Maybe<nsCString> selectedCategory;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (newtabVisitId) {
          extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
          extraValues.EmplaceBack(newtabVisitId.value());
        }
        if (selectedCategory) {
          extraKeys.AppendElement()->AssignASCII("selected_category");
          extraValues.EmplaceBack(selectedCategory.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when a user clicks a wallpaper category option
   */
  constexpr impl::EventMetric<WallpaperCategoryClickExtra> wallpaper_category_click(83);

  /**
   * generated from newtab.wallpaper_click
   */
    struct WallpaperClickExtra {
      mozilla::Maybe<bool> hadPreviousWallpaper;
      mozilla::Maybe<nsCString> newtabVisitId;
      mozilla::Maybe<nsCString> selectedWallpaper;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (hadPreviousWallpaper) {
          extraKeys.AppendElement()->AssignASCII("had_previous_wallpaper");
          extraValues.AppendElement()->AssignASCII(hadPreviousWallpaper.value() ? "true" : "false");
        }
        if (newtabVisitId) {
          extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
          extraValues.EmplaceBack(newtabVisitId.value());
        }
        if (selectedWallpaper) {
          extraKeys.AppendElement()->AssignASCII("selected_wallpaper");
          extraValues.EmplaceBack(selectedWallpaper.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when a user clicks on a wallpaper option
   */
  constexpr impl::EventMetric<WallpaperClickExtra> wallpaper_click(84);

  /**
   * generated from newtab.wallpaper_highlight_cta_click
   */
    struct WallpaperHighlightCtaClickExtra {
      mozilla::Maybe<nsCString> newtabVisitId;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (newtabVisitId) {
          extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
          extraValues.EmplaceBack(newtabVisitId.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when a user clicks the CTA on the wallpaper feature highlight
   */
  constexpr impl::EventMetric<WallpaperHighlightCtaClickExtra> wallpaper_highlight_cta_click(85);

  /**
   * generated from newtab.wallpaper_highlight_dismissed
   */
    struct WallpaperHighlightDismissedExtra {
      mozilla::Maybe<nsCString> newtabVisitId;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (newtabVisitId) {
          extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
          extraValues.EmplaceBack(newtabVisitId.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when a user dismisses the wallpaper feature highlight
   */
  constexpr impl::EventMetric<WallpaperHighlightDismissedExtra> wallpaper_highlight_dismissed(86);

  /**
   * generated from newtab.weather_change_display
   */
    struct WeatherChangeDisplayExtra {
      mozilla::Maybe<nsCString> newtabVisitId;
      mozilla::Maybe<nsCString> weatherDisplayMode;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (newtabVisitId) {
          extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
          extraValues.EmplaceBack(newtabVisitId.value());
        }
        if (weatherDisplayMode) {
          extraKeys.AppendElement()->AssignASCII("weather_display_mode");
          extraValues.EmplaceBack(weatherDisplayMode.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when a user changes the weather display.
   */
  constexpr impl::EventMetric<WeatherChangeDisplayExtra> weather_change_display(87);

  /**
   * generated from newtab.weather_enabled
   */
  /**
   * Whether the weather widget is enabled on the newtab. Corresponds to the value
     * of the `browser.newtabpage.activity-stream.showWeather` pref.
   */
  constexpr impl::BooleanMetric weather_enabled(88);

  /**
   * generated from newtab.weather_impression
   */
    struct WeatherImpressionExtra {
      mozilla::Maybe<nsCString> newtabVisitId;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (newtabVisitId) {
          extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
          extraValues.EmplaceBack(newtabVisitId.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when the weather widget is viewed
   */
  constexpr impl::EventMetric<WeatherImpressionExtra> weather_impression(89);

  /**
   * generated from newtab.weather_load_error
   */
    struct WeatherLoadErrorExtra {
      mozilla::Maybe<nsCString> newtabVisitId;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (newtabVisitId) {
          extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
          extraValues.EmplaceBack(newtabVisitId.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when the weather widget is not available
   */
  constexpr impl::EventMetric<WeatherLoadErrorExtra> weather_load_error(90);

  /**
   * generated from newtab.weather_location_selected
   */
    struct WeatherLocationSelectedExtra {
      mozilla::Maybe<nsCString> newtabVisitId;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (newtabVisitId) {
          extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
          extraValues.EmplaceBack(newtabVisitId.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when a user selects a location for weather widget
   */
  constexpr impl::EventMetric<WeatherLocationSelectedExtra> weather_location_selected(91);

  /**
   * generated from newtab.weather_open_provider_url
   */
    struct WeatherOpenProviderUrlExtra {
      mozilla::Maybe<nsCString> newtabVisitId;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (newtabVisitId) {
          extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
          extraValues.EmplaceBack(newtabVisitId.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when a user opens a link to the Weather provider website.
   */
  constexpr impl::EventMetric<WeatherOpenProviderUrlExtra> weather_open_provider_url(92);

}
namespace newtab_handoff_preference {
  /**
   * generated from newtab.handoff_preference.enabled
   */
  /**
   * Records whether the browser.newtabpage.activity-
     * stream.improvesearch.handoffToAwesomebar preference is enabled or disabled
   */
  constexpr impl::BooleanMetric enabled(93);

}
namespace newtab_search {
  /**
   * generated from newtab.search.enabled
   */
  /**
   * Whether the search input is enabled on the newtab. Corresponds to the value of
     * the `browser.newtabpage.activity-stream.showSearch` pref.
   */
  constexpr impl::BooleanMetric enabled(94);

  /**
   * generated from newtab.search.issued
   */
    struct IssuedExtra {
      mozilla::Maybe<nsCString> newtabVisitId;
      mozilla::Maybe<nsCString> searchAccessPoint;
      mozilla::Maybe<nsCString> telemetryId;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (newtabVisitId) {
          extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
          extraValues.EmplaceBack(newtabVisitId.value());
        }
        if (searchAccessPoint) {
          extraKeys.AppendElement()->AssignASCII("search_access_point");
          extraValues.EmplaceBack(searchAccessPoint.value());
        }
        if (telemetryId) {
          extraKeys.AppendElement()->AssignASCII("telemetry_id");
          extraValues.EmplaceBack(telemetryId.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * When Firefox was asked to issue a search from a Search Access Point (SAP) on a
     * newtab page. Doesn't record searches in Private Browsing Mode unless
     * `browser.engagement.search_counts.pbm` is set to `true`.
   */
  constexpr impl::EventMetric<IssuedExtra> issued(95);

}
namespace pocket {
  /**
   * generated from pocket.click
   */
    struct ClickExtra {
      mozilla::Maybe<bool> isSponsored;
      mozilla::Maybe<nsCString> newtabVisitId;
      mozilla::Maybe<uint32_t> position;
      mozilla::Maybe<nsCString> recommendationId;
      mozilla::Maybe<uint32_t> tileId;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (isSponsored) {
          extraKeys.AppendElement()->AssignASCII("is_sponsored");
          extraValues.AppendElement()->AssignASCII(isSponsored.value() ? "true" : "false");
        }
        if (newtabVisitId) {
          extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
          extraValues.EmplaceBack(newtabVisitId.value());
        }
        if (position) {
          extraKeys.AppendElement()->AssignASCII("position");
          extraValues.EmplaceBack(nsPrintfCString("%d", position.value()));
        }
        if (recommendationId) {
          extraKeys.AppendElement()->AssignASCII("recommendation_id");
          extraValues.EmplaceBack(recommendationId.value());
        }
        if (tileId) {
          extraKeys.AppendElement()->AssignASCII("tile_id");
          extraValues.EmplaceBack(nsPrintfCString("%d", tileId.value()));
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when a pocket tile is clicked. Only happens on click. Not on middle-
     * click. Not on "Open in new Tab"-like options in the context menu.
   */
  constexpr impl::EventMetric<ClickExtra> click(96);

  /**
   * generated from pocket.enabled
   */
  /**
   * Whether Pocket is enabled on the newtab. AKA the "Recommended by Pocket"
     * section. Corresponds to the value of the `browser.newtabpage.activity-
     * stream.feeds.section.topstories` pref.
   */
  constexpr impl::BooleanMetric enabled(97);

  /**
   * generated from pocket.fetch_timestamp
   */
  /**
   * Timestamp of when the spoc was fetched by the client
   */
  constexpr impl::DatetimeMetric fetch_timestamp(98);

  /**
   * generated from pocket.impression
   */
    struct ImpressionExtra {
      mozilla::Maybe<bool> isSponsored;
      mozilla::Maybe<nsCString> newtabVisitId;
      mozilla::Maybe<uint32_t> position;
      mozilla::Maybe<nsCString> recommendationId;
      mozilla::Maybe<uint32_t> tileId;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (isSponsored) {
          extraKeys.AppendElement()->AssignASCII("is_sponsored");
          extraValues.AppendElement()->AssignASCII(isSponsored.value() ? "true" : "false");
        }
        if (newtabVisitId) {
          extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
          extraValues.EmplaceBack(newtabVisitId.value());
        }
        if (position) {
          extraKeys.AppendElement()->AssignASCII("position");
          extraValues.EmplaceBack(nsPrintfCString("%d", position.value()));
        }
        if (recommendationId) {
          extraKeys.AppendElement()->AssignASCII("recommendation_id");
          extraValues.EmplaceBack(recommendationId.value());
        }
        if (tileId) {
          extraKeys.AppendElement()->AssignASCII("tile_id");
          extraValues.EmplaceBack(nsPrintfCString("%d", tileId.value()));
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when a pocket tile is visible to the user.
   */
  constexpr impl::EventMetric<ImpressionExtra> impression(99);

  /**
   * generated from pocket.is_signed_in
   */
  /**
   * Whether the Firefox user is signed in to Pocket. Does not correspond to a pref,
     * so its value is resampled at newtab's component init and whenever there is a
     * Discovery Stream user event.
   */
  constexpr impl::BooleanMetric is_signed_in(100);

  /**
   * generated from pocket.newtab_creation_timestamp
   */
  /**
   * Timestamp of when this instance of the newtab was first visible to the user.
   */
  constexpr impl::DatetimeMetric newtab_creation_timestamp(101);

  /**
   * generated from pocket.save
   */
    struct SaveExtra {
      mozilla::Maybe<bool> isSponsored;
      mozilla::Maybe<nsCString> newtabVisitId;
      mozilla::Maybe<uint32_t> position;
      mozilla::Maybe<nsCString> recommendationId;
      mozilla::Maybe<uint32_t> tileId;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (isSponsored) {
          extraKeys.AppendElement()->AssignASCII("is_sponsored");
          extraValues.AppendElement()->AssignASCII(isSponsored.value() ? "true" : "false");
        }
        if (newtabVisitId) {
          extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
          extraValues.EmplaceBack(newtabVisitId.value());
        }
        if (position) {
          extraKeys.AppendElement()->AssignASCII("position");
          extraValues.EmplaceBack(nsPrintfCString("%d", position.value()));
        }
        if (recommendationId) {
          extraKeys.AppendElement()->AssignASCII("recommendation_id");
          extraValues.EmplaceBack(recommendationId.value());
        }
        if (tileId) {
          extraKeys.AppendElement()->AssignASCII("tile_id");
          extraValues.EmplaceBack(nsPrintfCString("%d", tileId.value()));
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when a user decides to save a pocket tile. Does not mean it ends up
     * successfully saved. Just that the user clicked on "Save to Pocket" in the
     * little pocket tile menu.
   */
  constexpr impl::EventMetric<SaveExtra> save(102);

  /**
   * generated from pocket.shim
   */
  /**
   * Opaque partner identifier for a given ad impression or engagement action,
     * unique per market and region.
     * Pocket
     * [proxies requests to ad partners](https://github.com/Pocket/proxy-server/)
     * and provides them solely with market, region, and action to generate these
     * shims. Thus, though the contents of this field are obscure, they cannot
     * identify clients.
     * At time of writing this information is a comma-separated trio.
     * The first item is an index into the proxy server's list of acceptable http
     * endpoints for contacting the ad service. The second item is a
     * several-hundred-byte base64-encoded JSON-encoded struct with fields for,
     * amongst other things, market and region. The third is unknown, but appears
     * to be a signature or checksum.
     * This shim should not be sent with the client_id.
   */
  constexpr impl::TextMetric shim(103);

  /**
   * generated from pocket.sponsored_stories_enabled
   */
  /**
   * Whether Pocket sponsored stories are enabled on the newtab. Corresponds to the
     * value of the `browser.newtabpage.activity-stream.showSponsored` pref. Can be
     * `true` even if pocket.enabled is `false`.
   */
  constexpr impl::BooleanMetric sponsored_stories_enabled(104);

  /**
   * generated from pocket.topic_click
   */
    struct TopicClickExtra {
      mozilla::Maybe<nsCString> newtabVisitId;
      mozilla::Maybe<nsCString> topic;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (newtabVisitId) {
          extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
          extraValues.EmplaceBack(newtabVisitId.value());
        }
        if (topic) {
          extraKeys.AppendElement()->AssignASCII("topic");
          extraValues.EmplaceBack(topic.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when a pocket "Popular Topic" is clicked. Only happens on click. Not
     * on middle-click. Not on "Open in new Tab"-like options in the context menu.
   */
  constexpr impl::EventMetric<TopicClickExtra> topic_click(105);

}
namespace top_sites {
  /**
   * generated from top_sites.advertiser
   */
  /**
   * The name of the advertiser providing the sponsored TopSite.
   */
  constexpr impl::StringMetric advertiser(106);

  /**
   * generated from top_sites.context_id
   */
  /**
   * An identifier to identify users for Contextual Services user interaction pings.
   */
  constexpr impl::UuidMetric context_id(107);

  /**
   * generated from top_sites.ping_type
   */
  /**
   * The ping's type. In other situations might be designated by an event's name or
     * an interaction field. E.g. "topsites-impression", "topsites-click".
   */
  constexpr impl::StringMetric ping_type(108);

  /**
   * generated from top_sites.position
   */
  /**
   * The position (1-based) of the topsites item being interatcted with.
   */
  constexpr impl::QuantityMetric position(109);

  /**
   * generated from top_sites.reporting_url
   */
  /**
   * The url to report this interaction to.
   */
  constexpr impl::UrlMetric reporting_url(110);

  /**
   * generated from top_sites.source
   */
  /**
   * The source of the interaction. Always set to "newtab".
   */
  constexpr impl::StringMetric source(111);

  /**
   * generated from top_sites.tile_id
   */
  /**
   * String-encoded number for the tile's sponsored tile id.
   */
  constexpr impl::StringMetric tile_id(112);

}
namespace topsites {
  /**
   * generated from topsites.click
   */
    struct ClickExtra {
      mozilla::Maybe<nsCString> advertiserName;
      mozilla::Maybe<bool> isSponsored;
      mozilla::Maybe<nsCString> newtabVisitId;
      mozilla::Maybe<uint32_t> position;
      mozilla::Maybe<uint32_t> tileId;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (advertiserName) {
          extraKeys.AppendElement()->AssignASCII("advertiser_name");
          extraValues.EmplaceBack(advertiserName.value());
        }
        if (isSponsored) {
          extraKeys.AppendElement()->AssignASCII("is_sponsored");
          extraValues.AppendElement()->AssignASCII(isSponsored.value() ? "true" : "false");
        }
        if (newtabVisitId) {
          extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
          extraValues.EmplaceBack(newtabVisitId.value());
        }
        if (position) {
          extraKeys.AppendElement()->AssignASCII("position");
          extraValues.EmplaceBack(nsPrintfCString("%d", position.value()));
        }
        if (tileId) {
          extraKeys.AppendElement()->AssignASCII("tile_id");
          extraValues.EmplaceBack(nsPrintfCString("%d", tileId.value()));
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when a topsite tile is clicked. Only happens on click. Not on middle-
     * click. Not on "Open in new Tab"-like options in the context menu.
   */
  constexpr impl::EventMetric<ClickExtra> click(113);

  /**
   * generated from topsites.dismiss
   */
    struct DismissExtra {
      mozilla::Maybe<nsCString> advertiserName;
      mozilla::Maybe<bool> isSponsored;
      mozilla::Maybe<nsCString> newtabVisitId;
      mozilla::Maybe<uint32_t> position;
      mozilla::Maybe<uint32_t> tileId;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (advertiserName) {
          extraKeys.AppendElement()->AssignASCII("advertiser_name");
          extraValues.EmplaceBack(advertiserName.value());
        }
        if (isSponsored) {
          extraKeys.AppendElement()->AssignASCII("is_sponsored");
          extraValues.AppendElement()->AssignASCII(isSponsored.value() ? "true" : "false");
        }
        if (newtabVisitId) {
          extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
          extraValues.EmplaceBack(newtabVisitId.value());
        }
        if (position) {
          extraKeys.AppendElement()->AssignASCII("position");
          extraValues.EmplaceBack(nsPrintfCString("%d", position.value()));
        }
        if (tileId) {
          extraKeys.AppendElement()->AssignASCII("tile_id");
          extraValues.EmplaceBack(nsPrintfCString("%d", tileId.value()));
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when the "Dismiss" menu item in the three-dots menu of a topsite is
     * clicked. Corresponds to the receipt of a dispatched `BLOCK_URL` action by
     * `TelemetryFeed`. Applies to both sponsored and non-sponsored topsites.
     * `advertiser_name` is only provided for sponsored topsites.
   */
  constexpr impl::EventMetric<DismissExtra> dismiss(114);

  /**
   * generated from topsites.enabled
   */
  /**
   * Whether "topsites" is enabled on the newtab. AKA the "Shortcuts" section.
     * Corresponds to the value of the `browser.newtabpage.activity-
     * stream.feeds.topsites` pref.
   */
  constexpr impl::BooleanMetric enabled(115);

  /**
   * generated from topsites.impression
   */
    struct ImpressionExtra {
      mozilla::Maybe<nsCString> advertiserName;
      mozilla::Maybe<bool> isSponsored;
      mozilla::Maybe<nsCString> newtabVisitId;
      mozilla::Maybe<uint32_t> position;
      mozilla::Maybe<uint32_t> tileId;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (advertiserName) {
          extraKeys.AppendElement()->AssignASCII("advertiser_name");
          extraValues.EmplaceBack(advertiserName.value());
        }
        if (isSponsored) {
          extraKeys.AppendElement()->AssignASCII("is_sponsored");
          extraValues.AppendElement()->AssignASCII(isSponsored.value() ? "true" : "false");
        }
        if (newtabVisitId) {
          extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
          extraValues.EmplaceBack(newtabVisitId.value());
        }
        if (position) {
          extraKeys.AppendElement()->AssignASCII("position");
          extraValues.EmplaceBack(nsPrintfCString("%d", position.value()));
        }
        if (tileId) {
          extraKeys.AppendElement()->AssignASCII("tile_id");
          extraValues.EmplaceBack(nsPrintfCString("%d", tileId.value()));
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when topsite tiles are loaded.
   */
  constexpr impl::EventMetric<ImpressionExtra> impression(116);

  /**
   * generated from topsites.pref_changed
   */
    struct PrefChangedExtra {
      mozilla::Maybe<bool> newValue;
      mozilla::Maybe<nsCString> prefName;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (newValue) {
          extraKeys.AppendElement()->AssignASCII("new_value");
          extraValues.AppendElement()->AssignASCII(newValue.value() ? "true" : "false");
        }
        if (prefName) {
          extraKeys.AppendElement()->AssignASCII("pref_name");
          extraValues.EmplaceBack(prefName.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when specific topsites prefs have changed.
     * The list of possible prefs is presently:
     *  * browser.newtabpage.activity-stream.feeds.topsites
     *  * browser.newtabpage.activity-stream.showSponsoredTopSites
   */
  constexpr impl::EventMetric<PrefChangedExtra> pref_changed(117);

  /**
   * generated from topsites.rows
   */
  /**
   * The number of topsite tile rows configured to be shown on the newtab page.
     * Corresponds to the value of the `browser.newtabpage.activity-
     * stream.topSitesRows` pref. This is not the number of rows actually seen by the
     * user: if the browser window is partially off-screen, or isn't wide enough to
     * accommodate eight tiles per row, the actual number of rows may be different.
   */
  constexpr impl::QuantityMetric rows(118);

  /**
   * generated from topsites.show_privacy_click
   */
    struct ShowPrivacyClickExtra {
      mozilla::Maybe<nsCString> advertiserName;
      mozilla::Maybe<nsCString> newtabVisitId;
      mozilla::Maybe<uint32_t> position;
      mozilla::Maybe<uint32_t> tileId;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (advertiserName) {
          extraKeys.AppendElement()->AssignASCII("advertiser_name");
          extraValues.EmplaceBack(advertiserName.value());
        }
        if (newtabVisitId) {
          extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
          extraValues.EmplaceBack(newtabVisitId.value());
        }
        if (position) {
          extraKeys.AppendElement()->AssignASCII("position");
          extraValues.EmplaceBack(nsPrintfCString("%d", position.value()));
        }
        if (tileId) {
          extraKeys.AppendElement()->AssignASCII("tile_id");
          extraValues.EmplaceBack(nsPrintfCString("%d", tileId.value()));
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when the "Our Sponsors and Your Privacy" menu item in the three- dots
     * menu of a sponsored topsite is clicked. Corresponds to the receipt of a
     * dispatched `ABOUT_SPONSORED_TOP_SITES` action by `TelemetryFeed`.
   */
  constexpr impl::EventMetric<ShowPrivacyClickExtra> show_privacy_click(119);

  /**
   * generated from topsites.sponsored_enabled
   */
  /**
   * Whether sponsored topsites are enabled on the newtab. AKA the "Sponsored
     * Shortcuts" section. Corresponds to the value of the
     * `browser.newtabpage.activity-stream.showSponsoredTopSites` pref. Can be `true`
     * even if topsites.enabled is `false`.
   */
  constexpr impl::BooleanMetric sponsored_enabled(120);

  /**
   * generated from topsites.sponsored_tiles_configured
   */
  /**
   * The number of topsite tiles configured to be shown on newtab.
   */
  constexpr impl::QuantityMetric sponsored_tiles_configured(121);

  /**
   * generated from topsites.sponsored_tiles_received
   */
  /**
   * The stringified JSON of tiles processed for display (array of objects).
     * Includes tiles not displayed and reason for not displaying. Fields included:
     * advertiser, provider, display_position, display_fail_reason.
   */
  constexpr impl::TextMetric sponsored_tiles_received(122);

}
namespace pocket_button {
  /**
   * generated from pocket.button.event_action
   */
  /**
   * The action that was taken, like "click" or... actually, it might only ever be
     * "click".
   */
  constexpr impl::StringMetric event_action(123);

  /**
   * generated from pocket.button.event_position
   */
  /**
   * 0-based index of the item on which the action was performed. Not always
     * provided.
   */
  constexpr impl::QuantityMetric event_position(124);

  /**
   * generated from pocket.button.event_source
   */
  /**
   * The source of the taken action, like "save_button", "home_button",
     * "on_save_recs", or the like.
   */
  constexpr impl::StringMetric event_source(125);

  /**
   * generated from pocket.button.impression_id
   */
  /**
   * A UUID representing this profile. This isn't client_id, nor can it be used to
     * link to a client_id. This also means it should never be sent in a ping with a
     * client_id.
   */
  constexpr impl::UuidMetric impression_id(126);

  /**
   * generated from pocket.button.model
   */
  /**
   * A string that identifies the ML model (if any) used to generate on-save
     * recommendations. Like "doc2vec-incremental-best-article-pubspread".
   */
  constexpr impl::StringMetric model(127);

  /**
   * generated from pocket.button.pocket_logged_in_status
   */
  /**
   * Whether there was a logged-in Pocket account in the Pocket-Firefox integration
     * at the point in time this action occurred.
   */
  constexpr impl::BooleanMetric pocket_logged_in_status(128);

  /**
   * generated from pocket.button.profile_creation_date
   */
  /**
   * The days since Jan 1, 1970 that the oldest file in the profile dir was
     * modified. Or created. Or just the day and time of the first thing to ask for
     * the profile age called in. Or something earlier or later than that.
     * You may not want to use this.
   */
  constexpr impl::QuantityMetric profile_creation_date(129);

}
namespace privacy_ui_fpp_click {
  /**
   * generated from privacy.ui.fpp.click.checkbox
   */
    struct CheckboxExtra {
      mozilla::Maybe<bool> checked;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (checked) {
          extraKeys.AppendElement()->AssignASCII("checked");
          extraValues.AppendElement()->AssignASCII(checked.value() ? "true" : "false");
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * User interaction by click events on fingerprinting protection checkbox in the
     * ETP Custom subpanel.
   */
  constexpr impl::EventMetric<CheckboxExtra> checkbox(130);

  /**
   * generated from privacy.ui.fpp.click.menu
   */
    struct MenuExtra {
      mozilla::Maybe<nsCString> value;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (value) {
          extraKeys.AppendElement()->AssignASCII("value");
          extraValues.EmplaceBack(value.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * User interaction by click events on fingerprinting protection menulist in the
     * ETP Custom subpanel.
   */
  constexpr impl::EventMetric<MenuExtra> menu(131);

}
namespace private_browsing_reset_pbm {
  /**
   * generated from private_browsing.reset_pbm.confirm_panel
   */
    struct ConfirmPanelExtra {
      mozilla::Maybe<nsCString> action;
      mozilla::Maybe<nsCString> reason;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (action) {
          extraKeys.AppendElement()->AssignASCII("action");
          extraValues.EmplaceBack(action.value());
        }
        if (reason) {
          extraKeys.AppendElement()->AssignASCII("reason");
          extraValues.EmplaceBack(reason.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Confirm panel show / hide event.
   */
  constexpr impl::EventMetric<ConfirmPanelExtra> confirm_panel(132);

  /**
   * generated from private_browsing.reset_pbm.reset_action
   */
    struct ResetActionExtra {
      mozilla::Maybe<bool> didConfirm;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (didConfirm) {
          extraKeys.AppendElement()->AssignASCII("did_confirm");
          extraValues.AppendElement()->AssignASCII(didConfirm.value() ? "true" : "false");
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Dispatched whenever PBM is restarted / reset via the resetPBM feature.
   */
  constexpr impl::EventMetric<ResetActionExtra> reset_action(133);

}
namespace protocolhandler_mailto {
  /**
   * generated from protocolhandler.mailto.handler_prompt_shown
   */
  enum class HandlerPromptShownLabel: uint16_t {
      eOsDefault = 0,
      eFxDefault = 1,
      e__Other__,
    };
  /**
   * A website was visited, which called registerProtocolHandler for mailto://
   */
  constexpr impl::Labeled<impl::CounterMetric, HandlerPromptShownLabel> handler_prompt_shown(134);

  /**
   * generated from protocolhandler.mailto.prompt_clicked
   */
  enum class PromptClickedLabel: uint16_t {
      eSetOsDefault = 0,
      eSetOsDefaultError = 1,
      eSetOsDefaultImpossible = 2,
      eDismissOsDefault = 3,
      eSetLocalDefault = 4,
      eDismissLocalDefault = 5,
      e__Other__,
    };
  /**
   * User clicked on a button to approve setting the current site as default web
     * mail site. The sum of all counters is the total amount of user interactions and
     * dismissing the same dialog often could be a sign of a bug.
   */
  constexpr impl::Labeled<impl::CounterMetric, PromptClickedLabel> prompt_clicked(135);

  /**
   * generated from protocolhandler.mailto.visit
   */
    struct VisitExtra {
      mozilla::Maybe<bool> triggeredExternally;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (triggeredExternally) {
          extraKeys.AppendElement()->AssignASCII("triggered_externally");
          extraValues.AppendElement()->AssignASCII(triggeredExternally.value() ? "true" : "false");
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * a URI of type mailto was visited. Furthermore we want to know if from within
     * the browser.
   */
  constexpr impl::EventMetric<VisitExtra> visit(136);

}
namespace newtab_search_ad {
  /**
   * generated from newtab.search.ad.click
   */
    struct ClickExtra {
      mozilla::Maybe<bool> isFollowOn;
      mozilla::Maybe<bool> isTagged;
      mozilla::Maybe<nsCString> newtabVisitId;
      mozilla::Maybe<nsCString> searchAccessPoint;
      mozilla::Maybe<nsCString> telemetryId;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (isFollowOn) {
          extraKeys.AppendElement()->AssignASCII("is_follow_on");
          extraValues.AppendElement()->AssignASCII(isFollowOn.value() ? "true" : "false");
        }
        if (isTagged) {
          extraKeys.AppendElement()->AssignASCII("is_tagged");
          extraValues.AppendElement()->AssignASCII(isTagged.value() ? "true" : "false");
        }
        if (newtabVisitId) {
          extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
          extraValues.EmplaceBack(newtabVisitId.value());
        }
        if (searchAccessPoint) {
          extraKeys.AppendElement()->AssignASCII("search_access_point");
          extraValues.EmplaceBack(searchAccessPoint.value());
        }
        if (telemetryId) {
          extraKeys.AppendElement()->AssignASCII("telemetry_id");
          extraValues.EmplaceBack(telemetryId.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when an ad link is clicked on a Search Engine Result Page (SERP) which
     * was loaded by a seach that began on a newtab page.
   */
  constexpr impl::EventMetric<ClickExtra> click(137);

  /**
   * generated from newtab.search.ad.impression
   */
    struct ImpressionExtra {
      mozilla::Maybe<bool> isFollowOn;
      mozilla::Maybe<bool> isTagged;
      mozilla::Maybe<nsCString> newtabVisitId;
      mozilla::Maybe<nsCString> searchAccessPoint;
      mozilla::Maybe<nsCString> telemetryId;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (isFollowOn) {
          extraKeys.AppendElement()->AssignASCII("is_follow_on");
          extraValues.AppendElement()->AssignASCII(isFollowOn.value() ? "true" : "false");
        }
        if (isTagged) {
          extraKeys.AppendElement()->AssignASCII("is_tagged");
          extraValues.AppendElement()->AssignASCII(isTagged.value() ? "true" : "false");
        }
        if (newtabVisitId) {
          extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
          extraValues.EmplaceBack(newtabVisitId.value());
        }
        if (searchAccessPoint) {
          extraKeys.AppendElement()->AssignASCII("search_access_point");
          extraValues.EmplaceBack(searchAccessPoint.value());
        }
        if (telemetryId) {
          extraKeys.AppendElement()->AssignASCII("telemetry_id");
          extraValues.EmplaceBack(telemetryId.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when a newtab visit resulted in a search that loaded a Search Engine
     * Result Page (SERP) that contains an ad link. And the SERP is visible.
   */
  constexpr impl::EventMetric<ImpressionExtra> impression(138);

}
namespace search_with {
  /**
   * generated from search_with.context_id
   */
  /**
   * An identifier for Contextual Services user interaction pings. This is used
     * internally for counting unique users as well as for anti-fraud. It is shared
     * with other Contextual Services. It is not shared externally.
   */
  constexpr impl::UuidMetric context_id(139);

  /**
   * generated from search_with.reporting_url
   */
  /**
   * The external url to report this interaction to.
   */
  constexpr impl::UrlMetric reporting_url(140);

}
namespace serp {
  /**
   * generated from serp.abandonment
   */
    struct AbandonmentExtra {
      mozilla::Maybe<nsCString> impressionId;
      mozilla::Maybe<nsCString> reason;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (impressionId) {
          extraKeys.AppendElement()->AssignASCII("impression_id");
          extraValues.EmplaceBack(impressionId.value());
        }
        if (reason) {
          extraKeys.AppendElement()->AssignASCII("reason");
          extraValues.EmplaceBack(reason.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when there is no engagement with the SERP before the tab is closed,
     * the window is closed, the app is closed, or the tab is navigated away from.
   */
  constexpr impl::EventMetric<AbandonmentExtra> abandonment(141);

  /**
   * generated from serp.ad_impression
   */
    struct AdImpressionExtra {
      mozilla::Maybe<uint32_t> adsHidden;
      mozilla::Maybe<uint32_t> adsLoaded;
      mozilla::Maybe<uint32_t> adsVisible;
      mozilla::Maybe<nsCString> component;
      mozilla::Maybe<nsCString> impressionId;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (adsHidden) {
          extraKeys.AppendElement()->AssignASCII("ads_hidden");
          extraValues.EmplaceBack(nsPrintfCString("%d", adsHidden.value()));
        }
        if (adsLoaded) {
          extraKeys.AppendElement()->AssignASCII("ads_loaded");
          extraValues.EmplaceBack(nsPrintfCString("%d", adsLoaded.value()));
        }
        if (adsVisible) {
          extraKeys.AppendElement()->AssignASCII("ads_visible");
          extraValues.EmplaceBack(nsPrintfCString("%d", adsVisible.value()));
        }
        if (component) {
          extraKeys.AppendElement()->AssignASCII("component");
          extraValues.EmplaceBack(component.value());
        }
        if (impressionId) {
          extraKeys.AppendElement()->AssignASCII("impression_id");
          extraValues.EmplaceBack(impressionId.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when a user loads a SERP and ads are detected.
   */
  constexpr impl::EventMetric<AdImpressionExtra> ad_impression(142);

  /**
   * generated from serp.categorization
   */
    struct CategorizationExtra {
      mozilla::Maybe<uint32_t> appVersion;
      mozilla::Maybe<nsCString> channel;
      mozilla::Maybe<bool> isShoppingPage;
      mozilla::Maybe<uint32_t> mappingsVersion;
      mozilla::Maybe<uint32_t> numAdsClicked;
      mozilla::Maybe<uint32_t> numAdsHidden;
      mozilla::Maybe<uint32_t> numAdsLoaded;
      mozilla::Maybe<uint32_t> numAdsVisible;
      mozilla::Maybe<uint32_t> organicCategory;
      mozilla::Maybe<uint32_t> organicNumDomains;
      mozilla::Maybe<uint32_t> organicNumInconclusive;
      mozilla::Maybe<uint32_t> organicNumUnknown;
      mozilla::Maybe<nsCString> partnerCode;
      mozilla::Maybe<nsCString> provider;
      mozilla::Maybe<nsCString> region;
      mozilla::Maybe<uint32_t> sponsoredCategory;
      mozilla::Maybe<uint32_t> sponsoredNumDomains;
      mozilla::Maybe<uint32_t> sponsoredNumInconclusive;
      mozilla::Maybe<uint32_t> sponsoredNumUnknown;
      mozilla::Maybe<bool> tagged;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (appVersion) {
          extraKeys.AppendElement()->AssignASCII("app_version");
          extraValues.EmplaceBack(nsPrintfCString("%d", appVersion.value()));
        }
        if (channel) {
          extraKeys.AppendElement()->AssignASCII("channel");
          extraValues.EmplaceBack(channel.value());
        }
        if (isShoppingPage) {
          extraKeys.AppendElement()->AssignASCII("is_shopping_page");
          extraValues.AppendElement()->AssignASCII(isShoppingPage.value() ? "true" : "false");
        }
        if (mappingsVersion) {
          extraKeys.AppendElement()->AssignASCII("mappings_version");
          extraValues.EmplaceBack(nsPrintfCString("%d", mappingsVersion.value()));
        }
        if (numAdsClicked) {
          extraKeys.AppendElement()->AssignASCII("num_ads_clicked");
          extraValues.EmplaceBack(nsPrintfCString("%d", numAdsClicked.value()));
        }
        if (numAdsHidden) {
          extraKeys.AppendElement()->AssignASCII("num_ads_hidden");
          extraValues.EmplaceBack(nsPrintfCString("%d", numAdsHidden.value()));
        }
        if (numAdsLoaded) {
          extraKeys.AppendElement()->AssignASCII("num_ads_loaded");
          extraValues.EmplaceBack(nsPrintfCString("%d", numAdsLoaded.value()));
        }
        if (numAdsVisible) {
          extraKeys.AppendElement()->AssignASCII("num_ads_visible");
          extraValues.EmplaceBack(nsPrintfCString("%d", numAdsVisible.value()));
        }
        if (organicCategory) {
          extraKeys.AppendElement()->AssignASCII("organic_category");
          extraValues.EmplaceBack(nsPrintfCString("%d", organicCategory.value()));
        }
        if (organicNumDomains) {
          extraKeys.AppendElement()->AssignASCII("organic_num_domains");
          extraValues.EmplaceBack(nsPrintfCString("%d", organicNumDomains.value()));
        }
        if (organicNumInconclusive) {
          extraKeys.AppendElement()->AssignASCII("organic_num_inconclusive");
          extraValues.EmplaceBack(nsPrintfCString("%d", organicNumInconclusive.value()));
        }
        if (organicNumUnknown) {
          extraKeys.AppendElement()->AssignASCII("organic_num_unknown");
          extraValues.EmplaceBack(nsPrintfCString("%d", organicNumUnknown.value()));
        }
        if (partnerCode) {
          extraKeys.AppendElement()->AssignASCII("partner_code");
          extraValues.EmplaceBack(partnerCode.value());
        }
        if (provider) {
          extraKeys.AppendElement()->AssignASCII("provider");
          extraValues.EmplaceBack(provider.value());
        }
        if (region) {
          extraKeys.AppendElement()->AssignASCII("region");
          extraValues.EmplaceBack(region.value());
        }
        if (sponsoredCategory) {
          extraKeys.AppendElement()->AssignASCII("sponsored_category");
          extraValues.EmplaceBack(nsPrintfCString("%d", sponsoredCategory.value()));
        }
        if (sponsoredNumDomains) {
          extraKeys.AppendElement()->AssignASCII("sponsored_num_domains");
          extraValues.EmplaceBack(nsPrintfCString("%d", sponsoredNumDomains.value()));
        }
        if (sponsoredNumInconclusive) {
          extraKeys.AppendElement()->AssignASCII("sponsored_num_inconclusive");
          extraValues.EmplaceBack(nsPrintfCString("%d", sponsoredNumInconclusive.value()));
        }
        if (sponsoredNumUnknown) {
          extraKeys.AppendElement()->AssignASCII("sponsored_num_unknown");
          extraValues.EmplaceBack(nsPrintfCString("%d", sponsoredNumUnknown.value()));
        }
        if (tagged) {
          extraKeys.AppendElement()->AssignASCII("tagged");
          extraValues.AppendElement()->AssignASCII(tagged.value() ? "true" : "false");
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * A high-level categorization of a SERP (a best guess as to its topic), using
     * buckets such as "sports" or "travel".
   */
  constexpr impl::EventMetric<CategorizationExtra> categorization(143);

  /**
   * generated from serp.categorization_duration
   */
  /**
   * The time it takes to categorize elements on a SERP.
   */
  constexpr impl::TimingDistributionMetric categorization_duration(144);

  /**
   * generated from serp.engagement
   */
    struct EngagementExtra {
      mozilla::Maybe<nsCString> action;
      mozilla::Maybe<nsCString> impressionId;
      mozilla::Maybe<nsCString> target;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (action) {
          extraKeys.AppendElement()->AssignASCII("action");
          extraValues.EmplaceBack(action.value());
        }
        if (impressionId) {
          extraKeys.AppendElement()->AssignASCII("impression_id");
          extraValues.EmplaceBack(impressionId.value());
        }
        if (target) {
          extraKeys.AppendElement()->AssignASCII("target");
          extraValues.EmplaceBack(target.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded user actions on a SERP.
   */
  constexpr impl::EventMetric<EngagementExtra> engagement(145);

  /**
   * generated from serp.impression
   */
    struct ImpressionExtra {
      mozilla::Maybe<nsCString> impressionId;
      mozilla::Maybe<bool> isPrivate;
      mozilla::Maybe<bool> isShoppingPage;
      mozilla::Maybe<bool> isSignedIn;
      mozilla::Maybe<nsCString> partnerCode;
      mozilla::Maybe<nsCString> provider;
      mozilla::Maybe<bool> shoppingTabDisplayed;
      mozilla::Maybe<nsCString> source;
      mozilla::Maybe<bool> tagged;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (impressionId) {
          extraKeys.AppendElement()->AssignASCII("impression_id");
          extraValues.EmplaceBack(impressionId.value());
        }
        if (isPrivate) {
          extraKeys.AppendElement()->AssignASCII("is_private");
          extraValues.AppendElement()->AssignASCII(isPrivate.value() ? "true" : "false");
        }
        if (isShoppingPage) {
          extraKeys.AppendElement()->AssignASCII("is_shopping_page");
          extraValues.AppendElement()->AssignASCII(isShoppingPage.value() ? "true" : "false");
        }
        if (isSignedIn) {
          extraKeys.AppendElement()->AssignASCII("is_signed_in");
          extraValues.AppendElement()->AssignASCII(isSignedIn.value() ? "true" : "false");
        }
        if (partnerCode) {
          extraKeys.AppendElement()->AssignASCII("partner_code");
          extraValues.EmplaceBack(partnerCode.value());
        }
        if (provider) {
          extraKeys.AppendElement()->AssignASCII("provider");
          extraValues.EmplaceBack(provider.value());
        }
        if (shoppingTabDisplayed) {
          extraKeys.AppendElement()->AssignASCII("shopping_tab_displayed");
          extraValues.AppendElement()->AssignASCII(shoppingTabDisplayed.value() ? "true" : "false");
        }
        if (source) {
          extraKeys.AppendElement()->AssignASCII("source");
          extraValues.EmplaceBack(source.value());
        }
        if (tagged) {
          extraKeys.AppendElement()->AssignASCII("tagged");
          extraValues.AppendElement()->AssignASCII(tagged.value() ? "true" : "false");
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when a search engine results page (SERP) is shown to a user. The
     * feature began rolling out to all users with Firefox 115, and was permanently
     * enabled in Firefox 119.
   */
  constexpr impl::EventMetric<ImpressionExtra> impression(146);

}
namespace shopping {
  /**
   * generated from shopping.address_bar_feature_callout_displayed
   */
    struct AddressBarFeatureCalloutDisplayedExtra {
      mozilla::Maybe<nsCString> configuration;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (configuration) {
          extraKeys.AppendElement()->AssignASCII("configuration");
          extraValues.EmplaceBack(configuration.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * The user was shown the feature callout for the Shopping component.
   */
  constexpr impl::EventMetric<AddressBarFeatureCalloutDisplayedExtra> address_bar_feature_callout_displayed(147);

  /**
   * generated from shopping.address_bar_icon_clicked
   */
    struct AddressBarIconClickedExtra {
      mozilla::Maybe<nsCString> action;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (action) {
          extraKeys.AppendElement()->AssignASCII("action");
          extraValues.EmplaceBack(action.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * The Shopping product Address Bar Icon was clicked by the user.
   */
  constexpr impl::EventMetric<AddressBarIconClickedExtra> address_bar_icon_clicked(148);

  /**
   * generated from shopping.address_bar_icon_displayed
   */
  /**
   * The Shopping product Address Bar Icon was displayed to the user.
   */
  constexpr impl::EventMetric<NoExtraKeys> address_bar_icon_displayed(149);

  /**
   * generated from shopping.ads_exposure
   */
  /**
   * On a supported product page, the review checker showed analysis, and
     * the ads exposure pref was enabled, or review checker ads were enabled,
     * and when we tried to fetch an ad from the ad server, an ad was available.
     * Does not indicate whether the ad was actually shown.
   */
  constexpr impl::EventMetric<NoExtraKeys> ads_exposure(150);

  /**
   * generated from shopping.product_page_visits
   */
  /**
   * Counts number of visits to a supported retailer product page
     * while enrolled in either the control or treatment branches
     * of the shopping experiment.
   */
  constexpr impl::CounterMetric product_page_visits(151);

  /**
   * generated from shopping.surface_ads_clicked
   */
  /**
   * An ad shown in the sidebar was clicked.
   */
  constexpr impl::EventMetric<NoExtraKeys> surface_ads_clicked(152);

  /**
   * generated from shopping.surface_ads_impression
   */
  /**
   * An ad was shown and visible in the sidebar for 1.5 seconds.
   */
  constexpr impl::EventMetric<NoExtraKeys> surface_ads_impression(153);

  /**
   * generated from shopping.surface_ads_placement
   */
  /**
   * An ad unit was fetched successfully.
   */
  constexpr impl::EventMetric<NoExtraKeys> surface_ads_placement(154);

  /**
   * generated from shopping.surface_ads_setting_toggled
   */
    struct SurfaceAdsSettingToggledExtra {
      mozilla::Maybe<nsCString> action;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (action) {
          extraKeys.AppendElement()->AssignASCII("action");
          extraValues.EmplaceBack(action.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * The user clicked the settings toggle to enable or disable ads in the
     * sidebar settings component.
   */
  constexpr impl::EventMetric<SurfaceAdsSettingToggledExtra> surface_ads_setting_toggled(155);

  /**
   * generated from shopping.surface_analyze_reviews_none_available_clicked
   */
  /**
   * The user clicked to analyze reviews in the case the reliability rating
     * was not available for display in the shopping side bar. This metric
     * does not contain any information about the product the user is viewing.
   */
  constexpr impl::EventMetric<NoExtraKeys> surface_analyze_reviews_none_available_clicked(156);

  /**
   * generated from shopping.surface_auto_open_setting_toggled
   */
    struct SurfaceAutoOpenSettingToggledExtra {
      mozilla::Maybe<nsCString> action;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (action) {
          extraKeys.AppendElement()->AssignASCII("action");
          extraValues.EmplaceBack(action.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * The user clicked the settings toggle to enable or disable auto-open in the
     * sidebar settings component.
   */
  constexpr impl::EventMetric<SurfaceAutoOpenSettingToggledExtra> surface_auto_open_setting_toggled(157);

  /**
   * generated from shopping.surface_closed
   */
    struct SurfaceClosedExtra {
      mozilla::Maybe<nsCString> source;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (source) {
          extraKeys.AppendElement()->AssignASCII("source");
          extraValues.EmplaceBack(source.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * The user opened the settings menu of the shopping component.
   */
  constexpr impl::EventMetric<SurfaceClosedExtra> surface_closed(158);

  /**
   * generated from shopping.surface_displayed
   */
    struct SurfaceDisplayedExtra {
      mozilla::Maybe<nsCString> sideBarState;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (sideBarState) {
          extraKeys.AppendElement()->AssignASCII("side_bar_state");
          extraValues.EmplaceBack(sideBarState.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * The Shopping product Sidebar was displayed.
   */
  constexpr impl::EventMetric<SurfaceDisplayedExtra> surface_displayed(159);

  /**
   * generated from shopping.surface_learn_more_clicked
   */
  /**
   * The user clicked the 'Learn More' link in the Shopping onboarding
     * experience.
   */
  constexpr impl::EventMetric<NoExtraKeys> surface_learn_more_clicked(160);

  /**
   * generated from shopping.surface_no_ads_available
   */
  /**
   * On a supported product page, the review checker showed analysis, and
     * review checker ads were enabled, but when we tried to fetch an ad from
     * the ad server, no ad was available.
   */
  constexpr impl::EventMetric<NoExtraKeys> surface_no_ads_available(161);

  /**
   * generated from shopping.surface_no_review_reliability_available
   */
  /**
   * Review reliability was not available for display in the shopping side
     * bar. This metric does not contain any information about the product
     * the user is viewing.
   */
  constexpr impl::EventMetric<NoExtraKeys> surface_no_review_reliability_available(162);

  /**
   * generated from shopping.surface_no_thanks_button_clicked
   */
  /**
   * The user clicks the 'No thanks' button when asked if they want to
     * disable auto-open behavior.
   */
  constexpr impl::EventMetric<NoExtraKeys> surface_no_thanks_button_clicked(163);

  /**
   * generated from shopping.surface_not_now_clicked
   */
  /**
   * The user clicked 'Not Now' to dismiss the dialog.
   */
  constexpr impl::EventMetric<NoExtraKeys> surface_not_now_clicked(164);

  /**
   * generated from shopping.surface_onboarding_displayed
   */
    struct SurfaceOnboardingDisplayedExtra {
      mozilla::Maybe<nsCString> configuration;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (configuration) {
          extraKeys.AppendElement()->AssignASCII("configuration");
          extraValues.EmplaceBack(configuration.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * The Shopping Side bar displayed the onboarding experience.
   */
  constexpr impl::EventMetric<SurfaceOnboardingDisplayedExtra> surface_onboarding_displayed(165);

  /**
   * generated from shopping.surface_opt_in_clicked
   */
  /**
   * The user clicked the "Yes, try it" element to use the Shopping product's
     * functionality.
   */
  constexpr impl::EventMetric<NoExtraKeys> surface_opt_in_clicked(166);

  /**
   * generated from shopping.surface_opt_out_button_clicked
   */
  /**
   * The user clicked the button in the settings panel to turn off the shopping
     * experience.
   */
  constexpr impl::EventMetric<NoExtraKeys> surface_opt_out_button_clicked(167);

  /**
   * generated from shopping.surface_powered_by_fakespot_link_clicked
   */
  /**
   * The user clicked the "Fakespot by Mozilla" link in the shopping side
     * bar.
   */
  constexpr impl::EventMetric<NoExtraKeys> surface_powered_by_fakespot_link_clicked(168);

  /**
   * generated from shopping.surface_reactivated_button_clicked
   */
  /**
   * The user clicked the reactivated product button.
   */
  constexpr impl::EventMetric<NoExtraKeys> surface_reactivated_button_clicked(169);

  /**
   * generated from shopping.surface_reanalyze_clicked
   */
  /**
   * The user clicked to REanalyze reviews in the shopping side bar. This
     * metric does not contain any information about the product the user is
     * viewing or any displayed trusted deals.
   */
  constexpr impl::EventMetric<NoExtraKeys> surface_reanalyze_clicked(170);

  /**
   * generated from shopping.surface_settings_expand_clicked
   */
    struct SurfaceSettingsExpandClickedExtra {
      mozilla::Maybe<nsCString> action;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (action) {
          extraKeys.AppendElement()->AssignASCII("action");
          extraValues.EmplaceBack(action.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * The user opened the settings menu of the shopping component.
   */
  constexpr impl::EventMetric<SurfaceSettingsExpandClickedExtra> surface_settings_expand_clicked(171);

  /**
   * generated from shopping.surface_show_more_reviews_button_clicked
   */
    struct SurfaceShowMoreReviewsButtonClickedExtra {
      mozilla::Maybe<nsCString> action;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (action) {
          extraKeys.AppendElement()->AssignASCII("action");
          extraValues.EmplaceBack(action.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * The user clicked to expand the recent reviews to see more.
   */
  constexpr impl::EventMetric<SurfaceShowMoreReviewsButtonClickedExtra> surface_show_more_reviews_button_clicked(172);

  /**
   * generated from shopping.surface_show_privacy_policy_clicked
   */
  /**
   * The user clicked to view the Privacy Policy.
   */
  constexpr impl::EventMetric<NoExtraKeys> surface_show_privacy_policy_clicked(173);

  /**
   * generated from shopping.surface_show_quality_explainer_clicked
   */
    struct SurfaceShowQualityExplainerClickedExtra {
      mozilla::Maybe<nsCString> action;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (action) {
          extraKeys.AppendElement()->AssignASCII("action");
          extraValues.EmplaceBack(action.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * The user clicked to see the explanation of Review Quality in the
     * shopping component.
   */
  constexpr impl::EventMetric<SurfaceShowQualityExplainerClickedExtra> surface_show_quality_explainer_clicked(174);

  /**
   * generated from shopping.surface_show_quality_explainer_url_clicked
   */
  /**
   * The user clicked to see the explanation of Review Quality in the
     * shopping component.
   */
  constexpr impl::EventMetric<NoExtraKeys> surface_show_quality_explainer_url_clicked(175);

  /**
   * generated from shopping.surface_show_terms_clicked
   */
  /**
   * The user clicked to view the Terms of Service.
   */
  constexpr impl::EventMetric<NoExtraKeys> surface_show_terms_clicked(176);

  /**
   * generated from shopping.surface_stale_analysis_shown
   */
  /**
   * The user was shown the dialogue box indicating that analysis of a product
     * was stale. No information about the product is included.
   */
  constexpr impl::EventMetric<NoExtraKeys> surface_stale_analysis_shown(177);

  /**
   * generated from shopping.surface_yes_keep_closed_button_clicked
   */
  /**
   * The user clicks the 'Yes, keep closed' button when asked if they want to
     * disable auto-open behavior.
   */
  constexpr impl::EventMetric<NoExtraKeys> surface_yes_keep_closed_button_clicked(178);

}
namespace shopping_settings {
  /**
   * generated from shopping.settings.auto_open_user_disabled
   */
  /**
   * Indicates if the user has manually disabled the auto open sidebar feature.
     * Set during shopping component init and updated when changed in browser.
   */
  constexpr impl::BooleanMetric auto_open_user_disabled(179);

  /**
   * generated from shopping.settings.component_opted_out
   */
  /**
   * Indicates if the user has opted out of using the shopping component.
     * Set during shopping component init and updated when changed in browser.
   */
  constexpr impl::BooleanMetric component_opted_out(180);

  /**
   * generated from shopping.settings.disabled_ads
   */
  /**
   * Indicates if the user has manually disabled ads. Set during shopping
     * component init and updated when changed in browser.
   */
  constexpr impl::BooleanMetric disabled_ads(181);

  /**
   * generated from shopping.settings.has_onboarded
   */
  /**
   * Indicates if the user has completed the Shopping product Onboarding
     * experience. Set during shopping component init and updated when changed
     * in browser.
   */
  constexpr impl::BooleanMetric has_onboarded(182);

  /**
   * generated from shopping.settings.nimbus_disabled_shopping
   */
  /**
   * Indicates if Nimbus has disabled the use the shopping component.
   */
  constexpr impl::BooleanMetric nimbus_disabled_shopping(183);

}
namespace quick_suggest {
  /**
   * generated from quick_suggest.advertiser
   */
  /**
   * The name of the advertiser providing the sponsored TopSite.
   */
  constexpr impl::StringMetric advertiser(184);

  /**
   * generated from quick_suggest.block_id
   */
  /**
   * A unique identifier for the suggestion (a.k.a. a keywords block).
   */
  constexpr impl::StringMetric block_id(185);

  /**
   * generated from quick_suggest.context_id
   */
  /**
   * An identifier to identify users for Contextual Services user interaction pings.
   */
  constexpr impl::UuidMetric context_id(186);

  /**
   * generated from quick_suggest.iab_category
   */
  /**
   * The suggestion's category. Either "22 - Shopping" or "5 - Educational".
   */
  constexpr impl::StringMetric iab_category(187);

  /**
   * generated from quick_suggest.improve_suggest_experience
   */
  /**
   * Whether the "Improve Suggest Experience" checkbox is checked.
   */
  constexpr impl::BooleanMetric improve_suggest_experience(188);

  /**
   * generated from quick_suggest.is_clicked
   */
  /**
   * Whether this quicksuggest-impression ping was for an item that was clicked.
   */
  constexpr impl::BooleanMetric is_clicked(189);

  /**
   * generated from quick_suggest.match_type
   */
  /**
   * Whether this was a best/top match or not. Either "best-match" or "firefox-
     * suggest".
   */
  constexpr impl::StringMetric match_type(190);

  /**
   * generated from quick_suggest.ping_type
   */
  /**
   * The ping's type. In other situations might be designated by an event's name or
     * an interaction field. E.g. "quicksuggest-impression", "quicksuggest-block",
     * "quicksuggest-click".
   */
  constexpr impl::StringMetric ping_type(191);

  /**
   * generated from quick_suggest.position
   */
  /**
   * The position (1-based) of the QuickSuggest item being interatcted with.
   */
  constexpr impl::QuantityMetric position(192);

  /**
   * generated from quick_suggest.reporting_url
   */
  /**
   * The url to report this interaction to.
   */
  constexpr impl::UrlMetric reporting_url(193);

  /**
   * generated from quick_suggest.request_id
   */
  /**
   * A request identifier for each API request to [Merino](https://mozilla-
     * services.github.io/merino/). Only present for suggestions provided by Merino.
   */
  constexpr impl::StringMetric request_id(194);

  /**
   * generated from quick_suggest.source
   */
  /**
   * The source of the interaction. E.g. "urlbar".
   */
  constexpr impl::StringMetric source(195);

  /**
   * generated from quick_suggest.suggested_index
   */
  /**
   * A stringified integer value that is the intended index of the suggestion being
     * interacted with. If `suggested_index_relative_to_group` is true, the index is
     * relative to the "Firefox Suggest" group; otherwise the index is relative to the
     * entire list of suggestions. Non-negative values (starting at 0) are relative to
     * the start/top of the group/list; negative values are relative to the end/bottom
     * of the group/list.
   */
  constexpr impl::StringMetric suggested_index(196);

  /**
   * generated from quick_suggest.suggested_index_relative_to_group
   */
  /**
   * Whether `suggested_index` is relative to the "Firefox Suggest" group. If false,
     * it is relative to the entire list of suggestions.
   */
  constexpr impl::BooleanMetric suggested_index_relative_to_group(197);

}
namespace urlbar {
  /**
   * generated from urlbar.abandonment
   */
    struct AbandonmentExtra {
      mozilla::Maybe<nsCString> abandonmentType;
      mozilla::Maybe<nsCString> groups;
      mozilla::Maybe<nsCString> interaction;
      mozilla::Maybe<uint32_t> nChars;
      mozilla::Maybe<uint32_t> nResults;
      mozilla::Maybe<uint32_t> nWords;
      mozilla::Maybe<nsCString> results;
      mozilla::Maybe<nsCString> sap;
      mozilla::Maybe<nsCString> searchEngineDefaultId;
      mozilla::Maybe<nsCString> searchMode;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (abandonmentType) {
          extraKeys.AppendElement()->AssignASCII("abandonment_type");
          extraValues.EmplaceBack(abandonmentType.value());
        }
        if (groups) {
          extraKeys.AppendElement()->AssignASCII("groups");
          extraValues.EmplaceBack(groups.value());
        }
        if (interaction) {
          extraKeys.AppendElement()->AssignASCII("interaction");
          extraValues.EmplaceBack(interaction.value());
        }
        if (nChars) {
          extraKeys.AppendElement()->AssignASCII("n_chars");
          extraValues.EmplaceBack(nsPrintfCString("%d", nChars.value()));
        }
        if (nResults) {
          extraKeys.AppendElement()->AssignASCII("n_results");
          extraValues.EmplaceBack(nsPrintfCString("%d", nResults.value()));
        }
        if (nWords) {
          extraKeys.AppendElement()->AssignASCII("n_words");
          extraValues.EmplaceBack(nsPrintfCString("%d", nWords.value()));
        }
        if (results) {
          extraKeys.AppendElement()->AssignASCII("results");
          extraValues.EmplaceBack(results.value());
        }
        if (sap) {
          extraKeys.AppendElement()->AssignASCII("sap");
          extraValues.EmplaceBack(sap.value());
        }
        if (searchEngineDefaultId) {
          extraKeys.AppendElement()->AssignASCII("search_engine_default_id");
          extraValues.EmplaceBack(searchEngineDefaultId.value());
        }
        if (searchMode) {
          extraKeys.AppendElement()->AssignASCII("search_mode");
          extraValues.EmplaceBack(searchMode.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when the user abandons a search (blurring the urlbar).
   */
  constexpr impl::EventMetric<AbandonmentExtra> abandonment(198);

  /**
   * generated from urlbar.engagement
   */
    struct EngagementExtra {
      mozilla::Maybe<nsCString> engagementType;
      mozilla::Maybe<nsCString> groups;
      mozilla::Maybe<nsCString> interaction;
      mozilla::Maybe<uint32_t> nChars;
      mozilla::Maybe<uint32_t> nResults;
      mozilla::Maybe<uint32_t> nWords;
      mozilla::Maybe<nsCString> provider;
      mozilla::Maybe<nsCString> results;
      mozilla::Maybe<nsCString> sap;
      mozilla::Maybe<nsCString> searchEngineDefaultId;
      mozilla::Maybe<nsCString> searchMode;
      mozilla::Maybe<uint32_t> selectedPosition;
      mozilla::Maybe<nsCString> selectedResult;
      mozilla::Maybe<nsCString> selectedResultSubtype;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (engagementType) {
          extraKeys.AppendElement()->AssignASCII("engagement_type");
          extraValues.EmplaceBack(engagementType.value());
        }
        if (groups) {
          extraKeys.AppendElement()->AssignASCII("groups");
          extraValues.EmplaceBack(groups.value());
        }
        if (interaction) {
          extraKeys.AppendElement()->AssignASCII("interaction");
          extraValues.EmplaceBack(interaction.value());
        }
        if (nChars) {
          extraKeys.AppendElement()->AssignASCII("n_chars");
          extraValues.EmplaceBack(nsPrintfCString("%d", nChars.value()));
        }
        if (nResults) {
          extraKeys.AppendElement()->AssignASCII("n_results");
          extraValues.EmplaceBack(nsPrintfCString("%d", nResults.value()));
        }
        if (nWords) {
          extraKeys.AppendElement()->AssignASCII("n_words");
          extraValues.EmplaceBack(nsPrintfCString("%d", nWords.value()));
        }
        if (provider) {
          extraKeys.AppendElement()->AssignASCII("provider");
          extraValues.EmplaceBack(provider.value());
        }
        if (results) {
          extraKeys.AppendElement()->AssignASCII("results");
          extraValues.EmplaceBack(results.value());
        }
        if (sap) {
          extraKeys.AppendElement()->AssignASCII("sap");
          extraValues.EmplaceBack(sap.value());
        }
        if (searchEngineDefaultId) {
          extraKeys.AppendElement()->AssignASCII("search_engine_default_id");
          extraValues.EmplaceBack(searchEngineDefaultId.value());
        }
        if (searchMode) {
          extraKeys.AppendElement()->AssignASCII("search_mode");
          extraValues.EmplaceBack(searchMode.value());
        }
        if (selectedPosition) {
          extraKeys.AppendElement()->AssignASCII("selected_position");
          extraValues.EmplaceBack(nsPrintfCString("%d", selectedPosition.value()));
        }
        if (selectedResult) {
          extraKeys.AppendElement()->AssignASCII("selected_result");
          extraValues.EmplaceBack(selectedResult.value());
        }
        if (selectedResultSubtype) {
          extraKeys.AppendElement()->AssignASCII("selected_result_subtype");
          extraValues.EmplaceBack(selectedResultSubtype.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when the user executes an action on a result.
   */
  constexpr impl::EventMetric<EngagementExtra> engagement(199);

  /**
   * generated from urlbar.exposure
   */
    struct ExposureExtra {
      mozilla::Maybe<nsCString> results;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (results) {
          extraKeys.AppendElement()->AssignASCII("results");
          extraValues.EmplaceBack(results.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when client is exposed to urlbar experiment results.
   */
  constexpr impl::EventMetric<ExposureExtra> exposure(200);

  /**
   * generated from urlbar.potential_exposure
   */
    struct PotentialExposureExtra {
      mozilla::Maybe<nsCString> keyword;
      mozilla::Maybe<bool> terminal;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (keyword) {
          extraKeys.AppendElement()->AssignASCII("keyword");
          extraValues.EmplaceBack(keyword.value());
        }
        if (terminal) {
          extraKeys.AppendElement()->AssignASCII("terminal");
          extraValues.AppendElement()->AssignASCII(terminal.value() ? "true" : "false");
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * This event is recorded in the `urlbar-potential-exposure` ping, which is
     * submitted at the end of urlbar sessions during which the user typed a keyword
     * defined by the Nimbus variable `potentialExposureKeywords`. A "session" begins
     * when the user focuses the urlbar and ends with an engagement or abandonment.
     * The ping will contain one event per unique keyword that is typed during the
     * session. This ping is not submitted for sessions in private windows.
   */
  constexpr impl::EventMetric<PotentialExposureExtra> potential_exposure(201);

  /**
   * generated from urlbar.pref_max_results
   */
  /**
   * Maximum results to show in the Address Bar. Corresponds to the value of the
     * `browser.urlbar.maxRichResults` pref.
   */
  constexpr impl::QuantityMetric pref_max_results(202);

  /**
   * generated from urlbar.pref_suggest_data_collection
   */
  /**
   * Whether the user has opted in to data collection for Firefox Suggest, i.e.,
     * online suggestions served from Merino. Corresponds to the value of the
     * `browser.urlbar.quicksuggest.dataCollection.enabled` pref.
   */
  constexpr impl::BooleanMetric pref_suggest_data_collection(203);

  /**
   * generated from urlbar.pref_suggest_nonsponsored
   */
  /**
   * Whether non-sponsored quick suggest results are shown in the urlbar.
     * Corresponds to the value of the
     * `browser.urlbar.suggest.quicksuggest.nonsponsored` pref.
   */
  constexpr impl::BooleanMetric pref_suggest_nonsponsored(204);

  /**
   * generated from urlbar.pref_suggest_sponsored
   */
  /**
   * Whether sponsored quick suggest results are shown in the urlbar. Corresponds to
     * the value of the `browser.urlbar.suggest.quicksuggest.sponsored` pref.
   */
  constexpr impl::BooleanMetric pref_suggest_sponsored(205);

  /**
   * generated from urlbar.pref_suggest_topsites
   */
  /**
   * Whether topsite results are enabled in the urlbar. Corresponds to the value of
     * the `browser.urlbar.suggest.topsites` pref.
   */
  constexpr impl::BooleanMetric pref_suggest_topsites(206);

  /**
   * generated from urlbar.quick_suggest_contextual_opt_in
   */
    struct QuickSuggestContextualOptInExtra {
      mozilla::Maybe<nsCString> interaction;
      mozilla::Maybe<bool> sayHello;
      mozilla::Maybe<bool> topPosition;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (interaction) {
          extraKeys.AppendElement()->AssignASCII("interaction");
          extraValues.EmplaceBack(interaction.value());
        }
        if (sayHello) {
          extraKeys.AppendElement()->AssignASCII("say_hello");
          extraValues.AppendElement()->AssignASCII(sayHello.value() ? "true" : "false");
        }
        if (topPosition) {
          extraKeys.AppendElement()->AssignASCII("top_position");
          extraValues.AppendElement()->AssignASCII(topPosition.value() ? "true" : "false");
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when the contextual opt-in UI is shown or interacted with.
   */
  constexpr impl::EventMetric<QuickSuggestContextualOptInExtra> quick_suggest_contextual_opt_in(207);

}
namespace browser_engagement {
  /**
   * generated from browser.engagement.active_ticks
   */
  /**
   * The number of five-second intervals ('ticks') the user was considered
     * 'active'.
     * 
     * 'active' means keyboard or mouse interaction with the application.
     * It doesn't take into account whether or not the window has focus or is in
     * the foreground, only if it is receiving these interaction events.
     * 
     * Migrated from Telemetry's `browser.engagement.active_ticks`.
   */
  constexpr impl::CounterMetric active_ticks(208);

  /**
   * generated from browser.engagement.profile_count
   */
  /**
   * Windows only count of the browser profiles on the current system. This
     * counts profiles that have been used across all Windows user accounts on
     * machine since this probe was added. The value persists across installs.
     * A value of 0 is reported if there is an error determining the correct
     * count. Unset on other platforms.
   */
  constexpr impl::QuantityMetric profile_count(209);

  /**
   * generated from browser.engagement.uri_count
   */
  /**
   * The number of total non-unique http(s) URIs visited, including page
     * reloads, after the session has been restored. URIs on minimized or
     * background tabs may also be counted. Private browsing uris are included.
     * 
     * Migrated from Telemetry's
     * `browser.engagement.total_uri_count_normal_and_private_mode`.
   */
  constexpr impl::CounterMetric uri_count(210);

}
namespace browser_usage {
  /**
   * generated from browser.usage.interaction
   */
    struct InteractionExtra {
      mozilla::Maybe<nsCString> flowId;
      mozilla::Maybe<nsCString> source;
      mozilla::Maybe<nsCString> widgetId;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (flowId) {
          extraKeys.AppendElement()->AssignASCII("flow_id");
          extraValues.EmplaceBack(flowId.value());
        }
        if (source) {
          extraKeys.AppendElement()->AssignASCII("source");
          extraValues.EmplaceBack(source.value());
        }
        if (widgetId) {
          extraKeys.AppendElement()->AssignASCII("widget_id");
          extraValues.EmplaceBack(widgetId.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * The user interacted with something in the Firefox Desktop frontend. Could be
     * via mouse or keyboard, could be a command or a UI element.
   */
  constexpr impl::EventMetric<InteractionExtra> interaction(211);

}
namespace installation_first_seen {
  /**
   * generated from installation.first_seen.admin_user
   */
  /**
   * Whether the installer is running from an elevated admin user
   */
  constexpr impl::BooleanMetric admin_user(212);

  /**
   * generated from installation.first_seen.default_path
   */
  /**
   * (optional, present if installer_type is "full") Whether the default path was
     * used
   */
  constexpr impl::BooleanMetric default_path(213);

  /**
   * generated from installation.first_seen.failure_reason
   */
  /**
   * Only sent if unable to collect firstSeen data. Can have value "NotFoundError"
     * if file not found or other values depending on the failure reason.
   */
  constexpr impl::StringMetric failure_reason(214);

  /**
   * generated from installation.first_seen.from_msi
   */
  /**
   * (optional, present if installer_type is "full") Whether this was an MSI install
   */
  constexpr impl::BooleanMetric from_msi(215);

  /**
   * generated from installation.first_seen.install_existed
   */
  /**
   * Whether there was already an install in this location
   */
  constexpr impl::BooleanMetric install_existed(216);

  /**
   * generated from installation.first_seen.installer_type
   */
  /**
   * The type of installer used to install Firefox. The value is one of "stub",
     * "full", or "msix"
   */
  constexpr impl::StringMetric installer_type(217);

  /**
   * generated from installation.first_seen.other_inst
   */
  /**
   * Whether there was already any non-MSIX install on this system
   */
  constexpr impl::BooleanMetric other_inst(218);

  /**
   * generated from installation.first_seen.other_msix_inst
   */
  /**
   * Whether there was already any MSIX install on this system
   */
  constexpr impl::BooleanMetric other_msix_inst(219);

  /**
   * generated from installation.first_seen.profdir_existed
   */
  /**
   * Whether the top-level profile directory existed
   */
  constexpr impl::BooleanMetric profdir_existed(220);

  /**
   * generated from installation.first_seen.silent
   */
  /**
   * (optional, present if installer_type is "full") Whether this was a silent
     * install
   */
  constexpr impl::BooleanMetric silent(221);

  /**
   * generated from installation.first_seen.version
   */
  /**
   * The application version installed by the installer (not necessarily the current
     * version)
   */
  constexpr impl::StringMetric version(222);

}
namespace performance_interaction {
  /**
   * generated from performance.interaction.tab_switch_composite
   */
  /**
   * Time between tab selection and first composite of the tab content onto the
     * screen. (Migrated from the geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric tab_switch_composite(223);

  /**
   * generated from performance.interaction.keypress_present_latency
   */
  /**
   * Time between receiving a keypress event in the event loop and compositing its
     * result onto the screen. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::TimingDistributionMetric keypress_present_latency(224);

  /**
   * generated from performance.interaction.mouseup_click_present_latency
   */
  /**
   * Time between receiving a mouseup which follow by a mouseclick on the event loop
     * and compositing its result onto the screen. (Migrated from the geckoview metric
     * of the same name).
   */
  constexpr impl::TimingDistributionMetric mouseup_click_present_latency(225);

}
namespace performance_page {
  /**
   * generated from performance.page.total_content_page_load
   */
  /**
   * Time to load all of a page's resources and render. (Migrated from the geckoview
     * metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric total_content_page_load(226);

  /**
   * generated from performance.page.non_blank_paint
   */
  /**
   * The time between navigationStart and the first non-blank paint of a foreground
     * root content document, in milliseconds. This only records documents that were
     * in an active docshell throughout the whole time between navigation start and
     * non-blank paint. The non-blank paint timestamp is taken during display list
     * building and does not include rasterization or compositing of that paint.
     * (Migrated from the geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric non_blank_paint(227);

}
namespace use_counter {
  /**
   * generated from use.counter.content_documents_destroyed
   */
  /**
   * A count of how many content documents were destroyed. Used to turn document use
     * counters' counts into rates. Excludes documents for which we do not count use
     * counters (See `Document::ShouldIncludeInTelemetry`).
   */
  constexpr impl::CounterMetric content_documents_destroyed(228);

  /**
   * generated from use.counter.dedicated_workers_destroyed
   */
  /**
   * A count of how many `Dedicated`-kind workers were destroyed. Used to turn
     * dedicated worker use counters' counts into rates. Excludes chrome workers.
   */
  constexpr impl::CounterMetric dedicated_workers_destroyed(229);

  /**
   * generated from use.counter.service_workers_destroyed
   */
  /**
   * A count of how many `Service`-kind workers were destroyed. Used to turn service
     * worker use counters' counts into rates. Excludes chrome workers.
   */
  constexpr impl::CounterMetric service_workers_destroyed(230);

  /**
   * generated from use.counter.shared_workers_destroyed
   */
  /**
   * A count of how many `Shared`-kind workers were destroyed. Used to turn shared
     * worker use counters' counts into rates. Excludes chrome workers.
   */
  constexpr impl::CounterMetric shared_workers_destroyed(231);

  /**
   * generated from use.counter.top_level_content_documents_destroyed
   */
  /**
   * A count of how many "pages" were destroyed. Used to turn page use counters'
     * counts into rates. Excludes pages that contain only documents for which we do
     * not count use counters (See `Document::ShouldIncludeInTelemetry`).
   */
  constexpr impl::CounterMetric top_level_content_documents_destroyed(232);

}
namespace use_counter_css_doc {
  /**
   * generated from use.counter.css.doc.alignment_baseline
   */
  /**
   * Whether a document used the (unknown, counted) CSS property alignment-baseline.
     * Compare against `use.counter.content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric alignment_baseline(233);

  /**
   * generated from use.counter.css.doc.background_repeat_x
   */
  /**
   * Whether a document used the (unknown, counted) CSS property background-
     * repeat-x. Compare against `use.counter.content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric background_repeat_x(234);

  /**
   * generated from use.counter.css.doc.background_repeat_y
   */
  /**
   * Whether a document used the (unknown, counted) CSS property background-
     * repeat-y. Compare against `use.counter.content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric background_repeat_y(235);

  /**
   * generated from use.counter.css.doc.baseline_shift
   */
  /**
   * Whether a document used the (unknown, counted) CSS property baseline-shift.
     * Compare against `use.counter.content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric baseline_shift(236);

  /**
   * generated from use.counter.css.doc.buffered_rendering
   */
  /**
   * Whether a document used the (unknown, counted) CSS property buffered-rendering.
     * Compare against `use.counter.content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric buffered_rendering(237);

  /**
   * generated from use.counter.css.doc.color_rendering
   */
  /**
   * Whether a document used the (unknown, counted) CSS property color-rendering.
     * Compare against `use.counter.content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric color_rendering(238);

  /**
   * generated from use.counter.css.doc.css_accent_color
   */
  /**
   * Whether a document used the CSS property accent-color. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_accent_color(239);

  /**
   * generated from use.counter.css.doc.css_align_content
   */
  /**
   * Whether a document used the CSS property align-content. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_align_content(240);

  /**
   * generated from use.counter.css.doc.css_align_items
   */
  /**
   * Whether a document used the CSS property align-items. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_align_items(241);

  /**
   * generated from use.counter.css.doc.css_align_self
   */
  /**
   * Whether a document used the CSS property align-self. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_align_self(242);

  /**
   * generated from use.counter.css.doc.css_all
   */
  /**
   * Whether a document used the CSS property all. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_all(243);

  /**
   * generated from use.counter.css.doc.css_anchor_name
   */
  /**
   * Whether a document used the CSS property anchor-name. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_anchor_name(244);

  /**
   * generated from use.counter.css.doc.css_anchor_scope
   */
  /**
   * Whether a document used the CSS property anchor-scope. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_anchor_scope(245);

  /**
   * generated from use.counter.css.doc.css_animation
   */
  /**
   * Whether a document used the CSS property animation. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_animation(246);

  /**
   * generated from use.counter.css.doc.css_animation_composition
   */
  /**
   * Whether a document used the CSS property animation-composition. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_animation_composition(247);

  /**
   * generated from use.counter.css.doc.css_animation_delay
   */
  /**
   * Whether a document used the CSS property animation-delay. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_animation_delay(248);

  /**
   * generated from use.counter.css.doc.css_animation_direction
   */
  /**
   * Whether a document used the CSS property animation-direction. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_animation_direction(249);

  /**
   * generated from use.counter.css.doc.css_animation_duration
   */
  /**
   * Whether a document used the CSS property animation-duration. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_animation_duration(250);

  /**
   * generated from use.counter.css.doc.css_animation_fill_mode
   */
  /**
   * Whether a document used the CSS property animation-fill-mode. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_animation_fill_mode(251);

  /**
   * generated from use.counter.css.doc.css_animation_iteration_count
   */
  /**
   * Whether a document used the CSS property animation-iteration-count. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_animation_iteration_count(252);

  /**
   * generated from use.counter.css.doc.css_animation_name
   */
  /**
   * Whether a document used the CSS property animation-name. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_animation_name(253);

  /**
   * generated from use.counter.css.doc.css_animation_play_state
   */
  /**
   * Whether a document used the CSS property animation-play-state. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_animation_play_state(254);

  /**
   * generated from use.counter.css.doc.css_animation_timeline
   */
  /**
   * Whether a document used the CSS property animation-timeline. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_animation_timeline(255);

  /**
   * generated from use.counter.css.doc.css_animation_timing_function
   */
  /**
   * Whether a document used the CSS property animation-timing-function. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_animation_timing_function(256);

  /**
   * generated from use.counter.css.doc.css_appearance
   */
  /**
   * Whether a document used the CSS property appearance. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_appearance(257);

  /**
   * generated from use.counter.css.doc.css_aspect_ratio
   */
  /**
   * Whether a document used the CSS property aspect-ratio. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_aspect_ratio(258);

  /**
   * generated from use.counter.css.doc.css_backdrop_filter
   */
  /**
   * Whether a document used the CSS property backdrop-filter. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_backdrop_filter(259);

  /**
   * generated from use.counter.css.doc.css_backface_visibility
   */
  /**
   * Whether a document used the CSS property backface-visibility. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_backface_visibility(260);

  /**
   * generated from use.counter.css.doc.css_background
   */
  /**
   * Whether a document used the CSS property background. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_background(261);

  /**
   * generated from use.counter.css.doc.css_background_attachment
   */
  /**
   * Whether a document used the CSS property background-attachment. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_background_attachment(262);

  /**
   * generated from use.counter.css.doc.css_background_blend_mode
   */
  /**
   * Whether a document used the CSS property background-blend-mode. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_background_blend_mode(263);

  /**
   * generated from use.counter.css.doc.css_background_clip
   */
  /**
   * Whether a document used the CSS property background-clip. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_background_clip(264);

  /**
   * generated from use.counter.css.doc.css_background_color
   */
  /**
   * Whether a document used the CSS property background-color. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_background_color(265);

  /**
   * generated from use.counter.css.doc.css_background_image
   */
  /**
   * Whether a document used the CSS property background-image. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_background_image(266);

  /**
   * generated from use.counter.css.doc.css_background_origin
   */
  /**
   * Whether a document used the CSS property background-origin. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_background_origin(267);

  /**
   * generated from use.counter.css.doc.css_background_position
   */
  /**
   * Whether a document used the CSS property background-position. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_background_position(268);

  /**
   * generated from use.counter.css.doc.css_background_position_x
   */
  /**
   * Whether a document used the CSS property background-position-x. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_background_position_x(269);

  /**
   * generated from use.counter.css.doc.css_background_position_y
   */
  /**
   * Whether a document used the CSS property background-position-y. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_background_position_y(270);

  /**
   * generated from use.counter.css.doc.css_background_repeat
   */
  /**
   * Whether a document used the CSS property background-repeat. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_background_repeat(271);

  /**
   * generated from use.counter.css.doc.css_background_size
   */
  /**
   * Whether a document used the CSS property background-size. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_background_size(272);

  /**
   * generated from use.counter.css.doc.css_baseline_source
   */
  /**
   * Whether a document used the CSS property baseline-source. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_baseline_source(273);

  /**
   * generated from use.counter.css.doc.css_block_size
   */
  /**
   * Whether a document used the CSS property block-size. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_block_size(274);

  /**
   * generated from use.counter.css.doc.css_border
   */
  /**
   * Whether a document used the CSS property border. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border(275);

  /**
   * generated from use.counter.css.doc.css_border_block
   */
  /**
   * Whether a document used the CSS property border-block. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_block(276);

  /**
   * generated from use.counter.css.doc.css_border_block_color
   */
  /**
   * Whether a document used the CSS property border-block-color. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_block_color(277);

  /**
   * generated from use.counter.css.doc.css_border_block_end
   */
  /**
   * Whether a document used the CSS property border-block-end. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_block_end(278);

  /**
   * generated from use.counter.css.doc.css_border_block_end_color
   */
  /**
   * Whether a document used the CSS property border-block-end-color. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_block_end_color(279);

  /**
   * generated from use.counter.css.doc.css_border_block_end_style
   */
  /**
   * Whether a document used the CSS property border-block-end-style. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_block_end_style(280);

  /**
   * generated from use.counter.css.doc.css_border_block_end_width
   */
  /**
   * Whether a document used the CSS property border-block-end-width. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_block_end_width(281);

  /**
   * generated from use.counter.css.doc.css_border_block_start
   */
  /**
   * Whether a document used the CSS property border-block-start. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_block_start(282);

  /**
   * generated from use.counter.css.doc.css_border_block_start_color
   */
  /**
   * Whether a document used the CSS property border-block-start-color. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_block_start_color(283);

  /**
   * generated from use.counter.css.doc.css_border_block_start_style
   */
  /**
   * Whether a document used the CSS property border-block-start-style. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_block_start_style(284);

  /**
   * generated from use.counter.css.doc.css_border_block_start_width
   */
  /**
   * Whether a document used the CSS property border-block-start-width. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_block_start_width(285);

  /**
   * generated from use.counter.css.doc.css_border_block_style
   */
  /**
   * Whether a document used the CSS property border-block-style. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_block_style(286);

  /**
   * generated from use.counter.css.doc.css_border_block_width
   */
  /**
   * Whether a document used the CSS property border-block-width. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_block_width(287);

  /**
   * generated from use.counter.css.doc.css_border_bottom
   */
  /**
   * Whether a document used the CSS property border-bottom. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_bottom(288);

  /**
   * generated from use.counter.css.doc.css_border_bottom_color
   */
  /**
   * Whether a document used the CSS property border-bottom-color. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_bottom_color(289);

  /**
   * generated from use.counter.css.doc.css_border_bottom_left_radius
   */
  /**
   * Whether a document used the CSS property border-bottom-left-radius. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_bottom_left_radius(290);

  /**
   * generated from use.counter.css.doc.css_border_bottom_right_radius
   */
  /**
   * Whether a document used the CSS property border-bottom-right-radius. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_bottom_right_radius(291);

  /**
   * generated from use.counter.css.doc.css_border_bottom_style
   */
  /**
   * Whether a document used the CSS property border-bottom-style. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_bottom_style(292);

  /**
   * generated from use.counter.css.doc.css_border_bottom_width
   */
  /**
   * Whether a document used the CSS property border-bottom-width. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_bottom_width(293);

  /**
   * generated from use.counter.css.doc.css_border_collapse
   */
  /**
   * Whether a document used the CSS property border-collapse. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_collapse(294);

  /**
   * generated from use.counter.css.doc.css_border_color
   */
  /**
   * Whether a document used the CSS property border-color. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_color(295);

  /**
   * generated from use.counter.css.doc.css_border_end_end_radius
   */
  /**
   * Whether a document used the CSS property border-end-end-radius. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_end_end_radius(296);

  /**
   * generated from use.counter.css.doc.css_border_end_start_radius
   */
  /**
   * Whether a document used the CSS property border-end-start-radius. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_end_start_radius(297);

  /**
   * generated from use.counter.css.doc.css_border_image
   */
  /**
   * Whether a document used the CSS property border-image. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_image(298);

  /**
   * generated from use.counter.css.doc.css_border_image_outset
   */
  /**
   * Whether a document used the CSS property border-image-outset. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_image_outset(299);

  /**
   * generated from use.counter.css.doc.css_border_image_repeat
   */
  /**
   * Whether a document used the CSS property border-image-repeat. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_image_repeat(300);

  /**
   * generated from use.counter.css.doc.css_border_image_slice
   */
  /**
   * Whether a document used the CSS property border-image-slice. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_image_slice(301);

  /**
   * generated from use.counter.css.doc.css_border_image_source
   */
  /**
   * Whether a document used the CSS property border-image-source. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_image_source(302);

  /**
   * generated from use.counter.css.doc.css_border_image_width
   */
  /**
   * Whether a document used the CSS property border-image-width. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_image_width(303);

  /**
   * generated from use.counter.css.doc.css_border_inline
   */
  /**
   * Whether a document used the CSS property border-inline. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_inline(304);

  /**
   * generated from use.counter.css.doc.css_border_inline_color
   */
  /**
   * Whether a document used the CSS property border-inline-color. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_inline_color(305);

  /**
   * generated from use.counter.css.doc.css_border_inline_end
   */
  /**
   * Whether a document used the CSS property border-inline-end. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_inline_end(306);

  /**
   * generated from use.counter.css.doc.css_border_inline_end_color
   */
  /**
   * Whether a document used the CSS property border-inline-end-color. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_inline_end_color(307);

  /**
   * generated from use.counter.css.doc.css_border_inline_end_style
   */
  /**
   * Whether a document used the CSS property border-inline-end-style. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_inline_end_style(308);

  /**
   * generated from use.counter.css.doc.css_border_inline_end_width
   */
  /**
   * Whether a document used the CSS property border-inline-end-width. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_inline_end_width(309);

  /**
   * generated from use.counter.css.doc.css_border_inline_start
   */
  /**
   * Whether a document used the CSS property border-inline-start. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_inline_start(310);

  /**
   * generated from use.counter.css.doc.css_border_inline_start_color
   */
  /**
   * Whether a document used the CSS property border-inline-start-color. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_inline_start_color(311);

  /**
   * generated from use.counter.css.doc.css_border_inline_start_style
   */
  /**
   * Whether a document used the CSS property border-inline-start-style. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_inline_start_style(312);

  /**
   * generated from use.counter.css.doc.css_border_inline_start_width
   */
  /**
   * Whether a document used the CSS property border-inline-start-width. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_inline_start_width(313);

  /**
   * generated from use.counter.css.doc.css_border_inline_style
   */
  /**
   * Whether a document used the CSS property border-inline-style. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_inline_style(314);

  /**
   * generated from use.counter.css.doc.css_border_inline_width
   */
  /**
   * Whether a document used the CSS property border-inline-width. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_inline_width(315);

  /**
   * generated from use.counter.css.doc.css_border_left
   */
  /**
   * Whether a document used the CSS property border-left. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_left(316);

  /**
   * generated from use.counter.css.doc.css_border_left_color
   */
  /**
   * Whether a document used the CSS property border-left-color. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_left_color(317);

  /**
   * generated from use.counter.css.doc.css_border_left_style
   */
  /**
   * Whether a document used the CSS property border-left-style. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_left_style(318);

  /**
   * generated from use.counter.css.doc.css_border_left_width
   */
  /**
   * Whether a document used the CSS property border-left-width. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_left_width(319);

  /**
   * generated from use.counter.css.doc.css_border_radius
   */
  /**
   * Whether a document used the CSS property border-radius. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_radius(320);

  /**
   * generated from use.counter.css.doc.css_border_right
   */
  /**
   * Whether a document used the CSS property border-right. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_right(321);

  /**
   * generated from use.counter.css.doc.css_border_right_color
   */
  /**
   * Whether a document used the CSS property border-right-color. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_right_color(322);

  /**
   * generated from use.counter.css.doc.css_border_right_style
   */
  /**
   * Whether a document used the CSS property border-right-style. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_right_style(323);

  /**
   * generated from use.counter.css.doc.css_border_right_width
   */
  /**
   * Whether a document used the CSS property border-right-width. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_right_width(324);

  /**
   * generated from use.counter.css.doc.css_border_spacing
   */
  /**
   * Whether a document used the CSS property border-spacing. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_spacing(325);

  /**
   * generated from use.counter.css.doc.css_border_start_end_radius
   */
  /**
   * Whether a document used the CSS property border-start-end-radius. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_start_end_radius(326);

  /**
   * generated from use.counter.css.doc.css_border_start_start_radius
   */
  /**
   * Whether a document used the CSS property border-start-start-radius. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_start_start_radius(327);

  /**
   * generated from use.counter.css.doc.css_border_style
   */
  /**
   * Whether a document used the CSS property border-style. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_style(328);

  /**
   * generated from use.counter.css.doc.css_border_top
   */
  /**
   * Whether a document used the CSS property border-top. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_top(329);

  /**
   * generated from use.counter.css.doc.css_border_top_color
   */
  /**
   * Whether a document used the CSS property border-top-color. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_top_color(330);

  /**
   * generated from use.counter.css.doc.css_border_top_left_radius
   */
  /**
   * Whether a document used the CSS property border-top-left-radius. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_top_left_radius(331);

  /**
   * generated from use.counter.css.doc.css_border_top_right_radius
   */
  /**
   * Whether a document used the CSS property border-top-right-radius. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_top_right_radius(332);

  /**
   * generated from use.counter.css.doc.css_border_top_style
   */
  /**
   * Whether a document used the CSS property border-top-style. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_top_style(333);

  /**
   * generated from use.counter.css.doc.css_border_top_width
   */
  /**
   * Whether a document used the CSS property border-top-width. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_top_width(334);

  /**
   * generated from use.counter.css.doc.css_border_width
   */
  /**
   * Whether a document used the CSS property border-width. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_width(335);

  /**
   * generated from use.counter.css.doc.css_bottom
   */
  /**
   * Whether a document used the CSS property bottom. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_bottom(336);

  /**
   * generated from use.counter.css.doc.css_box_decoration_break
   */
  /**
   * Whether a document used the CSS property box-decoration-break. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_box_decoration_break(337);

  /**
   * generated from use.counter.css.doc.css_box_shadow
   */
  /**
   * Whether a document used the CSS property box-shadow. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_box_shadow(338);

  /**
   * generated from use.counter.css.doc.css_box_sizing
   */
  /**
   * Whether a document used the CSS property box-sizing. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_box_sizing(339);

  /**
   * generated from use.counter.css.doc.css_break_after
   */
  /**
   * Whether a document used the CSS property break-after. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_break_after(340);

  /**
   * generated from use.counter.css.doc.css_break_before
   */
  /**
   * Whether a document used the CSS property break-before. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_break_before(341);

  /**
   * generated from use.counter.css.doc.css_break_inside
   */
  /**
   * Whether a document used the CSS property break-inside. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_break_inside(342);

  /**
   * generated from use.counter.css.doc.css_caption_side
   */
  /**
   * Whether a document used the CSS property caption-side. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_caption_side(343);

  /**
   * generated from use.counter.css.doc.css_caret_color
   */
  /**
   * Whether a document used the CSS property caret-color. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_caret_color(344);

  /**
   * generated from use.counter.css.doc.css_clear
   */
  /**
   * Whether a document used the CSS property clear. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_clear(345);

  /**
   * generated from use.counter.css.doc.css_clip
   */
  /**
   * Whether a document used the CSS property clip. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_clip(346);

  /**
   * generated from use.counter.css.doc.css_clip_path
   */
  /**
   * Whether a document used the CSS property clip-path. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_clip_path(347);

  /**
   * generated from use.counter.css.doc.css_clip_rule
   */
  /**
   * Whether a document used the CSS property clip-rule. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_clip_rule(348);

  /**
   * generated from use.counter.css.doc.css_color
   */
  /**
   * Whether a document used the CSS property color. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_color(349);

  /**
   * generated from use.counter.css.doc.css_color_adjust
   */
  /**
   * Whether a document used the CSS property color-adjust. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_color_adjust(350);

  /**
   * generated from use.counter.css.doc.css_color_interpolation
   */
  /**
   * Whether a document used the CSS property color-interpolation. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_color_interpolation(351);

  /**
   * generated from use.counter.css.doc.css_color_interpolation_filters
   */
  /**
   * Whether a document used the CSS property color-interpolation-filters. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_color_interpolation_filters(352);

  /**
   * generated from use.counter.css.doc.css_color_scheme
   */
  /**
   * Whether a document used the CSS property color-scheme. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_color_scheme(353);

  /**
   * generated from use.counter.css.doc.css_column_count
   */
  /**
   * Whether a document used the CSS property column-count. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_column_count(354);

  /**
   * generated from use.counter.css.doc.css_column_fill
   */
  /**
   * Whether a document used the CSS property column-fill. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_column_fill(355);

  /**
   * generated from use.counter.css.doc.css_column_gap
   */
  /**
   * Whether a document used the CSS property column-gap. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_column_gap(356);

  /**
   * generated from use.counter.css.doc.css_column_rule
   */
  /**
   * Whether a document used the CSS property column-rule. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_column_rule(357);

  /**
   * generated from use.counter.css.doc.css_column_rule_color
   */
  /**
   * Whether a document used the CSS property column-rule-color. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_column_rule_color(358);

  /**
   * generated from use.counter.css.doc.css_column_rule_style
   */
  /**
   * Whether a document used the CSS property column-rule-style. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_column_rule_style(359);

  /**
   * generated from use.counter.css.doc.css_column_rule_width
   */
  /**
   * Whether a document used the CSS property column-rule-width. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_column_rule_width(360);

  /**
   * generated from use.counter.css.doc.css_column_span
   */
  /**
   * Whether a document used the CSS property column-span. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_column_span(361);

  /**
   * generated from use.counter.css.doc.css_column_width
   */
  /**
   * Whether a document used the CSS property column-width. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_column_width(362);

  /**
   * generated from use.counter.css.doc.css_columns
   */
  /**
   * Whether a document used the CSS property columns. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_columns(363);

  /**
   * generated from use.counter.css.doc.css_contain
   */
  /**
   * Whether a document used the CSS property contain. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_contain(364);

  /**
   * generated from use.counter.css.doc.css_contain_intrinsic_block_size
   */
  /**
   * Whether a document used the CSS property contain-intrinsic-block-size. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_contain_intrinsic_block_size(365);

  /**
   * generated from use.counter.css.doc.css_contain_intrinsic_height
   */
  /**
   * Whether a document used the CSS property contain-intrinsic-height. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_contain_intrinsic_height(366);

  /**
   * generated from use.counter.css.doc.css_contain_intrinsic_inline_size
   */
  /**
   * Whether a document used the CSS property contain-intrinsic-inline-size. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_contain_intrinsic_inline_size(367);

  /**
   * generated from use.counter.css.doc.css_contain_intrinsic_size
   */
  /**
   * Whether a document used the CSS property contain-intrinsic-size. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_contain_intrinsic_size(368);

  /**
   * generated from use.counter.css.doc.css_contain_intrinsic_width
   */
  /**
   * Whether a document used the CSS property contain-intrinsic-width. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_contain_intrinsic_width(369);

  /**
   * generated from use.counter.css.doc.css_container
   */
  /**
   * Whether a document used the CSS property container. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_container(370);

  /**
   * generated from use.counter.css.doc.css_container_name
   */
  /**
   * Whether a document used the CSS property container-name. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_container_name(371);

  /**
   * generated from use.counter.css.doc.css_container_type
   */
  /**
   * Whether a document used the CSS property container-type. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_container_type(372);

  /**
   * generated from use.counter.css.doc.css_content
   */
  /**
   * Whether a document used the CSS property content. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_content(373);

  /**
   * generated from use.counter.css.doc.css_content_visibility
   */
  /**
   * Whether a document used the CSS property content-visibility. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_content_visibility(374);

  /**
   * generated from use.counter.css.doc.css_counter_increment
   */
  /**
   * Whether a document used the CSS property counter-increment. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_counter_increment(375);

  /**
   * generated from use.counter.css.doc.css_counter_reset
   */
  /**
   * Whether a document used the CSS property counter-reset. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_counter_reset(376);

  /**
   * generated from use.counter.css.doc.css_counter_set
   */
  /**
   * Whether a document used the CSS property counter-set. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_counter_set(377);

  /**
   * generated from use.counter.css.doc.css_cursor
   */
  /**
   * Whether a document used the CSS property cursor. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_cursor(378);

  /**
   * generated from use.counter.css.doc.css_cx
   */
  /**
   * Whether a document used the CSS property cx. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_cx(379);

  /**
   * generated from use.counter.css.doc.css_cy
   */
  /**
   * Whether a document used the CSS property cy. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_cy(380);

  /**
   * generated from use.counter.css.doc.css_d
   */
  /**
   * Whether a document used the CSS property d. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_d(381);

  /**
   * generated from use.counter.css.doc.css_direction
   */
  /**
   * Whether a document used the CSS property direction. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_direction(382);

  /**
   * generated from use.counter.css.doc.css_display
   */
  /**
   * Whether a document used the CSS property display. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_display(383);

  /**
   * generated from use.counter.css.doc.css_dominant_baseline
   */
  /**
   * Whether a document used the CSS property dominant-baseline. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_dominant_baseline(384);

  /**
   * generated from use.counter.css.doc.css_empty_cells
   */
  /**
   * Whether a document used the CSS property empty-cells. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_empty_cells(385);

  /**
   * generated from use.counter.css.doc.css_fill
   */
  /**
   * Whether a document used the CSS property fill. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_fill(386);

  /**
   * generated from use.counter.css.doc.css_fill_opacity
   */
  /**
   * Whether a document used the CSS property fill-opacity. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_fill_opacity(387);

  /**
   * generated from use.counter.css.doc.css_fill_rule
   */
  /**
   * Whether a document used the CSS property fill-rule. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_fill_rule(388);

  /**
   * generated from use.counter.css.doc.css_filter
   */
  /**
   * Whether a document used the CSS property filter. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_filter(389);

  /**
   * generated from use.counter.css.doc.css_flex
   */
  /**
   * Whether a document used the CSS property flex. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_flex(390);

  /**
   * generated from use.counter.css.doc.css_flex_basis
   */
  /**
   * Whether a document used the CSS property flex-basis. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_flex_basis(391);

  /**
   * generated from use.counter.css.doc.css_flex_direction
   */
  /**
   * Whether a document used the CSS property flex-direction. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_flex_direction(392);

  /**
   * generated from use.counter.css.doc.css_flex_flow
   */
  /**
   * Whether a document used the CSS property flex-flow. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_flex_flow(393);

  /**
   * generated from use.counter.css.doc.css_flex_grow
   */
  /**
   * Whether a document used the CSS property flex-grow. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_flex_grow(394);

  /**
   * generated from use.counter.css.doc.css_flex_shrink
   */
  /**
   * Whether a document used the CSS property flex-shrink. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_flex_shrink(395);

  /**
   * generated from use.counter.css.doc.css_flex_wrap
   */
  /**
   * Whether a document used the CSS property flex-wrap. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_flex_wrap(396);

  /**
   * generated from use.counter.css.doc.css_float
   */
  /**
   * Whether a document used the CSS property float. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_float(397);

  /**
   * generated from use.counter.css.doc.css_flood_color
   */
  /**
   * Whether a document used the CSS property flood-color. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_flood_color(398);

  /**
   * generated from use.counter.css.doc.css_flood_opacity
   */
  /**
   * Whether a document used the CSS property flood-opacity. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_flood_opacity(399);

  /**
   * generated from use.counter.css.doc.css_font
   */
  /**
   * Whether a document used the CSS property font. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_font(400);

  /**
   * generated from use.counter.css.doc.css_font_family
   */
  /**
   * Whether a document used the CSS property font-family. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_font_family(401);

  /**
   * generated from use.counter.css.doc.css_font_feature_settings
   */
  /**
   * Whether a document used the CSS property font-feature-settings. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_font_feature_settings(402);

  /**
   * generated from use.counter.css.doc.css_font_kerning
   */
  /**
   * Whether a document used the CSS property font-kerning. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_font_kerning(403);

  /**
   * generated from use.counter.css.doc.css_font_language_override
   */
  /**
   * Whether a document used the CSS property font-language-override. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_font_language_override(404);

  /**
   * generated from use.counter.css.doc.css_font_optical_sizing
   */
  /**
   * Whether a document used the CSS property font-optical-sizing. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_font_optical_sizing(405);

  /**
   * generated from use.counter.css.doc.css_font_palette
   */
  /**
   * Whether a document used the CSS property font-palette. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_font_palette(406);

  /**
   * generated from use.counter.css.doc.css_font_size
   */
  /**
   * Whether a document used the CSS property font-size. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_font_size(407);

  /**
   * generated from use.counter.css.doc.css_font_size_adjust
   */
  /**
   * Whether a document used the CSS property font-size-adjust. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_font_size_adjust(408);

  /**
   * generated from use.counter.css.doc.css_font_stretch
   */
  /**
   * Whether a document used the CSS property font-stretch. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_font_stretch(409);

  /**
   * generated from use.counter.css.doc.css_font_style
   */
  /**
   * Whether a document used the CSS property font-style. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_font_style(410);

  /**
   * generated from use.counter.css.doc.css_font_synthesis
   */
  /**
   * Whether a document used the CSS property font-synthesis. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_font_synthesis(411);

  /**
   * generated from use.counter.css.doc.css_font_synthesis_position
   */
  /**
   * Whether a document used the CSS property font-synthesis-position. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_font_synthesis_position(412);

  /**
   * generated from use.counter.css.doc.css_font_synthesis_small_caps
   */
  /**
   * Whether a document used the CSS property font-synthesis-small-caps. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_font_synthesis_small_caps(413);

  /**
   * generated from use.counter.css.doc.css_font_synthesis_style
   */
  /**
   * Whether a document used the CSS property font-synthesis-style. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_font_synthesis_style(414);

  /**
   * generated from use.counter.css.doc.css_font_synthesis_weight
   */
  /**
   * Whether a document used the CSS property font-synthesis-weight. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_font_synthesis_weight(415);

  /**
   * generated from use.counter.css.doc.css_font_variant
   */
  /**
   * Whether a document used the CSS property font-variant. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_font_variant(416);

  /**
   * generated from use.counter.css.doc.css_font_variant_alternates
   */
  /**
   * Whether a document used the CSS property font-variant-alternates. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_font_variant_alternates(417);

  /**
   * generated from use.counter.css.doc.css_font_variant_caps
   */
  /**
   * Whether a document used the CSS property font-variant-caps. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_font_variant_caps(418);

  /**
   * generated from use.counter.css.doc.css_font_variant_east_asian
   */
  /**
   * Whether a document used the CSS property font-variant-east-asian. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_font_variant_east_asian(419);

  /**
   * generated from use.counter.css.doc.css_font_variant_emoji
   */
  /**
   * Whether a document used the CSS property font-variant-emoji. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_font_variant_emoji(420);

  /**
   * generated from use.counter.css.doc.css_font_variant_ligatures
   */
  /**
   * Whether a document used the CSS property font-variant-ligatures. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_font_variant_ligatures(421);

  /**
   * generated from use.counter.css.doc.css_font_variant_numeric
   */
  /**
   * Whether a document used the CSS property font-variant-numeric. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_font_variant_numeric(422);

  /**
   * generated from use.counter.css.doc.css_font_variant_position
   */
  /**
   * Whether a document used the CSS property font-variant-position. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_font_variant_position(423);

  /**
   * generated from use.counter.css.doc.css_font_variation_settings
   */
  /**
   * Whether a document used the CSS property font-variation-settings. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_font_variation_settings(424);

  /**
   * generated from use.counter.css.doc.css_font_weight
   */
  /**
   * Whether a document used the CSS property font-weight. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_font_weight(425);

  /**
   * generated from use.counter.css.doc.css_forced_color_adjust
   */
  /**
   * Whether a document used the CSS property forced-color-adjust. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_forced_color_adjust(426);

  /**
   * generated from use.counter.css.doc.css_gap
   */
  /**
   * Whether a document used the CSS property gap. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_gap(427);

  /**
   * generated from use.counter.css.doc.css_grid
   */
  /**
   * Whether a document used the CSS property grid. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_grid(428);

  /**
   * generated from use.counter.css.doc.css_grid_area
   */
  /**
   * Whether a document used the CSS property grid-area. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_grid_area(429);

  /**
   * generated from use.counter.css.doc.css_grid_auto_columns
   */
  /**
   * Whether a document used the CSS property grid-auto-columns. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_grid_auto_columns(430);

  /**
   * generated from use.counter.css.doc.css_grid_auto_flow
   */
  /**
   * Whether a document used the CSS property grid-auto-flow. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_grid_auto_flow(431);

  /**
   * generated from use.counter.css.doc.css_grid_auto_rows
   */
  /**
   * Whether a document used the CSS property grid-auto-rows. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_grid_auto_rows(432);

  /**
   * generated from use.counter.css.doc.css_grid_column
   */
  /**
   * Whether a document used the CSS property grid-column. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_grid_column(433);

  /**
   * generated from use.counter.css.doc.css_grid_column_end
   */
  /**
   * Whether a document used the CSS property grid-column-end. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_grid_column_end(434);

  /**
   * generated from use.counter.css.doc.css_grid_column_gap
   */
  /**
   * Whether a document used the CSS property grid-column-gap. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_grid_column_gap(435);

  /**
   * generated from use.counter.css.doc.css_grid_column_start
   */
  /**
   * Whether a document used the CSS property grid-column-start. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_grid_column_start(436);

  /**
   * generated from use.counter.css.doc.css_grid_gap
   */
  /**
   * Whether a document used the CSS property grid-gap. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_grid_gap(437);

  /**
   * generated from use.counter.css.doc.css_grid_row
   */
  /**
   * Whether a document used the CSS property grid-row. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_grid_row(438);

  /**
   * generated from use.counter.css.doc.css_grid_row_end
   */
  /**
   * Whether a document used the CSS property grid-row-end. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_grid_row_end(439);

  /**
   * generated from use.counter.css.doc.css_grid_row_gap
   */
  /**
   * Whether a document used the CSS property grid-row-gap. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_grid_row_gap(440);

  /**
   * generated from use.counter.css.doc.css_grid_row_start
   */
  /**
   * Whether a document used the CSS property grid-row-start. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_grid_row_start(441);

  /**
   * generated from use.counter.css.doc.css_grid_template
   */
  /**
   * Whether a document used the CSS property grid-template. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_grid_template(442);

  /**
   * generated from use.counter.css.doc.css_grid_template_areas
   */
  /**
   * Whether a document used the CSS property grid-template-areas. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_grid_template_areas(443);

  /**
   * generated from use.counter.css.doc.css_grid_template_columns
   */
  /**
   * Whether a document used the CSS property grid-template-columns. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_grid_template_columns(444);

  /**
   * generated from use.counter.css.doc.css_grid_template_rows
   */
  /**
   * Whether a document used the CSS property grid-template-rows. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_grid_template_rows(445);

  /**
   * generated from use.counter.css.doc.css_height
   */
  /**
   * Whether a document used the CSS property height. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_height(446);

  /**
   * generated from use.counter.css.doc.css_hyphenate_character
   */
  /**
   * Whether a document used the CSS property hyphenate-character. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_hyphenate_character(447);

  /**
   * generated from use.counter.css.doc.css_hyphens
   */
  /**
   * Whether a document used the CSS property hyphens. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_hyphens(448);

  /**
   * generated from use.counter.css.doc.css_image_orientation
   */
  /**
   * Whether a document used the CSS property image-orientation. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_image_orientation(449);

  /**
   * generated from use.counter.css.doc.css_image_rendering
   */
  /**
   * Whether a document used the CSS property image-rendering. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_image_rendering(450);

  /**
   * generated from use.counter.css.doc.css_ime_mode
   */
  /**
   * Whether a document used the CSS property ime-mode. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_ime_mode(451);

  /**
   * generated from use.counter.css.doc.css_initial_letter
   */
  /**
   * Whether a document used the CSS property initial-letter. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_initial_letter(452);

  /**
   * generated from use.counter.css.doc.css_inline_size
   */
  /**
   * Whether a document used the CSS property inline-size. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_inline_size(453);

  /**
   * generated from use.counter.css.doc.css_inset
   */
  /**
   * Whether a document used the CSS property inset. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_inset(454);

  /**
   * generated from use.counter.css.doc.css_inset_area
   */
  /**
   * Whether a document used the CSS property inset-area. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_inset_area(455);

  /**
   * generated from use.counter.css.doc.css_inset_block
   */
  /**
   * Whether a document used the CSS property inset-block. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_inset_block(456);

  /**
   * generated from use.counter.css.doc.css_inset_block_end
   */
  /**
   * Whether a document used the CSS property inset-block-end. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_inset_block_end(457);

  /**
   * generated from use.counter.css.doc.css_inset_block_start
   */
  /**
   * Whether a document used the CSS property inset-block-start. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_inset_block_start(458);

  /**
   * generated from use.counter.css.doc.css_inset_inline
   */
  /**
   * Whether a document used the CSS property inset-inline. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_inset_inline(459);

  /**
   * generated from use.counter.css.doc.css_inset_inline_end
   */
  /**
   * Whether a document used the CSS property inset-inline-end. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_inset_inline_end(460);

  /**
   * generated from use.counter.css.doc.css_inset_inline_start
   */
  /**
   * Whether a document used the CSS property inset-inline-start. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_inset_inline_start(461);

  /**
   * generated from use.counter.css.doc.css_isolation
   */
  /**
   * Whether a document used the CSS property isolation. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_isolation(462);

  /**
   * generated from use.counter.css.doc.css_justify_content
   */
  /**
   * Whether a document used the CSS property justify-content. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_justify_content(463);

  /**
   * generated from use.counter.css.doc.css_justify_items
   */
  /**
   * Whether a document used the CSS property justify-items. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_justify_items(464);

  /**
   * generated from use.counter.css.doc.css_justify_self
   */
  /**
   * Whether a document used the CSS property justify-self. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_justify_self(465);

  /**
   * generated from use.counter.css.doc.css_left
   */
  /**
   * Whether a document used the CSS property left. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_left(466);

  /**
   * generated from use.counter.css.doc.css_letter_spacing
   */
  /**
   * Whether a document used the CSS property letter-spacing. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_letter_spacing(467);

  /**
   * generated from use.counter.css.doc.css_lighting_color
   */
  /**
   * Whether a document used the CSS property lighting-color. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_lighting_color(468);

  /**
   * generated from use.counter.css.doc.css_line_break
   */
  /**
   * Whether a document used the CSS property line-break. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_line_break(469);

  /**
   * generated from use.counter.css.doc.css_line_height
   */
  /**
   * Whether a document used the CSS property line-height. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_line_height(470);

  /**
   * generated from use.counter.css.doc.css_list_style
   */
  /**
   * Whether a document used the CSS property list-style. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_list_style(471);

  /**
   * generated from use.counter.css.doc.css_list_style_image
   */
  /**
   * Whether a document used the CSS property list-style-image. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_list_style_image(472);

  /**
   * generated from use.counter.css.doc.css_list_style_position
   */
  /**
   * Whether a document used the CSS property list-style-position. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_list_style_position(473);

  /**
   * generated from use.counter.css.doc.css_list_style_type
   */
  /**
   * Whether a document used the CSS property list-style-type. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_list_style_type(474);

  /**
   * generated from use.counter.css.doc.css_margin
   */
  /**
   * Whether a document used the CSS property margin. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_margin(475);

  /**
   * generated from use.counter.css.doc.css_margin_block
   */
  /**
   * Whether a document used the CSS property margin-block. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_margin_block(476);

  /**
   * generated from use.counter.css.doc.css_margin_block_end
   */
  /**
   * Whether a document used the CSS property margin-block-end. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_margin_block_end(477);

  /**
   * generated from use.counter.css.doc.css_margin_block_start
   */
  /**
   * Whether a document used the CSS property margin-block-start. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_margin_block_start(478);

  /**
   * generated from use.counter.css.doc.css_margin_bottom
   */
  /**
   * Whether a document used the CSS property margin-bottom. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_margin_bottom(479);

  /**
   * generated from use.counter.css.doc.css_margin_inline
   */
  /**
   * Whether a document used the CSS property margin-inline. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_margin_inline(480);

  /**
   * generated from use.counter.css.doc.css_margin_inline_end
   */
  /**
   * Whether a document used the CSS property margin-inline-end. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_margin_inline_end(481);

  /**
   * generated from use.counter.css.doc.css_margin_inline_start
   */
  /**
   * Whether a document used the CSS property margin-inline-start. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_margin_inline_start(482);

  /**
   * generated from use.counter.css.doc.css_margin_left
   */
  /**
   * Whether a document used the CSS property margin-left. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_margin_left(483);

  /**
   * generated from use.counter.css.doc.css_margin_right
   */
  /**
   * Whether a document used the CSS property margin-right. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_margin_right(484);

  /**
   * generated from use.counter.css.doc.css_margin_top
   */
  /**
   * Whether a document used the CSS property margin-top. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_margin_top(485);

  /**
   * generated from use.counter.css.doc.css_marker
   */
  /**
   * Whether a document used the CSS property marker. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_marker(486);

  /**
   * generated from use.counter.css.doc.css_marker_end
   */
  /**
   * Whether a document used the CSS property marker-end. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_marker_end(487);

  /**
   * generated from use.counter.css.doc.css_marker_mid
   */
  /**
   * Whether a document used the CSS property marker-mid. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_marker_mid(488);

  /**
   * generated from use.counter.css.doc.css_marker_start
   */
  /**
   * Whether a document used the CSS property marker-start. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_marker_start(489);

  /**
   * generated from use.counter.css.doc.css_mask
   */
  /**
   * Whether a document used the CSS property mask. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_mask(490);

  /**
   * generated from use.counter.css.doc.css_mask_clip
   */
  /**
   * Whether a document used the CSS property mask-clip. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_mask_clip(491);

  /**
   * generated from use.counter.css.doc.css_mask_composite
   */
  /**
   * Whether a document used the CSS property mask-composite. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_mask_composite(492);

  /**
   * generated from use.counter.css.doc.css_mask_image
   */
  /**
   * Whether a document used the CSS property mask-image. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_mask_image(493);

  /**
   * generated from use.counter.css.doc.css_mask_mode
   */
  /**
   * Whether a document used the CSS property mask-mode. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_mask_mode(494);

  /**
   * generated from use.counter.css.doc.css_mask_origin
   */
  /**
   * Whether a document used the CSS property mask-origin. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_mask_origin(495);

  /**
   * generated from use.counter.css.doc.css_mask_position
   */
  /**
   * Whether a document used the CSS property mask-position. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_mask_position(496);

  /**
   * generated from use.counter.css.doc.css_mask_position_x
   */
  /**
   * Whether a document used the CSS property mask-position-x. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_mask_position_x(497);

  /**
   * generated from use.counter.css.doc.css_mask_position_y
   */
  /**
   * Whether a document used the CSS property mask-position-y. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_mask_position_y(498);

  /**
   * generated from use.counter.css.doc.css_mask_repeat
   */
  /**
   * Whether a document used the CSS property mask-repeat. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_mask_repeat(499);

  /**
   * generated from use.counter.css.doc.css_mask_size
   */
  /**
   * Whether a document used the CSS property mask-size. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_mask_size(500);

  /**
   * generated from use.counter.css.doc.css_mask_type
   */
  /**
   * Whether a document used the CSS property mask-type. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_mask_type(501);

  /**
   * generated from use.counter.css.doc.css_masonry_auto_flow
   */
  /**
   * Whether a document used the CSS property masonry-auto-flow. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_masonry_auto_flow(502);

  /**
   * generated from use.counter.css.doc.css_math_depth
   */
  /**
   * Whether a document used the CSS property math-depth. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_math_depth(503);

  /**
   * generated from use.counter.css.doc.css_math_style
   */
  /**
   * Whether a document used the CSS property math-style. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_math_style(504);

  /**
   * generated from use.counter.css.doc.css_max_block_size
   */
  /**
   * Whether a document used the CSS property max-block-size. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_max_block_size(505);

  /**
   * generated from use.counter.css.doc.css_max_height
   */
  /**
   * Whether a document used the CSS property max-height. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_max_height(506);

  /**
   * generated from use.counter.css.doc.css_max_inline_size
   */
  /**
   * Whether a document used the CSS property max-inline-size. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_max_inline_size(507);

  /**
   * generated from use.counter.css.doc.css_max_width
   */
  /**
   * Whether a document used the CSS property max-width. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_max_width(508);

  /**
   * generated from use.counter.css.doc.css_min_block_size
   */
  /**
   * Whether a document used the CSS property min-block-size. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_min_block_size(509);

  /**
   * generated from use.counter.css.doc.css_min_height
   */
  /**
   * Whether a document used the CSS property min-height. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_min_height(510);

  /**
   * generated from use.counter.css.doc.css_min_inline_size
   */
  /**
   * Whether a document used the CSS property min-inline-size. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_min_inline_size(511);

  /**
   * generated from use.counter.css.doc.css_min_width
   */
  /**
   * Whether a document used the CSS property min-width. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_min_width(512);

  /**
   * generated from use.counter.css.doc.css_mix_blend_mode
   */
  /**
   * Whether a document used the CSS property mix-blend-mode. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_mix_blend_mode(513);

  /**
   * generated from use.counter.css.doc.css_moz_animation
   */
  /**
   * Whether a document used the CSS property -moz-animation. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_animation(514);

  /**
   * generated from use.counter.css.doc.css_moz_animation_delay
   */
  /**
   * Whether a document used the CSS property -moz-animation-delay. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_animation_delay(515);

  /**
   * generated from use.counter.css.doc.css_moz_animation_direction
   */
  /**
   * Whether a document used the CSS property -moz-animation-direction. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_animation_direction(516);

  /**
   * generated from use.counter.css.doc.css_moz_animation_duration
   */
  /**
   * Whether a document used the CSS property -moz-animation-duration. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_animation_duration(517);

  /**
   * generated from use.counter.css.doc.css_moz_animation_fill_mode
   */
  /**
   * Whether a document used the CSS property -moz-animation-fill-mode. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_animation_fill_mode(518);

  /**
   * generated from use.counter.css.doc.css_moz_animation_iteration_count
   */
  /**
   * Whether a document used the CSS property -moz-animation-iteration-count.
     * Compare against `use.counter.content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric css_moz_animation_iteration_count(519);

  /**
   * generated from use.counter.css.doc.css_moz_animation_name
   */
  /**
   * Whether a document used the CSS property -moz-animation-name. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_animation_name(520);

  /**
   * generated from use.counter.css.doc.css_moz_animation_play_state
   */
  /**
   * Whether a document used the CSS property -moz-animation-play-state. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_animation_play_state(521);

  /**
   * generated from use.counter.css.doc.css_moz_animation_timing_function
   */
  /**
   * Whether a document used the CSS property -moz-animation-timing-function.
     * Compare against `use.counter.content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric css_moz_animation_timing_function(522);

  /**
   * generated from use.counter.css.doc.css_moz_appearance
   */
  /**
   * Whether a document used the CSS property -moz-appearance. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_appearance(523);

  /**
   * generated from use.counter.css.doc.css_moz_backface_visibility
   */
  /**
   * Whether a document used the CSS property -moz-backface-visibility. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_backface_visibility(524);

  /**
   * generated from use.counter.css.doc.css_moz_border_end
   */
  /**
   * Whether a document used the CSS property -moz-border-end. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_border_end(525);

  /**
   * generated from use.counter.css.doc.css_moz_border_end_color
   */
  /**
   * Whether a document used the CSS property -moz-border-end-color. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_border_end_color(526);

  /**
   * generated from use.counter.css.doc.css_moz_border_end_style
   */
  /**
   * Whether a document used the CSS property -moz-border-end-style. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_border_end_style(527);

  /**
   * generated from use.counter.css.doc.css_moz_border_end_width
   */
  /**
   * Whether a document used the CSS property -moz-border-end-width. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_border_end_width(528);

  /**
   * generated from use.counter.css.doc.css_moz_border_image
   */
  /**
   * Whether a document used the CSS property -moz-border-image. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_border_image(529);

  /**
   * generated from use.counter.css.doc.css_moz_border_start
   */
  /**
   * Whether a document used the CSS property -moz-border-start. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_border_start(530);

  /**
   * generated from use.counter.css.doc.css_moz_border_start_color
   */
  /**
   * Whether a document used the CSS property -moz-border-start-color. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_border_start_color(531);

  /**
   * generated from use.counter.css.doc.css_moz_border_start_style
   */
  /**
   * Whether a document used the CSS property -moz-border-start-style. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_border_start_style(532);

  /**
   * generated from use.counter.css.doc.css_moz_border_start_width
   */
  /**
   * Whether a document used the CSS property -moz-border-start-width. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_border_start_width(533);

  /**
   * generated from use.counter.css.doc.css_moz_box_align
   */
  /**
   * Whether a document used the CSS property -moz-box-align. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_box_align(534);

  /**
   * generated from use.counter.css.doc.css_moz_box_collapse
   */
  /**
   * Whether a document used the CSS property -moz-box-collapse. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_box_collapse(535);

  /**
   * generated from use.counter.css.doc.css_moz_box_direction
   */
  /**
   * Whether a document used the CSS property -moz-box-direction. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_box_direction(536);

  /**
   * generated from use.counter.css.doc.css_moz_box_flex
   */
  /**
   * Whether a document used the CSS property -moz-box-flex. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_box_flex(537);

  /**
   * generated from use.counter.css.doc.css_moz_box_ordinal_group
   */
  /**
   * Whether a document used the CSS property -moz-box-ordinal-group. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_box_ordinal_group(538);

  /**
   * generated from use.counter.css.doc.css_moz_box_orient
   */
  /**
   * Whether a document used the CSS property -moz-box-orient. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_box_orient(539);

  /**
   * generated from use.counter.css.doc.css_moz_box_pack
   */
  /**
   * Whether a document used the CSS property -moz-box-pack. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_box_pack(540);

  /**
   * generated from use.counter.css.doc.css_moz_box_sizing
   */
  /**
   * Whether a document used the CSS property -moz-box-sizing. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_box_sizing(541);

  /**
   * generated from use.counter.css.doc.css_moz_context_properties
   */
  /**
   * Whether a document used the CSS property -moz-context-properties. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_context_properties(542);

  /**
   * generated from use.counter.css.doc.css_moz_control_character_visibility
   */
  /**
   * Whether a document used the CSS property -moz-control-character-visibility.
     * Compare against `use.counter.content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric css_moz_control_character_visibility(543);

  /**
   * generated from use.counter.css.doc.css_moz_default_appearance
   */
  /**
   * Whether a document used the CSS property -moz-default-appearance. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_default_appearance(544);

  /**
   * generated from use.counter.css.doc.css_moz_float_edge
   */
  /**
   * Whether a document used the CSS property -moz-float-edge. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_float_edge(545);

  /**
   * generated from use.counter.css.doc.css_moz_font_feature_settings
   */
  /**
   * Whether a document used the CSS property -moz-font-feature-settings. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_font_feature_settings(546);

  /**
   * generated from use.counter.css.doc.css_moz_font_language_override
   */
  /**
   * Whether a document used the CSS property -moz-font-language-override. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_font_language_override(547);

  /**
   * generated from use.counter.css.doc.css_moz_force_broken_image_icon
   */
  /**
   * Whether a document used the CSS property -moz-force-broken-image-icon. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_force_broken_image_icon(548);

  /**
   * generated from use.counter.css.doc.css_moz_hyphens
   */
  /**
   * Whether a document used the CSS property -moz-hyphens. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_hyphens(549);

  /**
   * generated from use.counter.css.doc.css_moz_inert
   */
  /**
   * Whether a document used the CSS property -moz-inert. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_inert(550);

  /**
   * generated from use.counter.css.doc.css_moz_margin_end
   */
  /**
   * Whether a document used the CSS property -moz-margin-end. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_margin_end(551);

  /**
   * generated from use.counter.css.doc.css_moz_margin_start
   */
  /**
   * Whether a document used the CSS property -moz-margin-start. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_margin_start(552);

  /**
   * generated from use.counter.css.doc.css_moz_math_variant
   */
  /**
   * Whether a document used the CSS property -moz-math-variant. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_math_variant(553);

  /**
   * generated from use.counter.css.doc.css_moz_min_font_size_ratio
   */
  /**
   * Whether a document used the CSS property -moz-min-font-size-ratio. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_min_font_size_ratio(554);

  /**
   * generated from use.counter.css.doc.css_moz_orient
   */
  /**
   * Whether a document used the CSS property -moz-orient. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_orient(555);

  /**
   * generated from use.counter.css.doc.css_moz_osx_font_smoothing
   */
  /**
   * Whether a document used the CSS property -moz-osx-font-smoothing. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_osx_font_smoothing(556);

  /**
   * generated from use.counter.css.doc.css_moz_padding_end
   */
  /**
   * Whether a document used the CSS property -moz-padding-end. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_padding_end(557);

  /**
   * generated from use.counter.css.doc.css_moz_padding_start
   */
  /**
   * Whether a document used the CSS property -moz-padding-start. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_padding_start(558);

  /**
   * generated from use.counter.css.doc.css_moz_perspective
   */
  /**
   * Whether a document used the CSS property -moz-perspective. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_perspective(559);

  /**
   * generated from use.counter.css.doc.css_moz_perspective_origin
   */
  /**
   * Whether a document used the CSS property -moz-perspective-origin. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_perspective_origin(560);

  /**
   * generated from use.counter.css.doc.css_moz_subtree_hidden_only_visually
   */
  /**
   * Whether a document used the CSS property -moz-subtree-hidden-only-visually.
     * Compare against `use.counter.content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric css_moz_subtree_hidden_only_visually(561);

  /**
   * generated from use.counter.css.doc.css_moz_tab_size
   */
  /**
   * Whether a document used the CSS property -moz-tab-size. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_tab_size(562);

  /**
   * generated from use.counter.css.doc.css_moz_text_size_adjust
   */
  /**
   * Whether a document used the CSS property -moz-text-size-adjust. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_text_size_adjust(563);

  /**
   * generated from use.counter.css.doc.css_moz_theme
   */
  /**
   * Whether a document used the CSS property -moz-theme. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_theme(564);

  /**
   * generated from use.counter.css.doc.css_moz_top_layer
   */
  /**
   * Whether a document used the CSS property -moz-top-layer. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_top_layer(565);

  /**
   * generated from use.counter.css.doc.css_moz_transform
   */
  /**
   * Whether a document used the CSS property -moz-transform. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_transform(566);

  /**
   * generated from use.counter.css.doc.css_moz_transform_origin
   */
  /**
   * Whether a document used the CSS property -moz-transform-origin. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_transform_origin(567);

  /**
   * generated from use.counter.css.doc.css_moz_transform_style
   */
  /**
   * Whether a document used the CSS property -moz-transform-style. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_transform_style(568);

  /**
   * generated from use.counter.css.doc.css_moz_transition
   */
  /**
   * Whether a document used the CSS property -moz-transition. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_transition(569);

  /**
   * generated from use.counter.css.doc.css_moz_transition_delay
   */
  /**
   * Whether a document used the CSS property -moz-transition-delay. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_transition_delay(570);

  /**
   * generated from use.counter.css.doc.css_moz_transition_duration
   */
  /**
   * Whether a document used the CSS property -moz-transition-duration. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_transition_duration(571);

  /**
   * generated from use.counter.css.doc.css_moz_transition_property
   */
  /**
   * Whether a document used the CSS property -moz-transition-property. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_transition_property(572);

  /**
   * generated from use.counter.css.doc.css_moz_transition_timing_function
   */
  /**
   * Whether a document used the CSS property -moz-transition-timing-function.
     * Compare against `use.counter.content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric css_moz_transition_timing_function(573);

  /**
   * generated from use.counter.css.doc.css_moz_user_focus
   */
  /**
   * Whether a document used the CSS property -moz-user-focus. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_user_focus(574);

  /**
   * generated from use.counter.css.doc.css_moz_user_input
   */
  /**
   * Whether a document used the CSS property -moz-user-input. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_user_input(575);

  /**
   * generated from use.counter.css.doc.css_moz_user_modify
   */
  /**
   * Whether a document used the CSS property -moz-user-modify. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_user_modify(576);

  /**
   * generated from use.counter.css.doc.css_moz_user_select
   */
  /**
   * Whether a document used the CSS property -moz-user-select. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_user_select(577);

  /**
   * generated from use.counter.css.doc.css_moz_window_dragging
   */
  /**
   * Whether a document used the CSS property -moz-window-dragging. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_window_dragging(578);

  /**
   * generated from use.counter.css.doc.css_moz_window_input_region_margin
   */
  /**
   * Whether a document used the CSS property -moz-window-input-region-margin.
     * Compare against `use.counter.content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric css_moz_window_input_region_margin(579);

  /**
   * generated from use.counter.css.doc.css_moz_window_opacity
   */
  /**
   * Whether a document used the CSS property -moz-window-opacity. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_window_opacity(580);

  /**
   * generated from use.counter.css.doc.css_moz_window_shadow
   */
  /**
   * Whether a document used the CSS property -moz-window-shadow. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_window_shadow(581);

  /**
   * generated from use.counter.css.doc.css_moz_window_transform
   */
  /**
   * Whether a document used the CSS property -moz-window-transform. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_window_transform(582);

  /**
   * generated from use.counter.css.doc.css_moz_window_transform_origin
   */
  /**
   * Whether a document used the CSS property -moz-window-transform-origin. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_window_transform_origin(583);

  /**
   * generated from use.counter.css.doc.css_object_fit
   */
  /**
   * Whether a document used the CSS property object-fit. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_object_fit(584);

  /**
   * generated from use.counter.css.doc.css_object_position
   */
  /**
   * Whether a document used the CSS property object-position. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_object_position(585);

  /**
   * generated from use.counter.css.doc.css_offset
   */
  /**
   * Whether a document used the CSS property offset. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_offset(586);

  /**
   * generated from use.counter.css.doc.css_offset_anchor
   */
  /**
   * Whether a document used the CSS property offset-anchor. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_offset_anchor(587);

  /**
   * generated from use.counter.css.doc.css_offset_distance
   */
  /**
   * Whether a document used the CSS property offset-distance. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_offset_distance(588);

  /**
   * generated from use.counter.css.doc.css_offset_path
   */
  /**
   * Whether a document used the CSS property offset-path. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_offset_path(589);

  /**
   * generated from use.counter.css.doc.css_offset_position
   */
  /**
   * Whether a document used the CSS property offset-position. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_offset_position(590);

  /**
   * generated from use.counter.css.doc.css_offset_rotate
   */
  /**
   * Whether a document used the CSS property offset-rotate. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_offset_rotate(591);

  /**
   * generated from use.counter.css.doc.css_opacity
   */
  /**
   * Whether a document used the CSS property opacity. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_opacity(592);

  /**
   * generated from use.counter.css.doc.css_order
   */
  /**
   * Whether a document used the CSS property order. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_order(593);

  /**
   * generated from use.counter.css.doc.css_outline
   */
  /**
   * Whether a document used the CSS property outline. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_outline(594);

  /**
   * generated from use.counter.css.doc.css_outline_color
   */
  /**
   * Whether a document used the CSS property outline-color. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_outline_color(595);

  /**
   * generated from use.counter.css.doc.css_outline_offset
   */
  /**
   * Whether a document used the CSS property outline-offset. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_outline_offset(596);

  /**
   * generated from use.counter.css.doc.css_outline_style
   */
  /**
   * Whether a document used the CSS property outline-style. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_outline_style(597);

  /**
   * generated from use.counter.css.doc.css_outline_width
   */
  /**
   * Whether a document used the CSS property outline-width. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_outline_width(598);

  /**
   * generated from use.counter.css.doc.css_overflow
   */
  /**
   * Whether a document used the CSS property overflow. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_overflow(599);

  /**
   * generated from use.counter.css.doc.css_overflow_anchor
   */
  /**
   * Whether a document used the CSS property overflow-anchor. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_overflow_anchor(600);

  /**
   * generated from use.counter.css.doc.css_overflow_block
   */
  /**
   * Whether a document used the CSS property overflow-block. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_overflow_block(601);

  /**
   * generated from use.counter.css.doc.css_overflow_clip_box
   */
  /**
   * Whether a document used the CSS property overflow-clip-box. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_overflow_clip_box(602);

  /**
   * generated from use.counter.css.doc.css_overflow_clip_box_block
   */
  /**
   * Whether a document used the CSS property overflow-clip-box-block. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_overflow_clip_box_block(603);

  /**
   * generated from use.counter.css.doc.css_overflow_clip_box_inline
   */
  /**
   * Whether a document used the CSS property overflow-clip-box-inline. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_overflow_clip_box_inline(604);

  /**
   * generated from use.counter.css.doc.css_overflow_clip_margin
   */
  /**
   * Whether a document used the CSS property overflow-clip-margin. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_overflow_clip_margin(605);

  /**
   * generated from use.counter.css.doc.css_overflow_inline
   */
  /**
   * Whether a document used the CSS property overflow-inline. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_overflow_inline(606);

  /**
   * generated from use.counter.css.doc.css_overflow_wrap
   */
  /**
   * Whether a document used the CSS property overflow-wrap. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_overflow_wrap(607);

  /**
   * generated from use.counter.css.doc.css_overflow_x
   */
  /**
   * Whether a document used the CSS property overflow-x. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_overflow_x(608);

  /**
   * generated from use.counter.css.doc.css_overflow_y
   */
  /**
   * Whether a document used the CSS property overflow-y. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_overflow_y(609);

  /**
   * generated from use.counter.css.doc.css_overscroll_behavior
   */
  /**
   * Whether a document used the CSS property overscroll-behavior. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_overscroll_behavior(610);

  /**
   * generated from use.counter.css.doc.css_overscroll_behavior_block
   */
  /**
   * Whether a document used the CSS property overscroll-behavior-block. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_overscroll_behavior_block(611);

  /**
   * generated from use.counter.css.doc.css_overscroll_behavior_inline
   */
  /**
   * Whether a document used the CSS property overscroll-behavior-inline. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_overscroll_behavior_inline(612);

  /**
   * generated from use.counter.css.doc.css_overscroll_behavior_x
   */
  /**
   * Whether a document used the CSS property overscroll-behavior-x. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_overscroll_behavior_x(613);

  /**
   * generated from use.counter.css.doc.css_overscroll_behavior_y
   */
  /**
   * Whether a document used the CSS property overscroll-behavior-y. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_overscroll_behavior_y(614);

  /**
   * generated from use.counter.css.doc.css_padding
   */
  /**
   * Whether a document used the CSS property padding. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_padding(615);

  /**
   * generated from use.counter.css.doc.css_padding_block
   */
  /**
   * Whether a document used the CSS property padding-block. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_padding_block(616);

  /**
   * generated from use.counter.css.doc.css_padding_block_end
   */
  /**
   * Whether a document used the CSS property padding-block-end. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_padding_block_end(617);

  /**
   * generated from use.counter.css.doc.css_padding_block_start
   */
  /**
   * Whether a document used the CSS property padding-block-start. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_padding_block_start(618);

  /**
   * generated from use.counter.css.doc.css_padding_bottom
   */
  /**
   * Whether a document used the CSS property padding-bottom. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_padding_bottom(619);

  /**
   * generated from use.counter.css.doc.css_padding_inline
   */
  /**
   * Whether a document used the CSS property padding-inline. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_padding_inline(620);

  /**
   * generated from use.counter.css.doc.css_padding_inline_end
   */
  /**
   * Whether a document used the CSS property padding-inline-end. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_padding_inline_end(621);

  /**
   * generated from use.counter.css.doc.css_padding_inline_start
   */
  /**
   * Whether a document used the CSS property padding-inline-start. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_padding_inline_start(622);

  /**
   * generated from use.counter.css.doc.css_padding_left
   */
  /**
   * Whether a document used the CSS property padding-left. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_padding_left(623);

  /**
   * generated from use.counter.css.doc.css_padding_right
   */
  /**
   * Whether a document used the CSS property padding-right. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_padding_right(624);

  /**
   * generated from use.counter.css.doc.css_padding_top
   */
  /**
   * Whether a document used the CSS property padding-top. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_padding_top(625);

  /**
   * generated from use.counter.css.doc.css_page
   */
  /**
   * Whether a document used the CSS property page. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_page(626);

  /**
   * generated from use.counter.css.doc.css_page_break_after
   */
  /**
   * Whether a document used the CSS property page-break-after. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_page_break_after(627);

  /**
   * generated from use.counter.css.doc.css_page_break_before
   */
  /**
   * Whether a document used the CSS property page-break-before. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_page_break_before(628);

  /**
   * generated from use.counter.css.doc.css_page_break_inside
   */
  /**
   * Whether a document used the CSS property page-break-inside. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_page_break_inside(629);

  /**
   * generated from use.counter.css.doc.css_page_orientation
   */
  /**
   * Whether a document used the CSS property page-orientation. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_page_orientation(630);

  /**
   * generated from use.counter.css.doc.css_paint_order
   */
  /**
   * Whether a document used the CSS property paint-order. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_paint_order(631);

  /**
   * generated from use.counter.css.doc.css_perspective
   */
  /**
   * Whether a document used the CSS property perspective. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_perspective(632);

  /**
   * generated from use.counter.css.doc.css_perspective_origin
   */
  /**
   * Whether a document used the CSS property perspective-origin. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_perspective_origin(633);

  /**
   * generated from use.counter.css.doc.css_place_content
   */
  /**
   * Whether a document used the CSS property place-content. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_place_content(634);

  /**
   * generated from use.counter.css.doc.css_place_items
   */
  /**
   * Whether a document used the CSS property place-items. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_place_items(635);

  /**
   * generated from use.counter.css.doc.css_place_self
   */
  /**
   * Whether a document used the CSS property place-self. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_place_self(636);

  /**
   * generated from use.counter.css.doc.css_pointer_events
   */
  /**
   * Whether a document used the CSS property pointer-events. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_pointer_events(637);

  /**
   * generated from use.counter.css.doc.css_position
   */
  /**
   * Whether a document used the CSS property position. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_position(638);

  /**
   * generated from use.counter.css.doc.css_position_anchor
   */
  /**
   * Whether a document used the CSS property position-anchor. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_position_anchor(639);

  /**
   * generated from use.counter.css.doc.css_position_try_options
   */
  /**
   * Whether a document used the CSS property position-try-options. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_position_try_options(640);

  /**
   * generated from use.counter.css.doc.css_position_try_order
   */
  /**
   * Whether a document used the CSS property position-try-order. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_position_try_order(641);

  /**
   * generated from use.counter.css.doc.css_position_visibility
   */
  /**
   * Whether a document used the CSS property position-visibility. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_position_visibility(642);

  /**
   * generated from use.counter.css.doc.css_print_color_adjust
   */
  /**
   * Whether a document used the CSS property print-color-adjust. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_print_color_adjust(643);

  /**
   * generated from use.counter.css.doc.css_quotes
   */
  /**
   * Whether a document used the CSS property quotes. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_quotes(644);

  /**
   * generated from use.counter.css.doc.css_r
   */
  /**
   * Whether a document used the CSS property r. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_r(645);

  /**
   * generated from use.counter.css.doc.css_resize
   */
  /**
   * Whether a document used the CSS property resize. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_resize(646);

  /**
   * generated from use.counter.css.doc.css_right
   */
  /**
   * Whether a document used the CSS property right. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_right(647);

  /**
   * generated from use.counter.css.doc.css_rotate
   */
  /**
   * Whether a document used the CSS property rotate. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_rotate(648);

  /**
   * generated from use.counter.css.doc.css_row_gap
   */
  /**
   * Whether a document used the CSS property row-gap. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_row_gap(649);

  /**
   * generated from use.counter.css.doc.css_ruby_align
   */
  /**
   * Whether a document used the CSS property ruby-align. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_ruby_align(650);

  /**
   * generated from use.counter.css.doc.css_ruby_position
   */
  /**
   * Whether a document used the CSS property ruby-position. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_ruby_position(651);

  /**
   * generated from use.counter.css.doc.css_rx
   */
  /**
   * Whether a document used the CSS property rx. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_rx(652);

  /**
   * generated from use.counter.css.doc.css_ry
   */
  /**
   * Whether a document used the CSS property ry. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_ry(653);

  /**
   * generated from use.counter.css.doc.css_scale
   */
  /**
   * Whether a document used the CSS property scale. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scale(654);

  /**
   * generated from use.counter.css.doc.css_scroll_behavior
   */
  /**
   * Whether a document used the CSS property scroll-behavior. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scroll_behavior(655);

  /**
   * generated from use.counter.css.doc.css_scroll_margin
   */
  /**
   * Whether a document used the CSS property scroll-margin. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scroll_margin(656);

  /**
   * generated from use.counter.css.doc.css_scroll_margin_block
   */
  /**
   * Whether a document used the CSS property scroll-margin-block. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scroll_margin_block(657);

  /**
   * generated from use.counter.css.doc.css_scroll_margin_block_end
   */
  /**
   * Whether a document used the CSS property scroll-margin-block-end. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scroll_margin_block_end(658);

  /**
   * generated from use.counter.css.doc.css_scroll_margin_block_start
   */
  /**
   * Whether a document used the CSS property scroll-margin-block-start. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scroll_margin_block_start(659);

  /**
   * generated from use.counter.css.doc.css_scroll_margin_bottom
   */
  /**
   * Whether a document used the CSS property scroll-margin-bottom. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scroll_margin_bottom(660);

  /**
   * generated from use.counter.css.doc.css_scroll_margin_inline
   */
  /**
   * Whether a document used the CSS property scroll-margin-inline. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scroll_margin_inline(661);

  /**
   * generated from use.counter.css.doc.css_scroll_margin_inline_end
   */
  /**
   * Whether a document used the CSS property scroll-margin-inline-end. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scroll_margin_inline_end(662);

  /**
   * generated from use.counter.css.doc.css_scroll_margin_inline_start
   */
  /**
   * Whether a document used the CSS property scroll-margin-inline-start. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scroll_margin_inline_start(663);

  /**
   * generated from use.counter.css.doc.css_scroll_margin_left
   */
  /**
   * Whether a document used the CSS property scroll-margin-left. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scroll_margin_left(664);

  /**
   * generated from use.counter.css.doc.css_scroll_margin_right
   */
  /**
   * Whether a document used the CSS property scroll-margin-right. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scroll_margin_right(665);

  /**
   * generated from use.counter.css.doc.css_scroll_margin_top
   */
  /**
   * Whether a document used the CSS property scroll-margin-top. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scroll_margin_top(666);

  /**
   * generated from use.counter.css.doc.css_scroll_padding
   */
  /**
   * Whether a document used the CSS property scroll-padding. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scroll_padding(667);

  /**
   * generated from use.counter.css.doc.css_scroll_padding_block
   */
  /**
   * Whether a document used the CSS property scroll-padding-block. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scroll_padding_block(668);

  /**
   * generated from use.counter.css.doc.css_scroll_padding_block_end
   */
  /**
   * Whether a document used the CSS property scroll-padding-block-end. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scroll_padding_block_end(669);

  /**
   * generated from use.counter.css.doc.css_scroll_padding_block_start
   */
  /**
   * Whether a document used the CSS property scroll-padding-block-start. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scroll_padding_block_start(670);

  /**
   * generated from use.counter.css.doc.css_scroll_padding_bottom
   */
  /**
   * Whether a document used the CSS property scroll-padding-bottom. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scroll_padding_bottom(671);

  /**
   * generated from use.counter.css.doc.css_scroll_padding_inline
   */
  /**
   * Whether a document used the CSS property scroll-padding-inline. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scroll_padding_inline(672);

  /**
   * generated from use.counter.css.doc.css_scroll_padding_inline_end
   */
  /**
   * Whether a document used the CSS property scroll-padding-inline-end. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scroll_padding_inline_end(673);

  /**
   * generated from use.counter.css.doc.css_scroll_padding_inline_start
   */
  /**
   * Whether a document used the CSS property scroll-padding-inline-start. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scroll_padding_inline_start(674);

  /**
   * generated from use.counter.css.doc.css_scroll_padding_left
   */
  /**
   * Whether a document used the CSS property scroll-padding-left. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scroll_padding_left(675);

  /**
   * generated from use.counter.css.doc.css_scroll_padding_right
   */
  /**
   * Whether a document used the CSS property scroll-padding-right. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scroll_padding_right(676);

  /**
   * generated from use.counter.css.doc.css_scroll_padding_top
   */
  /**
   * Whether a document used the CSS property scroll-padding-top. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scroll_padding_top(677);

  /**
   * generated from use.counter.css.doc.css_scroll_snap_align
   */
  /**
   * Whether a document used the CSS property scroll-snap-align. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scroll_snap_align(678);

  /**
   * generated from use.counter.css.doc.css_scroll_snap_stop
   */
  /**
   * Whether a document used the CSS property scroll-snap-stop. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scroll_snap_stop(679);

  /**
   * generated from use.counter.css.doc.css_scroll_snap_type
   */
  /**
   * Whether a document used the CSS property scroll-snap-type. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scroll_snap_type(680);

  /**
   * generated from use.counter.css.doc.css_scroll_timeline
   */
  /**
   * Whether a document used the CSS property scroll-timeline. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scroll_timeline(681);

  /**
   * generated from use.counter.css.doc.css_scroll_timeline_axis
   */
  /**
   * Whether a document used the CSS property scroll-timeline-axis. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scroll_timeline_axis(682);

  /**
   * generated from use.counter.css.doc.css_scroll_timeline_name
   */
  /**
   * Whether a document used the CSS property scroll-timeline-name. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scroll_timeline_name(683);

  /**
   * generated from use.counter.css.doc.css_scrollbar_color
   */
  /**
   * Whether a document used the CSS property scrollbar-color. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scrollbar_color(684);

  /**
   * generated from use.counter.css.doc.css_scrollbar_gutter
   */
  /**
   * Whether a document used the CSS property scrollbar-gutter. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scrollbar_gutter(685);

  /**
   * generated from use.counter.css.doc.css_scrollbar_width
   */
  /**
   * Whether a document used the CSS property scrollbar-width. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scrollbar_width(686);

  /**
   * generated from use.counter.css.doc.css_shape_image_threshold
   */
  /**
   * Whether a document used the CSS property shape-image-threshold. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_shape_image_threshold(687);

  /**
   * generated from use.counter.css.doc.css_shape_margin
   */
  /**
   * Whether a document used the CSS property shape-margin. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_shape_margin(688);

  /**
   * generated from use.counter.css.doc.css_shape_outside
   */
  /**
   * Whether a document used the CSS property shape-outside. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_shape_outside(689);

  /**
   * generated from use.counter.css.doc.css_shape_rendering
   */
  /**
   * Whether a document used the CSS property shape-rendering. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_shape_rendering(690);

  /**
   * generated from use.counter.css.doc.css_size
   */
  /**
   * Whether a document used the CSS property size. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_size(691);

  /**
   * generated from use.counter.css.doc.css_stop_color
   */
  /**
   * Whether a document used the CSS property stop-color. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_stop_color(692);

  /**
   * generated from use.counter.css.doc.css_stop_opacity
   */
  /**
   * Whether a document used the CSS property stop-opacity. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_stop_opacity(693);

  /**
   * generated from use.counter.css.doc.css_stroke
   */
  /**
   * Whether a document used the CSS property stroke. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_stroke(694);

  /**
   * generated from use.counter.css.doc.css_stroke_dasharray
   */
  /**
   * Whether a document used the CSS property stroke-dasharray. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_stroke_dasharray(695);

  /**
   * generated from use.counter.css.doc.css_stroke_dashoffset
   */
  /**
   * Whether a document used the CSS property stroke-dashoffset. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_stroke_dashoffset(696);

  /**
   * generated from use.counter.css.doc.css_stroke_linecap
   */
  /**
   * Whether a document used the CSS property stroke-linecap. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_stroke_linecap(697);

  /**
   * generated from use.counter.css.doc.css_stroke_linejoin
   */
  /**
   * Whether a document used the CSS property stroke-linejoin. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_stroke_linejoin(698);

  /**
   * generated from use.counter.css.doc.css_stroke_miterlimit
   */
  /**
   * Whether a document used the CSS property stroke-miterlimit. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_stroke_miterlimit(699);

  /**
   * generated from use.counter.css.doc.css_stroke_opacity
   */
  /**
   * Whether a document used the CSS property stroke-opacity. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_stroke_opacity(700);

  /**
   * generated from use.counter.css.doc.css_stroke_width
   */
  /**
   * Whether a document used the CSS property stroke-width. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_stroke_width(701);

  /**
   * generated from use.counter.css.doc.css_tab_size
   */
  /**
   * Whether a document used the CSS property tab-size. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_tab_size(702);

  /**
   * generated from use.counter.css.doc.css_table_layout
   */
  /**
   * Whether a document used the CSS property table-layout. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_table_layout(703);

  /**
   * generated from use.counter.css.doc.css_text_align
   */
  /**
   * Whether a document used the CSS property text-align. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_text_align(704);

  /**
   * generated from use.counter.css.doc.css_text_align_last
   */
  /**
   * Whether a document used the CSS property text-align-last. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_text_align_last(705);

  /**
   * generated from use.counter.css.doc.css_text_anchor
   */
  /**
   * Whether a document used the CSS property text-anchor. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_text_anchor(706);

  /**
   * generated from use.counter.css.doc.css_text_combine_upright
   */
  /**
   * Whether a document used the CSS property text-combine-upright. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_text_combine_upright(707);

  /**
   * generated from use.counter.css.doc.css_text_decoration
   */
  /**
   * Whether a document used the CSS property text-decoration. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_text_decoration(708);

  /**
   * generated from use.counter.css.doc.css_text_decoration_color
   */
  /**
   * Whether a document used the CSS property text-decoration-color. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_text_decoration_color(709);

  /**
   * generated from use.counter.css.doc.css_text_decoration_line
   */
  /**
   * Whether a document used the CSS property text-decoration-line. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_text_decoration_line(710);

  /**
   * generated from use.counter.css.doc.css_text_decoration_skip_ink
   */
  /**
   * Whether a document used the CSS property text-decoration-skip-ink. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_text_decoration_skip_ink(711);

  /**
   * generated from use.counter.css.doc.css_text_decoration_style
   */
  /**
   * Whether a document used the CSS property text-decoration-style. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_text_decoration_style(712);

  /**
   * generated from use.counter.css.doc.css_text_decoration_thickness
   */
  /**
   * Whether a document used the CSS property text-decoration-thickness. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_text_decoration_thickness(713);

  /**
   * generated from use.counter.css.doc.css_text_emphasis
   */
  /**
   * Whether a document used the CSS property text-emphasis. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_text_emphasis(714);

  /**
   * generated from use.counter.css.doc.css_text_emphasis_color
   */
  /**
   * Whether a document used the CSS property text-emphasis-color. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_text_emphasis_color(715);

  /**
   * generated from use.counter.css.doc.css_text_emphasis_position
   */
  /**
   * Whether a document used the CSS property text-emphasis-position. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_text_emphasis_position(716);

  /**
   * generated from use.counter.css.doc.css_text_emphasis_style
   */
  /**
   * Whether a document used the CSS property text-emphasis-style. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_text_emphasis_style(717);

  /**
   * generated from use.counter.css.doc.css_text_indent
   */
  /**
   * Whether a document used the CSS property text-indent. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_text_indent(718);

  /**
   * generated from use.counter.css.doc.css_text_justify
   */
  /**
   * Whether a document used the CSS property text-justify. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_text_justify(719);

  /**
   * generated from use.counter.css.doc.css_text_orientation
   */
  /**
   * Whether a document used the CSS property text-orientation. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_text_orientation(720);

  /**
   * generated from use.counter.css.doc.css_text_overflow
   */
  /**
   * Whether a document used the CSS property text-overflow. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_text_overflow(721);

  /**
   * generated from use.counter.css.doc.css_text_rendering
   */
  /**
   * Whether a document used the CSS property text-rendering. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_text_rendering(722);

  /**
   * generated from use.counter.css.doc.css_text_shadow
   */
  /**
   * Whether a document used the CSS property text-shadow. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_text_shadow(723);

  /**
   * generated from use.counter.css.doc.css_text_transform
   */
  /**
   * Whether a document used the CSS property text-transform. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_text_transform(724);

  /**
   * generated from use.counter.css.doc.css_text_underline_offset
   */
  /**
   * Whether a document used the CSS property text-underline-offset. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_text_underline_offset(725);

  /**
   * generated from use.counter.css.doc.css_text_underline_position
   */
  /**
   * Whether a document used the CSS property text-underline-position. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_text_underline_position(726);

  /**
   * generated from use.counter.css.doc.css_text_wrap
   */
  /**
   * Whether a document used the CSS property text-wrap. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_text_wrap(727);

  /**
   * generated from use.counter.css.doc.css_text_wrap_mode
   */
  /**
   * Whether a document used the CSS property text-wrap-mode. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_text_wrap_mode(728);

  /**
   * generated from use.counter.css.doc.css_text_wrap_style
   */
  /**
   * Whether a document used the CSS property text-wrap-style. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_text_wrap_style(729);

  /**
   * generated from use.counter.css.doc.css_top
   */
  /**
   * Whether a document used the CSS property top. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_top(730);

  /**
   * generated from use.counter.css.doc.css_touch_action
   */
  /**
   * Whether a document used the CSS property touch-action. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_touch_action(731);

  /**
   * generated from use.counter.css.doc.css_transform
   */
  /**
   * Whether a document used the CSS property transform. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_transform(732);

  /**
   * generated from use.counter.css.doc.css_transform_box
   */
  /**
   * Whether a document used the CSS property transform-box. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_transform_box(733);

  /**
   * generated from use.counter.css.doc.css_transform_origin
   */
  /**
   * Whether a document used the CSS property transform-origin. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_transform_origin(734);

  /**
   * generated from use.counter.css.doc.css_transform_style
   */
  /**
   * Whether a document used the CSS property transform-style. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_transform_style(735);

  /**
   * generated from use.counter.css.doc.css_transition
   */
  /**
   * Whether a document used the CSS property transition. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_transition(736);

  /**
   * generated from use.counter.css.doc.css_transition_behavior
   */
  /**
   * Whether a document used the CSS property transition-behavior. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_transition_behavior(737);

  /**
   * generated from use.counter.css.doc.css_transition_delay
   */
  /**
   * Whether a document used the CSS property transition-delay. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_transition_delay(738);

  /**
   * generated from use.counter.css.doc.css_transition_duration
   */
  /**
   * Whether a document used the CSS property transition-duration. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_transition_duration(739);

  /**
   * generated from use.counter.css.doc.css_transition_property
   */
  /**
   * Whether a document used the CSS property transition-property. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_transition_property(740);

  /**
   * generated from use.counter.css.doc.css_transition_timing_function
   */
  /**
   * Whether a document used the CSS property transition-timing-function. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_transition_timing_function(741);

  /**
   * generated from use.counter.css.doc.css_translate
   */
  /**
   * Whether a document used the CSS property translate. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_translate(742);

  /**
   * generated from use.counter.css.doc.css_unicode_bidi
   */
  /**
   * Whether a document used the CSS property unicode-bidi. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_unicode_bidi(743);

  /**
   * generated from use.counter.css.doc.css_user_select
   */
  /**
   * Whether a document used the CSS property user-select. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_user_select(744);

  /**
   * generated from use.counter.css.doc.css_vector_effect
   */
  /**
   * Whether a document used the CSS property vector-effect. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_vector_effect(745);

  /**
   * generated from use.counter.css.doc.css_vertical_align
   */
  /**
   * Whether a document used the CSS property vertical-align. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_vertical_align(746);

  /**
   * generated from use.counter.css.doc.css_view_timeline
   */
  /**
   * Whether a document used the CSS property view-timeline. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_view_timeline(747);

  /**
   * generated from use.counter.css.doc.css_view_timeline_axis
   */
  /**
   * Whether a document used the CSS property view-timeline-axis. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_view_timeline_axis(748);

  /**
   * generated from use.counter.css.doc.css_view_timeline_inset
   */
  /**
   * Whether a document used the CSS property view-timeline-inset. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_view_timeline_inset(749);

  /**
   * generated from use.counter.css.doc.css_view_timeline_name
   */
  /**
   * Whether a document used the CSS property view-timeline-name. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_view_timeline_name(750);

  /**
   * generated from use.counter.css.doc.css_visibility
   */
  /**
   * Whether a document used the CSS property visibility. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_visibility(751);

  /**
   * generated from use.counter.css.doc.css_webkit_align_content
   */
  /**
   * Whether a document used the CSS property -webkit-align-content. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_align_content(752);

  /**
   * generated from use.counter.css.doc.css_webkit_align_items
   */
  /**
   * Whether a document used the CSS property -webkit-align-items. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_align_items(753);

  /**
   * generated from use.counter.css.doc.css_webkit_align_self
   */
  /**
   * Whether a document used the CSS property -webkit-align-self. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_align_self(754);

  /**
   * generated from use.counter.css.doc.css_webkit_animation
   */
  /**
   * Whether a document used the CSS property -webkit-animation. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_animation(755);

  /**
   * generated from use.counter.css.doc.css_webkit_animation_delay
   */
  /**
   * Whether a document used the CSS property -webkit-animation-delay. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_animation_delay(756);

  /**
   * generated from use.counter.css.doc.css_webkit_animation_direction
   */
  /**
   * Whether a document used the CSS property -webkit-animation-direction. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_animation_direction(757);

  /**
   * generated from use.counter.css.doc.css_webkit_animation_duration
   */
  /**
   * Whether a document used the CSS property -webkit-animation-duration. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_animation_duration(758);

  /**
   * generated from use.counter.css.doc.css_webkit_animation_fill_mode
   */
  /**
   * Whether a document used the CSS property -webkit-animation-fill-mode. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_animation_fill_mode(759);

  /**
   * generated from use.counter.css.doc.css_webkit_animation_iteration_count
   */
  /**
   * Whether a document used the CSS property -webkit-animation-iteration-count.
     * Compare against `use.counter.content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric css_webkit_animation_iteration_count(760);

  /**
   * generated from use.counter.css.doc.css_webkit_animation_name
   */
  /**
   * Whether a document used the CSS property -webkit-animation-name. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_animation_name(761);

  /**
   * generated from use.counter.css.doc.css_webkit_animation_play_state
   */
  /**
   * Whether a document used the CSS property -webkit-animation-play-state. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_animation_play_state(762);

  /**
   * generated from use.counter.css.doc.css_webkit_animation_timing_function
   */
  /**
   * Whether a document used the CSS property -webkit-animation-timing-function.
     * Compare against `use.counter.content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric css_webkit_animation_timing_function(763);

  /**
   * generated from use.counter.css.doc.css_webkit_appearance
   */
  /**
   * Whether a document used the CSS property -webkit-appearance. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_appearance(764);

  /**
   * generated from use.counter.css.doc.css_webkit_backface_visibility
   */
  /**
   * Whether a document used the CSS property -webkit-backface-visibility. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_backface_visibility(765);

  /**
   * generated from use.counter.css.doc.css_webkit_background_clip
   */
  /**
   * Whether a document used the CSS property -webkit-background-clip. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_background_clip(766);

  /**
   * generated from use.counter.css.doc.css_webkit_background_origin
   */
  /**
   * Whether a document used the CSS property -webkit-background-origin. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_background_origin(767);

  /**
   * generated from use.counter.css.doc.css_webkit_background_size
   */
  /**
   * Whether a document used the CSS property -webkit-background-size. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_background_size(768);

  /**
   * generated from use.counter.css.doc.css_webkit_border_bottom_left_radius
   */
  /**
   * Whether a document used the CSS property -webkit-border-bottom-left-radius.
     * Compare against `use.counter.content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric css_webkit_border_bottom_left_radius(769);

  /**
   * generated from use.counter.css.doc.css_webkit_border_bottom_right_radius
   */
  /**
   * Whether a document used the CSS property -webkit-border-bottom-right-radius.
     * Compare against `use.counter.content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric css_webkit_border_bottom_right_radius(770);

  /**
   * generated from use.counter.css.doc.css_webkit_border_image
   */
  /**
   * Whether a document used the CSS property -webkit-border-image. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_border_image(771);

  /**
   * generated from use.counter.css.doc.css_webkit_border_radius
   */
  /**
   * Whether a document used the CSS property -webkit-border-radius. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_border_radius(772);

  /**
   * generated from use.counter.css.doc.css_webkit_border_top_left_radius
   */
  /**
   * Whether a document used the CSS property -webkit-border-top-left-radius.
     * Compare against `use.counter.content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric css_webkit_border_top_left_radius(773);

  /**
   * generated from use.counter.css.doc.css_webkit_border_top_right_radius
   */
  /**
   * Whether a document used the CSS property -webkit-border-top-right-radius.
     * Compare against `use.counter.content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric css_webkit_border_top_right_radius(774);

  /**
   * generated from use.counter.css.doc.css_webkit_box_align
   */
  /**
   * Whether a document used the CSS property -webkit-box-align. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_box_align(775);

  /**
   * generated from use.counter.css.doc.css_webkit_box_direction
   */
  /**
   * Whether a document used the CSS property -webkit-box-direction. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_box_direction(776);

  /**
   * generated from use.counter.css.doc.css_webkit_box_flex
   */
  /**
   * Whether a document used the CSS property -webkit-box-flex. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_box_flex(777);

  /**
   * generated from use.counter.css.doc.css_webkit_box_ordinal_group
   */
  /**
   * Whether a document used the CSS property -webkit-box-ordinal-group. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_box_ordinal_group(778);

  /**
   * generated from use.counter.css.doc.css_webkit_box_orient
   */
  /**
   * Whether a document used the CSS property -webkit-box-orient. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_box_orient(779);

  /**
   * generated from use.counter.css.doc.css_webkit_box_pack
   */
  /**
   * Whether a document used the CSS property -webkit-box-pack. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_box_pack(780);

  /**
   * generated from use.counter.css.doc.css_webkit_box_shadow
   */
  /**
   * Whether a document used the CSS property -webkit-box-shadow. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_box_shadow(781);

  /**
   * generated from use.counter.css.doc.css_webkit_box_sizing
   */
  /**
   * Whether a document used the CSS property -webkit-box-sizing. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_box_sizing(782);

  /**
   * generated from use.counter.css.doc.css_webkit_clip_path
   */
  /**
   * Whether a document used the CSS property -webkit-clip-path. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_clip_path(783);

  /**
   * generated from use.counter.css.doc.css_webkit_filter
   */
  /**
   * Whether a document used the CSS property -webkit-filter. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_filter(784);

  /**
   * generated from use.counter.css.doc.css_webkit_flex
   */
  /**
   * Whether a document used the CSS property -webkit-flex. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_flex(785);

  /**
   * generated from use.counter.css.doc.css_webkit_flex_basis
   */
  /**
   * Whether a document used the CSS property -webkit-flex-basis. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_flex_basis(786);

  /**
   * generated from use.counter.css.doc.css_webkit_flex_direction
   */
  /**
   * Whether a document used the CSS property -webkit-flex-direction. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_flex_direction(787);

  /**
   * generated from use.counter.css.doc.css_webkit_flex_flow
   */
  /**
   * Whether a document used the CSS property -webkit-flex-flow. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_flex_flow(788);

  /**
   * generated from use.counter.css.doc.css_webkit_flex_grow
   */
  /**
   * Whether a document used the CSS property -webkit-flex-grow. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_flex_grow(789);

  /**
   * generated from use.counter.css.doc.css_webkit_flex_shrink
   */
  /**
   * Whether a document used the CSS property -webkit-flex-shrink. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_flex_shrink(790);

  /**
   * generated from use.counter.css.doc.css_webkit_flex_wrap
   */
  /**
   * Whether a document used the CSS property -webkit-flex-wrap. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_flex_wrap(791);

  /**
   * generated from use.counter.css.doc.css_webkit_font_smoothing
   */
  /**
   * Whether a document used the CSS property -webkit-font-smoothing. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_font_smoothing(792);

  /**
   * generated from use.counter.css.doc.css_webkit_justify_content
   */
  /**
   * Whether a document used the CSS property -webkit-justify-content. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_justify_content(793);

  /**
   * generated from use.counter.css.doc.css_webkit_line_clamp
   */
  /**
   * Whether a document used the CSS property -webkit-line-clamp. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_line_clamp(794);

  /**
   * generated from use.counter.css.doc.css_webkit_mask
   */
  /**
   * Whether a document used the CSS property -webkit-mask. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_mask(795);

  /**
   * generated from use.counter.css.doc.css_webkit_mask_clip
   */
  /**
   * Whether a document used the CSS property -webkit-mask-clip. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_mask_clip(796);

  /**
   * generated from use.counter.css.doc.css_webkit_mask_composite
   */
  /**
   * Whether a document used the CSS property -webkit-mask-composite. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_mask_composite(797);

  /**
   * generated from use.counter.css.doc.css_webkit_mask_image
   */
  /**
   * Whether a document used the CSS property -webkit-mask-image. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_mask_image(798);

  /**
   * generated from use.counter.css.doc.css_webkit_mask_origin
   */
  /**
   * Whether a document used the CSS property -webkit-mask-origin. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_mask_origin(799);

  /**
   * generated from use.counter.css.doc.css_webkit_mask_position
   */
  /**
   * Whether a document used the CSS property -webkit-mask-position. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_mask_position(800);

  /**
   * generated from use.counter.css.doc.css_webkit_mask_position_x
   */
  /**
   * Whether a document used the CSS property -webkit-mask-position-x. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_mask_position_x(801);

  /**
   * generated from use.counter.css.doc.css_webkit_mask_position_y
   */
  /**
   * Whether a document used the CSS property -webkit-mask-position-y. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_mask_position_y(802);

  /**
   * generated from use.counter.css.doc.css_webkit_mask_repeat
   */
  /**
   * Whether a document used the CSS property -webkit-mask-repeat. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_mask_repeat(803);

  /**
   * generated from use.counter.css.doc.css_webkit_mask_size
   */
  /**
   * Whether a document used the CSS property -webkit-mask-size. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_mask_size(804);

  /**
   * generated from use.counter.css.doc.css_webkit_order
   */
  /**
   * Whether a document used the CSS property -webkit-order. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_order(805);

  /**
   * generated from use.counter.css.doc.css_webkit_perspective
   */
  /**
   * Whether a document used the CSS property -webkit-perspective. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_perspective(806);

  /**
   * generated from use.counter.css.doc.css_webkit_perspective_origin
   */
  /**
   * Whether a document used the CSS property -webkit-perspective-origin. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_perspective_origin(807);

  /**
   * generated from use.counter.css.doc.css_webkit_text_fill_color
   */
  /**
   * Whether a document used the CSS property -webkit-text-fill-color. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_text_fill_color(808);

  /**
   * generated from use.counter.css.doc.css_webkit_text_security
   */
  /**
   * Whether a document used the CSS property -webkit-text-security. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_text_security(809);

  /**
   * generated from use.counter.css.doc.css_webkit_text_size_adjust
   */
  /**
   * Whether a document used the CSS property -webkit-text-size-adjust. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_text_size_adjust(810);

  /**
   * generated from use.counter.css.doc.css_webkit_text_stroke
   */
  /**
   * Whether a document used the CSS property -webkit-text-stroke. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_text_stroke(811);

  /**
   * generated from use.counter.css.doc.css_webkit_text_stroke_color
   */
  /**
   * Whether a document used the CSS property -webkit-text-stroke-color. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_text_stroke_color(812);

  /**
   * generated from use.counter.css.doc.css_webkit_text_stroke_width
   */
  /**
   * Whether a document used the CSS property -webkit-text-stroke-width. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_text_stroke_width(813);

  /**
   * generated from use.counter.css.doc.css_webkit_transform
   */
  /**
   * Whether a document used the CSS property -webkit-transform. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_transform(814);

  /**
   * generated from use.counter.css.doc.css_webkit_transform_origin
   */
  /**
   * Whether a document used the CSS property -webkit-transform-origin. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_transform_origin(815);

  /**
   * generated from use.counter.css.doc.css_webkit_transform_style
   */
  /**
   * Whether a document used the CSS property -webkit-transform-style. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_transform_style(816);

  /**
   * generated from use.counter.css.doc.css_webkit_transition
   */
  /**
   * Whether a document used the CSS property -webkit-transition. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_transition(817);

  /**
   * generated from use.counter.css.doc.css_webkit_transition_delay
   */
  /**
   * Whether a document used the CSS property -webkit-transition-delay. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_transition_delay(818);

  /**
   * generated from use.counter.css.doc.css_webkit_transition_duration
   */
  /**
   * Whether a document used the CSS property -webkit-transition-duration. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_transition_duration(819);

  /**
   * generated from use.counter.css.doc.css_webkit_transition_property
   */
  /**
   * Whether a document used the CSS property -webkit-transition-property. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_transition_property(820);

  /**
   * generated from use.counter.css.doc.css_webkit_transition_timing_function
   */
  /**
   * Whether a document used the CSS property -webkit-transition-timing-function.
     * Compare against `use.counter.content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric css_webkit_transition_timing_function(821);

  /**
   * generated from use.counter.css.doc.css_webkit_user_select
   */
  /**
   * Whether a document used the CSS property -webkit-user-select. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_user_select(822);

  /**
   * generated from use.counter.css.doc.css_white_space
   */
  /**
   * Whether a document used the CSS property white-space. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_white_space(823);

  /**
   * generated from use.counter.css.doc.css_white_space_collapse
   */
  /**
   * Whether a document used the CSS property white-space-collapse. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_white_space_collapse(824);

  /**
   * generated from use.counter.css.doc.css_width
   */
  /**
   * Whether a document used the CSS property width. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_width(825);

  /**
   * generated from use.counter.css.doc.css_will_change
   */
  /**
   * Whether a document used the CSS property will-change. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_will_change(826);

  /**
   * generated from use.counter.css.doc.css_word_break
   */
  /**
   * Whether a document used the CSS property word-break. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_word_break(827);

  /**
   * generated from use.counter.css.doc.css_word_spacing
   */
  /**
   * Whether a document used the CSS property word-spacing. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_word_spacing(828);

  /**
   * generated from use.counter.css.doc.css_word_wrap
   */
  /**
   * Whether a document used the CSS property word-wrap. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_word_wrap(829);

  /**
   * generated from use.counter.css.doc.css_writing_mode
   */
  /**
   * Whether a document used the CSS property writing-mode. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_writing_mode(830);

  /**
   * generated from use.counter.css.doc.css_x
   */
  /**
   * Whether a document used the CSS property x. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_x(831);

  /**
   * generated from use.counter.css.doc.css_x_lang
   */
  /**
   * Whether a document used the CSS property -x-lang. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_x_lang(832);

  /**
   * generated from use.counter.css.doc.css_x_span
   */
  /**
   * Whether a document used the CSS property -x-span. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_x_span(833);

  /**
   * generated from use.counter.css.doc.css_x_text_scale
   */
  /**
   * Whether a document used the CSS property -x-text-scale. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_x_text_scale(834);

  /**
   * generated from use.counter.css.doc.css_y
   */
  /**
   * Whether a document used the CSS property y. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_y(835);

  /**
   * generated from use.counter.css.doc.css_z_index
   */
  /**
   * Whether a document used the CSS property z-index. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_z_index(836);

  /**
   * generated from use.counter.css.doc.css_zoom
   */
  /**
   * Whether a document used the CSS property zoom. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_zoom(837);

  /**
   * generated from use.counter.css.doc.max_zoom
   */
  /**
   * Whether a document used the (unknown, counted) CSS property max-zoom. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric max_zoom(838);

  /**
   * generated from use.counter.css.doc.min_zoom
   */
  /**
   * Whether a document used the (unknown, counted) CSS property min-zoom. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric min_zoom(839);

  /**
   * generated from use.counter.css.doc.orientation
   */
  /**
   * Whether a document used the (unknown, counted) CSS property orientation.
     * Compare against `use.counter.content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric orientation(840);

  /**
   * generated from use.counter.css.doc.orphans
   */
  /**
   * Whether a document used the (unknown, counted) CSS property orphans. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric orphans(841);

  /**
   * generated from use.counter.css.doc.speak
   */
  /**
   * Whether a document used the (unknown, counted) CSS property speak. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric speak(842);

  /**
   * generated from use.counter.css.doc.text_size_adjust
   */
  /**
   * Whether a document used the (unknown, counted) CSS property text-size-adjust.
     * Compare against `use.counter.content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric text_size_adjust(843);

  /**
   * generated from use.counter.css.doc.user_zoom
   */
  /**
   * Whether a document used the (unknown, counted) CSS property user-zoom. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric user_zoom(844);

  /**
   * generated from use.counter.css.doc.webkit_app_region
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-app-region.
     * Compare against `use.counter.content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric webkit_app_region(845);

  /**
   * generated from use.counter.css.doc.webkit_border_after
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-border-
     * after. Compare against `use.counter.content_documents_destroyed` to calculate
     * the rate.
   */
  constexpr impl::CounterMetric webkit_border_after(846);

  /**
   * generated from use.counter.css.doc.webkit_border_after_color
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-border-
     * after-color. Compare against `use.counter.content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_border_after_color(847);

  /**
   * generated from use.counter.css.doc.webkit_border_after_style
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-border-
     * after-style. Compare against `use.counter.content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_border_after_style(848);

  /**
   * generated from use.counter.css.doc.webkit_border_after_width
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-border-
     * after-width. Compare against `use.counter.content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_border_after_width(849);

  /**
   * generated from use.counter.css.doc.webkit_border_before
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-border-
     * before. Compare against `use.counter.content_documents_destroyed` to calculate
     * the rate.
   */
  constexpr impl::CounterMetric webkit_border_before(850);

  /**
   * generated from use.counter.css.doc.webkit_border_before_color
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-border-
     * before-color. Compare against `use.counter.content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_border_before_color(851);

  /**
   * generated from use.counter.css.doc.webkit_border_before_style
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-border-
     * before-style. Compare against `use.counter.content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_border_before_style(852);

  /**
   * generated from use.counter.css.doc.webkit_border_before_width
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-border-
     * before-width. Compare against `use.counter.content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_border_before_width(853);

  /**
   * generated from use.counter.css.doc.webkit_border_end
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-border-end.
     * Compare against `use.counter.content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric webkit_border_end(854);

  /**
   * generated from use.counter.css.doc.webkit_border_end_color
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-border-end-
     * color. Compare against `use.counter.content_documents_destroyed` to calculate
     * the rate.
   */
  constexpr impl::CounterMetric webkit_border_end_color(855);

  /**
   * generated from use.counter.css.doc.webkit_border_end_style
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-border-end-
     * style. Compare against `use.counter.content_documents_destroyed` to calculate
     * the rate.
   */
  constexpr impl::CounterMetric webkit_border_end_style(856);

  /**
   * generated from use.counter.css.doc.webkit_border_end_width
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-border-end-
     * width. Compare against `use.counter.content_documents_destroyed` to calculate
     * the rate.
   */
  constexpr impl::CounterMetric webkit_border_end_width(857);

  /**
   * generated from use.counter.css.doc.webkit_border_horizontal_spacing
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-border-
     * horizontal-spacing. Compare against `use.counter.content_documents_destroyed`
     * to calculate the rate.
   */
  constexpr impl::CounterMetric webkit_border_horizontal_spacing(858);

  /**
   * generated from use.counter.css.doc.webkit_border_start
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-border-
     * start. Compare against `use.counter.content_documents_destroyed` to calculate
     * the rate.
   */
  constexpr impl::CounterMetric webkit_border_start(859);

  /**
   * generated from use.counter.css.doc.webkit_border_start_color
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-border-
     * start-color. Compare against `use.counter.content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_border_start_color(860);

  /**
   * generated from use.counter.css.doc.webkit_border_start_style
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-border-
     * start-style. Compare against `use.counter.content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_border_start_style(861);

  /**
   * generated from use.counter.css.doc.webkit_border_start_width
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-border-
     * start-width. Compare against `use.counter.content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_border_start_width(862);

  /**
   * generated from use.counter.css.doc.webkit_border_vertical_spacing
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-border-
     * vertical-spacing. Compare against `use.counter.content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_border_vertical_spacing(863);

  /**
   * generated from use.counter.css.doc.webkit_box_decoration_break
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-box-
     * decoration-break. Compare against `use.counter.content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_box_decoration_break(864);

  /**
   * generated from use.counter.css.doc.webkit_box_reflect
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-box-
     * reflect. Compare against `use.counter.content_documents_destroyed` to calculate
     * the rate.
   */
  constexpr impl::CounterMetric webkit_box_reflect(865);

  /**
   * generated from use.counter.css.doc.webkit_column_break_after
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-column-
     * break-after. Compare against `use.counter.content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_column_break_after(866);

  /**
   * generated from use.counter.css.doc.webkit_column_break_before
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-column-
     * break-before. Compare against `use.counter.content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_column_break_before(867);

  /**
   * generated from use.counter.css.doc.webkit_column_break_inside
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-column-
     * break-inside. Compare against `use.counter.content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_column_break_inside(868);

  /**
   * generated from use.counter.css.doc.webkit_column_count
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-column-
     * count. Compare against `use.counter.content_documents_destroyed` to calculate
     * the rate.
   */
  constexpr impl::CounterMetric webkit_column_count(869);

  /**
   * generated from use.counter.css.doc.webkit_column_gap
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-column-gap.
     * Compare against `use.counter.content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric webkit_column_gap(870);

  /**
   * generated from use.counter.css.doc.webkit_column_rule
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-column-
     * rule. Compare against `use.counter.content_documents_destroyed` to calculate
     * the rate.
   */
  constexpr impl::CounterMetric webkit_column_rule(871);

  /**
   * generated from use.counter.css.doc.webkit_column_rule_color
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-column-
     * rule-color. Compare against `use.counter.content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_column_rule_color(872);

  /**
   * generated from use.counter.css.doc.webkit_column_rule_style
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-column-
     * rule-style. Compare against `use.counter.content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_column_rule_style(873);

  /**
   * generated from use.counter.css.doc.webkit_column_rule_width
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-column-
     * rule-width. Compare against `use.counter.content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_column_rule_width(874);

  /**
   * generated from use.counter.css.doc.webkit_column_span
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-column-
     * span. Compare against `use.counter.content_documents_destroyed` to calculate
     * the rate.
   */
  constexpr impl::CounterMetric webkit_column_span(875);

  /**
   * generated from use.counter.css.doc.webkit_column_width
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-column-
     * width. Compare against `use.counter.content_documents_destroyed` to calculate
     * the rate.
   */
  constexpr impl::CounterMetric webkit_column_width(876);

  /**
   * generated from use.counter.css.doc.webkit_columns
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-columns.
     * Compare against `use.counter.content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric webkit_columns(877);

  /**
   * generated from use.counter.css.doc.webkit_font_feature_settings
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-font-
     * feature-settings. Compare against `use.counter.content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_font_feature_settings(878);

  /**
   * generated from use.counter.css.doc.webkit_font_size_delta
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-font-size-
     * delta. Compare against `use.counter.content_documents_destroyed` to calculate
     * the rate.
   */
  constexpr impl::CounterMetric webkit_font_size_delta(879);

  /**
   * generated from use.counter.css.doc.webkit_highlight
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-highlight.
     * Compare against `use.counter.content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric webkit_highlight(880);

  /**
   * generated from use.counter.css.doc.webkit_hyphenate_character
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-hyphenate-
     * character. Compare against `use.counter.content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_hyphenate_character(881);

  /**
   * generated from use.counter.css.doc.webkit_line_break
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-line-break.
     * Compare against `use.counter.content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric webkit_line_break(882);

  /**
   * generated from use.counter.css.doc.webkit_locale
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-locale.
     * Compare against `use.counter.content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric webkit_locale(883);

  /**
   * generated from use.counter.css.doc.webkit_logical_height
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-logical-
     * height. Compare against `use.counter.content_documents_destroyed` to calculate
     * the rate.
   */
  constexpr impl::CounterMetric webkit_logical_height(884);

  /**
   * generated from use.counter.css.doc.webkit_logical_width
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-logical-
     * width. Compare against `use.counter.content_documents_destroyed` to calculate
     * the rate.
   */
  constexpr impl::CounterMetric webkit_logical_width(885);

  /**
   * generated from use.counter.css.doc.webkit_margin_after
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-margin-
     * after. Compare against `use.counter.content_documents_destroyed` to calculate
     * the rate.
   */
  constexpr impl::CounterMetric webkit_margin_after(886);

  /**
   * generated from use.counter.css.doc.webkit_margin_after_collapse
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-margin-
     * after-collapse. Compare against `use.counter.content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_margin_after_collapse(887);

  /**
   * generated from use.counter.css.doc.webkit_margin_before
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-margin-
     * before. Compare against `use.counter.content_documents_destroyed` to calculate
     * the rate.
   */
  constexpr impl::CounterMetric webkit_margin_before(888);

  /**
   * generated from use.counter.css.doc.webkit_margin_before_collapse
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-margin-
     * before-collapse. Compare against `use.counter.content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_margin_before_collapse(889);

  /**
   * generated from use.counter.css.doc.webkit_margin_bottom_collapse
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-margin-
     * bottom-collapse. Compare against `use.counter.content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_margin_bottom_collapse(890);

  /**
   * generated from use.counter.css.doc.webkit_margin_collapse
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-margin-
     * collapse. Compare against `use.counter.content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_margin_collapse(891);

  /**
   * generated from use.counter.css.doc.webkit_margin_end
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-margin-end.
     * Compare against `use.counter.content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric webkit_margin_end(892);

  /**
   * generated from use.counter.css.doc.webkit_margin_start
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-margin-
     * start. Compare against `use.counter.content_documents_destroyed` to calculate
     * the rate.
   */
  constexpr impl::CounterMetric webkit_margin_start(893);

  /**
   * generated from use.counter.css.doc.webkit_margin_top_collapse
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-margin-top-
     * collapse. Compare against `use.counter.content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_margin_top_collapse(894);

  /**
   * generated from use.counter.css.doc.webkit_mask_box_image
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-mask-box-
     * image. Compare against `use.counter.content_documents_destroyed` to calculate
     * the rate.
   */
  constexpr impl::CounterMetric webkit_mask_box_image(895);

  /**
   * generated from use.counter.css.doc.webkit_mask_box_image_outset
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-mask-box-
     * image-outset. Compare against `use.counter.content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_mask_box_image_outset(896);

  /**
   * generated from use.counter.css.doc.webkit_mask_box_image_repeat
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-mask-box-
     * image-repeat. Compare against `use.counter.content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_mask_box_image_repeat(897);

  /**
   * generated from use.counter.css.doc.webkit_mask_box_image_slice
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-mask-box-
     * image-slice. Compare against `use.counter.content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_mask_box_image_slice(898);

  /**
   * generated from use.counter.css.doc.webkit_mask_box_image_source
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-mask-box-
     * image-source. Compare against `use.counter.content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_mask_box_image_source(899);

  /**
   * generated from use.counter.css.doc.webkit_mask_box_image_width
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-mask-box-
     * image-width. Compare against `use.counter.content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_mask_box_image_width(900);

  /**
   * generated from use.counter.css.doc.webkit_mask_repeat_x
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-mask-
     * repeat-x. Compare against `use.counter.content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_mask_repeat_x(901);

  /**
   * generated from use.counter.css.doc.webkit_mask_repeat_y
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-mask-
     * repeat-y. Compare against `use.counter.content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_mask_repeat_y(902);

  /**
   * generated from use.counter.css.doc.webkit_max_logical_height
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-max-
     * logical-height. Compare against `use.counter.content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_max_logical_height(903);

  /**
   * generated from use.counter.css.doc.webkit_max_logical_width
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-max-
     * logical-width. Compare against `use.counter.content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_max_logical_width(904);

  /**
   * generated from use.counter.css.doc.webkit_min_logical_height
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-min-
     * logical-height. Compare against `use.counter.content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_min_logical_height(905);

  /**
   * generated from use.counter.css.doc.webkit_min_logical_width
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-min-
     * logical-width. Compare against `use.counter.content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_min_logical_width(906);

  /**
   * generated from use.counter.css.doc.webkit_opacity
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-opacity.
     * Compare against `use.counter.content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric webkit_opacity(907);

  /**
   * generated from use.counter.css.doc.webkit_padding_after
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-padding-
     * after. Compare against `use.counter.content_documents_destroyed` to calculate
     * the rate.
   */
  constexpr impl::CounterMetric webkit_padding_after(908);

  /**
   * generated from use.counter.css.doc.webkit_padding_before
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-padding-
     * before. Compare against `use.counter.content_documents_destroyed` to calculate
     * the rate.
   */
  constexpr impl::CounterMetric webkit_padding_before(909);

  /**
   * generated from use.counter.css.doc.webkit_padding_end
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-padding-
     * end. Compare against `use.counter.content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric webkit_padding_end(910);

  /**
   * generated from use.counter.css.doc.webkit_padding_start
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-padding-
     * start. Compare against `use.counter.content_documents_destroyed` to calculate
     * the rate.
   */
  constexpr impl::CounterMetric webkit_padding_start(911);

  /**
   * generated from use.counter.css.doc.webkit_perspective_origin_x
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-
     * perspective-origin-x. Compare against `use.counter.content_documents_destroyed`
     * to calculate the rate.
   */
  constexpr impl::CounterMetric webkit_perspective_origin_x(912);

  /**
   * generated from use.counter.css.doc.webkit_perspective_origin_y
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-
     * perspective-origin-y. Compare against `use.counter.content_documents_destroyed`
     * to calculate the rate.
   */
  constexpr impl::CounterMetric webkit_perspective_origin_y(913);

  /**
   * generated from use.counter.css.doc.webkit_print_color_adjust
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-print-
     * color-adjust. Compare against `use.counter.content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_print_color_adjust(914);

  /**
   * generated from use.counter.css.doc.webkit_rtl_ordering
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-rtl-
     * ordering. Compare against `use.counter.content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_rtl_ordering(915);

  /**
   * generated from use.counter.css.doc.webkit_ruby_position
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-ruby-
     * position. Compare against `use.counter.content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_ruby_position(916);

  /**
   * generated from use.counter.css.doc.webkit_shape_image_threshold
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-shape-
     * image-threshold. Compare against `use.counter.content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_shape_image_threshold(917);

  /**
   * generated from use.counter.css.doc.webkit_shape_margin
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-shape-
     * margin. Compare against `use.counter.content_documents_destroyed` to calculate
     * the rate.
   */
  constexpr impl::CounterMetric webkit_shape_margin(918);

  /**
   * generated from use.counter.css.doc.webkit_shape_outside
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-shape-
     * outside. Compare against `use.counter.content_documents_destroyed` to calculate
     * the rate.
   */
  constexpr impl::CounterMetric webkit_shape_outside(919);

  /**
   * generated from use.counter.css.doc.webkit_tap_highlight_color
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-tap-
     * highlight-color. Compare against `use.counter.content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_tap_highlight_color(920);

  /**
   * generated from use.counter.css.doc.webkit_text_combine
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-text-
     * combine. Compare against `use.counter.content_documents_destroyed` to calculate
     * the rate.
   */
  constexpr impl::CounterMetric webkit_text_combine(921);

  /**
   * generated from use.counter.css.doc.webkit_text_decorations_in_effect
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-text-
     * decorations-in-effect. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric webkit_text_decorations_in_effect(922);

  /**
   * generated from use.counter.css.doc.webkit_text_emphasis
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-text-
     * emphasis. Compare against `use.counter.content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_text_emphasis(923);

  /**
   * generated from use.counter.css.doc.webkit_text_emphasis_color
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-text-
     * emphasis-color. Compare against `use.counter.content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_text_emphasis_color(924);

  /**
   * generated from use.counter.css.doc.webkit_text_emphasis_position
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-text-
     * emphasis-position. Compare against `use.counter.content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_text_emphasis_position(925);

  /**
   * generated from use.counter.css.doc.webkit_text_emphasis_style
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-text-
     * emphasis-style. Compare against `use.counter.content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_text_emphasis_style(926);

  /**
   * generated from use.counter.css.doc.webkit_text_orientation
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-text-
     * orientation. Compare against `use.counter.content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_text_orientation(927);

  /**
   * generated from use.counter.css.doc.webkit_transform_origin_x
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-transform-
     * origin-x. Compare against `use.counter.content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_transform_origin_x(928);

  /**
   * generated from use.counter.css.doc.webkit_transform_origin_y
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-transform-
     * origin-y. Compare against `use.counter.content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_transform_origin_y(929);

  /**
   * generated from use.counter.css.doc.webkit_transform_origin_z
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-transform-
     * origin-z. Compare against `use.counter.content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_transform_origin_z(930);

  /**
   * generated from use.counter.css.doc.webkit_user_drag
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-user-drag.
     * Compare against `use.counter.content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric webkit_user_drag(931);

  /**
   * generated from use.counter.css.doc.webkit_user_modify
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-user-
     * modify. Compare against `use.counter.content_documents_destroyed` to calculate
     * the rate.
   */
  constexpr impl::CounterMetric webkit_user_modify(932);

  /**
   * generated from use.counter.css.doc.webkit_writing_mode
   */
  /**
   * Whether a document used the (unknown, counted) CSS property -webkit-writing-
     * mode. Compare against `use.counter.content_documents_destroyed` to calculate
     * the rate.
   */
  constexpr impl::CounterMetric webkit_writing_mode(933);

  /**
   * generated from use.counter.css.doc.widows
   */
  /**
   * Whether a document used the (unknown, counted) CSS property widows. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric widows(934);

}
namespace use_counter_css_page {
  /**
   * generated from use.counter.css.page.alignment_baseline
   */
  /**
   * Whether a page used the (unknown, counted) CSS property alignment-baseline.
     * Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric alignment_baseline(935);

  /**
   * generated from use.counter.css.page.background_repeat_x
   */
  /**
   * Whether a page used the (unknown, counted) CSS property background-repeat-x.
     * Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric background_repeat_x(936);

  /**
   * generated from use.counter.css.page.background_repeat_y
   */
  /**
   * Whether a page used the (unknown, counted) CSS property background-repeat-y.
     * Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric background_repeat_y(937);

  /**
   * generated from use.counter.css.page.baseline_shift
   */
  /**
   * Whether a page used the (unknown, counted) CSS property baseline-shift. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric baseline_shift(938);

  /**
   * generated from use.counter.css.page.buffered_rendering
   */
  /**
   * Whether a page used the (unknown, counted) CSS property buffered-rendering.
     * Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric buffered_rendering(939);

  /**
   * generated from use.counter.css.page.color_rendering
   */
  /**
   * Whether a page used the (unknown, counted) CSS property color-rendering.
     * Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric color_rendering(940);

  /**
   * generated from use.counter.css.page.css_accent_color
   */
  /**
   * Whether a page used the CSS property accent-color. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_accent_color(941);

  /**
   * generated from use.counter.css.page.css_align_content
   */
  /**
   * Whether a page used the CSS property align-content. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_align_content(942);

  /**
   * generated from use.counter.css.page.css_align_items
   */
  /**
   * Whether a page used the CSS property align-items. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_align_items(943);

  /**
   * generated from use.counter.css.page.css_align_self
   */
  /**
   * Whether a page used the CSS property align-self. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_align_self(944);

  /**
   * generated from use.counter.css.page.css_all
   */
  /**
   * Whether a page used the CSS property all. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_all(945);

  /**
   * generated from use.counter.css.page.css_anchor_name
   */
  /**
   * Whether a page used the CSS property anchor-name. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_anchor_name(946);

  /**
   * generated from use.counter.css.page.css_anchor_scope
   */
  /**
   * Whether a page used the CSS property anchor-scope. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_anchor_scope(947);

  /**
   * generated from use.counter.css.page.css_animation
   */
  /**
   * Whether a page used the CSS property animation. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_animation(948);

  /**
   * generated from use.counter.css.page.css_animation_composition
   */
  /**
   * Whether a page used the CSS property animation-composition. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_animation_composition(949);

  /**
   * generated from use.counter.css.page.css_animation_delay
   */
  /**
   * Whether a page used the CSS property animation-delay. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_animation_delay(950);

  /**
   * generated from use.counter.css.page.css_animation_direction
   */
  /**
   * Whether a page used the CSS property animation-direction. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_animation_direction(951);

  /**
   * generated from use.counter.css.page.css_animation_duration
   */
  /**
   * Whether a page used the CSS property animation-duration. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_animation_duration(952);

  /**
   * generated from use.counter.css.page.css_animation_fill_mode
   */
  /**
   * Whether a page used the CSS property animation-fill-mode. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_animation_fill_mode(953);

  /**
   * generated from use.counter.css.page.css_animation_iteration_count
   */
  /**
   * Whether a page used the CSS property animation-iteration-count. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_animation_iteration_count(954);

  /**
   * generated from use.counter.css.page.css_animation_name
   */
  /**
   * Whether a page used the CSS property animation-name. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_animation_name(955);

  /**
   * generated from use.counter.css.page.css_animation_play_state
   */
  /**
   * Whether a page used the CSS property animation-play-state. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_animation_play_state(956);

  /**
   * generated from use.counter.css.page.css_animation_timeline
   */
  /**
   * Whether a page used the CSS property animation-timeline. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_animation_timeline(957);

  /**
   * generated from use.counter.css.page.css_animation_timing_function
   */
  /**
   * Whether a page used the CSS property animation-timing-function. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_animation_timing_function(958);

  /**
   * generated from use.counter.css.page.css_appearance
   */
  /**
   * Whether a page used the CSS property appearance. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_appearance(959);

  /**
   * generated from use.counter.css.page.css_aspect_ratio
   */
  /**
   * Whether a page used the CSS property aspect-ratio. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_aspect_ratio(960);

  /**
   * generated from use.counter.css.page.css_backdrop_filter
   */
  /**
   * Whether a page used the CSS property backdrop-filter. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_backdrop_filter(961);

  /**
   * generated from use.counter.css.page.css_backface_visibility
   */
  /**
   * Whether a page used the CSS property backface-visibility. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_backface_visibility(962);

  /**
   * generated from use.counter.css.page.css_background
   */
  /**
   * Whether a page used the CSS property background. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_background(963);

  /**
   * generated from use.counter.css.page.css_background_attachment
   */
  /**
   * Whether a page used the CSS property background-attachment. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_background_attachment(964);

  /**
   * generated from use.counter.css.page.css_background_blend_mode
   */
  /**
   * Whether a page used the CSS property background-blend-mode. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_background_blend_mode(965);

  /**
   * generated from use.counter.css.page.css_background_clip
   */
  /**
   * Whether a page used the CSS property background-clip. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_background_clip(966);

  /**
   * generated from use.counter.css.page.css_background_color
   */
  /**
   * Whether a page used the CSS property background-color. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_background_color(967);

  /**
   * generated from use.counter.css.page.css_background_image
   */
  /**
   * Whether a page used the CSS property background-image. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_background_image(968);

  /**
   * generated from use.counter.css.page.css_background_origin
   */
  /**
   * Whether a page used the CSS property background-origin. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_background_origin(969);

  /**
   * generated from use.counter.css.page.css_background_position
   */
  /**
   * Whether a page used the CSS property background-position. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_background_position(970);

  /**
   * generated from use.counter.css.page.css_background_position_x
   */
  /**
   * Whether a page used the CSS property background-position-x. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_background_position_x(971);

  /**
   * generated from use.counter.css.page.css_background_position_y
   */
  /**
   * Whether a page used the CSS property background-position-y. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_background_position_y(972);

  /**
   * generated from use.counter.css.page.css_background_repeat
   */
  /**
   * Whether a page used the CSS property background-repeat. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_background_repeat(973);

  /**
   * generated from use.counter.css.page.css_background_size
   */
  /**
   * Whether a page used the CSS property background-size. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_background_size(974);

  /**
   * generated from use.counter.css.page.css_baseline_source
   */
  /**
   * Whether a page used the CSS property baseline-source. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_baseline_source(975);

  /**
   * generated from use.counter.css.page.css_block_size
   */
  /**
   * Whether a page used the CSS property block-size. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_block_size(976);

  /**
   * generated from use.counter.css.page.css_border
   */
  /**
   * Whether a page used the CSS property border. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border(977);

  /**
   * generated from use.counter.css.page.css_border_block
   */
  /**
   * Whether a page used the CSS property border-block. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_block(978);

  /**
   * generated from use.counter.css.page.css_border_block_color
   */
  /**
   * Whether a page used the CSS property border-block-color. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_block_color(979);

  /**
   * generated from use.counter.css.page.css_border_block_end
   */
  /**
   * Whether a page used the CSS property border-block-end. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_block_end(980);

  /**
   * generated from use.counter.css.page.css_border_block_end_color
   */
  /**
   * Whether a page used the CSS property border-block-end-color. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_block_end_color(981);

  /**
   * generated from use.counter.css.page.css_border_block_end_style
   */
  /**
   * Whether a page used the CSS property border-block-end-style. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_block_end_style(982);

  /**
   * generated from use.counter.css.page.css_border_block_end_width
   */
  /**
   * Whether a page used the CSS property border-block-end-width. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_block_end_width(983);

  /**
   * generated from use.counter.css.page.css_border_block_start
   */
  /**
   * Whether a page used the CSS property border-block-start. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_block_start(984);

  /**
   * generated from use.counter.css.page.css_border_block_start_color
   */
  /**
   * Whether a page used the CSS property border-block-start-color. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_block_start_color(985);

  /**
   * generated from use.counter.css.page.css_border_block_start_style
   */
  /**
   * Whether a page used the CSS property border-block-start-style. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_block_start_style(986);

  /**
   * generated from use.counter.css.page.css_border_block_start_width
   */
  /**
   * Whether a page used the CSS property border-block-start-width. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_block_start_width(987);

  /**
   * generated from use.counter.css.page.css_border_block_style
   */
  /**
   * Whether a page used the CSS property border-block-style. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_block_style(988);

  /**
   * generated from use.counter.css.page.css_border_block_width
   */
  /**
   * Whether a page used the CSS property border-block-width. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_block_width(989);

  /**
   * generated from use.counter.css.page.css_border_bottom
   */
  /**
   * Whether a page used the CSS property border-bottom. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_bottom(990);

  /**
   * generated from use.counter.css.page.css_border_bottom_color
   */
  /**
   * Whether a page used the CSS property border-bottom-color. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_bottom_color(991);

  /**
   * generated from use.counter.css.page.css_border_bottom_left_radius
   */
  /**
   * Whether a page used the CSS property border-bottom-left-radius. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_bottom_left_radius(992);

  /**
   * generated from use.counter.css.page.css_border_bottom_right_radius
   */
  /**
   * Whether a page used the CSS property border-bottom-right-radius. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric css_border_bottom_right_radius(993);

  /**
   * generated from use.counter.css.page.css_border_bottom_style
   */
  /**
   * Whether a page used the CSS property border-bottom-style. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_bottom_style(994);

  /**
   * generated from use.counter.css.page.css_border_bottom_width
   */
  /**
   * Whether a page used the CSS property border-bottom-width. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_bottom_width(995);

  /**
   * generated from use.counter.css.page.css_border_collapse
   */
  /**
   * Whether a page used the CSS property border-collapse. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_collapse(996);

  /**
   * generated from use.counter.css.page.css_border_color
   */
  /**
   * Whether a page used the CSS property border-color. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_color(997);

  /**
   * generated from use.counter.css.page.css_border_end_end_radius
   */
  /**
   * Whether a page used the CSS property border-end-end-radius. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_end_end_radius(998);

  /**
   * generated from use.counter.css.page.css_border_end_start_radius
   */
  /**
   * Whether a page used the CSS property border-end-start-radius. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_end_start_radius(999);

  /**
   * generated from use.counter.css.page.css_border_image
   */
  /**
   * Whether a page used the CSS property border-image. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_image(1000);

  /**
   * generated from use.counter.css.page.css_border_image_outset
   */
  /**
   * Whether a page used the CSS property border-image-outset. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_image_outset(1001);

  /**
   * generated from use.counter.css.page.css_border_image_repeat
   */
  /**
   * Whether a page used the CSS property border-image-repeat. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_image_repeat(1002);

  /**
   * generated from use.counter.css.page.css_border_image_slice
   */
  /**
   * Whether a page used the CSS property border-image-slice. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_image_slice(1003);

  /**
   * generated from use.counter.css.page.css_border_image_source
   */
  /**
   * Whether a page used the CSS property border-image-source. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_image_source(1004);

  /**
   * generated from use.counter.css.page.css_border_image_width
   */
  /**
   * Whether a page used the CSS property border-image-width. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_image_width(1005);

  /**
   * generated from use.counter.css.page.css_border_inline
   */
  /**
   * Whether a page used the CSS property border-inline. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_inline(1006);

  /**
   * generated from use.counter.css.page.css_border_inline_color
   */
  /**
   * Whether a page used the CSS property border-inline-color. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_inline_color(1007);

  /**
   * generated from use.counter.css.page.css_border_inline_end
   */
  /**
   * Whether a page used the CSS property border-inline-end. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_inline_end(1008);

  /**
   * generated from use.counter.css.page.css_border_inline_end_color
   */
  /**
   * Whether a page used the CSS property border-inline-end-color. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_inline_end_color(1009);

  /**
   * generated from use.counter.css.page.css_border_inline_end_style
   */
  /**
   * Whether a page used the CSS property border-inline-end-style. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_inline_end_style(1010);

  /**
   * generated from use.counter.css.page.css_border_inline_end_width
   */
  /**
   * Whether a page used the CSS property border-inline-end-width. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_inline_end_width(1011);

  /**
   * generated from use.counter.css.page.css_border_inline_start
   */
  /**
   * Whether a page used the CSS property border-inline-start. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_inline_start(1012);

  /**
   * generated from use.counter.css.page.css_border_inline_start_color
   */
  /**
   * Whether a page used the CSS property border-inline-start-color. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_inline_start_color(1013);

  /**
   * generated from use.counter.css.page.css_border_inline_start_style
   */
  /**
   * Whether a page used the CSS property border-inline-start-style. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_inline_start_style(1014);

  /**
   * generated from use.counter.css.page.css_border_inline_start_width
   */
  /**
   * Whether a page used the CSS property border-inline-start-width. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_inline_start_width(1015);

  /**
   * generated from use.counter.css.page.css_border_inline_style
   */
  /**
   * Whether a page used the CSS property border-inline-style. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_inline_style(1016);

  /**
   * generated from use.counter.css.page.css_border_inline_width
   */
  /**
   * Whether a page used the CSS property border-inline-width. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_inline_width(1017);

  /**
   * generated from use.counter.css.page.css_border_left
   */
  /**
   * Whether a page used the CSS property border-left. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_left(1018);

  /**
   * generated from use.counter.css.page.css_border_left_color
   */
  /**
   * Whether a page used the CSS property border-left-color. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_left_color(1019);

  /**
   * generated from use.counter.css.page.css_border_left_style
   */
  /**
   * Whether a page used the CSS property border-left-style. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_left_style(1020);

  /**
   * generated from use.counter.css.page.css_border_left_width
   */
  /**
   * Whether a page used the CSS property border-left-width. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_left_width(1021);

  /**
   * generated from use.counter.css.page.css_border_radius
   */
  /**
   * Whether a page used the CSS property border-radius. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_radius(1022);

  /**
   * generated from use.counter.css.page.css_border_right
   */
  /**
   * Whether a page used the CSS property border-right. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_right(1023);

  /**
   * generated from use.counter.css.page.css_border_right_color
   */
  /**
   * Whether a page used the CSS property border-right-color. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_right_color(1024);

  /**
   * generated from use.counter.css.page.css_border_right_style
   */
  /**
   * Whether a page used the CSS property border-right-style. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_right_style(1025);

  /**
   * generated from use.counter.css.page.css_border_right_width
   */
  /**
   * Whether a page used the CSS property border-right-width. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_right_width(1026);

  /**
   * generated from use.counter.css.page.css_border_spacing
   */
  /**
   * Whether a page used the CSS property border-spacing. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_spacing(1027);

  /**
   * generated from use.counter.css.page.css_border_start_end_radius
   */
  /**
   * Whether a page used the CSS property border-start-end-radius. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_start_end_radius(1028);

  /**
   * generated from use.counter.css.page.css_border_start_start_radius
   */
  /**
   * Whether a page used the CSS property border-start-start-radius. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_start_start_radius(1029);

  /**
   * generated from use.counter.css.page.css_border_style
   */
  /**
   * Whether a page used the CSS property border-style. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_style(1030);

  /**
   * generated from use.counter.css.page.css_border_top
   */
  /**
   * Whether a page used the CSS property border-top. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_top(1031);

  /**
   * generated from use.counter.css.page.css_border_top_color
   */
  /**
   * Whether a page used the CSS property border-top-color. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_top_color(1032);

  /**
   * generated from use.counter.css.page.css_border_top_left_radius
   */
  /**
   * Whether a page used the CSS property border-top-left-radius. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_top_left_radius(1033);

  /**
   * generated from use.counter.css.page.css_border_top_right_radius
   */
  /**
   * Whether a page used the CSS property border-top-right-radius. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_top_right_radius(1034);

  /**
   * generated from use.counter.css.page.css_border_top_style
   */
  /**
   * Whether a page used the CSS property border-top-style. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_top_style(1035);

  /**
   * generated from use.counter.css.page.css_border_top_width
   */
  /**
   * Whether a page used the CSS property border-top-width. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_top_width(1036);

  /**
   * generated from use.counter.css.page.css_border_width
   */
  /**
   * Whether a page used the CSS property border-width. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_border_width(1037);

  /**
   * generated from use.counter.css.page.css_bottom
   */
  /**
   * Whether a page used the CSS property bottom. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_bottom(1038);

  /**
   * generated from use.counter.css.page.css_box_decoration_break
   */
  /**
   * Whether a page used the CSS property box-decoration-break. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_box_decoration_break(1039);

  /**
   * generated from use.counter.css.page.css_box_shadow
   */
  /**
   * Whether a page used the CSS property box-shadow. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_box_shadow(1040);

  /**
   * generated from use.counter.css.page.css_box_sizing
   */
  /**
   * Whether a page used the CSS property box-sizing. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_box_sizing(1041);

  /**
   * generated from use.counter.css.page.css_break_after
   */
  /**
   * Whether a page used the CSS property break-after. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_break_after(1042);

  /**
   * generated from use.counter.css.page.css_break_before
   */
  /**
   * Whether a page used the CSS property break-before. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_break_before(1043);

  /**
   * generated from use.counter.css.page.css_break_inside
   */
  /**
   * Whether a page used the CSS property break-inside. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_break_inside(1044);

  /**
   * generated from use.counter.css.page.css_caption_side
   */
  /**
   * Whether a page used the CSS property caption-side. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_caption_side(1045);

  /**
   * generated from use.counter.css.page.css_caret_color
   */
  /**
   * Whether a page used the CSS property caret-color. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_caret_color(1046);

  /**
   * generated from use.counter.css.page.css_clear
   */
  /**
   * Whether a page used the CSS property clear. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_clear(1047);

  /**
   * generated from use.counter.css.page.css_clip
   */
  /**
   * Whether a page used the CSS property clip. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_clip(1048);

  /**
   * generated from use.counter.css.page.css_clip_path
   */
  /**
   * Whether a page used the CSS property clip-path. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_clip_path(1049);

  /**
   * generated from use.counter.css.page.css_clip_rule
   */
  /**
   * Whether a page used the CSS property clip-rule. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_clip_rule(1050);

  /**
   * generated from use.counter.css.page.css_color
   */
  /**
   * Whether a page used the CSS property color. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_color(1051);

  /**
   * generated from use.counter.css.page.css_color_adjust
   */
  /**
   * Whether a page used the CSS property color-adjust. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_color_adjust(1052);

  /**
   * generated from use.counter.css.page.css_color_interpolation
   */
  /**
   * Whether a page used the CSS property color-interpolation. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_color_interpolation(1053);

  /**
   * generated from use.counter.css.page.css_color_interpolation_filters
   */
  /**
   * Whether a page used the CSS property color-interpolation-filters. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric css_color_interpolation_filters(1054);

  /**
   * generated from use.counter.css.page.css_color_scheme
   */
  /**
   * Whether a page used the CSS property color-scheme. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_color_scheme(1055);

  /**
   * generated from use.counter.css.page.css_column_count
   */
  /**
   * Whether a page used the CSS property column-count. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_column_count(1056);

  /**
   * generated from use.counter.css.page.css_column_fill
   */
  /**
   * Whether a page used the CSS property column-fill. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_column_fill(1057);

  /**
   * generated from use.counter.css.page.css_column_gap
   */
  /**
   * Whether a page used the CSS property column-gap. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_column_gap(1058);

  /**
   * generated from use.counter.css.page.css_column_rule
   */
  /**
   * Whether a page used the CSS property column-rule. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_column_rule(1059);

  /**
   * generated from use.counter.css.page.css_column_rule_color
   */
  /**
   * Whether a page used the CSS property column-rule-color. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_column_rule_color(1060);

  /**
   * generated from use.counter.css.page.css_column_rule_style
   */
  /**
   * Whether a page used the CSS property column-rule-style. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_column_rule_style(1061);

  /**
   * generated from use.counter.css.page.css_column_rule_width
   */
  /**
   * Whether a page used the CSS property column-rule-width. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_column_rule_width(1062);

  /**
   * generated from use.counter.css.page.css_column_span
   */
  /**
   * Whether a page used the CSS property column-span. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_column_span(1063);

  /**
   * generated from use.counter.css.page.css_column_width
   */
  /**
   * Whether a page used the CSS property column-width. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_column_width(1064);

  /**
   * generated from use.counter.css.page.css_columns
   */
  /**
   * Whether a page used the CSS property columns. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_columns(1065);

  /**
   * generated from use.counter.css.page.css_contain
   */
  /**
   * Whether a page used the CSS property contain. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_contain(1066);

  /**
   * generated from use.counter.css.page.css_contain_intrinsic_block_size
   */
  /**
   * Whether a page used the CSS property contain-intrinsic-block-size. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric css_contain_intrinsic_block_size(1067);

  /**
   * generated from use.counter.css.page.css_contain_intrinsic_height
   */
  /**
   * Whether a page used the CSS property contain-intrinsic-height. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_contain_intrinsic_height(1068);

  /**
   * generated from use.counter.css.page.css_contain_intrinsic_inline_size
   */
  /**
   * Whether a page used the CSS property contain-intrinsic-inline-size. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric css_contain_intrinsic_inline_size(1069);

  /**
   * generated from use.counter.css.page.css_contain_intrinsic_size
   */
  /**
   * Whether a page used the CSS property contain-intrinsic-size. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_contain_intrinsic_size(1070);

  /**
   * generated from use.counter.css.page.css_contain_intrinsic_width
   */
  /**
   * Whether a page used the CSS property contain-intrinsic-width. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_contain_intrinsic_width(1071);

  /**
   * generated from use.counter.css.page.css_container
   */
  /**
   * Whether a page used the CSS property container. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_container(1072);

  /**
   * generated from use.counter.css.page.css_container_name
   */
  /**
   * Whether a page used the CSS property container-name. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_container_name(1073);

  /**
   * generated from use.counter.css.page.css_container_type
   */
  /**
   * Whether a page used the CSS property container-type. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_container_type(1074);

  /**
   * generated from use.counter.css.page.css_content
   */
  /**
   * Whether a page used the CSS property content. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_content(1075);

  /**
   * generated from use.counter.css.page.css_content_visibility
   */
  /**
   * Whether a page used the CSS property content-visibility. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_content_visibility(1076);

  /**
   * generated from use.counter.css.page.css_counter_increment
   */
  /**
   * Whether a page used the CSS property counter-increment. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_counter_increment(1077);

  /**
   * generated from use.counter.css.page.css_counter_reset
   */
  /**
   * Whether a page used the CSS property counter-reset. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_counter_reset(1078);

  /**
   * generated from use.counter.css.page.css_counter_set
   */
  /**
   * Whether a page used the CSS property counter-set. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_counter_set(1079);

  /**
   * generated from use.counter.css.page.css_cursor
   */
  /**
   * Whether a page used the CSS property cursor. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_cursor(1080);

  /**
   * generated from use.counter.css.page.css_cx
   */
  /**
   * Whether a page used the CSS property cx. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_cx(1081);

  /**
   * generated from use.counter.css.page.css_cy
   */
  /**
   * Whether a page used the CSS property cy. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_cy(1082);

  /**
   * generated from use.counter.css.page.css_d
   */
  /**
   * Whether a page used the CSS property d. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_d(1083);

  /**
   * generated from use.counter.css.page.css_direction
   */
  /**
   * Whether a page used the CSS property direction. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_direction(1084);

  /**
   * generated from use.counter.css.page.css_display
   */
  /**
   * Whether a page used the CSS property display. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_display(1085);

  /**
   * generated from use.counter.css.page.css_dominant_baseline
   */
  /**
   * Whether a page used the CSS property dominant-baseline. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_dominant_baseline(1086);

  /**
   * generated from use.counter.css.page.css_empty_cells
   */
  /**
   * Whether a page used the CSS property empty-cells. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_empty_cells(1087);

  /**
   * generated from use.counter.css.page.css_fill
   */
  /**
   * Whether a page used the CSS property fill. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_fill(1088);

  /**
   * generated from use.counter.css.page.css_fill_opacity
   */
  /**
   * Whether a page used the CSS property fill-opacity. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_fill_opacity(1089);

  /**
   * generated from use.counter.css.page.css_fill_rule
   */
  /**
   * Whether a page used the CSS property fill-rule. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_fill_rule(1090);

  /**
   * generated from use.counter.css.page.css_filter
   */
  /**
   * Whether a page used the CSS property filter. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_filter(1091);

  /**
   * generated from use.counter.css.page.css_flex
   */
  /**
   * Whether a page used the CSS property flex. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_flex(1092);

  /**
   * generated from use.counter.css.page.css_flex_basis
   */
  /**
   * Whether a page used the CSS property flex-basis. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_flex_basis(1093);

  /**
   * generated from use.counter.css.page.css_flex_direction
   */
  /**
   * Whether a page used the CSS property flex-direction. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_flex_direction(1094);

  /**
   * generated from use.counter.css.page.css_flex_flow
   */
  /**
   * Whether a page used the CSS property flex-flow. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_flex_flow(1095);

  /**
   * generated from use.counter.css.page.css_flex_grow
   */
  /**
   * Whether a page used the CSS property flex-grow. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_flex_grow(1096);

  /**
   * generated from use.counter.css.page.css_flex_shrink
   */
  /**
   * Whether a page used the CSS property flex-shrink. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_flex_shrink(1097);

  /**
   * generated from use.counter.css.page.css_flex_wrap
   */
  /**
   * Whether a page used the CSS property flex-wrap. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_flex_wrap(1098);

  /**
   * generated from use.counter.css.page.css_float
   */
  /**
   * Whether a page used the CSS property float. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_float(1099);

  /**
   * generated from use.counter.css.page.css_flood_color
   */
  /**
   * Whether a page used the CSS property flood-color. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_flood_color(1100);

  /**
   * generated from use.counter.css.page.css_flood_opacity
   */
  /**
   * Whether a page used the CSS property flood-opacity. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_flood_opacity(1101);

  /**
   * generated from use.counter.css.page.css_font
   */
  /**
   * Whether a page used the CSS property font. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_font(1102);

  /**
   * generated from use.counter.css.page.css_font_family
   */
  /**
   * Whether a page used the CSS property font-family. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_font_family(1103);

  /**
   * generated from use.counter.css.page.css_font_feature_settings
   */
  /**
   * Whether a page used the CSS property font-feature-settings. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_font_feature_settings(1104);

  /**
   * generated from use.counter.css.page.css_font_kerning
   */
  /**
   * Whether a page used the CSS property font-kerning. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_font_kerning(1105);

  /**
   * generated from use.counter.css.page.css_font_language_override
   */
  /**
   * Whether a page used the CSS property font-language-override. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_font_language_override(1106);

  /**
   * generated from use.counter.css.page.css_font_optical_sizing
   */
  /**
   * Whether a page used the CSS property font-optical-sizing. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_font_optical_sizing(1107);

  /**
   * generated from use.counter.css.page.css_font_palette
   */
  /**
   * Whether a page used the CSS property font-palette. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_font_palette(1108);

  /**
   * generated from use.counter.css.page.css_font_size
   */
  /**
   * Whether a page used the CSS property font-size. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_font_size(1109);

  /**
   * generated from use.counter.css.page.css_font_size_adjust
   */
  /**
   * Whether a page used the CSS property font-size-adjust. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_font_size_adjust(1110);

  /**
   * generated from use.counter.css.page.css_font_stretch
   */
  /**
   * Whether a page used the CSS property font-stretch. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_font_stretch(1111);

  /**
   * generated from use.counter.css.page.css_font_style
   */
  /**
   * Whether a page used the CSS property font-style. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_font_style(1112);

  /**
   * generated from use.counter.css.page.css_font_synthesis
   */
  /**
   * Whether a page used the CSS property font-synthesis. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_font_synthesis(1113);

  /**
   * generated from use.counter.css.page.css_font_synthesis_position
   */
  /**
   * Whether a page used the CSS property font-synthesis-position. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_font_synthesis_position(1114);

  /**
   * generated from use.counter.css.page.css_font_synthesis_small_caps
   */
  /**
   * Whether a page used the CSS property font-synthesis-small-caps. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_font_synthesis_small_caps(1115);

  /**
   * generated from use.counter.css.page.css_font_synthesis_style
   */
  /**
   * Whether a page used the CSS property font-synthesis-style. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_font_synthesis_style(1116);

  /**
   * generated from use.counter.css.page.css_font_synthesis_weight
   */
  /**
   * Whether a page used the CSS property font-synthesis-weight. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_font_synthesis_weight(1117);

  /**
   * generated from use.counter.css.page.css_font_variant
   */
  /**
   * Whether a page used the CSS property font-variant. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_font_variant(1118);

  /**
   * generated from use.counter.css.page.css_font_variant_alternates
   */
  /**
   * Whether a page used the CSS property font-variant-alternates. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_font_variant_alternates(1119);

  /**
   * generated from use.counter.css.page.css_font_variant_caps
   */
  /**
   * Whether a page used the CSS property font-variant-caps. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_font_variant_caps(1120);

  /**
   * generated from use.counter.css.page.css_font_variant_east_asian
   */
  /**
   * Whether a page used the CSS property font-variant-east-asian. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_font_variant_east_asian(1121);

  /**
   * generated from use.counter.css.page.css_font_variant_emoji
   */
  /**
   * Whether a page used the CSS property font-variant-emoji. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_font_variant_emoji(1122);

  /**
   * generated from use.counter.css.page.css_font_variant_ligatures
   */
  /**
   * Whether a page used the CSS property font-variant-ligatures. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_font_variant_ligatures(1123);

  /**
   * generated from use.counter.css.page.css_font_variant_numeric
   */
  /**
   * Whether a page used the CSS property font-variant-numeric. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_font_variant_numeric(1124);

  /**
   * generated from use.counter.css.page.css_font_variant_position
   */
  /**
   * Whether a page used the CSS property font-variant-position. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_font_variant_position(1125);

  /**
   * generated from use.counter.css.page.css_font_variation_settings
   */
  /**
   * Whether a page used the CSS property font-variation-settings. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_font_variation_settings(1126);

  /**
   * generated from use.counter.css.page.css_font_weight
   */
  /**
   * Whether a page used the CSS property font-weight. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_font_weight(1127);

  /**
   * generated from use.counter.css.page.css_forced_color_adjust
   */
  /**
   * Whether a page used the CSS property forced-color-adjust. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_forced_color_adjust(1128);

  /**
   * generated from use.counter.css.page.css_gap
   */
  /**
   * Whether a page used the CSS property gap. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_gap(1129);

  /**
   * generated from use.counter.css.page.css_grid
   */
  /**
   * Whether a page used the CSS property grid. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_grid(1130);

  /**
   * generated from use.counter.css.page.css_grid_area
   */
  /**
   * Whether a page used the CSS property grid-area. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_grid_area(1131);

  /**
   * generated from use.counter.css.page.css_grid_auto_columns
   */
  /**
   * Whether a page used the CSS property grid-auto-columns. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_grid_auto_columns(1132);

  /**
   * generated from use.counter.css.page.css_grid_auto_flow
   */
  /**
   * Whether a page used the CSS property grid-auto-flow. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_grid_auto_flow(1133);

  /**
   * generated from use.counter.css.page.css_grid_auto_rows
   */
  /**
   * Whether a page used the CSS property grid-auto-rows. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_grid_auto_rows(1134);

  /**
   * generated from use.counter.css.page.css_grid_column
   */
  /**
   * Whether a page used the CSS property grid-column. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_grid_column(1135);

  /**
   * generated from use.counter.css.page.css_grid_column_end
   */
  /**
   * Whether a page used the CSS property grid-column-end. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_grid_column_end(1136);

  /**
   * generated from use.counter.css.page.css_grid_column_gap
   */
  /**
   * Whether a page used the CSS property grid-column-gap. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_grid_column_gap(1137);

  /**
   * generated from use.counter.css.page.css_grid_column_start
   */
  /**
   * Whether a page used the CSS property grid-column-start. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_grid_column_start(1138);

  /**
   * generated from use.counter.css.page.css_grid_gap
   */
  /**
   * Whether a page used the CSS property grid-gap. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_grid_gap(1139);

  /**
   * generated from use.counter.css.page.css_grid_row
   */
  /**
   * Whether a page used the CSS property grid-row. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_grid_row(1140);

  /**
   * generated from use.counter.css.page.css_grid_row_end
   */
  /**
   * Whether a page used the CSS property grid-row-end. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_grid_row_end(1141);

  /**
   * generated from use.counter.css.page.css_grid_row_gap
   */
  /**
   * Whether a page used the CSS property grid-row-gap. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_grid_row_gap(1142);

  /**
   * generated from use.counter.css.page.css_grid_row_start
   */
  /**
   * Whether a page used the CSS property grid-row-start. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_grid_row_start(1143);

  /**
   * generated from use.counter.css.page.css_grid_template
   */
  /**
   * Whether a page used the CSS property grid-template. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_grid_template(1144);

  /**
   * generated from use.counter.css.page.css_grid_template_areas
   */
  /**
   * Whether a page used the CSS property grid-template-areas. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_grid_template_areas(1145);

  /**
   * generated from use.counter.css.page.css_grid_template_columns
   */
  /**
   * Whether a page used the CSS property grid-template-columns. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_grid_template_columns(1146);

  /**
   * generated from use.counter.css.page.css_grid_template_rows
   */
  /**
   * Whether a page used the CSS property grid-template-rows. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_grid_template_rows(1147);

  /**
   * generated from use.counter.css.page.css_height
   */
  /**
   * Whether a page used the CSS property height. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_height(1148);

  /**
   * generated from use.counter.css.page.css_hyphenate_character
   */
  /**
   * Whether a page used the CSS property hyphenate-character. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_hyphenate_character(1149);

  /**
   * generated from use.counter.css.page.css_hyphens
   */
  /**
   * Whether a page used the CSS property hyphens. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_hyphens(1150);

  /**
   * generated from use.counter.css.page.css_image_orientation
   */
  /**
   * Whether a page used the CSS property image-orientation. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_image_orientation(1151);

  /**
   * generated from use.counter.css.page.css_image_rendering
   */
  /**
   * Whether a page used the CSS property image-rendering. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_image_rendering(1152);

  /**
   * generated from use.counter.css.page.css_ime_mode
   */
  /**
   * Whether a page used the CSS property ime-mode. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_ime_mode(1153);

  /**
   * generated from use.counter.css.page.css_initial_letter
   */
  /**
   * Whether a page used the CSS property initial-letter. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_initial_letter(1154);

  /**
   * generated from use.counter.css.page.css_inline_size
   */
  /**
   * Whether a page used the CSS property inline-size. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_inline_size(1155);

  /**
   * generated from use.counter.css.page.css_inset
   */
  /**
   * Whether a page used the CSS property inset. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_inset(1156);

  /**
   * generated from use.counter.css.page.css_inset_area
   */
  /**
   * Whether a page used the CSS property inset-area. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_inset_area(1157);

  /**
   * generated from use.counter.css.page.css_inset_block
   */
  /**
   * Whether a page used the CSS property inset-block. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_inset_block(1158);

  /**
   * generated from use.counter.css.page.css_inset_block_end
   */
  /**
   * Whether a page used the CSS property inset-block-end. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_inset_block_end(1159);

  /**
   * generated from use.counter.css.page.css_inset_block_start
   */
  /**
   * Whether a page used the CSS property inset-block-start. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_inset_block_start(1160);

  /**
   * generated from use.counter.css.page.css_inset_inline
   */
  /**
   * Whether a page used the CSS property inset-inline. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_inset_inline(1161);

  /**
   * generated from use.counter.css.page.css_inset_inline_end
   */
  /**
   * Whether a page used the CSS property inset-inline-end. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_inset_inline_end(1162);

  /**
   * generated from use.counter.css.page.css_inset_inline_start
   */
  /**
   * Whether a page used the CSS property inset-inline-start. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_inset_inline_start(1163);

  /**
   * generated from use.counter.css.page.css_isolation
   */
  /**
   * Whether a page used the CSS property isolation. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_isolation(1164);

  /**
   * generated from use.counter.css.page.css_justify_content
   */
  /**
   * Whether a page used the CSS property justify-content. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_justify_content(1165);

  /**
   * generated from use.counter.css.page.css_justify_items
   */
  /**
   * Whether a page used the CSS property justify-items. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_justify_items(1166);

  /**
   * generated from use.counter.css.page.css_justify_self
   */
  /**
   * Whether a page used the CSS property justify-self. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_justify_self(1167);

  /**
   * generated from use.counter.css.page.css_left
   */
  /**
   * Whether a page used the CSS property left. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_left(1168);

  /**
   * generated from use.counter.css.page.css_letter_spacing
   */
  /**
   * Whether a page used the CSS property letter-spacing. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_letter_spacing(1169);

  /**
   * generated from use.counter.css.page.css_lighting_color
   */
  /**
   * Whether a page used the CSS property lighting-color. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_lighting_color(1170);

  /**
   * generated from use.counter.css.page.css_line_break
   */
  /**
   * Whether a page used the CSS property line-break. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_line_break(1171);

  /**
   * generated from use.counter.css.page.css_line_height
   */
  /**
   * Whether a page used the CSS property line-height. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_line_height(1172);

  /**
   * generated from use.counter.css.page.css_list_style
   */
  /**
   * Whether a page used the CSS property list-style. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_list_style(1173);

  /**
   * generated from use.counter.css.page.css_list_style_image
   */
  /**
   * Whether a page used the CSS property list-style-image. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_list_style_image(1174);

  /**
   * generated from use.counter.css.page.css_list_style_position
   */
  /**
   * Whether a page used the CSS property list-style-position. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_list_style_position(1175);

  /**
   * generated from use.counter.css.page.css_list_style_type
   */
  /**
   * Whether a page used the CSS property list-style-type. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_list_style_type(1176);

  /**
   * generated from use.counter.css.page.css_margin
   */
  /**
   * Whether a page used the CSS property margin. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_margin(1177);

  /**
   * generated from use.counter.css.page.css_margin_block
   */
  /**
   * Whether a page used the CSS property margin-block. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_margin_block(1178);

  /**
   * generated from use.counter.css.page.css_margin_block_end
   */
  /**
   * Whether a page used the CSS property margin-block-end. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_margin_block_end(1179);

  /**
   * generated from use.counter.css.page.css_margin_block_start
   */
  /**
   * Whether a page used the CSS property margin-block-start. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_margin_block_start(1180);

  /**
   * generated from use.counter.css.page.css_margin_bottom
   */
  /**
   * Whether a page used the CSS property margin-bottom. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_margin_bottom(1181);

  /**
   * generated from use.counter.css.page.css_margin_inline
   */
  /**
   * Whether a page used the CSS property margin-inline. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_margin_inline(1182);

  /**
   * generated from use.counter.css.page.css_margin_inline_end
   */
  /**
   * Whether a page used the CSS property margin-inline-end. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_margin_inline_end(1183);

  /**
   * generated from use.counter.css.page.css_margin_inline_start
   */
  /**
   * Whether a page used the CSS property margin-inline-start. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_margin_inline_start(1184);

  /**
   * generated from use.counter.css.page.css_margin_left
   */
  /**
   * Whether a page used the CSS property margin-left. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_margin_left(1185);

  /**
   * generated from use.counter.css.page.css_margin_right
   */
  /**
   * Whether a page used the CSS property margin-right. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_margin_right(1186);

  /**
   * generated from use.counter.css.page.css_margin_top
   */
  /**
   * Whether a page used the CSS property margin-top. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_margin_top(1187);

  /**
   * generated from use.counter.css.page.css_marker
   */
  /**
   * Whether a page used the CSS property marker. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_marker(1188);

  /**
   * generated from use.counter.css.page.css_marker_end
   */
  /**
   * Whether a page used the CSS property marker-end. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_marker_end(1189);

  /**
   * generated from use.counter.css.page.css_marker_mid
   */
  /**
   * Whether a page used the CSS property marker-mid. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_marker_mid(1190);

  /**
   * generated from use.counter.css.page.css_marker_start
   */
  /**
   * Whether a page used the CSS property marker-start. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_marker_start(1191);

  /**
   * generated from use.counter.css.page.css_mask
   */
  /**
   * Whether a page used the CSS property mask. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_mask(1192);

  /**
   * generated from use.counter.css.page.css_mask_clip
   */
  /**
   * Whether a page used the CSS property mask-clip. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_mask_clip(1193);

  /**
   * generated from use.counter.css.page.css_mask_composite
   */
  /**
   * Whether a page used the CSS property mask-composite. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_mask_composite(1194);

  /**
   * generated from use.counter.css.page.css_mask_image
   */
  /**
   * Whether a page used the CSS property mask-image. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_mask_image(1195);

  /**
   * generated from use.counter.css.page.css_mask_mode
   */
  /**
   * Whether a page used the CSS property mask-mode. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_mask_mode(1196);

  /**
   * generated from use.counter.css.page.css_mask_origin
   */
  /**
   * Whether a page used the CSS property mask-origin. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_mask_origin(1197);

  /**
   * generated from use.counter.css.page.css_mask_position
   */
  /**
   * Whether a page used the CSS property mask-position. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_mask_position(1198);

  /**
   * generated from use.counter.css.page.css_mask_position_x
   */
  /**
   * Whether a page used the CSS property mask-position-x. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_mask_position_x(1199);

  /**
   * generated from use.counter.css.page.css_mask_position_y
   */
  /**
   * Whether a page used the CSS property mask-position-y. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_mask_position_y(1200);

  /**
   * generated from use.counter.css.page.css_mask_repeat
   */
  /**
   * Whether a page used the CSS property mask-repeat. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_mask_repeat(1201);

  /**
   * generated from use.counter.css.page.css_mask_size
   */
  /**
   * Whether a page used the CSS property mask-size. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_mask_size(1202);

  /**
   * generated from use.counter.css.page.css_mask_type
   */
  /**
   * Whether a page used the CSS property mask-type. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_mask_type(1203);

  /**
   * generated from use.counter.css.page.css_masonry_auto_flow
   */
  /**
   * Whether a page used the CSS property masonry-auto-flow. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_masonry_auto_flow(1204);

  /**
   * generated from use.counter.css.page.css_math_depth
   */
  /**
   * Whether a page used the CSS property math-depth. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_math_depth(1205);

  /**
   * generated from use.counter.css.page.css_math_style
   */
  /**
   * Whether a page used the CSS property math-style. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_math_style(1206);

  /**
   * generated from use.counter.css.page.css_max_block_size
   */
  /**
   * Whether a page used the CSS property max-block-size. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_max_block_size(1207);

  /**
   * generated from use.counter.css.page.css_max_height
   */
  /**
   * Whether a page used the CSS property max-height. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_max_height(1208);

  /**
   * generated from use.counter.css.page.css_max_inline_size
   */
  /**
   * Whether a page used the CSS property max-inline-size. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_max_inline_size(1209);

  /**
   * generated from use.counter.css.page.css_max_width
   */
  /**
   * Whether a page used the CSS property max-width. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_max_width(1210);

  /**
   * generated from use.counter.css.page.css_min_block_size
   */
  /**
   * Whether a page used the CSS property min-block-size. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_min_block_size(1211);

  /**
   * generated from use.counter.css.page.css_min_height
   */
  /**
   * Whether a page used the CSS property min-height. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_min_height(1212);

  /**
   * generated from use.counter.css.page.css_min_inline_size
   */
  /**
   * Whether a page used the CSS property min-inline-size. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_min_inline_size(1213);

  /**
   * generated from use.counter.css.page.css_min_width
   */
  /**
   * Whether a page used the CSS property min-width. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_min_width(1214);

  /**
   * generated from use.counter.css.page.css_mix_blend_mode
   */
  /**
   * Whether a page used the CSS property mix-blend-mode. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_mix_blend_mode(1215);

  /**
   * generated from use.counter.css.page.css_moz_animation
   */
  /**
   * Whether a page used the CSS property -moz-animation. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_animation(1216);

  /**
   * generated from use.counter.css.page.css_moz_animation_delay
   */
  /**
   * Whether a page used the CSS property -moz-animation-delay. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_animation_delay(1217);

  /**
   * generated from use.counter.css.page.css_moz_animation_direction
   */
  /**
   * Whether a page used the CSS property -moz-animation-direction. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_animation_direction(1218);

  /**
   * generated from use.counter.css.page.css_moz_animation_duration
   */
  /**
   * Whether a page used the CSS property -moz-animation-duration. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_animation_duration(1219);

  /**
   * generated from use.counter.css.page.css_moz_animation_fill_mode
   */
  /**
   * Whether a page used the CSS property -moz-animation-fill-mode. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_animation_fill_mode(1220);

  /**
   * generated from use.counter.css.page.css_moz_animation_iteration_count
   */
  /**
   * Whether a page used the CSS property -moz-animation-iteration-count. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric css_moz_animation_iteration_count(1221);

  /**
   * generated from use.counter.css.page.css_moz_animation_name
   */
  /**
   * Whether a page used the CSS property -moz-animation-name. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_animation_name(1222);

  /**
   * generated from use.counter.css.page.css_moz_animation_play_state
   */
  /**
   * Whether a page used the CSS property -moz-animation-play-state. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_animation_play_state(1223);

  /**
   * generated from use.counter.css.page.css_moz_animation_timing_function
   */
  /**
   * Whether a page used the CSS property -moz-animation-timing-function. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric css_moz_animation_timing_function(1224);

  /**
   * generated from use.counter.css.page.css_moz_appearance
   */
  /**
   * Whether a page used the CSS property -moz-appearance. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_appearance(1225);

  /**
   * generated from use.counter.css.page.css_moz_backface_visibility
   */
  /**
   * Whether a page used the CSS property -moz-backface-visibility. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_backface_visibility(1226);

  /**
   * generated from use.counter.css.page.css_moz_border_end
   */
  /**
   * Whether a page used the CSS property -moz-border-end. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_border_end(1227);

  /**
   * generated from use.counter.css.page.css_moz_border_end_color
   */
  /**
   * Whether a page used the CSS property -moz-border-end-color. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_border_end_color(1228);

  /**
   * generated from use.counter.css.page.css_moz_border_end_style
   */
  /**
   * Whether a page used the CSS property -moz-border-end-style. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_border_end_style(1229);

  /**
   * generated from use.counter.css.page.css_moz_border_end_width
   */
  /**
   * Whether a page used the CSS property -moz-border-end-width. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_border_end_width(1230);

  /**
   * generated from use.counter.css.page.css_moz_border_image
   */
  /**
   * Whether a page used the CSS property -moz-border-image. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_border_image(1231);

  /**
   * generated from use.counter.css.page.css_moz_border_start
   */
  /**
   * Whether a page used the CSS property -moz-border-start. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_border_start(1232);

  /**
   * generated from use.counter.css.page.css_moz_border_start_color
   */
  /**
   * Whether a page used the CSS property -moz-border-start-color. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_border_start_color(1233);

  /**
   * generated from use.counter.css.page.css_moz_border_start_style
   */
  /**
   * Whether a page used the CSS property -moz-border-start-style. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_border_start_style(1234);

  /**
   * generated from use.counter.css.page.css_moz_border_start_width
   */
  /**
   * Whether a page used the CSS property -moz-border-start-width. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_border_start_width(1235);

  /**
   * generated from use.counter.css.page.css_moz_box_align
   */
  /**
   * Whether a page used the CSS property -moz-box-align. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_box_align(1236);

  /**
   * generated from use.counter.css.page.css_moz_box_collapse
   */
  /**
   * Whether a page used the CSS property -moz-box-collapse. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_box_collapse(1237);

  /**
   * generated from use.counter.css.page.css_moz_box_direction
   */
  /**
   * Whether a page used the CSS property -moz-box-direction. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_box_direction(1238);

  /**
   * generated from use.counter.css.page.css_moz_box_flex
   */
  /**
   * Whether a page used the CSS property -moz-box-flex. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_box_flex(1239);

  /**
   * generated from use.counter.css.page.css_moz_box_ordinal_group
   */
  /**
   * Whether a page used the CSS property -moz-box-ordinal-group. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_box_ordinal_group(1240);

  /**
   * generated from use.counter.css.page.css_moz_box_orient
   */
  /**
   * Whether a page used the CSS property -moz-box-orient. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_box_orient(1241);

  /**
   * generated from use.counter.css.page.css_moz_box_pack
   */
  /**
   * Whether a page used the CSS property -moz-box-pack. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_box_pack(1242);

  /**
   * generated from use.counter.css.page.css_moz_box_sizing
   */
  /**
   * Whether a page used the CSS property -moz-box-sizing. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_box_sizing(1243);

  /**
   * generated from use.counter.css.page.css_moz_context_properties
   */
  /**
   * Whether a page used the CSS property -moz-context-properties. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_context_properties(1244);

  /**
   * generated from use.counter.css.page.css_moz_control_character_visibility
   */
  /**
   * Whether a page used the CSS property -moz-control-character-visibility. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric css_moz_control_character_visibility(1245);

  /**
   * generated from use.counter.css.page.css_moz_default_appearance
   */
  /**
   * Whether a page used the CSS property -moz-default-appearance. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_default_appearance(1246);

  /**
   * generated from use.counter.css.page.css_moz_float_edge
   */
  /**
   * Whether a page used the CSS property -moz-float-edge. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_float_edge(1247);

  /**
   * generated from use.counter.css.page.css_moz_font_feature_settings
   */
  /**
   * Whether a page used the CSS property -moz-font-feature-settings. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric css_moz_font_feature_settings(1248);

  /**
   * generated from use.counter.css.page.css_moz_font_language_override
   */
  /**
   * Whether a page used the CSS property -moz-font-language-override. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric css_moz_font_language_override(1249);

  /**
   * generated from use.counter.css.page.css_moz_force_broken_image_icon
   */
  /**
   * Whether a page used the CSS property -moz-force-broken-image-icon. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric css_moz_force_broken_image_icon(1250);

  /**
   * generated from use.counter.css.page.css_moz_hyphens
   */
  /**
   * Whether a page used the CSS property -moz-hyphens. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_hyphens(1251);

  /**
   * generated from use.counter.css.page.css_moz_inert
   */
  /**
   * Whether a page used the CSS property -moz-inert. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_inert(1252);

  /**
   * generated from use.counter.css.page.css_moz_margin_end
   */
  /**
   * Whether a page used the CSS property -moz-margin-end. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_margin_end(1253);

  /**
   * generated from use.counter.css.page.css_moz_margin_start
   */
  /**
   * Whether a page used the CSS property -moz-margin-start. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_margin_start(1254);

  /**
   * generated from use.counter.css.page.css_moz_math_variant
   */
  /**
   * Whether a page used the CSS property -moz-math-variant. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_math_variant(1255);

  /**
   * generated from use.counter.css.page.css_moz_min_font_size_ratio
   */
  /**
   * Whether a page used the CSS property -moz-min-font-size-ratio. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_min_font_size_ratio(1256);

  /**
   * generated from use.counter.css.page.css_moz_orient
   */
  /**
   * Whether a page used the CSS property -moz-orient. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_orient(1257);

  /**
   * generated from use.counter.css.page.css_moz_osx_font_smoothing
   */
  /**
   * Whether a page used the CSS property -moz-osx-font-smoothing. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_osx_font_smoothing(1258);

  /**
   * generated from use.counter.css.page.css_moz_padding_end
   */
  /**
   * Whether a page used the CSS property -moz-padding-end. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_padding_end(1259);

  /**
   * generated from use.counter.css.page.css_moz_padding_start
   */
  /**
   * Whether a page used the CSS property -moz-padding-start. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_padding_start(1260);

  /**
   * generated from use.counter.css.page.css_moz_perspective
   */
  /**
   * Whether a page used the CSS property -moz-perspective. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_perspective(1261);

  /**
   * generated from use.counter.css.page.css_moz_perspective_origin
   */
  /**
   * Whether a page used the CSS property -moz-perspective-origin. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_perspective_origin(1262);

  /**
   * generated from use.counter.css.page.css_moz_subtree_hidden_only_visually
   */
  /**
   * Whether a page used the CSS property -moz-subtree-hidden-only-visually. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric css_moz_subtree_hidden_only_visually(1263);

  /**
   * generated from use.counter.css.page.css_moz_tab_size
   */
  /**
   * Whether a page used the CSS property -moz-tab-size. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_tab_size(1264);

  /**
   * generated from use.counter.css.page.css_moz_text_size_adjust
   */
  /**
   * Whether a page used the CSS property -moz-text-size-adjust. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_text_size_adjust(1265);

  /**
   * generated from use.counter.css.page.css_moz_theme
   */
  /**
   * Whether a page used the CSS property -moz-theme. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_theme(1266);

  /**
   * generated from use.counter.css.page.css_moz_top_layer
   */
  /**
   * Whether a page used the CSS property -moz-top-layer. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_top_layer(1267);

  /**
   * generated from use.counter.css.page.css_moz_transform
   */
  /**
   * Whether a page used the CSS property -moz-transform. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_transform(1268);

  /**
   * generated from use.counter.css.page.css_moz_transform_origin
   */
  /**
   * Whether a page used the CSS property -moz-transform-origin. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_transform_origin(1269);

  /**
   * generated from use.counter.css.page.css_moz_transform_style
   */
  /**
   * Whether a page used the CSS property -moz-transform-style. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_transform_style(1270);

  /**
   * generated from use.counter.css.page.css_moz_transition
   */
  /**
   * Whether a page used the CSS property -moz-transition. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_transition(1271);

  /**
   * generated from use.counter.css.page.css_moz_transition_delay
   */
  /**
   * Whether a page used the CSS property -moz-transition-delay. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_transition_delay(1272);

  /**
   * generated from use.counter.css.page.css_moz_transition_duration
   */
  /**
   * Whether a page used the CSS property -moz-transition-duration. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_transition_duration(1273);

  /**
   * generated from use.counter.css.page.css_moz_transition_property
   */
  /**
   * Whether a page used the CSS property -moz-transition-property. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_transition_property(1274);

  /**
   * generated from use.counter.css.page.css_moz_transition_timing_function
   */
  /**
   * Whether a page used the CSS property -moz-transition-timing-function. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric css_moz_transition_timing_function(1275);

  /**
   * generated from use.counter.css.page.css_moz_user_focus
   */
  /**
   * Whether a page used the CSS property -moz-user-focus. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_user_focus(1276);

  /**
   * generated from use.counter.css.page.css_moz_user_input
   */
  /**
   * Whether a page used the CSS property -moz-user-input. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_user_input(1277);

  /**
   * generated from use.counter.css.page.css_moz_user_modify
   */
  /**
   * Whether a page used the CSS property -moz-user-modify. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_user_modify(1278);

  /**
   * generated from use.counter.css.page.css_moz_user_select
   */
  /**
   * Whether a page used the CSS property -moz-user-select. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_user_select(1279);

  /**
   * generated from use.counter.css.page.css_moz_window_dragging
   */
  /**
   * Whether a page used the CSS property -moz-window-dragging. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_window_dragging(1280);

  /**
   * generated from use.counter.css.page.css_moz_window_input_region_margin
   */
  /**
   * Whether a page used the CSS property -moz-window-input-region-margin. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric css_moz_window_input_region_margin(1281);

  /**
   * generated from use.counter.css.page.css_moz_window_opacity
   */
  /**
   * Whether a page used the CSS property -moz-window-opacity. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_window_opacity(1282);

  /**
   * generated from use.counter.css.page.css_moz_window_shadow
   */
  /**
   * Whether a page used the CSS property -moz-window-shadow. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_window_shadow(1283);

  /**
   * generated from use.counter.css.page.css_moz_window_transform
   */
  /**
   * Whether a page used the CSS property -moz-window-transform. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_moz_window_transform(1284);

  /**
   * generated from use.counter.css.page.css_moz_window_transform_origin
   */
  /**
   * Whether a page used the CSS property -moz-window-transform-origin. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric css_moz_window_transform_origin(1285);

  /**
   * generated from use.counter.css.page.css_object_fit
   */
  /**
   * Whether a page used the CSS property object-fit. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_object_fit(1286);

  /**
   * generated from use.counter.css.page.css_object_position
   */
  /**
   * Whether a page used the CSS property object-position. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_object_position(1287);

  /**
   * generated from use.counter.css.page.css_offset
   */
  /**
   * Whether a page used the CSS property offset. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_offset(1288);

  /**
   * generated from use.counter.css.page.css_offset_anchor
   */
  /**
   * Whether a page used the CSS property offset-anchor. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_offset_anchor(1289);

  /**
   * generated from use.counter.css.page.css_offset_distance
   */
  /**
   * Whether a page used the CSS property offset-distance. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_offset_distance(1290);

  /**
   * generated from use.counter.css.page.css_offset_path
   */
  /**
   * Whether a page used the CSS property offset-path. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_offset_path(1291);

  /**
   * generated from use.counter.css.page.css_offset_position
   */
  /**
   * Whether a page used the CSS property offset-position. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_offset_position(1292);

  /**
   * generated from use.counter.css.page.css_offset_rotate
   */
  /**
   * Whether a page used the CSS property offset-rotate. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_offset_rotate(1293);

  /**
   * generated from use.counter.css.page.css_opacity
   */
  /**
   * Whether a page used the CSS property opacity. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_opacity(1294);

  /**
   * generated from use.counter.css.page.css_order
   */
  /**
   * Whether a page used the CSS property order. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_order(1295);

  /**
   * generated from use.counter.css.page.css_outline
   */
  /**
   * Whether a page used the CSS property outline. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_outline(1296);

  /**
   * generated from use.counter.css.page.css_outline_color
   */
  /**
   * Whether a page used the CSS property outline-color. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_outline_color(1297);

  /**
   * generated from use.counter.css.page.css_outline_offset
   */
  /**
   * Whether a page used the CSS property outline-offset. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_outline_offset(1298);

  /**
   * generated from use.counter.css.page.css_outline_style
   */
  /**
   * Whether a page used the CSS property outline-style. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_outline_style(1299);

  /**
   * generated from use.counter.css.page.css_outline_width
   */
  /**
   * Whether a page used the CSS property outline-width. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_outline_width(1300);

  /**
   * generated from use.counter.css.page.css_overflow
   */
  /**
   * Whether a page used the CSS property overflow. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_overflow(1301);

  /**
   * generated from use.counter.css.page.css_overflow_anchor
   */
  /**
   * Whether a page used the CSS property overflow-anchor. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_overflow_anchor(1302);

  /**
   * generated from use.counter.css.page.css_overflow_block
   */
  /**
   * Whether a page used the CSS property overflow-block. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_overflow_block(1303);

  /**
   * generated from use.counter.css.page.css_overflow_clip_box
   */
  /**
   * Whether a page used the CSS property overflow-clip-box. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_overflow_clip_box(1304);

  /**
   * generated from use.counter.css.page.css_overflow_clip_box_block
   */
  /**
   * Whether a page used the CSS property overflow-clip-box-block. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_overflow_clip_box_block(1305);

  /**
   * generated from use.counter.css.page.css_overflow_clip_box_inline
   */
  /**
   * Whether a page used the CSS property overflow-clip-box-inline. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_overflow_clip_box_inline(1306);

  /**
   * generated from use.counter.css.page.css_overflow_clip_margin
   */
  /**
   * Whether a page used the CSS property overflow-clip-margin. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_overflow_clip_margin(1307);

  /**
   * generated from use.counter.css.page.css_overflow_inline
   */
  /**
   * Whether a page used the CSS property overflow-inline. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_overflow_inline(1308);

  /**
   * generated from use.counter.css.page.css_overflow_wrap
   */
  /**
   * Whether a page used the CSS property overflow-wrap. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_overflow_wrap(1309);

  /**
   * generated from use.counter.css.page.css_overflow_x
   */
  /**
   * Whether a page used the CSS property overflow-x. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_overflow_x(1310);

  /**
   * generated from use.counter.css.page.css_overflow_y
   */
  /**
   * Whether a page used the CSS property overflow-y. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_overflow_y(1311);

  /**
   * generated from use.counter.css.page.css_overscroll_behavior
   */
  /**
   * Whether a page used the CSS property overscroll-behavior. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_overscroll_behavior(1312);

  /**
   * generated from use.counter.css.page.css_overscroll_behavior_block
   */
  /**
   * Whether a page used the CSS property overscroll-behavior-block. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_overscroll_behavior_block(1313);

  /**
   * generated from use.counter.css.page.css_overscroll_behavior_inline
   */
  /**
   * Whether a page used the CSS property overscroll-behavior-inline. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric css_overscroll_behavior_inline(1314);

  /**
   * generated from use.counter.css.page.css_overscroll_behavior_x
   */
  /**
   * Whether a page used the CSS property overscroll-behavior-x. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_overscroll_behavior_x(1315);

  /**
   * generated from use.counter.css.page.css_overscroll_behavior_y
   */
  /**
   * Whether a page used the CSS property overscroll-behavior-y. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_overscroll_behavior_y(1316);

  /**
   * generated from use.counter.css.page.css_padding
   */
  /**
   * Whether a page used the CSS property padding. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_padding(1317);

  /**
   * generated from use.counter.css.page.css_padding_block
   */
  /**
   * Whether a page used the CSS property padding-block. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_padding_block(1318);

  /**
   * generated from use.counter.css.page.css_padding_block_end
   */
  /**
   * Whether a page used the CSS property padding-block-end. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_padding_block_end(1319);

  /**
   * generated from use.counter.css.page.css_padding_block_start
   */
  /**
   * Whether a page used the CSS property padding-block-start. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_padding_block_start(1320);

  /**
   * generated from use.counter.css.page.css_padding_bottom
   */
  /**
   * Whether a page used the CSS property padding-bottom. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_padding_bottom(1321);

  /**
   * generated from use.counter.css.page.css_padding_inline
   */
  /**
   * Whether a page used the CSS property padding-inline. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_padding_inline(1322);

  /**
   * generated from use.counter.css.page.css_padding_inline_end
   */
  /**
   * Whether a page used the CSS property padding-inline-end. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_padding_inline_end(1323);

  /**
   * generated from use.counter.css.page.css_padding_inline_start
   */
  /**
   * Whether a page used the CSS property padding-inline-start. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_padding_inline_start(1324);

  /**
   * generated from use.counter.css.page.css_padding_left
   */
  /**
   * Whether a page used the CSS property padding-left. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_padding_left(1325);

  /**
   * generated from use.counter.css.page.css_padding_right
   */
  /**
   * Whether a page used the CSS property padding-right. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_padding_right(1326);

  /**
   * generated from use.counter.css.page.css_padding_top
   */
  /**
   * Whether a page used the CSS property padding-top. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_padding_top(1327);

  /**
   * generated from use.counter.css.page.css_page
   */
  /**
   * Whether a page used the CSS property page. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_page(1328);

  /**
   * generated from use.counter.css.page.css_page_break_after
   */
  /**
   * Whether a page used the CSS property page-break-after. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_page_break_after(1329);

  /**
   * generated from use.counter.css.page.css_page_break_before
   */
  /**
   * Whether a page used the CSS property page-break-before. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_page_break_before(1330);

  /**
   * generated from use.counter.css.page.css_page_break_inside
   */
  /**
   * Whether a page used the CSS property page-break-inside. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_page_break_inside(1331);

  /**
   * generated from use.counter.css.page.css_page_orientation
   */
  /**
   * Whether a page used the CSS property page-orientation. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_page_orientation(1332);

  /**
   * generated from use.counter.css.page.css_paint_order
   */
  /**
   * Whether a page used the CSS property paint-order. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_paint_order(1333);

  /**
   * generated from use.counter.css.page.css_perspective
   */
  /**
   * Whether a page used the CSS property perspective. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_perspective(1334);

  /**
   * generated from use.counter.css.page.css_perspective_origin
   */
  /**
   * Whether a page used the CSS property perspective-origin. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_perspective_origin(1335);

  /**
   * generated from use.counter.css.page.css_place_content
   */
  /**
   * Whether a page used the CSS property place-content. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_place_content(1336);

  /**
   * generated from use.counter.css.page.css_place_items
   */
  /**
   * Whether a page used the CSS property place-items. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_place_items(1337);

  /**
   * generated from use.counter.css.page.css_place_self
   */
  /**
   * Whether a page used the CSS property place-self. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_place_self(1338);

  /**
   * generated from use.counter.css.page.css_pointer_events
   */
  /**
   * Whether a page used the CSS property pointer-events. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_pointer_events(1339);

  /**
   * generated from use.counter.css.page.css_position
   */
  /**
   * Whether a page used the CSS property position. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_position(1340);

  /**
   * generated from use.counter.css.page.css_position_anchor
   */
  /**
   * Whether a page used the CSS property position-anchor. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_position_anchor(1341);

  /**
   * generated from use.counter.css.page.css_position_try_options
   */
  /**
   * Whether a page used the CSS property position-try-options. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_position_try_options(1342);

  /**
   * generated from use.counter.css.page.css_position_try_order
   */
  /**
   * Whether a page used the CSS property position-try-order. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_position_try_order(1343);

  /**
   * generated from use.counter.css.page.css_position_visibility
   */
  /**
   * Whether a page used the CSS property position-visibility. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_position_visibility(1344);

  /**
   * generated from use.counter.css.page.css_print_color_adjust
   */
  /**
   * Whether a page used the CSS property print-color-adjust. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_print_color_adjust(1345);

  /**
   * generated from use.counter.css.page.css_quotes
   */
  /**
   * Whether a page used the CSS property quotes. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_quotes(1346);

  /**
   * generated from use.counter.css.page.css_r
   */
  /**
   * Whether a page used the CSS property r. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_r(1347);

  /**
   * generated from use.counter.css.page.css_resize
   */
  /**
   * Whether a page used the CSS property resize. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_resize(1348);

  /**
   * generated from use.counter.css.page.css_right
   */
  /**
   * Whether a page used the CSS property right. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_right(1349);

  /**
   * generated from use.counter.css.page.css_rotate
   */
  /**
   * Whether a page used the CSS property rotate. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_rotate(1350);

  /**
   * generated from use.counter.css.page.css_row_gap
   */
  /**
   * Whether a page used the CSS property row-gap. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_row_gap(1351);

  /**
   * generated from use.counter.css.page.css_ruby_align
   */
  /**
   * Whether a page used the CSS property ruby-align. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_ruby_align(1352);

  /**
   * generated from use.counter.css.page.css_ruby_position
   */
  /**
   * Whether a page used the CSS property ruby-position. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_ruby_position(1353);

  /**
   * generated from use.counter.css.page.css_rx
   */
  /**
   * Whether a page used the CSS property rx. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_rx(1354);

  /**
   * generated from use.counter.css.page.css_ry
   */
  /**
   * Whether a page used the CSS property ry. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_ry(1355);

  /**
   * generated from use.counter.css.page.css_scale
   */
  /**
   * Whether a page used the CSS property scale. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scale(1356);

  /**
   * generated from use.counter.css.page.css_scroll_behavior
   */
  /**
   * Whether a page used the CSS property scroll-behavior. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scroll_behavior(1357);

  /**
   * generated from use.counter.css.page.css_scroll_margin
   */
  /**
   * Whether a page used the CSS property scroll-margin. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scroll_margin(1358);

  /**
   * generated from use.counter.css.page.css_scroll_margin_block
   */
  /**
   * Whether a page used the CSS property scroll-margin-block. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scroll_margin_block(1359);

  /**
   * generated from use.counter.css.page.css_scroll_margin_block_end
   */
  /**
   * Whether a page used the CSS property scroll-margin-block-end. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scroll_margin_block_end(1360);

  /**
   * generated from use.counter.css.page.css_scroll_margin_block_start
   */
  /**
   * Whether a page used the CSS property scroll-margin-block-start. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scroll_margin_block_start(1361);

  /**
   * generated from use.counter.css.page.css_scroll_margin_bottom
   */
  /**
   * Whether a page used the CSS property scroll-margin-bottom. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scroll_margin_bottom(1362);

  /**
   * generated from use.counter.css.page.css_scroll_margin_inline
   */
  /**
   * Whether a page used the CSS property scroll-margin-inline. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scroll_margin_inline(1363);

  /**
   * generated from use.counter.css.page.css_scroll_margin_inline_end
   */
  /**
   * Whether a page used the CSS property scroll-margin-inline-end. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scroll_margin_inline_end(1364);

  /**
   * generated from use.counter.css.page.css_scroll_margin_inline_start
   */
  /**
   * Whether a page used the CSS property scroll-margin-inline-start. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric css_scroll_margin_inline_start(1365);

  /**
   * generated from use.counter.css.page.css_scroll_margin_left
   */
  /**
   * Whether a page used the CSS property scroll-margin-left. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scroll_margin_left(1366);

  /**
   * generated from use.counter.css.page.css_scroll_margin_right
   */
  /**
   * Whether a page used the CSS property scroll-margin-right. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scroll_margin_right(1367);

  /**
   * generated from use.counter.css.page.css_scroll_margin_top
   */
  /**
   * Whether a page used the CSS property scroll-margin-top. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scroll_margin_top(1368);

  /**
   * generated from use.counter.css.page.css_scroll_padding
   */
  /**
   * Whether a page used the CSS property scroll-padding. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scroll_padding(1369);

  /**
   * generated from use.counter.css.page.css_scroll_padding_block
   */
  /**
   * Whether a page used the CSS property scroll-padding-block. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scroll_padding_block(1370);

  /**
   * generated from use.counter.css.page.css_scroll_padding_block_end
   */
  /**
   * Whether a page used the CSS property scroll-padding-block-end. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scroll_padding_block_end(1371);

  /**
   * generated from use.counter.css.page.css_scroll_padding_block_start
   */
  /**
   * Whether a page used the CSS property scroll-padding-block-start. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric css_scroll_padding_block_start(1372);

  /**
   * generated from use.counter.css.page.css_scroll_padding_bottom
   */
  /**
   * Whether a page used the CSS property scroll-padding-bottom. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scroll_padding_bottom(1373);

  /**
   * generated from use.counter.css.page.css_scroll_padding_inline
   */
  /**
   * Whether a page used the CSS property scroll-padding-inline. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scroll_padding_inline(1374);

  /**
   * generated from use.counter.css.page.css_scroll_padding_inline_end
   */
  /**
   * Whether a page used the CSS property scroll-padding-inline-end. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scroll_padding_inline_end(1375);

  /**
   * generated from use.counter.css.page.css_scroll_padding_inline_start
   */
  /**
   * Whether a page used the CSS property scroll-padding-inline-start. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric css_scroll_padding_inline_start(1376);

  /**
   * generated from use.counter.css.page.css_scroll_padding_left
   */
  /**
   * Whether a page used the CSS property scroll-padding-left. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scroll_padding_left(1377);

  /**
   * generated from use.counter.css.page.css_scroll_padding_right
   */
  /**
   * Whether a page used the CSS property scroll-padding-right. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scroll_padding_right(1378);

  /**
   * generated from use.counter.css.page.css_scroll_padding_top
   */
  /**
   * Whether a page used the CSS property scroll-padding-top. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scroll_padding_top(1379);

  /**
   * generated from use.counter.css.page.css_scroll_snap_align
   */
  /**
   * Whether a page used the CSS property scroll-snap-align. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scroll_snap_align(1380);

  /**
   * generated from use.counter.css.page.css_scroll_snap_stop
   */
  /**
   * Whether a page used the CSS property scroll-snap-stop. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scroll_snap_stop(1381);

  /**
   * generated from use.counter.css.page.css_scroll_snap_type
   */
  /**
   * Whether a page used the CSS property scroll-snap-type. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scroll_snap_type(1382);

  /**
   * generated from use.counter.css.page.css_scroll_timeline
   */
  /**
   * Whether a page used the CSS property scroll-timeline. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scroll_timeline(1383);

  /**
   * generated from use.counter.css.page.css_scroll_timeline_axis
   */
  /**
   * Whether a page used the CSS property scroll-timeline-axis. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scroll_timeline_axis(1384);

  /**
   * generated from use.counter.css.page.css_scroll_timeline_name
   */
  /**
   * Whether a page used the CSS property scroll-timeline-name. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scroll_timeline_name(1385);

  /**
   * generated from use.counter.css.page.css_scrollbar_color
   */
  /**
   * Whether a page used the CSS property scrollbar-color. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scrollbar_color(1386);

  /**
   * generated from use.counter.css.page.css_scrollbar_gutter
   */
  /**
   * Whether a page used the CSS property scrollbar-gutter. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scrollbar_gutter(1387);

  /**
   * generated from use.counter.css.page.css_scrollbar_width
   */
  /**
   * Whether a page used the CSS property scrollbar-width. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_scrollbar_width(1388);

  /**
   * generated from use.counter.css.page.css_shape_image_threshold
   */
  /**
   * Whether a page used the CSS property shape-image-threshold. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_shape_image_threshold(1389);

  /**
   * generated from use.counter.css.page.css_shape_margin
   */
  /**
   * Whether a page used the CSS property shape-margin. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_shape_margin(1390);

  /**
   * generated from use.counter.css.page.css_shape_outside
   */
  /**
   * Whether a page used the CSS property shape-outside. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_shape_outside(1391);

  /**
   * generated from use.counter.css.page.css_shape_rendering
   */
  /**
   * Whether a page used the CSS property shape-rendering. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_shape_rendering(1392);

  /**
   * generated from use.counter.css.page.css_size
   */
  /**
   * Whether a page used the CSS property size. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_size(1393);

  /**
   * generated from use.counter.css.page.css_stop_color
   */
  /**
   * Whether a page used the CSS property stop-color. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_stop_color(1394);

  /**
   * generated from use.counter.css.page.css_stop_opacity
   */
  /**
   * Whether a page used the CSS property stop-opacity. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_stop_opacity(1395);

  /**
   * generated from use.counter.css.page.css_stroke
   */
  /**
   * Whether a page used the CSS property stroke. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_stroke(1396);

  /**
   * generated from use.counter.css.page.css_stroke_dasharray
   */
  /**
   * Whether a page used the CSS property stroke-dasharray. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_stroke_dasharray(1397);

  /**
   * generated from use.counter.css.page.css_stroke_dashoffset
   */
  /**
   * Whether a page used the CSS property stroke-dashoffset. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_stroke_dashoffset(1398);

  /**
   * generated from use.counter.css.page.css_stroke_linecap
   */
  /**
   * Whether a page used the CSS property stroke-linecap. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_stroke_linecap(1399);

  /**
   * generated from use.counter.css.page.css_stroke_linejoin
   */
  /**
   * Whether a page used the CSS property stroke-linejoin. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_stroke_linejoin(1400);

  /**
   * generated from use.counter.css.page.css_stroke_miterlimit
   */
  /**
   * Whether a page used the CSS property stroke-miterlimit. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_stroke_miterlimit(1401);

  /**
   * generated from use.counter.css.page.css_stroke_opacity
   */
  /**
   * Whether a page used the CSS property stroke-opacity. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_stroke_opacity(1402);

  /**
   * generated from use.counter.css.page.css_stroke_width
   */
  /**
   * Whether a page used the CSS property stroke-width. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_stroke_width(1403);

  /**
   * generated from use.counter.css.page.css_tab_size
   */
  /**
   * Whether a page used the CSS property tab-size. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_tab_size(1404);

  /**
   * generated from use.counter.css.page.css_table_layout
   */
  /**
   * Whether a page used the CSS property table-layout. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_table_layout(1405);

  /**
   * generated from use.counter.css.page.css_text_align
   */
  /**
   * Whether a page used the CSS property text-align. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_text_align(1406);

  /**
   * generated from use.counter.css.page.css_text_align_last
   */
  /**
   * Whether a page used the CSS property text-align-last. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_text_align_last(1407);

  /**
   * generated from use.counter.css.page.css_text_anchor
   */
  /**
   * Whether a page used the CSS property text-anchor. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_text_anchor(1408);

  /**
   * generated from use.counter.css.page.css_text_combine_upright
   */
  /**
   * Whether a page used the CSS property text-combine-upright. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_text_combine_upright(1409);

  /**
   * generated from use.counter.css.page.css_text_decoration
   */
  /**
   * Whether a page used the CSS property text-decoration. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_text_decoration(1410);

  /**
   * generated from use.counter.css.page.css_text_decoration_color
   */
  /**
   * Whether a page used the CSS property text-decoration-color. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_text_decoration_color(1411);

  /**
   * generated from use.counter.css.page.css_text_decoration_line
   */
  /**
   * Whether a page used the CSS property text-decoration-line. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_text_decoration_line(1412);

  /**
   * generated from use.counter.css.page.css_text_decoration_skip_ink
   */
  /**
   * Whether a page used the CSS property text-decoration-skip-ink. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_text_decoration_skip_ink(1413);

  /**
   * generated from use.counter.css.page.css_text_decoration_style
   */
  /**
   * Whether a page used the CSS property text-decoration-style. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_text_decoration_style(1414);

  /**
   * generated from use.counter.css.page.css_text_decoration_thickness
   */
  /**
   * Whether a page used the CSS property text-decoration-thickness. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_text_decoration_thickness(1415);

  /**
   * generated from use.counter.css.page.css_text_emphasis
   */
  /**
   * Whether a page used the CSS property text-emphasis. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_text_emphasis(1416);

  /**
   * generated from use.counter.css.page.css_text_emphasis_color
   */
  /**
   * Whether a page used the CSS property text-emphasis-color. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_text_emphasis_color(1417);

  /**
   * generated from use.counter.css.page.css_text_emphasis_position
   */
  /**
   * Whether a page used the CSS property text-emphasis-position. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_text_emphasis_position(1418);

  /**
   * generated from use.counter.css.page.css_text_emphasis_style
   */
  /**
   * Whether a page used the CSS property text-emphasis-style. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_text_emphasis_style(1419);

  /**
   * generated from use.counter.css.page.css_text_indent
   */
  /**
   * Whether a page used the CSS property text-indent. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_text_indent(1420);

  /**
   * generated from use.counter.css.page.css_text_justify
   */
  /**
   * Whether a page used the CSS property text-justify. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_text_justify(1421);

  /**
   * generated from use.counter.css.page.css_text_orientation
   */
  /**
   * Whether a page used the CSS property text-orientation. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_text_orientation(1422);

  /**
   * generated from use.counter.css.page.css_text_overflow
   */
  /**
   * Whether a page used the CSS property text-overflow. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_text_overflow(1423);

  /**
   * generated from use.counter.css.page.css_text_rendering
   */
  /**
   * Whether a page used the CSS property text-rendering. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_text_rendering(1424);

  /**
   * generated from use.counter.css.page.css_text_shadow
   */
  /**
   * Whether a page used the CSS property text-shadow. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_text_shadow(1425);

  /**
   * generated from use.counter.css.page.css_text_transform
   */
  /**
   * Whether a page used the CSS property text-transform. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_text_transform(1426);

  /**
   * generated from use.counter.css.page.css_text_underline_offset
   */
  /**
   * Whether a page used the CSS property text-underline-offset. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_text_underline_offset(1427);

  /**
   * generated from use.counter.css.page.css_text_underline_position
   */
  /**
   * Whether a page used the CSS property text-underline-position. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_text_underline_position(1428);

  /**
   * generated from use.counter.css.page.css_text_wrap
   */
  /**
   * Whether a page used the CSS property text-wrap. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_text_wrap(1429);

  /**
   * generated from use.counter.css.page.css_text_wrap_mode
   */
  /**
   * Whether a page used the CSS property text-wrap-mode. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_text_wrap_mode(1430);

  /**
   * generated from use.counter.css.page.css_text_wrap_style
   */
  /**
   * Whether a page used the CSS property text-wrap-style. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_text_wrap_style(1431);

  /**
   * generated from use.counter.css.page.css_top
   */
  /**
   * Whether a page used the CSS property top. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_top(1432);

  /**
   * generated from use.counter.css.page.css_touch_action
   */
  /**
   * Whether a page used the CSS property touch-action. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_touch_action(1433);

  /**
   * generated from use.counter.css.page.css_transform
   */
  /**
   * Whether a page used the CSS property transform. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_transform(1434);

  /**
   * generated from use.counter.css.page.css_transform_box
   */
  /**
   * Whether a page used the CSS property transform-box. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_transform_box(1435);

  /**
   * generated from use.counter.css.page.css_transform_origin
   */
  /**
   * Whether a page used the CSS property transform-origin. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_transform_origin(1436);

  /**
   * generated from use.counter.css.page.css_transform_style
   */
  /**
   * Whether a page used the CSS property transform-style. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_transform_style(1437);

  /**
   * generated from use.counter.css.page.css_transition
   */
  /**
   * Whether a page used the CSS property transition. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_transition(1438);

  /**
   * generated from use.counter.css.page.css_transition_behavior
   */
  /**
   * Whether a page used the CSS property transition-behavior. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_transition_behavior(1439);

  /**
   * generated from use.counter.css.page.css_transition_delay
   */
  /**
   * Whether a page used the CSS property transition-delay. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_transition_delay(1440);

  /**
   * generated from use.counter.css.page.css_transition_duration
   */
  /**
   * Whether a page used the CSS property transition-duration. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_transition_duration(1441);

  /**
   * generated from use.counter.css.page.css_transition_property
   */
  /**
   * Whether a page used the CSS property transition-property. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_transition_property(1442);

  /**
   * generated from use.counter.css.page.css_transition_timing_function
   */
  /**
   * Whether a page used the CSS property transition-timing-function. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric css_transition_timing_function(1443);

  /**
   * generated from use.counter.css.page.css_translate
   */
  /**
   * Whether a page used the CSS property translate. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_translate(1444);

  /**
   * generated from use.counter.css.page.css_unicode_bidi
   */
  /**
   * Whether a page used the CSS property unicode-bidi. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_unicode_bidi(1445);

  /**
   * generated from use.counter.css.page.css_user_select
   */
  /**
   * Whether a page used the CSS property user-select. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_user_select(1446);

  /**
   * generated from use.counter.css.page.css_vector_effect
   */
  /**
   * Whether a page used the CSS property vector-effect. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_vector_effect(1447);

  /**
   * generated from use.counter.css.page.css_vertical_align
   */
  /**
   * Whether a page used the CSS property vertical-align. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_vertical_align(1448);

  /**
   * generated from use.counter.css.page.css_view_timeline
   */
  /**
   * Whether a page used the CSS property view-timeline. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_view_timeline(1449);

  /**
   * generated from use.counter.css.page.css_view_timeline_axis
   */
  /**
   * Whether a page used the CSS property view-timeline-axis. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_view_timeline_axis(1450);

  /**
   * generated from use.counter.css.page.css_view_timeline_inset
   */
  /**
   * Whether a page used the CSS property view-timeline-inset. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_view_timeline_inset(1451);

  /**
   * generated from use.counter.css.page.css_view_timeline_name
   */
  /**
   * Whether a page used the CSS property view-timeline-name. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_view_timeline_name(1452);

  /**
   * generated from use.counter.css.page.css_visibility
   */
  /**
   * Whether a page used the CSS property visibility. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_visibility(1453);

  /**
   * generated from use.counter.css.page.css_webkit_align_content
   */
  /**
   * Whether a page used the CSS property -webkit-align-content. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_align_content(1454);

  /**
   * generated from use.counter.css.page.css_webkit_align_items
   */
  /**
   * Whether a page used the CSS property -webkit-align-items. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_align_items(1455);

  /**
   * generated from use.counter.css.page.css_webkit_align_self
   */
  /**
   * Whether a page used the CSS property -webkit-align-self. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_align_self(1456);

  /**
   * generated from use.counter.css.page.css_webkit_animation
   */
  /**
   * Whether a page used the CSS property -webkit-animation. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_animation(1457);

  /**
   * generated from use.counter.css.page.css_webkit_animation_delay
   */
  /**
   * Whether a page used the CSS property -webkit-animation-delay. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_animation_delay(1458);

  /**
   * generated from use.counter.css.page.css_webkit_animation_direction
   */
  /**
   * Whether a page used the CSS property -webkit-animation-direction. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric css_webkit_animation_direction(1459);

  /**
   * generated from use.counter.css.page.css_webkit_animation_duration
   */
  /**
   * Whether a page used the CSS property -webkit-animation-duration. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric css_webkit_animation_duration(1460);

  /**
   * generated from use.counter.css.page.css_webkit_animation_fill_mode
   */
  /**
   * Whether a page used the CSS property -webkit-animation-fill-mode. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric css_webkit_animation_fill_mode(1461);

  /**
   * generated from use.counter.css.page.css_webkit_animation_iteration_count
   */
  /**
   * Whether a page used the CSS property -webkit-animation-iteration-count. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric css_webkit_animation_iteration_count(1462);

  /**
   * generated from use.counter.css.page.css_webkit_animation_name
   */
  /**
   * Whether a page used the CSS property -webkit-animation-name. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_animation_name(1463);

  /**
   * generated from use.counter.css.page.css_webkit_animation_play_state
   */
  /**
   * Whether a page used the CSS property -webkit-animation-play-state. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric css_webkit_animation_play_state(1464);

  /**
   * generated from use.counter.css.page.css_webkit_animation_timing_function
   */
  /**
   * Whether a page used the CSS property -webkit-animation-timing-function. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric css_webkit_animation_timing_function(1465);

  /**
   * generated from use.counter.css.page.css_webkit_appearance
   */
  /**
   * Whether a page used the CSS property -webkit-appearance. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_appearance(1466);

  /**
   * generated from use.counter.css.page.css_webkit_backface_visibility
   */
  /**
   * Whether a page used the CSS property -webkit-backface-visibility. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric css_webkit_backface_visibility(1467);

  /**
   * generated from use.counter.css.page.css_webkit_background_clip
   */
  /**
   * Whether a page used the CSS property -webkit-background-clip. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_background_clip(1468);

  /**
   * generated from use.counter.css.page.css_webkit_background_origin
   */
  /**
   * Whether a page used the CSS property -webkit-background-origin. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_background_origin(1469);

  /**
   * generated from use.counter.css.page.css_webkit_background_size
   */
  /**
   * Whether a page used the CSS property -webkit-background-size. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_background_size(1470);

  /**
   * generated from use.counter.css.page.css_webkit_border_bottom_left_radius
   */
  /**
   * Whether a page used the CSS property -webkit-border-bottom-left-radius. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric css_webkit_border_bottom_left_radius(1471);

  /**
   * generated from use.counter.css.page.css_webkit_border_bottom_right_radius
   */
  /**
   * Whether a page used the CSS property -webkit-border-bottom-right-radius.
     * Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_border_bottom_right_radius(1472);

  /**
   * generated from use.counter.css.page.css_webkit_border_image
   */
  /**
   * Whether a page used the CSS property -webkit-border-image. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_border_image(1473);

  /**
   * generated from use.counter.css.page.css_webkit_border_radius
   */
  /**
   * Whether a page used the CSS property -webkit-border-radius. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_border_radius(1474);

  /**
   * generated from use.counter.css.page.css_webkit_border_top_left_radius
   */
  /**
   * Whether a page used the CSS property -webkit-border-top-left-radius. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric css_webkit_border_top_left_radius(1475);

  /**
   * generated from use.counter.css.page.css_webkit_border_top_right_radius
   */
  /**
   * Whether a page used the CSS property -webkit-border-top-right-radius. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric css_webkit_border_top_right_radius(1476);

  /**
   * generated from use.counter.css.page.css_webkit_box_align
   */
  /**
   * Whether a page used the CSS property -webkit-box-align. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_box_align(1477);

  /**
   * generated from use.counter.css.page.css_webkit_box_direction
   */
  /**
   * Whether a page used the CSS property -webkit-box-direction. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_box_direction(1478);

  /**
   * generated from use.counter.css.page.css_webkit_box_flex
   */
  /**
   * Whether a page used the CSS property -webkit-box-flex. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_box_flex(1479);

  /**
   * generated from use.counter.css.page.css_webkit_box_ordinal_group
   */
  /**
   * Whether a page used the CSS property -webkit-box-ordinal-group. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_box_ordinal_group(1480);

  /**
   * generated from use.counter.css.page.css_webkit_box_orient
   */
  /**
   * Whether a page used the CSS property -webkit-box-orient. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_box_orient(1481);

  /**
   * generated from use.counter.css.page.css_webkit_box_pack
   */
  /**
   * Whether a page used the CSS property -webkit-box-pack. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_box_pack(1482);

  /**
   * generated from use.counter.css.page.css_webkit_box_shadow
   */
  /**
   * Whether a page used the CSS property -webkit-box-shadow. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_box_shadow(1483);

  /**
   * generated from use.counter.css.page.css_webkit_box_sizing
   */
  /**
   * Whether a page used the CSS property -webkit-box-sizing. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_box_sizing(1484);

  /**
   * generated from use.counter.css.page.css_webkit_clip_path
   */
  /**
   * Whether a page used the CSS property -webkit-clip-path. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_clip_path(1485);

  /**
   * generated from use.counter.css.page.css_webkit_filter
   */
  /**
   * Whether a page used the CSS property -webkit-filter. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_filter(1486);

  /**
   * generated from use.counter.css.page.css_webkit_flex
   */
  /**
   * Whether a page used the CSS property -webkit-flex. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_flex(1487);

  /**
   * generated from use.counter.css.page.css_webkit_flex_basis
   */
  /**
   * Whether a page used the CSS property -webkit-flex-basis. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_flex_basis(1488);

  /**
   * generated from use.counter.css.page.css_webkit_flex_direction
   */
  /**
   * Whether a page used the CSS property -webkit-flex-direction. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_flex_direction(1489);

  /**
   * generated from use.counter.css.page.css_webkit_flex_flow
   */
  /**
   * Whether a page used the CSS property -webkit-flex-flow. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_flex_flow(1490);

  /**
   * generated from use.counter.css.page.css_webkit_flex_grow
   */
  /**
   * Whether a page used the CSS property -webkit-flex-grow. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_flex_grow(1491);

  /**
   * generated from use.counter.css.page.css_webkit_flex_shrink
   */
  /**
   * Whether a page used the CSS property -webkit-flex-shrink. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_flex_shrink(1492);

  /**
   * generated from use.counter.css.page.css_webkit_flex_wrap
   */
  /**
   * Whether a page used the CSS property -webkit-flex-wrap. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_flex_wrap(1493);

  /**
   * generated from use.counter.css.page.css_webkit_font_smoothing
   */
  /**
   * Whether a page used the CSS property -webkit-font-smoothing. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_font_smoothing(1494);

  /**
   * generated from use.counter.css.page.css_webkit_justify_content
   */
  /**
   * Whether a page used the CSS property -webkit-justify-content. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_justify_content(1495);

  /**
   * generated from use.counter.css.page.css_webkit_line_clamp
   */
  /**
   * Whether a page used the CSS property -webkit-line-clamp. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_line_clamp(1496);

  /**
   * generated from use.counter.css.page.css_webkit_mask
   */
  /**
   * Whether a page used the CSS property -webkit-mask. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_mask(1497);

  /**
   * generated from use.counter.css.page.css_webkit_mask_clip
   */
  /**
   * Whether a page used the CSS property -webkit-mask-clip. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_mask_clip(1498);

  /**
   * generated from use.counter.css.page.css_webkit_mask_composite
   */
  /**
   * Whether a page used the CSS property -webkit-mask-composite. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_mask_composite(1499);

  /**
   * generated from use.counter.css.page.css_webkit_mask_image
   */
  /**
   * Whether a page used the CSS property -webkit-mask-image. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_mask_image(1500);

  /**
   * generated from use.counter.css.page.css_webkit_mask_origin
   */
  /**
   * Whether a page used the CSS property -webkit-mask-origin. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_mask_origin(1501);

  /**
   * generated from use.counter.css.page.css_webkit_mask_position
   */
  /**
   * Whether a page used the CSS property -webkit-mask-position. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_mask_position(1502);

  /**
   * generated from use.counter.css.page.css_webkit_mask_position_x
   */
  /**
   * Whether a page used the CSS property -webkit-mask-position-x. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_mask_position_x(1503);

  /**
   * generated from use.counter.css.page.css_webkit_mask_position_y
   */
  /**
   * Whether a page used the CSS property -webkit-mask-position-y. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_mask_position_y(1504);

  /**
   * generated from use.counter.css.page.css_webkit_mask_repeat
   */
  /**
   * Whether a page used the CSS property -webkit-mask-repeat. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_mask_repeat(1505);

  /**
   * generated from use.counter.css.page.css_webkit_mask_size
   */
  /**
   * Whether a page used the CSS property -webkit-mask-size. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_mask_size(1506);

  /**
   * generated from use.counter.css.page.css_webkit_order
   */
  /**
   * Whether a page used the CSS property -webkit-order. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_order(1507);

  /**
   * generated from use.counter.css.page.css_webkit_perspective
   */
  /**
   * Whether a page used the CSS property -webkit-perspective. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_perspective(1508);

  /**
   * generated from use.counter.css.page.css_webkit_perspective_origin
   */
  /**
   * Whether a page used the CSS property -webkit-perspective-origin. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric css_webkit_perspective_origin(1509);

  /**
   * generated from use.counter.css.page.css_webkit_text_fill_color
   */
  /**
   * Whether a page used the CSS property -webkit-text-fill-color. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_text_fill_color(1510);

  /**
   * generated from use.counter.css.page.css_webkit_text_security
   */
  /**
   * Whether a page used the CSS property -webkit-text-security. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_text_security(1511);

  /**
   * generated from use.counter.css.page.css_webkit_text_size_adjust
   */
  /**
   * Whether a page used the CSS property -webkit-text-size-adjust. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_text_size_adjust(1512);

  /**
   * generated from use.counter.css.page.css_webkit_text_stroke
   */
  /**
   * Whether a page used the CSS property -webkit-text-stroke. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_text_stroke(1513);

  /**
   * generated from use.counter.css.page.css_webkit_text_stroke_color
   */
  /**
   * Whether a page used the CSS property -webkit-text-stroke-color. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_text_stroke_color(1514);

  /**
   * generated from use.counter.css.page.css_webkit_text_stroke_width
   */
  /**
   * Whether a page used the CSS property -webkit-text-stroke-width. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_text_stroke_width(1515);

  /**
   * generated from use.counter.css.page.css_webkit_transform
   */
  /**
   * Whether a page used the CSS property -webkit-transform. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_transform(1516);

  /**
   * generated from use.counter.css.page.css_webkit_transform_origin
   */
  /**
   * Whether a page used the CSS property -webkit-transform-origin. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_transform_origin(1517);

  /**
   * generated from use.counter.css.page.css_webkit_transform_style
   */
  /**
   * Whether a page used the CSS property -webkit-transform-style. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_transform_style(1518);

  /**
   * generated from use.counter.css.page.css_webkit_transition
   */
  /**
   * Whether a page used the CSS property -webkit-transition. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_transition(1519);

  /**
   * generated from use.counter.css.page.css_webkit_transition_delay
   */
  /**
   * Whether a page used the CSS property -webkit-transition-delay. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_transition_delay(1520);

  /**
   * generated from use.counter.css.page.css_webkit_transition_duration
   */
  /**
   * Whether a page used the CSS property -webkit-transition-duration. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric css_webkit_transition_duration(1521);

  /**
   * generated from use.counter.css.page.css_webkit_transition_property
   */
  /**
   * Whether a page used the CSS property -webkit-transition-property. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric css_webkit_transition_property(1522);

  /**
   * generated from use.counter.css.page.css_webkit_transition_timing_function
   */
  /**
   * Whether a page used the CSS property -webkit-transition-timing-function.
     * Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_transition_timing_function(1523);

  /**
   * generated from use.counter.css.page.css_webkit_user_select
   */
  /**
   * Whether a page used the CSS property -webkit-user-select. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_webkit_user_select(1524);

  /**
   * generated from use.counter.css.page.css_white_space
   */
  /**
   * Whether a page used the CSS property white-space. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_white_space(1525);

  /**
   * generated from use.counter.css.page.css_white_space_collapse
   */
  /**
   * Whether a page used the CSS property white-space-collapse. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_white_space_collapse(1526);

  /**
   * generated from use.counter.css.page.css_width
   */
  /**
   * Whether a page used the CSS property width. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_width(1527);

  /**
   * generated from use.counter.css.page.css_will_change
   */
  /**
   * Whether a page used the CSS property will-change. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_will_change(1528);

  /**
   * generated from use.counter.css.page.css_word_break
   */
  /**
   * Whether a page used the CSS property word-break. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_word_break(1529);

  /**
   * generated from use.counter.css.page.css_word_spacing
   */
  /**
   * Whether a page used the CSS property word-spacing. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_word_spacing(1530);

  /**
   * generated from use.counter.css.page.css_word_wrap
   */
  /**
   * Whether a page used the CSS property word-wrap. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_word_wrap(1531);

  /**
   * generated from use.counter.css.page.css_writing_mode
   */
  /**
   * Whether a page used the CSS property writing-mode. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_writing_mode(1532);

  /**
   * generated from use.counter.css.page.css_x
   */
  /**
   * Whether a page used the CSS property x. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_x(1533);

  /**
   * generated from use.counter.css.page.css_x_lang
   */
  /**
   * Whether a page used the CSS property -x-lang. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_x_lang(1534);

  /**
   * generated from use.counter.css.page.css_x_span
   */
  /**
   * Whether a page used the CSS property -x-span. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_x_span(1535);

  /**
   * generated from use.counter.css.page.css_x_text_scale
   */
  /**
   * Whether a page used the CSS property -x-text-scale. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_x_text_scale(1536);

  /**
   * generated from use.counter.css.page.css_y
   */
  /**
   * Whether a page used the CSS property y. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_y(1537);

  /**
   * generated from use.counter.css.page.css_z_index
   */
  /**
   * Whether a page used the CSS property z-index. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_z_index(1538);

  /**
   * generated from use.counter.css.page.css_zoom
   */
  /**
   * Whether a page used the CSS property zoom. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric css_zoom(1539);

  /**
   * generated from use.counter.css.page.max_zoom
   */
  /**
   * Whether a page used the (unknown, counted) CSS property max-zoom. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric max_zoom(1540);

  /**
   * generated from use.counter.css.page.min_zoom
   */
  /**
   * Whether a page used the (unknown, counted) CSS property min-zoom. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric min_zoom(1541);

  /**
   * generated from use.counter.css.page.orientation
   */
  /**
   * Whether a page used the (unknown, counted) CSS property orientation. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric orientation(1542);

  /**
   * generated from use.counter.css.page.orphans
   */
  /**
   * Whether a page used the (unknown, counted) CSS property orphans. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric orphans(1543);

  /**
   * generated from use.counter.css.page.speak
   */
  /**
   * Whether a page used the (unknown, counted) CSS property speak. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric speak(1544);

  /**
   * generated from use.counter.css.page.text_size_adjust
   */
  /**
   * Whether a page used the (unknown, counted) CSS property text-size-adjust.
     * Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric text_size_adjust(1545);

  /**
   * generated from use.counter.css.page.user_zoom
   */
  /**
   * Whether a page used the (unknown, counted) CSS property user-zoom. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric user_zoom(1546);

  /**
   * generated from use.counter.css.page.webkit_app_region
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-app-region.
     * Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_app_region(1547);

  /**
   * generated from use.counter.css.page.webkit_border_after
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-border-after.
     * Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_border_after(1548);

  /**
   * generated from use.counter.css.page.webkit_border_after_color
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-border-after-
     * color. Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_border_after_color(1549);

  /**
   * generated from use.counter.css.page.webkit_border_after_style
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-border-after-
     * style. Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_border_after_style(1550);

  /**
   * generated from use.counter.css.page.webkit_border_after_width
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-border-after-
     * width. Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_border_after_width(1551);

  /**
   * generated from use.counter.css.page.webkit_border_before
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-border-before.
     * Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_border_before(1552);

  /**
   * generated from use.counter.css.page.webkit_border_before_color
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-border-before-
     * color. Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_border_before_color(1553);

  /**
   * generated from use.counter.css.page.webkit_border_before_style
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-border-before-
     * style. Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_border_before_style(1554);

  /**
   * generated from use.counter.css.page.webkit_border_before_width
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-border-before-
     * width. Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_border_before_width(1555);

  /**
   * generated from use.counter.css.page.webkit_border_end
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-border-end.
     * Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_border_end(1556);

  /**
   * generated from use.counter.css.page.webkit_border_end_color
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-border-end-
     * color. Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_border_end_color(1557);

  /**
   * generated from use.counter.css.page.webkit_border_end_style
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-border-end-
     * style. Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_border_end_style(1558);

  /**
   * generated from use.counter.css.page.webkit_border_end_width
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-border-end-
     * width. Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_border_end_width(1559);

  /**
   * generated from use.counter.css.page.webkit_border_horizontal_spacing
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-border-
     * horizontal-spacing. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric webkit_border_horizontal_spacing(1560);

  /**
   * generated from use.counter.css.page.webkit_border_start
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-border-start.
     * Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_border_start(1561);

  /**
   * generated from use.counter.css.page.webkit_border_start_color
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-border-start-
     * color. Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_border_start_color(1562);

  /**
   * generated from use.counter.css.page.webkit_border_start_style
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-border-start-
     * style. Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_border_start_style(1563);

  /**
   * generated from use.counter.css.page.webkit_border_start_width
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-border-start-
     * width. Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_border_start_width(1564);

  /**
   * generated from use.counter.css.page.webkit_border_vertical_spacing
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-border-
     * vertical-spacing. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric webkit_border_vertical_spacing(1565);

  /**
   * generated from use.counter.css.page.webkit_box_decoration_break
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-box-decoration-
     * break. Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_box_decoration_break(1566);

  /**
   * generated from use.counter.css.page.webkit_box_reflect
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-box-reflect.
     * Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_box_reflect(1567);

  /**
   * generated from use.counter.css.page.webkit_column_break_after
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-column-break-
     * after. Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_column_break_after(1568);

  /**
   * generated from use.counter.css.page.webkit_column_break_before
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-column-break-
     * before. Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_column_break_before(1569);

  /**
   * generated from use.counter.css.page.webkit_column_break_inside
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-column-break-
     * inside. Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_column_break_inside(1570);

  /**
   * generated from use.counter.css.page.webkit_column_count
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-column-count.
     * Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_column_count(1571);

  /**
   * generated from use.counter.css.page.webkit_column_gap
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-column-gap.
     * Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_column_gap(1572);

  /**
   * generated from use.counter.css.page.webkit_column_rule
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-column-rule.
     * Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_column_rule(1573);

  /**
   * generated from use.counter.css.page.webkit_column_rule_color
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-column-rule-
     * color. Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_column_rule_color(1574);

  /**
   * generated from use.counter.css.page.webkit_column_rule_style
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-column-rule-
     * style. Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_column_rule_style(1575);

  /**
   * generated from use.counter.css.page.webkit_column_rule_width
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-column-rule-
     * width. Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_column_rule_width(1576);

  /**
   * generated from use.counter.css.page.webkit_column_span
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-column-span.
     * Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_column_span(1577);

  /**
   * generated from use.counter.css.page.webkit_column_width
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-column-width.
     * Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_column_width(1578);

  /**
   * generated from use.counter.css.page.webkit_columns
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-columns.
     * Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_columns(1579);

  /**
   * generated from use.counter.css.page.webkit_font_feature_settings
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-font-feature-
     * settings. Compare against `use.counter.top_level_content_documents_destroyed`
     * to calculate the rate.
   */
  constexpr impl::CounterMetric webkit_font_feature_settings(1580);

  /**
   * generated from use.counter.css.page.webkit_font_size_delta
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-font-size-
     * delta. Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_font_size_delta(1581);

  /**
   * generated from use.counter.css.page.webkit_highlight
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-highlight.
     * Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_highlight(1582);

  /**
   * generated from use.counter.css.page.webkit_hyphenate_character
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-hyphenate-
     * character. Compare against `use.counter.top_level_content_documents_destroyed`
     * to calculate the rate.
   */
  constexpr impl::CounterMetric webkit_hyphenate_character(1583);

  /**
   * generated from use.counter.css.page.webkit_line_break
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-line-break.
     * Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_line_break(1584);

  /**
   * generated from use.counter.css.page.webkit_locale
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-locale. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric webkit_locale(1585);

  /**
   * generated from use.counter.css.page.webkit_logical_height
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-logical-height.
     * Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_logical_height(1586);

  /**
   * generated from use.counter.css.page.webkit_logical_width
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-logical-width.
     * Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_logical_width(1587);

  /**
   * generated from use.counter.css.page.webkit_margin_after
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-margin-after.
     * Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_margin_after(1588);

  /**
   * generated from use.counter.css.page.webkit_margin_after_collapse
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-margin-after-
     * collapse. Compare against `use.counter.top_level_content_documents_destroyed`
     * to calculate the rate.
   */
  constexpr impl::CounterMetric webkit_margin_after_collapse(1589);

  /**
   * generated from use.counter.css.page.webkit_margin_before
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-margin-before.
     * Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_margin_before(1590);

  /**
   * generated from use.counter.css.page.webkit_margin_before_collapse
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-margin-before-
     * collapse. Compare against `use.counter.top_level_content_documents_destroyed`
     * to calculate the rate.
   */
  constexpr impl::CounterMetric webkit_margin_before_collapse(1591);

  /**
   * generated from use.counter.css.page.webkit_margin_bottom_collapse
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-margin-bottom-
     * collapse. Compare against `use.counter.top_level_content_documents_destroyed`
     * to calculate the rate.
   */
  constexpr impl::CounterMetric webkit_margin_bottom_collapse(1592);

  /**
   * generated from use.counter.css.page.webkit_margin_collapse
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-margin-
     * collapse. Compare against `use.counter.top_level_content_documents_destroyed`
     * to calculate the rate.
   */
  constexpr impl::CounterMetric webkit_margin_collapse(1593);

  /**
   * generated from use.counter.css.page.webkit_margin_end
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-margin-end.
     * Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_margin_end(1594);

  /**
   * generated from use.counter.css.page.webkit_margin_start
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-margin-start.
     * Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_margin_start(1595);

  /**
   * generated from use.counter.css.page.webkit_margin_top_collapse
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-margin-top-
     * collapse. Compare against `use.counter.top_level_content_documents_destroyed`
     * to calculate the rate.
   */
  constexpr impl::CounterMetric webkit_margin_top_collapse(1596);

  /**
   * generated from use.counter.css.page.webkit_mask_box_image
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-mask-box-image.
     * Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_mask_box_image(1597);

  /**
   * generated from use.counter.css.page.webkit_mask_box_image_outset
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-mask-box-image-
     * outset. Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_mask_box_image_outset(1598);

  /**
   * generated from use.counter.css.page.webkit_mask_box_image_repeat
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-mask-box-image-
     * repeat. Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_mask_box_image_repeat(1599);

  /**
   * generated from use.counter.css.page.webkit_mask_box_image_slice
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-mask-box-image-
     * slice. Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_mask_box_image_slice(1600);

  /**
   * generated from use.counter.css.page.webkit_mask_box_image_source
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-mask-box-image-
     * source. Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_mask_box_image_source(1601);

  /**
   * generated from use.counter.css.page.webkit_mask_box_image_width
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-mask-box-image-
     * width. Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_mask_box_image_width(1602);

  /**
   * generated from use.counter.css.page.webkit_mask_repeat_x
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-mask-repeat-x.
     * Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_mask_repeat_x(1603);

  /**
   * generated from use.counter.css.page.webkit_mask_repeat_y
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-mask-repeat-y.
     * Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_mask_repeat_y(1604);

  /**
   * generated from use.counter.css.page.webkit_max_logical_height
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-max-logical-
     * height. Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_max_logical_height(1605);

  /**
   * generated from use.counter.css.page.webkit_max_logical_width
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-max-logical-
     * width. Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_max_logical_width(1606);

  /**
   * generated from use.counter.css.page.webkit_min_logical_height
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-min-logical-
     * height. Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_min_logical_height(1607);

  /**
   * generated from use.counter.css.page.webkit_min_logical_width
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-min-logical-
     * width. Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_min_logical_width(1608);

  /**
   * generated from use.counter.css.page.webkit_opacity
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-opacity.
     * Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_opacity(1609);

  /**
   * generated from use.counter.css.page.webkit_padding_after
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-padding-after.
     * Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_padding_after(1610);

  /**
   * generated from use.counter.css.page.webkit_padding_before
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-padding-before.
     * Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_padding_before(1611);

  /**
   * generated from use.counter.css.page.webkit_padding_end
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-padding-end.
     * Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_padding_end(1612);

  /**
   * generated from use.counter.css.page.webkit_padding_start
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-padding-start.
     * Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_padding_start(1613);

  /**
   * generated from use.counter.css.page.webkit_perspective_origin_x
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-perspective-
     * origin-x. Compare against `use.counter.top_level_content_documents_destroyed`
     * to calculate the rate.
   */
  constexpr impl::CounterMetric webkit_perspective_origin_x(1614);

  /**
   * generated from use.counter.css.page.webkit_perspective_origin_y
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-perspective-
     * origin-y. Compare against `use.counter.top_level_content_documents_destroyed`
     * to calculate the rate.
   */
  constexpr impl::CounterMetric webkit_perspective_origin_y(1615);

  /**
   * generated from use.counter.css.page.webkit_print_color_adjust
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-print-color-
     * adjust. Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_print_color_adjust(1616);

  /**
   * generated from use.counter.css.page.webkit_rtl_ordering
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-rtl-ordering.
     * Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_rtl_ordering(1617);

  /**
   * generated from use.counter.css.page.webkit_ruby_position
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-ruby-position.
     * Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_ruby_position(1618);

  /**
   * generated from use.counter.css.page.webkit_shape_image_threshold
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-shape-image-
     * threshold. Compare against `use.counter.top_level_content_documents_destroyed`
     * to calculate the rate.
   */
  constexpr impl::CounterMetric webkit_shape_image_threshold(1619);

  /**
   * generated from use.counter.css.page.webkit_shape_margin
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-shape-margin.
     * Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_shape_margin(1620);

  /**
   * generated from use.counter.css.page.webkit_shape_outside
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-shape-outside.
     * Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_shape_outside(1621);

  /**
   * generated from use.counter.css.page.webkit_tap_highlight_color
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-tap-highlight-
     * color. Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_tap_highlight_color(1622);

  /**
   * generated from use.counter.css.page.webkit_text_combine
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-text-combine.
     * Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_text_combine(1623);

  /**
   * generated from use.counter.css.page.webkit_text_decorations_in_effect
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-text-
     * decorations-in-effect. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric webkit_text_decorations_in_effect(1624);

  /**
   * generated from use.counter.css.page.webkit_text_emphasis
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-text-emphasis.
     * Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_text_emphasis(1625);

  /**
   * generated from use.counter.css.page.webkit_text_emphasis_color
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-text-emphasis-
     * color. Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_text_emphasis_color(1626);

  /**
   * generated from use.counter.css.page.webkit_text_emphasis_position
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-text-emphasis-
     * position. Compare against `use.counter.top_level_content_documents_destroyed`
     * to calculate the rate.
   */
  constexpr impl::CounterMetric webkit_text_emphasis_position(1627);

  /**
   * generated from use.counter.css.page.webkit_text_emphasis_style
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-text-emphasis-
     * style. Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_text_emphasis_style(1628);

  /**
   * generated from use.counter.css.page.webkit_text_orientation
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-text-
     * orientation. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric webkit_text_orientation(1629);

  /**
   * generated from use.counter.css.page.webkit_transform_origin_x
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-transform-
     * origin-x. Compare against `use.counter.top_level_content_documents_destroyed`
     * to calculate the rate.
   */
  constexpr impl::CounterMetric webkit_transform_origin_x(1630);

  /**
   * generated from use.counter.css.page.webkit_transform_origin_y
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-transform-
     * origin-y. Compare against `use.counter.top_level_content_documents_destroyed`
     * to calculate the rate.
   */
  constexpr impl::CounterMetric webkit_transform_origin_y(1631);

  /**
   * generated from use.counter.css.page.webkit_transform_origin_z
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-transform-
     * origin-z. Compare against `use.counter.top_level_content_documents_destroyed`
     * to calculate the rate.
   */
  constexpr impl::CounterMetric webkit_transform_origin_z(1632);

  /**
   * generated from use.counter.css.page.webkit_user_drag
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-user-drag.
     * Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_user_drag(1633);

  /**
   * generated from use.counter.css.page.webkit_user_modify
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-user-modify.
     * Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_user_modify(1634);

  /**
   * generated from use.counter.css.page.webkit_writing_mode
   */
  /**
   * Whether a page used the (unknown, counted) CSS property -webkit-writing-mode.
     * Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric webkit_writing_mode(1635);

  /**
   * generated from use.counter.css.page.widows
   */
  /**
   * Whether a page used the (unknown, counted) CSS property widows. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric widows(1636);

}
namespace use_counter_deprecated_ops_doc {
  /**
   * generated from use.counter.deprecated_ops.doc.ambient_light_event
   */
  /**
   * Whether a document used AmbientLightEvent. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric ambient_light_event(1637);

  /**
   * generated from use.counter.deprecated_ops.doc.app_cache
   */
  /**
   * Whether a document used AppCache. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric app_cache(1638);

  /**
   * generated from use.counter.deprecated_ops.doc.components
   */
  /**
   * Whether a document used Components. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric components(1639);

  /**
   * generated from use.counter.deprecated_ops.doc.create_image_bitmap_canvas_rendering_context2_d
   */
  /**
   * Whether a document used CreateImageBitmapCanvasRenderingContext2D. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric create_image_bitmap_canvas_rendering_context2_d(1640);

  /**
   * generated from use.counter.deprecated_ops.doc.deprecated_testing_attribute
   */
  /**
   * Whether a document used DeprecatedTestingAttribute. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric deprecated_testing_attribute(1641);

  /**
   * generated from use.counter.deprecated_ops.doc.deprecated_testing_interface
   */
  /**
   * Whether a document used DeprecatedTestingInterface. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric deprecated_testing_interface(1642);

  /**
   * generated from use.counter.deprecated_ops.doc.deprecated_testing_method
   */
  /**
   * Whether a document used DeprecatedTestingMethod. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric deprecated_testing_method(1643);

  /**
   * generated from use.counter.deprecated_ops.doc.document_release_capture
   */
  /**
   * Whether a document used DocumentReleaseCapture. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_release_capture(1644);

  /**
   * generated from use.counter.deprecated_ops.doc.domattr_modified
   */
  /**
   * Whether a document used DOMAttrModified. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric domattr_modified(1645);

  /**
   * generated from use.counter.deprecated_ops.doc.domcharacter_data_modified
   */
  /**
   * Whether a document used DOMCharacterDataModified. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric domcharacter_data_modified(1646);

  /**
   * generated from use.counter.deprecated_ops.doc.domnode_inserted
   */
  /**
   * Whether a document used DOMNodeInserted. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric domnode_inserted(1647);

  /**
   * generated from use.counter.deprecated_ops.doc.domnode_inserted_into_document
   */
  /**
   * Whether a document used DOMNodeInsertedIntoDocument. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric domnode_inserted_into_document(1648);

  /**
   * generated from use.counter.deprecated_ops.doc.domnode_removed
   */
  /**
   * Whether a document used DOMNodeRemoved. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric domnode_removed(1649);

  /**
   * generated from use.counter.deprecated_ops.doc.domnode_removed_from_document
   */
  /**
   * Whether a document used DOMNodeRemovedFromDocument. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric domnode_removed_from_document(1650);

  /**
   * generated from use.counter.deprecated_ops.doc.domquad_bounds_attr
   */
  /**
   * Whether a document used DOMQuadBoundsAttr. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric domquad_bounds_attr(1651);

  /**
   * generated from use.counter.deprecated_ops.doc.domsubtree_modified
   */
  /**
   * Whether a document used DOMSubtreeModified. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric domsubtree_modified(1652);

  /**
   * generated from use.counter.deprecated_ops.doc.draw_window_canvas_rendering_context2_d
   */
  /**
   * Whether a document used DrawWindowCanvasRenderingContext2D. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric draw_window_canvas_rendering_context2_d(1653);

  /**
   * generated from use.counter.deprecated_ops.doc.element_release_capture
   */
  /**
   * Whether a document used ElementReleaseCapture. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric element_release_capture(1654);

  /**
   * generated from use.counter.deprecated_ops.doc.element_set_capture
   */
  /**
   * Whether a document used ElementSetCapture. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric element_set_capture(1655);

  /**
   * generated from use.counter.deprecated_ops.doc.external__add_search_provider
   */
  /**
   * Whether a document used External_AddSearchProvider. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric external__add_search_provider(1656);

  /**
   * generated from use.counter.deprecated_ops.doc.form_submission_untrusted_event
   */
  /**
   * Whether a document used FormSubmissionUntrustedEvent. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric form_submission_untrusted_event(1657);

  /**
   * generated from use.counter.deprecated_ops.doc.idbobject_store_create_index_locale
   */
  /**
   * Whether a document used IDBObjectStoreCreateIndexLocale. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric idbobject_store_create_index_locale(1658);

  /**
   * generated from use.counter.deprecated_ops.doc.idbopen_dboptions__storage_type
   */
  /**
   * Whether a document used IDBOpenDBOptions_StorageType. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric idbopen_dboptions__storage_type(1659);

  /**
   * generated from use.counter.deprecated_ops.doc.image_bitmap_rendering_context__transfer_image_bitmap
   */
  /**
   * Whether a document used ImageBitmapRenderingContext_TransferImageBitmap.
     * Compare against `use.counter.content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric image_bitmap_rendering_context__transfer_image_bitmap(1660);

  /**
   * generated from use.counter.deprecated_ops.doc.import_xulinto_content
   */
  /**
   * Whether a document used ImportXULIntoContent. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric import_xulinto_content(1661);

  /**
   * generated from use.counter.deprecated_ops.doc.init_mouse_event
   */
  /**
   * Whether a document used InitMouseEvent. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric init_mouse_event(1662);

  /**
   * generated from use.counter.deprecated_ops.doc.init_nsmouse_event
   */
  /**
   * Whether a document used InitNSMouseEvent. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric init_nsmouse_event(1663);

  /**
   * generated from use.counter.deprecated_ops.doc.install_trigger_deprecated
   */
  /**
   * Whether a document used InstallTriggerDeprecated. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric install_trigger_deprecated(1664);

  /**
   * generated from use.counter.deprecated_ops.doc.install_trigger_install_deprecated
   */
  /**
   * Whether a document used InstallTriggerInstallDeprecated. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric install_trigger_install_deprecated(1665);

  /**
   * generated from use.counter.deprecated_ops.doc.lenient_setter
   */
  /**
   * Whether a document used LenientSetter. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric lenient_setter(1666);

  /**
   * generated from use.counter.deprecated_ops.doc.lenient_this
   */
  /**
   * Whether a document used LenientThis. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric lenient_this(1667);

  /**
   * generated from use.counter.deprecated_ops.doc.math_ml__deprecated_math_space_value2
   */
  /**
   * Whether a document used MathML_DeprecatedMathSpaceValue2. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric math_ml__deprecated_math_space_value2(1668);

  /**
   * generated from use.counter.deprecated_ops.doc.math_ml__deprecated_math_variant
   */
  /**
   * Whether a document used MathML_DeprecatedMathVariant. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric math_ml__deprecated_math_variant(1669);

  /**
   * generated from use.counter.deprecated_ops.doc.math_ml__deprecated_stixgeneral_operator_stretching
   */
  /**
   * Whether a document used MathML_DeprecatedStixgeneralOperatorStretching. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric math_ml__deprecated_stixgeneral_operator_stretching(1670);

  /**
   * generated from use.counter.deprecated_ops.doc.motion_event
   */
  /**
   * Whether a document used MotionEvent. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric motion_event(1671);

  /**
   * generated from use.counter.deprecated_ops.doc.mouse_event__moz_pressure
   */
  /**
   * Whether a document used MouseEvent_MozPressure. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric mouse_event__moz_pressure(1672);

  /**
   * generated from use.counter.deprecated_ops.doc.moz_input_source
   */
  /**
   * Whether a document used MozInputSource. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric moz_input_source(1673);

  /**
   * generated from use.counter.deprecated_ops.doc.moz_request_full_screen_deprecated_prefix
   */
  /**
   * Whether a document used MozRequestFullScreenDeprecatedPrefix. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric moz_request_full_screen_deprecated_prefix(1674);

  /**
   * generated from use.counter.deprecated_ops.doc.mozfullscreenchange_deprecated_prefix
   */
  /**
   * Whether a document used MozfullscreenchangeDeprecatedPrefix. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric mozfullscreenchange_deprecated_prefix(1675);

  /**
   * generated from use.counter.deprecated_ops.doc.mozfullscreenerror_deprecated_prefix
   */
  /**
   * Whether a document used MozfullscreenerrorDeprecatedPrefix. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric mozfullscreenerror_deprecated_prefix(1676);

  /**
   * generated from use.counter.deprecated_ops.doc.navigator_get_user_media
   */
  /**
   * Whether a document used NavigatorGetUserMedia. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric navigator_get_user_media(1677);

  /**
   * generated from use.counter.deprecated_ops.doc.node_iterator_detach
   */
  /**
   * Whether a document used NodeIteratorDetach. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric node_iterator_detach(1678);

  /**
   * generated from use.counter.deprecated_ops.doc.offscreen_canvas_to_blob
   */
  /**
   * Whether a document used OffscreenCanvasToBlob. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric offscreen_canvas_to_blob(1679);

  /**
   * generated from use.counter.deprecated_ops.doc.orientation_event
   */
  /**
   * Whether a document used OrientationEvent. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric orientation_event(1680);

  /**
   * generated from use.counter.deprecated_ops.doc.proximity_event
   */
  /**
   * Whether a document used ProximityEvent. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric proximity_event(1681);

  /**
   * generated from use.counter.deprecated_ops.doc.rtcpeer_connection_get_streams
   */
  /**
   * Whether a document used RTCPeerConnectionGetStreams. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric rtcpeer_connection_get_streams(1682);

  /**
   * generated from use.counter.deprecated_ops.doc.size_to_content
   */
  /**
   * Whether a document used SizeToContent. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric size_to_content(1683);

  /**
   * generated from use.counter.deprecated_ops.doc.svgdeselect_all
   */
  /**
   * Whether a document used SVGDeselectAll. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric svgdeselect_all(1684);

  /**
   * generated from use.counter.deprecated_ops.doc.svgfarthest_viewport_element
   */
  /**
   * Whether a document used SVGFarthestViewportElement. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric svgfarthest_viewport_element(1685);

  /**
   * generated from use.counter.deprecated_ops.doc.svgnearest_viewport_element
   */
  /**
   * Whether a document used SVGNearestViewportElement. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric svgnearest_viewport_element(1686);

  /**
   * generated from use.counter.deprecated_ops.doc.sync_xmlhttp_request_deprecated
   */
  /**
   * Whether a document used SyncXMLHttpRequestDeprecated. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric sync_xmlhttp_request_deprecated(1687);

  /**
   * generated from use.counter.deprecated_ops.doc.use_of_capture_events
   */
  /**
   * Whether a document used UseOfCaptureEvents. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric use_of_capture_events(1688);

  /**
   * generated from use.counter.deprecated_ops.doc.use_of_release_events
   */
  /**
   * Whether a document used UseOfReleaseEvents. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric use_of_release_events(1689);

  /**
   * generated from use.counter.deprecated_ops.doc.webrtc_deprecated_prefix
   */
  /**
   * Whether a document used WebrtcDeprecatedPrefix. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric webrtc_deprecated_prefix(1690);

  /**
   * generated from use.counter.deprecated_ops.doc.window__cc_ontrollers
   */
  /**
   * Whether a document used Window_Cc_ontrollers. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window__cc_ontrollers(1691);

  /**
   * generated from use.counter.deprecated_ops.doc.window_content_untrusted
   */
  /**
   * Whether a document used WindowContentUntrusted. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_content_untrusted(1692);

}
namespace use_counter_deprecated_ops_page {
  /**
   * generated from use.counter.deprecated_ops.page.ambient_light_event
   */
  /**
   * Whether a page used AmbientLightEvent. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric ambient_light_event(1693);

  /**
   * generated from use.counter.deprecated_ops.page.app_cache
   */
  /**
   * Whether a page used AppCache. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric app_cache(1694);

  /**
   * generated from use.counter.deprecated_ops.page.components
   */
  /**
   * Whether a page used Components. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric components(1695);

  /**
   * generated from use.counter.deprecated_ops.page.create_image_bitmap_canvas_rendering_context2_d
   */
  /**
   * Whether a page used CreateImageBitmapCanvasRenderingContext2D. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric create_image_bitmap_canvas_rendering_context2_d(1696);

  /**
   * generated from use.counter.deprecated_ops.page.deprecated_testing_attribute
   */
  /**
   * Whether a page used DeprecatedTestingAttribute. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric deprecated_testing_attribute(1697);

  /**
   * generated from use.counter.deprecated_ops.page.deprecated_testing_interface
   */
  /**
   * Whether a page used DeprecatedTestingInterface. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric deprecated_testing_interface(1698);

  /**
   * generated from use.counter.deprecated_ops.page.deprecated_testing_method
   */
  /**
   * Whether a page used DeprecatedTestingMethod. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric deprecated_testing_method(1699);

  /**
   * generated from use.counter.deprecated_ops.page.document_release_capture
   */
  /**
   * Whether a page used DocumentReleaseCapture. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_release_capture(1700);

  /**
   * generated from use.counter.deprecated_ops.page.domattr_modified
   */
  /**
   * Whether a page used DOMAttrModified. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric domattr_modified(1701);

  /**
   * generated from use.counter.deprecated_ops.page.domcharacter_data_modified
   */
  /**
   * Whether a page used DOMCharacterDataModified. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric domcharacter_data_modified(1702);

  /**
   * generated from use.counter.deprecated_ops.page.domnode_inserted
   */
  /**
   * Whether a page used DOMNodeInserted. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric domnode_inserted(1703);

  /**
   * generated from use.counter.deprecated_ops.page.domnode_inserted_into_document
   */
  /**
   * Whether a page used DOMNodeInsertedIntoDocument. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric domnode_inserted_into_document(1704);

  /**
   * generated from use.counter.deprecated_ops.page.domnode_removed
   */
  /**
   * Whether a page used DOMNodeRemoved. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric domnode_removed(1705);

  /**
   * generated from use.counter.deprecated_ops.page.domnode_removed_from_document
   */
  /**
   * Whether a page used DOMNodeRemovedFromDocument. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric domnode_removed_from_document(1706);

  /**
   * generated from use.counter.deprecated_ops.page.domquad_bounds_attr
   */
  /**
   * Whether a page used DOMQuadBoundsAttr. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric domquad_bounds_attr(1707);

  /**
   * generated from use.counter.deprecated_ops.page.domsubtree_modified
   */
  /**
   * Whether a page used DOMSubtreeModified. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric domsubtree_modified(1708);

  /**
   * generated from use.counter.deprecated_ops.page.draw_window_canvas_rendering_context2_d
   */
  /**
   * Whether a page used DrawWindowCanvasRenderingContext2D. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric draw_window_canvas_rendering_context2_d(1709);

  /**
   * generated from use.counter.deprecated_ops.page.element_release_capture
   */
  /**
   * Whether a page used ElementReleaseCapture. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric element_release_capture(1710);

  /**
   * generated from use.counter.deprecated_ops.page.element_set_capture
   */
  /**
   * Whether a page used ElementSetCapture. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric element_set_capture(1711);

  /**
   * generated from use.counter.deprecated_ops.page.external__add_search_provider
   */
  /**
   * Whether a page used External_AddSearchProvider. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric external__add_search_provider(1712);

  /**
   * generated from use.counter.deprecated_ops.page.form_submission_untrusted_event
   */
  /**
   * Whether a page used FormSubmissionUntrustedEvent. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric form_submission_untrusted_event(1713);

  /**
   * generated from use.counter.deprecated_ops.page.idbobject_store_create_index_locale
   */
  /**
   * Whether a page used IDBObjectStoreCreateIndexLocale. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric idbobject_store_create_index_locale(1714);

  /**
   * generated from use.counter.deprecated_ops.page.idbopen_dboptions__storage_type
   */
  /**
   * Whether a page used IDBOpenDBOptions_StorageType. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric idbopen_dboptions__storage_type(1715);

  /**
   * generated from use.counter.deprecated_ops.page.image_bitmap_rendering_context__transfer_image_bitmap
   */
  /**
   * Whether a page used ImageBitmapRenderingContext_TransferImageBitmap. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric image_bitmap_rendering_context__transfer_image_bitmap(1716);

  /**
   * generated from use.counter.deprecated_ops.page.import_xulinto_content
   */
  /**
   * Whether a page used ImportXULIntoContent. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric import_xulinto_content(1717);

  /**
   * generated from use.counter.deprecated_ops.page.init_mouse_event
   */
  /**
   * Whether a page used InitMouseEvent. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric init_mouse_event(1718);

  /**
   * generated from use.counter.deprecated_ops.page.init_nsmouse_event
   */
  /**
   * Whether a page used InitNSMouseEvent. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric init_nsmouse_event(1719);

  /**
   * generated from use.counter.deprecated_ops.page.install_trigger_deprecated
   */
  /**
   * Whether a page used InstallTriggerDeprecated. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric install_trigger_deprecated(1720);

  /**
   * generated from use.counter.deprecated_ops.page.install_trigger_install_deprecated
   */
  /**
   * Whether a page used InstallTriggerInstallDeprecated. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric install_trigger_install_deprecated(1721);

  /**
   * generated from use.counter.deprecated_ops.page.lenient_setter
   */
  /**
   * Whether a page used LenientSetter. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric lenient_setter(1722);

  /**
   * generated from use.counter.deprecated_ops.page.lenient_this
   */
  /**
   * Whether a page used LenientThis. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric lenient_this(1723);

  /**
   * generated from use.counter.deprecated_ops.page.math_ml__deprecated_math_space_value2
   */
  /**
   * Whether a page used MathML_DeprecatedMathSpaceValue2. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric math_ml__deprecated_math_space_value2(1724);

  /**
   * generated from use.counter.deprecated_ops.page.math_ml__deprecated_math_variant
   */
  /**
   * Whether a page used MathML_DeprecatedMathVariant. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric math_ml__deprecated_math_variant(1725);

  /**
   * generated from use.counter.deprecated_ops.page.math_ml__deprecated_stixgeneral_operator_stretching
   */
  /**
   * Whether a page used MathML_DeprecatedStixgeneralOperatorStretching. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric math_ml__deprecated_stixgeneral_operator_stretching(1726);

  /**
   * generated from use.counter.deprecated_ops.page.motion_event
   */
  /**
   * Whether a page used MotionEvent. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric motion_event(1727);

  /**
   * generated from use.counter.deprecated_ops.page.mouse_event__moz_pressure
   */
  /**
   * Whether a page used MouseEvent_MozPressure. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric mouse_event__moz_pressure(1728);

  /**
   * generated from use.counter.deprecated_ops.page.moz_input_source
   */
  /**
   * Whether a page used MozInputSource. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric moz_input_source(1729);

  /**
   * generated from use.counter.deprecated_ops.page.moz_request_full_screen_deprecated_prefix
   */
  /**
   * Whether a page used MozRequestFullScreenDeprecatedPrefix. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric moz_request_full_screen_deprecated_prefix(1730);

  /**
   * generated from use.counter.deprecated_ops.page.mozfullscreenchange_deprecated_prefix
   */
  /**
   * Whether a page used MozfullscreenchangeDeprecatedPrefix. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric mozfullscreenchange_deprecated_prefix(1731);

  /**
   * generated from use.counter.deprecated_ops.page.mozfullscreenerror_deprecated_prefix
   */
  /**
   * Whether a page used MozfullscreenerrorDeprecatedPrefix. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric mozfullscreenerror_deprecated_prefix(1732);

  /**
   * generated from use.counter.deprecated_ops.page.navigator_get_user_media
   */
  /**
   * Whether a page used NavigatorGetUserMedia. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric navigator_get_user_media(1733);

  /**
   * generated from use.counter.deprecated_ops.page.node_iterator_detach
   */
  /**
   * Whether a page used NodeIteratorDetach. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric node_iterator_detach(1734);

  /**
   * generated from use.counter.deprecated_ops.page.offscreen_canvas_to_blob
   */
  /**
   * Whether a page used OffscreenCanvasToBlob. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric offscreen_canvas_to_blob(1735);

  /**
   * generated from use.counter.deprecated_ops.page.orientation_event
   */
  /**
   * Whether a page used OrientationEvent. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric orientation_event(1736);

  /**
   * generated from use.counter.deprecated_ops.page.proximity_event
   */
  /**
   * Whether a page used ProximityEvent. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric proximity_event(1737);

  /**
   * generated from use.counter.deprecated_ops.page.rtcpeer_connection_get_streams
   */
  /**
   * Whether a page used RTCPeerConnectionGetStreams. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric rtcpeer_connection_get_streams(1738);

  /**
   * generated from use.counter.deprecated_ops.page.size_to_content
   */
  /**
   * Whether a page used SizeToContent. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric size_to_content(1739);

  /**
   * generated from use.counter.deprecated_ops.page.svgdeselect_all
   */
  /**
   * Whether a page used SVGDeselectAll. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric svgdeselect_all(1740);

  /**
   * generated from use.counter.deprecated_ops.page.svgfarthest_viewport_element
   */
  /**
   * Whether a page used SVGFarthestViewportElement. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric svgfarthest_viewport_element(1741);

  /**
   * generated from use.counter.deprecated_ops.page.svgnearest_viewport_element
   */
  /**
   * Whether a page used SVGNearestViewportElement. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric svgnearest_viewport_element(1742);

  /**
   * generated from use.counter.deprecated_ops.page.sync_xmlhttp_request_deprecated
   */
  /**
   * Whether a page used SyncXMLHttpRequestDeprecated. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric sync_xmlhttp_request_deprecated(1743);

  /**
   * generated from use.counter.deprecated_ops.page.use_of_capture_events
   */
  /**
   * Whether a page used UseOfCaptureEvents. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric use_of_capture_events(1744);

  /**
   * generated from use.counter.deprecated_ops.page.use_of_release_events
   */
  /**
   * Whether a page used UseOfReleaseEvents. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric use_of_release_events(1745);

  /**
   * generated from use.counter.deprecated_ops.page.webrtc_deprecated_prefix
   */
  /**
   * Whether a page used WebrtcDeprecatedPrefix. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric webrtc_deprecated_prefix(1746);

  /**
   * generated from use.counter.deprecated_ops.page.window__cc_ontrollers
   */
  /**
   * Whether a page used Window_Cc_ontrollers. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window__cc_ontrollers(1747);

  /**
   * generated from use.counter.deprecated_ops.page.window_content_untrusted
   */
  /**
   * Whether a page used WindowContentUntrusted. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_content_untrusted(1748);

}
namespace use_counter_doc {
  /**
   * generated from use.counter.doc.clipboard_read
   */
  /**
   * Whether a document called called Clipboard.read. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric clipboard_read(1749);

  /**
   * generated from use.counter.doc.clipboard_readtext
   */
  /**
   * Whether a document called called Clipboard.readText. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric clipboard_readtext(1750);

  /**
   * generated from use.counter.doc.clipboard_write
   */
  /**
   * Whether a document called called Clipboard.write. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric clipboard_write(1751);

  /**
   * generated from use.counter.doc.console_assert
   */
  /**
   * Whether a document called called console.assert. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_assert(1752);

  /**
   * generated from use.counter.doc.console_clear
   */
  /**
   * Whether a document called called console.clear. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_clear(1753);

  /**
   * generated from use.counter.doc.console_count
   */
  /**
   * Whether a document called called console.count. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_count(1754);

  /**
   * generated from use.counter.doc.console_countreset
   */
  /**
   * Whether a document called called console.countReset. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_countreset(1755);

  /**
   * generated from use.counter.doc.console_debug
   */
  /**
   * Whether a document called called console.debug. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_debug(1756);

  /**
   * generated from use.counter.doc.console_dir
   */
  /**
   * Whether a document called called console.dir. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_dir(1757);

  /**
   * generated from use.counter.doc.console_dirxml
   */
  /**
   * Whether a document called called console.dirxml. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_dirxml(1758);

  /**
   * generated from use.counter.doc.console_error
   */
  /**
   * Whether a document called called console.error. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_error(1759);

  /**
   * generated from use.counter.doc.console_exception
   */
  /**
   * Whether a document called called console.exception. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_exception(1760);

  /**
   * generated from use.counter.doc.console_group
   */
  /**
   * Whether a document called called console.group. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_group(1761);

  /**
   * generated from use.counter.doc.console_groupcollapsed
   */
  /**
   * Whether a document called called console.groupCollapsed. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_groupcollapsed(1762);

  /**
   * generated from use.counter.doc.console_groupend
   */
  /**
   * Whether a document called called console.groupEnd. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_groupend(1763);

  /**
   * generated from use.counter.doc.console_info
   */
  /**
   * Whether a document called called console.info. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_info(1764);

  /**
   * generated from use.counter.doc.console_log
   */
  /**
   * Whether a document called called console.log. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_log(1765);

  /**
   * generated from use.counter.doc.console_profile
   */
  /**
   * Whether a document called called console.profile. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_profile(1766);

  /**
   * generated from use.counter.doc.console_profileend
   */
  /**
   * Whether a document called called console.profileEnd. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_profileend(1767);

  /**
   * generated from use.counter.doc.console_table
   */
  /**
   * Whether a document called called console.table. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_table(1768);

  /**
   * generated from use.counter.doc.console_time
   */
  /**
   * Whether a document called called console.time. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_time(1769);

  /**
   * generated from use.counter.doc.console_timeend
   */
  /**
   * Whether a document called called console.timeEnd. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_timeend(1770);

  /**
   * generated from use.counter.doc.console_timelog
   */
  /**
   * Whether a document called called console.timeLog. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_timelog(1771);

  /**
   * generated from use.counter.doc.console_timestamp
   */
  /**
   * Whether a document called called console.timeStamp. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_timestamp(1772);

  /**
   * generated from use.counter.doc.console_trace
   */
  /**
   * Whether a document called called console.trace. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_trace(1773);

  /**
   * generated from use.counter.doc.console_warn
   */
  /**
   * Whether a document called called console.warn. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_warn(1774);

  /**
   * generated from use.counter.doc.customelementregistry_define
   */
  /**
   * Whether a document called called CustomElementRegistry.define. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric customelementregistry_define(1775);

  /**
   * generated from use.counter.doc.customized_builtin
   */
  /**
   * Whether a document registers a customized built-in element. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric customized_builtin(1776);

  /**
   * generated from use.counter.doc.datatransfer_addelement
   */
  /**
   * Whether a document called called DataTransfer.addElement. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric datatransfer_addelement(1777);

  /**
   * generated from use.counter.doc.datatransfer_mozcleardataat
   */
  /**
   * Whether a document called called DataTransfer.mozClearDataAt. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric datatransfer_mozcleardataat(1778);

  /**
   * generated from use.counter.doc.datatransfer_mozcursor_getter
   */
  /**
   * Whether a document got DataTransfer.mozCursor. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric datatransfer_mozcursor_getter(1779);

  /**
   * generated from use.counter.doc.datatransfer_mozcursor_setter
   */
  /**
   * Whether a document set DataTransfer.mozCursor. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric datatransfer_mozcursor_setter(1780);

  /**
   * generated from use.counter.doc.datatransfer_mozgetdataat
   */
  /**
   * Whether a document called called DataTransfer.mozGetDataAt. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric datatransfer_mozgetdataat(1781);

  /**
   * generated from use.counter.doc.datatransfer_mozitemcount_getter
   */
  /**
   * Whether a document got DataTransfer.mozItemCount. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric datatransfer_mozitemcount_getter(1782);

  /**
   * generated from use.counter.doc.datatransfer_mozitemcount_setter
   */
  /**
   * Whether a document set DataTransfer.mozItemCount. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric datatransfer_mozitemcount_setter(1783);

  /**
   * generated from use.counter.doc.datatransfer_mozsetdataat
   */
  /**
   * Whether a document called called DataTransfer.mozSetDataAt. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric datatransfer_mozsetdataat(1784);

  /**
   * generated from use.counter.doc.datatransfer_mozsourcenode_getter
   */
  /**
   * Whether a document got DataTransfer.mozSourceNode. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric datatransfer_mozsourcenode_getter(1785);

  /**
   * generated from use.counter.doc.datatransfer_mozsourcenode_setter
   */
  /**
   * Whether a document set DataTransfer.mozSourceNode. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric datatransfer_mozsourcenode_setter(1786);

  /**
   * generated from use.counter.doc.datatransfer_moztypesat
   */
  /**
   * Whether a document called called DataTransfer.mozTypesAt. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric datatransfer_moztypesat(1787);

  /**
   * generated from use.counter.doc.datatransfer_mozusercancelled_getter
   */
  /**
   * Whether a document got DataTransfer.mozUserCancelled. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric datatransfer_mozusercancelled_getter(1788);

  /**
   * generated from use.counter.doc.datatransfer_mozusercancelled_setter
   */
  /**
   * Whether a document set DataTransfer.mozUserCancelled. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric datatransfer_mozusercancelled_setter(1789);

  /**
   * generated from use.counter.doc.datatransferitem_webkitgetasentry
   */
  /**
   * Whether a document called called DataTransferItem.webkitGetAsEntry. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric datatransferitem_webkitgetasentry(1790);

  /**
   * generated from use.counter.doc.document_caretrangefrompoint
   */
  /**
   * Whether a document called called Document.caretRangeFromPoint. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_caretrangefrompoint(1791);

  /**
   * generated from use.counter.doc.document_exec_command_content_read_only
   */
  /**
   * Whether a document calls execCommand with contentReadOnly. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_exec_command_content_read_only(1792);

  /**
   * generated from use.counter.doc.document_exitpictureinpicture
   */
  /**
   * Whether a document called called Document.exitPictureInPicture. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_exitpictureinpicture(1793);

  /**
   * generated from use.counter.doc.document_featurepolicy
   */
  /**
   * Whether a document called called Document.featurePolicy. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_featurepolicy(1794);

  /**
   * generated from use.counter.doc.document_mozsetimageelement
   */
  /**
   * Whether a document called called Document.mozSetImageElement. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_mozsetimageelement(1795);

  /**
   * generated from use.counter.doc.document_onbeforecopy
   */
  /**
   * Whether a document called called Document.onbeforecopy. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_onbeforecopy(1796);

  /**
   * generated from use.counter.doc.document_onbeforecut
   */
  /**
   * Whether a document called called Document.onbeforecut. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_onbeforecut(1797);

  /**
   * generated from use.counter.doc.document_onbeforepaste
   */
  /**
   * Whether a document called called Document.onbeforepaste. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_onbeforepaste(1798);

  /**
   * generated from use.counter.doc.document_oncancel
   */
  /**
   * Whether a document called called Document.oncancel. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_oncancel(1799);

  /**
   * generated from use.counter.doc.document_onfreeze
   */
  /**
   * Whether a document called called Document.onfreeze. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_onfreeze(1800);

  /**
   * generated from use.counter.doc.document_onmousewheel
   */
  /**
   * Whether a document called called Document.onmousewheel. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_onmousewheel(1801);

  /**
   * generated from use.counter.doc.document_onresume
   */
  /**
   * Whether a document called called Document.onresume. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_onresume(1802);

  /**
   * generated from use.counter.doc.document_onsearch
   */
  /**
   * Whether a document called called Document.onsearch. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_onsearch(1803);

  /**
   * generated from use.counter.doc.document_onwebkitfullscreenchange
   */
  /**
   * Whether a document called called Document.onwebkitfullscreenchange. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_onwebkitfullscreenchange(1804);

  /**
   * generated from use.counter.doc.document_onwebkitfullscreenerror
   */
  /**
   * Whether a document called called Document.onwebkitfullscreenerror. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_onwebkitfullscreenerror(1805);

  /**
   * generated from use.counter.doc.document_open
   */
  /**
   * Whether a document calls document.open in a way that creates a new Window
     * object. Compare against `use.counter.content_documents_destroyed` to calculate
     * the rate.
   */
  constexpr impl::CounterMetric document_open(1806);

  /**
   * generated from use.counter.doc.document_pictureinpictureelement
   */
  /**
   * Whether a document called called Document.pictureInPictureElement. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_pictureinpictureelement(1807);

  /**
   * generated from use.counter.doc.document_pictureinpictureenabled
   */
  /**
   * Whether a document called called Document.pictureInPictureEnabled. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_pictureinpictureenabled(1808);

  /**
   * generated from use.counter.doc.document_query_command_state_or_value_content_read_only
   */
  /**
   * Whether a document calls queryCommandState or queryCommandValue with
     * contentReadOnly. Compare against `use.counter.content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric document_query_command_state_or_value_content_read_only(1809);

  /**
   * generated from use.counter.doc.document_query_command_state_or_value_insert_br_on_return
   */
  /**
   * Whether a document calls queryCommandState or queryCommandValue with
     * insertBrOnReturn. Compare against `use.counter.content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric document_query_command_state_or_value_insert_br_on_return(1810);

  /**
   * generated from use.counter.doc.document_query_command_supported_or_enabled_content_read_only
   */
  /**
   * Whether a document calls queryCommandSupported or queryCommandEnabled with
     * contentReadOnly. Compare against `use.counter.content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric document_query_command_supported_or_enabled_content_read_only(1811);

  /**
   * generated from use.counter.doc.document_query_command_supported_or_enabled_insert_br_on_return
   */
  /**
   * Whether a document calls queryCommandSupported or queryCommandEnabled with
     * insertBrOnReturn. Compare against `use.counter.content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric document_query_command_supported_or_enabled_insert_br_on_return(1812);

  /**
   * generated from use.counter.doc.document_registerelement
   */
  /**
   * Whether a document called called Document.registerElement. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_registerelement(1813);

  /**
   * generated from use.counter.doc.document_wasdiscarded
   */
  /**
   * Whether a document called called Document.wasDiscarded. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_wasdiscarded(1814);

  /**
   * generated from use.counter.doc.document_webkitcancelfullscreen
   */
  /**
   * Whether a document called called Document.webkitCancelFullScreen. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_webkitcancelfullscreen(1815);

  /**
   * generated from use.counter.doc.document_webkitcurrentfullscreenelement
   */
  /**
   * Whether a document called called Document.webkitCurrentFullScreenElement.
     * Compare against `use.counter.content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric document_webkitcurrentfullscreenelement(1816);

  /**
   * generated from use.counter.doc.document_webkitexitfullscreen
   */
  /**
   * Whether a document called called Document.webkitExitFullscreen. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_webkitexitfullscreen(1817);

  /**
   * generated from use.counter.doc.document_webkitfullscreenelement
   */
  /**
   * Whether a document called called Document.webkitFullscreenElement. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_webkitfullscreenelement(1818);

  /**
   * generated from use.counter.doc.document_webkitfullscreenenabled
   */
  /**
   * Whether a document called called Document.webkitFullscreenEnabled. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_webkitfullscreenenabled(1819);

  /**
   * generated from use.counter.doc.document_webkithidden
   */
  /**
   * Whether a document called called Document.webkitHidden. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_webkithidden(1820);

  /**
   * generated from use.counter.doc.document_webkitisfullscreen
   */
  /**
   * Whether a document called called Document.webkitIsFullScreen. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_webkitisfullscreen(1821);

  /**
   * generated from use.counter.doc.document_webkitvisibilitystate
   */
  /**
   * Whether a document called called Document.webkitVisibilityState. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_webkitvisibilitystate(1822);

  /**
   * generated from use.counter.doc.document_xmlencoding
   */
  /**
   * Whether a document called called Document.xmlEncoding. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_xmlencoding(1823);

  /**
   * generated from use.counter.doc.document_xmlstandalone
   */
  /**
   * Whether a document called called Document.xmlStandalone. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_xmlstandalone(1824);

  /**
   * generated from use.counter.doc.document_xmlversion
   */
  /**
   * Whether a document called called Document.xmlVersion. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_xmlversion(1825);

  /**
   * generated from use.counter.doc.domparser_parsefromstring
   */
  /**
   * Whether a document called called DOMParser.parseFromString. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric domparser_parsefromstring(1826);

  /**
   * generated from use.counter.doc.element_attachshadow
   */
  /**
   * Whether a document called called Element.attachShadow. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric element_attachshadow(1827);

  /**
   * generated from use.counter.doc.element_computedstylemap
   */
  /**
   * Whether a document called called Element.computedStyleMap. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric element_computedstylemap(1828);

  /**
   * generated from use.counter.doc.element_onmousewheel
   */
  /**
   * Whether a document called called Element.onmousewheel. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric element_onmousewheel(1829);

  /**
   * generated from use.counter.doc.element_releasecapture
   */
  /**
   * Whether a document called called Element.releaseCapture. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric element_releasecapture(1830);

  /**
   * generated from use.counter.doc.element_releasepointercapture
   */
  /**
   * Whether a document called called Element.releasePointerCapture. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric element_releasepointercapture(1831);

  /**
   * generated from use.counter.doc.element_scrollintoviewifneeded
   */
  /**
   * Whether a document called called Element.scrollIntoViewIfNeeded. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric element_scrollintoviewifneeded(1832);

  /**
   * generated from use.counter.doc.element_setcapture
   */
  /**
   * Whether a document called called Element.setCapture. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric element_setcapture(1833);

  /**
   * generated from use.counter.doc.element_sethtml
   */
  /**
   * Whether a document called called Element.setHTML. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric element_sethtml(1834);

  /**
   * generated from use.counter.doc.element_setpointercapture
   */
  /**
   * Whether a document called called Element.setPointerCapture. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric element_setpointercapture(1835);

  /**
   * generated from use.counter.doc.enumerate_devices_insec
   */
  /**
   * Whether a document calls MediaDevices.enumerateDevices from an insecure
     * context. Compare against `use.counter.content_documents_destroyed` to calculate
     * the rate.
   */
  constexpr impl::CounterMetric enumerate_devices_insec(1836);

  /**
   * generated from use.counter.doc.enumerate_devices_unfocused
   */
  /**
   * Whether a document calls MediaDevices.enumerateDevices from a unfocused
     * document. Compare against `use.counter.content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric enumerate_devices_unfocused(1837);

  /**
   * generated from use.counter.doc.fe_blend
   */
  /**
   * Whether a document uses the feBlend SVG filter.. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric fe_blend(1838);

  /**
   * generated from use.counter.doc.fe_color_matrix
   */
  /**
   * Whether a document uses the feColorMatrix SVG filter.. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric fe_color_matrix(1839);

  /**
   * generated from use.counter.doc.fe_component_transfer
   */
  /**
   * Whether a document uses the feComponentTransfer SVG filter.. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric fe_component_transfer(1840);

  /**
   * generated from use.counter.doc.fe_composite
   */
  /**
   * Whether a document uses the feComposite SVG filter.. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric fe_composite(1841);

  /**
   * generated from use.counter.doc.fe_convolve_matrix
   */
  /**
   * Whether a document uses the feConvolveMatrix SVG filter.. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric fe_convolve_matrix(1842);

  /**
   * generated from use.counter.doc.fe_diffuse_lighting
   */
  /**
   * Whether a document uses the feDiffuseLighting SVG filter.. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric fe_diffuse_lighting(1843);

  /**
   * generated from use.counter.doc.fe_displacement_map
   */
  /**
   * Whether a document uses the feDisplacementMap SVG filter.. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric fe_displacement_map(1844);

  /**
   * generated from use.counter.doc.fe_flood
   */
  /**
   * Whether a document uses the feFlood SVG filter.. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric fe_flood(1845);

  /**
   * generated from use.counter.doc.fe_gaussian_blur
   */
  /**
   * Whether a document uses the feGaussianBlur SVG filter.. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric fe_gaussian_blur(1846);

  /**
   * generated from use.counter.doc.fe_image
   */
  /**
   * Whether a document uses the feImage SVG filter.. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric fe_image(1847);

  /**
   * generated from use.counter.doc.fe_merge
   */
  /**
   * Whether a document uses the feMerge SVG filter.. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric fe_merge(1848);

  /**
   * generated from use.counter.doc.fe_morphology
   */
  /**
   * Whether a document uses the feMorphology SVG filter.. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric fe_morphology(1849);

  /**
   * generated from use.counter.doc.fe_offset
   */
  /**
   * Whether a document uses the feOffset SVG filter.. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric fe_offset(1850);

  /**
   * generated from use.counter.doc.fe_specular_lighting
   */
  /**
   * Whether a document uses the feSpecularLighting SVG filter.. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric fe_specular_lighting(1851);

  /**
   * generated from use.counter.doc.fe_tile
   */
  /**
   * Whether a document uses the feTile SVG filter.. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric fe_tile(1852);

  /**
   * generated from use.counter.doc.fe_turbulence
   */
  /**
   * Whether a document uses the feTurbulence SVG filter.. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric fe_turbulence(1853);

  /**
   * generated from use.counter.doc.filtered_cross_origin_iframe
   */
  /**
   * Whether a document cross-origin <iframe> within a CSS/SVG filter. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric filtered_cross_origin_iframe(1854);

  /**
   * generated from use.counter.doc.get_user_media_insec
   */
  /**
   * Whether a document calls MediaDevices.getUserMedia from an insecure context.
     * Compare against `use.counter.content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric get_user_media_insec(1855);

  /**
   * generated from use.counter.doc.get_user_media_unfocused
   */
  /**
   * Whether a document calls MediaDevices.getUserMedia from an unfocused document.
     * Compare against `use.counter.content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric get_user_media_unfocused(1856);

  /**
   * generated from use.counter.doc.htmlbuttonelement_popovertargetaction
   */
  /**
   * Whether a document called called HTMLButtonElement.popoverTargetAction. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric htmlbuttonelement_popovertargetaction(1857);

  /**
   * generated from use.counter.doc.htmlbuttonelement_popovertargetelement
   */
  /**
   * Whether a document called called HTMLButtonElement.popoverTargetElement.
     * Compare against `use.counter.content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric htmlbuttonelement_popovertargetelement(1858);

  /**
   * generated from use.counter.doc.htmldialogelement_show
   */
  /**
   * Whether a document called called HTMLDialogElement.show. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric htmldialogelement_show(1859);

  /**
   * generated from use.counter.doc.htmldocument_named_getter_hit
   */
  /**
   * Whether a document calls to the named getter on HTMLDocument that find
     * something via the name lookup. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric htmldocument_named_getter_hit(1860);

  /**
   * generated from use.counter.doc.htmlelement_attributestylemap
   */
  /**
   * Whether a document called called HTMLElement.attributeStyleMap. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric htmlelement_attributestylemap(1861);

  /**
   * generated from use.counter.doc.htmlelement_hidepopover
   */
  /**
   * Whether a document called called HTMLElement.hidePopover. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric htmlelement_hidepopover(1862);

  /**
   * generated from use.counter.doc.htmlelement_popover
   */
  /**
   * Whether a document called called HTMLElement.popover. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric htmlelement_popover(1863);

  /**
   * generated from use.counter.doc.htmlelement_showpopover
   */
  /**
   * Whether a document called called HTMLElement.showPopover. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric htmlelement_showpopover(1864);

  /**
   * generated from use.counter.doc.htmlelement_togglepopover
   */
  /**
   * Whether a document called called HTMLElement.togglePopover. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric htmlelement_togglepopover(1865);

  /**
   * generated from use.counter.doc.htmliframeelement_loading
   */
  /**
   * Whether a document called called HTMLIFrameElement.loading. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric htmliframeelement_loading(1866);

  /**
   * generated from use.counter.doc.htmlinputelement_capture
   */
  /**
   * Whether a document called called HTMLInputElement.capture. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric htmlinputelement_capture(1867);

  /**
   * generated from use.counter.doc.htmlinputelement_incremental
   */
  /**
   * Whether a document called called HTMLInputElement.incremental. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric htmlinputelement_incremental(1868);

  /**
   * generated from use.counter.doc.htmlinputelement_onsearch
   */
  /**
   * Whether a document called called HTMLInputElement.onsearch. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric htmlinputelement_onsearch(1869);

  /**
   * generated from use.counter.doc.htmlinputelement_popovertargetaction
   */
  /**
   * Whether a document called called HTMLInputElement.popoverTargetAction. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric htmlinputelement_popovertargetaction(1870);

  /**
   * generated from use.counter.doc.htmlinputelement_popovertargetelement
   */
  /**
   * Whether a document called called HTMLInputElement.popoverTargetElement. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric htmlinputelement_popovertargetelement(1871);

  /**
   * generated from use.counter.doc.htmlinputelement_webkitdirectory
   */
  /**
   * Whether a document called called HTMLInputElement.webkitdirectory. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric htmlinputelement_webkitdirectory(1872);

  /**
   * generated from use.counter.doc.htmlinputelement_webkitentries
   */
  /**
   * Whether a document called called HTMLInputElement.webkitEntries. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric htmlinputelement_webkitentries(1873);

  /**
   * generated from use.counter.doc.htmlmediaelement_disableremoteplayback
   */
  /**
   * Whether a document called called HTMLMediaElement.disableRemotePlayback.
     * Compare against `use.counter.content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric htmlmediaelement_disableremoteplayback(1874);

  /**
   * generated from use.counter.doc.htmlmediaelement_remote
   */
  /**
   * Whether a document called called HTMLMediaElement.remote. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric htmlmediaelement_remote(1875);

  /**
   * generated from use.counter.doc.htmlvideoelement_cancelvideoframecallback
   */
  /**
   * Whether a document called called HTMLVideoElement.cancelVideoFrameCallback.
     * Compare against `use.counter.content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric htmlvideoelement_cancelvideoframecallback(1876);

  /**
   * generated from use.counter.doc.htmlvideoelement_disablepictureinpicture
   */
  /**
   * Whether a document called called HTMLVideoElement.disablePictureInPicture.
     * Compare against `use.counter.content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric htmlvideoelement_disablepictureinpicture(1877);

  /**
   * generated from use.counter.doc.htmlvideoelement_onenterpictureinpicture
   */
  /**
   * Whether a document called called HTMLVideoElement.onenterpictureinpicture.
     * Compare against `use.counter.content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric htmlvideoelement_onenterpictureinpicture(1878);

  /**
   * generated from use.counter.doc.htmlvideoelement_onleavepictureinpicture
   */
  /**
   * Whether a document called called HTMLVideoElement.onleavepictureinpicture.
     * Compare against `use.counter.content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric htmlvideoelement_onleavepictureinpicture(1879);

  /**
   * generated from use.counter.doc.htmlvideoelement_playsinline
   */
  /**
   * Whether a document called called HTMLVideoElement.playsInline. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric htmlvideoelement_playsinline(1880);

  /**
   * generated from use.counter.doc.htmlvideoelement_requestpictureinpicture
   */
  /**
   * Whether a document called called HTMLVideoElement.requestPictureInPicture.
     * Compare against `use.counter.content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric htmlvideoelement_requestpictureinpicture(1881);

  /**
   * generated from use.counter.doc.htmlvideoelement_requestvideoframecallback
   */
  /**
   * Whether a document called called HTMLVideoElement.requestVideoFrameCallback.
     * Compare against `use.counter.content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric htmlvideoelement_requestvideoframecallback(1882);

  /**
   * generated from use.counter.doc.imagedata_colorspace
   */
  /**
   * Whether a document called called ImageData.colorSpace. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric imagedata_colorspace(1883);

  /**
   * generated from use.counter.doc.js_asmjs
   */
  /**
   * Whether a document uses asm.js. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric js_asmjs(1884);

  /**
   * generated from use.counter.doc.js_subclassing_array_type_2
   */
  /**
   * Whether a document Array is Type II subclassed. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric js_subclassing_array_type_2(1885);

  /**
   * generated from use.counter.doc.js_subclassing_array_type_3
   */
  /**
   * Whether a document Array is Type III subclassed. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric js_subclassing_array_type_3(1886);

  /**
   * generated from use.counter.doc.js_subclassing_arraybuffer_type_3
   */
  /**
   * Whether a document ArrayBuffer is Type III subclassed. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric js_subclassing_arraybuffer_type_3(1887);

  /**
   * generated from use.counter.doc.js_subclassing_promise_type_2
   */
  /**
   * Whether a document Promise is Type II subclassed. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric js_subclassing_promise_type_2(1888);

  /**
   * generated from use.counter.doc.js_subclassing_promise_type_3
   */
  /**
   * Whether a document Promise is Type III subclassed. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric js_subclassing_promise_type_3(1889);

  /**
   * generated from use.counter.doc.js_subclassing_regexp_type_3
   */
  /**
   * Whether a document RegExp is Type III subclassed. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric js_subclassing_regexp_type_3(1890);

  /**
   * generated from use.counter.doc.js_subclassing_regexp_type_4
   */
  /**
   * Whether a document RegExp is Type IV subclassed. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric js_subclassing_regexp_type_4(1891);

  /**
   * generated from use.counter.doc.js_subclassing_sharedarraybuffer_type_3
   */
  /**
   * Whether a document SharedArrayBuffer is Type III subclassed. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric js_subclassing_sharedarraybuffer_type_3(1892);

  /**
   * generated from use.counter.doc.js_subclassing_typedarray_type_2
   */
  /**
   * Whether a document TypedArray is Type II subclassed. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric js_subclassing_typedarray_type_2(1893);

  /**
   * generated from use.counter.doc.js_subclassing_typedarray_type_3
   */
  /**
   * Whether a document TypedArray is Type III subclassed. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric js_subclassing_typedarray_type_3(1894);

  /**
   * generated from use.counter.doc.js_wasm
   */
  /**
   * Whether a document uses WebAssembly. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric js_wasm(1895);

  /**
   * generated from use.counter.doc.js_wasm_legacy_exceptions
   */
  /**
   * Whether a document uses WebAssembly legacy exception-handling. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric js_wasm_legacy_exceptions(1896);

  /**
   * generated from use.counter.doc.location_ancestororigins
   */
  /**
   * Whether a document called called Location.ancestorOrigins. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric location_ancestororigins(1897);

  /**
   * generated from use.counter.doc.mediadevices_enumeratedevices
   */
  /**
   * Whether a document called called MediaDevices.enumerateDevices. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric mediadevices_enumeratedevices(1898);

  /**
   * generated from use.counter.doc.mediadevices_getdisplaymedia
   */
  /**
   * Whether a document called called MediaDevices.getDisplayMedia. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric mediadevices_getdisplaymedia(1899);

  /**
   * generated from use.counter.doc.mediadevices_getusermedia
   */
  /**
   * Whether a document called called MediaDevices.getUserMedia. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric mediadevices_getusermedia(1900);

  /**
   * generated from use.counter.doc.mixed_content_not_upgraded_audio_failure
   */
  /**
   * Whether a document includes a mixed content audio element that does not load..
     * Compare against `use.counter.content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric mixed_content_not_upgraded_audio_failure(1901);

  /**
   * generated from use.counter.doc.mixed_content_not_upgraded_audio_success
   */
  /**
   * Whether a document includes a mixed content audio element that loads.. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric mixed_content_not_upgraded_audio_success(1902);

  /**
   * generated from use.counter.doc.mixed_content_not_upgraded_image_failure
   */
  /**
   * Whether a document includes a mixed content img element that does not load..
     * Compare against `use.counter.content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric mixed_content_not_upgraded_image_failure(1903);

  /**
   * generated from use.counter.doc.mixed_content_not_upgraded_image_success
   */
  /**
   * Whether a document includes a mixed content img element that loads.. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric mixed_content_not_upgraded_image_success(1904);

  /**
   * generated from use.counter.doc.mixed_content_not_upgraded_video_failure
   */
  /**
   * Whether a document includes a mixed content video element that does not laod..
     * Compare against `use.counter.content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric mixed_content_not_upgraded_video_failure(1905);

  /**
   * generated from use.counter.doc.mixed_content_not_upgraded_video_success
   */
  /**
   * Whether a document includes a mixed content video element that loads.. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric mixed_content_not_upgraded_video_success(1906);

  /**
   * generated from use.counter.doc.mixed_content_upgraded_audio_failure
   */
  /**
   * Whether a document includes a mixed content audio element that does not load..
     * Compare against `use.counter.content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric mixed_content_upgraded_audio_failure(1907);

  /**
   * generated from use.counter.doc.mixed_content_upgraded_audio_success
   */
  /**
   * Whether a document includes a mixed content audio element that loads.. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric mixed_content_upgraded_audio_success(1908);

  /**
   * generated from use.counter.doc.mixed_content_upgraded_image_failure
   */
  /**
   * Whether a document includes a mixed content img element that does not load..
     * Compare against `use.counter.content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric mixed_content_upgraded_image_failure(1909);

  /**
   * generated from use.counter.doc.mixed_content_upgraded_image_success
   */
  /**
   * Whether a document includes a mixed content img element that loads.. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric mixed_content_upgraded_image_success(1910);

  /**
   * generated from use.counter.doc.mixed_content_upgraded_video_failure
   */
  /**
   * Whether a document includes a mixed content video element that does not laod..
     * Compare against `use.counter.content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric mixed_content_upgraded_video_failure(1911);

  /**
   * generated from use.counter.doc.mixed_content_upgraded_video_success
   */
  /**
   * Whether a document includes a mixed content video element that loads.. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric mixed_content_upgraded_video_success(1912);

  /**
   * generated from use.counter.doc.moz_get_user_media_insec
   */
  /**
   * Whether a document calls Navigator.mozGetUserMedia from an insecure context.
     * Compare against `use.counter.content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric moz_get_user_media_insec(1913);

  /**
   * generated from use.counter.doc.navigator_canshare
   */
  /**
   * Whether a document called called Navigator.canShare. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric navigator_canshare(1914);

  /**
   * generated from use.counter.doc.navigator_clearappbadge
   */
  /**
   * Whether a document called called Navigator.clearAppBadge. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric navigator_clearappbadge(1915);

  /**
   * generated from use.counter.doc.navigator_mozgetusermedia
   */
  /**
   * Whether a document called called Navigator.mozGetUserMedia. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric navigator_mozgetusermedia(1916);

  /**
   * generated from use.counter.doc.navigator_setappbadge
   */
  /**
   * Whether a document called called Navigator.setAppBadge. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric navigator_setappbadge(1917);

  /**
   * generated from use.counter.doc.navigator_share
   */
  /**
   * Whether a document called called Navigator.share. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric navigator_share(1918);

  /**
   * generated from use.counter.doc.navigator_useractivation
   */
  /**
   * Whether a document called called Navigator.userActivation. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric navigator_useractivation(1919);

  /**
   * generated from use.counter.doc.navigator_wakelock
   */
  /**
   * Whether a document called called Navigator.wakeLock. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric navigator_wakelock(1920);

  /**
   * generated from use.counter.doc.ondommousescroll
   */
  /**
   * Whether a document sets DOMMouseScroll event listener. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric ondommousescroll(1921);

  /**
   * generated from use.counter.doc.onmozmousepixelscroll
   */
  /**
   * Whether a document sets MozMousePixelScroll event listener. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric onmozmousepixelscroll(1922);

  /**
   * generated from use.counter.doc.onoverflow
   */
  /**
   * Whether a document sets an element onoverflow event listener. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric onoverflow(1923);

  /**
   * generated from use.counter.doc.onunderflow
   */
  /**
   * Whether a document sets an element onunderflow event listener. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric onunderflow(1924);

  /**
   * generated from use.counter.doc.percentage_stroke_width_in_svg
   */
  /**
   * Whether a document whether percentage stroke-width is used in SVG elements
     * (excluding <text>). Compare against `use.counter.content_documents_destroyed`
     * to calculate the rate.
   */
  constexpr impl::CounterMetric percentage_stroke_width_in_svg(1925);

  /**
   * generated from use.counter.doc.percentage_stroke_width_in_svgtext
   */
  /**
   * Whether a document whether percentage stroke-width is used in SVG <text>.
     * Compare against `use.counter.content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric percentage_stroke_width_in_svgtext(1926);

  /**
   * generated from use.counter.doc.private_browsing_caches_delete
   */
  /**
   * Whether a document calls caches.delete in Private Browsing Mode. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric private_browsing_caches_delete(1927);

  /**
   * generated from use.counter.doc.private_browsing_caches_has
   */
  /**
   * Whether a document calls caches.has in Private Browsing Mode. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric private_browsing_caches_has(1928);

  /**
   * generated from use.counter.doc.private_browsing_caches_keys
   */
  /**
   * Whether a document calls caches.keys in Private Browsing Mode. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric private_browsing_caches_keys(1929);

  /**
   * generated from use.counter.doc.private_browsing_caches_match
   */
  /**
   * Whether a document calls caches.match in Private Browsing Mode. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric private_browsing_caches_match(1930);

  /**
   * generated from use.counter.doc.private_browsing_caches_open
   */
  /**
   * Whether a document calls caches.open in Private Browsing Mode. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric private_browsing_caches_open(1931);

  /**
   * generated from use.counter.doc.private_browsing_idbfactory_delete_database
   */
  /**
   * Whether a document calls indexedDB.deleteDatabase in Private Browsing Mode.
     * Compare against `use.counter.content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric private_browsing_idbfactory_delete_database(1932);

  /**
   * generated from use.counter.doc.private_browsing_idbfactory_open
   */
  /**
   * Whether a document calls indexedDB.open in Private Browsing Mode. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric private_browsing_idbfactory_open(1933);

  /**
   * generated from use.counter.doc.private_browsing_navigator_service_worker
   */
  /**
   * Whether a document accesses navigator.serviceWorker in Private Browsing Mode.
     * Compare against `use.counter.content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric private_browsing_navigator_service_worker(1934);

  /**
   * generated from use.counter.doc.pushmanager_subscribe
   */
  /**
   * Whether a document called called PushManager.subscribe. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric pushmanager_subscribe(1935);

  /**
   * generated from use.counter.doc.pushsubscription_unsubscribe
   */
  /**
   * Whether a document called called PushSubscription.unsubscribe. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric pushsubscription_unsubscribe(1936);

  /**
   * generated from use.counter.doc.range_createcontextualfragment
   */
  /**
   * Whether a document called called Range.createContextualFragment. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric range_createcontextualfragment(1937);

  /**
   * generated from use.counter.doc.sanitizer_constructor
   */
  /**
   * Whether a document called called Sanitizer.constructor. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric sanitizer_constructor(1938);

  /**
   * generated from use.counter.doc.sanitizer_sanitize
   */
  /**
   * Whether a document called called Sanitizer.sanitize. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric sanitizer_sanitize(1939);

  /**
   * generated from use.counter.doc.scheduler_posttask
   */
  /**
   * Whether a document called called Scheduler.postTask. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric scheduler_posttask(1940);

  /**
   * generated from use.counter.doc.shadowroot_pictureinpictureelement
   */
  /**
   * Whether a document called called ShadowRoot.pictureInPictureElement. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric shadowroot_pictureinpictureelement(1941);

  /**
   * generated from use.counter.doc.svgsvgelement_currentscale_getter
   */
  /**
   * Whether a document got SVGSVGElement.currentScale. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric svgsvgelement_currentscale_getter(1942);

  /**
   * generated from use.counter.doc.svgsvgelement_currentscale_setter
   */
  /**
   * Whether a document set SVGSVGElement.currentScale. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric svgsvgelement_currentscale_setter(1943);

  /**
   * generated from use.counter.doc.svgsvgelement_getelementbyid
   */
  /**
   * Whether a document called called SVGSVGElement.getElementById. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric svgsvgelement_getelementbyid(1944);

  /**
   * generated from use.counter.doc.window_absoluteorientationsensor
   */
  /**
   * Whether a document called called Window.AbsoluteOrientationSensor. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_absoluteorientationsensor(1945);

  /**
   * generated from use.counter.doc.window_accelerometer
   */
  /**
   * Whether a document called called Window.Accelerometer. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_accelerometer(1946);

  /**
   * generated from use.counter.doc.window_backgroundfetchmanager
   */
  /**
   * Whether a document called called Window.BackgroundFetchManager. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_backgroundfetchmanager(1947);

  /**
   * generated from use.counter.doc.window_backgroundfetchrecord
   */
  /**
   * Whether a document called called Window.BackgroundFetchRecord. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_backgroundfetchrecord(1948);

  /**
   * generated from use.counter.doc.window_backgroundfetchregistration
   */
  /**
   * Whether a document called called Window.BackgroundFetchRegistration. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_backgroundfetchregistration(1949);

  /**
   * generated from use.counter.doc.window_beforeinstallpromptevent
   */
  /**
   * Whether a document called called Window.BeforeInstallPromptEvent. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_beforeinstallpromptevent(1950);

  /**
   * generated from use.counter.doc.window_bluetooth
   */
  /**
   * Whether a document called called Window.Bluetooth. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_bluetooth(1951);

  /**
   * generated from use.counter.doc.window_bluetoothcharacteristicproperties
   */
  /**
   * Whether a document called called Window.BluetoothCharacteristicProperties.
     * Compare against `use.counter.content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric window_bluetoothcharacteristicproperties(1952);

  /**
   * generated from use.counter.doc.window_bluetoothdevice
   */
  /**
   * Whether a document called called Window.BluetoothDevice. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_bluetoothdevice(1953);

  /**
   * generated from use.counter.doc.window_bluetoothremotegattcharacteristic
   */
  /**
   * Whether a document called called Window.BluetoothRemoteGATTCharacteristic.
     * Compare against `use.counter.content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric window_bluetoothremotegattcharacteristic(1954);

  /**
   * generated from use.counter.doc.window_bluetoothremotegattdescriptor
   */
  /**
   * Whether a document called called Window.BluetoothRemoteGATTDescriptor. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_bluetoothremotegattdescriptor(1955);

  /**
   * generated from use.counter.doc.window_bluetoothremotegattserver
   */
  /**
   * Whether a document called called Window.BluetoothRemoteGATTServer. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_bluetoothremotegattserver(1956);

  /**
   * generated from use.counter.doc.window_bluetoothremotegattservice
   */
  /**
   * Whether a document called called Window.BluetoothRemoteGATTService. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_bluetoothremotegattservice(1957);

  /**
   * generated from use.counter.doc.window_bluetoothuuid
   */
  /**
   * Whether a document called called Window.BluetoothUUID. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_bluetoothuuid(1958);

  /**
   * generated from use.counter.doc.window_canvascapturemediastreamtrack
   */
  /**
   * Whether a document called called Window.CanvasCaptureMediaStreamTrack. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_canvascapturemediastreamtrack(1959);

  /**
   * generated from use.counter.doc.window_chrome
   */
  /**
   * Whether a document called called Window.chrome. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_chrome(1960);

  /**
   * generated from use.counter.doc.window_clipboarditem
   */
  /**
   * Whether a document called called Window.ClipboardItem. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_clipboarditem(1961);

  /**
   * generated from use.counter.doc.window_cssimagevalue
   */
  /**
   * Whether a document called called Window.CSSImageValue. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_cssimagevalue(1962);

  /**
   * generated from use.counter.doc.window_csskeywordvalue
   */
  /**
   * Whether a document called called Window.CSSKeywordValue. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_csskeywordvalue(1963);

  /**
   * generated from use.counter.doc.window_cssmathclamp
   */
  /**
   * Whether a document called called Window.CSSMathClamp. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_cssmathclamp(1964);

  /**
   * generated from use.counter.doc.window_cssmathinvert
   */
  /**
   * Whether a document called called Window.CSSMathInvert. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_cssmathinvert(1965);

  /**
   * generated from use.counter.doc.window_cssmathmax
   */
  /**
   * Whether a document called called Window.CSSMathMax. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_cssmathmax(1966);

  /**
   * generated from use.counter.doc.window_cssmathmin
   */
  /**
   * Whether a document called called Window.CSSMathMin. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_cssmathmin(1967);

  /**
   * generated from use.counter.doc.window_cssmathnegate
   */
  /**
   * Whether a document called called Window.CSSMathNegate. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_cssmathnegate(1968);

  /**
   * generated from use.counter.doc.window_cssmathproduct
   */
  /**
   * Whether a document called called Window.CSSMathProduct. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_cssmathproduct(1969);

  /**
   * generated from use.counter.doc.window_cssmathsum
   */
  /**
   * Whether a document called called Window.CSSMathSum. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_cssmathsum(1970);

  /**
   * generated from use.counter.doc.window_cssmathvalue
   */
  /**
   * Whether a document called called Window.CSSMathValue. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_cssmathvalue(1971);

  /**
   * generated from use.counter.doc.window_cssmatrixcomponent
   */
  /**
   * Whether a document called called Window.CSSMatrixComponent. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_cssmatrixcomponent(1972);

  /**
   * generated from use.counter.doc.window_cssnumericarray
   */
  /**
   * Whether a document called called Window.CSSNumericArray. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_cssnumericarray(1973);

  /**
   * generated from use.counter.doc.window_cssnumericvalue
   */
  /**
   * Whether a document called called Window.CSSNumericValue. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_cssnumericvalue(1974);

  /**
   * generated from use.counter.doc.window_cssperspective
   */
  /**
   * Whether a document called called Window.CSSPerspective. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_cssperspective(1975);

  /**
   * generated from use.counter.doc.window_csspositionvalue
   */
  /**
   * Whether a document called called Window.CSSPositionValue. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_csspositionvalue(1976);

  /**
   * generated from use.counter.doc.window_csspropertyrule
   */
  /**
   * Whether a document called called Window.CSSPropertyRule. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_csspropertyrule(1977);

  /**
   * generated from use.counter.doc.window_cssrotate
   */
  /**
   * Whether a document called called Window.CSSRotate. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_cssrotate(1978);

  /**
   * generated from use.counter.doc.window_cssscale
   */
  /**
   * Whether a document called called Window.CSSScale. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_cssscale(1979);

  /**
   * generated from use.counter.doc.window_cssskew
   */
  /**
   * Whether a document called called Window.CSSSkew. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_cssskew(1980);

  /**
   * generated from use.counter.doc.window_cssskewx
   */
  /**
   * Whether a document called called Window.CSSSkewX. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_cssskewx(1981);

  /**
   * generated from use.counter.doc.window_cssskewy
   */
  /**
   * Whether a document called called Window.CSSSkewY. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_cssskewy(1982);

  /**
   * generated from use.counter.doc.window_cssstylevalue
   */
  /**
   * Whether a document called called Window.CSSStyleValue. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_cssstylevalue(1983);

  /**
   * generated from use.counter.doc.window_csstransformcomponent
   */
  /**
   * Whether a document called called Window.CSSTransformComponent. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_csstransformcomponent(1984);

  /**
   * generated from use.counter.doc.window_csstransformvalue
   */
  /**
   * Whether a document called called Window.CSSTransformValue. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_csstransformvalue(1985);

  /**
   * generated from use.counter.doc.window_csstranslate
   */
  /**
   * Whether a document called called Window.CSSTranslate. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_csstranslate(1986);

  /**
   * generated from use.counter.doc.window_cssunitvalue
   */
  /**
   * Whether a document called called Window.CSSUnitValue. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_cssunitvalue(1987);

  /**
   * generated from use.counter.doc.window_cssunparsedvalue
   */
  /**
   * Whether a document called called Window.CSSUnparsedValue. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_cssunparsedvalue(1988);

  /**
   * generated from use.counter.doc.window_cssvariablereferencevalue
   */
  /**
   * Whether a document called called Window.CSSVariableReferenceValue. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_cssvariablereferencevalue(1989);

  /**
   * generated from use.counter.doc.window_defaultstatus
   */
  /**
   * Whether a document called called Window.defaultStatus. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_defaultstatus(1990);

  /**
   * generated from use.counter.doc.window_devicemotioneventacceleration
   */
  /**
   * Whether a document called called Window.DeviceMotionEventAcceleration. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_devicemotioneventacceleration(1991);

  /**
   * generated from use.counter.doc.window_devicemotioneventrotationrate
   */
  /**
   * Whether a document called called Window.DeviceMotionEventRotationRate. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_devicemotioneventrotationrate(1992);

  /**
   * generated from use.counter.doc.window_domerror
   */
  /**
   * Whether a document called called Window.DOMError. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_domerror(1993);

  /**
   * generated from use.counter.doc.window_encodedvideochunk
   */
  /**
   * Whether a document called called Window.EncodedVideoChunk. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_encodedvideochunk(1994);

  /**
   * generated from use.counter.doc.window_enterpictureinpictureevent
   */
  /**
   * Whether a document called called Window.EnterPictureInPictureEvent. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_enterpictureinpictureevent(1995);

  /**
   * generated from use.counter.doc.window_external
   */
  /**
   * Whether a document called called Window.External. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_external(1996);

  /**
   * generated from use.counter.doc.window_federatedcredential
   */
  /**
   * Whether a document called called Window.FederatedCredential. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_federatedcredential(1997);

  /**
   * generated from use.counter.doc.window_gyroscope
   */
  /**
   * Whether a document called called Window.Gyroscope. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_gyroscope(1998);

  /**
   * generated from use.counter.doc.window_htmlcontentelement
   */
  /**
   * Whether a document called called Window.HTMLContentElement. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_htmlcontentelement(1999);

  /**
   * generated from use.counter.doc.window_htmlshadowelement
   */
  /**
   * Whether a document called called Window.HTMLShadowElement. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_htmlshadowelement(2000);

  /**
   * generated from use.counter.doc.window_imagecapture
   */
  /**
   * Whether a document called called Window.ImageCapture. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_imagecapture(2001);

  /**
   * generated from use.counter.doc.window_inputdevicecapabilities
   */
  /**
   * Whether a document called called Window.InputDeviceCapabilities. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_inputdevicecapabilities(2002);

  /**
   * generated from use.counter.doc.window_inputdeviceinfo
   */
  /**
   * Whether a document called called Window.InputDeviceInfo. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_inputdeviceinfo(2003);

  /**
   * generated from use.counter.doc.window_keyboard
   */
  /**
   * Whether a document called called Window.Keyboard. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_keyboard(2004);

  /**
   * generated from use.counter.doc.window_keyboardlayoutmap
   */
  /**
   * Whether a document called called Window.KeyboardLayoutMap. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_keyboardlayoutmap(2005);

  /**
   * generated from use.counter.doc.window_linearaccelerationsensor
   */
  /**
   * Whether a document called called Window.LinearAccelerationSensor. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_linearaccelerationsensor(2006);

  /**
   * generated from use.counter.doc.window_mediasettingsrange
   */
  /**
   * Whether a document called called Window.MediaSettingsRange. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_mediasettingsrange(2007);

  /**
   * generated from use.counter.doc.window_midiaccess
   */
  /**
   * Whether a document called called Window.MIDIAccess. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_midiaccess(2008);

  /**
   * generated from use.counter.doc.window_midiconnectionevent
   */
  /**
   * Whether a document called called Window.MIDIConnectionEvent. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_midiconnectionevent(2009);

  /**
   * generated from use.counter.doc.window_midiinput
   */
  /**
   * Whether a document called called Window.MIDIInput. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_midiinput(2010);

  /**
   * generated from use.counter.doc.window_midiinputmap
   */
  /**
   * Whether a document called called Window.MIDIInputMap. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_midiinputmap(2011);

  /**
   * generated from use.counter.doc.window_midimessageevent
   */
  /**
   * Whether a document called called Window.MIDIMessageEvent. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_midimessageevent(2012);

  /**
   * generated from use.counter.doc.window_midioutput
   */
  /**
   * Whether a document called called Window.MIDIOutput. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_midioutput(2013);

  /**
   * generated from use.counter.doc.window_midioutputmap
   */
  /**
   * Whether a document called called Window.MIDIOutputMap. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_midioutputmap(2014);

  /**
   * generated from use.counter.doc.window_midiport
   */
  /**
   * Whether a document called called Window.MIDIPort. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_midiport(2015);

  /**
   * generated from use.counter.doc.window_networkinformation
   */
  /**
   * Whether a document called called Window.NetworkInformation. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_networkinformation(2016);

  /**
   * generated from use.counter.doc.window_offscreenbuffering
   */
  /**
   * Whether a document called called Window.offscreenBuffering. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_offscreenbuffering(2017);

  /**
   * generated from use.counter.doc.window_onbeforeinstallprompt
   */
  /**
   * Whether a document called called Window.onbeforeinstallprompt. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_onbeforeinstallprompt(2018);

  /**
   * generated from use.counter.doc.window_oncancel
   */
  /**
   * Whether a document called called Window.oncancel. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_oncancel(2019);

  /**
   * generated from use.counter.doc.window_onmousewheel
   */
  /**
   * Whether a document called called Window.onmousewheel. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_onmousewheel(2020);

  /**
   * generated from use.counter.doc.window_onorientationchange
   */
  /**
   * Whether a document called called Window.onorientationchange. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_onorientationchange(2021);

  /**
   * generated from use.counter.doc.window_onsearch
   */
  /**
   * Whether a document called called Window.onsearch. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_onsearch(2022);

  /**
   * generated from use.counter.doc.window_onselectionchange
   */
  /**
   * Whether a document called called Window.onselectionchange. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_onselectionchange(2023);

  /**
   * generated from use.counter.doc.window_open_empty_url
   */
  /**
   * Whether a document calls window.open with an empty url argument. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_open_empty_url(2024);

  /**
   * generated from use.counter.doc.window_opendatabase
   */
  /**
   * Whether a document called called Window.openDatabase. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_opendatabase(2025);

  /**
   * generated from use.counter.doc.window_orientation
   */
  /**
   * Whether a document called called Window.orientation. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_orientation(2026);

  /**
   * generated from use.counter.doc.window_orientationsensor
   */
  /**
   * Whether a document called called Window.OrientationSensor. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_orientationsensor(2027);

  /**
   * generated from use.counter.doc.window_overconstrainederror
   */
  /**
   * Whether a document called called Window.OverconstrainedError. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_overconstrainederror(2028);

  /**
   * generated from use.counter.doc.window_passwordcredential
   */
  /**
   * Whether a document called called Window.PasswordCredential. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_passwordcredential(2029);

  /**
   * generated from use.counter.doc.window_paymentaddress
   */
  /**
   * Whether a document called called Window.PaymentAddress. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_paymentaddress(2030);

  /**
   * generated from use.counter.doc.window_paymentinstruments
   */
  /**
   * Whether a document called called Window.PaymentInstruments. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_paymentinstruments(2031);

  /**
   * generated from use.counter.doc.window_paymentmanager
   */
  /**
   * Whether a document called called Window.PaymentManager. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_paymentmanager(2032);

  /**
   * generated from use.counter.doc.window_paymentmethodchangeevent
   */
  /**
   * Whether a document called called Window.PaymentMethodChangeEvent. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_paymentmethodchangeevent(2033);

  /**
   * generated from use.counter.doc.window_paymentrequest
   */
  /**
   * Whether a document called called Window.PaymentRequest. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_paymentrequest(2034);

  /**
   * generated from use.counter.doc.window_paymentrequestupdateevent
   */
  /**
   * Whether a document called called Window.PaymentRequestUpdateEvent. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_paymentrequestupdateevent(2035);

  /**
   * generated from use.counter.doc.window_paymentresponse
   */
  /**
   * Whether a document called called Window.PaymentResponse. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_paymentresponse(2036);

  /**
   * generated from use.counter.doc.window_performancelongtasktiming
   */
  /**
   * Whether a document called called Window.PerformanceLongTaskTiming. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_performancelongtasktiming(2037);

  /**
   * generated from use.counter.doc.window_photocapabilities
   */
  /**
   * Whether a document called called Window.PhotoCapabilities. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_photocapabilities(2038);

  /**
   * generated from use.counter.doc.window_pictureinpictureevent
   */
  /**
   * Whether a document called called Window.PictureInPictureEvent. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_pictureinpictureevent(2039);

  /**
   * generated from use.counter.doc.window_pictureinpicturewindow
   */
  /**
   * Whether a document called called Window.PictureInPictureWindow. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_pictureinpicturewindow(2040);

  /**
   * generated from use.counter.doc.window_presentation
   */
  /**
   * Whether a document called called Window.Presentation. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_presentation(2041);

  /**
   * generated from use.counter.doc.window_presentationavailability
   */
  /**
   * Whether a document called called Window.PresentationAvailability. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_presentationavailability(2042);

  /**
   * generated from use.counter.doc.window_presentationconnection
   */
  /**
   * Whether a document called called Window.PresentationConnection. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_presentationconnection(2043);

  /**
   * generated from use.counter.doc.window_presentationconnectionavailableevent
   */
  /**
   * Whether a document called called Window.PresentationConnectionAvailableEvent.
     * Compare against `use.counter.content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric window_presentationconnectionavailableevent(2044);

  /**
   * generated from use.counter.doc.window_presentationconnectioncloseevent
   */
  /**
   * Whether a document called called Window.PresentationConnectionCloseEvent.
     * Compare against `use.counter.content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric window_presentationconnectioncloseevent(2045);

  /**
   * generated from use.counter.doc.window_presentationconnectionlist
   */
  /**
   * Whether a document called called Window.PresentationConnectionList. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_presentationconnectionlist(2046);

  /**
   * generated from use.counter.doc.window_presentationreceiver
   */
  /**
   * Whether a document called called Window.PresentationReceiver. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_presentationreceiver(2047);

  /**
   * generated from use.counter.doc.window_presentationrequest
   */
  /**
   * Whether a document called called Window.PresentationRequest. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_presentationrequest(2048);

  /**
   * generated from use.counter.doc.window_relativeorientationsensor
   */
  /**
   * Whether a document called called Window.RelativeOrientationSensor. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_relativeorientationsensor(2049);

  /**
   * generated from use.counter.doc.window_remoteplayback
   */
  /**
   * Whether a document called called Window.RemotePlayback. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_remoteplayback(2050);

  /**
   * generated from use.counter.doc.window_report
   */
  /**
   * Whether a document called called Window.Report. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_report(2051);

  /**
   * generated from use.counter.doc.window_reportbody
   */
  /**
   * Whether a document called called Window.ReportBody. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_reportbody(2052);

  /**
   * generated from use.counter.doc.window_reportingobserver
   */
  /**
   * Whether a document called called Window.ReportingObserver. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_reportingobserver(2053);

  /**
   * generated from use.counter.doc.window_rtcerror
   */
  /**
   * Whether a document called called Window.RTCError. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_rtcerror(2054);

  /**
   * generated from use.counter.doc.window_rtcerrorevent
   */
  /**
   * Whether a document called called Window.RTCErrorEvent. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_rtcerrorevent(2055);

  /**
   * generated from use.counter.doc.window_rtcicetransport
   */
  /**
   * Whether a document called called Window.RTCIceTransport. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_rtcicetransport(2056);

  /**
   * generated from use.counter.doc.window_rtcpeerconnectioniceerrorevent
   */
  /**
   * Whether a document called called Window.RTCPeerConnectionIceErrorEvent. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_rtcpeerconnectioniceerrorevent(2057);

  /**
   * generated from use.counter.doc.window_sensor
   */
  /**
   * Whether a document called called Window.Sensor. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_sensor(2058);

  /**
   * generated from use.counter.doc.window_sensorerrorevent
   */
  /**
   * Whether a document called called Window.SensorErrorEvent. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_sensorerrorevent(2059);

  /**
   * generated from use.counter.doc.window_sidebar_getter
   */
  /**
   * Whether a document got Window.sidebar. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_sidebar_getter(2060);

  /**
   * generated from use.counter.doc.window_sidebar_setter
   */
  /**
   * Whether a document set Window.sidebar. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_sidebar_setter(2061);

  /**
   * generated from use.counter.doc.window_speechrecognitionalternative
   */
  /**
   * Whether a document called called Window.SpeechRecognitionAlternative. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_speechrecognitionalternative(2062);

  /**
   * generated from use.counter.doc.window_speechrecognitionresult
   */
  /**
   * Whether a document called called Window.SpeechRecognitionResult. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_speechrecognitionresult(2063);

  /**
   * generated from use.counter.doc.window_speechrecognitionresultlist
   */
  /**
   * Whether a document called called Window.SpeechRecognitionResultList. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_speechrecognitionresultlist(2064);

  /**
   * generated from use.counter.doc.window_stylemedia
   */
  /**
   * Whether a document called called Window.styleMedia. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_stylemedia(2065);

  /**
   * generated from use.counter.doc.window_stylepropertymap
   */
  /**
   * Whether a document called called Window.StylePropertyMap. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_stylepropertymap(2066);

  /**
   * generated from use.counter.doc.window_stylepropertymapreadonly
   */
  /**
   * Whether a document called called Window.StylePropertyMapReadOnly. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_stylepropertymapreadonly(2067);

  /**
   * generated from use.counter.doc.window_svgdiscardelement
   */
  /**
   * Whether a document called called Window.SVGDiscardElement. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_svgdiscardelement(2068);

  /**
   * generated from use.counter.doc.window_syncmanager
   */
  /**
   * Whether a document called called Window.SyncManager. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_syncmanager(2069);

  /**
   * generated from use.counter.doc.window_taskattributiontiming
   */
  /**
   * Whether a document called called Window.TaskAttributionTiming. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_taskattributiontiming(2070);

  /**
   * generated from use.counter.doc.window_textevent
   */
  /**
   * Whether a document called called Window.TextEvent. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_textevent(2071);

  /**
   * generated from use.counter.doc.window_touch
   */
  /**
   * Whether a document called called Window.Touch. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_touch(2072);

  /**
   * generated from use.counter.doc.window_touchevent
   */
  /**
   * Whether a document called called Window.TouchEvent. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_touchevent(2073);

  /**
   * generated from use.counter.doc.window_touchlist
   */
  /**
   * Whether a document called called Window.TouchList. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_touchlist(2074);

  /**
   * generated from use.counter.doc.window_usb
   */
  /**
   * Whether a document called called Window.USB. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_usb(2075);

  /**
   * generated from use.counter.doc.window_usbalternateinterface
   */
  /**
   * Whether a document called called Window.USBAlternateInterface. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_usbalternateinterface(2076);

  /**
   * generated from use.counter.doc.window_usbconfiguration
   */
  /**
   * Whether a document called called Window.USBConfiguration. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_usbconfiguration(2077);

  /**
   * generated from use.counter.doc.window_usbconnectionevent
   */
  /**
   * Whether a document called called Window.USBConnectionEvent. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_usbconnectionevent(2078);

  /**
   * generated from use.counter.doc.window_usbdevice
   */
  /**
   * Whether a document called called Window.USBDevice. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_usbdevice(2079);

  /**
   * generated from use.counter.doc.window_usbendpoint
   */
  /**
   * Whether a document called called Window.USBEndpoint. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_usbendpoint(2080);

  /**
   * generated from use.counter.doc.window_usbinterface
   */
  /**
   * Whether a document called called Window.USBInterface. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_usbinterface(2081);

  /**
   * generated from use.counter.doc.window_usbintransferresult
   */
  /**
   * Whether a document called called Window.USBInTransferResult. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_usbintransferresult(2082);

  /**
   * generated from use.counter.doc.window_usbisochronousintransferpacket
   */
  /**
   * Whether a document called called Window.USBIsochronousInTransferPacket. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_usbisochronousintransferpacket(2083);

  /**
   * generated from use.counter.doc.window_usbisochronousintransferresult
   */
  /**
   * Whether a document called called Window.USBIsochronousInTransferResult. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_usbisochronousintransferresult(2084);

  /**
   * generated from use.counter.doc.window_usbisochronousouttransferpacket
   */
  /**
   * Whether a document called called Window.USBIsochronousOutTransferPacket.
     * Compare against `use.counter.content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric window_usbisochronousouttransferpacket(2085);

  /**
   * generated from use.counter.doc.window_usbisochronousouttransferresult
   */
  /**
   * Whether a document called called Window.USBIsochronousOutTransferResult.
     * Compare against `use.counter.content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric window_usbisochronousouttransferresult(2086);

  /**
   * generated from use.counter.doc.window_usbouttransferresult
   */
  /**
   * Whether a document called called Window.USBOutTransferResult. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_usbouttransferresult(2087);

  /**
   * generated from use.counter.doc.window_useractivation
   */
  /**
   * Whether a document called called Window.UserActivation. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_useractivation(2088);

  /**
   * generated from use.counter.doc.window_videocolorspace
   */
  /**
   * Whether a document called called Window.VideoColorSpace. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_videocolorspace(2089);

  /**
   * generated from use.counter.doc.window_videodecoder
   */
  /**
   * Whether a document called called Window.VideoDecoder. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_videodecoder(2090);

  /**
   * generated from use.counter.doc.window_videoencoder
   */
  /**
   * Whether a document called called Window.VideoEncoder. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_videoencoder(2091);

  /**
   * generated from use.counter.doc.window_videoframe
   */
  /**
   * Whether a document called called Window.VideoFrame. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_videoframe(2092);

  /**
   * generated from use.counter.doc.window_wakelock
   */
  /**
   * Whether a document called called Window.WakeLock. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_wakelock(2093);

  /**
   * generated from use.counter.doc.window_wakelocksentinel
   */
  /**
   * Whether a document called called Window.WakeLockSentinel. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_wakelocksentinel(2094);

  /**
   * generated from use.counter.doc.window_webkitcancelanimationframe
   */
  /**
   * Whether a document called called Window.webkitCancelAnimationFrame. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_webkitcancelanimationframe(2095);

  /**
   * generated from use.counter.doc.window_webkitmediastream
   */
  /**
   * Whether a document called called Window.webkitMediaStream. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_webkitmediastream(2096);

  /**
   * generated from use.counter.doc.window_webkitmutationobserver
   */
  /**
   * Whether a document called called Window.WebKitMutationObserver. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_webkitmutationobserver(2097);

  /**
   * generated from use.counter.doc.window_webkitrequestanimationframe
   */
  /**
   * Whether a document called called Window.webkitRequestAnimationFrame. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_webkitrequestanimationframe(2098);

  /**
   * generated from use.counter.doc.window_webkitrequestfilesystem
   */
  /**
   * Whether a document called called Window.webkitRequestFileSystem. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_webkitrequestfilesystem(2099);

  /**
   * generated from use.counter.doc.window_webkitresolvelocalfilesystemurl
   */
  /**
   * Whether a document called called Window.webkitResolveLocalFileSystemURL.
     * Compare against `use.counter.content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric window_webkitresolvelocalfilesystemurl(2100);

  /**
   * generated from use.counter.doc.window_webkitrtcpeerconnection
   */
  /**
   * Whether a document called called Window.webkitRTCPeerConnection. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_webkitrtcpeerconnection(2101);

  /**
   * generated from use.counter.doc.window_webkitspeechgrammar
   */
  /**
   * Whether a document called called Window.webkitSpeechGrammar. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_webkitspeechgrammar(2102);

  /**
   * generated from use.counter.doc.window_webkitspeechgrammarlist
   */
  /**
   * Whether a document called called Window.webkitSpeechGrammarList. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_webkitspeechgrammarlist(2103);

  /**
   * generated from use.counter.doc.window_webkitspeechrecognition
   */
  /**
   * Whether a document called called Window.webkitSpeechRecognition. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_webkitspeechrecognition(2104);

  /**
   * generated from use.counter.doc.window_webkitspeechrecognitionerror
   */
  /**
   * Whether a document called called Window.webkitSpeechRecognitionError. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_webkitspeechrecognitionerror(2105);

  /**
   * generated from use.counter.doc.window_webkitspeechrecognitionevent
   */
  /**
   * Whether a document called called Window.webkitSpeechRecognitionEvent. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_webkitspeechrecognitionevent(2106);

  /**
   * generated from use.counter.doc.window_webkitstorageinfo
   */
  /**
   * Whether a document called called Window.webkitStorageInfo. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_webkitstorageinfo(2107);

  /**
   * generated from use.counter.doc.workernavigator_permissions
   */
  /**
   * Whether a document called called WorkerNavigator.permissions. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric workernavigator_permissions(2108);

  /**
   * generated from use.counter.doc.wr_filter_fallback
   */
  /**
   * Whether a document triggers the blob fallback for an SVG filter.. Compare
     * against `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric wr_filter_fallback(2109);

  /**
   * generated from use.counter.doc.xslstylesheet
   */
  /**
   * Whether a document uses an XSL Stylesheet. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric xslstylesheet(2110);

  /**
   * generated from use.counter.doc.xsltprocessor_constructor
   */
  /**
   * Whether a document called called XSLTProcessor.constructor. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric xsltprocessor_constructor(2111);

  /**
   * generated from use.counter.doc.you_tube_flash_embed
   */
  /**
   * Whether a document in <object> or <embed>. Compare against
     * `use.counter.content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric you_tube_flash_embed(2112);

}
namespace use_counter_page {
  /**
   * generated from use.counter.page.clipboard_read
   */
  /**
   * Whether a page called called Clipboard.read. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric clipboard_read(2113);

  /**
   * generated from use.counter.page.clipboard_readtext
   */
  /**
   * Whether a page called called Clipboard.readText. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric clipboard_readtext(2114);

  /**
   * generated from use.counter.page.clipboard_write
   */
  /**
   * Whether a page called called Clipboard.write. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric clipboard_write(2115);

  /**
   * generated from use.counter.page.console_assert
   */
  /**
   * Whether a page called called console.assert. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_assert(2116);

  /**
   * generated from use.counter.page.console_clear
   */
  /**
   * Whether a page called called console.clear. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_clear(2117);

  /**
   * generated from use.counter.page.console_count
   */
  /**
   * Whether a page called called console.count. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_count(2118);

  /**
   * generated from use.counter.page.console_countreset
   */
  /**
   * Whether a page called called console.countReset. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_countreset(2119);

  /**
   * generated from use.counter.page.console_debug
   */
  /**
   * Whether a page called called console.debug. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_debug(2120);

  /**
   * generated from use.counter.page.console_dir
   */
  /**
   * Whether a page called called console.dir. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_dir(2121);

  /**
   * generated from use.counter.page.console_dirxml
   */
  /**
   * Whether a page called called console.dirxml. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_dirxml(2122);

  /**
   * generated from use.counter.page.console_error
   */
  /**
   * Whether a page called called console.error. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_error(2123);

  /**
   * generated from use.counter.page.console_exception
   */
  /**
   * Whether a page called called console.exception. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_exception(2124);

  /**
   * generated from use.counter.page.console_group
   */
  /**
   * Whether a page called called console.group. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_group(2125);

  /**
   * generated from use.counter.page.console_groupcollapsed
   */
  /**
   * Whether a page called called console.groupCollapsed. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_groupcollapsed(2126);

  /**
   * generated from use.counter.page.console_groupend
   */
  /**
   * Whether a page called called console.groupEnd. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_groupend(2127);

  /**
   * generated from use.counter.page.console_info
   */
  /**
   * Whether a page called called console.info. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_info(2128);

  /**
   * generated from use.counter.page.console_log
   */
  /**
   * Whether a page called called console.log. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_log(2129);

  /**
   * generated from use.counter.page.console_profile
   */
  /**
   * Whether a page called called console.profile. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_profile(2130);

  /**
   * generated from use.counter.page.console_profileend
   */
  /**
   * Whether a page called called console.profileEnd. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_profileend(2131);

  /**
   * generated from use.counter.page.console_table
   */
  /**
   * Whether a page called called console.table. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_table(2132);

  /**
   * generated from use.counter.page.console_time
   */
  /**
   * Whether a page called called console.time. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_time(2133);

  /**
   * generated from use.counter.page.console_timeend
   */
  /**
   * Whether a page called called console.timeEnd. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_timeend(2134);

  /**
   * generated from use.counter.page.console_timelog
   */
  /**
   * Whether a page called called console.timeLog. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_timelog(2135);

  /**
   * generated from use.counter.page.console_timestamp
   */
  /**
   * Whether a page called called console.timeStamp. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_timestamp(2136);

  /**
   * generated from use.counter.page.console_trace
   */
  /**
   * Whether a page called called console.trace. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_trace(2137);

  /**
   * generated from use.counter.page.console_warn
   */
  /**
   * Whether a page called called console.warn. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_warn(2138);

  /**
   * generated from use.counter.page.customelementregistry_define
   */
  /**
   * Whether a page called called CustomElementRegistry.define. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric customelementregistry_define(2139);

  /**
   * generated from use.counter.page.customized_builtin
   */
  /**
   * Whether a page registers a customized built-in element. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric customized_builtin(2140);

  /**
   * generated from use.counter.page.datatransfer_addelement
   */
  /**
   * Whether a page called called DataTransfer.addElement. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric datatransfer_addelement(2141);

  /**
   * generated from use.counter.page.datatransfer_mozcleardataat
   */
  /**
   * Whether a page called called DataTransfer.mozClearDataAt. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric datatransfer_mozcleardataat(2142);

  /**
   * generated from use.counter.page.datatransfer_mozcursor_getter
   */
  /**
   * Whether a page got DataTransfer.mozCursor. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric datatransfer_mozcursor_getter(2143);

  /**
   * generated from use.counter.page.datatransfer_mozcursor_setter
   */
  /**
   * Whether a page set DataTransfer.mozCursor. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric datatransfer_mozcursor_setter(2144);

  /**
   * generated from use.counter.page.datatransfer_mozgetdataat
   */
  /**
   * Whether a page called called DataTransfer.mozGetDataAt. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric datatransfer_mozgetdataat(2145);

  /**
   * generated from use.counter.page.datatransfer_mozitemcount_getter
   */
  /**
   * Whether a page got DataTransfer.mozItemCount. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric datatransfer_mozitemcount_getter(2146);

  /**
   * generated from use.counter.page.datatransfer_mozitemcount_setter
   */
  /**
   * Whether a page set DataTransfer.mozItemCount. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric datatransfer_mozitemcount_setter(2147);

  /**
   * generated from use.counter.page.datatransfer_mozsetdataat
   */
  /**
   * Whether a page called called DataTransfer.mozSetDataAt. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric datatransfer_mozsetdataat(2148);

  /**
   * generated from use.counter.page.datatransfer_mozsourcenode_getter
   */
  /**
   * Whether a page got DataTransfer.mozSourceNode. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric datatransfer_mozsourcenode_getter(2149);

  /**
   * generated from use.counter.page.datatransfer_mozsourcenode_setter
   */
  /**
   * Whether a page set DataTransfer.mozSourceNode. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric datatransfer_mozsourcenode_setter(2150);

  /**
   * generated from use.counter.page.datatransfer_moztypesat
   */
  /**
   * Whether a page called called DataTransfer.mozTypesAt. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric datatransfer_moztypesat(2151);

  /**
   * generated from use.counter.page.datatransfer_mozusercancelled_getter
   */
  /**
   * Whether a page got DataTransfer.mozUserCancelled. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric datatransfer_mozusercancelled_getter(2152);

  /**
   * generated from use.counter.page.datatransfer_mozusercancelled_setter
   */
  /**
   * Whether a page set DataTransfer.mozUserCancelled. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric datatransfer_mozusercancelled_setter(2153);

  /**
   * generated from use.counter.page.datatransferitem_webkitgetasentry
   */
  /**
   * Whether a page called called DataTransferItem.webkitGetAsEntry. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric datatransferitem_webkitgetasentry(2154);

  /**
   * generated from use.counter.page.document_caretrangefrompoint
   */
  /**
   * Whether a page called called Document.caretRangeFromPoint. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_caretrangefrompoint(2155);

  /**
   * generated from use.counter.page.document_exec_command_content_read_only
   */
  /**
   * Whether a page calls execCommand with contentReadOnly. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_exec_command_content_read_only(2156);

  /**
   * generated from use.counter.page.document_exitpictureinpicture
   */
  /**
   * Whether a page called called Document.exitPictureInPicture. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_exitpictureinpicture(2157);

  /**
   * generated from use.counter.page.document_featurepolicy
   */
  /**
   * Whether a page called called Document.featurePolicy. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_featurepolicy(2158);

  /**
   * generated from use.counter.page.document_mozsetimageelement
   */
  /**
   * Whether a page called called Document.mozSetImageElement. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_mozsetimageelement(2159);

  /**
   * generated from use.counter.page.document_onbeforecopy
   */
  /**
   * Whether a page called called Document.onbeforecopy. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_onbeforecopy(2160);

  /**
   * generated from use.counter.page.document_onbeforecut
   */
  /**
   * Whether a page called called Document.onbeforecut. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_onbeforecut(2161);

  /**
   * generated from use.counter.page.document_onbeforepaste
   */
  /**
   * Whether a page called called Document.onbeforepaste. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_onbeforepaste(2162);

  /**
   * generated from use.counter.page.document_oncancel
   */
  /**
   * Whether a page called called Document.oncancel. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_oncancel(2163);

  /**
   * generated from use.counter.page.document_onfreeze
   */
  /**
   * Whether a page called called Document.onfreeze. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_onfreeze(2164);

  /**
   * generated from use.counter.page.document_onmousewheel
   */
  /**
   * Whether a page called called Document.onmousewheel. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_onmousewheel(2165);

  /**
   * generated from use.counter.page.document_onresume
   */
  /**
   * Whether a page called called Document.onresume. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_onresume(2166);

  /**
   * generated from use.counter.page.document_onsearch
   */
  /**
   * Whether a page called called Document.onsearch. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_onsearch(2167);

  /**
   * generated from use.counter.page.document_onwebkitfullscreenchange
   */
  /**
   * Whether a page called called Document.onwebkitfullscreenchange. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_onwebkitfullscreenchange(2168);

  /**
   * generated from use.counter.page.document_onwebkitfullscreenerror
   */
  /**
   * Whether a page called called Document.onwebkitfullscreenerror. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_onwebkitfullscreenerror(2169);

  /**
   * generated from use.counter.page.document_open
   */
  /**
   * Whether a page calls document.open in a way that creates a new Window object.
     * Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric document_open(2170);

  /**
   * generated from use.counter.page.document_pictureinpictureelement
   */
  /**
   * Whether a page called called Document.pictureInPictureElement. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_pictureinpictureelement(2171);

  /**
   * generated from use.counter.page.document_pictureinpictureenabled
   */
  /**
   * Whether a page called called Document.pictureInPictureEnabled. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_pictureinpictureenabled(2172);

  /**
   * generated from use.counter.page.document_query_command_state_or_value_content_read_only
   */
  /**
   * Whether a page calls queryCommandState or queryCommandValue with
     * contentReadOnly. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_query_command_state_or_value_content_read_only(2173);

  /**
   * generated from use.counter.page.document_query_command_state_or_value_insert_br_on_return
   */
  /**
   * Whether a page calls queryCommandState or queryCommandValue with
     * insertBrOnReturn. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_query_command_state_or_value_insert_br_on_return(2174);

  /**
   * generated from use.counter.page.document_query_command_supported_or_enabled_content_read_only
   */
  /**
   * Whether a page calls queryCommandSupported or queryCommandEnabled with
     * contentReadOnly. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_query_command_supported_or_enabled_content_read_only(2175);

  /**
   * generated from use.counter.page.document_query_command_supported_or_enabled_insert_br_on_return
   */
  /**
   * Whether a page calls queryCommandSupported or queryCommandEnabled with
     * insertBrOnReturn. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_query_command_supported_or_enabled_insert_br_on_return(2176);

  /**
   * generated from use.counter.page.document_registerelement
   */
  /**
   * Whether a page called called Document.registerElement. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_registerelement(2177);

  /**
   * generated from use.counter.page.document_wasdiscarded
   */
  /**
   * Whether a page called called Document.wasDiscarded. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_wasdiscarded(2178);

  /**
   * generated from use.counter.page.document_webkitcancelfullscreen
   */
  /**
   * Whether a page called called Document.webkitCancelFullScreen. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_webkitcancelfullscreen(2179);

  /**
   * generated from use.counter.page.document_webkitcurrentfullscreenelement
   */
  /**
   * Whether a page called called Document.webkitCurrentFullScreenElement. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric document_webkitcurrentfullscreenelement(2180);

  /**
   * generated from use.counter.page.document_webkitexitfullscreen
   */
  /**
   * Whether a page called called Document.webkitExitFullscreen. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_webkitexitfullscreen(2181);

  /**
   * generated from use.counter.page.document_webkitfullscreenelement
   */
  /**
   * Whether a page called called Document.webkitFullscreenElement. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_webkitfullscreenelement(2182);

  /**
   * generated from use.counter.page.document_webkitfullscreenenabled
   */
  /**
   * Whether a page called called Document.webkitFullscreenEnabled. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_webkitfullscreenenabled(2183);

  /**
   * generated from use.counter.page.document_webkithidden
   */
  /**
   * Whether a page called called Document.webkitHidden. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_webkithidden(2184);

  /**
   * generated from use.counter.page.document_webkitisfullscreen
   */
  /**
   * Whether a page called called Document.webkitIsFullScreen. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_webkitisfullscreen(2185);

  /**
   * generated from use.counter.page.document_webkitvisibilitystate
   */
  /**
   * Whether a page called called Document.webkitVisibilityState. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_webkitvisibilitystate(2186);

  /**
   * generated from use.counter.page.document_xmlencoding
   */
  /**
   * Whether a page called called Document.xmlEncoding. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_xmlencoding(2187);

  /**
   * generated from use.counter.page.document_xmlstandalone
   */
  /**
   * Whether a page called called Document.xmlStandalone. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_xmlstandalone(2188);

  /**
   * generated from use.counter.page.document_xmlversion
   */
  /**
   * Whether a page called called Document.xmlVersion. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric document_xmlversion(2189);

  /**
   * generated from use.counter.page.domparser_parsefromstring
   */
  /**
   * Whether a page called called DOMParser.parseFromString. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric domparser_parsefromstring(2190);

  /**
   * generated from use.counter.page.element_attachshadow
   */
  /**
   * Whether a page called called Element.attachShadow. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric element_attachshadow(2191);

  /**
   * generated from use.counter.page.element_computedstylemap
   */
  /**
   * Whether a page called called Element.computedStyleMap. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric element_computedstylemap(2192);

  /**
   * generated from use.counter.page.element_onmousewheel
   */
  /**
   * Whether a page called called Element.onmousewheel. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric element_onmousewheel(2193);

  /**
   * generated from use.counter.page.element_releasecapture
   */
  /**
   * Whether a page called called Element.releaseCapture. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric element_releasecapture(2194);

  /**
   * generated from use.counter.page.element_releasepointercapture
   */
  /**
   * Whether a page called called Element.releasePointerCapture. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric element_releasepointercapture(2195);

  /**
   * generated from use.counter.page.element_scrollintoviewifneeded
   */
  /**
   * Whether a page called called Element.scrollIntoViewIfNeeded. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric element_scrollintoviewifneeded(2196);

  /**
   * generated from use.counter.page.element_setcapture
   */
  /**
   * Whether a page called called Element.setCapture. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric element_setcapture(2197);

  /**
   * generated from use.counter.page.element_sethtml
   */
  /**
   * Whether a page called called Element.setHTML. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric element_sethtml(2198);

  /**
   * generated from use.counter.page.element_setpointercapture
   */
  /**
   * Whether a page called called Element.setPointerCapture. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric element_setpointercapture(2199);

  /**
   * generated from use.counter.page.enumerate_devices_insec
   */
  /**
   * Whether a page calls MediaDevices.enumerateDevices from an insecure context.
     * Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric enumerate_devices_insec(2200);

  /**
   * generated from use.counter.page.enumerate_devices_unfocused
   */
  /**
   * Whether a page calls MediaDevices.enumerateDevices from a unfocused document.
     * Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric enumerate_devices_unfocused(2201);

  /**
   * generated from use.counter.page.fe_blend
   */
  /**
   * Whether a page uses the feBlend SVG filter.. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric fe_blend(2202);

  /**
   * generated from use.counter.page.fe_color_matrix
   */
  /**
   * Whether a page uses the feColorMatrix SVG filter.. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric fe_color_matrix(2203);

  /**
   * generated from use.counter.page.fe_component_transfer
   */
  /**
   * Whether a page uses the feComponentTransfer SVG filter.. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric fe_component_transfer(2204);

  /**
   * generated from use.counter.page.fe_composite
   */
  /**
   * Whether a page uses the feComposite SVG filter.. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric fe_composite(2205);

  /**
   * generated from use.counter.page.fe_convolve_matrix
   */
  /**
   * Whether a page uses the feConvolveMatrix SVG filter.. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric fe_convolve_matrix(2206);

  /**
   * generated from use.counter.page.fe_diffuse_lighting
   */
  /**
   * Whether a page uses the feDiffuseLighting SVG filter.. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric fe_diffuse_lighting(2207);

  /**
   * generated from use.counter.page.fe_displacement_map
   */
  /**
   * Whether a page uses the feDisplacementMap SVG filter.. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric fe_displacement_map(2208);

  /**
   * generated from use.counter.page.fe_flood
   */
  /**
   * Whether a page uses the feFlood SVG filter.. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric fe_flood(2209);

  /**
   * generated from use.counter.page.fe_gaussian_blur
   */
  /**
   * Whether a page uses the feGaussianBlur SVG filter.. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric fe_gaussian_blur(2210);

  /**
   * generated from use.counter.page.fe_image
   */
  /**
   * Whether a page uses the feImage SVG filter.. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric fe_image(2211);

  /**
   * generated from use.counter.page.fe_merge
   */
  /**
   * Whether a page uses the feMerge SVG filter.. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric fe_merge(2212);

  /**
   * generated from use.counter.page.fe_morphology
   */
  /**
   * Whether a page uses the feMorphology SVG filter.. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric fe_morphology(2213);

  /**
   * generated from use.counter.page.fe_offset
   */
  /**
   * Whether a page uses the feOffset SVG filter.. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric fe_offset(2214);

  /**
   * generated from use.counter.page.fe_specular_lighting
   */
  /**
   * Whether a page uses the feSpecularLighting SVG filter.. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric fe_specular_lighting(2215);

  /**
   * generated from use.counter.page.fe_tile
   */
  /**
   * Whether a page uses the feTile SVG filter.. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric fe_tile(2216);

  /**
   * generated from use.counter.page.fe_turbulence
   */
  /**
   * Whether a page uses the feTurbulence SVG filter.. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric fe_turbulence(2217);

  /**
   * generated from use.counter.page.filtered_cross_origin_iframe
   */
  /**
   * Whether a page cross-origin <iframe> within a CSS/SVG filter. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric filtered_cross_origin_iframe(2218);

  /**
   * generated from use.counter.page.get_user_media_insec
   */
  /**
   * Whether a page calls MediaDevices.getUserMedia from an insecure context.
     * Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric get_user_media_insec(2219);

  /**
   * generated from use.counter.page.get_user_media_unfocused
   */
  /**
   * Whether a page calls MediaDevices.getUserMedia from an unfocused document.
     * Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric get_user_media_unfocused(2220);

  /**
   * generated from use.counter.page.htmlbuttonelement_popovertargetaction
   */
  /**
   * Whether a page called called HTMLButtonElement.popoverTargetAction. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric htmlbuttonelement_popovertargetaction(2221);

  /**
   * generated from use.counter.page.htmlbuttonelement_popovertargetelement
   */
  /**
   * Whether a page called called HTMLButtonElement.popoverTargetElement. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric htmlbuttonelement_popovertargetelement(2222);

  /**
   * generated from use.counter.page.htmldialogelement_show
   */
  /**
   * Whether a page called called HTMLDialogElement.show. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric htmldialogelement_show(2223);

  /**
   * generated from use.counter.page.htmldocument_named_getter_hit
   */
  /**
   * Whether a page calls to the named getter on HTMLDocument that find something
     * via the name lookup. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric htmldocument_named_getter_hit(2224);

  /**
   * generated from use.counter.page.htmlelement_attributestylemap
   */
  /**
   * Whether a page called called HTMLElement.attributeStyleMap. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric htmlelement_attributestylemap(2225);

  /**
   * generated from use.counter.page.htmlelement_hidepopover
   */
  /**
   * Whether a page called called HTMLElement.hidePopover. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric htmlelement_hidepopover(2226);

  /**
   * generated from use.counter.page.htmlelement_popover
   */
  /**
   * Whether a page called called HTMLElement.popover. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric htmlelement_popover(2227);

  /**
   * generated from use.counter.page.htmlelement_showpopover
   */
  /**
   * Whether a page called called HTMLElement.showPopover. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric htmlelement_showpopover(2228);

  /**
   * generated from use.counter.page.htmlelement_togglepopover
   */
  /**
   * Whether a page called called HTMLElement.togglePopover. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric htmlelement_togglepopover(2229);

  /**
   * generated from use.counter.page.htmliframeelement_loading
   */
  /**
   * Whether a page called called HTMLIFrameElement.loading. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric htmliframeelement_loading(2230);

  /**
   * generated from use.counter.page.htmlinputelement_capture
   */
  /**
   * Whether a page called called HTMLInputElement.capture. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric htmlinputelement_capture(2231);

  /**
   * generated from use.counter.page.htmlinputelement_incremental
   */
  /**
   * Whether a page called called HTMLInputElement.incremental. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric htmlinputelement_incremental(2232);

  /**
   * generated from use.counter.page.htmlinputelement_onsearch
   */
  /**
   * Whether a page called called HTMLInputElement.onsearch. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric htmlinputelement_onsearch(2233);

  /**
   * generated from use.counter.page.htmlinputelement_popovertargetaction
   */
  /**
   * Whether a page called called HTMLInputElement.popoverTargetAction. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric htmlinputelement_popovertargetaction(2234);

  /**
   * generated from use.counter.page.htmlinputelement_popovertargetelement
   */
  /**
   * Whether a page called called HTMLInputElement.popoverTargetElement. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric htmlinputelement_popovertargetelement(2235);

  /**
   * generated from use.counter.page.htmlinputelement_webkitdirectory
   */
  /**
   * Whether a page called called HTMLInputElement.webkitdirectory. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric htmlinputelement_webkitdirectory(2236);

  /**
   * generated from use.counter.page.htmlinputelement_webkitentries
   */
  /**
   * Whether a page called called HTMLInputElement.webkitEntries. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric htmlinputelement_webkitentries(2237);

  /**
   * generated from use.counter.page.htmlmediaelement_disableremoteplayback
   */
  /**
   * Whether a page called called HTMLMediaElement.disableRemotePlayback. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric htmlmediaelement_disableremoteplayback(2238);

  /**
   * generated from use.counter.page.htmlmediaelement_remote
   */
  /**
   * Whether a page called called HTMLMediaElement.remote. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric htmlmediaelement_remote(2239);

  /**
   * generated from use.counter.page.htmlvideoelement_cancelvideoframecallback
   */
  /**
   * Whether a page called called HTMLVideoElement.cancelVideoFrameCallback. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric htmlvideoelement_cancelvideoframecallback(2240);

  /**
   * generated from use.counter.page.htmlvideoelement_disablepictureinpicture
   */
  /**
   * Whether a page called called HTMLVideoElement.disablePictureInPicture. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric htmlvideoelement_disablepictureinpicture(2241);

  /**
   * generated from use.counter.page.htmlvideoelement_onenterpictureinpicture
   */
  /**
   * Whether a page called called HTMLVideoElement.onenterpictureinpicture. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric htmlvideoelement_onenterpictureinpicture(2242);

  /**
   * generated from use.counter.page.htmlvideoelement_onleavepictureinpicture
   */
  /**
   * Whether a page called called HTMLVideoElement.onleavepictureinpicture. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric htmlvideoelement_onleavepictureinpicture(2243);

  /**
   * generated from use.counter.page.htmlvideoelement_playsinline
   */
  /**
   * Whether a page called called HTMLVideoElement.playsInline. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric htmlvideoelement_playsinline(2244);

  /**
   * generated from use.counter.page.htmlvideoelement_requestpictureinpicture
   */
  /**
   * Whether a page called called HTMLVideoElement.requestPictureInPicture. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric htmlvideoelement_requestpictureinpicture(2245);

  /**
   * generated from use.counter.page.htmlvideoelement_requestvideoframecallback
   */
  /**
   * Whether a page called called HTMLVideoElement.requestVideoFrameCallback.
     * Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric htmlvideoelement_requestvideoframecallback(2246);

  /**
   * generated from use.counter.page.imagedata_colorspace
   */
  /**
   * Whether a page called called ImageData.colorSpace. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric imagedata_colorspace(2247);

  /**
   * generated from use.counter.page.js_asmjs
   */
  /**
   * Whether a page uses asm.js. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric js_asmjs(2248);

  /**
   * generated from use.counter.page.js_subclassing_array_type_2
   */
  /**
   * Whether a page Array is Type II subclassed. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric js_subclassing_array_type_2(2249);

  /**
   * generated from use.counter.page.js_subclassing_array_type_3
   */
  /**
   * Whether a page Array is Type III subclassed. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric js_subclassing_array_type_3(2250);

  /**
   * generated from use.counter.page.js_subclassing_arraybuffer_type_3
   */
  /**
   * Whether a page ArrayBuffer is Type III subclassed. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric js_subclassing_arraybuffer_type_3(2251);

  /**
   * generated from use.counter.page.js_subclassing_promise_type_2
   */
  /**
   * Whether a page Promise is Type II subclassed. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric js_subclassing_promise_type_2(2252);

  /**
   * generated from use.counter.page.js_subclassing_promise_type_3
   */
  /**
   * Whether a page Promise is Type III subclassed. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric js_subclassing_promise_type_3(2253);

  /**
   * generated from use.counter.page.js_subclassing_regexp_type_3
   */
  /**
   * Whether a page RegExp is Type III subclassed. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric js_subclassing_regexp_type_3(2254);

  /**
   * generated from use.counter.page.js_subclassing_regexp_type_4
   */
  /**
   * Whether a page RegExp is Type IV subclassed. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric js_subclassing_regexp_type_4(2255);

  /**
   * generated from use.counter.page.js_subclassing_sharedarraybuffer_type_3
   */
  /**
   * Whether a page SharedArrayBuffer is Type III subclassed. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric js_subclassing_sharedarraybuffer_type_3(2256);

  /**
   * generated from use.counter.page.js_subclassing_typedarray_type_2
   */
  /**
   * Whether a page TypedArray is Type II subclassed. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric js_subclassing_typedarray_type_2(2257);

  /**
   * generated from use.counter.page.js_subclassing_typedarray_type_3
   */
  /**
   * Whether a page TypedArray is Type III subclassed. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric js_subclassing_typedarray_type_3(2258);

  /**
   * generated from use.counter.page.js_wasm
   */
  /**
   * Whether a page uses WebAssembly. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric js_wasm(2259);

  /**
   * generated from use.counter.page.js_wasm_legacy_exceptions
   */
  /**
   * Whether a page uses WebAssembly legacy exception-handling. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric js_wasm_legacy_exceptions(2260);

  /**
   * generated from use.counter.page.location_ancestororigins
   */
  /**
   * Whether a page called called Location.ancestorOrigins. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric location_ancestororigins(2261);

  /**
   * generated from use.counter.page.mediadevices_enumeratedevices
   */
  /**
   * Whether a page called called MediaDevices.enumerateDevices. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric mediadevices_enumeratedevices(2262);

  /**
   * generated from use.counter.page.mediadevices_getdisplaymedia
   */
  /**
   * Whether a page called called MediaDevices.getDisplayMedia. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric mediadevices_getdisplaymedia(2263);

  /**
   * generated from use.counter.page.mediadevices_getusermedia
   */
  /**
   * Whether a page called called MediaDevices.getUserMedia. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric mediadevices_getusermedia(2264);

  /**
   * generated from use.counter.page.mixed_content_not_upgraded_audio_failure
   */
  /**
   * Whether a page includes a mixed content audio element that does not load..
     * Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric mixed_content_not_upgraded_audio_failure(2265);

  /**
   * generated from use.counter.page.mixed_content_not_upgraded_audio_success
   */
  /**
   * Whether a page includes a mixed content audio element that loads.. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric mixed_content_not_upgraded_audio_success(2266);

  /**
   * generated from use.counter.page.mixed_content_not_upgraded_image_failure
   */
  /**
   * Whether a page includes a mixed content img element that does not load..
     * Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric mixed_content_not_upgraded_image_failure(2267);

  /**
   * generated from use.counter.page.mixed_content_not_upgraded_image_success
   */
  /**
   * Whether a page includes a mixed content img element that loads.. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric mixed_content_not_upgraded_image_success(2268);

  /**
   * generated from use.counter.page.mixed_content_not_upgraded_video_failure
   */
  /**
   * Whether a page includes a mixed content video element that does not laod..
     * Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric mixed_content_not_upgraded_video_failure(2269);

  /**
   * generated from use.counter.page.mixed_content_not_upgraded_video_success
   */
  /**
   * Whether a page includes a mixed content video element that loads.. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric mixed_content_not_upgraded_video_success(2270);

  /**
   * generated from use.counter.page.mixed_content_upgraded_audio_failure
   */
  /**
   * Whether a page includes a mixed content audio element that does not load..
     * Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric mixed_content_upgraded_audio_failure(2271);

  /**
   * generated from use.counter.page.mixed_content_upgraded_audio_success
   */
  /**
   * Whether a page includes a mixed content audio element that loads.. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric mixed_content_upgraded_audio_success(2272);

  /**
   * generated from use.counter.page.mixed_content_upgraded_image_failure
   */
  /**
   * Whether a page includes a mixed content img element that does not load..
     * Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric mixed_content_upgraded_image_failure(2273);

  /**
   * generated from use.counter.page.mixed_content_upgraded_image_success
   */
  /**
   * Whether a page includes a mixed content img element that loads.. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric mixed_content_upgraded_image_success(2274);

  /**
   * generated from use.counter.page.mixed_content_upgraded_video_failure
   */
  /**
   * Whether a page includes a mixed content video element that does not laod..
     * Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric mixed_content_upgraded_video_failure(2275);

  /**
   * generated from use.counter.page.mixed_content_upgraded_video_success
   */
  /**
   * Whether a page includes a mixed content video element that loads.. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric mixed_content_upgraded_video_success(2276);

  /**
   * generated from use.counter.page.moz_get_user_media_insec
   */
  /**
   * Whether a page calls Navigator.mozGetUserMedia from an insecure context.
     * Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric moz_get_user_media_insec(2277);

  /**
   * generated from use.counter.page.navigator_canshare
   */
  /**
   * Whether a page called called Navigator.canShare. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric navigator_canshare(2278);

  /**
   * generated from use.counter.page.navigator_clearappbadge
   */
  /**
   * Whether a page called called Navigator.clearAppBadge. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric navigator_clearappbadge(2279);

  /**
   * generated from use.counter.page.navigator_mozgetusermedia
   */
  /**
   * Whether a page called called Navigator.mozGetUserMedia. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric navigator_mozgetusermedia(2280);

  /**
   * generated from use.counter.page.navigator_setappbadge
   */
  /**
   * Whether a page called called Navigator.setAppBadge. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric navigator_setappbadge(2281);

  /**
   * generated from use.counter.page.navigator_share
   */
  /**
   * Whether a page called called Navigator.share. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric navigator_share(2282);

  /**
   * generated from use.counter.page.navigator_useractivation
   */
  /**
   * Whether a page called called Navigator.userActivation. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric navigator_useractivation(2283);

  /**
   * generated from use.counter.page.navigator_wakelock
   */
  /**
   * Whether a page called called Navigator.wakeLock. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric navigator_wakelock(2284);

  /**
   * generated from use.counter.page.ondommousescroll
   */
  /**
   * Whether a page sets DOMMouseScroll event listener. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric ondommousescroll(2285);

  /**
   * generated from use.counter.page.onmozmousepixelscroll
   */
  /**
   * Whether a page sets MozMousePixelScroll event listener. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric onmozmousepixelscroll(2286);

  /**
   * generated from use.counter.page.onoverflow
   */
  /**
   * Whether a page sets an element onoverflow event listener. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric onoverflow(2287);

  /**
   * generated from use.counter.page.onunderflow
   */
  /**
   * Whether a page sets an element onunderflow event listener. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric onunderflow(2288);

  /**
   * generated from use.counter.page.percentage_stroke_width_in_svg
   */
  /**
   * Whether a page whether percentage stroke-width is used in SVG elements
     * (excluding <text>). Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric percentage_stroke_width_in_svg(2289);

  /**
   * generated from use.counter.page.percentage_stroke_width_in_svgtext
   */
  /**
   * Whether a page whether percentage stroke-width is used in SVG <text>. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric percentage_stroke_width_in_svgtext(2290);

  /**
   * generated from use.counter.page.private_browsing_caches_delete
   */
  /**
   * Whether a page calls caches.delete in Private Browsing Mode. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric private_browsing_caches_delete(2291);

  /**
   * generated from use.counter.page.private_browsing_caches_has
   */
  /**
   * Whether a page calls caches.has in Private Browsing Mode. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric private_browsing_caches_has(2292);

  /**
   * generated from use.counter.page.private_browsing_caches_keys
   */
  /**
   * Whether a page calls caches.keys in Private Browsing Mode. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric private_browsing_caches_keys(2293);

  /**
   * generated from use.counter.page.private_browsing_caches_match
   */
  /**
   * Whether a page calls caches.match in Private Browsing Mode. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric private_browsing_caches_match(2294);

  /**
   * generated from use.counter.page.private_browsing_caches_open
   */
  /**
   * Whether a page calls caches.open in Private Browsing Mode. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric private_browsing_caches_open(2295);

  /**
   * generated from use.counter.page.private_browsing_idbfactory_delete_database
   */
  /**
   * Whether a page calls indexedDB.deleteDatabase in Private Browsing Mode. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric private_browsing_idbfactory_delete_database(2296);

  /**
   * generated from use.counter.page.private_browsing_idbfactory_open
   */
  /**
   * Whether a page calls indexedDB.open in Private Browsing Mode. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric private_browsing_idbfactory_open(2297);

  /**
   * generated from use.counter.page.private_browsing_navigator_service_worker
   */
  /**
   * Whether a page accesses navigator.serviceWorker in Private Browsing Mode.
     * Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric private_browsing_navigator_service_worker(2298);

  /**
   * generated from use.counter.page.pushmanager_subscribe
   */
  /**
   * Whether a page called called PushManager.subscribe. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric pushmanager_subscribe(2299);

  /**
   * generated from use.counter.page.pushsubscription_unsubscribe
   */
  /**
   * Whether a page called called PushSubscription.unsubscribe. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric pushsubscription_unsubscribe(2300);

  /**
   * generated from use.counter.page.range_createcontextualfragment
   */
  /**
   * Whether a page called called Range.createContextualFragment. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric range_createcontextualfragment(2301);

  /**
   * generated from use.counter.page.sanitizer_constructor
   */
  /**
   * Whether a page called called Sanitizer.constructor. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric sanitizer_constructor(2302);

  /**
   * generated from use.counter.page.sanitizer_sanitize
   */
  /**
   * Whether a page called called Sanitizer.sanitize. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric sanitizer_sanitize(2303);

  /**
   * generated from use.counter.page.scheduler_posttask
   */
  /**
   * Whether a page called called Scheduler.postTask. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric scheduler_posttask(2304);

  /**
   * generated from use.counter.page.shadowroot_pictureinpictureelement
   */
  /**
   * Whether a page called called ShadowRoot.pictureInPictureElement. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric shadowroot_pictureinpictureelement(2305);

  /**
   * generated from use.counter.page.svgsvgelement_currentscale_getter
   */
  /**
   * Whether a page got SVGSVGElement.currentScale. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric svgsvgelement_currentscale_getter(2306);

  /**
   * generated from use.counter.page.svgsvgelement_currentscale_setter
   */
  /**
   * Whether a page set SVGSVGElement.currentScale. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric svgsvgelement_currentscale_setter(2307);

  /**
   * generated from use.counter.page.svgsvgelement_getelementbyid
   */
  /**
   * Whether a page called called SVGSVGElement.getElementById. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric svgsvgelement_getelementbyid(2308);

  /**
   * generated from use.counter.page.window_absoluteorientationsensor
   */
  /**
   * Whether a page called called Window.AbsoluteOrientationSensor. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_absoluteorientationsensor(2309);

  /**
   * generated from use.counter.page.window_accelerometer
   */
  /**
   * Whether a page called called Window.Accelerometer. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_accelerometer(2310);

  /**
   * generated from use.counter.page.window_backgroundfetchmanager
   */
  /**
   * Whether a page called called Window.BackgroundFetchManager. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_backgroundfetchmanager(2311);

  /**
   * generated from use.counter.page.window_backgroundfetchrecord
   */
  /**
   * Whether a page called called Window.BackgroundFetchRecord. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_backgroundfetchrecord(2312);

  /**
   * generated from use.counter.page.window_backgroundfetchregistration
   */
  /**
   * Whether a page called called Window.BackgroundFetchRegistration. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric window_backgroundfetchregistration(2313);

  /**
   * generated from use.counter.page.window_beforeinstallpromptevent
   */
  /**
   * Whether a page called called Window.BeforeInstallPromptEvent. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_beforeinstallpromptevent(2314);

  /**
   * generated from use.counter.page.window_bluetooth
   */
  /**
   * Whether a page called called Window.Bluetooth. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_bluetooth(2315);

  /**
   * generated from use.counter.page.window_bluetoothcharacteristicproperties
   */
  /**
   * Whether a page called called Window.BluetoothCharacteristicProperties. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric window_bluetoothcharacteristicproperties(2316);

  /**
   * generated from use.counter.page.window_bluetoothdevice
   */
  /**
   * Whether a page called called Window.BluetoothDevice. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_bluetoothdevice(2317);

  /**
   * generated from use.counter.page.window_bluetoothremotegattcharacteristic
   */
  /**
   * Whether a page called called Window.BluetoothRemoteGATTCharacteristic. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric window_bluetoothremotegattcharacteristic(2318);

  /**
   * generated from use.counter.page.window_bluetoothremotegattdescriptor
   */
  /**
   * Whether a page called called Window.BluetoothRemoteGATTDescriptor. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric window_bluetoothremotegattdescriptor(2319);

  /**
   * generated from use.counter.page.window_bluetoothremotegattserver
   */
  /**
   * Whether a page called called Window.BluetoothRemoteGATTServer. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_bluetoothremotegattserver(2320);

  /**
   * generated from use.counter.page.window_bluetoothremotegattservice
   */
  /**
   * Whether a page called called Window.BluetoothRemoteGATTService. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_bluetoothremotegattservice(2321);

  /**
   * generated from use.counter.page.window_bluetoothuuid
   */
  /**
   * Whether a page called called Window.BluetoothUUID. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_bluetoothuuid(2322);

  /**
   * generated from use.counter.page.window_canvascapturemediastreamtrack
   */
  /**
   * Whether a page called called Window.CanvasCaptureMediaStreamTrack. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric window_canvascapturemediastreamtrack(2323);

  /**
   * generated from use.counter.page.window_chrome
   */
  /**
   * Whether a page called called Window.chrome. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_chrome(2324);

  /**
   * generated from use.counter.page.window_clipboarditem
   */
  /**
   * Whether a page called called Window.ClipboardItem. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_clipboarditem(2325);

  /**
   * generated from use.counter.page.window_cssimagevalue
   */
  /**
   * Whether a page called called Window.CSSImageValue. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_cssimagevalue(2326);

  /**
   * generated from use.counter.page.window_csskeywordvalue
   */
  /**
   * Whether a page called called Window.CSSKeywordValue. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_csskeywordvalue(2327);

  /**
   * generated from use.counter.page.window_cssmathclamp
   */
  /**
   * Whether a page called called Window.CSSMathClamp. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_cssmathclamp(2328);

  /**
   * generated from use.counter.page.window_cssmathinvert
   */
  /**
   * Whether a page called called Window.CSSMathInvert. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_cssmathinvert(2329);

  /**
   * generated from use.counter.page.window_cssmathmax
   */
  /**
   * Whether a page called called Window.CSSMathMax. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_cssmathmax(2330);

  /**
   * generated from use.counter.page.window_cssmathmin
   */
  /**
   * Whether a page called called Window.CSSMathMin. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_cssmathmin(2331);

  /**
   * generated from use.counter.page.window_cssmathnegate
   */
  /**
   * Whether a page called called Window.CSSMathNegate. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_cssmathnegate(2332);

  /**
   * generated from use.counter.page.window_cssmathproduct
   */
  /**
   * Whether a page called called Window.CSSMathProduct. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_cssmathproduct(2333);

  /**
   * generated from use.counter.page.window_cssmathsum
   */
  /**
   * Whether a page called called Window.CSSMathSum. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_cssmathsum(2334);

  /**
   * generated from use.counter.page.window_cssmathvalue
   */
  /**
   * Whether a page called called Window.CSSMathValue. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_cssmathvalue(2335);

  /**
   * generated from use.counter.page.window_cssmatrixcomponent
   */
  /**
   * Whether a page called called Window.CSSMatrixComponent. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_cssmatrixcomponent(2336);

  /**
   * generated from use.counter.page.window_cssnumericarray
   */
  /**
   * Whether a page called called Window.CSSNumericArray. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_cssnumericarray(2337);

  /**
   * generated from use.counter.page.window_cssnumericvalue
   */
  /**
   * Whether a page called called Window.CSSNumericValue. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_cssnumericvalue(2338);

  /**
   * generated from use.counter.page.window_cssperspective
   */
  /**
   * Whether a page called called Window.CSSPerspective. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_cssperspective(2339);

  /**
   * generated from use.counter.page.window_csspositionvalue
   */
  /**
   * Whether a page called called Window.CSSPositionValue. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_csspositionvalue(2340);

  /**
   * generated from use.counter.page.window_csspropertyrule
   */
  /**
   * Whether a page called called Window.CSSPropertyRule. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_csspropertyrule(2341);

  /**
   * generated from use.counter.page.window_cssrotate
   */
  /**
   * Whether a page called called Window.CSSRotate. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_cssrotate(2342);

  /**
   * generated from use.counter.page.window_cssscale
   */
  /**
   * Whether a page called called Window.CSSScale. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_cssscale(2343);

  /**
   * generated from use.counter.page.window_cssskew
   */
  /**
   * Whether a page called called Window.CSSSkew. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_cssskew(2344);

  /**
   * generated from use.counter.page.window_cssskewx
   */
  /**
   * Whether a page called called Window.CSSSkewX. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_cssskewx(2345);

  /**
   * generated from use.counter.page.window_cssskewy
   */
  /**
   * Whether a page called called Window.CSSSkewY. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_cssskewy(2346);

  /**
   * generated from use.counter.page.window_cssstylevalue
   */
  /**
   * Whether a page called called Window.CSSStyleValue. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_cssstylevalue(2347);

  /**
   * generated from use.counter.page.window_csstransformcomponent
   */
  /**
   * Whether a page called called Window.CSSTransformComponent. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_csstransformcomponent(2348);

  /**
   * generated from use.counter.page.window_csstransformvalue
   */
  /**
   * Whether a page called called Window.CSSTransformValue. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_csstransformvalue(2349);

  /**
   * generated from use.counter.page.window_csstranslate
   */
  /**
   * Whether a page called called Window.CSSTranslate. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_csstranslate(2350);

  /**
   * generated from use.counter.page.window_cssunitvalue
   */
  /**
   * Whether a page called called Window.CSSUnitValue. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_cssunitvalue(2351);

  /**
   * generated from use.counter.page.window_cssunparsedvalue
   */
  /**
   * Whether a page called called Window.CSSUnparsedValue. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_cssunparsedvalue(2352);

  /**
   * generated from use.counter.page.window_cssvariablereferencevalue
   */
  /**
   * Whether a page called called Window.CSSVariableReferenceValue. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_cssvariablereferencevalue(2353);

  /**
   * generated from use.counter.page.window_defaultstatus
   */
  /**
   * Whether a page called called Window.defaultStatus. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_defaultstatus(2354);

  /**
   * generated from use.counter.page.window_devicemotioneventacceleration
   */
  /**
   * Whether a page called called Window.DeviceMotionEventAcceleration. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric window_devicemotioneventacceleration(2355);

  /**
   * generated from use.counter.page.window_devicemotioneventrotationrate
   */
  /**
   * Whether a page called called Window.DeviceMotionEventRotationRate. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric window_devicemotioneventrotationrate(2356);

  /**
   * generated from use.counter.page.window_domerror
   */
  /**
   * Whether a page called called Window.DOMError. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_domerror(2357);

  /**
   * generated from use.counter.page.window_encodedvideochunk
   */
  /**
   * Whether a page called called Window.EncodedVideoChunk. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_encodedvideochunk(2358);

  /**
   * generated from use.counter.page.window_enterpictureinpictureevent
   */
  /**
   * Whether a page called called Window.EnterPictureInPictureEvent. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_enterpictureinpictureevent(2359);

  /**
   * generated from use.counter.page.window_external
   */
  /**
   * Whether a page called called Window.External. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_external(2360);

  /**
   * generated from use.counter.page.window_federatedcredential
   */
  /**
   * Whether a page called called Window.FederatedCredential. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_federatedcredential(2361);

  /**
   * generated from use.counter.page.window_gyroscope
   */
  /**
   * Whether a page called called Window.Gyroscope. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_gyroscope(2362);

  /**
   * generated from use.counter.page.window_htmlcontentelement
   */
  /**
   * Whether a page called called Window.HTMLContentElement. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_htmlcontentelement(2363);

  /**
   * generated from use.counter.page.window_htmlshadowelement
   */
  /**
   * Whether a page called called Window.HTMLShadowElement. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_htmlshadowelement(2364);

  /**
   * generated from use.counter.page.window_imagecapture
   */
  /**
   * Whether a page called called Window.ImageCapture. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_imagecapture(2365);

  /**
   * generated from use.counter.page.window_inputdevicecapabilities
   */
  /**
   * Whether a page called called Window.InputDeviceCapabilities. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_inputdevicecapabilities(2366);

  /**
   * generated from use.counter.page.window_inputdeviceinfo
   */
  /**
   * Whether a page called called Window.InputDeviceInfo. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_inputdeviceinfo(2367);

  /**
   * generated from use.counter.page.window_keyboard
   */
  /**
   * Whether a page called called Window.Keyboard. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_keyboard(2368);

  /**
   * generated from use.counter.page.window_keyboardlayoutmap
   */
  /**
   * Whether a page called called Window.KeyboardLayoutMap. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_keyboardlayoutmap(2369);

  /**
   * generated from use.counter.page.window_linearaccelerationsensor
   */
  /**
   * Whether a page called called Window.LinearAccelerationSensor. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_linearaccelerationsensor(2370);

  /**
   * generated from use.counter.page.window_mediasettingsrange
   */
  /**
   * Whether a page called called Window.MediaSettingsRange. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_mediasettingsrange(2371);

  /**
   * generated from use.counter.page.window_midiaccess
   */
  /**
   * Whether a page called called Window.MIDIAccess. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_midiaccess(2372);

  /**
   * generated from use.counter.page.window_midiconnectionevent
   */
  /**
   * Whether a page called called Window.MIDIConnectionEvent. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_midiconnectionevent(2373);

  /**
   * generated from use.counter.page.window_midiinput
   */
  /**
   * Whether a page called called Window.MIDIInput. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_midiinput(2374);

  /**
   * generated from use.counter.page.window_midiinputmap
   */
  /**
   * Whether a page called called Window.MIDIInputMap. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_midiinputmap(2375);

  /**
   * generated from use.counter.page.window_midimessageevent
   */
  /**
   * Whether a page called called Window.MIDIMessageEvent. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_midimessageevent(2376);

  /**
   * generated from use.counter.page.window_midioutput
   */
  /**
   * Whether a page called called Window.MIDIOutput. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_midioutput(2377);

  /**
   * generated from use.counter.page.window_midioutputmap
   */
  /**
   * Whether a page called called Window.MIDIOutputMap. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_midioutputmap(2378);

  /**
   * generated from use.counter.page.window_midiport
   */
  /**
   * Whether a page called called Window.MIDIPort. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_midiport(2379);

  /**
   * generated from use.counter.page.window_networkinformation
   */
  /**
   * Whether a page called called Window.NetworkInformation. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_networkinformation(2380);

  /**
   * generated from use.counter.page.window_offscreenbuffering
   */
  /**
   * Whether a page called called Window.offscreenBuffering. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_offscreenbuffering(2381);

  /**
   * generated from use.counter.page.window_onbeforeinstallprompt
   */
  /**
   * Whether a page called called Window.onbeforeinstallprompt. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_onbeforeinstallprompt(2382);

  /**
   * generated from use.counter.page.window_oncancel
   */
  /**
   * Whether a page called called Window.oncancel. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_oncancel(2383);

  /**
   * generated from use.counter.page.window_onmousewheel
   */
  /**
   * Whether a page called called Window.onmousewheel. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_onmousewheel(2384);

  /**
   * generated from use.counter.page.window_onorientationchange
   */
  /**
   * Whether a page called called Window.onorientationchange. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_onorientationchange(2385);

  /**
   * generated from use.counter.page.window_onsearch
   */
  /**
   * Whether a page called called Window.onsearch. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_onsearch(2386);

  /**
   * generated from use.counter.page.window_onselectionchange
   */
  /**
   * Whether a page called called Window.onselectionchange. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_onselectionchange(2387);

  /**
   * generated from use.counter.page.window_open_empty_url
   */
  /**
   * Whether a page calls window.open with an empty url argument. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_open_empty_url(2388);

  /**
   * generated from use.counter.page.window_opendatabase
   */
  /**
   * Whether a page called called Window.openDatabase. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_opendatabase(2389);

  /**
   * generated from use.counter.page.window_orientation
   */
  /**
   * Whether a page called called Window.orientation. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_orientation(2390);

  /**
   * generated from use.counter.page.window_orientationsensor
   */
  /**
   * Whether a page called called Window.OrientationSensor. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_orientationsensor(2391);

  /**
   * generated from use.counter.page.window_overconstrainederror
   */
  /**
   * Whether a page called called Window.OverconstrainedError. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_overconstrainederror(2392);

  /**
   * generated from use.counter.page.window_passwordcredential
   */
  /**
   * Whether a page called called Window.PasswordCredential. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_passwordcredential(2393);

  /**
   * generated from use.counter.page.window_paymentaddress
   */
  /**
   * Whether a page called called Window.PaymentAddress. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_paymentaddress(2394);

  /**
   * generated from use.counter.page.window_paymentinstruments
   */
  /**
   * Whether a page called called Window.PaymentInstruments. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_paymentinstruments(2395);

  /**
   * generated from use.counter.page.window_paymentmanager
   */
  /**
   * Whether a page called called Window.PaymentManager. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_paymentmanager(2396);

  /**
   * generated from use.counter.page.window_paymentmethodchangeevent
   */
  /**
   * Whether a page called called Window.PaymentMethodChangeEvent. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_paymentmethodchangeevent(2397);

  /**
   * generated from use.counter.page.window_paymentrequest
   */
  /**
   * Whether a page called called Window.PaymentRequest. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_paymentrequest(2398);

  /**
   * generated from use.counter.page.window_paymentrequestupdateevent
   */
  /**
   * Whether a page called called Window.PaymentRequestUpdateEvent. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_paymentrequestupdateevent(2399);

  /**
   * generated from use.counter.page.window_paymentresponse
   */
  /**
   * Whether a page called called Window.PaymentResponse. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_paymentresponse(2400);

  /**
   * generated from use.counter.page.window_performancelongtasktiming
   */
  /**
   * Whether a page called called Window.PerformanceLongTaskTiming. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_performancelongtasktiming(2401);

  /**
   * generated from use.counter.page.window_photocapabilities
   */
  /**
   * Whether a page called called Window.PhotoCapabilities. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_photocapabilities(2402);

  /**
   * generated from use.counter.page.window_pictureinpictureevent
   */
  /**
   * Whether a page called called Window.PictureInPictureEvent. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_pictureinpictureevent(2403);

  /**
   * generated from use.counter.page.window_pictureinpicturewindow
   */
  /**
   * Whether a page called called Window.PictureInPictureWindow. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_pictureinpicturewindow(2404);

  /**
   * generated from use.counter.page.window_presentation
   */
  /**
   * Whether a page called called Window.Presentation. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_presentation(2405);

  /**
   * generated from use.counter.page.window_presentationavailability
   */
  /**
   * Whether a page called called Window.PresentationAvailability. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_presentationavailability(2406);

  /**
   * generated from use.counter.page.window_presentationconnection
   */
  /**
   * Whether a page called called Window.PresentationConnection. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_presentationconnection(2407);

  /**
   * generated from use.counter.page.window_presentationconnectionavailableevent
   */
  /**
   * Whether a page called called Window.PresentationConnectionAvailableEvent.
     * Compare against `use.counter.top_level_content_documents_destroyed` to
     * calculate the rate.
   */
  constexpr impl::CounterMetric window_presentationconnectionavailableevent(2408);

  /**
   * generated from use.counter.page.window_presentationconnectioncloseevent
   */
  /**
   * Whether a page called called Window.PresentationConnectionCloseEvent. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric window_presentationconnectioncloseevent(2409);

  /**
   * generated from use.counter.page.window_presentationconnectionlist
   */
  /**
   * Whether a page called called Window.PresentationConnectionList. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_presentationconnectionlist(2410);

  /**
   * generated from use.counter.page.window_presentationreceiver
   */
  /**
   * Whether a page called called Window.PresentationReceiver. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_presentationreceiver(2411);

  /**
   * generated from use.counter.page.window_presentationrequest
   */
  /**
   * Whether a page called called Window.PresentationRequest. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_presentationrequest(2412);

  /**
   * generated from use.counter.page.window_relativeorientationsensor
   */
  /**
   * Whether a page called called Window.RelativeOrientationSensor. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_relativeorientationsensor(2413);

  /**
   * generated from use.counter.page.window_remoteplayback
   */
  /**
   * Whether a page called called Window.RemotePlayback. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_remoteplayback(2414);

  /**
   * generated from use.counter.page.window_report
   */
  /**
   * Whether a page called called Window.Report. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_report(2415);

  /**
   * generated from use.counter.page.window_reportbody
   */
  /**
   * Whether a page called called Window.ReportBody. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_reportbody(2416);

  /**
   * generated from use.counter.page.window_reportingobserver
   */
  /**
   * Whether a page called called Window.ReportingObserver. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_reportingobserver(2417);

  /**
   * generated from use.counter.page.window_rtcerror
   */
  /**
   * Whether a page called called Window.RTCError. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_rtcerror(2418);

  /**
   * generated from use.counter.page.window_rtcerrorevent
   */
  /**
   * Whether a page called called Window.RTCErrorEvent. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_rtcerrorevent(2419);

  /**
   * generated from use.counter.page.window_rtcicetransport
   */
  /**
   * Whether a page called called Window.RTCIceTransport. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_rtcicetransport(2420);

  /**
   * generated from use.counter.page.window_rtcpeerconnectioniceerrorevent
   */
  /**
   * Whether a page called called Window.RTCPeerConnectionIceErrorEvent. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric window_rtcpeerconnectioniceerrorevent(2421);

  /**
   * generated from use.counter.page.window_sensor
   */
  /**
   * Whether a page called called Window.Sensor. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_sensor(2422);

  /**
   * generated from use.counter.page.window_sensorerrorevent
   */
  /**
   * Whether a page called called Window.SensorErrorEvent. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_sensorerrorevent(2423);

  /**
   * generated from use.counter.page.window_sidebar_getter
   */
  /**
   * Whether a page got Window.sidebar. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_sidebar_getter(2424);

  /**
   * generated from use.counter.page.window_sidebar_setter
   */
  /**
   * Whether a page set Window.sidebar. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_sidebar_setter(2425);

  /**
   * generated from use.counter.page.window_speechrecognitionalternative
   */
  /**
   * Whether a page called called Window.SpeechRecognitionAlternative. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric window_speechrecognitionalternative(2426);

  /**
   * generated from use.counter.page.window_speechrecognitionresult
   */
  /**
   * Whether a page called called Window.SpeechRecognitionResult. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_speechrecognitionresult(2427);

  /**
   * generated from use.counter.page.window_speechrecognitionresultlist
   */
  /**
   * Whether a page called called Window.SpeechRecognitionResultList. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric window_speechrecognitionresultlist(2428);

  /**
   * generated from use.counter.page.window_stylemedia
   */
  /**
   * Whether a page called called Window.styleMedia. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_stylemedia(2429);

  /**
   * generated from use.counter.page.window_stylepropertymap
   */
  /**
   * Whether a page called called Window.StylePropertyMap. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_stylepropertymap(2430);

  /**
   * generated from use.counter.page.window_stylepropertymapreadonly
   */
  /**
   * Whether a page called called Window.StylePropertyMapReadOnly. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_stylepropertymapreadonly(2431);

  /**
   * generated from use.counter.page.window_svgdiscardelement
   */
  /**
   * Whether a page called called Window.SVGDiscardElement. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_svgdiscardelement(2432);

  /**
   * generated from use.counter.page.window_syncmanager
   */
  /**
   * Whether a page called called Window.SyncManager. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_syncmanager(2433);

  /**
   * generated from use.counter.page.window_taskattributiontiming
   */
  /**
   * Whether a page called called Window.TaskAttributionTiming. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_taskattributiontiming(2434);

  /**
   * generated from use.counter.page.window_textevent
   */
  /**
   * Whether a page called called Window.TextEvent. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_textevent(2435);

  /**
   * generated from use.counter.page.window_touch
   */
  /**
   * Whether a page called called Window.Touch. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_touch(2436);

  /**
   * generated from use.counter.page.window_touchevent
   */
  /**
   * Whether a page called called Window.TouchEvent. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_touchevent(2437);

  /**
   * generated from use.counter.page.window_touchlist
   */
  /**
   * Whether a page called called Window.TouchList. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_touchlist(2438);

  /**
   * generated from use.counter.page.window_usb
   */
  /**
   * Whether a page called called Window.USB. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_usb(2439);

  /**
   * generated from use.counter.page.window_usbalternateinterface
   */
  /**
   * Whether a page called called Window.USBAlternateInterface. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_usbalternateinterface(2440);

  /**
   * generated from use.counter.page.window_usbconfiguration
   */
  /**
   * Whether a page called called Window.USBConfiguration. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_usbconfiguration(2441);

  /**
   * generated from use.counter.page.window_usbconnectionevent
   */
  /**
   * Whether a page called called Window.USBConnectionEvent. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_usbconnectionevent(2442);

  /**
   * generated from use.counter.page.window_usbdevice
   */
  /**
   * Whether a page called called Window.USBDevice. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_usbdevice(2443);

  /**
   * generated from use.counter.page.window_usbendpoint
   */
  /**
   * Whether a page called called Window.USBEndpoint. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_usbendpoint(2444);

  /**
   * generated from use.counter.page.window_usbinterface
   */
  /**
   * Whether a page called called Window.USBInterface. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_usbinterface(2445);

  /**
   * generated from use.counter.page.window_usbintransferresult
   */
  /**
   * Whether a page called called Window.USBInTransferResult. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_usbintransferresult(2446);

  /**
   * generated from use.counter.page.window_usbisochronousintransferpacket
   */
  /**
   * Whether a page called called Window.USBIsochronousInTransferPacket. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric window_usbisochronousintransferpacket(2447);

  /**
   * generated from use.counter.page.window_usbisochronousintransferresult
   */
  /**
   * Whether a page called called Window.USBIsochronousInTransferResult. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric window_usbisochronousintransferresult(2448);

  /**
   * generated from use.counter.page.window_usbisochronousouttransferpacket
   */
  /**
   * Whether a page called called Window.USBIsochronousOutTransferPacket. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric window_usbisochronousouttransferpacket(2449);

  /**
   * generated from use.counter.page.window_usbisochronousouttransferresult
   */
  /**
   * Whether a page called called Window.USBIsochronousOutTransferResult. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric window_usbisochronousouttransferresult(2450);

  /**
   * generated from use.counter.page.window_usbouttransferresult
   */
  /**
   * Whether a page called called Window.USBOutTransferResult. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_usbouttransferresult(2451);

  /**
   * generated from use.counter.page.window_useractivation
   */
  /**
   * Whether a page called called Window.UserActivation. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_useractivation(2452);

  /**
   * generated from use.counter.page.window_videocolorspace
   */
  /**
   * Whether a page called called Window.VideoColorSpace. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_videocolorspace(2453);

  /**
   * generated from use.counter.page.window_videodecoder
   */
  /**
   * Whether a page called called Window.VideoDecoder. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_videodecoder(2454);

  /**
   * generated from use.counter.page.window_videoencoder
   */
  /**
   * Whether a page called called Window.VideoEncoder. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_videoencoder(2455);

  /**
   * generated from use.counter.page.window_videoframe
   */
  /**
   * Whether a page called called Window.VideoFrame. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_videoframe(2456);

  /**
   * generated from use.counter.page.window_wakelock
   */
  /**
   * Whether a page called called Window.WakeLock. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_wakelock(2457);

  /**
   * generated from use.counter.page.window_wakelocksentinel
   */
  /**
   * Whether a page called called Window.WakeLockSentinel. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_wakelocksentinel(2458);

  /**
   * generated from use.counter.page.window_webkitcancelanimationframe
   */
  /**
   * Whether a page called called Window.webkitCancelAnimationFrame. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_webkitcancelanimationframe(2459);

  /**
   * generated from use.counter.page.window_webkitmediastream
   */
  /**
   * Whether a page called called Window.webkitMediaStream. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_webkitmediastream(2460);

  /**
   * generated from use.counter.page.window_webkitmutationobserver
   */
  /**
   * Whether a page called called Window.WebKitMutationObserver. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_webkitmutationobserver(2461);

  /**
   * generated from use.counter.page.window_webkitrequestanimationframe
   */
  /**
   * Whether a page called called Window.webkitRequestAnimationFrame. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric window_webkitrequestanimationframe(2462);

  /**
   * generated from use.counter.page.window_webkitrequestfilesystem
   */
  /**
   * Whether a page called called Window.webkitRequestFileSystem. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_webkitrequestfilesystem(2463);

  /**
   * generated from use.counter.page.window_webkitresolvelocalfilesystemurl
   */
  /**
   * Whether a page called called Window.webkitResolveLocalFileSystemURL. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric window_webkitresolvelocalfilesystemurl(2464);

  /**
   * generated from use.counter.page.window_webkitrtcpeerconnection
   */
  /**
   * Whether a page called called Window.webkitRTCPeerConnection. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_webkitrtcpeerconnection(2465);

  /**
   * generated from use.counter.page.window_webkitspeechgrammar
   */
  /**
   * Whether a page called called Window.webkitSpeechGrammar. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_webkitspeechgrammar(2466);

  /**
   * generated from use.counter.page.window_webkitspeechgrammarlist
   */
  /**
   * Whether a page called called Window.webkitSpeechGrammarList. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_webkitspeechgrammarlist(2467);

  /**
   * generated from use.counter.page.window_webkitspeechrecognition
   */
  /**
   * Whether a page called called Window.webkitSpeechRecognition. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_webkitspeechrecognition(2468);

  /**
   * generated from use.counter.page.window_webkitspeechrecognitionerror
   */
  /**
   * Whether a page called called Window.webkitSpeechRecognitionError. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric window_webkitspeechrecognitionerror(2469);

  /**
   * generated from use.counter.page.window_webkitspeechrecognitionevent
   */
  /**
   * Whether a page called called Window.webkitSpeechRecognitionEvent. Compare
     * against `use.counter.top_level_content_documents_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric window_webkitspeechrecognitionevent(2470);

  /**
   * generated from use.counter.page.window_webkitstorageinfo
   */
  /**
   * Whether a page called called Window.webkitStorageInfo. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric window_webkitstorageinfo(2471);

  /**
   * generated from use.counter.page.workernavigator_permissions
   */
  /**
   * Whether a page called called WorkerNavigator.permissions. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric workernavigator_permissions(2472);

  /**
   * generated from use.counter.page.wr_filter_fallback
   */
  /**
   * Whether a page triggers the blob fallback for an SVG filter.. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric wr_filter_fallback(2473);

  /**
   * generated from use.counter.page.xslstylesheet
   */
  /**
   * Whether a page uses an XSL Stylesheet. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric xslstylesheet(2474);

  /**
   * generated from use.counter.page.xsltprocessor_constructor
   */
  /**
   * Whether a page called called XSLTProcessor.constructor. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric xsltprocessor_constructor(2475);

  /**
   * generated from use.counter.page.you_tube_flash_embed
   */
  /**
   * Whether a page in <object> or <embed>. Compare against
     * `use.counter.top_level_content_documents_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric you_tube_flash_embed(2476);

}
namespace use_counter_worker_dedicated {
  /**
   * generated from use.counter.worker.dedicated.console_assert
   */
  /**
   * Whether a dedicated worker called called console.assert. Compare against
     * `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_assert(2477);

  /**
   * generated from use.counter.worker.dedicated.console_clear
   */
  /**
   * Whether a dedicated worker called called console.clear. Compare against
     * `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_clear(2478);

  /**
   * generated from use.counter.worker.dedicated.console_count
   */
  /**
   * Whether a dedicated worker called called console.count. Compare against
     * `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_count(2479);

  /**
   * generated from use.counter.worker.dedicated.console_countreset
   */
  /**
   * Whether a dedicated worker called called console.countReset. Compare against
     * `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_countreset(2480);

  /**
   * generated from use.counter.worker.dedicated.console_debug
   */
  /**
   * Whether a dedicated worker called called console.debug. Compare against
     * `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_debug(2481);

  /**
   * generated from use.counter.worker.dedicated.console_dir
   */
  /**
   * Whether a dedicated worker called called console.dir. Compare against
     * `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_dir(2482);

  /**
   * generated from use.counter.worker.dedicated.console_dirxml
   */
  /**
   * Whether a dedicated worker called called console.dirxml. Compare against
     * `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_dirxml(2483);

  /**
   * generated from use.counter.worker.dedicated.console_error
   */
  /**
   * Whether a dedicated worker called called console.error. Compare against
     * `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_error(2484);

  /**
   * generated from use.counter.worker.dedicated.console_exception
   */
  /**
   * Whether a dedicated worker called called console.exception. Compare against
     * `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_exception(2485);

  /**
   * generated from use.counter.worker.dedicated.console_group
   */
  /**
   * Whether a dedicated worker called called console.group. Compare against
     * `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_group(2486);

  /**
   * generated from use.counter.worker.dedicated.console_groupcollapsed
   */
  /**
   * Whether a dedicated worker called called console.groupCollapsed. Compare
     * against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_groupcollapsed(2487);

  /**
   * generated from use.counter.worker.dedicated.console_groupend
   */
  /**
   * Whether a dedicated worker called called console.groupEnd. Compare against
     * `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_groupend(2488);

  /**
   * generated from use.counter.worker.dedicated.console_info
   */
  /**
   * Whether a dedicated worker called called console.info. Compare against
     * `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_info(2489);

  /**
   * generated from use.counter.worker.dedicated.console_log
   */
  /**
   * Whether a dedicated worker called called console.log. Compare against
     * `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_log(2490);

  /**
   * generated from use.counter.worker.dedicated.console_profile
   */
  /**
   * Whether a dedicated worker called called console.profile. Compare against
     * `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_profile(2491);

  /**
   * generated from use.counter.worker.dedicated.console_profileend
   */
  /**
   * Whether a dedicated worker called called console.profileEnd. Compare against
     * `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_profileend(2492);

  /**
   * generated from use.counter.worker.dedicated.console_table
   */
  /**
   * Whether a dedicated worker called called console.table. Compare against
     * `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_table(2493);

  /**
   * generated from use.counter.worker.dedicated.console_time
   */
  /**
   * Whether a dedicated worker called called console.time. Compare against
     * `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_time(2494);

  /**
   * generated from use.counter.worker.dedicated.console_timeend
   */
  /**
   * Whether a dedicated worker called called console.timeEnd. Compare against
     * `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_timeend(2495);

  /**
   * generated from use.counter.worker.dedicated.console_timelog
   */
  /**
   * Whether a dedicated worker called called console.timeLog. Compare against
     * `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_timelog(2496);

  /**
   * generated from use.counter.worker.dedicated.console_timestamp
   */
  /**
   * Whether a dedicated worker called called console.timeStamp. Compare against
     * `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_timestamp(2497);

  /**
   * generated from use.counter.worker.dedicated.console_trace
   */
  /**
   * Whether a dedicated worker called called console.trace. Compare against
     * `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_trace(2498);

  /**
   * generated from use.counter.worker.dedicated.console_warn
   */
  /**
   * Whether a dedicated worker called called console.warn. Compare against
     * `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_warn(2499);

  /**
   * generated from use.counter.worker.dedicated.private_browsing_caches_delete
   */
  /**
   * Whether a dedicated worker calls caches.delete in Private Browsing Mode.
     * Compare against `use.counter.dedicated_workers_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric private_browsing_caches_delete(2500);

  /**
   * generated from use.counter.worker.dedicated.private_browsing_caches_has
   */
  /**
   * Whether a dedicated worker calls caches.has in Private Browsing Mode. Compare
     * against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric private_browsing_caches_has(2501);

  /**
   * generated from use.counter.worker.dedicated.private_browsing_caches_keys
   */
  /**
   * Whether a dedicated worker calls caches.keys in Private Browsing Mode. Compare
     * against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric private_browsing_caches_keys(2502);

  /**
   * generated from use.counter.worker.dedicated.private_browsing_caches_match
   */
  /**
   * Whether a dedicated worker calls caches.match in Private Browsing Mode. Compare
     * against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric private_browsing_caches_match(2503);

  /**
   * generated from use.counter.worker.dedicated.private_browsing_caches_open
   */
  /**
   * Whether a dedicated worker calls caches.open in Private Browsing Mode. Compare
     * against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric private_browsing_caches_open(2504);

  /**
   * generated from use.counter.worker.dedicated.private_browsing_idbfactory_delete_database
   */
  /**
   * Whether a dedicated worker calls indexedDB.deleteDatabase in Private Browsing
     * Mode. Compare against `use.counter.dedicated_workers_destroyed` to calculate
     * the rate.
   */
  constexpr impl::CounterMetric private_browsing_idbfactory_delete_database(2505);

  /**
   * generated from use.counter.worker.dedicated.private_browsing_idbfactory_open
   */
  /**
   * Whether a dedicated worker calls indexedDB.open in Private Browsing Mode.
     * Compare against `use.counter.dedicated_workers_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric private_browsing_idbfactory_open(2506);

  /**
   * generated from use.counter.worker.dedicated.pushmanager_subscribe
   */
  /**
   * Whether a dedicated worker called called PushManager.subscribe. Compare against
     * `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric pushmanager_subscribe(2507);

  /**
   * generated from use.counter.worker.dedicated.pushsubscription_unsubscribe
   */
  /**
   * Whether a dedicated worker called called PushSubscription.unsubscribe. Compare
     * against `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric pushsubscription_unsubscribe(2508);

  /**
   * generated from use.counter.worker.dedicated.scheduler_posttask
   */
  /**
   * Whether a dedicated worker called called Scheduler.postTask. Compare against
     * `use.counter.dedicated_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric scheduler_posttask(2509);

}
namespace use_counter_worker_service {
  /**
   * generated from use.counter.worker.service.console_assert
   */
  /**
   * Whether a service worker called called console.assert. Compare against
     * `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_assert(2510);

  /**
   * generated from use.counter.worker.service.console_clear
   */
  /**
   * Whether a service worker called called console.clear. Compare against
     * `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_clear(2511);

  /**
   * generated from use.counter.worker.service.console_count
   */
  /**
   * Whether a service worker called called console.count. Compare against
     * `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_count(2512);

  /**
   * generated from use.counter.worker.service.console_countreset
   */
  /**
   * Whether a service worker called called console.countReset. Compare against
     * `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_countreset(2513);

  /**
   * generated from use.counter.worker.service.console_debug
   */
  /**
   * Whether a service worker called called console.debug. Compare against
     * `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_debug(2514);

  /**
   * generated from use.counter.worker.service.console_dir
   */
  /**
   * Whether a service worker called called console.dir. Compare against
     * `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_dir(2515);

  /**
   * generated from use.counter.worker.service.console_dirxml
   */
  /**
   * Whether a service worker called called console.dirxml. Compare against
     * `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_dirxml(2516);

  /**
   * generated from use.counter.worker.service.console_error
   */
  /**
   * Whether a service worker called called console.error. Compare against
     * `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_error(2517);

  /**
   * generated from use.counter.worker.service.console_exception
   */
  /**
   * Whether a service worker called called console.exception. Compare against
     * `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_exception(2518);

  /**
   * generated from use.counter.worker.service.console_group
   */
  /**
   * Whether a service worker called called console.group. Compare against
     * `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_group(2519);

  /**
   * generated from use.counter.worker.service.console_groupcollapsed
   */
  /**
   * Whether a service worker called called console.groupCollapsed. Compare against
     * `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_groupcollapsed(2520);

  /**
   * generated from use.counter.worker.service.console_groupend
   */
  /**
   * Whether a service worker called called console.groupEnd. Compare against
     * `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_groupend(2521);

  /**
   * generated from use.counter.worker.service.console_info
   */
  /**
   * Whether a service worker called called console.info. Compare against
     * `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_info(2522);

  /**
   * generated from use.counter.worker.service.console_log
   */
  /**
   * Whether a service worker called called console.log. Compare against
     * `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_log(2523);

  /**
   * generated from use.counter.worker.service.console_profile
   */
  /**
   * Whether a service worker called called console.profile. Compare against
     * `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_profile(2524);

  /**
   * generated from use.counter.worker.service.console_profileend
   */
  /**
   * Whether a service worker called called console.profileEnd. Compare against
     * `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_profileend(2525);

  /**
   * generated from use.counter.worker.service.console_table
   */
  /**
   * Whether a service worker called called console.table. Compare against
     * `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_table(2526);

  /**
   * generated from use.counter.worker.service.console_time
   */
  /**
   * Whether a service worker called called console.time. Compare against
     * `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_time(2527);

  /**
   * generated from use.counter.worker.service.console_timeend
   */
  /**
   * Whether a service worker called called console.timeEnd. Compare against
     * `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_timeend(2528);

  /**
   * generated from use.counter.worker.service.console_timelog
   */
  /**
   * Whether a service worker called called console.timeLog. Compare against
     * `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_timelog(2529);

  /**
   * generated from use.counter.worker.service.console_timestamp
   */
  /**
   * Whether a service worker called called console.timeStamp. Compare against
     * `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_timestamp(2530);

  /**
   * generated from use.counter.worker.service.console_trace
   */
  /**
   * Whether a service worker called called console.trace. Compare against
     * `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_trace(2531);

  /**
   * generated from use.counter.worker.service.console_warn
   */
  /**
   * Whether a service worker called called console.warn. Compare against
     * `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_warn(2532);

  /**
   * generated from use.counter.worker.service.private_browsing_caches_delete
   */
  /**
   * Whether a service worker calls caches.delete in Private Browsing Mode. Compare
     * against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric private_browsing_caches_delete(2533);

  /**
   * generated from use.counter.worker.service.private_browsing_caches_has
   */
  /**
   * Whether a service worker calls caches.has in Private Browsing Mode. Compare
     * against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric private_browsing_caches_has(2534);

  /**
   * generated from use.counter.worker.service.private_browsing_caches_keys
   */
  /**
   * Whether a service worker calls caches.keys in Private Browsing Mode. Compare
     * against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric private_browsing_caches_keys(2535);

  /**
   * generated from use.counter.worker.service.private_browsing_caches_match
   */
  /**
   * Whether a service worker calls caches.match in Private Browsing Mode. Compare
     * against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric private_browsing_caches_match(2536);

  /**
   * generated from use.counter.worker.service.private_browsing_caches_open
   */
  /**
   * Whether a service worker calls caches.open in Private Browsing Mode. Compare
     * against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric private_browsing_caches_open(2537);

  /**
   * generated from use.counter.worker.service.private_browsing_idbfactory_delete_database
   */
  /**
   * Whether a service worker calls indexedDB.deleteDatabase in Private Browsing
     * Mode. Compare against `use.counter.service_workers_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric private_browsing_idbfactory_delete_database(2538);

  /**
   * generated from use.counter.worker.service.private_browsing_idbfactory_open
   */
  /**
   * Whether a service worker calls indexedDB.open in Private Browsing Mode. Compare
     * against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric private_browsing_idbfactory_open(2539);

  /**
   * generated from use.counter.worker.service.pushmanager_subscribe
   */
  /**
   * Whether a service worker called called PushManager.subscribe. Compare against
     * `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric pushmanager_subscribe(2540);

  /**
   * generated from use.counter.worker.service.pushsubscription_unsubscribe
   */
  /**
   * Whether a service worker called called PushSubscription.unsubscribe. Compare
     * against `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric pushsubscription_unsubscribe(2541);

  /**
   * generated from use.counter.worker.service.scheduler_posttask
   */
  /**
   * Whether a service worker called called Scheduler.postTask. Compare against
     * `use.counter.service_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric scheduler_posttask(2542);

}
namespace use_counter_worker_shared {
  /**
   * generated from use.counter.worker.shared.console_assert
   */
  /**
   * Whether a shared worker called called console.assert. Compare against
     * `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_assert(2543);

  /**
   * generated from use.counter.worker.shared.console_clear
   */
  /**
   * Whether a shared worker called called console.clear. Compare against
     * `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_clear(2544);

  /**
   * generated from use.counter.worker.shared.console_count
   */
  /**
   * Whether a shared worker called called console.count. Compare against
     * `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_count(2545);

  /**
   * generated from use.counter.worker.shared.console_countreset
   */
  /**
   * Whether a shared worker called called console.countReset. Compare against
     * `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_countreset(2546);

  /**
   * generated from use.counter.worker.shared.console_debug
   */
  /**
   * Whether a shared worker called called console.debug. Compare against
     * `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_debug(2547);

  /**
   * generated from use.counter.worker.shared.console_dir
   */
  /**
   * Whether a shared worker called called console.dir. Compare against
     * `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_dir(2548);

  /**
   * generated from use.counter.worker.shared.console_dirxml
   */
  /**
   * Whether a shared worker called called console.dirxml. Compare against
     * `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_dirxml(2549);

  /**
   * generated from use.counter.worker.shared.console_error
   */
  /**
   * Whether a shared worker called called console.error. Compare against
     * `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_error(2550);

  /**
   * generated from use.counter.worker.shared.console_exception
   */
  /**
   * Whether a shared worker called called console.exception. Compare against
     * `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_exception(2551);

  /**
   * generated from use.counter.worker.shared.console_group
   */
  /**
   * Whether a shared worker called called console.group. Compare against
     * `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_group(2552);

  /**
   * generated from use.counter.worker.shared.console_groupcollapsed
   */
  /**
   * Whether a shared worker called called console.groupCollapsed. Compare against
     * `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_groupcollapsed(2553);

  /**
   * generated from use.counter.worker.shared.console_groupend
   */
  /**
   * Whether a shared worker called called console.groupEnd. Compare against
     * `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_groupend(2554);

  /**
   * generated from use.counter.worker.shared.console_info
   */
  /**
   * Whether a shared worker called called console.info. Compare against
     * `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_info(2555);

  /**
   * generated from use.counter.worker.shared.console_log
   */
  /**
   * Whether a shared worker called called console.log. Compare against
     * `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_log(2556);

  /**
   * generated from use.counter.worker.shared.console_profile
   */
  /**
   * Whether a shared worker called called console.profile. Compare against
     * `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_profile(2557);

  /**
   * generated from use.counter.worker.shared.console_profileend
   */
  /**
   * Whether a shared worker called called console.profileEnd. Compare against
     * `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_profileend(2558);

  /**
   * generated from use.counter.worker.shared.console_table
   */
  /**
   * Whether a shared worker called called console.table. Compare against
     * `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_table(2559);

  /**
   * generated from use.counter.worker.shared.console_time
   */
  /**
   * Whether a shared worker called called console.time. Compare against
     * `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_time(2560);

  /**
   * generated from use.counter.worker.shared.console_timeend
   */
  /**
   * Whether a shared worker called called console.timeEnd. Compare against
     * `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_timeend(2561);

  /**
   * generated from use.counter.worker.shared.console_timelog
   */
  /**
   * Whether a shared worker called called console.timeLog. Compare against
     * `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_timelog(2562);

  /**
   * generated from use.counter.worker.shared.console_timestamp
   */
  /**
   * Whether a shared worker called called console.timeStamp. Compare against
     * `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_timestamp(2563);

  /**
   * generated from use.counter.worker.shared.console_trace
   */
  /**
   * Whether a shared worker called called console.trace. Compare against
     * `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_trace(2564);

  /**
   * generated from use.counter.worker.shared.console_warn
   */
  /**
   * Whether a shared worker called called console.warn. Compare against
     * `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric console_warn(2565);

  /**
   * generated from use.counter.worker.shared.private_browsing_caches_delete
   */
  /**
   * Whether a shared worker calls caches.delete in Private Browsing Mode. Compare
     * against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric private_browsing_caches_delete(2566);

  /**
   * generated from use.counter.worker.shared.private_browsing_caches_has
   */
  /**
   * Whether a shared worker calls caches.has in Private Browsing Mode. Compare
     * against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric private_browsing_caches_has(2567);

  /**
   * generated from use.counter.worker.shared.private_browsing_caches_keys
   */
  /**
   * Whether a shared worker calls caches.keys in Private Browsing Mode. Compare
     * against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric private_browsing_caches_keys(2568);

  /**
   * generated from use.counter.worker.shared.private_browsing_caches_match
   */
  /**
   * Whether a shared worker calls caches.match in Private Browsing Mode. Compare
     * against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric private_browsing_caches_match(2569);

  /**
   * generated from use.counter.worker.shared.private_browsing_caches_open
   */
  /**
   * Whether a shared worker calls caches.open in Private Browsing Mode. Compare
     * against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric private_browsing_caches_open(2570);

  /**
   * generated from use.counter.worker.shared.private_browsing_idbfactory_delete_database
   */
  /**
   * Whether a shared worker calls indexedDB.deleteDatabase in Private Browsing
     * Mode. Compare against `use.counter.shared_workers_destroyed` to calculate the
     * rate.
   */
  constexpr impl::CounterMetric private_browsing_idbfactory_delete_database(2571);

  /**
   * generated from use.counter.worker.shared.private_browsing_idbfactory_open
   */
  /**
   * Whether a shared worker calls indexedDB.open in Private Browsing Mode. Compare
     * against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric private_browsing_idbfactory_open(2572);

  /**
   * generated from use.counter.worker.shared.pushmanager_subscribe
   */
  /**
   * Whether a shared worker called called PushManager.subscribe. Compare against
     * `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric pushmanager_subscribe(2573);

  /**
   * generated from use.counter.worker.shared.pushsubscription_unsubscribe
   */
  /**
   * Whether a shared worker called called PushSubscription.unsubscribe. Compare
     * against `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric pushsubscription_unsubscribe(2574);

  /**
   * generated from use.counter.worker.shared.scheduler_posttask
   */
  /**
   * Whether a shared worker called called Scheduler.postTask. Compare against
     * `use.counter.shared_workers_destroyed` to calculate the rate.
   */
  constexpr impl::CounterMetric scheduler_posttask(2575);

}
namespace geolocation {
  /**
   * generated from geolocation.accuracy
   */
  /**
   * Accuracy returned by the Geolocation API
   */
  constexpr impl::CustomDistributionMetric accuracy(2576);

  /**
   * generated from geolocation.fallback
   */
  enum class FallbackLabel: uint16_t {
      eNone = 0,
      eOnError = 1,
      eOnTimeout = 2,
      e__Other__,
    };
  /**
   * Whether the default provider falled back to NetworkGeolocationProvider.
   */
  constexpr impl::Labeled<impl::CounterMetric, FallbackLabel> fallback(2577);

  /**
   * generated from geolocation.linux_provider
   */
  enum class LinuxProviderLabel: uint16_t {
      eNone = 0,
      ePortal = 1,
      eGeoclue = 2,
      eGpsd = 3,
      e__Other__,
    };
  /**
   * Which system provider are we using on Linux
   */
  constexpr impl::Labeled<impl::BooleanMetric, LinuxProviderLabel> linux_provider(2578);

  /**
   * generated from geolocation.request_result
   */
  enum class RequestResultLabel: uint16_t {
      eSuccess = 0,
      ePermissionDenied = 1,
      ePositionUnavailable = 2,
      eTimeout = 3,
      e__Other__,
    };
  /**
   * The result for each geolocation request. Success label will only happen once
     * for each request, even if it's a watch request.
   */
  constexpr impl::Labeled<impl::CounterMetric, RequestResultLabel> request_result(2579);

}
namespace mediadrm {
  /**
   * generated from mediadrm.eme_playback
   */
    struct EmePlaybackExtra {
      mozilla::Maybe<nsCString> keySystem;
      mozilla::Maybe<uint32_t> playedTime;
      mozilla::Maybe<nsCString> resolution;
      mozilla::Maybe<nsCString> videoCodec;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (keySystem) {
          extraKeys.AppendElement()->AssignASCII("key_system");
          extraValues.EmplaceBack(keySystem.value());
        }
        if (playedTime) {
          extraKeys.AppendElement()->AssignASCII("played_time");
          extraValues.EmplaceBack(nsPrintfCString("%d", playedTime.value()));
        }
        if (resolution) {
          extraKeys.AppendElement()->AssignASCII("resolution");
          extraValues.EmplaceBack(resolution.value());
        }
        if (videoCodec) {
          extraKeys.AppendElement()->AssignASCII("video_codec");
          extraValues.EmplaceBack(videoCodec.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Record the EME play time with the video codec and resolutions.
   */
  constexpr impl::EventMetric<EmePlaybackExtra> eme_playback(2580);

}
namespace hls {
  /**
   * generated from hls.canplay_requested
   */
  /**
   * Record when a page requests canPlayType for a HLS media type.
   */
  constexpr impl::CounterMetric canplay_requested(2581);

  /**
   * generated from hls.canplay_supported
   */
  /**
   * Record when a canPlayType request supports HLS.
   */
  constexpr impl::CounterMetric canplay_supported(2582);

  /**
   * generated from hls.media_load
   */
    struct MediaLoadExtra {
      mozilla::Maybe<nsCString> mediaExtension;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (mediaExtension) {
          extraKeys.AppendElement()->AssignASCII("media_extension");
          extraValues.EmplaceBack(mediaExtension.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Record the information about the HLS playback on Android using ExoPlayer. The
     * value of this event contains the media format.
   */
  constexpr impl::EventMetric<MediaLoadExtra> media_load(2583);

}
namespace gmp {
  /**
   * generated from gmp.update_xml_fetch_result
   */
  enum class UpdateXmlFetchResultLabel: uint16_t {
      eCertPinSuccess = 0,
      eCertPinNetRequestError = 1,
      eCertPinNetTimeout = 2,
      eCertPinAbort = 3,
      eCertPinMissingData = 4,
      eCertPinFailed = 5,
      eCertPinInvalid = 6,
      eCertPinXmlParseError = 7,
      eCertPinUnknownError = 8,
      eContentSigSuccess = 9,
      eContentSigNetRequestError = 10,
      eContentSigNetTimeout = 11,
      eContentSigAbort = 12,
      eContentSigMissingData = 13,
      eContentSigFailed = 14,
      eContentSigInvalid = 15,
      eContentSigXmlParseError = 16,
      eContentSigUnknownError = 17,
      e__Other__,
    };
  /**
   * The result of Gecko fetching an update.xml from Balrog. This captures 3
     * different data points: success or failure of the request, if cert pinning or
     * content signatures were used to verify the result, and the reason for failure,
     * if the request failed.
   */
  constexpr impl::Labeled<impl::CounterMetric, UpdateXmlFetchResultLabel> update_xml_fetch_result(2584);

}
namespace media_audio {
  /**
   * generated from media.audio.backend
   */
  enum class BackendLabel: uint16_t {
      eUnknown = 0,
      eAudiounit = 1,
      eAudiounitRust = 2,
      eAaudio = 3,
      eOpensl = 4,
      eWasapi = 5,
      eWinmm = 6,
      eAlsa = 7,
      eJack = 8,
      eOss = 9,
      ePulse = 10,
      ePulseRust = 11,
      eSndio = 12,
      eSunaudio = 13,
      e__Other__,
    };
  /**
   * The operating system audio backend (Migrated from the geckoview metric of the
     * same name).
   */
  constexpr impl::Labeled<impl::CounterMetric, BackendLabel> backend(2585);

  /**
   * generated from media.audio.init_failure
   */
  enum class InitFailureLabel: uint16_t {
      eFirst = 0,
      eOther = 1,
      e__Other__,
    };
  /**
   * Failure occurs when initializing the audio stream. (Migrated from the geckoview
     * metric of the same name).
   */
  constexpr impl::Labeled<impl::CounterMetric, InitFailureLabel> init_failure(2586);

}
namespace media_playback {
  /**
   * generated from media.playback.device_hardware_decoder_support
   */
  enum class DeviceHardwareDecoderSupportLabel: uint16_t {
      eH264 = 0,
      eVp8 = 1,
      eVp9 = 2,
      eAv1 = 3,
      eHevc = 4,
      e__Other__,
    };
  /**
   * The results of hardware decoder support for different video codecs. True means
     * that codec can be decoded by hardware on user's device.
   */
  constexpr impl::Labeled<impl::BooleanMetric, DeviceHardwareDecoderSupportLabel> device_hardware_decoder_support(2587);

  /**
   * generated from media.playback.first_frame_loaded
   */
    struct FirstFrameLoadedExtra {
      mozilla::Maybe<uint32_t> bufferingTime;
      mozilla::Maybe<uint32_t> firstFrameLoadedTime;
      mozilla::Maybe<bool> hlsDecoder;
      mozilla::Maybe<bool> isHardwareDecoding;
      mozilla::Maybe<nsCString> keySystem;
      mozilla::Maybe<uint32_t> metadataLoadedTime;
      mozilla::Maybe<nsCString> playbackType;
      mozilla::Maybe<nsCString> resolution;
      mozilla::Maybe<uint32_t> totalWaitingDataTime;
      mozilla::Maybe<nsCString> videoCodec;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (bufferingTime) {
          extraKeys.AppendElement()->AssignASCII("buffering_time");
          extraValues.EmplaceBack(nsPrintfCString("%d", bufferingTime.value()));
        }
        if (firstFrameLoadedTime) {
          extraKeys.AppendElement()->AssignASCII("first_frame_loaded_time");
          extraValues.EmplaceBack(nsPrintfCString("%d", firstFrameLoadedTime.value()));
        }
        if (hlsDecoder) {
          extraKeys.AppendElement()->AssignASCII("hls_decoder");
          extraValues.AppendElement()->AssignASCII(hlsDecoder.value() ? "true" : "false");
        }
        if (isHardwareDecoding) {
          extraKeys.AppendElement()->AssignASCII("is_hardware_decoding");
          extraValues.AppendElement()->AssignASCII(isHardwareDecoding.value() ? "true" : "false");
        }
        if (keySystem) {
          extraKeys.AppendElement()->AssignASCII("key_system");
          extraValues.EmplaceBack(keySystem.value());
        }
        if (metadataLoadedTime) {
          extraKeys.AppendElement()->AssignASCII("metadata_loaded_time");
          extraValues.EmplaceBack(nsPrintfCString("%d", metadataLoadedTime.value()));
        }
        if (playbackType) {
          extraKeys.AppendElement()->AssignASCII("playback_type");
          extraValues.EmplaceBack(playbackType.value());
        }
        if (resolution) {
          extraKeys.AppendElement()->AssignASCII("resolution");
          extraValues.EmplaceBack(resolution.value());
        }
        if (totalWaitingDataTime) {
          extraKeys.AppendElement()->AssignASCII("total_waiting_data_time");
          extraValues.EmplaceBack(nsPrintfCString("%d", totalWaitingDataTime.value()));
        }
        if (videoCodec) {
          extraKeys.AppendElement()->AssignASCII("video_codec");
          extraValues.EmplaceBack(videoCodec.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * The time that the media pipeline takes to load the first video frame.
   */
  constexpr impl::EventMetric<FirstFrameLoadedExtra> first_frame_loaded(2588);

  /**
   * generated from media.playback.not_supported_video_per_mime_type
   */
  /**
   * Count the amount of times where video playback is failed to start due to the
     * mime type is not supported by Firefox. The result is accumulated per mime type,
     * eg. video/hevc.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> not_supported_video_per_mime_type(2589);

}
namespace mfcdm {
  /**
   * generated from mfcdm.eme_playback
   */
    struct EmePlaybackExtra {
      mozilla::Maybe<uint32_t> droppedFrames;
      mozilla::Maybe<nsCString> keySystem;
      mozilla::Maybe<uint32_t> playedTime;
      mozilla::Maybe<uint32_t> renderedFrames;
      mozilla::Maybe<nsCString> resolution;
      mozilla::Maybe<nsCString> videoCodec;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (droppedFrames) {
          extraKeys.AppendElement()->AssignASCII("dropped_frames");
          extraValues.EmplaceBack(nsPrintfCString("%d", droppedFrames.value()));
        }
        if (keySystem) {
          extraKeys.AppendElement()->AssignASCII("key_system");
          extraValues.EmplaceBack(keySystem.value());
        }
        if (playedTime) {
          extraKeys.AppendElement()->AssignASCII("played_time");
          extraValues.EmplaceBack(nsPrintfCString("%d", playedTime.value()));
        }
        if (renderedFrames) {
          extraKeys.AppendElement()->AssignASCII("rendered_frames");
          extraValues.EmplaceBack(nsPrintfCString("%d", renderedFrames.value()));
        }
        if (resolution) {
          extraKeys.AppendElement()->AssignASCII("resolution");
          extraValues.EmplaceBack(resolution.value());
        }
        if (videoCodec) {
          extraKeys.AppendElement()->AssignASCII("video_codec");
          extraValues.EmplaceBack(videoCodec.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Record the information about the EME playback when using the media engine. The
     * value of this event is the key system name.
   */
  constexpr impl::EventMetric<EmePlaybackExtra> eme_playback(2590);

  /**
   * generated from mfcdm.error
   */
    struct ErrorExtra {
      mozilla::Maybe<nsCString> audioCodec;
      mozilla::Maybe<nsCString> currentState;
      mozilla::Maybe<nsCString> errorName;
      mozilla::Maybe<nsCString> keySystem;
      mozilla::Maybe<nsCString> resolution;
      mozilla::Maybe<nsCString> videoCodec;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (audioCodec) {
          extraKeys.AppendElement()->AssignASCII("audio_codec");
          extraValues.EmplaceBack(audioCodec.value());
        }
        if (currentState) {
          extraKeys.AppendElement()->AssignASCII("current_state");
          extraValues.EmplaceBack(currentState.value());
        }
        if (errorName) {
          extraKeys.AppendElement()->AssignASCII("error_name");
          extraValues.EmplaceBack(errorName.value());
        }
        if (keySystem) {
          extraKeys.AppendElement()->AssignASCII("key_system");
          extraValues.EmplaceBack(keySystem.value());
        }
        if (resolution) {
          extraKeys.AppendElement()->AssignASCII("resolution");
          extraValues.EmplaceBack(resolution.value());
        }
        if (videoCodec) {
          extraKeys.AppendElement()->AssignASCII("video_codec");
          extraValues.EmplaceBack(videoCodec.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Record the error or crash happened while using the media engine playback. The
     * value of this event is the name of error. This probe covers both EME and non-
     * EME playback.
   */
  constexpr impl::EventMetric<ErrorExtra> error(2591);

}
namespace codec_stats {
  /**
   * generated from codec.stats.audio_preferred_codec
   */
  /**
   * Counts the preferred audio codec being signaled to us to identify preferred
     * audio codec.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> audio_preferred_codec(2592);

  /**
   * generated from codec.stats.other_fec_signaled
   */
  /**
   * Count how many other fec options are being offered.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> other_fec_signaled(2593);

  /**
   * generated from codec.stats.ulpfec_negotiated
   */
  enum class UlpfecNegotiatedLabel: uint16_t {
      eNegotiated = 0,
      eNotNegotiated = 1,
      e__Other__,
    };
  /**
   * Counts the number of times that ulpfec is negotiated or not negotiated on the
     * first negotiation for each video transceiver.
   */
  constexpr impl::Labeled<impl::CounterMetric, UlpfecNegotiatedLabel> ulpfec_negotiated(2594);

  /**
   * generated from codec.stats.video_preferred_codec
   */
  /**
   * Counts the preferred video codec being signaled to us to identify preferred
     * video codec.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> video_preferred_codec(2595);

}
namespace rtcrtpsender {
  /**
   * generated from rtcrtpsender.count
   */
  /**
   * The number of RTCRtpSenders created.
   */
  constexpr impl::DenominatorMetric count(2596);

  /**
   * generated from rtcrtpsender.count_setparameters_compat
   */
  /**
   * The number of RTCRtpSenders created that use the compatibility mode for
     * setParameters.
   */
  constexpr impl::DenominatorMetric count_setparameters_compat(2597);

  /**
   * generated from rtcrtpsender.used_sendencodings
   */
  /**
   * The proportion of RTCRtpSenders that were created by an addTransceivers call
     * that was passed a sendEncodings.
   */
  constexpr impl::NumeratorMetric used_sendencodings(2598);

}
namespace rtcrtpsender_setparameters {
  /**
   * generated from rtcrtpsender.setparameters.blame_length_changed
   */
  /**
   * The number of RTCRtpSenders that have warned at least once about a
     * `setParameters` call that attempted to change the number of encodings, broken
     * down by the eTLD+1 of the site. Collected only on EARLY_BETA_OR_EARLIER.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> blame_length_changed(2599);

  /**
   * generated from rtcrtpsender.setparameters.blame_no_getparameters
   */
  /**
   * The number of RTCRtpSenders that have warned at least once about a
     * `setParameters` call because `[[LastReturnedParameters]]` was not set, broken
     * down by the eTLD+1 of the site. (ie; there was not a recent enough call to
     * `getParameters`) Collected only on EARLY_BETA_OR_EARLIER.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> blame_no_getparameters(2600);

  /**
   * generated from rtcrtpsender.setparameters.blame_no_transactionid
   */
  /**
   * The number of RTCRtpSenders that have warned at least once about a
     * `setParameters` call that did not set the transactionId field, broken down by
     * the eTLD+1 of the site. Collected only on EARLY_BETA_OR_EARLIER.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> blame_no_transactionid(2601);

  /**
   * generated from rtcrtpsender.setparameters.fail_length_changed
   */
  /**
   * The proportion of RTCRtpSenders that have thrown an error at least once about a
     * setParameters call that attempted to change the number of encodings.
   */
  constexpr impl::NumeratorMetric fail_length_changed(2602);

  /**
   * generated from rtcrtpsender.setparameters.fail_no_encodings
   */
  /**
   * The proportion of RTCRtpSenders configured with the setParameters compat mode
     * that have thrown an error at least once about a setParameters call that had no
     * encodings (we do not measure this against the general population of
     * RTCRtpSenders, since without the compat mode this failure is never observed,
     * because it fails the length change check).
   */
  constexpr impl::NumeratorMetric fail_no_encodings(2603);

  /**
   * generated from rtcrtpsender.setparameters.fail_no_getparameters
   */
  /**
   * The proportion of RTCRtpSenders that have thrown an error at least once about a
     * setParameters call because [[LastReturnedParameters]] was not set. (ie; there
     * was not a recent enough call to getParameters)
   */
  constexpr impl::NumeratorMetric fail_no_getparameters(2604);

  /**
   * generated from rtcrtpsender.setparameters.fail_no_transactionid
   */
  /**
   * The proportion of RTCRtpSenders that have thrown an error at least once about a
     * setParameters call that did not set the transactionId field.
   */
  constexpr impl::NumeratorMetric fail_no_transactionid(2605);

  /**
   * generated from rtcrtpsender.setparameters.fail_other
   */
  /**
   * The proportion of RTCRtpSenders that have thrown an error at least once about a
     * setParameters call that had no encodings.
   */
  constexpr impl::NumeratorMetric fail_other(2606);

  /**
   * generated from rtcrtpsender.setparameters.fail_rid_changed
   */
  /**
   * The proportion of RTCRtpSenders that have thrown an error at least once about a
     * setParameters call that attempted to change the rid on an encoding (note that
     * we only check this if the encoding count did not change, see
     * fail_length_changed).
   */
  constexpr impl::NumeratorMetric fail_rid_changed(2607);

  /**
   * generated from rtcrtpsender.setparameters.fail_stale_transactionid
   */
  /**
   * The proportion of RTCRtpSenders that have thrown an error at least once about a
     * setParameters call that used a stale transaction id.
   */
  constexpr impl::NumeratorMetric fail_stale_transactionid(2608);

  /**
   * generated from rtcrtpsender.setparameters.warn_length_changed
   */
  /**
   * The proportion of RTCRtpSenders configured with the setParameters compat mode
     * that have warned at least once about a setParameters call that attempted to
     * change the number of encodings.
   */
  constexpr impl::NumeratorMetric warn_length_changed(2609);

  /**
   * generated from rtcrtpsender.setparameters.warn_no_getparameters
   */
  /**
   * The proportion of RTCRtpSenders configured with the setParameters compat mode
     * that have warned at least once about a setParameters call because
     * [[LastReturnedParameters]] was not set.  (ie; there was not a recent enough
     * call to getParameters)
   */
  constexpr impl::NumeratorMetric warn_no_getparameters(2610);

  /**
   * generated from rtcrtpsender.setparameters.warn_no_transactionid
   */
  /**
   * The proportion of RTCRtpSenders configured with the setParameters compat mode
     * that have warned at least once about a setParameters call that did not set the
     * transactionId field.
   */
  constexpr impl::NumeratorMetric warn_no_transactionid(2611);

}
namespace webrtcdtls {
  /**
   * generated from webrtcdtls.cipher
   */
  /**
   * The CipherSuite used for each webrtc DTLS connection, as a string
     * representation of the CipherSuite's ID in 4 hex digits (eg;
     * TLS_DHE_RSA_WITH_AES_128_CBC_SHA would be "0x0033")
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> cipher(2612);

  /**
   * generated from webrtcdtls.client_handshake_result
   */
  /**
   * The result of each webrtc client DTLS handshake as a string containing either
     * the name of the error code (eg; SSL_ERROR_BAD_CERTIFICATE), SUCCESS for
     * successful handshakes, ALPN_FAILURE when ALPN negotiation fails, or
     * CERT_FAILURE when cert validation fails.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> client_handshake_result(2613);

  /**
   * generated from webrtcdtls.protocol_version
   */
  /**
   * The version of DTLS used for each webrtc connection. Can be 1.0, 1.2, or 1.3
     * (there is no 1.1 version of DTLS)
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> protocol_version(2614);

  /**
   * generated from webrtcdtls.server_handshake_result
   */
  /**
   * The result of each webrtc server DTLS handshake, as the name of the error code
     * (eg; SSL_ERROR_BAD_CERTIFICATE), the empty string for successful handshakes,
     * ALPN_FAILURE when ALPN negotiation fails, or CERT_FAILURE when cert validation
     * fails.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> server_handshake_result(2615);

  /**
   * generated from webrtcdtls.srtp_cipher
   */
  /**
   * The SRTPProtectionProfile (see RFC 5764) used for each webrtc SRTP connection,
     * as a string representation of the SRTPProtectionProfile's ID in 4 hex digits
     * (eg; SRTP_AES128_CM_HMAC_SHA1_80 would be "0x0001")
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> srtp_cipher(2616);

}
namespace javascript_pageload {
  /**
   * generated from javascript.pageload.baseline_compile_time
   */
  /**
   * Time spent during page load baseline compiling Javascript in ms. (Migrated from
     * the geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric baseline_compile_time(2617);

  /**
   * generated from javascript.pageload.delazification_time
   */
  /**
   * Time spent during page load delazifying Javascript in ms. (Migrated from the
     * geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric delazification_time(2618);

  /**
   * generated from javascript.pageload.execution_time
   */
  /**
   * Time spent during page load executing Javascript in ms. (Migrated from the
     * geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric execution_time(2619);

  /**
   * generated from javascript.pageload.gc_time
   */
  /**
   * Time spent during page load in the GC in ms. (Migrated from the geckoview
     * metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric gc_time(2620);

  /**
   * generated from javascript.pageload.parse_time
   */
  /**
   * Time spent during page load syntax parsing JS scripts on the main thread in ms.
     * (Migrated from the geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric parse_time(2621);

  /**
   * generated from javascript.pageload.protect_time
   */
  /**
   * Time spent during page load protecting JIT executable memory. (Migrated from
     * the geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric protect_time(2622);

  /**
   * generated from javascript.pageload.xdr_encode_time
   */
  /**
   * Time spent during page load XDR encoding Javascript in ms. (Migrated from the
     * geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric xdr_encode_time(2623);

}
namespace perf {
  /**
   * generated from perf.largest_contentful_paint
   */
  /**
   * Time from navigation start to largest contentful paint.
   */
  constexpr impl::TimingDistributionMetric largest_contentful_paint(2624);

  /**
   * generated from perf.largest_contentful_paint_from_response_start
   */
  /**
   * Time from response start to largest contentful paint.
   */
  constexpr impl::TimingDistributionMetric largest_contentful_paint_from_response_start(2625);

  /**
   * generated from perf.page_load
   */
    struct PageLoadExtra {
      mozilla::Maybe<uint32_t> dnsLookupTime;
      mozilla::Maybe<uint32_t> fcpTime;
      mozilla::Maybe<uint32_t> httpVer;
      mozilla::Maybe<uint32_t> jsExecTime;
      mozilla::Maybe<uint32_t> lcpTime;
      mozilla::Maybe<uint32_t> loadTime;
      mozilla::Maybe<nsCString> loadType;
      mozilla::Maybe<uint32_t> redirectCount;
      mozilla::Maybe<uint32_t> redirectTime;
      mozilla::Maybe<uint32_t> responseTime;
      mozilla::Maybe<bool> sameOriginNav;
      mozilla::Maybe<nsCString> trrDomain;
      mozilla::Maybe<bool> usingWebdriver;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (dnsLookupTime) {
          extraKeys.AppendElement()->AssignASCII("dns_lookup_time");
          extraValues.EmplaceBack(nsPrintfCString("%d", dnsLookupTime.value()));
        }
        if (fcpTime) {
          extraKeys.AppendElement()->AssignASCII("fcp_time");
          extraValues.EmplaceBack(nsPrintfCString("%d", fcpTime.value()));
        }
        if (httpVer) {
          extraKeys.AppendElement()->AssignASCII("http_ver");
          extraValues.EmplaceBack(nsPrintfCString("%d", httpVer.value()));
        }
        if (jsExecTime) {
          extraKeys.AppendElement()->AssignASCII("js_exec_time");
          extraValues.EmplaceBack(nsPrintfCString("%d", jsExecTime.value()));
        }
        if (lcpTime) {
          extraKeys.AppendElement()->AssignASCII("lcp_time");
          extraValues.EmplaceBack(nsPrintfCString("%d", lcpTime.value()));
        }
        if (loadTime) {
          extraKeys.AppendElement()->AssignASCII("load_time");
          extraValues.EmplaceBack(nsPrintfCString("%d", loadTime.value()));
        }
        if (loadType) {
          extraKeys.AppendElement()->AssignASCII("load_type");
          extraValues.EmplaceBack(loadType.value());
        }
        if (redirectCount) {
          extraKeys.AppendElement()->AssignASCII("redirect_count");
          extraValues.EmplaceBack(nsPrintfCString("%d", redirectCount.value()));
        }
        if (redirectTime) {
          extraKeys.AppendElement()->AssignASCII("redirect_time");
          extraValues.EmplaceBack(nsPrintfCString("%d", redirectTime.value()));
        }
        if (responseTime) {
          extraKeys.AppendElement()->AssignASCII("response_time");
          extraValues.EmplaceBack(nsPrintfCString("%d", responseTime.value()));
        }
        if (sameOriginNav) {
          extraKeys.AppendElement()->AssignASCII("same_origin_nav");
          extraValues.AppendElement()->AssignASCII(sameOriginNav.value() ? "true" : "false");
        }
        if (trrDomain) {
          extraKeys.AppendElement()->AssignASCII("trr_domain");
          extraValues.EmplaceBack(trrDomain.value());
        }
        if (usingWebdriver) {
          extraKeys.AppendElement()->AssignASCII("using_webdriver");
          extraValues.AppendElement()->AssignASCII(usingWebdriver.value() ? "true" : "false");
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when a top level content document has been loaded.
   */
  constexpr impl::EventMetric<PageLoadExtra> page_load(2626);

}
namespace performance_pageload {
  /**
   * generated from performance.pageload.fcp
   */
  /**
   * The time between navigationStart and the first contentful paint of a foreground
     * http or https root content document, in milliseconds. The contentful paint
     * timestamp is taken during display list building and does not include
     * rasterization or compositing of that paint. (Migrated from the geckoview metric
     * of the same name).
   */
  constexpr impl::TimingDistributionMetric fcp(2627);

  /**
   * generated from performance.pageload.fcp_responsestart
   */
  /**
   * The time between responseStart and the first contentful paint of a foreground
     * http or https root content document, in milliseconds. The contentful paint
     * timestamp is taken during display list building and does not include
     * rasterization or compositing of that paint. (Migrated from the geckoview metric
     * of the same name).
   */
  constexpr impl::TimingDistributionMetric fcp_responsestart(2628);

  /**
   * generated from performance.pageload.load_time
   */
  /**
   * Time in milliseconds from navigationStart to loadEventStart for the foreground
     * http or https root content document. (Migrated from the geckoview metric of the
     * same name).
   */
  constexpr impl::TimingDistributionMetric load_time(2629);

  /**
   * generated from performance.pageload.load_time_responsestart
   */
  /**
   * Time in milliseconds from responseStart to loadEventStart for the foreground
     * http or https root content document. (Migrated from the geckoview metric of the
     * same name).
   */
  constexpr impl::TimingDistributionMetric load_time_responsestart(2630);

  /**
   * generated from performance.pageload.async_sheet_load
   */
  /**
   * Time spent in milliseconds since a style sheet started loading async until it
     * finished.
   */
  constexpr impl::TimingDistributionMetric async_sheet_load(2631);

  /**
   * generated from performance.pageload.req_anim_frame_callback
   */
  /**
   * Time spent in milliseconds calling all request animation frame callbacks for a
     * document before it has reached readystate complete. (Migrated from the
     * geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric req_anim_frame_callback(2632);

}
namespace performance_time {
  /**
   * generated from performance.time.dom_complete
   */
  /**
   * Time from navigationStart to domComplete as per the W3C Performance Timing API.
     * (Migrated from the geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric dom_complete(2633);

  /**
   * generated from performance.time.dom_content_loaded_end
   */
  /**
   * Time from navigationStart to domContentLoadedEventEnd as per the W3C
     * Performance Timing API. (Migrated from the geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric dom_content_loaded_end(2634);

  /**
   * generated from performance.time.dom_content_loaded_start
   */
  /**
   * Time from navigationStart to domContentLoadedEventStart as per the W3C
     * Performance Timing API. (Migrated from the geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric dom_content_loaded_start(2635);

  /**
   * generated from performance.time.dom_interactive
   */
  /**
   * Time from navigationStart to domInteractive as per the W3C Performance Timing
     * API. (Migrated from the geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric dom_interactive(2636);

  /**
   * generated from performance.time.load_event_end
   */
  /**
   * Time from navigationStart to loadEventEnd as per the W3C Performance Timing
     * API. (Migrated from the geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric load_event_end(2637);

  /**
   * generated from performance.time.load_event_start
   */
  /**
   * Time from navigationStart to loadEventStart as per the W3C Performance Timing
     * API. (Migrated from the geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric load_event_start(2638);

  /**
   * generated from performance.time.response_start
   */
  /**
   * Time from navigationStart to responseStart as per the W3C Performance Timing
     * API. (Migrated from the geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric response_start(2639);

}
namespace private_attribution {
  /**
   * generated from private_attribution.database
   */
  enum class DatabaseLabel: uint16_t {
      eReset = 0,
      e__Other__,
    };
  /**
   * The metrics for the attribution data stores
   */
  constexpr impl::Labeled<impl::CounterMetric, DatabaseLabel> database(2640);

  /**
   * generated from private_attribution.measure_conversion
   */
  enum class MeasureConversionLabel: uint16_t {
      eSuccess = 0,
      eError = 1,
      eLastView = 2,
      eLastClick = 3,
      eLastImpression = 4,
      e__Other__,
    };
  /**
   * The count of outcomes for the measureConversion API
   */
  constexpr impl::Labeled<impl::CounterMetric, MeasureConversionLabel> measure_conversion(2641);

  /**
   * generated from private_attribution.save_impression
   */
  enum class SaveImpressionLabel: uint16_t {
      eSuccess = 0,
      eError = 1,
      eLastView = 2,
      eLastClick = 3,
      eLastImpression = 4,
      e__Other__,
    };
  /**
   * The count of outcomes for the saveImpression API
   */
  constexpr impl::Labeled<impl::CounterMetric, SaveImpressionLabel> save_impression(2642);

}
namespace web_push {
  /**
   * generated from web_push.detected_duplicated_message_ids
   */
  /**
   * Counts the duplicated IDs from the server. The ability to detect depends on the
     * pref `dom.push.maxRecentMessageIDsPerSubscription`.
   */
  constexpr impl::CounterMetric detected_duplicated_message_ids(2643);

  /**
   * generated from web_push.error_code
   */
  enum class ErrorCodeLabel: uint16_t {
      eDecryptionError = 0,
      eNotDelivered = 1,
      eUncaughtException = 2,
      eUnhandledRejection = 3,
      eInternalError = 4,
      e__Other__,
    };
  /**
   * The code indicating why the push message couldn't be processed.
   */
  constexpr impl::Labeled<impl::CounterMetric, ErrorCodeLabel> error_code(2644);

}
namespace httpsfirst {
  /**
   * generated from httpsfirst.downgrade_time
   */
  /**
   * If a HTTPS-First (`dom.security.https_first` enabled) upgrade isn't successful,
     * measures the timespan between the navigation start and the downgrade.
   */
  constexpr impl::TimingDistributionMetric downgrade_time(2645);

  /**
   * generated from httpsfirst.downgrade_time_schemeless
   */
  /**
   * If a schemeless HTTPS-First (`dom.security.https_first` disabled, but load
     * marked as schemeless) upgrade isn't successful, measures the timespan between
     * the navigation start and the downgrade.
   */
  constexpr impl::TimingDistributionMetric downgrade_time_schemeless(2646);

  /**
   * generated from httpsfirst.downgraded
   */
  /**
   * How many regular HTTPS-First (`dom.security.https_first` enabled) upgrades fail
     * and get downgraded again.
   */
  constexpr impl::DenominatorMetric downgraded(2647);

  /**
   * generated from httpsfirst.downgraded_on_timer
   */
  /**
   * How many HTTPS-First (`dom.security.https_first` enabled) upgrades get
     * downgraded again because the HTTP request fired after 3s received a answer
     * faster than the HTTPS request.
   */
  constexpr impl::NumeratorMetric downgraded_on_timer(2648);

  /**
   * generated from httpsfirst.downgraded_on_timer_schemeless
   */
  /**
   * How many of schemeless HTTPS-First (`dom.security.https_first` disabled, but
     * load marked as schemeless) upgrades get downgraded again because the HTTP
     * request fired after 3s received a answer faster than the HTTPS request
   */
  constexpr impl::NumeratorMetric downgraded_on_timer_schemeless(2649);

  /**
   * generated from httpsfirst.downgraded_schemeless
   */
  /**
   * How many schemeless HTTPS-First (`dom.security.https_first` disabled, but load
     * marked as schemeless) upgrades fail and get downgraded again.
   */
  constexpr impl::DenominatorMetric downgraded_schemeless(2650);

  /**
   * generated from httpsfirst.upgraded
   */
  /**
   * Counts how often a load is successfully upgraded to HTTPS because of HTTPS-
     * First (`dom.security.https_first` enabled). This does not include loads that
     * get downgraded again.
   */
  constexpr impl::CounterMetric upgraded(2651);

  /**
   * generated from httpsfirst.upgraded_schemeless
   */
  /**
   * Counts how often a load is successfully upgraded to HTTPS because of schemeless
     * HTTPS-First (`dom.security.https_first` disabled, but load marked as
     * schemeless). This does not include loads that get downgraded again.
   */
  constexpr impl::CounterMetric upgraded_schemeless(2652);

}
namespace webauthn_create {
  /**
   * generated from webauthn_create.authenticator_attachment
   */
  enum class AuthenticatorAttachmentLabel: uint16_t {
      eCrossPlatform = 0,
      ePlatform = 1,
      eUnknown = 2,
      e__Other__,
    };
  /**
   * The number of successfully created credentials by authenticator attachment
     * modality.
   */
  constexpr impl::Labeled<impl::CounterMetric, AuthenticatorAttachmentLabel> authenticator_attachment(2653);

  /**
   * generated from webauthn_create.failure
   */
  /**
   * The total number of failed calls to navigator.credentials.create.
   */
  constexpr impl::CounterMetric failure(2654);

  /**
   * generated from webauthn_create.passkey
   */
  /**
   * The number of client-side discoverable credentials (passkeys) created.
   */
  constexpr impl::CounterMetric passkey(2655);

  /**
   * generated from webauthn_create.success
   */
  /**
   * The total number of successful calls to navigator.credentials.create.
   */
  constexpr impl::CounterMetric success(2656);

}
namespace webauthn_get {
  /**
   * generated from webauthn_get.authenticator_attachment
   */
  enum class AuthenticatorAttachmentLabel: uint16_t {
      eCrossPlatform = 0,
      ePlatform = 1,
      eUnknown = 2,
      e__Other__,
    };
  /**
   * The number of successfully asserted credentials by authenticator attachment
     * modality.
   */
  constexpr impl::Labeled<impl::CounterMetric, AuthenticatorAttachmentLabel> authenticator_attachment(2657);

  /**
   * generated from webauthn_get.failure
   */
  /**
   * The total number of failed calls to navigator.credentials.get.
   */
  constexpr impl::CounterMetric failure(2658);

  /**
   * generated from webauthn_get.success
   */
  /**
   * The total number of successful calls to navigator.credentials.get.
   */
  constexpr impl::CounterMetric success(2659);

}
namespace gfx {
  /**
   * generated from gfx.composite_time
   */
  /**
   * The time taken to composite a frame. On non-webrender this is the time taken in
     * `CompositorBridgeParent::CompositeToTarget()`. On webrender, this is the time
     * taken from the start of `WebRenderBridgeParent::CompositeToTarget()`, until the
     * render thread has rendered the frame (in `RenderThread::HandleFrameOneDoc()`).
     * (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::TimingDistributionMetric composite_time(2660);

  /**
   * generated from gfx.scroll_present_latency
   */
  /**
   * Time between receiving a scroll event on the event loop and compositing its
     * result onto the screen (ms). (Migrated from the geckoview metric of the same
     * name).
   */
  constexpr impl::TimingDistributionMetric scroll_present_latency(2661);

}
namespace gfx_adapter_primary {
  /**
   * generated from gfx.adapter.primary.description
   */
  /**
   * Long form description of the Graphics adapter (Migrated from the geckoview
     * metric of the same name).
   */
  constexpr impl::StringMetric description(2662);

  /**
   * generated from gfx.adapter.primary.device_id
   */
  /**
   * Graphics adapter device identification (Migrated from the geckoview metric of
     * the same name).
   */
  constexpr impl::StringMetric device_id(2663);

  /**
   * generated from gfx.adapter.primary.driver_date
   */
  /**
   * Graphics adapter driver date (Migrated from the geckoview metric of the same
     * name).
   */
  constexpr impl::StringMetric driver_date(2664);

  /**
   * generated from gfx.adapter.primary.driver_files
   */
  /**
   * List of graphics adapter driver files (Migrated from the geckoview metric of
     * the same name).
   */
  constexpr impl::StringMetric driver_files(2665);

  /**
   * generated from gfx.adapter.primary.driver_vendor
   */
  /**
   * Graphics adapter driver vendor identification (Migrated from the geckoview
     * metric of the same name).
   */
  constexpr impl::StringMetric driver_vendor(2666);

  /**
   * generated from gfx.adapter.primary.driver_version
   */
  /**
   * Graphics adapter driver version (Migrated from the geckoview metric of the same
     * name).
   */
  constexpr impl::StringMetric driver_version(2667);

  /**
   * generated from gfx.adapter.primary.ram
   */
  /**
   * Graphics adapter dedicated memory (Migrated from the geckoview metric of the
     * same name).
   */
  constexpr impl::QuantityMetric ram(2668);

  /**
   * generated from gfx.adapter.primary.subsystem_id
   */
  /**
   * Graphics adapter subsystem identification (Migrated from the geckoview metric
     * of the same name).
   */
  constexpr impl::StringMetric subsystem_id(2669);

  /**
   * generated from gfx.adapter.primary.vendor_id
   */
  /**
   * Graphics adapter vendor identification (Migrated from the geckoview metric of
     * the same name).
   */
  constexpr impl::StringMetric vendor_id(2670);

}
namespace gfx_checkerboard {
  /**
   * generated from gfx.checkerboard.duration
   */
  /**
   * The duration of a checkerboard event. Checkerboarding is when painting has not
     * kept up with asynchronous panning and zooming so the compositor has to display
     * a "checkerboard pattern" (or in practice, the background color) rather than the
     * actual page content. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::TimingDistributionMetric duration(2671);

  /**
   * generated from gfx.checkerboard.peak_pixel_count
   */
  /**
   * The peak number of CSS pixels that checkerboarded during a checkerboard event.
     * The minimum value of the largest histogram bucket is the size of a 4k display
     * with maximum APZ zooming. (Migrated from the geckoview metric of the same
     * name).
   */
  constexpr impl::CustomDistributionMetric peak_pixel_count(2672);

  /**
   * generated from gfx.checkerboard.potential_duration
   */
  /**
   * The total amount of time that we could reasonably be checkerboarding. This is
     * the union of two possibly-intersecting sets of time periods: The first set is
     * that in which checkerboarding was actually happening, since by definition it
     * could potentially be happening. The second set is that in which the APZC is
     * actively transforming content in the compositor, since it could potentially
     * transform it so as to display checkerboarding to the user. Combined with other
     * information, this allows us to meaningfully say how frequently users actually
     * enncounters checkerboarding. (Migrated from the geckoview metric of the same
     * name).
   */
  constexpr impl::TimingDistributionMetric potential_duration(2673);

  /**
   * generated from gfx.checkerboard.severity
   */
  /**
   * An opaque measurement of the severity of a checkerboard event. This doesn't
     * have units, it's just useful for comparing two checkerboard events to see which
     * one is worse, for some implementation-specific definition of "worse". The
     * larger the value, the worse the checkerboarding. (Migrated from the geckoview
     * metric of the same name).
   */
  constexpr impl::CustomDistributionMetric severity(2674);

}
namespace gfx_content {
  /**
   * generated from gfx.content.full_paint_time
   */
  /**
   * Time spent in the full paint pipeline for content until it's ready for
     * composition. For non-webrender this includes `paint_time`, plus rasterization
     * if OMTP is enabled. For webrender, this includes `paint_time`, plus scene
     * building time. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::TimingDistributionMetric full_paint_time(2675);

  /**
   * generated from gfx.content.paint_time
   */
  /**
   * Time spent in the main-thread paint pipeline for content. For non-webrender,
     * this includes display list building, layer building, and when OMTP is disabled,
     * rasterization. For webrender, this includes display list building, and
     * webrender display list building. (Migrated from the geckoview metric of the
     * same name).
   */
  constexpr impl::TimingDistributionMetric paint_time(2676);

}
namespace gfx_content_frame_time {
  /**
   * generated from gfx.content.frame_time.from_paint
   */
  /**
   * The time, in percentage of a vsync interval, spent from beginning a paint in
     * the content process until that frame is presented in the compositor. (Migrated
     * from the geckoview metric of the same name).
   */
  constexpr impl::CustomDistributionMetric from_paint(2677);

  /**
   * generated from gfx.content.frame_time.from_vsync
   */
  /**
   * The time, in percentage of a vsync interval, spent from the vsync that started
     * a paint in the content process until that frame is presented in the compositor.
     * (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::CustomDistributionMetric from_vsync(2678);

  /**
   * generated from gfx.content.frame_time.reason
   */
  enum class ReasonLabel: uint16_t {
      eOnTime = 0,
      eNoVsync = 1,
      eMissedComposite = 2,
      eSlowComposite = 3,
      eMissedCompositeMid = 4,
      eMissedCompositeLong = 5,
      eMissedCompositeLow = 6,
      eNoVsyncNoId = 7,
      e__Other__,
    };
  /**
   * The reason that `gfx.content.frame_time.from_paint` recorded a slow (>200ms)
     * result, if any. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::Labeled<impl::CounterMetric, ReasonLabel> reason(2679);

  /**
   * generated from gfx.content.frame_time.with_svg
   */
  /**
   * The time, in percentage of a vsync interval, spent from beginning a paint in
     * the content process until that frame is presented in the compositor, for frames
     * that contained an SVG to be drawn by webrender. (Migrated from the geckoview
     * metric of the same name).
   */
  constexpr impl::CustomDistributionMetric with_svg(2680);

  /**
   * generated from gfx.content.frame_time.without_resource_upload
   */
  /**
   * The time, in percentage of a vsync interval, spent from beginning a paint in
     * the content process until that frame is presented in the compositor by
     * webrender, excluding time spent uploading resources. (Migrated from the
     * geckoview metric of the same name).
   */
  constexpr impl::CustomDistributionMetric without_resource_upload(2681);

  /**
   * generated from gfx.content.frame_time.without_upload
   */
  /**
   * The time, in percentage of a vsync interval, spent from beginning a paint in
     * the content process until that frame is presented in the compositor by
     * webrender, excluding time spent uploading any content. (Migrated from the
     * geckoview metric of the same name).
   */
  constexpr impl::CustomDistributionMetric without_upload(2682);

}
namespace gfx_display {
  /**
   * generated from gfx.display.count
   */
  /**
   * Amount of displays connected to the device (Migrated from the geckoview metric
     * of the same name).
   */
  constexpr impl::QuantityMetric count(2683);

  /**
   * generated from gfx.display.primary_height
   */
  /**
   * Height of the primary display, takes device rotation into account. (Migrated
     * from the geckoview metric of the same name).
   */
  constexpr impl::QuantityMetric primary_height(2684);

  /**
   * generated from gfx.display.primary_width
   */
  /**
   * Width of the primary display, takes device rotation into account. (Migrated
     * from the geckoview metric of the same name).
   */
  constexpr impl::QuantityMetric primary_width(2685);

}
namespace gfx_feature {
  /**
   * generated from gfx.feature.webrender
   */
  /**
   * Whether webrender is enabled or disabled, and why. (Migrated from the geckoview
     * metric of the same name).
   */
  constexpr impl::StringMetric webrender(2686);

}
namespace gfx_status {
  /**
   * generated from gfx.status.compositor
   */
  /**
   * Name of the graphics compositor in use. Possible values are "opengl, d3d11,
     * client, webrender or basic" (Migrated from the geckoview metric of the same
     * name).
   */
  constexpr impl::StringMetric compositor(2687);

  /**
   * generated from gfx.status.headless
   */
  /**
   * Boolean indicated whether graphics is running in headless (no display) mode
     * (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::BooleanMetric headless(2688);

  /**
   * generated from gfx.status.last_compositor_gecko_version
   */
  /**
   * The gecko version at the last time a compositor was initialized, and therefore
     * when gfx_status_compositor was last updated. Due to gfx_status_compositor's
     * user lifetime we see lots of unexpected values for the current gecko version.
     * We believe this is because the user has not opened a tab since they were
     * updated to a version where webrender should be enabled on their device. This
     * can be used to verify that theory. (Migrated from the geckoview metric of the
     * same name).
   */
  constexpr impl::StringMetric last_compositor_gecko_version(2689);

}
namespace gpu_process {
  /**
   * generated from gpu_process.crash_fallbacks
   */
  enum class CrashFallbacksLabel: uint16_t {
      eNone = 0,
      eDecodingDisabled = 1,
      eDisabled = 2,
      e__Other__,
    };
  /**
   * How often we use different fallbacks when the GPU process crashes
   */
  constexpr impl::Labeled<impl::CounterMetric, CrashFallbacksLabel> crash_fallbacks(2690);

  /**
   * generated from gpu_process.feature_status
   */
  /**
   * Current status of the GPU process feature
   */
  constexpr impl::StringMetric feature_status(2691);

  /**
   * generated from gpu_process.total_launch_attempts
   */
  /**
   * The number of total GPU process launch attempts.
   */
  constexpr impl::QuantityMetric total_launch_attempts(2692);

  /**
   * generated from gpu_process.unstable_launch_attempts
   */
  /**
   * The number of consecutive unstable launch attempts.
   */
  constexpr impl::QuantityMetric unstable_launch_attempts(2693);

}
namespace paint {
  /**
   * generated from paint.build_displaylist_time
   */
  /**
   * The time to build a Gecko display list.
   */
  constexpr impl::TimingDistributionMetric build_displaylist_time(2694);

}
namespace wr {
  /**
   * generated from wr.framebuild_time
   */
  /**
   * The time to rasterize glyphs for consumption by WebRender.
   */
  constexpr impl::TimingDistributionMetric framebuild_time(2695);

  /**
   * generated from wr.gpu_wait_time
   */
  /**
   * The time spent waiting for the GPU to complete previously issued drawing
     * commands.
   */
  constexpr impl::TimingDistributionMetric gpu_wait_time(2696);

  /**
   * generated from wr.rasterize_blobs_time
   */
  /**
   * The time to rasterize blobs for consumption by WebRender.
   */
  constexpr impl::TimingDistributionMetric rasterize_blobs_time(2697);

  /**
   * generated from wr.rasterize_glyphs_time
   */
  /**
   * The time to rasterize glyphs for consumption by WebRender.
   */
  constexpr impl::TimingDistributionMetric rasterize_glyphs_time(2698);

  /**
   * generated from wr.renderer_time
   */
  /**
   * WebRender renderer time.
   */
  constexpr impl::TimingDistributionMetric renderer_time(2699);

  /**
   * generated from wr.renderer_time_no_sc
   */
  /**
   * WebRender renderer time excluding frames in which shader compilation took
     * place.
   */
  constexpr impl::TimingDistributionMetric renderer_time_no_sc(2700);

  /**
   * generated from wr.scenebuild_time
   */
  /**
   * WebRender scene build time.
   */
  constexpr impl::TimingDistributionMetric scenebuild_time(2701);

  /**
   * generated from wr.sceneswap_time
   */
  /**
   * WebRender scene swap time.
   */
  constexpr impl::TimingDistributionMetric sceneswap_time(2702);

  /**
   * generated from wr.texture_cache_update_time
   */
  /**
   * Time taken by WebRender to update the texture cache.
   */
  constexpr impl::TimingDistributionMetric texture_cache_update_time(2703);

  /**
   * generated from wr.time_to_frame_build
   */
  /**
   * Time elapsed between the construction of a transaction and the associated frame
     * build beginning.
   */
  constexpr impl::TimingDistributionMetric time_to_frame_build(2704);

  /**
   * generated from wr.time_to_render_start
   */
  /**
   * Time elapsed between the construction of a frame and the start of rendering.
   */
  constexpr impl::TimingDistributionMetric time_to_render_start(2705);

}
namespace avif {
  /**
   * generated from avif.a1lx
   */
  enum class A1lxLabel: uint16_t {
      ePresent = 0,
      eAbsent = 1,
      e__Other__,
    };
  /**
   * AV1LayeredImageIndexingProperty (a1lx). (Migrated from the geckoview metric of
     * the same name).
   */
  constexpr impl::Labeled<impl::CounterMetric, A1lxLabel> a1lx(2706);

  /**
   * generated from avif.a1op
   */
  enum class A1opLabel: uint16_t {
      ePresent = 0,
      eAbsent = 1,
      e__Other__,
    };
  /**
   * AVIF OperatingPointSelectorProperty (a1op). (Migrated from the geckoview metric
     * of the same name).
   */
  constexpr impl::Labeled<impl::CounterMetric, A1opLabel> a1op(2707);

  /**
   * generated from avif.alpha
   */
  enum class AlphaLabel: uint16_t {
      eAbsent = 0,
      ePresent = 1,
      e__Other__,
    };
  /**
   * AVIF alpha plane. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::Labeled<impl::CounterMetric, AlphaLabel> alpha(2708);

  /**
   * generated from avif.aom_decode_error
   */
  enum class AomDecodeErrorLabel: uint16_t {
      eError = 0,
      eMemError = 1,
      eAbiMismatch = 2,
      eIncapable = 3,
      eUnsupBitstream = 4,
      eUnsupFeature = 5,
      eCorruptFrame = 6,
      eInvalidParam = 7,
      e__Other__,
    };
  /**
   * Image-decode Error from AOM decoder (Migrated from the geckoview metric of the
     * same name).
   */
  constexpr impl::Labeled<impl::CounterMetric, AomDecodeErrorLabel> aom_decode_error(2709);

  /**
   * generated from avif.bit_depth
   */
  enum class BitDepthLabel: uint16_t {
      eColor8 = 0,
      eColor10 = 1,
      eColor12 = 2,
      eColor16 = 3,
      eUnknown = 4,
      e__Other__,
    };
  /**
   * Bits per pixel of AVIF image. (Migrated from the geckoview metric of the same
     * name).
   */
  constexpr impl::Labeled<impl::CounterMetric, BitDepthLabel> bit_depth(2710);

  /**
   * generated from avif.cicp_cp
   */
  enum class CicpCpLabel: uint16_t {
      eReserved = 0,
      eBt709 = 1,
      eUnspecified = 2,
      eReserved3 = 3,
      eBt470m = 4,
      eBt470bg = 5,
      eBt601 = 6,
      eSmpte240 = 7,
      eGenericFilm = 8,
      eBt2020 = 9,
      eXyz = 10,
      eSmpte431 = 11,
      eSmpte432 = 12,
      eReserved13 = 13,
      eReserved14 = 14,
      eReserved15 = 15,
      eReserved16 = 16,
      eReserved17 = 17,
      eReserved18 = 18,
      eReserved19 = 19,
      eReserved20 = 20,
      eReserved21 = 21,
      eEbu3213 = 22,
      eReservedRest = 23,
      e__Other__,
    };
  /**
   * AVIF CICP colour primaries. (Migrated from the geckoview metric of the same
     * name).
   */
  constexpr impl::Labeled<impl::CounterMetric, CicpCpLabel> cicp_cp(2711);

  /**
   * generated from avif.cicp_mc
   */
  enum class CicpMcLabel: uint16_t {
      eIdentity = 0,
      eBt709 = 1,
      eUnspecified = 2,
      eReserved = 3,
      eFcc = 4,
      eBt470bg = 5,
      eBt601 = 6,
      eSmpte240 = 7,
      eYcgco = 8,
      eBt2020Ncl = 9,
      eBt2020Cl = 10,
      eSmpte2085 = 11,
      eChromatNcl = 12,
      eChromatCl = 13,
      eIctcp = 14,
      eReservedRest = 15,
      e__Other__,
    };
  /**
   * AVIF CICP transfer characteristics. (Migrated from the geckoview metric of the
     * same name).
   */
  constexpr impl::Labeled<impl::CounterMetric, CicpMcLabel> cicp_mc(2712);

  /**
   * generated from avif.cicp_tc
   */
  enum class CicpTcLabel: uint16_t {
      eReserved = 0,
      eBt709 = 1,
      eUnspecified = 2,
      eReserved3 = 3,
      eBt470m = 4,
      eBt470bg = 5,
      eBt601 = 6,
      eSmpte240 = 7,
      eLinear = 8,
      eLog100 = 9,
      eLog100Sqrt10 = 10,
      eIec61966 = 11,
      eBt1361 = 12,
      eSrgb = 13,
      eBt202010bit = 14,
      eBt202012bit = 15,
      eSmpte2084 = 16,
      eSmpte428 = 17,
      eHlg = 18,
      eReservedRest = 19,
      e__Other__,
    };
  /**
   * AVIF CICP transfer characteristics. (Migrated from the geckoview metric of the
     * same name).
   */
  constexpr impl::Labeled<impl::CounterMetric, CicpTcLabel> cicp_tc(2713);

  /**
   * generated from avif.clap
   */
  enum class ClapLabel: uint16_t {
      ePresent = 0,
      eAbsent = 1,
      e__Other__,
    };
  /**
   * AVIF CleanApertureBox (clap). (Migrated from the geckoview metric of the same
     * name).
   */
  constexpr impl::Labeled<impl::CounterMetric, ClapLabel> clap(2714);

  /**
   * generated from avif.colr
   */
  enum class ColrLabel: uint16_t {
      eNclx = 0,
      eIcc = 1,
      eAbsent = 2,
      eBoth = 3,
      e__Other__,
    };
  /**
   * AVIF colour information type. (Migrated from the geckoview metric of the same
     * name).
   */
  constexpr impl::Labeled<impl::CounterMetric, ColrLabel> colr(2715);

  /**
   * generated from avif.decode_result
   */
  enum class DecodeResultLabel: uint16_t {
      eSuccess = 0,
      eParseError = 1,
      eNoPrimaryItem = 2,
      eDecodeError = 3,
      eSizeOverflow = 4,
      eOutOfMemory = 5,
      ePipeInitError = 6,
      eWriteBufferError = 7,
      eAlphaYSzMismatch = 8,
      eAlphaYBpcMismatch = 9,
      eIspeMismatch = 10,
      eRenderSizeMismatch = 11,
      eFrameSizeChanged = 12,
      eInvalidCicp = 13,
      eInvalidParseStatus = 14,
      eMissingBrand = 15,
      eFtypNotFirst = 16,
      eNoImage = 17,
      eMultipleMoov = 18,
      eNoMoov = 19,
      eLselNoEssential = 20,
      eA1opNoEssential = 21,
      eA1lxEssential = 22,
      eTxformNoEssential = 23,
      eImageItemType = 24,
      eItemTypeMissing = 25,
      eConstructionMethod = 26,
      eItemLocNotFound = 27,
      eNoItemDataBox = 28,
      eNoSamples = 29,
      eUncategorized = 30,
      e__Other__,
    };
  /**
   * Decode result of AVIF image. (Migrated from the geckoview metric of the same
     * name).
   */
  constexpr impl::Labeled<impl::CounterMetric, DecodeResultLabel> decode_result(2716);

  /**
   * generated from avif.decoder
   */
  enum class DecoderLabel: uint16_t {
      eDav1d = 0,
      eAom = 1,
      e__Other__,
    };
  /**
   * Decoder of AVIF image. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::Labeled<impl::CounterMetric, DecoderLabel> decoder(2717);

  /**
   * generated from avif.grid
   */
  enum class GridLabel: uint16_t {
      ePresent = 0,
      eAbsent = 1,
      e__Other__,
    };
  /**
   * AVIF AVIF grid-based image. (Migrated from the geckoview metric of the same
     * name).
   */
  constexpr impl::Labeled<impl::CounterMetric, GridLabel> grid(2718);

  /**
   * generated from avif.ipro
   */
  enum class IproLabel: uint16_t {
      ePresent = 0,
      eAbsent = 1,
      e__Other__,
    };
  /**
   * AVIF ItemProtectionBox (ipro). (Migrated from the geckoview metric of the same
     * name).
   */
  constexpr impl::Labeled<impl::CounterMetric, IproLabel> ipro(2719);

  /**
   * generated from avif.ispe
   */
  enum class IspeLabel: uint16_t {
      eValid = 0,
      eAbsent = 1,
      eBitstreamMismatch = 2,
      e__Other__,
    };
  /**
   * AVIF spatial extents (image size). (Migrated from the geckoview metric of the
     * same name).
   */
  constexpr impl::Labeled<impl::CounterMetric, IspeLabel> ispe(2720);

  /**
   * generated from avif.lsel
   */
  enum class LselLabel: uint16_t {
      ePresent = 0,
      eAbsent = 1,
      e__Other__,
    };
  /**
   * AVIF LayerSelectorProperty (lsel). (Migrated from the geckoview metric of the
     * same name).
   */
  constexpr impl::Labeled<impl::CounterMetric, LselLabel> lsel(2721);

  /**
   * generated from avif.pasp
   */
  enum class PaspLabel: uint16_t {
      eAbsent = 0,
      eSquare = 1,
      eNonsquare = 2,
      eInvalid = 3,
      e__Other__,
    };
  /**
   * AVIF pixel aspect ratio. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::Labeled<impl::CounterMetric, PaspLabel> pasp(2722);

  /**
   * generated from avif.pixi
   */
  enum class PixiLabel: uint16_t {
      eValid = 0,
      eAbsent = 1,
      eBitstreamMismatch = 2,
      e__Other__,
    };
  /**
   * AVIF pixel information (bits per channel). (Migrated from the geckoview metric
     * of the same name).
   */
  constexpr impl::Labeled<impl::CounterMetric, PixiLabel> pixi(2723);

  /**
   * generated from avif.yuv_color_space
   */
  enum class YuvColorSpaceLabel: uint16_t {
      eBt601 = 0,
      eBt709 = 1,
      eBt2020 = 2,
      eIdentity = 3,
      eUnknown = 4,
      e__Other__,
    };
  /**
   * YUV color space of AVIF image. (Migrated from the geckoview metric of the same
     * name).
   */
  constexpr impl::Labeled<impl::CounterMetric, YuvColorSpaceLabel> yuv_color_space(2724);

}
namespace javascript_gc {
  /**
   * generated from javascript.gc.compact_time
   */
  /**
   * The time spent in the compact phase. (Migrated from the geckoview metric of the
     * same name.)
   */
  constexpr impl::TimingDistributionMetric compact_time(2725);

  /**
   * generated from javascript.gc.mark_roots_time
   */
  /**
   * The time spent marking GC roots. (Migrated from the geckoview metric of the
     * same name.)
   */
  constexpr impl::TimingDistributionMetric mark_roots_time(2726);

  /**
   * generated from javascript.gc.mark_time
   */
  /**
   * The time spent in the mark phase. (Migrated from the geckoview metric of the
     * same name.)
   */
  constexpr impl::TimingDistributionMetric mark_time(2727);

  /**
   * generated from javascript.gc.minor_time
   */
  /**
   * The time taked by a minor (nursery) collection. (Migrated from the geckoview
     * metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric minor_time(2728);

  /**
   * generated from javascript.gc.prepare_time
   */
  /**
   * The time spent in the preparation phase. (Migrated from the geckoview metric of
     * the same name.)
   */
  constexpr impl::TimingDistributionMetric prepare_time(2729);

  /**
   * generated from javascript.gc.slice_time
   */
  /**
   * The time spent running a GC slice. (Migrated from the geckoview metric of the
     * same name.)
   */
  constexpr impl::TimingDistributionMetric slice_time(2730);

  /**
   * generated from javascript.gc.sweep_time
   */
  /**
   * The time spent in the sweep phase. (Migrated from the geckoview metric of the
     * same name.)
   */
  constexpr impl::TimingDistributionMetric sweep_time(2731);

  /**
   * generated from javascript.gc.total_time
   */
  /**
   * The total time taken by a major collection. (Migrated from the geckoview metric
     * of the same name.)
   */
  constexpr impl::TimingDistributionMetric total_time(2732);

}
namespace performance_clone_deserialize {
  /**
   * generated from performance.clone.deserialize.items
   */
  /**
   * Size of deserialized data, in items
   */
  constexpr impl::CustomDistributionMetric items(2733);

  /**
   * generated from performance.clone.deserialize.size
   */
  /**
   * Size of deserialized data, in bytes
   */
  constexpr impl::MemoryDistributionMetric size(2734);

  /**
   * generated from performance.clone.deserialize.time
   */
  /**
   * Time spent deserializing structured data
   */
  constexpr impl::TimingDistributionMetric time(2735);

}
namespace performance_responsiveness {
  /**
   * generated from performance.responsiveness.req_anim_frame_callback
   */
  /**
   * Time spent in milliseconds calling all request animation frame callbacks for a
     * document after it has reached readystate complete. (Migrated from the geckoview
     * metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric req_anim_frame_callback(2736);

}
namespace geckoview {
  /**
   * generated from geckoview.content_process_lifetime
   */
  /**
   * The uptime of content processes. (Migrated from the geckoview metric of the
     * same name).
   */
  constexpr impl::TimingDistributionMetric content_process_lifetime(2737);

  /**
   * generated from geckoview.document_site_origins
   */
  /**
   * When a document is loaded, report the number of [site
     * origins](https://searchfox.org/ mozilla-central/rev/
     * 3300072e993ae05d50d5c63d815260367eaf9179/ caps/nsIPrincipal.idl#264) of the
     * entire browser if it has been at least 5 minutes since last time we collect
     * this data. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::CustomDistributionMetric document_site_origins(2738);

  /**
   * generated from geckoview.page_load_progress_time
   */
  /**
   * Time between page load progress starts (0) and completion (100). (Migrated from
     * the geckoview metric of the same name).
   */
  constexpr impl::TimingDistributionMetric page_load_progress_time(2739);

  /**
   * generated from geckoview.page_load_time
   */
  /**
   * The time taken to load a page. This includes all static contents, no dynamic
     * content. Loading of about: pages is not counted. Back back navigation
     * (sometimes via BFCache) is included which is a source of bimodality due to the
     * <50ms load times. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::TimingDistributionMetric page_load_time(2740);

  /**
   * generated from geckoview.page_reload_time
   */
  /**
   * Time taken to reload a page. This includes all static contents, no dynamic
     * content. Loading of about: pages is not counted. (Migrated from the geckoview
     * metric of the same name).
   */
  constexpr impl::TimingDistributionMetric page_reload_time(2741);

  /**
   * generated from geckoview.per_document_site_origins
   */
  /**
   * When a document is unloaded, report the highest number of [site
     * origins](https://searchfox.org/ mozilla-central/rev/
     * 3300072e993ae05d50d5c63d815260367eaf9179/ caps/nsIPrincipal.idl#264) loaded
     * simultaneously in that document. (Migrated from the geckoview metric of the
     * same name).
   */
  constexpr impl::CustomDistributionMetric per_document_site_origins(2742);

  /**
   * generated from geckoview.startup_runtime
   */
  /**
   * The time taken to initialize GeckoRuntime. (Migrated from the geckoview metric
     * of the same name).
   */
  constexpr impl::TimingDistributionMetric startup_runtime(2743);

}
namespace network_sso {
  /**
   * generated from network.sso.entra_success
   */
  enum class EntraSuccessLabel: uint16_t {
      eSuccess = 0,
      eDeviceHeadersMissing = 1,
      ePrtHeadersMissing = 2,
      eBothHeadersMissing = 3,
      eInvalidCookie = 4,
      eNoCredential = 5,
      eBrokerError = 6,
      eInvalidControllerSetup = 7,
      e__Other__,
    };
  /**
   * Counts how often Entra SSO succeeded/failed (macOS only). Labels are ordered in
     * reverse chronological relation to SSO success, meaning the labels higher up are
     * closer to the SSO success. device_headers_missing: only device_headers is
     * missing in the SSO cookie. prt_headers_missing: only prt_headers is missing in
     * the SSO cookie. both_headers_missing: both prt_headers and device_headers are
     * missing in the SSO cookie. invalid_cookie: Failed to parse SSO cookie (could be
     * a null cookie/format is incorrect). no_credential:
     * ASAuthorizationSingleSignOnCredential is not present broker_error: An error
     * from Microsoft's broker. invalid_controller_setup: ASAuthorizationController is
     * setup incorrectly.
   */
  constexpr impl::Labeled<impl::CounterMetric, EntraSuccessLabel> entra_success(2744);

  /**
   * generated from network.sso.total_entra_uses
   */
  /**
   * Counts how often Entra SSO is used (macOS only).
   */
  constexpr impl::CounterMetric total_entra_uses(2745);

}
namespace networking {
  /**
   * generated from networking.cookie_access_fixup_diff
   */
  /**
   * If we fix up a cookie lastAccessed timestamp that is in the future this metric
     * records the number of seconds that timestamp was off from NOW.
   */
  constexpr impl::CustomDistributionMetric cookie_access_fixup_diff(2746);

  /**
   * generated from networking.cookie_count_part_by_key
   */
  /**
   * A distribution of the partitioned cookies in storage belonging to a particular
     * cookie key (host + origin attributes)
   */
  constexpr impl::CustomDistributionMetric cookie_count_part_by_key(2747);

  /**
   * generated from networking.cookie_count_partitioned
   */
  /**
   * Reports the number of partitioned cookies in storage
   */
  constexpr impl::CustomDistributionMetric cookie_count_partitioned(2748);

  /**
   * generated from networking.cookie_count_total
   */
  /**
   * Reports the total number of cookies in storage
   */
  constexpr impl::CustomDistributionMetric cookie_count_total(2749);

  /**
   * generated from networking.cookie_count_unpart_by_key
   */
  /**
   * A distribution of the unpartitioned cookies in storage belonging to a
     * particular cookie key (host + origin attributes)
   */
  constexpr impl::CustomDistributionMetric cookie_count_unpart_by_key(2750);

  /**
   * generated from networking.cookie_count_unpartitioned
   */
  /**
   * Reports the number of unpartitioned cookies in storage
   */
  constexpr impl::CustomDistributionMetric cookie_count_unpartitioned(2751);

  /**
   * generated from networking.cookie_creation_fixup_diff
   */
  /**
   * If we fix up a cookie creation timestamp that is in the future this metric
     * records the number of seconds that timestamp was off from NOW.
   */
  constexpr impl::CustomDistributionMetric cookie_creation_fixup_diff(2752);

  /**
   * generated from networking.cookie_purge_entry_max
   */
  /**
   * A distribution of the number of cookies purged for a single host + OA entry as
     * a result of exceeding the maximum threshold for the given host + OA (single
     * purge)
   */
  constexpr impl::CustomDistributionMetric cookie_purge_entry_max(2753);

  /**
   * generated from networking.cookie_purge_max
   */
  /**
   * A distribution of the number of cookies purged across all host + OAs as a
     * result of exceeding the cookie maximum threshold (single purge)
   */
  constexpr impl::CustomDistributionMetric cookie_purge_max(2754);

  /**
   * generated from networking.cookie_timestamp_fixed_count
   */
  enum class CookieTimestampFixedCountLabel: uint16_t {
      eCreationtime = 0,
      eLastaccessed = 1,
      e__Other__,
    };
  /**
   * Counts the number of times a cookie's invalid timestamp was fixed when reading
     * it from the DB.
   */
  constexpr impl::Labeled<impl::CounterMetric, CookieTimestampFixedCountLabel> cookie_timestamp_fixed_count(2755);

  /**
   * generated from networking.dns_failed_lookup_time
   */
  /**
   * Time for an unsuccessful DNS OS resolution (msec) | Migrated from Firefox
     * Telemetry's `DNS_FAILED_LOOKUP_TIME`.
   */
  constexpr impl::TimingDistributionMetric dns_failed_lookup_time(2756);

  /**
   * generated from networking.dns_lookup_time
   */
  /**
   * Time for a successful DNS resolution (msec) | Migrated from Firefox Telemetry's
     * `DNS_LOOKUP_TIME`.
   */
  constexpr impl::TimingDistributionMetric dns_lookup_time(2757);

  /**
   * generated from networking.dns_native_count
   */
  enum class DnsNativeCountLabel: uint16_t {
      eRegular = 0,
      ePrivate = 1,
      eHttpsRegular = 2,
      eHttpsPrivate = 3,
      e__Other__,
    };
  /**
   * The count of calls to the native DNS APIs
   */
  constexpr impl::Labeled<impl::CounterMetric, DnsNativeCountLabel> dns_native_count(2758);

  /**
   * generated from networking.dns_native_https_call_time
   */
  /**
   * Time spent in the call to the native OS DNS resolution.
   */
  constexpr impl::TimingDistributionMetric dns_native_https_call_time(2759);

  /**
   * generated from networking.dns_renewal_time
   */
  /**
   * Time for a renewed DNS OS resolution (msec) | Migrated from Firefox Telemetry's
     * `DNS_RENEWAL_TIME`.
   */
  constexpr impl::TimingDistributionMetric dns_renewal_time(2760);

  /**
   * generated from networking.dns_renewal_time_for_ttl
   */
  /**
   * Time for a DNS OS resolution (msec) used to get TTL | Migrated from Firefox
     * Telemetry's `DNS_RENEWAL_TIME_FOR_TTL`.
   */
  constexpr impl::TimingDistributionMetric dns_renewal_time_for_ttl(2761);

  /**
   * generated from networking.http_1_download_throughput
   */
  /**
   * The download throughput for  http/1.0, http/1.1 requests larger than 10MB.
     * Measured in megabits per second, Mbps.
   */
  constexpr impl::CustomDistributionMetric http_1_download_throughput(2762);

  /**
   * generated from networking.http_1_upload_throughput
   */
  /**
   * The upload throughput for http/1.0, http/1.1 requests larger than 10MB.
     * Measured in megabits per second, Mbps.
   */
  constexpr impl::CustomDistributionMetric http_1_upload_throughput(2763);

  /**
   * generated from networking.http_1_upload_throughput_100
   */
  /**
   * The upload throughput for http/1.0, http/1.1 request size larger than 100MB.
     * Measured in megabits per second, Mbps.
   */
  constexpr impl::CustomDistributionMetric http_1_upload_throughput_100(2764);

  /**
   * generated from networking.http_1_upload_throughput_10_50
   */
  /**
   * The upload throughput for http/1.0, http/1.1 request size between 10MB and
     * 50MB. Measured in megabits per second, Mbps.
   */
  constexpr impl::CustomDistributionMetric http_1_upload_throughput_10_50(2765);

  /**
   * generated from networking.http_1_upload_throughput_50_100
   */
  /**
   * The upload throughput for http/1.0, http/1.1 request size between 50MB and
     * 100MB. Measured in megabits per second, Mbps.
   */
  constexpr impl::CustomDistributionMetric http_1_upload_throughput_50_100(2766);

  /**
   * generated from networking.http_2_download_throughput
   */
  /**
   * The download throughput for http/2 requests larger than 10MB. Measured in
     * megabits per second, Mbps.
   */
  constexpr impl::CustomDistributionMetric http_2_download_throughput(2767);

  /**
   * generated from networking.http_2_upload_throughput
   */
  /**
   * The upload throughput for http/2 requests larger than 10MB. Measured in
     * megabits per second, Mbps.
   */
  constexpr impl::CustomDistributionMetric http_2_upload_throughput(2768);

  /**
   * generated from networking.http_2_upload_throughput_100
   */
  /**
   * The upload throughput for http/2 request size larger than 100MB. Measured in
     * megabits per second, Mbps.
   */
  constexpr impl::CustomDistributionMetric http_2_upload_throughput_100(2769);

  /**
   * generated from networking.http_2_upload_throughput_10_50
   */
  /**
   * The upload throughput for http/2 request size between 10MB and 50MB. Measured
     * in megabits per second, Mbps.
   */
  constexpr impl::CustomDistributionMetric http_2_upload_throughput_10_50(2770);

  /**
   * generated from networking.http_2_upload_throughput_50_100
   */
  /**
   * The upload throughput for http/2 request size between 50MB and 100MB. Measured
     * in megabits per second, Mbps.
   */
  constexpr impl::CustomDistributionMetric http_2_upload_throughput_50_100(2771);

  /**
   * generated from networking.http_3_download_throughput
   */
  /**
   * The download throughput for http/3 requests larger than 10MB. Measured in
     * megabits per second, Mbps.
   */
  constexpr impl::CustomDistributionMetric http_3_download_throughput(2772);

  /**
   * generated from networking.http_3_upload_throughput
   */
  /**
   * The upload throughput for http/3 requests larger than 10MB. Measured in
     * megabits per second, Mbps.
   */
  constexpr impl::CustomDistributionMetric http_3_upload_throughput(2773);

  /**
   * generated from networking.http_3_upload_throughput_100
   */
  /**
   * The upload throughput for http/3 request size larger than 100MB. Measured in
     * megabits per second, Mbps.
   */
  constexpr impl::CustomDistributionMetric http_3_upload_throughput_100(2774);

  /**
   * generated from networking.http_3_upload_throughput_10_50
   */
  /**
   * The upload throughput for http/3 request size between 10MB and 50MB. Measured
     * in megabits per second, Mbps.
   */
  constexpr impl::CustomDistributionMetric http_3_upload_throughput_10_50(2775);

  /**
   * generated from networking.http_3_upload_throughput_50_100
   */
  /**
   * The upload throughput for http/3 request size between 50MB and 100MB. Measured
     * in megabits per second, Mbps.
   */
  constexpr impl::CustomDistributionMetric http_3_upload_throughput_50_100(2776);

  /**
   * generated from networking.http_channel_onstart_success_https_rr
   */
  enum class HttpChannelOnstartSuccessHttpsRrLabel: uint16_t {
      eSuccess = 0,
      eFailure = 1,
      eSuccessEchUsed = 2,
      eFailureEchUsed = 3,
      e__Other__,
    };
  /**
   * Successfully started HTTP channels when HTTPS RR is used
   */
  constexpr impl::Labeled<impl::CounterMetric, HttpChannelOnstartSuccessHttpsRrLabel> http_channel_onstart_success_https_rr(2777);

  /**
   * generated from networking.http_channel_page_open_to_first_sent
   */
  /**
   * Time in milliseconds from AsyncOpen to first byte of request sent, applicable
     * for page loads without HTTPS RR
   */
  constexpr impl::TimingDistributionMetric http_channel_page_open_to_first_sent(2778);

  /**
   * generated from networking.http_channel_page_open_to_first_sent_https_rr
   */
  /**
   * Time in milliseconds from AsyncOpen to first byte of request sent, applicable
     * for page loads with HTTPS RR
   */
  constexpr impl::TimingDistributionMetric http_channel_page_open_to_first_sent_https_rr(2779);

  /**
   * generated from networking.http_channel_sub_open_to_first_sent
   */
  /**
   * Time in milliseconds from AsyncOpen to first byte of request sent, applicable
     * for sub-resource loads without HTTPS RR
   */
  constexpr impl::TimingDistributionMetric http_channel_sub_open_to_first_sent(2780);

  /**
   * generated from networking.http_channel_sub_open_to_first_sent_https_rr
   */
  /**
   * Time in milliseconds from AsyncOpen to first byte of request sent, applicable
     * for sub-resource loads with HTTPS RR
   */
  constexpr impl::TimingDistributionMetric http_channel_sub_open_to_first_sent_https_rr(2781);

  /**
   * generated from networking.http_content_cssloader_ondatafinished_to_onstop_delay
   */
  /**
   * The time between processing OnDataFinished and processing OnStopRequest for
     * CSSLoader in the content process
   */
  constexpr impl::TimingDistributionMetric http_content_cssloader_ondatafinished_to_onstop_delay(2782);

  /**
   * generated from networking.http_content_html5parser_ondatafinished_to_onstop_delay
   */
  /**
   * The time between processing OnDataFinished and processing OnStopRequest (if
     * OnDataFinished comes first)
   */
  constexpr impl::TimingDistributionMetric http_content_html5parser_ondatafinished_to_onstop_delay(2783);

  /**
   * generated from networking.http_content_ondatafinished_delay
   */
  /**
   * The time between dispatching OnDataFinished from the socket thread and
     * processing it.
   */
  constexpr impl::TimingDistributionMetric http_content_ondatafinished_delay(2784);

  /**
   * generated from networking.http_content_ondatafinished_to_onstop_delay
   */
  /**
   * The time between processing OnDataFinished and processing OnStopRequest (if
     * OnDataFinished comes first)
   */
  constexpr impl::TimingDistributionMetric http_content_ondatafinished_to_onstop_delay(2785);

  /**
   * generated from networking.http_content_onstart_delay
   */
  /**
   * The time between dispatching OnStartRequest from the socket thread and
     * processing it on the main thread (content process).
   */
  constexpr impl::TimingDistributionMetric http_content_onstart_delay(2786);

  /**
   * generated from networking.http_content_onstop_delay
   */
  /**
   * The time between dispatching OnStopRequest from the socket thread and
     * processing it on the main thread (content process).
   */
  constexpr impl::TimingDistributionMetric http_content_onstop_delay(2787);

  /**
   * generated from networking.http_onstart_suspend_total_time
   */
  /**
   * Time in milliseconds that http channel spent suspended between AsyncOpen and
     * OnStartRequest.
   */
  constexpr impl::TimingDistributionMetric http_onstart_suspend_total_time(2788);

  /**
   * generated from networking.http_response_version
   */
  enum class HttpResponseVersionLabel: uint16_t {
      eUnknown = 0,
      eHttp1 = 1,
      eHttp2 = 2,
      eHttp3 = 3,
      e__Other__,
    };
  /**
   * HTTP protocol version used on response from nsHttp.h
   */
  constexpr impl::Labeled<impl::CounterMetric, HttpResponseVersionLabel> http_response_version(2789);

  /**
   * generated from networking.https_rr_presented
   */
  enum class HttpsRrPresentedLabel: uint16_t {
      ePresented = 0,
      ePresentedWithHttp3 = 1,
      eNone = 2,
      e__Other__,
    };
  /**
   * HTTPS RR is presented or not
   */
  constexpr impl::Labeled<impl::CounterMetric, HttpsRrPresentedLabel> https_rr_presented(2790);

  /**
   * generated from networking.https_upgrade_with_https_rr
   */
  enum class HttpsUpgradeWithHttpsRrLabel: uint16_t {
      eHttpsRr = 0,
      eOthers = 1,
      e__Other__,
    };
  /**
   * Whether an HTTP request gets upgraded to HTTPS because of HTTPS RR
   */
  constexpr impl::Labeled<impl::CounterMetric, HttpsUpgradeWithHttpsRrLabel> https_upgrade_with_https_rr(2791);

  /**
   * generated from networking.proxy_info_type
   */
  enum class ProxyInfoTypeLabel: uint16_t {
      eHttp = 0,
      eHttps = 1,
      eSocks4 = 2,
      eSocks4a = 3,
      eSocks5 = 4,
      eSocks5h = 5,
      eDirect = 6,
      eUnknown = 7,
      e__Other__,
    };
  /**
   * The proxies configurations created in the browser session (SOCKSv4, SOCKSv5,
     * HTTP, HTTPS)
   */
  constexpr impl::Labeled<impl::CounterMetric, ProxyInfoTypeLabel> proxy_info_type(2792);

  /**
   * generated from networking.residual_cache_folder_count
   */
  /**
   * Counts how often we find a cache folder that wasn't purged at shutdown by a
     * background task process.
   */
  constexpr impl::CounterMetric residual_cache_folder_count(2793);

  /**
   * generated from networking.residual_cache_folder_removal
   */
  enum class ResidualCacheFolderRemovalLabel: uint16_t {
      eSuccess = 0,
      eFailure = 1,
      e__Other__,
    };
  /**
   * Counts how often succeed/fail in removing cache folder that wasn't purged at
     * shutdown
   */
  constexpr impl::Labeled<impl::CounterMetric, ResidualCacheFolderRemovalLabel> residual_cache_folder_removal(2794);

  /**
   * generated from networking.set_cookie
   */
  /**
   * This counts the number of times we set a cookie. Introduced as a denomenator
     * for measuring CHIPS adoption.
   */
  constexpr impl::DenominatorMetric set_cookie(2795);

  /**
   * generated from networking.set_cookie_foreign
   */
  /**
   * This counts the number of times we set a cookie from a foreign (not same-site)
     * context. Introduced as a denomenator for measuring CHIPS adoption.
   */
  constexpr impl::NumeratorMetric set_cookie_foreign(2796);

  /**
   * generated from networking.set_cookie_foreign_partitioned
   */
  /**
   * This counts the number of times we set a cookie that has the Partitioned
     * attribute in a foreign (not same-site) context. This tracks the adoption of
     * CHIPS.
   */
  constexpr impl::NumeratorMetric set_cookie_foreign_partitioned(2797);

  /**
   * generated from networking.set_cookie_partitioned
   */
  /**
   * This counts the number of times we set a cookie that has the Partitioned
     * attribute. This tracks the adoption of CHIPS.
   */
  constexpr impl::NumeratorMetric set_cookie_partitioned(2798);

  /**
   * generated from networking.speculative_connect_outcome
   */
  enum class SpeculativeConnectOutcomeLabel: uint16_t {
      eSuccessful = 0,
      eAbortedSocketLimit = 1,
      eAbortedSocketFail = 2,
      eAbortedHttpsNotEnabled = 3,
      e__Other__,
    };
  /**
   * Counts the occurrence of each outcome of a speculative connection
   */
  constexpr impl::Labeled<impl::CounterMetric, SpeculativeConnectOutcomeLabel> speculative_connect_outcome(2799);

  /**
   * generated from networking.transaction_wait_time
   */
  /**
   * Time from submission to dispatch of transaction without HTTPS RR (ms)
   */
  constexpr impl::TimingDistributionMetric transaction_wait_time(2800);

  /**
   * generated from networking.transaction_wait_time_https_rr
   */
  /**
   * Time from submission to dispatch of transaction when HTTPS RR is used (ms)
   */
  constexpr impl::TimingDistributionMetric transaction_wait_time_https_rr(2801);

  /**
   * generated from networking.trr_request_count
   */
  enum class TrrRequestCountLabel: uint16_t {
      eRegular = 0,
      ePrivate = 1,
      e__Other__,
    };
  /**
   * The count of successful TRR requests keyed by regular/private browsing
   */
  constexpr impl::Labeled<impl::CounterMetric, TrrRequestCountLabel> trr_request_count(2802);

}
namespace netwerk {
  /**
   * generated from netwerk.early_hints
   */
  enum class EarlyHintsLabel: uint16_t {
      eStylesheet = 0,
      eFonts = 1,
      eScripts = 2,
      eFetch = 3,
      eImage = 4,
      eOther = 5,
      e__Other__,
    };
  /**
   * Counts the different type of resources that are sent for early hints.
   */
  constexpr impl::Labeled<impl::CounterMetric, EarlyHintsLabel> early_hints(2803);

  /**
   * generated from netwerk.eh_link_type
   */
  enum class EhLinkTypeLabel: uint16_t {
      eDnsPrefetch = 0,
      eIcon = 1,
      eModulepreload = 2,
      ePreconnect = 3,
      ePrefetch = 4,
      ePreload = 5,
      ePrerender = 6,
      eStylesheet = 7,
      eOther = 8,
      e__Other__,
    };
  /**
   * Counts different type of link headers that are sent in early hint
   */
  constexpr impl::Labeled<impl::CounterMetric, EhLinkTypeLabel> eh_link_type(2804);

}
namespace network {
  /**
   * generated from network.cache_hit_time
   */
  /**
   * Time to open existing cache entry file. (Migrated from the geckoview metric of
     * the same name).
   */
  constexpr impl::TimingDistributionMetric cache_hit_time(2805);

  /**
   * generated from network.cors_authorization_header
   */
  enum class CorsAuthorizationHeaderLabel: uint16_t {
      eAllowed = 0,
      eDisallowed = 1,
      eCoveredByWildcard = 2,
      e__Other__,
    };
  /**
   * Count how many times we see `Authorization` header in `Access-Control-Request-
     * Headers` header and the possible outcomes.
   */
  constexpr impl::Labeled<impl::CounterMetric, CorsAuthorizationHeaderLabel> cors_authorization_header(2806);

  /**
   * generated from network.data_size_pb_per_type
   */
  enum class DataSizePbPerTypeLabel: uint16_t {
      eTextHtml = 0,
      eTextCss = 1,
      eTextJson = 2,
      eTextPlain = 3,
      eTextJavascript = 4,
      eTextOther = 5,
      eAudio = 6,
      eVideo = 7,
      eMultipart = 8,
      eIcon = 9,
      eImage = 10,
      eOcsp = 11,
      eXpinstall = 12,
      eWasm = 13,
      ePdf = 14,
      eOctetStream = 15,
      eProxy = 16,
      eCompressed = 17,
      eX509 = 18,
      eApplicationOther = 19,
      e__Other__,
    };
  /**
   * Number of KB we transferred keyed by "contentType"
   */
  constexpr impl::Labeled<impl::CounterMetric, DataSizePbPerTypeLabel> data_size_pb_per_type(2807);

  /**
   * generated from network.data_size_per_type
   */
  enum class DataSizePerTypeLabel: uint16_t {
      eTextHtml = 0,
      eTextCss = 1,
      eTextJson = 2,
      eTextPlain = 3,
      eTextJavascript = 4,
      eTextOther = 5,
      eAudio = 6,
      eVideo = 7,
      eMultipart = 8,
      eIcon = 9,
      eImage = 10,
      eOcsp = 11,
      eXpinstall = 12,
      eWasm = 13,
      ePdf = 14,
      eOctetStream = 15,
      eProxy = 16,
      eCompressed = 17,
      eX509 = 18,
      eApplicationOther = 19,
      e__Other__,
    };
  /**
   * Number of KB we transferred keyed by "contentType"
   */
  constexpr impl::Labeled<impl::CounterMetric, DataSizePerTypeLabel> data_size_per_type(2808);

  /**
   * generated from network.dns_end
   */
  /**
   * In the HTTP page channel, time from the DNS request being issued to the
     * response. Corresponds to Legacy histogram HTTP_PAGE_DNS_LOOKUP_TIME in Desktop.
     * (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::TimingDistributionMetric dns_end(2809);

  /**
   * generated from network.dns_start
   */
  /**
   * In the HTTP page channel, time from connection open to the DNS request being
     * issued. Corresponds to Legacy histogram HTTP_PAGE_DNS_ISSUE_TIME in Desktop.
     * (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::TimingDistributionMetric dns_start(2810);

  /**
   * generated from network.first_from_cache
   */
  /**
   * In the HTTP page channel, time from connection open to cache read start.
     * Corresponds to Legacy histogram HTTP_PAGE_OPEN_TO_FIRST_FROM_CACHE_V2 in
     * Desktop.
   */
  constexpr impl::TimingDistributionMetric first_from_cache(2811);

  /**
   * generated from network.font_download_end
   */
  /**
   * Time after navigationStart that all webfont downloads are completed. (Migrated
     * from the geckoview metric of the same name).
   */
  constexpr impl::TimingDistributionMetric font_download_end(2812);

  /**
   * generated from network.tcp_connection
   */
  /**
   * In the HTTP page channel, time from the TCP SYN packet is received to the
     * connection is established and ready for HTTP. Corresponds to Legacy histogram
     * HTTP_PAGE_TCP_CONNECTION_2 in Desktop (Migrated from the geckoview metric of
     * the same name).
   */
  constexpr impl::TimingDistributionMetric tcp_connection(2813);

  /**
   * generated from network.tls_handshake
   */
  /**
   * In the HTTP page channel, time from after the TCP SYN packet is received to the
     * secure connection is established and ready for HTTP. Corresponds to Legacy
     * histogram HTTP_PAGE_TLS_HANDSHAKE in Desktop. (Migrated from the geckoview
     * metric of the same name).
   */
  constexpr impl::TimingDistributionMetric tls_handshake(2814);

}
namespace cert_verifier {
  /**
   * generated from cert_verifier.cert_trust_evaluation_time
   */
  /**
   * Measures how long we take to evaluate the trust status of a certificate.
   */
  constexpr impl::TimingDistributionMetric cert_trust_evaluation_time(2815);

  /**
   * generated from cert_verifier.crlite_status
   */
  enum class CrliteStatusLabel: uint16_t {
      eNoFilter = 0,
      eNotCovered = 1,
      eNotEnrolled = 2,
      eNotRevoked = 3,
      eRevokedInFilter = 4,
      eRevokedInStash = 5,
      e__Other__,
    };
  /**
   * Counts the number of times different CRLite statuses were returned.
   */
  constexpr impl::Labeled<impl::CounterMetric, CrliteStatusLabel> crlite_status(2816);

  /**
   * generated from cert_verifier.trust_obj_count
   */
  /**
   * The total number of trust objects in cert9.db
   */
  constexpr impl::QuantityMetric trust_obj_count(2817);

}
namespace cert_compression {
  /**
   * generated from cert_compression.brotli_saved_bytes
   */
  /**
   * The difference between the length of encoded certificate vs the actual
     * certificate.
   */
  constexpr impl::CustomDistributionMetric brotli_saved_bytes(2818);

  /**
   * generated from cert_compression.failures
   */
  enum class FailuresLabel: uint16_t {
      eZlib = 0,
      eBrotli = 1,
      e__Other__,
    };
  /**
   * The number of times each certificate compression algorithm returned an error.
   */
  constexpr impl::Labeled<impl::CounterMetric, FailuresLabel> failures(2819);

  /**
   * generated from cert_compression.used
   */
  enum class UsedLabel: uint16_t {
      eZlib = 0,
      eBrotli = 1,
      e__Other__,
    };
  /**
   * The number of times each certificate compression algorithm was used.
   */
  constexpr impl::Labeled<impl::CounterMetric, UsedLabel> used(2820);

  /**
   * generated from cert_compression.zlib_saved_bytes
   */
  /**
   * The difference between the length of encoded certificate vs the actual
     * certificate.
   */
  constexpr impl::CustomDistributionMetric zlib_saved_bytes(2821);

}
namespace data_storage {
  /**
   * generated from data_storage.alternate_services
   */
  /**
   * The number of entries stored in the AlternateServices nsIDataStorage
   */
  constexpr impl::QuantityMetric alternate_services(2822);

  /**
   * generated from data_storage.client_auth_remember_list
   */
  /**
   * The number of entries stored in the ClientAuthRememberList nsIDataStorage
   */
  constexpr impl::QuantityMetric client_auth_remember_list(2823);

  /**
   * generated from data_storage.site_security_service_state
   */
  /**
   * The number of entries stored in the SiteSecurityServiceState nsIDataStorage
   */
  constexpr impl::QuantityMetric site_security_service_state(2824);

}
namespace tls {
  /**
   * generated from tls.certificate_verifications
   */
  /**
   * The total number of successful TLS server certificate verifications.
   */
  constexpr impl::DenominatorMetric certificate_verifications(2825);

  /**
   * generated from tls.xyber_intolerance_reason
   */
  enum class XyberIntoleranceReasonLabel: uint16_t {
      ePrConnectResetError = 0,
      ePrEndOfFileError = 1,
      eSslErrorBadHandshakeHashValue = 2,
      eSslErrorBadMacAlert = 3,
      eSslErrorBadMacRead = 4,
      eSslErrorDecodeErrorAlert = 5,
      eSslErrorHandshakeFailed = 6,
      eSslErrorHandshakeFailureAlert = 7,
      eSslErrorHandshakeUnexpectedAlert = 8,
      eSslErrorIllegalParameterAlert = 9,
      eSslErrorInternalErrorAlert = 10,
      eSslErrorKeyExchangeFailure = 11,
      eSslErrorNoCypherOverlap = 12,
      eSslErrorProtocolVersionAlert = 13,
      eSslErrorRxUnexpectedRecordType = 14,
      eSslErrorRxMalformedHybridKeyShare = 15,
      eSslErrorUnsupportedVersion = 16,
      e__Other__,
    };
  /**
   * The error that was returned from a failed TLS 1.3 handshake in which the client
     * sent a Xyber key share (see tlsIntoleranceTelemetryBucket() in
     * nsNSSIOLayer.cpp).
   */
  constexpr impl::Labeled<impl::CounterMetric, XyberIntoleranceReasonLabel> xyber_intolerance_reason(2826);

}
namespace verification_used_cert_from {
  /**
   * generated from verification_used_cert_from.built_in_roots_module
   */
  /**
   * How many successfully-built certificate chains used a certificate from the
     * built-in roots module.
   */
  constexpr impl::NumeratorMetric built_in_roots_module(2827);

  /**
   * generated from verification_used_cert_from.nss_cert_db
   */
  /**
   * How many successfully-built certificate chains used a certificate from the NSS
     * cert DB.
   */
  constexpr impl::NumeratorMetric nss_cert_db(2828);

  /**
   * generated from verification_used_cert_from.preloaded_intermediates
   */
  /**
   * How many successfully-built certificate chains used a certificate from
     * preloaded intermediates.
   */
  constexpr impl::NumeratorMetric preloaded_intermediates(2829);

  /**
   * generated from verification_used_cert_from.third_party_certificates
   */
  /**
   * How many successfully-built certificate chains used a third-party certificate
     * from the OS.
   */
  constexpr impl::NumeratorMetric third_party_certificates(2830);

  /**
   * generated from verification_used_cert_from.tls_handshake
   */
  /**
   * How many successfully-built certificate chains used a certificate from the TLS
     * handshake.
   */
  constexpr impl::NumeratorMetric tls_handshake(2831);

}
namespace bounce_tracking_protection {
  /**
   * generated from bounce.tracking.protection.enabled_at_startup
   */
  /**
   * Keeps track of whether the feature is enabled at startup.
   */
  constexpr impl::BooleanMetric enabled_at_startup(2832);

  /**
   * generated from bounce.tracking.protection.enabled_dry_run_mode_at_startup
   */
  /**
   * Keeps track of whether the feature is enabled and running in dry-run mode at
     * startup.
   */
  constexpr impl::BooleanMetric enabled_dry_run_mode_at_startup(2833);

  /**
   * generated from bounce.tracking.protection.purge_count
   */
  enum class PurgeCountLabel: uint16_t {
      eSuccess = 0,
      eFailure = 1,
      eDry = 2,
      e__Other__,
    };
  /**
   * Counts how often we purge trackers. Giving a high level overview about the
     * effectivness of bounce tracking protection. Allows determining error rate with
     * failure/success label. When in dry mode, we count the purges that would have
     * happened under the dry label.
   */
  constexpr impl::Labeled<impl::CounterMetric, PurgeCountLabel> purge_count(2834);

  /**
   * generated from bounce.tracking.protection.purge_count_classified_tracker
   */
  /**
   * Counts sites purged from BTP that are classified as trackers as part of the
     * following lists: [emailtracking-protection, fingerprinting-protection,
     * socialtracking-protection, tracking-protection]
   */
  constexpr impl::CounterMetric purge_count_classified_tracker(2835);

  /**
   * generated from bounce.tracking.protection.purge_duration
   */
  /**
   * For every purge that is scheduled, we call the ClearDataService to purge
     * persistent storage for each detected bounce tracker. This may do some blocking
     * work on main thread and dispatch some cleanups to other threads. Collect
     * telemetry on how long it takes to clear in the wild to determine whether we
     * need to improve performance here.
   */
  constexpr impl::TimingDistributionMetric purge_duration(2836);

}
namespace background_tasks_rmdir_base {
  /**
   * generated from background_tasks.rmdir.base.elapsed_ms
   */
  /**
   * The amount of time the task took for removing the directories.
   */
  constexpr impl::QuantityMetric elapsed_ms(2837);

  /**
   * generated from background_tasks.rmdir.base.metric_base
   */
  /**
   * The base metric template for removeDirectory.
   */
  constexpr impl::EventMetric<NoExtraKeys> metric_base(2838);

  /**
   * generated from background_tasks.rmdir.base.removal_count
   */
  /**
   * The number of the removed entries at each call, even if the target directory
     * itself couldn't be removed.
   */
  constexpr impl::QuantityMetric removal_count(2839);

  /**
   * generated from background_tasks.rmdir.base.retry_count
   */
  /**
   * The number of retries before the task started removing the child directory.
     * This can happen when the target directory doesn't exist.
   */
  constexpr impl::QuantityMetric retry_count(2840);

  /**
   * generated from background_tasks.rmdir.base.succeeded
   */
  /**
   * Whether the target directory removal succeeded.
   */
  constexpr impl::BooleanMetric succeeded(2841);

  /**
   * generated from background_tasks.rmdir.base.suffix_ever_failed
   */
  /**
   * Whether removing the suffixed directories ever failed.
   */
  constexpr impl::BooleanMetric suffix_ever_failed(2842);

  /**
   * generated from background_tasks.rmdir.base.suffix_removal_count
   */
  /**
   * The number of the removed entries of the suffixed directories.
   */
  constexpr impl::QuantityMetric suffix_removal_count(2843);

  /**
   * generated from background_tasks.rmdir.base.was_first
   */
  /**
   * Whether this task is the first one removing the directory.
   */
  constexpr impl::BooleanMetric was_first(2844);

}
namespace background_tasks_rmdir_http_cache {
  /**
   * generated from background_tasks.rmdir.http_cache.elapsed_ms
   */
  /**
   * The amount of time the task took for removing the directories.
   */
  constexpr impl::QuantityMetric elapsed_ms(2845);

  /**
   * generated from background_tasks.rmdir.http_cache.metric_base
   */
  /**
   * The base metric template for removeDirectory.
   */
  constexpr impl::EventMetric<NoExtraKeys> metric_base(2846);

  /**
   * generated from background_tasks.rmdir.http_cache.removal_count
   */
  /**
   * The number of the removed entries at each call, even if the target directory
     * itself couldn't be removed.
   */
  constexpr impl::QuantityMetric removal_count(2847);

  /**
   * generated from background_tasks.rmdir.http_cache.retry_count
   */
  /**
   * The number of retries before the task started removing the child directory.
     * This can happen when the target directory doesn't exist.
   */
  constexpr impl::QuantityMetric retry_count(2848);

  /**
   * generated from background_tasks.rmdir.http_cache.succeeded
   */
  /**
   * Whether the target directory removal succeeded.
   */
  constexpr impl::BooleanMetric succeeded(2849);

  /**
   * generated from background_tasks.rmdir.http_cache.suffix_ever_failed
   */
  /**
   * Whether removing the suffixed directories ever failed.
   */
  constexpr impl::BooleanMetric suffix_ever_failed(2850);

  /**
   * generated from background_tasks.rmdir.http_cache.suffix_removal_count
   */
  /**
   * The number of the removed entries of the suffixed directories.
   */
  constexpr impl::QuantityMetric suffix_removal_count(2851);

  /**
   * generated from background_tasks.rmdir.http_cache.was_first
   */
  /**
   * Whether this task is the first one removing the directory.
   */
  constexpr impl::BooleanMetric was_first(2852);

}
namespace background_tasks_rmdir_quota {
  /**
   * generated from background_tasks.rmdir.quota.elapsed_ms
   */
  /**
   * The amount of time the task took for removing the directories.
   */
  constexpr impl::QuantityMetric elapsed_ms(2853);

  /**
   * generated from background_tasks.rmdir.quota.metric_base
   */
  /**
   * The base metric template for removeDirectory.
   */
  constexpr impl::EventMetric<NoExtraKeys> metric_base(2854);

  /**
   * generated from background_tasks.rmdir.quota.removal_count
   */
  /**
   * The number of the removed entries at each call, even if the target directory
     * itself couldn't be removed.
   */
  constexpr impl::QuantityMetric removal_count(2855);

  /**
   * generated from background_tasks.rmdir.quota.retry_count
   */
  /**
   * The number of retries before the task started removing the child directory.
     * This can happen when the target directory doesn't exist.
   */
  constexpr impl::QuantityMetric retry_count(2856);

  /**
   * generated from background_tasks.rmdir.quota.succeeded
   */
  /**
   * Whether the target directory removal succeeded.
   */
  constexpr impl::BooleanMetric succeeded(2857);

  /**
   * generated from background_tasks.rmdir.quota.suffix_ever_failed
   */
  /**
   * Whether removing the suffixed directories ever failed.
   */
  constexpr impl::BooleanMetric suffix_ever_failed(2858);

  /**
   * generated from background_tasks.rmdir.quota.suffix_removal_count
   */
  /**
   * The number of the removed entries of the suffixed directories.
   */
  constexpr impl::QuantityMetric suffix_removal_count(2859);

  /**
   * generated from background_tasks.rmdir.quota.was_first
   */
  /**
   * Whether this task is the first one removing the directory.
   */
  constexpr impl::BooleanMetric was_first(2860);

}
namespace relevancy_classify {
  /**
   * generated from relevancy.classify.duration
   */
  /**
   * Record the duration (in ms) of a successful classification.
   */
  constexpr impl::TimingDistributionMetric duration(2861);

  /**
   * generated from relevancy.classify.fail
   */
    struct FailExtra {
      mozilla::Maybe<nsCString> reason;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (reason) {
          extraKeys.AppendElement()->AssignASCII("reason");
          extraValues.EmplaceBack(reason.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Record an event of a failed / aborted user interest classification.
   */
  constexpr impl::EventMetric<FailExtra> fail(2862);

  /**
   * generated from relevancy.classify.succeed
   */
    struct SucceedExtra {
      mozilla::Maybe<uint32_t> inputClassifiedSize;
      mozilla::Maybe<uint32_t> inputInconclusiveSize;
      mozilla::Maybe<uint32_t> inputSize;
      mozilla::Maybe<uint32_t> interestTop1Hits;
      mozilla::Maybe<uint32_t> interestTop2Hits;
      mozilla::Maybe<uint32_t> interestTop3Hits;
      mozilla::Maybe<uint32_t> outputInterestSize;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (inputClassifiedSize) {
          extraKeys.AppendElement()->AssignASCII("input_classified_size");
          extraValues.EmplaceBack(nsPrintfCString("%d", inputClassifiedSize.value()));
        }
        if (inputInconclusiveSize) {
          extraKeys.AppendElement()->AssignASCII("input_inconclusive_size");
          extraValues.EmplaceBack(nsPrintfCString("%d", inputInconclusiveSize.value()));
        }
        if (inputSize) {
          extraKeys.AppendElement()->AssignASCII("input_size");
          extraValues.EmplaceBack(nsPrintfCString("%d", inputSize.value()));
        }
        if (interestTop1Hits) {
          extraKeys.AppendElement()->AssignASCII("interest_top_1_hits");
          extraValues.EmplaceBack(nsPrintfCString("%d", interestTop1Hits.value()));
        }
        if (interestTop2Hits) {
          extraKeys.AppendElement()->AssignASCII("interest_top_2_hits");
          extraValues.EmplaceBack(nsPrintfCString("%d", interestTop2Hits.value()));
        }
        if (interestTop3Hits) {
          extraKeys.AppendElement()->AssignASCII("interest_top_3_hits");
          extraValues.EmplaceBack(nsPrintfCString("%d", interestTop3Hits.value()));
        }
        if (outputInterestSize) {
          extraKeys.AppendElement()->AssignASCII("output_interest_size");
          extraValues.EmplaceBack(nsPrintfCString("%d", outputInterestSize.value()));
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Record an event of a successful user interest classification.
   */
  constexpr impl::EventMetric<SucceedExtra> succeed(2863);

}
namespace cookie_banners {
  /**
   * generated from cookie.banners.cookie_injection_fail
   */
  /**
   * Counts how often the cookie banner is still shown even if we have injected
     * cookies.
   */
  constexpr impl::CounterMetric cookie_injection_fail(2864);

  /**
   * generated from cookie.banners.google_gdpr_choice_cookie
   */
  /**
   * Records the GDPR choice on Google Search based on the "SOCS" cookie of the
     * Google Search domains. The value could be "Accept", "Reject" or "Custom". We
     * use the label to record different choices on different Google domains. We only
     * collect this if the default search engine is Google.
   */
  constexpr impl::Labeled<impl::StringMetric, DynamicLabel> google_gdpr_choice_cookie(2865);

  /**
   * generated from cookie.banners.google_gdpr_choice_cookie_event
   */
    struct GoogleGdprChoiceCookieEventExtra {
      mozilla::Maybe<nsCString> choice;
      mozilla::Maybe<nsCString> region;
      mozilla::Maybe<nsCString> searchDomain;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (choice) {
          extraKeys.AppendElement()->AssignASCII("choice");
          extraValues.EmplaceBack(choice.value());
        }
        if (region) {
          extraKeys.AppendElement()->AssignASCII("region");
          extraValues.EmplaceBack(region.value());
        }
        if (searchDomain) {
          extraKeys.AppendElement()->AssignASCII("search_domain");
          extraValues.EmplaceBack(searchDomain.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded whenever a GDPR choice is made on a Google Search page. We assess the
     * "SOCS" cookie to know the GDPR choice.
   */
  constexpr impl::EventMetric<GoogleGdprChoiceCookieEventExtra> google_gdpr_choice_cookie_event(2866);

  /**
   * generated from cookie.banners.google_gdpr_choice_cookie_event_pbm
   */
    struct GoogleGdprChoiceCookieEventPbmExtra {
      mozilla::Maybe<nsCString> choice;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (choice) {
          extraKeys.AppendElement()->AssignASCII("choice");
          extraValues.EmplaceBack(choice.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded whenever a GDPR choice is made on a Google Search page on private
     * browsing windows. We assess the "SOCS" cookie to know the GDPR choice.
   */
  constexpr impl::EventMetric<GoogleGdprChoiceCookieEventPbmExtra> google_gdpr_choice_cookie_event_pbm(2867);

  /**
   * generated from cookie.banners.normal_window_service_mode
   */
  enum class NormalWindowServiceModeLabel: uint16_t {
      eDisabled = 0,
      eReject = 1,
      eRejectOrAccept = 2,
      eInvalid = 3,
      e__Other__,
    };
  /**
   * The pref value of the cookie banner service mode for normal windows.
   */
  constexpr impl::Labeled<impl::BooleanMetric, NormalWindowServiceModeLabel> normal_window_service_mode(2868);

  /**
   * generated from cookie.banners.private_window_service_mode
   */
  enum class PrivateWindowServiceModeLabel: uint16_t {
      eDisabled = 0,
      eReject = 1,
      eRejectOrAccept = 2,
      eInvalid = 3,
      e__Other__,
    };
  /**
   * The pref value of the cookie banner service mode for private windows.
   */
  constexpr impl::Labeled<impl::BooleanMetric, PrivateWindowServiceModeLabel> private_window_service_mode(2869);

  /**
   * generated from cookie.banners.reload
   */
    struct ReloadExtra {
      mozilla::Maybe<bool> hasClickRule;
      mozilla::Maybe<bool> hasCookieRule;
      mozilla::Maybe<bool> noRule;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (hasClickRule) {
          extraKeys.AppendElement()->AssignASCII("has_click_rule");
          extraValues.AppendElement()->AssignASCII(hasClickRule.value() ? "true" : "false");
        }
        if (hasCookieRule) {
          extraKeys.AppendElement()->AssignASCII("has_cookie_rule");
          extraValues.AppendElement()->AssignASCII(hasCookieRule.value() ? "true" : "false");
        }
        if (noRule) {
          extraKeys.AppendElement()->AssignASCII("no_rule");
          extraValues.AppendElement()->AssignASCII(noRule.value() ? "true" : "false");
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when the top-level page is reloaded. We use this event metric to know
     * whether or not the reloading domain has cookie banner rule.
   */
  constexpr impl::EventMetric<ReloadExtra> reload(2870);

  /**
   * generated from cookie.banners.rule_lookup_by_domain
   */
  enum class RuleLookupByDomainLabel: uint16_t {
      eTopHit = 0,
      eTopHitOptIn = 1,
      eTopHitOptOut = 2,
      eTopMiss = 3,
      eIframeHit = 4,
      eIframeHitOptIn = 5,
      eIframeHitOptOut = 6,
      eIframeMiss = 7,
      eTopCookieHit = 8,
      eTopCookieHitOptIn = 9,
      eTopCookieHitOptOut = 10,
      eTopCookieMiss = 11,
      eIframeCookieHit = 12,
      eIframeCookieHitOptIn = 13,
      eIframeCookieHitOptOut = 14,
      eIframeCookieMiss = 15,
      eTopClickHit = 16,
      eTopClickHitOptIn = 17,
      eTopClickHitOptOut = 18,
      eTopClickMiss = 19,
      eIframeClickHit = 20,
      eIframeClickHitOptIn = 21,
      eIframeClickHitOptOut = 22,
      eIframeClickMiss = 23,
      e__Other__,
    };
  /**
   * Counts the number of hit/miss of cookie banner rule lookups for domain. We
     * collect three types of counters, including counters for overall rule lookup,
     * counters for cookie rule lookup and counters for click rule lookup. We also
     * divide the counter by top-level loads and iframe loads. For each domain, we
     * will only collect once.
   */
  constexpr impl::Labeled<impl::CounterMetric, RuleLookupByDomainLabel> rule_lookup_by_domain(2871);

  /**
   * generated from cookie.banners.rule_lookup_by_load
   */
  enum class RuleLookupByLoadLabel: uint16_t {
      eTopHit = 0,
      eTopHitOptIn = 1,
      eTopHitOptOut = 2,
      eTopMiss = 3,
      eIframeHit = 4,
      eIframeHitOptIn = 5,
      eIframeHitOptOut = 6,
      eIframeMiss = 7,
      eTopCookieHit = 8,
      eTopCookieHitOptIn = 9,
      eTopCookieHitOptOut = 10,
      eTopCookieMiss = 11,
      eIframeCookieHit = 12,
      eIframeCookieHitOptIn = 13,
      eIframeCookieHitOptOut = 14,
      eIframeCookieMiss = 15,
      eTopClickHit = 16,
      eTopClickHitOptIn = 17,
      eTopClickHitOptOut = 18,
      eTopClickMiss = 19,
      eIframeClickHit = 20,
      eIframeClickHitOptIn = 21,
      eIframeClickHitOptOut = 22,
      eIframeClickMiss = 23,
      e__Other__,
    };
  /**
   * Counts the number of hit/miss of cookie banner rule lookups for every load. We
     * collect three types of counters, including counters for overall rule lookup,
     * counters for cookie rule lookup and counters for click rule lookup. We also
     * divide the counter by top-level loads and iframe loads.
   */
  constexpr impl::Labeled<impl::CounterMetric, RuleLookupByLoadLabel> rule_lookup_by_load(2872);

  /**
   * generated from cookie.banners.service_detect_only
   */
  /**
   * Tracks the value of the cookiebanners.service.detectOnly pref.
   */
  constexpr impl::BooleanMetric service_detect_only(2873);

}
namespace cookie_banners_click {
  /**
   * generated from cookie.banners.click.query_selector_run_count_per_window_frame
   */
  /**
   * How often a query selector is run during the lifetime of a sub-frame content
     * window.
   */
  constexpr impl::CustomDistributionMetric query_selector_run_count_per_window_frame(2874);

  /**
   * generated from cookie.banners.click.query_selector_run_count_per_window_top_level
   */
  /**
   * How often a query selector is run during the lifetime of a top-level content
     * window.
   */
  constexpr impl::CustomDistributionMetric query_selector_run_count_per_window_top_level(2875);

  /**
   * generated from cookie.banners.click.query_selector_run_duration_per_window_frame
   */
  /**
   * Total time spent (in microseconds) on running querySelector for the lifetime of
     * a sub-frame content window.
   */
  constexpr impl::CustomDistributionMetric query_selector_run_duration_per_window_frame(2876);

  /**
   * generated from cookie.banners.click.query_selector_run_duration_per_window_top_level
   */
  /**
   * Total time spent (in microseconds) on running querySelector for the lifetime of
     * a top-level content window.
   */
  constexpr impl::CustomDistributionMetric query_selector_run_duration_per_window_top_level(2877);

  /**
   * generated from cookie.banners.click.result
   */
  enum class ResultLabel: uint16_t {
      eSuccess = 0,
      eSuccessCookieInjected = 1,
      eSuccessDomContentLoaded = 2,
      eSuccessMutationPreLoad = 3,
      eSuccessMutationPostLoad = 4,
      eFail = 5,
      eFailBannerNotFound = 6,
      eFailBannerNotVisible = 7,
      eFailButtonNotFound = 8,
      eFailNoRuleForMode = 9,
      eFailActorDestroyed = 10,
      e__Other__,
    };
  /**
   * Given a matching cookie banner rule, how often do we handle or fail to handle
     * cookie banners, labelled by reason. The 'success' and 'fail' counters count the
     * total numbers independently of the reason counters. Counters are incremented
     * after the content window has been destroyed. This metric additionally reports
     * cookie injections after which we didn't see a banner as
     * "success_cookie_injected".
   */
  constexpr impl::Labeled<impl::CounterMetric, ResultLabel> result(2878);

}
namespace cookie_banners_cmp {
  /**
   * generated from cookie.banners.cmp.detected_cmp
   */
  /**
   * Counts how often a specific cmp has been detected by our cookie banner
     * handling.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> detected_cmp(2879);

  /**
   * generated from cookie.banners.cmp.ratio_handled_by_cmp_rule
   */
  /**
   * The proportion of cookie banners handled by CMP rules within the total number
     * of cases handled, including those handled by site-specific rules.
   */
  constexpr impl::RateMetric ratio_handled_by_cmp_rule(2880);

  /**
   * generated from cookie.banners.cmp.result
   */
  enum class ResultLabel: uint16_t {
      eSuccess = 0,
      eSuccessDomContentLoaded = 1,
      eSuccessMutationPreLoad = 2,
      eSuccessMutationPostLoad = 3,
      eFail = 4,
      eFailBannerNotFound = 5,
      eFailBannerNotVisible = 6,
      eFailButtonNotFound = 7,
      eFailNoRuleForMode = 8,
      eFailActorDestroyed = 9,
      e__Other__,
    };
  /**
   * Given a matching CMP rule, how often do we handle or fail to handle cookie
     * banners, labelled by reason. The 'success' and 'fail' counters count the total
     * numbers independently of the reason counters. Counters are incremented after
     * the content window has been destroyed.
   */
  constexpr impl::Labeled<impl::CounterMetric, ResultLabel> result(2881);

}
namespace crash {
  /**
   * generated from crash.app_build
   */
  /**
   * The build id of the application. This may differ from `client_info` because a
     * main process crash may be reported later by a different (e.g. updated) client.
   */
  constexpr impl::StringMetric app_build(2882);

  /**
   * generated from crash.app_channel
   */
  /**
   * The release channel of the application. This may differ from `client_info`
     * because a main process crash may be reported later by a different (e.g.
     * updated) client.
   */
  constexpr impl::StringMetric app_channel(2883);

  /**
   * generated from crash.app_display_version
   */
  /**
   * The version of the application. This may differ from `client_info` because a
     * main process crash may be reported later by a different (e.g. updated) client.
   */
  constexpr impl::StringMetric app_display_version(2884);


  /**
   * generated from crash.background_task_name
   */
  /**
   * The name of the background task if launched as one.
   */
  constexpr impl::StringMetric background_task_name(2886);

  /**
   * generated from crash.event_loop_nesting_level
   */
  /**
   * Indicates the nesting level of the event loop.
   */
  constexpr impl::QuantityMetric event_loop_nesting_level(2887);

  /**
   * generated from crash.font_name
   */
  /**
   * The font family name that is being loaded when the crash occurred.
   */
  constexpr impl::StringMetric font_name(2888);

  /**
   * generated from crash.gpu_process_launch
   */
  /**
   * The number of times that the GPU process was launched.
   */
  constexpr impl::QuantityMetric gpu_process_launch(2889);

  /**
   * generated from crash.ipc_channel_error
   */
  /**
   * The error reason for an ipc-based content crash.
   */
  constexpr impl::StringMetric ipc_channel_error(2890);

  /**
   * generated from crash.is_garbage_collecting
   */
  /**
   * Indicates that the crash occurred while the garbage collector was running.
   */
  constexpr impl::BooleanMetric is_garbage_collecting(2891);

  /**
   * generated from crash.main_thread_runnable_name
   */
  /**
   * Name of the currently executing `nsIRunnable` on the main thread. Nightly-only.
   */
  constexpr impl::StringMetric main_thread_runnable_name(2892);

  /**
   * generated from crash.minidump_sha256_hash
   */
  /**
   * The SHA256 hash of the associated minidump file, if any.
   */
  constexpr impl::StringMetric minidump_sha256_hash(2893);

  /**
   * generated from crash.moz_crash_reason
   */
  /**
   * Contains the string passed to `MOZ_CRASH()`.
   */
  constexpr impl::StringMetric moz_crash_reason(2894);

  /**
   * generated from crash.process_type
   */
  /**
   * The type of process that experienced a crash. See the full list of options
     * [here](https://firefox-source-
     * docs.mozilla.org/toolkit/components/telemetry/data/crash-ping.html#process-
     * types).
   */
  constexpr impl::StringMetric process_type(2895);

  /**
   * generated from crash.profiler_child_shutdown_phase
   */
  /**
   * The shutdown phase of the profiler.
   */
  constexpr impl::StringMetric profiler_child_shutdown_phase(2896);


  /**
   * generated from crash.remote_type
   */
  /**
   * The type of the content process. See the full list of options
     * [here](https://firefox-source-
     * docs.mozilla.org/toolkit/components/telemetry/data/crash-ping.html#remote-
     * process-types).
   */
  constexpr impl::StringMetric remote_type(2898);

  /**
   * generated from crash.shutdown_progress
   */
  /**
   * The shutdown phase in which the crash occurred.
   */
  constexpr impl::StringMetric shutdown_progress(2899);


  /**
   * generated from crash.startup
   */
  /**
   * If true, the crash occurred during process startup.
   */
  constexpr impl::BooleanMetric startup(2901);

  /**
   * generated from crash.time
   */
  /**
   * The time at which the crash occurred.
   */
  constexpr impl::DatetimeMetric time(2902);

}
namespace crash_windows {
  /**
   * generated from crash.windows.error_reporting
   */
  /**
   * Indicates if the crash was intercepted by the Windows Error Reporting runtime
     * exception module.
   */
  constexpr impl::BooleanMetric error_reporting(2903);

  /**
   * generated from crash.windows.file_dialog_error_code
   */
  /**
   * The HRESULT returned from a Win32 system call leading to termination of the
     * file-dialog utility process. MozCrashReason is expected to provide context for
     * the value.
   */
  constexpr impl::StringMetric file_dialog_error_code(2904);

}
namespace crash_submission {
  /**
   * generated from crash_submission.collector_errors
   */
  /**
   * 
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> collector_errors(2905);

  /**
   * generated from crash_submission.failure
   */
  /**
   * 
   */
  constexpr impl::CounterMetric failure(2906);

  /**
   * generated from crash_submission.pending
   */
  /**
   * 
   */
  constexpr impl::CounterMetric pending(2907);

  /**
   * generated from crash_submission.success
   */
  /**
   * 
   */
  constexpr impl::CounterMetric success(2908);

}
namespace dll_blocklist {
  /**
   * generated from dll_blocklist.init_failed
   */
  /**
   * Indicates whether initialization of the DLL blocklist failed.
   */
  constexpr impl::BooleanMetric init_failed(2909);

  /**
   * generated from dll_blocklist.list
   */
  /**
   * A list of blocked DLLs.
   */
  constexpr impl::StringListMetric list(2910);

  /**
   * generated from dll_blocklist.user32_loaded_before
   */
  /**
   * Indicates whether `user32.dll` was loaded before the DLL blocklist was
     * initialized.
   */
  constexpr impl::BooleanMetric user32_loaded_before(2911);

}
namespace environment {
  /**
   * generated from environment.experimental_features
   */
  /**
   * Specifies the enabled experimental features from
     * about:preferences#experimental.
   */
  constexpr impl::StringListMetric experimental_features(2912);

  /**
   * generated from environment.headless_mode
   */
  /**
   * Whether the app was invoked in headless mode via `--headless` or
     * `--backgroundtask`.
   */
  constexpr impl::BooleanMetric headless_mode(2913);

  /**
   * generated from environment.uptime
   */
  /**
   * The start time of the application.
   */
  constexpr impl::TimespanMetric uptime(2914);

}
namespace memory {
  /**
   * generated from memory.available_commit
   */
  /**
   * Available commit size.
   */
  constexpr impl::QuantityMetric available_commit(2915);

  /**
   * generated from memory.available_physical
   */
  /**
   * Available physical memory.
   */
  constexpr impl::QuantityMetric available_physical(2916);

  /**
   * generated from memory.available_swap
   */
  /**
   * Available swap memory.
   */
  constexpr impl::QuantityMetric available_swap(2917);

  /**
   * generated from memory.available_virtual
   */
  /**
   * Available virtual memory.
   */
  constexpr impl::QuantityMetric available_virtual(2918);

  /**
   * generated from memory.low_physical
   */
  /**
   * The number of times the available memory tracker has detected that free
     * physical memory is running low.
   */
  constexpr impl::QuantityMetric low_physical(2919);

  /**
   * generated from memory.oom_allocation_size
   */
  /**
   * The size of the allocation that caused on OOM crash.
   */
  constexpr impl::QuantityMetric oom_allocation_size(2920);

  /**
   * generated from memory.purgeable_physical
   */
  /**
   * The amount of memory that can be deallocated by the OS in case of memory
     * pressure.
   */
  constexpr impl::QuantityMetric purgeable_physical(2921);

  /**
   * generated from memory.system_use_percentage
   */
  /**
   * The percentage of memory in use.
   */
  constexpr impl::QuantityMetric system_use_percentage(2922);

  /**
   * generated from memory.texture
   */
  /**
   * The amount of memory used in textures.
   */
  constexpr impl::QuantityMetric texture(2923);

  /**
   * generated from memory.total_page_file
   */
  /**
   * The total page file size.
   */
  constexpr impl::QuantityMetric total_page_file(2924);

  /**
   * generated from memory.total_physical
   */
  /**
   * The total physical memory.
   */
  constexpr impl::QuantityMetric total_physical(2925);

  /**
   * generated from memory.total_virtual
   */
  /**
   * The total virtual memory.
   */
  constexpr impl::QuantityMetric total_virtual(2926);

}
namespace windows {
  /**
   * generated from windows.package_family_name
   */
  /**
   * The Package Family Name of Firefox, if installed through an MSIX package.
   */
  constexpr impl::StringMetric package_family_name(2927);

}
namespace extensions {
  /**
   * generated from extensions.process_event
   */
  enum class ProcessEventLabel: uint16_t {
      eCrashedBg = 0,
      eCrashedFg = 1,
      eCreatedBg = 2,
      eCreatedFg = 3,
      eCrashedOverThresholdBg = 4,
      eCrashedOverThresholdFg = 5,
      e__Other__,
    };
  /**
   * Counters for how many times the extension process has crashed or been created.
     * The labels with "_fg" / "_bg" suffixes are only recorded in Android builds,
     * while the "created" and "crashed" labels are recorded on both Desktop and
     * Android
     * builds.
   */
  constexpr impl::Labeled<impl::CounterMetric, ProcessEventLabel> process_event(2928);

  /**
   * generated from extensions.startup_cache_load_time
   */
  /**
   * Time to load and deserialize the extensions startupCache data.
   */
  constexpr impl::TimespanMetric startup_cache_load_time(2929);

  /**
   * generated from extensions.startup_cache_read_errors
   */
  /**
   * The number of times an unexpected error has been raised while reading
     * the extensions StartupCache file.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> startup_cache_read_errors(2930);

  /**
   * generated from extensions.startup_cache_write_bytelength
   */
  /**
   * The amount of bytes written to the extensions StartupCache file.
   */
  constexpr impl::QuantityMetric startup_cache_write_bytelength(2931);

  /**
   * generated from extensions.use_remote_policy
   */
  /**
   * Corresponds to the value of `WebExtensionPolicy.useRemoteWebExtensions`.
   */
  constexpr impl::BooleanMetric use_remote_policy(2932);

  /**
   * generated from extensions.use_remote_pref
   */
  /**
   * Corresponds to the value of `extensions.webextensions.remote` pref.
   */
  constexpr impl::BooleanMetric use_remote_pref(2933);

}
namespace extensions_apis_dnr {
  /**
   * generated from extensions.apis.dnr.evaluate_rules_count_max
   */
  /**
   * Max amount of DNR rules being evaluated.
   */
  constexpr impl::QuantityMetric evaluate_rules_count_max(2934);

  /**
   * generated from extensions.apis.dnr.evaluate_rules_time
   */
  /**
   * Amount of time it takes to evaluate DNR rules for one network request.
   */
  constexpr impl::TimingDistributionMetric evaluate_rules_time(2935);

  /**
   * generated from extensions.apis.dnr.startup_cache_entries
   */
  enum class StartupCacheEntriesLabel: uint16_t {
      eHit = 0,
      eMiss = 1,
      e__Other__,
    };
  /**
   * Counters for startup cache data hits or misses on initializating
     * DNR rules for extensions loaded on application startup.
   */
  constexpr impl::Labeled<impl::CounterMetric, StartupCacheEntriesLabel> startup_cache_entries(2936);

  /**
   * generated from extensions.apis.dnr.startup_cache_read_size
   */
  /**
   * Amount of data read from the DNR startup cache file.
   */
  constexpr impl::MemoryDistributionMetric startup_cache_read_size(2937);

  /**
   * generated from extensions.apis.dnr.startup_cache_read_time
   */
  /**
   * Amount of time it takes to read data into the DNR startup cache file.
   */
  constexpr impl::TimingDistributionMetric startup_cache_read_time(2938);

  /**
   * generated from extensions.apis.dnr.startup_cache_write_size
   */
  /**
   * Amount of data written to the DNR startup cache file.
   */
  constexpr impl::MemoryDistributionMetric startup_cache_write_size(2939);

  /**
   * generated from extensions.apis.dnr.startup_cache_write_time
   */
  /**
   * Amount of time it takes to write data into the DNR startup cache file.
   */
  constexpr impl::TimingDistributionMetric startup_cache_write_time(2940);

  /**
   * generated from extensions.apis.dnr.validate_rules_time
   */
  /**
   * Amount of time it takes to validate DNR rules of individual ruleset
     * when dynamic or static rulesets have been loaded from disk.
   */
  constexpr impl::TimingDistributionMetric validate_rules_time(2941);

}
namespace extensions_counters {
  /**
   * generated from extensions.counters.browser_action_preload_result
   */
  enum class BrowserActionPreloadResultLabel: uint16_t {
      ePopupshown = 0,
      eClearafterhover = 1,
      eClearaftermousedown = 2,
      e__Other__,
    };
  /**
   * Number of times an event page hit the idle timeout and results in one of the
     * labels.
   */
  constexpr impl::Labeled<impl::CounterMetric, BrowserActionPreloadResultLabel> browser_action_preload_result(2942);

  /**
   * generated from extensions.counters.event_page_idle_result
   */
  enum class EventPageIdleResultLabel: uint16_t {
      eSuspend = 0,
      eResetOther = 1,
      eResetEvent = 2,
      eResetListeners = 3,
      eResetNativeapp = 4,
      eResetStreamfilter = 5,
      eResetParentapicall = 6,
      ePermissionsRequest = 7,
      eLaunchwebauthflow = 8,
      e__Other__,
    };
  /**
   * Number of times an event page hit the idle timeout and results in one of the
     * labels.
   */
  constexpr impl::Labeled<impl::CounterMetric, EventPageIdleResultLabel> event_page_idle_result(2943);

}
namespace extensions_data {
  /**
   * generated from extensions.data.migrate_result
   */
    struct MigrateResultExtra {
      mozilla::Maybe<nsCString> addonId;
      mozilla::Maybe<nsCString> backend;
      mozilla::Maybe<nsCString> dataMigrated;
      mozilla::Maybe<nsCString> errorName;
      mozilla::Maybe<nsCString> hasJsonfile;
      mozilla::Maybe<nsCString> hasOlddata;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (addonId) {
          extraKeys.AppendElement()->AssignASCII("addon_id");
          extraValues.EmplaceBack(addonId.value());
        }
        if (backend) {
          extraKeys.AppendElement()->AssignASCII("backend");
          extraValues.EmplaceBack(backend.value());
        }
        if (dataMigrated) {
          extraKeys.AppendElement()->AssignASCII("data_migrated");
          extraValues.EmplaceBack(dataMigrated.value());
        }
        if (errorName) {
          extraKeys.AppendElement()->AssignASCII("error_name");
          extraValues.EmplaceBack(errorName.value());
        }
        if (hasJsonfile) {
          extraKeys.AppendElement()->AssignASCII("has_jsonfile");
          extraValues.EmplaceBack(hasJsonfile.value());
        }
        if (hasOlddata) {
          extraKeys.AppendElement()->AssignASCII("has_olddata");
          extraValues.EmplaceBack(hasOlddata.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * These events are sent when an extension is migrating its data to the new
     * IndexedDB backend.
   */
  constexpr impl::EventMetric<MigrateResultExtra> migrate_result(2944);

  /**
   * generated from extensions.data.storage_local_error
   */
    struct StorageLocalErrorExtra {
      mozilla::Maybe<nsCString> addonId;
      mozilla::Maybe<nsCString> errorName;
      mozilla::Maybe<nsCString> method;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (addonId) {
          extraKeys.AppendElement()->AssignASCII("addon_id");
          extraValues.EmplaceBack(addonId.value());
        }
        if (errorName) {
          extraKeys.AppendElement()->AssignASCII("error_name");
          extraValues.EmplaceBack(errorName.value());
        }
        if (method) {
          extraKeys.AppendElement()->AssignASCII("method");
          extraValues.EmplaceBack(method.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * These events are collected when an extension triggers an unexpected error
     * while running a storage.local API call (e.g. because of some underlying
     * QuotaManager and/or IndexedDB error).
   */
  constexpr impl::EventMetric<StorageLocalErrorExtra> storage_local_error(2945);

}
namespace extensions_quarantined_domains {
  /**
   * generated from extensions.quarantined_domains.listhash
   */
  /**
   * SHA1 cryptographic hash of the quarantined domains string pref.
   */
  constexpr impl::StringMetric listhash(2946);

  /**
   * generated from extensions.quarantined_domains.listsize
   */
  /**
   * Number of domains listed in the quarantined domains list pref for the client
     * during this session.
   */
  constexpr impl::QuantityMetric listsize(2947);

  /**
   * generated from extensions.quarantined_domains.remotehash
   */
  /**
   * SHA1 cryptographic hash of the quarantined domains string pref as it was set
     * based on the value got synced from the RemoteSettings collection.
     * AMRemoteSettings will be re-processing the entries on the next application
     * startup and so this metric lifetime can be set to application and expect it to
     * be always set to the value got from the RemoteSettings collection.
   */
  constexpr impl::StringMetric remotehash(2948);

}
namespace extensions_timing {
  /**
   * generated from extensions.timing.background_page_load
   */
  /**
   * Amount of time it takes to load a WebExtensions background page, from when the
     * build function is called to when the page has finished processing the onload
     * event.
   */
  constexpr impl::TimingDistributionMetric background_page_load(2949);

  /**
   * generated from extensions.timing.browser_action_popup_open
   */
  /**
   * Amount of time it takes for a BrowserAction popup to open.
   */
  constexpr impl::TimingDistributionMetric browser_action_popup_open(2950);

  /**
   * generated from extensions.timing.content_script_injection
   */
  /**
   * Amount of time it takes for content scripts from a WebExtension to be injected
     * into a window.
   */
  constexpr impl::TimingDistributionMetric content_script_injection(2951);

  /**
   * generated from extensions.timing.event_page_running_time
   */
  /**
   * Amount of time (keyed by addon id) that an event page has been running before
     * being suspended,
     * or the entire addon shutdown.
   */
  constexpr impl::CustomDistributionMetric event_page_running_time(2952);

  /**
   * generated from extensions.timing.extension_startup
   */
  /**
   * Amount of time it takes for a WebExtension to start up, from when the
     * startup function is called to when the startup promise resolves.
   */
  constexpr impl::TimingDistributionMetric extension_startup(2953);

  /**
   * generated from extensions.timing.page_action_popup_open
   */
  /**
   * Amount of time it takes for a PageAction popup to open.
   */
  constexpr impl::TimingDistributionMetric page_action_popup_open(2954);

  /**
   * generated from extensions.timing.storage_local_get_idb
   */
  /**
   * Amount of time it takes to perform a get via storage.local using the IndexedDB
     * backend.
   */
  constexpr impl::TimingDistributionMetric storage_local_get_idb(2955);

  /**
   * generated from extensions.timing.storage_local_set_idb
   */
  /**
   * Amount of time it takes to perform a set via storage.local using the Indexed
     * backend.
   */
  constexpr impl::TimingDistributionMetric storage_local_set_idb(2956);

}
namespace formautofill {
  /**
   * generated from formautofill.form_submission_heuristic
   */
  enum class FormSubmissionHeuristicLabel: uint16_t {
      eFormSubmitEvent = 0,
      eFormRemovalAfterFetch = 1,
      ePageNavigation = 2,
      eIframePagehide = 3,
      e__Other__,
    };
  /**
   * The heuristic that detected the form submission.
   */
  constexpr impl::Labeled<impl::CounterMetric, FormSubmissionHeuristicLabel> form_submission_heuristic(2957);

}
namespace formautofill_creditcards {
  /**
   * generated from formautofill.creditcards.autofill_profiles_count
   */
  /**
   * Count at store time how many credit card autofill profiles the user has.
   */
  constexpr impl::QuantityMetric autofill_profiles_count(2958);

  /**
   * generated from formautofill.creditcards.form_cleared
   */
    struct FormClearedExtra {
      mozilla::Maybe<nsCString> fieldName;
      mozilla::Maybe<nsCString> flowId;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (fieldName) {
          extraKeys.AppendElement()->AssignASCII("field_name");
          extraValues.EmplaceBack(fieldName.value());
        }
        if (flowId) {
          extraKeys.AppendElement()->AssignASCII("flow_id");
          extraValues.EmplaceBack(flowId.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when a credit card form is cleared . The flow id indicates an
     * interaction session with the a form and is shared across cc_form events. The
     * field_name is used to record the field that triggers this event
   */
  constexpr impl::EventMetric<FormClearedExtra> form_cleared(2959);

  /**
   * generated from formautofill.creditcards.form_detected
   */
    struct FormDetectedExtra {
      mozilla::Maybe<nsCString> ccExp;
      mozilla::Maybe<nsCString> ccExpMonth;
      mozilla::Maybe<nsCString> ccExpYear;
      mozilla::Maybe<nsCString> ccName;
      mozilla::Maybe<nsCString> ccNumber;
      mozilla::Maybe<uint32_t> ccNumberMultiParts;
      mozilla::Maybe<nsCString> ccType;
      mozilla::Maybe<nsCString> flowId;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (ccExp) {
          extraKeys.AppendElement()->AssignASCII("cc_exp");
          extraValues.EmplaceBack(ccExp.value());
        }
        if (ccExpMonth) {
          extraKeys.AppendElement()->AssignASCII("cc_exp_month");
          extraValues.EmplaceBack(ccExpMonth.value());
        }
        if (ccExpYear) {
          extraKeys.AppendElement()->AssignASCII("cc_exp_year");
          extraValues.EmplaceBack(ccExpYear.value());
        }
        if (ccName) {
          extraKeys.AppendElement()->AssignASCII("cc_name");
          extraValues.EmplaceBack(ccName.value());
        }
        if (ccNumber) {
          extraKeys.AppendElement()->AssignASCII("cc_number");
          extraValues.EmplaceBack(ccNumber.value());
        }
        if (ccNumberMultiParts) {
          extraKeys.AppendElement()->AssignASCII("cc_number_multi_parts");
          extraValues.EmplaceBack(nsPrintfCString("%d", ccNumberMultiParts.value()));
        }
        if (ccType) {
          extraKeys.AppendElement()->AssignASCII("cc_type");
          extraValues.EmplaceBack(ccType.value());
        }
        if (flowId) {
          extraKeys.AppendElement()->AssignASCII("flow_id");
          extraValues.EmplaceBack(flowId.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when a form is recognized as a credit card form. The possible value of
     * cc_* are "autocomplete", "undetected", "regexp" or an integer between 0-100:
     *   - When the value is "autocomplete", the field is identified via autocomplete
     * attribute
     *   - When the value is "undetected", the field is not detected in the form
     *   - When the value is "regexp", then the field is identified by regexp-based
     * heuristic
     *   - When the value is an integer greater than 0, the value indicates the
     * confidence value from fathom (normalized to 0-100)
     * The flow id points to an interaction session with a credit card form and is
     * shared across cc_form events .
   */
  constexpr impl::EventMetric<FormDetectedExtra> form_detected(2960);

  /**
   * generated from formautofill.creditcards.form_filled
   */
    struct FormFilledExtra {
      mozilla::Maybe<nsCString> ccExp;
      mozilla::Maybe<nsCString> ccExpMonth;
      mozilla::Maybe<nsCString> ccExpYear;
      mozilla::Maybe<nsCString> ccName;
      mozilla::Maybe<nsCString> ccNumber;
      mozilla::Maybe<nsCString> ccType;
      mozilla::Maybe<nsCString> flowId;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (ccExp) {
          extraKeys.AppendElement()->AssignASCII("cc_exp");
          extraValues.EmplaceBack(ccExp.value());
        }
        if (ccExpMonth) {
          extraKeys.AppendElement()->AssignASCII("cc_exp_month");
          extraValues.EmplaceBack(ccExpMonth.value());
        }
        if (ccExpYear) {
          extraKeys.AppendElement()->AssignASCII("cc_exp_year");
          extraValues.EmplaceBack(ccExpYear.value());
        }
        if (ccName) {
          extraKeys.AppendElement()->AssignASCII("cc_name");
          extraValues.EmplaceBack(ccName.value());
        }
        if (ccNumber) {
          extraKeys.AppendElement()->AssignASCII("cc_number");
          extraValues.EmplaceBack(ccNumber.value());
        }
        if (ccType) {
          extraKeys.AppendElement()->AssignASCII("cc_type");
          extraValues.EmplaceBack(ccType.value());
        }
        if (flowId) {
          extraKeys.AppendElement()->AssignASCII("flow_id");
          extraValues.EmplaceBack(flowId.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when a credit card form is autofilled. The flow id indicates an
     * interaction session with the a form and is shared across cc_form events. The
     * possible value of cc_* are `filled`, `not_filled`, `user_filled` or
     * `unavailable`
   */
  constexpr impl::EventMetric<FormFilledExtra> form_filled(2961);

  /**
   * generated from formautofill.creditcards.form_filled_modified
   */
    struct FormFilledModifiedExtra {
      mozilla::Maybe<nsCString> fieldName;
      mozilla::Maybe<nsCString> flowId;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (fieldName) {
          extraKeys.AppendElement()->AssignASCII("field_name");
          extraValues.EmplaceBack(fieldName.value());
        }
        if (flowId) {
          extraKeys.AppendElement()->AssignASCII("flow_id");
          extraValues.EmplaceBack(flowId.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when a field in a credit card form is autofilled and then modified by
     * the user. The flow id indicates an interaction session with the a form and is
     * shared across cc_form events. The field_name is used to record the field that
     * triggers this event.
   */
  constexpr impl::EventMetric<FormFilledModifiedExtra> form_filled_modified(2962);

  /**
   * generated from formautofill.creditcards.form_popup_shown
   */
    struct FormPopupShownExtra {
      mozilla::Maybe<nsCString> fieldName;
      mozilla::Maybe<nsCString> flowId;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (fieldName) {
          extraKeys.AppendElement()->AssignASCII("field_name");
          extraValues.EmplaceBack(fieldName.value());
        }
        if (flowId) {
          extraKeys.AppendElement()->AssignASCII("flow_id");
          extraValues.EmplaceBack(flowId.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when autofill popup is shown for a credit card form. The flow id
     * indicates an interaction session with the a form and is shared across cc_form
     * events. The field_name is used to record the field that triggers this event.
   */
  constexpr impl::EventMetric<FormPopupShownExtra> form_popup_shown(2963);

  /**
   * generated from formautofill.creditcards.form_submitted
   */
    struct FormSubmittedExtra {
      mozilla::Maybe<nsCString> ccExp;
      mozilla::Maybe<nsCString> ccExpMonth;
      mozilla::Maybe<nsCString> ccExpYear;
      mozilla::Maybe<nsCString> ccName;
      mozilla::Maybe<nsCString> ccNumber;
      mozilla::Maybe<nsCString> ccType;
      mozilla::Maybe<nsCString> flowId;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (ccExp) {
          extraKeys.AppendElement()->AssignASCII("cc_exp");
          extraValues.EmplaceBack(ccExp.value());
        }
        if (ccExpMonth) {
          extraKeys.AppendElement()->AssignASCII("cc_exp_month");
          extraValues.EmplaceBack(ccExpMonth.value());
        }
        if (ccExpYear) {
          extraKeys.AppendElement()->AssignASCII("cc_exp_year");
          extraValues.EmplaceBack(ccExpYear.value());
        }
        if (ccName) {
          extraKeys.AppendElement()->AssignASCII("cc_name");
          extraValues.EmplaceBack(ccName.value());
        }
        if (ccNumber) {
          extraKeys.AppendElement()->AssignASCII("cc_number");
          extraValues.EmplaceBack(ccNumber.value());
        }
        if (ccType) {
          extraKeys.AppendElement()->AssignASCII("cc_type");
          extraValues.EmplaceBack(ccType.value());
        }
        if (flowId) {
          extraKeys.AppendElement()->AssignASCII("flow_id");
          extraValues.EmplaceBack(flowId.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when a credit card form is submitted. The flow id indicates an
     * interaction session with the a form and is shared across cc_form events. The
     * possible value of cc_* are `autofilled`, `user_filled` or `unavailable`
   */
  constexpr impl::EventMetric<FormSubmittedExtra> form_submitted(2964);

}
namespace fog {
  /**
   * generated from fog.failed_idle_registration
   */
  /**
   * True if we failed to register with the idle service. Absent otherwise.
     * Means IPC probably isn't working well.
     * Child-process data will likely be absent, or incomplete.
   */
  constexpr impl::BooleanMetric failed_idle_registration(2965);

  /**
   * generated from fog.initialization
   */
  /**
   * Time the FOG initialization takes.
   */
  constexpr impl::TimespanMetric initialization(2966);

  /**
   * generated from fog.inits_during_shutdown
   */
  /**
   * Counts the number of times init had to be called during shutdown.
     * Should never have a value for any session long enough to grow idle.
   */
  constexpr impl::CounterMetric inits_during_shutdown(2967);

  /**
   * generated from fog.max_pings_per_minute
   */
  /**
   * Value of the configurable rate limit, in pings per minute, for Glean pings as
     * set at init.
   */
  constexpr impl::QuantityMetric max_pings_per_minute(2968);

}
namespace fog_ipc {
  /**
   * generated from fog.ipc.buffer_sizes
   */
  /**
   * The number and size of the IPC buffers being received over FOG IPC.
   */
  constexpr impl::MemoryDistributionMetric buffer_sizes(2969);

  /**
   * generated from fog.ipc.flush_durations
   */
  /**
   * The length of time between asking the child processes for their
     * IPC buffers and all of them being received by the parent.
   */
  constexpr impl::TimingDistributionMetric flush_durations(2970);

  /**
   * generated from fog.ipc.flush_failures
   */
  /**
   * The number of times we failed to flush all non-parent-process data,
     * throwing even partial results into the trash.
     * If this number is high, we might consider writing custom `MozPromise`-
     * handling code instead of using `MozPromise::All`.
   */
  constexpr impl::CounterMetric flush_failures(2971);

  /**
   * generated from fog.ipc.replay_failures
   */
  /**
   * The number of times the ipc buffer failed to be replayed in the
     * parent process.
   */
  constexpr impl::CounterMetric replay_failures(2972);

  /**
   * generated from fog.ipc.shutdown_registration_failures
   */
  /**
   * The number of times we tried to register shutdown flush routines for
     * content child processes, and failed (probably because there was no main
     * thread).
     * As a result there may be data loss from content child processes.
     * Large or rising number of clients experiencing this indicates we should
     * perhaps refactor content child shutdown in FOG to try harder to register
     * flush operations.
     * Will likely be obsoleted by bug 1641989.
   */
  constexpr impl::CounterMetric shutdown_registration_failures(2973);

}
namespace test_only {
  /**
   * generated from test_only.bad_code
   */
  /**
   * Number of times we encountered bad code.
     * This is a test-only metric.
   */
  constexpr impl::CounterMetric bad_code(2974);


  /**
   * generated from test_only.can_we_flag_it
   */
  /**
   * Test metric for a boolean.
     * This is a test-only metric.
   */
  constexpr impl::BooleanMetric can_we_flag_it(2976);

  /**
   * generated from test_only.can_we_time_it
   */
  /**
   * Test metric for a timespan.
     * This is a test-only metric.
   */
  constexpr impl::TimespanMetric can_we_time_it(2977);

  /**
   * generated from test_only.cheesy_string
   */
  /**
   * Only the cheesiest of strings.
     * This is a test-only metric.
   */
  constexpr impl::StringMetric cheesy_string(2978);

  /**
   * generated from test_only.cheesy_string_list
   */
  /**
   * Only the cheesiest of strings. In list form!
     * This is a test-only metric.
   */
  constexpr impl::StringListMetric cheesy_string_list(2979);


  /**
   * generated from test_only.do_you_remember
   */
  /**
   * They say it's the second thing to go.
     * This is a test-only metric.
   */
  constexpr impl::MemoryDistributionMetric do_you_remember(2981);

  /**
   * generated from test_only.mabels_balloon_labels
   */
  enum class MabelsBalloonLabelsLabel: uint16_t {
      eCelebratory = 0,
      eCelebratoryAndSnarky = 1,
      e__Other__,
    };
  /**
   * How does Mabel label her balloons?
     * This is a test-only metric.
   */
  constexpr impl::Labeled<impl::StringMetric, MabelsBalloonLabelsLabel> mabels_balloon_labels(2982);

  /**
   * generated from test_only.mabels_balloon_strings
   */
  /**
   * What do the labeled Mabel's liked balloons' strings say?
     * This is a test-only metric.
   */
  constexpr impl::Labeled<impl::StringMetric, DynamicLabel> mabels_balloon_strings(2983);

  /**
   * generated from test_only.mabels_bathroom_counters
   */
  /**
   * Counts Mabels labeled by their bathroom counters.
     * This is a test-only metric.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> mabels_bathroom_counters(2984);

  /**
   * generated from test_only.mabels_kitchen_counters
   */
  /**
   * Counts Mabels labeled by their kitchen counters.
     * This is a test-only metric.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> mabels_kitchen_counters(2985);

  /**
   * generated from test_only.mabels_label_maker
   */
  /**
   * Mabel just got a label maker and wants to party like it's
     * 1999.
     * This is a test-only metric.
   */
  constexpr impl::Labeled<impl::StringMetric, DynamicLabel> mabels_label_maker(2986);

  /**
   * generated from test_only.mabels_labeled_counters
   */
  enum class MabelsLabeledCountersLabel: uint16_t {
      eNextToTheFridge = 0,
      eClean = 1,
      e1stCounter = 2,
      e__Other__,
    };
  /**
   * Counts Mabels labeled by their kitchen counters.
     * Now with static labels.
     * This is a test-only metric.
   */
  constexpr impl::Labeled<impl::CounterMetric, MabelsLabeledCountersLabel> mabels_labeled_counters(2987);

  /**
   * generated from test_only.mabels_like_balloons
   */
  /**
   * Does the labeled Mabel like balloons?
     * This is a test-only metric.
   */
  constexpr impl::Labeled<impl::BooleanMetric, DynamicLabel> mabels_like_balloons(2988);

  /**
   * generated from test_only.mabels_like_labeled_balloons
   */
  enum class MabelsLikeLabeledBalloonsLabel: uint16_t {
      eWater = 0,
      eBirthdayParty = 1,
      e__Other__,
    };
  /**
   * Does the labeled Mabel like balloons?
     * This is a test-only metric.
   */
  constexpr impl::Labeled<impl::BooleanMetric, MabelsLikeLabeledBalloonsLabel> mabels_like_labeled_balloons(2989);

  /**
   * generated from test_only.meaning_of_life
   */
  /**
   * Measures the one true answer to the Ultimate Question of Life,
     * the Universe, and Everything.
     * Approximately.
     * This is a test-only metric.
   */
  constexpr impl::QuantityMetric meaning_of_life(2990);

  /**
   * generated from test_only.mirror_time
   */
  /**
   * Mirrored metric for a timespan.
     * This is a test-only metric.
   */
  constexpr impl::TimespanMetric mirror_time(2991);

  /**
   * generated from test_only.mirror_time_nanos
   */
  /**
   * Mirrored metric for a timespan.
     * This is a test-only metric.
   */
  constexpr impl::TimespanMetric mirror_time_nanos(2992);

  /**
   * generated from test_only.mirrors_for_labeled_bools
   */
  /**
   * Mirrored metric.
     * This is a test-only metric.
   */
  constexpr impl::Labeled<impl::BooleanMetric, DynamicLabel> mirrors_for_labeled_bools(2993);

  /**
   * generated from test_only.one_ping_one_bool
   */
  /**
   * One bool for one ping only.
     * This is a test-only metric.
   */
  constexpr impl::BooleanMetric one_ping_one_bool(2994);

  /**
   * generated from test_only.what_a_date
   */
  /**
   * ...To be writing FOG code. This is a test-only metric.
   */
  constexpr impl::DatetimeMetric what_a_date(2995);

  /**
   * generated from test_only.what_id_it
   */
  /**
   * Just a UUID.
     * This is a test-only metric.
   */
  constexpr impl::UuidMetric what_id_it(2996);

  /**
   * generated from test_only.what_time_is_it
   */
  /**
   * Adheres to at least two of the top ten fallacies programmers believe
     * about time.
     * This is a test-only metric.
   */
  constexpr impl::TimingDistributionMetric what_time_is_it(2997);

}
namespace test_only_ipc {
  /**
   * generated from test_only.ipc.a_bool
   */
  /**
   * This is a test-only metric.
     * Just flagging things.
   */
  constexpr impl::BooleanMetric a_bool(2998);

  /**
   * generated from test_only.ipc.a_counter
   */
  /**
   * This is a test-only metric.
     * Just counting things.
   */
  constexpr impl::CounterMetric a_counter(2999);

  /**
   * generated from test_only.ipc.a_custom_dist
   */
  /**
   * This is a test-only metric.
     * Just measuring samples.
   */
  constexpr impl::CustomDistributionMetric a_custom_dist(3000);

  /**
   * generated from test_only.ipc.a_date
   */
  /**
   * This is a test-only metric.
     * Just putting things on the calendar.
   */
  constexpr impl::DatetimeMetric a_date(3001);

  /**
   * generated from test_only.ipc.a_labeled_counter
   */
  /**
   * This is a test-only metric.
     * Just counting labeled things.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> a_labeled_counter(3002);

  /**
   * generated from test_only.ipc.a_memory_dist
   */
  /**
   * This is a test-only metric.
     * Just measuring memory.
   */
  constexpr impl::MemoryDistributionMetric a_memory_dist(3003);

  /**
   * generated from test_only.ipc.a_quantity
   */
  /**
   * This is a test-only metric.
     * Just quantifying things.
   */
  constexpr impl::QuantityMetric a_quantity(3004);

  /**
   * generated from test_only.ipc.a_string
   */
  /**
   * This is a test-only metric.
     * Just setting some strings.
   */
  constexpr impl::StringMetric a_string(3005);

  /**
   * generated from test_only.ipc.a_string_list
   */
  /**
   * This is a test-only metric.
     * Just appending some strings.
   */
  constexpr impl::StringListMetric a_string_list(3006);

  /**
   * generated from test_only.ipc.a_text
   */
  /**
   * This is a test-only metric.
     * For holding Text data.
   */
  constexpr impl::TextMetric a_text(3007);

  /**
   * generated from test_only.ipc.a_timing_dist
   */
  /**
   * This is a test-only metric.
     * Just measuring time.
   */
  constexpr impl::TimingDistributionMetric a_timing_dist(3008);

  /**
   * generated from test_only.ipc.a_url
   */
  /**
   * This is a test-only metric.
     * Just setting some Urls.
   */
  constexpr impl::UrlMetric a_url(3009);

  /**
   * generated from test_only.ipc.a_uuid
   */
  /**
   * This is a test-only metric.
     * Just recording some unique identifiers.
   */
  constexpr impl::UuidMetric a_uuid(3010);

  /**
   * generated from test_only.ipc.an_event
   */
    struct AnEventExtra {
      mozilla::Maybe<nsCString> extra1;
      mozilla::Maybe<nsCString> extra2;
      mozilla::Maybe<nsCString> value;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (extra1) {
          extraKeys.AppendElement()->AssignASCII("extra1");
          extraValues.EmplaceBack(extra1.value());
        }
        if (extra2) {
          extraKeys.AppendElement()->AssignASCII("extra2");
          extraValues.EmplaceBack(extra2.value());
        }
        if (value) {
          extraKeys.AppendElement()->AssignASCII("value");
          extraValues.EmplaceBack(value.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * This is a test-only metric.
     * Just recording some events.
   */
  constexpr impl::EventMetric<AnEventExtra> an_event(3011);

  /**
   * generated from test_only.ipc.an_external_denominator
   */
  /**
   * This is a test-only metric.
     * A denominator not from around here.
   */
  constexpr impl::DenominatorMetric an_external_denominator(3012);

  /**
   * generated from test_only.ipc.another_labeled_counter
   */
  /**
   * This is a test-only metric.
     * Just another metric counting labeled things.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> another_labeled_counter(3013);

  /**
   * generated from test_only.ipc.event_with_extra
   */
    struct EventWithExtraExtra {
      mozilla::Maybe<nsCString> extra1;
      mozilla::Maybe<uint32_t> extra2;
      mozilla::Maybe<bool> extra3LongerName;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (extra1) {
          extraKeys.AppendElement()->AssignASCII("extra1");
          extraValues.EmplaceBack(extra1.value());
        }
        if (extra2) {
          extraKeys.AppendElement()->AssignASCII("extra2");
          extraValues.EmplaceBack(nsPrintfCString("%d", extra2.value()));
        }
        if (extra3LongerName) {
          extraKeys.AppendElement()->AssignASCII("extra3_longer_name");
          extraValues.AppendElement()->AssignASCII(extra3LongerName.value() ? "true" : "false");
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * This is a test-only metric.
     * Just recording some events.
   */
  constexpr impl::EventMetric<EventWithExtraExtra> event_with_extra(3014);

  /**
   * generated from test_only.ipc.irate
   */
  /**
   * This is a test-only metric.
     * A rate that isn't happy about it.
   */
  constexpr impl::RateMetric irate(3015);

  /**
   * generated from test_only.ipc.no_extra_event
   */
  /**
   * This is a test-only metric.
     * Just recording some events without the extra fuss.
   */
  constexpr impl::EventMetric<NoExtraKeys> no_extra_event(3016);

  /**
   * generated from test_only.ipc.rate_with_external_denominator
   */
  /**
   * This is a test-only metric.
     * A rate with a denominator that is Out There.
   */
  constexpr impl::NumeratorMetric rat