/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/toolkit/components/contentanalysis/nsIContentAnalysis.idl
 */

#ifndef __gen_nsIContentAnalysis_h__
#define __gen_nsIContentAnalysis_h__


#include "nsISupports.h"

#include "nsTArray.h"

#include "js/Value.h"

#include "js/GCAnnotations.h"

#include "mozilla/AlreadyAddRefed.h"
#include "mozilla/Assertions.h"
#include "mozilla/DebugOnly.h"

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIURI; /* forward declaration */

namespace mozilla {
namespace dom {
class BrowsingContext; /* webidl BrowsingContext */
} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {
class DragEvent; /* webidl DragEvent */
} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {
class WindowGlobalParent; /* webidl WindowGlobalParent */
} // namespace dom
} // namespace mozilla


/* starting interface:    nsIContentAnalysisAcknowledgement */
#define NS_ICONTENTANALYSISACKNOWLEDGEMENT_IID_STR "06e6a60f-3a2b-41fa-a63b-fea7a7f71649"

#define NS_ICONTENTANALYSISACKNOWLEDGEMENT_IID \
  {0x06e6a60f, 0x3a2b, 0x41fa, \
    { 0xa6, 0x3b, 0xfe, 0xa7, 0xa7, 0xf7, 0x16, 0x49 }}

class NS_NO_VTABLE nsIContentAnalysisAcknowledgement : public nsISupports {
 public:

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_ICONTENTANALYSISACKNOWLEDGEMENT_IID)

  /* Used by ToJSValue to check which scriptable interface is implemented. */
  using ScriptableInterfaceType = nsIContentAnalysisAcknowledgement;

  enum Result : uint32_t {
    eSuccess = 1,
    eInvalidResponse = 2,
    eTooLate = 3,
  };

  /* readonly attribute nsIContentAnalysisAcknowledgement_Result result; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetResult(nsIContentAnalysisAcknowledgement::Result *aResult) = 0;

  enum FinalAction : uint32_t {
    eUnspecified = 0,
    eAllow = 1,
    eReportOnly = 2,
    eWarn = 3,
    eBlock = 4,
  };

  /* readonly attribute nsIContentAnalysisAcknowledgement_FinalAction finalAction; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetFinalAction(nsIContentAnalysisAcknowledgement::FinalAction *aFinalAction) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsIContentAnalysisAcknowledgement, NS_ICONTENTANALYSISACKNOWLEDGEMENT_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSICONTENTANALYSISACKNOWLEDGEMENT \
  NS_IMETHOD GetResult(nsIContentAnalysisAcknowledgement::Result *aResult) override; \
  NS_IMETHOD GetFinalAction(nsIContentAnalysisAcknowledgement::FinalAction *aFinalAction) override; 

/* Use this macro when declaring the members of this interface when the
   class doesn't implement the interface. This is useful for forwarding. */
#define NS_DECL_NON_VIRTUAL_NSICONTENTANALYSISACKNOWLEDGEMENT \
  nsresult GetResult(nsIContentAnalysisAcknowledgement::Result *aResult); \
  nsresult GetFinalAction(nsIContentAnalysisAcknowledgement::FinalAction *aFinalAction); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSICONTENTANALYSISACKNOWLEDGEMENT(_to) \
  NS_IMETHOD GetResult(nsIContentAnalysisAcknowledgement::Result *aResult) override { return _to GetResult(aResult); } \
  NS_IMETHOD GetFinalAction(nsIContentAnalysisAcknowledgement::FinalAction *aFinalAction) override { return _to GetFinalAction(aFinalAction); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSICONTENTANALYSISACKNOWLEDGEMENT(_to) \
  NS_IMETHOD GetResult(nsIContentAnalysisAcknowledgement::Result *aResult) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetResult(aResult); } \
  NS_IMETHOD GetFinalAction(nsIContentAnalysisAcknowledgement::FinalAction *aFinalAction) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetFinalAction(aFinalAction); } 


/* starting interface:    nsIContentAnalysisResponse */
#define NS_ICONTENTANALYSISRESPONSE_IID_STR "89088c61-15f6-4ace-a880-a1b5ea47ca66"

#define NS_ICONTENTANALYSISRESPONSE_IID \
  {0x89088c61, 0x15f6, 0x4ace, \
    { 0xa8, 0x80, 0xa1, 0xb5, 0xea, 0x47, 0xca, 0x66 }}

class NS_NO_VTABLE nsIContentAnalysisResponse : public nsISupports {
 public:

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_ICONTENTANALYSISRESPONSE_IID)

  /* Used by ToJSValue to check which scriptable interface is implemented. */
  using ScriptableInterfaceType = nsIContentAnalysisResponse;

  enum Action : uint32_t {
    eUnspecified = 0,
    eReportOnly = 1,
    eWarn = 2,
    eBlock = 3,
    eAllow = 1000,
    eCanceled = 1001,
  };

  enum CancelError : uint32_t {
    eUserInitiated = 0,
    eNoAgent = 1,
    eInvalidAgentSignature = 2,
    eErrorOther = 3,
  };

  /* readonly attribute nsIContentAnalysisResponse_Action action; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetAction(nsIContentAnalysisResponse::Action *aAction) = 0;

  /* readonly attribute boolean shouldAllowContent; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetShouldAllowContent(bool *aShouldAllowContent) = 0;

  /* readonly attribute nsIContentAnalysisResponse_CancelError cancelError; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetCancelError(nsIContentAnalysisResponse::CancelError *aCancelError) = 0;

  /* readonly attribute ACString requestToken; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetRequestToken(nsACString& aRequestToken) = 0;

  /* readonly attribute boolean isCachedResponse; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetIsCachedResponse(bool *aIsCachedResponse) = 0;

  /* void acknowledge (in nsIContentAnalysisAcknowledgement aCaa); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD Acknowledge(nsIContentAnalysisAcknowledgement *aCaa) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsIContentAnalysisResponse, NS_ICONTENTANALYSISRESPONSE_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSICONTENTANALYSISRESPONSE \
  NS_IMETHOD GetAction(nsIContentAnalysisResponse::Action *aAction) override; \
  NS_IMETHOD GetShouldAllowContent(bool *aShouldAllowContent) override; \
  NS_IMETHOD GetCancelError(nsIContentAnalysisResponse::CancelError *aCancelError) override; \
  NS_IMETHOD GetRequestToken(nsACString& aRequestToken) override; \
  NS_IMETHOD GetIsCachedResponse(bool *aIsCachedResponse) override; \
  NS_IMETHOD Acknowledge(nsIContentAnalysisAcknowledgement *aCaa) override; 

/* Use this macro when declaring the members of this interface when the
   class doesn't implement the interface. This is useful for forwarding. */
#define NS_DECL_NON_VIRTUAL_NSICONTENTANALYSISRESPONSE \
  nsresult GetAction(nsIContentAnalysisResponse::Action *aAction); \
  nsresult GetShouldAllowContent(bool *aShouldAllowContent); \
  nsresult GetCancelError(nsIContentAnalysisResponse::CancelError *aCancelError); \
  nsresult GetRequestToken(nsACString& aRequestToken); \
  nsresult GetIsCachedResponse(bool *aIsCachedResponse); \
  nsresult Acknowledge(nsIContentAnalysisAcknowledgement *aCaa); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSICONTENTANALYSISRESPONSE(_to) \
  NS_IMETHOD GetAction(nsIContentAnalysisResponse::Action *aAction) override { return _to GetAction(aAction); } \
  NS_IMETHOD GetShouldAllowContent(bool *aShouldAllowContent) override { return _to GetShouldAllowContent(aShouldAllowContent); } \
  NS_IMETHOD GetCancelError(nsIContentAnalysisResponse::CancelError *aCancelError) override { return _to GetCancelError(aCancelError); } \
  NS_IMETHOD GetRequestToken(nsACString& aRequestToken) override { return _to GetRequestToken(aRequestToken); } \
  NS_IMETHOD GetIsCachedResponse(bool *aIsCachedResponse) override { return _to GetIsCachedResponse(aIsCachedResponse); } \
  NS_IMETHOD Acknowledge(nsIContentAnalysisAcknowledgement *aCaa) override { return _to Acknowledge(aCaa); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSICONTENTANALYSISRESPONSE(_to) \
  NS_IMETHOD GetAction(nsIContentAnalysisResponse::Action *aAction) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAction(aAction); } \
  NS_IMETHOD GetShouldAllowContent(bool *aShouldAllowContent) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetShouldAllowContent(aShouldAllowContent); } \
  NS_IMETHOD GetCancelError(nsIContentAnalysisResponse::CancelError *aCancelError) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCancelError(aCancelError); } \
  NS_IMETHOD GetRequestToken(nsACString& aRequestToken) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetRequestToken(aRequestToken); } \
  NS_IMETHOD GetIsCachedResponse(bool *aIsCachedResponse) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetIsCachedResponse(aIsCachedResponse); } \
  NS_IMETHOD Acknowledge(nsIContentAnalysisAcknowledgement *aCaa) override { return !_to ? NS_ERROR_NULL_POINTER : _to->Acknowledge(aCaa); } 


/* starting interface:    nsIClientDownloadResource */
#define NS_ICLIENTDOWNLOADRESOURCE_IID_STR "48d31df1-204d-42ce-a57f-f156bb870d89"

#define NS_ICLIENTDOWNLOADRESOURCE_IID \
  {0x48d31df1, 0x204d, 0x42ce, \
    { 0xa5, 0x7f, 0xf1, 0x56, 0xbb, 0x87, 0x0d, 0x89 }}

class NS_NO_VTABLE nsIClientDownloadResource : public nsISupports {
 public:

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_ICLIENTDOWNLOADRESOURCE_IID)

  /* Used by ToJSValue to check which scriptable interface is implemented. */
  using ScriptableInterfaceType = nsIClientDownloadResource;

  /* readonly attribute AString url; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetUrl(nsAString& aUrl) = 0;

  enum {
    DOWNLOAD_URL = 0U,
    DOWNLOAD_REDIRECT = 1U,
    TAB_URL = 2U,
    TAB_REDIRECT = 3U,
    PPAPI_DOCUMENT = 4U,
    PPAPI_PLUGIN = 5U
  };

  /* readonly attribute unsigned long type; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetType(uint32_t *aType) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsIClientDownloadResource, NS_ICLIENTDOWNLOADRESOURCE_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSICLIENTDOWNLOADRESOURCE \
  NS_IMETHOD GetUrl(nsAString& aUrl) override; \
  NS_IMETHOD GetType(uint32_t *aType) override; 

/* Use this macro when declaring the members of this interface when the
   class doesn't implement the interface. This is useful for forwarding. */
#define NS_DECL_NON_VIRTUAL_NSICLIENTDOWNLOADRESOURCE \
  nsresult GetUrl(nsAString& aUrl); \
  nsresult GetType(uint32_t *aType); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSICLIENTDOWNLOADRESOURCE(_to) \
  NS_IMETHOD GetUrl(nsAString& aUrl) override { return _to GetUrl(aUrl); } \
  NS_IMETHOD GetType(uint32_t *aType) override { return _to GetType(aType); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSICLIENTDOWNLOADRESOURCE(_to) \
  NS_IMETHOD GetUrl(nsAString& aUrl) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetUrl(aUrl); } \
  NS_IMETHOD GetType(uint32_t *aType) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetType(aType); } 


/* starting interface:    nsIContentAnalysisRequest */
#define NS_ICONTENTANALYSISREQUEST_IID_STR "c11a6636-da2a-4afc-bdd1-0bcae2310e6d"

#define NS_ICONTENTANALYSISREQUEST_IID \
  {0xc11a6636, 0xda2a, 0x4afc, \
    { 0xbd, 0xd1, 0x0b, 0xca, 0xe2, 0x31, 0x0e, 0x6d }}

class NS_NO_VTABLE nsIContentAnalysisRequest : public nsISupports {
 public:

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_ICONTENTANALYSISREQUEST_IID)

  /* Used by ToJSValue to check which scriptable interface is implemented. */
  using ScriptableInterfaceType = nsIContentAnalysisRequest;

  enum AnalysisType : uint32_t {
    eUnspecified = 0,
    eFileDownloaded = 1,
    eFileAttached = 2,
    eBulkDataEntry = 3,
    ePrint = 4,
    eFileTransfer = 5,
  };

  /* readonly attribute nsIContentAnalysisRequest_AnalysisType analysisType; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetAnalysisType(nsIContentAnalysisRequest::AnalysisType *aAnalysisType) = 0;

  enum OperationType : uint32_t {
    eCustomDisplayString = 0,
    eClipboard = 1,
    eDroppedText = 2,
    eOperationPrint = 3,
  };

  /* readonly attribute nsIContentAnalysisRequest_OperationType operationTypeForDisplay; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetOperationTypeForDisplay(nsIContentAnalysisRequest::OperationType *aOperationTypeForDisplay) = 0;

  /* readonly attribute AString operationDisplayString; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetOperationDisplayString(nsAString& aOperationDisplayString) = 0;

  /* readonly attribute AString textContent; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetTextContent(nsAString& aTextContent) = 0;

  /* readonly attribute AString filePath; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetFilePath(nsAString& aFilePath) = 0;

  /* readonly attribute unsigned long long printDataHandle; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetPrintDataHandle(uint64_t *aPrintDataHandle) = 0;

  /* readonly attribute unsigned long long printDataSize; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetPrintDataSize(uint64_t *aPrintDataSize) = 0;

  /* readonly attribute AString printerName; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetPrinterName(nsAString& aPrinterName) = 0;

  /* readonly attribute nsIURI url; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetUrl(nsIURI **aUrl) = 0;

  /* readonly attribute ACString sha256Digest; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetSha256Digest(nsACString& aSha256Digest) = 0;

  /* readonly attribute Array<nsIClientDownloadResource> resources; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetResources(nsTArray<RefPtr<nsIClientDownloadResource>>& aResources) = 0;

  /* readonly attribute AString email; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetEmail(nsAString& aEmail) = 0;

  /* readonly attribute ACString requestToken; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetRequestToken(nsACString& aRequestToken) = 0;

  /* readonly attribute WindowGlobalParent windowGlobalParent; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetWindowGlobalParent(mozilla::dom::WindowGlobalParent **aWindowGlobalParent) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsIContentAnalysisRequest, NS_ICONTENTANALYSISREQUEST_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSICONTENTANALYSISREQUEST \
  NS_IMETHOD GetAnalysisType(nsIContentAnalysisRequest::AnalysisType *aAnalysisType) override; \
  NS_IMETHOD GetOperationTypeForDisplay(nsIContentAnalysisRequest::OperationType *aOperationTypeForDisplay) override; \
  NS_IMETHOD GetOperationDisplayString(nsAString& aOperationDisplayString) override; \
  NS_IMETHOD GetTextContent(nsAString& aTextContent) override; \
  NS_IMETHOD GetFilePath(nsAString& aFilePath) override; \
  NS_IMETHOD GetPrintDataHandle(uint64_t *aPrintDataHandle) override; \
  NS_IMETHOD GetPrintDataSize(uint64_t *aPrintDataSize) override; \
  NS_IMETHOD GetPrinterName(nsAString& aPrinterName) override; \
  NS_IMETHOD GetUrl(nsIURI **aUrl) override; \
  NS_IMETHOD GetSha256Digest(nsACString& aSha256Digest) override; \
  NS_IMETHOD GetResources(nsTArray<RefPtr<nsIClientDownloadResource>>& aResources) override; \
  NS_IMETHOD GetEmail(nsAString& aEmail) override; \
  NS_IMETHOD GetRequestToken(nsACString& aRequestToken) override; \
  NS_IMETHOD GetWindowGlobalParent(mozilla::dom::WindowGlobalParent **aWindowGlobalParent) override; 

/* Use this macro when declaring the members of this interface when the
   class doesn't implement the interface. This is useful for forwarding. */
#define NS_DECL_NON_VIRTUAL_NSICONTENTANALYSISREQUEST \
  nsresult GetAnalysisType(nsIContentAnalysisRequest::AnalysisType *aAnalysisType); \
  nsresult GetOperationTypeForDisplay(nsIContentAnalysisRequest::OperationType *aOperationTypeForDisplay); \
  nsresult GetOperationDisplayString(nsAString& aOperationDisplayString); \
  nsresult GetTextContent(nsAString& aTextContent); \
  nsresult GetFilePath(nsAString& aFilePath); \
  nsresult GetPrintDataHandle(uint64_t *aPrintDataHandle); \
  nsresult GetPrintDataSize(uint64_t *aPrintDataSize); \
  nsresult GetPrinterName(nsAString& aPrinterName); \
  nsresult GetUrl(nsIURI **aUrl); \
  nsresult GetSha256Digest(nsACString& aSha256Digest); \
  nsresult GetResources(nsTArray<RefPtr<nsIClientDownloadResource>>& aResources); \
  nsresult GetEmail(nsAString& aEmail); \
  nsresult GetRequestToken(nsACString& aRequestToken); \
  nsresult GetWindowGlobalParent(mozilla::dom::WindowGlobalParent **aWindowGlobalParent); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSICONTENTANALYSISREQUEST(_to) \
  NS_IMETHOD GetAnalysisType(nsIContentAnalysisRequest::AnalysisType *aAnalysisType) override { return _to GetAnalysisType(aAnalysisType); } \
  NS_IMETHOD GetOperationTypeForDisplay(nsIContentAnalysisRequest::OperationType *aOperationTypeForDisplay) override { return _to GetOperationTypeForDisplay(aOperationTypeForDisplay); } \
  NS_IMETHOD GetOperationDisplayString(nsAString& aOperationDisplayString) override { return _to GetOperationDisplayString(aOperationDisplayString); } \
  NS_IMETHOD GetTextContent(nsAString& aTextContent) override { return _to GetTextContent(aTextContent); } \
  NS_IMETHOD GetFilePath(nsAString& aFilePath) override { return _to GetFilePath(aFilePath); } \
  NS_IMETHOD GetPrintDataHandle(uint64_t *aPrintDataHandle) override { return _to GetPrintDataHandle(aPrintDataHandle); } \
  NS_IMETHOD GetPrintDataSize(uint64_t *aPrintDataSize) override { return _to GetPrintDataSize(aPrintDataSize); } \
  NS_IMETHOD GetPrinterName(nsAString& aPrinterName) override { return _to GetPrinterName(aPrinterName); } \
  NS_IMETHOD GetUrl(nsIURI **aUrl) override { return _to GetUrl(aUrl); } \
  NS_IMETHOD GetSha256Digest(nsACString& aSha256Digest) override { return _to GetSha256Digest(aSha256Digest); } \
  NS_IMETHOD GetResources(nsTArray<RefPtr<nsIClientDownloadResource>>& aResources) override { return _to GetResources(aResources); } \
  NS_IMETHOD GetEmail(nsAString& aEmail) override { return _to GetEmail(aEmail); } \
  NS_IMETHOD GetRequestToken(nsACString& aRequestToken) override { return _to GetRequestToken(aRequestToken); } \
  NS_IMETHOD GetWindowGlobalParent(mozilla::dom::WindowGlobalParent **aWindowGlobalParent) override { return _to GetWindowGlobalParent(aWindowGlobalParent); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSICONTENTANALYSISREQUEST(_to) \
  NS_IMETHOD GetAnalysisType(nsIContentAnalysisRequest::AnalysisType *aAnalysisType) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAnalysisType(aAnalysisType); } \
  NS_IMETHOD GetOperationTypeForDisplay(nsIContentAnalysisRequest::OperationType *aOperationTypeForDisplay) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetOperationTypeForDisplay(aOperationTypeForDisplay); } \
  NS_IMETHOD GetOperationDisplayString(nsAString& aOperationDisplayString) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetOperationDisplayString(aOperationDisplayString); } \
  NS_IMETHOD GetTextContent(nsAString& aTextContent) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetTextContent(aTextContent); } \
  NS_IMETHOD GetFilePath(nsAString& aFilePath) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetFilePath(aFilePath); } \
  NS_IMETHOD GetPrintDataHandle(uint64_t *aPrintDataHandle) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetPrintDataHandle(aPrintDataHandle); } \
  NS_IMETHOD GetPrintDataSize(uint64_t *aPrintDataSize) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetPrintDataSize(aPrintDataSize); } \
  NS_IMETHOD GetPrinterName(nsAString& aPrinterName) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetPrinterName(aPrinterName); } \
  NS_IMETHOD GetUrl(nsIURI **aUrl) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetUrl(aUrl); } \
  NS_IMETHOD GetSha256Digest(nsACString& aSha256Digest) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetSha256Digest(aSha256Digest); } \
  NS_IMETHOD GetResources(nsTArray<RefPtr<nsIClientDownloadResource>>& aResources) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetResources(aResources); } \
  NS_IMETHOD GetEmail(nsAString& aEmail) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetEmail(aEmail); } \
  NS_IMETHOD GetRequestToken(nsACString& aRequestToken) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetRequestToken(aRequestToken); } \
  NS_IMETHOD GetWindowGlobalParent(mozilla::dom::WindowGlobalParent **aWindowGlobalParent) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetWindowGlobalParent(aWindowGlobalParent); } 


/* starting interface:    nsIContentAnalysisResult */
#define NS_ICONTENTANALYSISRESULT_IID_STR "9679545f-4256-4c90-9654-90292c355d25"

#define NS_ICONTENTANALYSISRESULT_IID \
  {0x9679545f, 0x4256, 0x4c90, \
    { 0x96, 0x54, 0x90, 0x29, 0x2c, 0x35, 0x5d, 0x25 }}

class NS_NO_VTABLE nsIContentAnalysisResult : public nsISupports {
 public:

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_ICONTENTANALYSISRESULT_IID)

  /* Used by ToJSValue to check which scriptable interface is implemented. */
  using ScriptableInterfaceType = nsIContentAnalysisResult;

  /* [infallible] readonly attribute boolean shouldAllowContent; */
  NS_IMETHOD GetShouldAllowContent(bool *aShouldAllowContent) = 0;
  inline bool  GetShouldAllowContent()
  {
    bool result;
    mozilla::DebugOnly<nsresult> rv = GetShouldAllowContent(&result);
    MOZ_ASSERT(NS_SUCCEEDED(rv));
    return result;
  }

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsIContentAnalysisResult, NS_ICONTENTANALYSISRESULT_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSICONTENTANALYSISRESULT \
  using nsIContentAnalysisResult::GetShouldAllowContent; \
  NS_IMETHOD GetShouldAllowContent(bool *aShouldAllowContent) override; 

/* Use this macro when declaring the members of this interface when the
   class doesn't implement the interface. This is useful for forwarding. */
#define NS_DECL_NON_VIRTUAL_NSICONTENTANALYSISRESULT \
  using nsIContentAnalysisResult::GetShouldAllowContent; \
  nsresult GetShouldAllowContent(bool *aShouldAllowContent); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSICONTENTANALYSISRESULT(_to) \
  using nsIContentAnalysisResult::GetShouldAllowContent; \
  NS_IMETHOD GetShouldAllowContent(bool *aShouldAllowContent) override { return _to GetShouldAllowContent(aShouldAllowContent); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSICONTENTANALYSISRESULT(_to) \
  NS_IMETHOD GetShouldAllowContent(bool *aShouldAllowContent) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetShouldAllowContent(aShouldAllowContent); } 


/* starting interface:    nsIContentAnalysisCallback */
#define NS_ICONTENTANALYSISCALLBACK_IID_STR "cb09fc88-118c-411b-aa89-2e1bc5e3eba6"

#define NS_ICONTENTANALYSISCALLBACK_IID \
  {0xcb09fc88, 0x118c, 0x411b, \
    { 0xaa, 0x89, 0x2e, 0x1b, 0xc5, 0xe3, 0xeb, 0xa6 }}

class NS_NO_VTABLE nsIContentAnalysisCallback : public nsISupports {
 public:

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_ICONTENTANALYSISCALLBACK_IID)

  /* Used by ToJSValue to check which scriptable interface is implemented. */
  using ScriptableInterfaceType = nsIContentAnalysisCallback;

  /* void contentResult (in nsIContentAnalysisResponse aResult); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD ContentResult(nsIContentAnalysisResponse *aResult) = 0;

  /* void error (in nsresult aResult); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD Error(nsresult aResult) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsIContentAnalysisCallback, NS_ICONTENTANALYSISCALLBACK_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSICONTENTANALYSISCALLBACK \
  NS_IMETHOD ContentResult(nsIContentAnalysisResponse *aResult) override; \
  NS_IMETHOD Error(nsresult aResult) override; 

/* Use this macro when declaring the members of this interface when the
   class doesn't implement the interface. This is useful for forwarding. */
#define NS_DECL_NON_VIRTUAL_NSICONTENTANALYSISCALLBACK \
  nsresult ContentResult(nsIContentAnalysisResponse *aResult); \
  nsresult Error(nsresult aResult); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSICONTENTANALYSISCALLBACK(_to) \
  NS_IMETHOD ContentResult(nsIContentAnalysisResponse *aResult) override { return _to ContentResult(aResult); } \
  NS_IMETHOD Error(nsresult aResult) override { return _to Error(aResult); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSICONTENTANALYSISCALLBACK(_to) \
  NS_IMETHOD ContentResult(nsIContentAnalysisResponse *aResult) override { return !_to ? NS_ERROR_NULL_POINTER : _to->ContentResult(aResult); } \
  NS_IMETHOD Error(nsresult aResult) override { return !_to ? NS_ERROR_NULL_POINTER : _to->Error(aResult); } 


/* starting interface:    nsIContentAnalysisDiagnosticInfo */
#define NS_ICONTENTANALYSISDIAGNOSTICINFO_IID_STR "a430f6ef-a526-4055-8a82-7741ea757367"

#define NS_ICONTENTANALYSISDIAGNOSTICINFO_IID \
  {0xa430f6ef, 0xa526, 0x4055, \
    { 0x8a, 0x82, 0x77, 0x41, 0xea, 0x75, 0x73, 0x67 }}

class NS_NO_VTABLE nsIContentAnalysisDiagnosticInfo : public nsISupports {
 public:

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_ICONTENTANALYSISDIAGNOSTICINFO_IID)

  /* Used by ToJSValue to check which scriptable interface is implemented. */
  using ScriptableInterfaceType = nsIContentAnalysisDiagnosticInfo;

  /* [infallible] readonly attribute boolean connectedToAgent; */
  NS_IMETHOD GetConnectedToAgent(bool *aConnectedToAgent) = 0;
  inline bool  GetConnectedToAgent()
  {
    bool result;
    mozilla::DebugOnly<nsresult> rv = GetConnectedToAgent(&result);
    MOZ_ASSERT(NS_SUCCEEDED(rv));
    return result;
  }

  /* readonly attribute AString agentPath; */
  NS_IMETHOD GetAgentPath(nsAString& aAgentPath) = 0;

  /* [infallible] readonly attribute boolean failedSignatureVerification; */
  NS_IMETHOD GetFailedSignatureVerification(bool *aFailedSignatureVerification) = 0;
  inline bool  GetFailedSignatureVerification()
  {
    bool result;
    mozilla::DebugOnly<nsresult> rv = GetFailedSignatureVerification(&result);
    MOZ_ASSERT(NS_SUCCEEDED(rv));
    return result;
  }

  /* [infallible] readonly attribute long long requestCount; */
  NS_IMETHOD GetRequestCount(int64_t *aRequestCount) = 0;
  inline int64_t  GetRequestCount()
  {
    int64_t result;
    mozilla::DebugOnly<nsresult> rv = GetRequestCount(&result);
    MOZ_ASSERT(NS_SUCCEEDED(rv));
    return result;
  }

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsIContentAnalysisDiagnosticInfo, NS_ICONTENTANALYSISDIAGNOSTICINFO_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSICONTENTANALYSISDIAGNOSTICINFO \
  using nsIContentAnalysisDiagnosticInfo::GetConnectedToAgent; \
  NS_IMETHOD GetConnectedToAgent(bool *aConnectedToAgent) override; \
  NS_IMETHOD GetAgentPath(nsAString& aAgentPath) override; \
  using nsIContentAnalysisDiagnosticInfo::GetFailedSignatureVerification; \
  NS_IMETHOD GetFailedSignatureVerification(bool *aFailedSignatureVerification) override; \
  using nsIContentAnalysisDiagnosticInfo::GetRequestCount; \
  NS_IMETHOD GetRequestCount(int64_t *aRequestCount) override; 

/* Use this macro when declaring the members of this interface when the
   class doesn't implement the interface. This is useful for forwarding. */
#define NS_DECL_NON_VIRTUAL_NSICONTENTANALYSISDIAGNOSTICINFO \
  using nsIContentAnalysisDiagnosticInfo::GetConnectedToAgent; \
  nsresult GetConnectedToAgent(bool *aConnectedToAgent); \
  nsresult GetAgentPath(nsAString& aAgentPath); \
  using nsIContentAnalysisDiagnosticInfo::GetFailedSignatureVerification; \
  nsresult GetFailedSignatureVerification(bool *aFailedSignatureVerification); \
  using nsIContentAnalysisDiagnosticInfo::GetRequestCount; \
  nsresult GetRequestCount(int64_t *aRequestCount); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSICONTENTANALYSISDIAGNOSTICINFO(_to) \
  using nsIContentAnalysisDiagnosticInfo::GetConnectedToAgent; \
  NS_IMETHOD GetConnectedToAgent(bool *aConnectedToAgent) override { return _to GetConnectedToAgent(aConnectedToAgent); } \
  NS_IMETHOD GetAgentPath(nsAString& aAgentPath) override { return _to GetAgentPath(aAgentPath); } \
  using nsIContentAnalysisDiagnosticInfo::GetFailedSignatureVerification; \
  NS_IMETHOD GetFailedSignatureVerification(bool *aFailedSignatureVerification) override { return _to GetFailedSignatureVerification(aFailedSignatureVerification); } \
  using nsIContentAnalysisDiagnosticInfo::GetRequestCount; \
  NS_IMETHOD GetRequestCount(int64_t *aRequestCount) override { return _to GetRequestCount(aRequestCount); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSICONTENTANALYSISDIAGNOSTICINFO(_to) \
  NS_IMETHOD GetConnectedToAgent(bool *aConnectedToAgent) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetConnectedToAgent(aConnectedToAgent); } \
  NS_IMETHOD GetAgentPath(nsAString& aAgentPath) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAgentPath(aAgentPath); } \
  NS_IMETHOD GetFailedSignatureVerification(bool *aFailedSignatureVerification) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetFailedSignatureVerification(aFailedSignatureVerification); } \
  NS_IMETHOD GetRequestCount(int64_t *aRequestCount) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetRequestCount(aRequestCount); } 


/* starting interface:    nsIContentAnalysis */
#define NS_ICONTENTANALYSIS_IID_STR "61497587-2bba-4a88-acd3-3fbb2cedf163"

#define NS_ICONTENTANALYSIS_IID \
  {0x61497587, 0x2bba, 0x4a88, \
    { 0xac, 0xd3, 0x3f, 0xbb, 0x2c, 0xed, 0xf1, 0x63 }}

class nsIContentAnalysis : public nsISupports {
 public:

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_ICONTENTANALYSIS_IID)

  /* Used by ToJSValue to check which scriptable interface is implemented. */
  using ScriptableInterfaceType = nsIContentAnalysis;

  /* readonly attribute boolean isActive; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetIsActive(bool *aIsActive) = 0;

  /* readonly attribute boolean mightBeActive; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetMightBeActive(bool *aMightBeActive) = 0;

   /**
   * Static way to get the mightBeActive property.
   */
  static bool MightBeActive();
    /* attribute boolean isSetByEnterprisePolicy; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetIsSetByEnterprisePolicy(bool *aIsSetByEnterprisePolicy) = 0;
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD SetIsSetByEnterprisePolicy(bool aIsSetByEnterprisePolicy) = 0;

  /* [implicit_jscontext] Promise analyzeContentRequest (in nsIContentAnalysisRequest aCar, in boolean aAutoAcknowledge); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD AnalyzeContentRequest(nsIContentAnalysisRequest *aCar, bool aAutoAcknowledge, JSContext* cx, ::mozilla::dom::Promise * * _retval) = 0;

  /* void analyzeContentRequestCallback (in nsIContentAnalysisRequest aCar, in boolean aAutoAcknowledge, in nsIContentAnalysisCallback callback); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD AnalyzeContentRequestCallback(nsIContentAnalysisRequest *aCar, bool aAutoAcknowledge, nsIContentAnalysisCallback *callback) = 0;

  /* void cancelContentAnalysisRequest (in ACString aRequestToken); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD CancelContentAnalysisRequest(const nsACString& aRequestToken) = 0;

  /* void respondToWarnDialog (in ACString aRequestToken, in boolean aAllowContent); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD RespondToWarnDialog(const nsACString& aRequestToken, bool aAllowContent) = 0;

  /* void cancelAllRequests (); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD CancelAllRequests(void) = 0;

  /* void testOnlySetCACmdLineArg (in boolean aVal); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD TestOnlySetCACmdLineArg(bool aVal) = 0;

  /* [implicit_jscontext] Promise getDiagnosticInfo (); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetDiagnosticInfo(JSContext* cx, ::mozilla::dom::Promise * * _retval) = 0;

  /* nsIURI getURIForBrowsingContext (in BrowsingContext aBrowsingContext); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetURIForBrowsingContext(mozilla::dom::BrowsingContext *aBrowsingContext, nsIURI **_retval) = 0;

  /* nsIURI getURIForDropEvent (in DragEvent aEvent); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetURIForDropEvent(mozilla::dom::DragEvent *aEvent, nsIURI **_retval) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsIContentAnalysis, NS_ICONTENTANALYSIS_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSICONTENTANALYSIS \
  NS_IMETHOD GetIsActive(bool *aIsActive) override; \
  NS_IMETHOD GetMightBeActive(bool *aMightBeActive) override; \
  NS_IMETHOD GetIsSetByEnterprisePolicy(bool *aIsSetByEnterprisePolicy) override; \
  NS_IMETHOD SetIsSetByEnterprisePolicy(bool aIsSetByEnterprisePolicy) override; \
  NS_IMETHOD AnalyzeContentRequest(nsIContentAnalysisRequest *aCar, bool aAutoAcknowledge, JSContext* cx, ::mozilla::dom::Promise * * _retval) override; \
  NS_IMETHOD AnalyzeContentRequestCallback(nsIContentAnalysisRequest *aCar, bool aAutoAcknowledge, nsIContentAnalysisCallback *callback) override; \
  NS_IMETHOD CancelContentAnalysisRequest(const nsACString& aRequestToken) override; \
  NS_IMETHOD RespondToWarnDialog(const nsACString& aRequestToken, bool aAllowContent) override; \
  NS_IMETHOD CancelAllRequests(void) override; \
  NS_IMETHOD TestOnlySetCACmdLineArg(bool aVal) override; \
  NS_IMETHOD GetDiagnosticInfo(JSContext* cx, ::mozilla::dom::Promise * * _retval) override; \
  NS_IMETHOD GetURIForBrowsingContext(mozilla::dom::BrowsingContext *aBrowsingContext, nsIURI **_retval) override; \
  NS_IMETHOD GetURIForDropEvent(mozilla::dom::DragEvent *aEvent, nsIURI **_retval) override; 

/* Use this macro when declaring the members of this interface when the
   class doesn't implement the interface. This is useful for forwarding. */
#define NS_DECL_NON_VIRTUAL_NSICONTENTANALYSIS \
  nsresult GetIsActive(bool *aIsActive); \
  nsresult GetMightBeActive(bool *aMightBeActive); \
  nsresult GetIsSetByEnterprisePolicy(bool *aIsSetByEnterprisePolicy); \
  nsresult SetIsSetByEnterprisePolicy(bool aIsSetByEnterprisePolicy); \
  nsresult AnalyzeContentRequest(nsIContentAnalysisRequest *aCar, bool aAutoAcknowledge, JSContext* cx, ::mozilla::dom::Promise * * _retval); \
  nsresult AnalyzeContentRequestCallback(nsIContentAnalysisRequest *aCar, bool aAutoAcknowledge, nsIContentAnalysisCallback *callback); \
  nsresult CancelContentAnalysisRequest(const nsACString& aRequestToken); \
  nsresult RespondToWarnDialog(const nsACString& aRequestToken, bool aAllowContent); \
  nsresult CancelAllRequests(void); \
  nsresult TestOnlySetCACmdLineArg(bool aVal); \
  nsresult GetDiagnosticInfo(JSContext* cx, ::mozilla::dom::Promise * * _retval); \
  nsresult GetURIForBrowsingContext(mozilla::dom::BrowsingContext *aBrowsingContext, nsIURI **_retval); \
  nsresult GetURIForDropEvent(mozilla::dom::DragEvent *aEvent, nsIURI **_retval); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSICONTENTANALYSIS(_to) \
  NS_IMETHOD GetIsActive(bool *aIsActive) override { return _to GetIsActive(aIsActive); } \
  NS_IMETHOD GetMightBeActive(bool *aMightBeActive) override { return _to GetMightBeActive(aMightBeActive); } \
  NS_IMETHOD GetIsSetByEnterprisePolicy(bool *aIsSetByEnterprisePolicy) override { return _to GetIsSetByEnterprisePolicy(aIsSetByEnterprisePolicy); } \
  NS_IMETHOD SetIsSetByEnterprisePolicy(bool aIsSetByEnterprisePolicy) override { return _to SetIsSetByEnterprisePolicy(aIsSetByEnterprisePolicy); } \
  NS_IMETHOD AnalyzeContentRequest(nsIContentAnalysisRequest *aCar, bool aAutoAcknowledge, JSContext* cx, ::mozilla::dom::Promise * * _retval) override { return _to AnalyzeContentRequest(aCar, aAutoAcknowledge, cx, _retval); } \
  NS_IMETHOD AnalyzeContentRequestCallback(nsIContentAnalysisRequest *aCar, bool aAutoAcknowledge, nsIContentAnalysisCallback *callback) override { return _to AnalyzeContentRequestCallback(aCar, aAutoAcknowledge, callback); } \
  NS_IMETHOD CancelContentAnalysisRequest(const nsACString& aRequestToken) override { return _to CancelContentAnalysisRequest(aRequestToken); } \
  NS_IMETHOD RespondToWarnDialog(const nsACString& aRequestToken, bool aAllowContent) override { return _to RespondToWarnDialog(aRequestToken, aAllowContent); } \
  NS_IMETHOD CancelAllRequests(void) override { return _to CancelAllRequests(); } \
  NS_IMETHOD TestOnlySetCACmdLineArg(bool aVal) override { return _to TestOnlySetCACmdLineArg(aVal); } \
  NS_IMETHOD GetDiagnosticInfo(JSContext* cx, ::mozilla::dom::Promise * * _retval) override { return _to GetDiagnosticInfo(cx, _retval); } \
  NS_IMETHOD GetURIForBrowsingContext(mozilla::dom::BrowsingContext *aBrowsingContext, nsIURI **_retval) override { return _to GetURIForBrowsingContext(aBrowsingContext, _retval); } \
  NS_IMETHOD GetURIForDropEvent(mozilla::dom::DragEvent *aEvent, nsIURI **_retval) override { return _to GetURIForDropEvent(aEvent, _retval); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSICONTENTANALYSIS(_to) \
  NS_IMETHOD GetIsActive(bool *aIsActive) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetIsActive(aIsActive); } \
  NS_IMETHOD GetMightBeActive(bool *aMightBeActive) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetMightBeActive(aMightBeActive); } \
  NS_IMETHOD GetIsSetByEnterprisePolicy(bool *aIsSetByEnterprisePolicy) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetIsSetByEnterprisePolicy(aIsSetByEnterprisePolicy); } \
  NS_IMETHOD SetIsSetByEnterprisePolicy(bool aIsSetByEnterprisePolicy) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetIsSetByEnterprisePolicy(aIsSetByEnterprisePolicy); } \
  NS_IMETHOD AnalyzeContentRequest(nsIContentAnalysisRequest *aCar, bool aAutoAcknowledge, JSContext* cx, ::mozilla::dom::Promise * * _retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->AnalyzeContentRequest(aCar, aAutoAcknowledge, cx, _retval); } \
  NS_IMETHOD AnalyzeContentRequestCallback(nsIContentAnalysisRequest *aCar, bool aAutoAcknowledge, nsIContentAnalysisCallback *callback) override { return !_to ? NS_ERROR_NULL_POINTER : _to->AnalyzeContentRequestCallback(aCar, aAutoAcknowledge, callback); } \
  NS_IMETHOD CancelContentAnalysisRequest(const nsACString& aRequestToken) override { return !_to ? NS_ERROR_NULL_POINTER : _to->CancelContentAnalysisRequest(aRequestToken); } \
  NS_IMETHOD RespondToWarnDialog(const nsACString& aRequestToken, bool aAllowContent) override { return !_to ? NS_ERROR_NULL_POINTER : _to->RespondToWarnDialog(aRequestToken, aAllowContent); } \
  NS_IMETHOD CancelAllRequests(void) override { return !_to ? NS_ERROR_NULL_POINTER : _to->CancelAllRequests(); } \
  NS_IMETHOD TestOnlySetCACmdLineArg(bool aVal) override { return !_to ? NS_ERROR_NULL_POINTER : _to->TestOnlySetCACmdLineArg(aVal); } \
  NS_IMETHOD GetDiagnosticInfo(JSContext* cx, ::mozilla::dom::Promise * * _retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDiagnosticInfo(cx, _retval); } \
  NS_IMETHOD GetURIForBrowsingContext(mozilla::dom::BrowsingContext *aBrowsingContext, nsIURI **_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetURIForBrowsingContext(aBrowsingContext, _retval); } \
  NS_IMETHOD GetURIForDropEvent(mozilla::dom::DragEvent *aEvent, nsIURI **_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetURIForDropEvent(aEvent, _retval); } 


#endif /* __gen_nsIContentAnalysis_h__ */
