// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanNewtabMetrics_h
#define mozilla_GleanNewtabMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace activity_stream {
  /**
   * generated from activity_stream.end_session
   */
  struct EndSessionExtra {
    mozilla::Maybe<nsCString> addonVersion;
    mozilla::Maybe<nsCString> page;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<uint32_t> userPrefs;
    mozilla::Maybe<uint32_t> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (addonVersion) {
        extraKeys.AppendElement()->AssignASCII("addon_version");
        extraValues.EmplaceBack(addonVersion.value());
      }
      if (page) {
        extraKeys.AppendElement()->AssignASCII("page");
        extraValues.EmplaceBack(page.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (userPrefs) {
        extraKeys.AppendElement()->AssignASCII("user_prefs");
        extraValues.AppendElement()->AppendInt(userPrefs.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.AppendElement()->AppendInt(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded with every session ended in Activity Stream. This event was generated to correspond to the Legacy Telemetry event activity_stream.end#session.
   */
  constexpr impl::EventMetric<EndSessionExtra> end_session(473);

  /**
   * generated from activity_stream.event_archive_from_pocket
   */
  struct EventArchiveFromPocketExtra {
    mozilla::Maybe<uint32_t> actionPosition;
    mozilla::Maybe<nsCString> addonVersion;
    mozilla::Maybe<nsCString> page;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<uint32_t> userPrefs;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (actionPosition) {
        extraKeys.AppendElement()->AssignASCII("action_position");
        extraValues.AppendElement()->AppendInt(actionPosition.value());
      }
      if (addonVersion) {
        extraKeys.AppendElement()->AssignASCII("addon_version");
        extraValues.EmplaceBack(addonVersion.value());
      }
      if (page) {
        extraKeys.AppendElement()->AssignASCII("page");
        extraValues.EmplaceBack(page.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (userPrefs) {
        extraKeys.AppendElement()->AssignASCII("user_prefs");
        extraValues.AppendElement()->AppendInt(userPrefs.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#ARCHIVE_FROM_POCKET.
   */
  constexpr impl::EventMetric<EventArchiveFromPocketExtra> event_archive_from_pocket(474);

  /**
   * generated from activity_stream.event_block
   */
  struct EventBlockExtra {
    mozilla::Maybe<uint32_t> actionPosition;
    mozilla::Maybe<nsCString> addonVersion;
    mozilla::Maybe<nsCString> page;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<uint32_t> userPrefs;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (actionPosition) {
        extraKeys.AppendElement()->AssignASCII("action_position");
        extraValues.AppendElement()->AppendInt(actionPosition.value());
      }
      if (addonVersion) {
        extraKeys.AppendElement()->AssignASCII("addon_version");
        extraValues.EmplaceBack(addonVersion.value());
      }
      if (page) {
        extraKeys.AppendElement()->AssignASCII("page");
        extraValues.EmplaceBack(page.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (userPrefs) {
        extraKeys.AppendElement()->AssignASCII("user_prefs");
        extraValues.AppendElement()->AppendInt(userPrefs.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#BLOCK.
   */
  constexpr impl::EventMetric<EventBlockExtra> event_block(475);

  /**
   * generated from activity_stream.event_bookmark_add
   */
  struct EventBookmarkAddExtra {
    mozilla::Maybe<uint32_t> actionPosition;
    mozilla::Maybe<nsCString> addonVersion;
    mozilla::Maybe<nsCString> page;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<uint32_t> userPrefs;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (actionPosition) {
        extraKeys.AppendElement()->AssignASCII("action_position");
        extraValues.AppendElement()->AppendInt(actionPosition.value());
      }
      if (addonVersion) {
        extraKeys.AppendElement()->AssignASCII("addon_version");
        extraValues.EmplaceBack(addonVersion.value());
      }
      if (page) {
        extraKeys.AppendElement()->AssignASCII("page");
        extraValues.EmplaceBack(page.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (userPrefs) {
        extraKeys.AppendElement()->AssignASCII("user_prefs");
        extraValues.AppendElement()->AppendInt(userPrefs.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#BOOKMARK_ADD.
   */
  constexpr impl::EventMetric<EventBookmarkAddExtra> event_bookmark_add(476);

  /**
   * generated from activity_stream.event_bookmark_delete
   */
  struct EventBookmarkDeleteExtra {
    mozilla::Maybe<uint32_t> actionPosition;
    mozilla::Maybe<nsCString> addonVersion;
    mozilla::Maybe<nsCString> page;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<uint32_t> userPrefs;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (actionPosition) {
        extraKeys.AppendElement()->AssignASCII("action_position");
        extraValues.AppendElement()->AppendInt(actionPosition.value());
      }
      if (addonVersion) {
        extraKeys.AppendElement()->AssignASCII("addon_version");
        extraValues.EmplaceBack(addonVersion.value());
      }
      if (page) {
        extraKeys.AppendElement()->AssignASCII("page");
        extraValues.EmplaceBack(page.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (userPrefs) {
        extraKeys.AppendElement()->AssignASCII("user_prefs");
        extraValues.AppendElement()->AppendInt(userPrefs.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#BOOKMARK_DELETE.
   */
  constexpr impl::EventMetric<EventBookmarkDeleteExtra> event_bookmark_delete(477);

  /**
   * generated from activity_stream.event_click
   */
  struct EventClickExtra {
    mozilla::Maybe<uint32_t> actionPosition;
    mozilla::Maybe<nsCString> addonVersion;
    mozilla::Maybe<nsCString> page;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<uint32_t> userPrefs;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (actionPosition) {
        extraKeys.AppendElement()->AssignASCII("action_position");
        extraValues.AppendElement()->AppendInt(actionPosition.value());
      }
      if (addonVersion) {
        extraKeys.AppendElement()->AssignASCII("addon_version");
        extraValues.EmplaceBack(addonVersion.value());
      }
      if (page) {
        extraKeys.AppendElement()->AssignASCII("page");
        extraValues.EmplaceBack(page.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (userPrefs) {
        extraKeys.AppendElement()->AssignASCII("user_prefs");
        extraValues.AppendElement()->AppendInt(userPrefs.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#CLICK.
   */
  constexpr impl::EventMetric<EventClickExtra> event_click(478);

  /**
   * generated from activity_stream.event_click_privacy_info
   */
  struct EventClickPrivacyInfoExtra {
    mozilla::Maybe<uint32_t> actionPosition;
    mozilla::Maybe<nsCString> addonVersion;
    mozilla::Maybe<nsCString> page;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<uint32_t> userPrefs;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (actionPosition) {
        extraKeys.AppendElement()->AssignASCII("action_position");
        extraValues.AppendElement()->AppendInt(actionPosition.value());
      }
      if (addonVersion) {
        extraKeys.AppendElement()->AssignASCII("addon_version");
        extraValues.EmplaceBack(addonVersion.value());
      }
      if (page) {
        extraKeys.AppendElement()->AssignASCII("page");
        extraValues.EmplaceBack(page.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (userPrefs) {
        extraKeys.AppendElement()->AssignASCII("user_prefs");
        extraValues.AppendElement()->AppendInt(userPrefs.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#CLICK_PRIVACY_INFO.
   */
  constexpr impl::EventMetric<EventClickPrivacyInfoExtra> event_click_privacy_info(479);

  /**
   * generated from activity_stream.event_close_newtab_prefs
   */
  struct EventCloseNewtabPrefsExtra {
    mozilla::Maybe<uint32_t> actionPosition;
    mozilla::Maybe<nsCString> addonVersion;
    mozilla::Maybe<nsCString> page;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<uint32_t> userPrefs;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (actionPosition) {
        extraKeys.AppendElement()->AssignASCII("action_position");
        extraValues.AppendElement()->AppendInt(actionPosition.value());
      }
      if (addonVersion) {
        extraKeys.AppendElement()->AssignASCII("addon_version");
        extraValues.EmplaceBack(addonVersion.value());
      }
      if (page) {
        extraKeys.AppendElement()->AssignASCII("page");
        extraValues.EmplaceBack(page.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (userPrefs) {
        extraKeys.AppendElement()->AssignASCII("user_prefs");
        extraValues.AppendElement()->AppendInt(userPrefs.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#CLOSE_NEWTAB_PREFS.
   */
  constexpr impl::EventMetric<EventCloseNewtabPrefsExtra> event_close_newtab_prefs(480);

  /**
   * generated from activity_stream.event_delete
   */
  struct EventDeleteExtra {
    mozilla::Maybe<uint32_t> actionPosition;
    mozilla::Maybe<nsCString> addonVersion;
    mozilla::Maybe<nsCString> page;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<uint32_t> userPrefs;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (actionPosition) {
        extraKeys.AppendElement()->AssignASCII("action_position");
        extraValues.AppendElement()->AppendInt(actionPosition.value());
      }
      if (addonVersion) {
        extraKeys.AppendElement()->AssignASCII("addon_version");
        extraValues.EmplaceBack(addonVersion.value());
      }
      if (page) {
        extraKeys.AppendElement()->AssignASCII("page");
        extraValues.EmplaceBack(page.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (userPrefs) {
        extraKeys.AppendElement()->AssignASCII("user_prefs");
        extraValues.AppendElement()->AppendInt(userPrefs.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#DELETE.
   */
  constexpr impl::EventMetric<EventDeleteExtra> event_delete(481);

  /**
   * generated from activity_stream.event_delete_confirm
   */
  struct EventDeleteConfirmExtra {
    mozilla::Maybe<uint32_t> actionPosition;
    mozilla::Maybe<nsCString> addonVersion;
    mozilla::Maybe<nsCString> page;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<uint32_t> userPrefs;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (actionPosition) {
        extraKeys.AppendElement()->AssignASCII("action_position");
        extraValues.AppendElement()->AppendInt(actionPosition.value());
      }
      if (addonVersion) {
        extraKeys.AppendElement()->AssignASCII("addon_version");
        extraValues.EmplaceBack(addonVersion.value());
      }
      if (page) {
        extraKeys.AppendElement()->AssignASCII("page");
        extraValues.EmplaceBack(page.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (userPrefs) {
        extraKeys.AppendElement()->AssignASCII("user_prefs");
        extraValues.AppendElement()->AppendInt(userPrefs.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#DELETE_CONFIRM.
   */
  constexpr impl::EventMetric<EventDeleteConfirmExtra> event_delete_confirm(482);

  /**
   * generated from activity_stream.event_delete_from_pocket
   */
  struct EventDeleteFromPocketExtra {
    mozilla::Maybe<uint32_t> actionPosition;
    mozilla::Maybe<nsCString> addonVersion;
    mozilla::Maybe<nsCString> page;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<uint32_t> userPrefs;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (actionPosition) {
        extraKeys.AppendElement()->AssignASCII("action_position");
        extraValues.AppendElement()->AppendInt(actionPosition.value());
      }
      if (addonVersion) {
        extraKeys.AppendElement()->AssignASCII("addon_version");
        extraValues.EmplaceBack(addonVersion.value());
      }
      if (page) {
        extraKeys.AppendElement()->AssignASCII("page");
        extraValues.EmplaceBack(page.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (userPrefs) {
        extraKeys.AppendElement()->AssignASCII("user_prefs");
        extraValues.AppendElement()->AppendInt(userPrefs.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#DELETE_FROM_POCKET.
   */
  constexpr impl::EventMetric<EventDeleteFromPocketExtra> event_delete_from_pocket(483);

  /**
   * generated from activity_stream.event_dialog_cancel
   */
  struct EventDialogCancelExtra {
    mozilla::Maybe<uint32_t> actionPosition;
    mozilla::Maybe<nsCString> addonVersion;
    mozilla::Maybe<nsCString> page;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<uint32_t> userPrefs;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (actionPosition) {
        extraKeys.AppendElement()->AssignASCII("action_position");
        extraValues.AppendElement()->AppendInt(actionPosition.value());
      }
      if (addonVersion) {
        extraKeys.AppendElement()->AssignASCII("addon_version");
        extraValues.EmplaceBack(addonVersion.value());
      }
      if (page) {
        extraKeys.AppendElement()->AssignASCII("page");
        extraValues.EmplaceBack(page.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (userPrefs) {
        extraKeys.AppendElement()->AssignASCII("user_prefs");
        extraValues.AppendElement()->AppendInt(userPrefs.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#DIALOG_CANCEL.
   */
  constexpr impl::EventMetric<EventDialogCancelExtra> event_dialog_cancel(484);

  /**
   * generated from activity_stream.event_dialog_open
   */
  struct EventDialogOpenExtra {
    mozilla::Maybe<uint32_t> actionPosition;
    mozilla::Maybe<nsCString> addonVersion;
    mozilla::Maybe<nsCString> page;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<uint32_t> userPrefs;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (actionPosition) {
        extraKeys.AppendElement()->AssignASCII("action_position");
        extraValues.AppendElement()->AppendInt(actionPosition.value());
      }
      if (addonVersion) {
        extraKeys.AppendElement()->AssignASCII("addon_version");
        extraValues.EmplaceBack(addonVersion.value());
      }
      if (page) {
        extraKeys.AppendElement()->AssignASCII("page");
        extraValues.EmplaceBack(page.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (userPrefs) {
        extraKeys.AppendElement()->AssignASCII("user_prefs");
        extraValues.AppendElement()->AppendInt(userPrefs.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#DIALOG_OPEN.
   */
  constexpr impl::EventMetric<EventDialogOpenExtra> event_dialog_open(485);

  /**
   * generated from activity_stream.event_disclaimer_acked
   */
  struct EventDisclaimerAckedExtra {
    mozilla::Maybe<uint32_t> actionPosition;
    mozilla::Maybe<nsCString> addonVersion;
    mozilla::Maybe<nsCString> page;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<uint32_t> userPrefs;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (actionPosition) {
        extraKeys.AppendElement()->AssignASCII("action_position");
        extraValues.AppendElement()->AppendInt(actionPosition.value());
      }
      if (addonVersion) {
        extraKeys.AppendElement()->AssignASCII("addon_version");
        extraValues.EmplaceBack(addonVersion.value());
      }
      if (page) {
        extraKeys.AppendElement()->AssignASCII("page");
        extraValues.EmplaceBack(page.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (userPrefs) {
        extraKeys.AppendElement()->AssignASCII("user_prefs");
        extraValues.AppendElement()->AppendInt(userPrefs.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#DISCLAIMER_ACKED.
   */
  constexpr impl::EventMetric<EventDisclaimerAckedExtra> event_disclaimer_acked(486);

  /**
   * generated from activity_stream.event_drag
   */
  struct EventDragExtra {
    mozilla::Maybe<uint32_t> actionPosition;
    mozilla::Maybe<nsCString> addonVersion;
    mozilla::Maybe<nsCString> page;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<uint32_t> userPrefs;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (actionPosition) {
        extraKeys.AppendElement()->AssignASCII("action_position");
        extraValues.AppendElement()->AppendInt(actionPosition.value());
      }
      if (addonVersion) {
        extraKeys.AppendElement()->AssignASCII("addon_version");
        extraValues.EmplaceBack(addonVersion.value());
      }
      if (page) {
        extraKeys.AppendElement()->AssignASCII("page");
        extraValues.EmplaceBack(page.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (userPrefs) {
        extraKeys.AppendElement()->AssignASCII("user_prefs");
        extraValues.AppendElement()->AppendInt(userPrefs.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#DRAG.
   */
  constexpr impl::EventMetric<EventDragExtra> event_drag(487);

  /**
   * generated from activity_stream.event_drop
   */
  struct EventDropExtra {
    mozilla::Maybe<uint32_t> actionPosition;
    mozilla::Maybe<nsCString> addonVersion;
    mozilla::Maybe<nsCString> page;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<uint32_t> userPrefs;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (actionPosition) {
        extraKeys.AppendElement()->AssignASCII("action_position");
        extraValues.AppendElement()->AppendInt(actionPosition.value());
      }
      if (addonVersion) {
        extraKeys.AppendElement()->AssignASCII("addon_version");
        extraValues.EmplaceBack(addonVersion.value());
      }
      if (page) {
        extraKeys.AppendElement()->AssignASCII("page");
        extraValues.EmplaceBack(page.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (userPrefs) {
        extraKeys.AppendElement()->AssignASCII("user_prefs");
        extraValues.AppendElement()->AppendInt(userPrefs.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#DROP.
   */
  constexpr impl::EventMetric<EventDropExtra> event_drop(488);

  /**
   * generated from activity_stream.event_fakespot_category
   */
  struct EventFakespotCategoryExtra {
    mozilla::Maybe<uint32_t> actionPosition;
    mozilla::Maybe<nsCString> addonVersion;
    mozilla::Maybe<nsCString> page;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<uint32_t> userPrefs;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (actionPosition) {
        extraKeys.AppendElement()->AssignASCII("action_position");
        extraValues.AppendElement()->AppendInt(actionPosition.value());
      }
      if (addonVersion) {
        extraKeys.AppendElement()->AssignASCII("addon_version");
        extraValues.EmplaceBack(addonVersion.value());
      }
      if (page) {
        extraKeys.AppendElement()->AssignASCII("page");
        extraValues.EmplaceBack(page.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (userPrefs) {
        extraKeys.AppendElement()->AssignASCII("user_prefs");
        extraValues.AppendElement()->AppendInt(userPrefs.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#FAKESPOT_CATEGORY.
   */
  constexpr impl::EventMetric<EventFakespotCategoryExtra> event_fakespot_category(489);

  /**
   * generated from activity_stream.event_fakespot_click
   */
  struct EventFakespotClickExtra {
    mozilla::Maybe<uint32_t> actionPosition;
    mozilla::Maybe<nsCString> addonVersion;
    mozilla::Maybe<nsCString> page;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<uint32_t> userPrefs;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (actionPosition) {
        extraKeys.AppendElement()->AssignASCII("action_position");
        extraValues.AppendElement()->AppendInt(actionPosition.value());
      }
      if (addonVersion) {
        extraKeys.AppendElement()->AssignASCII("addon_version");
        extraValues.EmplaceBack(addonVersion.value());
      }
      if (page) {
        extraKeys.AppendElement()->AssignASCII("page");
        extraValues.EmplaceBack(page.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (userPrefs) {
        extraKeys.AppendElement()->AssignASCII("user_prefs");
        extraValues.AppendElement()->AppendInt(userPrefs.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#FAKESPOT_CLICK.
   */
  constexpr impl::EventMetric<EventFakespotClickExtra> event_fakespot_click(490);

  /**
   * generated from activity_stream.event_hide_personalize
   */
  struct EventHidePersonalizeExtra {
    mozilla::Maybe<uint32_t> actionPosition;
    mozilla::Maybe<nsCString> addonVersion;
    mozilla::Maybe<nsCString> page;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<uint32_t> userPrefs;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (actionPosition) {
        extraKeys.AppendElement()->AssignASCII("action_position");
        extraValues.AppendElement()->AppendInt(actionPosition.value());
      }
      if (addonVersion) {
        extraKeys.AppendElement()->AssignASCII("addon_version");
        extraValues.EmplaceBack(addonVersion.value());
      }
      if (page) {
        extraKeys.AppendElement()->AssignASCII("page");
        extraValues.EmplaceBack(page.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (userPrefs) {
        extraKeys.AppendElement()->AssignASCII("user_prefs");
        extraValues.AppendElement()->AppendInt(userPrefs.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#HIDE_PERSONALIZE.
   */
  constexpr impl::EventMetric<EventHidePersonalizeExtra> event_hide_personalize(491);

  /**
   * generated from activity_stream.event_impression
   */
  struct EventImpressionExtra {
    mozilla::Maybe<uint32_t> actionPosition;
    mozilla::Maybe<nsCString> addonVersion;
    mozilla::Maybe<nsCString> page;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<uint32_t> userPrefs;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (actionPosition) {
        extraKeys.AppendElement()->AssignASCII("action_position");
        extraValues.AppendElement()->AppendInt(actionPosition.value());
      }
      if (addonVersion) {
        extraKeys.AppendElement()->AssignASCII("addon_version");
        extraValues.EmplaceBack(addonVersion.value());
      }
      if (page) {
        extraKeys.AppendElement()->AssignASCII("page");
        extraValues.EmplaceBack(page.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (userPrefs) {
        extraKeys.AppendElement()->AssignASCII("user_prefs");
        extraValues.AppendElement()->AppendInt(userPrefs.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#IMPRESSION.
   */
  constexpr impl::EventMetric<EventImpressionExtra> event_impression(492);

  /**
   * generated from activity_stream.event_menu_add_search
   */
  struct EventMenuAddSearchExtra {
    mozilla::Maybe<uint32_t> actionPosition;
    mozilla::Maybe<nsCString> addonVersion;
    mozilla::Maybe<nsCString> page;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<uint32_t> userPrefs;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (actionPosition) {
        extraKeys.AppendElement()->AssignASCII("action_position");
        extraValues.AppendElement()->AppendInt(actionPosition.value());
      }
      if (addonVersion) {
        extraKeys.AppendElement()->AssignASCII("addon_version");
        extraValues.EmplaceBack(addonVersion.value());
      }
      if (page) {
        extraKeys.AppendElement()->AssignASCII("page");
        extraValues.EmplaceBack(page.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (userPrefs) {
        extraKeys.AppendElement()->AssignASCII("user_prefs");
        extraValues.AppendElement()->AppendInt(userPrefs.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#MENU_ADD_SEARCH.
   */
  constexpr impl::EventMetric<EventMenuAddSearchExtra> event_menu_add_search(493);

  /**
   * generated from activity_stream.event_menu_add_topsite
   */
  struct EventMenuAddTopsiteExtra {
    mozilla::Maybe<uint32_t> actionPosition;
    mozilla::Maybe<nsCString> addonVersion;
    mozilla::Maybe<nsCString> page;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<uint32_t> userPrefs;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (actionPosition) {
        extraKeys.AppendElement()->AssignASCII("action_position");
        extraValues.AppendElement()->AppendInt(actionPosition.value());
      }
      if (addonVersion) {
        extraKeys.AppendElement()->AssignASCII("addon_version");
        extraValues.EmplaceBack(addonVersion.value());
      }
      if (page) {
        extraKeys.AppendElement()->AssignASCII("page");
        extraValues.EmplaceBack(page.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (userPrefs) {
        extraKeys.AppendElement()->AssignASCII("user_prefs");
        extraValues.AppendElement()->AppendInt(userPrefs.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#MENU_ADD_TOPSITE.
   */
  constexpr impl::EventMetric<EventMenuAddTopsiteExtra> event_menu_add_topsite(494);

  /**
   * generated from activity_stream.event_menu_collapse
   */
  struct EventMenuCollapseExtra {
    mozilla::Maybe<uint32_t> actionPosition;
    mozilla::Maybe<nsCString> addonVersion;
    mozilla::Maybe<nsCString> page;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<uint32_t> userPrefs;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (actionPosition) {
        extraKeys.AppendElement()->AssignASCII("action_position");
        extraValues.AppendElement()->AppendInt(actionPosition.value());
      }
      if (addonVersion) {
        extraKeys.AppendElement()->AssignASCII("addon_version");
        extraValues.EmplaceBack(addonVersion.value());
      }
      if (page) {
        extraKeys.AppendElement()->AssignASCII("page");
        extraValues.EmplaceBack(page.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (userPrefs) {
        extraKeys.AppendElement()->AssignASCII("user_prefs");
        extraValues.AppendElement()->AppendInt(userPrefs.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#MENU_COLLAPSE.
   */
  constexpr impl::EventMetric<EventMenuCollapseExtra> event_menu_collapse(495);

  /**
   * generated from activity_stream.event_menu_expand
   */
  struct EventMenuExpandExtra {
    mozilla::Maybe<uint32_t> actionPosition;
    mozilla::Maybe<nsCString> addonVersion;
    mozilla::Maybe<nsCString> page;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<uint32_t> userPrefs;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (actionPosition) {
        extraKeys.AppendElement()->AssignASCII("action_position");
        extraValues.AppendElement()->AppendInt(actionPosition.value());
      }
      if (addonVersion) {
        extraKeys.AppendElement()->AssignASCII("addon_version");
        extraValues.EmplaceBack(addonVersion.value());
      }
      if (page) {
        extraKeys.AppendElement()->AssignASCII("page");
        extraValues.EmplaceBack(page.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (userPrefs) {
        extraKeys.AppendElement()->AssignASCII("user_prefs");
        extraValues.AppendElement()->AppendInt(userPrefs.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#MENU_EXPAND.
   */
  constexpr impl::EventMetric<EventMenuExpandExtra> event_menu_expand(496);

  /**
   * generated from activity_stream.event_menu_manage
   */
  struct EventMenuManageExtra {
    mozilla::Maybe<uint32_t> actionPosition;
    mozilla::Maybe<nsCString> addonVersion;
    mozilla::Maybe<nsCString> page;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<uint32_t> userPrefs;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (actionPosition) {
        extraKeys.AppendElement()->AssignASCII("action_position");
        extraValues.AppendElement()->AppendInt(actionPosition.value());
      }
      if (addonVersion) {
        extraKeys.AppendElement()->AssignASCII("addon_version");
        extraValues.EmplaceBack(addonVersion.value());
      }
      if (page) {
        extraKeys.AppendElement()->AssignASCII("page");
        extraValues.EmplaceBack(page.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (userPrefs) {
        extraKeys.AppendElement()->AssignASCII("user_prefs");
        extraValues.AppendElement()->AppendInt(userPrefs.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#MENU_MANAGE.
   */
  constexpr impl::EventMetric<EventMenuManageExtra> event_menu_manage(497);

  /**
   * generated from activity_stream.event_menu_move_down
   */
  struct EventMenuMoveDownExtra {
    mozilla::Maybe<uint32_t> actionPosition;
    mozilla::Maybe<nsCString> addonVersion;
    mozilla::Maybe<nsCString> page;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<uint32_t> userPrefs;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (actionPosition) {
        extraKeys.AppendElement()->AssignASCII("action_position");
        extraValues.AppendElement()->AppendInt(actionPosition.value());
      }
      if (addonVersion) {
        extraKeys.AppendElement()->AssignASCII("addon_version");
        extraValues.EmplaceBack(addonVersion.value());
      }
      if (page) {
        extraKeys.AppendElement()->AssignASCII("page");
        extraValues.EmplaceBack(page.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (userPrefs) {
        extraKeys.AppendElement()->AssignASCII("user_prefs");
        extraValues.AppendElement()->AppendInt(userPrefs.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#MENU_MOVE_DOWN.
   */
  constexpr impl::EventMetric<EventMenuMoveDownExtra> event_menu_move_down(498);

  /**
   * generated from activity_stream.event_menu_move_up
   */
  struct EventMenuMoveUpExtra {
    mozilla::Maybe<uint32_t> actionPosition;
    mozilla::Maybe<nsCString> addonVersion;
    mozilla::Maybe<nsCString> page;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<uint32_t> userPrefs;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (actionPosition) {
        extraKeys.AppendElement()->AssignASCII("action_position");
        extraValues.AppendElement()->AppendInt(actionPosition.value());
      }
      if (addonVersion) {
        extraKeys.AppendElement()->AssignASCII("addon_version");
        extraValues.EmplaceBack(addonVersion.value());
      }
      if (page) {
        extraKeys.AppendElement()->AssignASCII("page");
        extraValues.EmplaceBack(page.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (userPrefs) {
        extraKeys.AppendElement()->AssignASCII("user_prefs");
        extraValues.AppendElement()->AppendInt(userPrefs.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#MENU_MOVE_UP.
   */
  constexpr impl::EventMetric<EventMenuMoveUpExtra> event_menu_move_up(499);

  /**
   * generated from activity_stream.event_menu_privacy_notice
   */
  struct EventMenuPrivacyNoticeExtra {
    mozilla::Maybe<uint32_t> actionPosition;
    mozilla::Maybe<nsCString> addonVersion;
    mozilla::Maybe<nsCString> page;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<uint32_t> userPrefs;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (actionPosition) {
        extraKeys.AppendElement()->AssignASCII("action_position");
        extraValues.AppendElement()->AppendInt(actionPosition.value());
      }
      if (addonVersion) {
        extraKeys.AppendElement()->AssignASCII("addon_version");
        extraValues.EmplaceBack(addonVersion.value());
      }
      if (page) {
        extraKeys.AppendElement()->AssignASCII("page");
        extraValues.EmplaceBack(page.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (userPrefs) {
        extraKeys.AppendElement()->AssignASCII("user_prefs");
        extraValues.AppendElement()->AppendInt(userPrefs.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#MENU_PRIVACY_NOTICE.
   */
  constexpr impl::EventMetric<EventMenuPrivacyNoticeExtra> event_menu_privacy_notice(500);

  /**
   * generated from activity_stream.event_menu_remove
   */
  struct EventMenuRemoveExtra {
    mozilla::Maybe<uint32_t> actionPosition;
    mozilla::Maybe<nsCString> addonVersion;
    mozilla::Maybe<nsCString> page;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<uint32_t> userPrefs;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (actionPosition) {
        extraKeys.AppendElement()->AssignASCII("action_position");
        extraValues.AppendElement()->AppendInt(actionPosition.value());
      }
      if (addonVersion) {
        extraKeys.AppendElement()->AssignASCII("addon_version");
        extraValues.EmplaceBack(addonVersion.value());
      }
      if (page) {
        extraKeys.AppendElement()->AssignASCII("page");
        extraValues.EmplaceBack(page.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (userPrefs) {
        extraKeys.AppendElement()->AssignASCII("user_prefs");
        extraValues.AppendElement()->AppendInt(userPrefs.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#MENU_REMOVE.
   */
  constexpr impl::EventMetric<EventMenuRemoveExtra> event_menu_remove(501);

  /**
   * generated from activity_stream.event_migration_cancel
   */
  struct EventMigrationCancelExtra {
    mozilla::Maybe<uint32_t> actionPosition;
    mozilla::Maybe<nsCString> addonVersion;
    mozilla::Maybe<nsCString> page;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<uint32_t> userPrefs;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (actionPosition) {
        extraKeys.AppendElement()->AssignASCII("action_position");
        extraValues.AppendElement()->AppendInt(actionPosition.value());
      }
      if (addonVersion) {
        extraKeys.AppendElement()->AssignASCII("addon_version");
        extraValues.EmplaceBack(addonVersion.value());
      }
      if (page) {
        extraKeys.AppendElement()->AssignASCII("page");
        extraValues.EmplaceBack(page.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (userPrefs) {
        extraKeys.AppendElement()->AssignASCII("user_prefs");
        extraValues.AppendElement()->AppendInt(userPrefs.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#MIGRATION_CANCEL.
   */
  constexpr impl::EventMetric<EventMigrationCancelExtra> event_migration_cancel(502);

  /**
   * generated from activity_stream.event_migration_start
   */
  struct EventMigrationStartExtra {
    mozilla::Maybe<uint32_t> actionPosition;
    mozilla::Maybe<nsCString> addonVersion;
    mozilla::Maybe<nsCString> page;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<uint32_t> userPrefs;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (actionPosition) {
        extraKeys.AppendElement()->AssignASCII("action_position");
        extraValues.AppendElement()->AppendInt(actionPosition.value());
      }
      if (addonVersion) {
        extraKeys.AppendElement()->AssignASCII("addon_version");
        extraValues.EmplaceBack(addonVersion.value());
      }
      if (page) {
        extraKeys.AppendElement()->AssignASCII("page");
        extraValues.EmplaceBack(page.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (userPrefs) {
        extraKeys.AppendElement()->AssignASCII("user_prefs");
        extraValues.AppendElement()->AppendInt(userPrefs.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#MIGRATION_START.
   */
  constexpr impl::EventMetric<EventMigrationStartExtra> event_migration_start(503);

  /**
   * generated from activity_stream.event_open_new_window
   */
  struct EventOpenNewWindowExtra {
    mozilla::Maybe<uint32_t> actionPosition;
    mozilla::Maybe<nsCString> addonVersion;
    mozilla::Maybe<nsCString> page;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<uint32_t> userPrefs;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (actionPosition) {
        extraKeys.AppendElement()->AssignASCII("action_position");
        extraValues.AppendElement()->AppendInt(actionPosition.value());
      }
      if (addonVersion) {
        extraKeys.AppendElement()->AssignASCII("addon_version");
        extraValues.EmplaceBack(addonVersion.value());
      }
      if (page) {
        extraKeys.AppendElement()->AssignASCII("page");
        extraValues.EmplaceBack(page.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (userPrefs) {
        extraKeys.AppendElement()->AssignASCII("user_prefs");
        extraValues.AppendElement()->AppendInt(userPrefs.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#OPEN_NEW_WINDOW.
   */
  constexpr impl::EventMetric<EventOpenNewWindowExtra> event_open_new_window(504);

  /**
   * generated from activity_stream.event_open_newtab_prefs
   */
  struct EventOpenNewtabPrefsExtra {
    mozilla::Maybe<uint32_t> actionPosition;
    mozilla::Maybe<nsCString> addonVersion;
    mozilla::Maybe<nsCString> page;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<uint32_t> userPrefs;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (actionPosition) {
        extraKeys.AppendElement()->AssignASCII("action_position");
        extraValues.AppendElement()->AppendInt(actionPosition.value());
      }
      if (addonVersion) {
        extraKeys.AppendElement()->AssignASCII("addon_version");
        extraValues.EmplaceBack(addonVersion.value());
      }
      if (page) {
        extraKeys.AppendElement()->AssignASCII("page");
        extraValues.EmplaceBack(page.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (userPrefs) {
        extraKeys.AppendElement()->AssignASCII("user_prefs");
        extraValues.AppendElement()->AppendInt(userPrefs.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#OPEN_NEWTAB_PREFS.
   */
  constexpr impl::EventMetric<EventOpenNewtabPrefsExtra> event_open_newtab_prefs(505);

  /**
   * generated from activity_stream.event_open_private_window
   */
  struct EventOpenPrivateWindowExtra {
    mozilla::Maybe<uint32_t> actionPosition;
    mozilla::Maybe<nsCString> addonVersion;
    mozilla::Maybe<nsCString> page;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<uint32_t> userPrefs;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (actionPosition) {
        extraKeys.AppendElement()->AssignASCII("action_position");
        extraValues.AppendElement()->AppendInt(actionPosition.value());
      }
      if (addonVersion) {
        extraKeys.AppendElement()->AssignASCII("addon_version");
        extraValues.EmplaceBack(addonVersion.value());
      }
      if (page) {
        extraKeys.AppendElement()->AssignASCII("page");
        extraValues.EmplaceBack(page.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (userPrefs) {
        extraKeys.AppendElement()->AssignASCII("user_prefs");
        extraValues.AppendElement()->AppendInt(userPrefs.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#OPEN_PRIVATE_WINDOW.
   */
  constexpr impl::EventMetric<EventOpenPrivateWindowExtra> event_open_private_window(506);

  /**
   * generated from activity_stream.event_pin
   */
  struct EventPinExtra {
    mozilla::Maybe<uint32_t> actionPosition;
    mozilla::Maybe<nsCString> addonVersion;
    mozilla::Maybe<nsCString> page;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<uint32_t> userPrefs;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (actionPosition) {
        extraKeys.AppendElement()->AssignASCII("action_position");
        extraValues.AppendElement()->AppendInt(actionPosition.value());
      }
      if (addonVersion) {
        extraKeys.AppendElement()->AssignASCII("addon_version");
        extraValues.EmplaceBack(addonVersion.value());
      }
      if (page) {
        extraKeys.AppendElement()->AssignASCII("page");
        extraValues.EmplaceBack(page.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (userPrefs) {
        extraKeys.AppendElement()->AssignASCII("user_prefs");
        extraValues.AppendElement()->AppendInt(userPrefs.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#PIN.
   */
  constexpr impl::EventMetric<EventPinExtra> event_pin(507);

  /**
   * generated from activity_stream.event_pocket_thumbs_down
   */
  struct EventPocketThumbsDownExtra {
    mozilla::Maybe<uint32_t> actionPosition;
    mozilla::Maybe<nsCString> addonVersion;
    mozilla::Maybe<nsCString> page;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<uint32_t> userPrefs;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (actionPosition) {
        extraKeys.AppendElement()->AssignASCII("action_position");
        extraValues.AppendElement()->AppendInt(actionPosition.value());
      }
      if (addonVersion) {
        extraKeys.AppendElement()->AssignASCII("addon_version");
        extraValues.EmplaceBack(addonVersion.value());
      }
      if (page) {
        extraKeys.AppendElement()->AssignASCII("page");
        extraValues.EmplaceBack(page.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (userPrefs) {
        extraKeys.AppendElement()->AssignASCII("user_prefs");
        extraValues.AppendElement()->AppendInt(userPrefs.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#POCKET_THUMBS_DOWN.
   */
  constexpr impl::EventMetric<EventPocketThumbsDownExtra> event_pocket_thumbs_down(508);

  /**
   * generated from activity_stream.event_pocket_thumbs_up
   */
  struct EventPocketThumbsUpExtra {
    mozilla::Maybe<uint32_t> actionPosition;
    mozilla::Maybe<nsCString> addonVersion;
    mozilla::Maybe<nsCString> page;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<uint32_t> userPrefs;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (actionPosition) {
        extraKeys.AppendElement()->AssignASCII("action_position");
        extraValues.AppendElement()->AppendInt(actionPosition.value());
      }
      if (addonVersion) {
        extraKeys.AppendElement()->AssignASCII("addon_version");
        extraValues.EmplaceBack(addonVersion.value());
      }
      if (page) {
        extraKeys.AppendElement()->AssignASCII("page");
        extraValues.EmplaceBack(page.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (userPrefs) {
        extraKeys.AppendElement()->AssignASCII("user_prefs");
        extraValues.AppendElement()->AppendInt(userPrefs.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#POCKET_THUMBS_UP.
   */
  constexpr impl::EventMetric<EventPocketThumbsUpExtra> event_pocket_thumbs_up(509);

  /**
   * generated from activity_stream.event_pref_changed
   */
  struct EventPrefChangedExtra {
    mozilla::Maybe<uint32_t> actionPosition;
    mozilla::Maybe<nsCString> addonVersion;
    mozilla::Maybe<nsCString> page;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<uint32_t> userPrefs;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (actionPosition) {
        extraKeys.AppendElement()->AssignASCII("action_position");
        extraValues.AppendElement()->AppendInt(actionPosition.value());
      }
      if (addonVersion) {
        extraKeys.AppendElement()->AssignASCII("addon_version");
        extraValues.EmplaceBack(addonVersion.value());
      }
      if (page) {
        extraKeys.AppendElement()->AssignASCII("page");
        extraValues.EmplaceBack(page.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (userPrefs) {
        extraKeys.AppendElement()->AssignASCII("user_prefs");
        extraValues.AppendElement()->AppendInt(userPrefs.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#PREF_CHANGED.
   */
  constexpr impl::EventMetric<EventPrefChangedExtra> event_pref_changed(510);

  /**
   * generated from activity_stream.event_preview_request
   */
  struct EventPreviewRequestExtra {
    mozilla::Maybe<uint32_t> actionPosition;
    mozilla::Maybe<nsCString> addonVersion;
    mozilla::Maybe<nsCString> page;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<uint32_t> userPrefs;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (actionPosition) {
        extraKeys.AppendElement()->AssignASCII("action_position");
        extraValues.AppendElement()->AppendInt(actionPosition.value());
      }
      if (addonVersion) {
        extraKeys.AppendElement()->AssignASCII("addon_version");
        extraValues.EmplaceBack(addonVersion.value());
      }
      if (page) {
        extraKeys.AppendElement()->AssignASCII("page");
        extraValues.EmplaceBack(page.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (userPrefs) {
        extraKeys.AppendElement()->AssignASCII("user_prefs");
        extraValues.AppendElement()->AppendInt(userPrefs.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#PREVIEW_REQUEST.
   */
  constexpr impl::EventMetric<EventPreviewRequestExtra> event_preview_request(511);

  /**
   * generated from activity_stream.event_save_to_pocket
   */
  struct EventSaveToPocketExtra {
    mozilla::Maybe<uint32_t> actionPosition;
    mozilla::Maybe<nsCString> addonVersion;
    mozilla::Maybe<nsCString> page;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<uint32_t> userPrefs;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (actionPosition) {
        extraKeys.AppendElement()->AssignASCII("action_position");
        extraValues.AppendElement()->AppendInt(actionPosition.value());
      }
      if (addonVersion) {
        extraKeys.AppendElement()->AssignASCII("addon_version");
        extraValues.EmplaceBack(addonVersion.value());
      }
      if (page) {
        extraKeys.AppendElement()->AssignASCII("page");
        extraValues.EmplaceBack(page.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (userPrefs) {
        extraKeys.AppendElement()->AssignASCII("user_prefs");
        extraValues.AppendElement()->AppendInt(userPrefs.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#SAVE_TO_POCKET.
   */
  constexpr impl::EventMetric<EventSaveToPocketExtra> event_save_to_pocket(512);

  /**
   * generated from activity_stream.event_search
   */
  struct EventSearchExtra {
    mozilla::Maybe<uint32_t> actionPosition;
    mozilla::Maybe<nsCString> addonVersion;
    mozilla::Maybe<nsCString> page;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<uint32_t> userPrefs;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (actionPosition) {
        extraKeys.AppendElement()->AssignASCII("action_position");
        extraValues.AppendElement()->AppendInt(actionPosition.value());
      }
      if (addonVersion) {
        extraKeys.AppendElement()->AssignASCII("addon_version");
        extraValues.EmplaceBack(addonVersion.value());
      }
      if (page) {
        extraKeys.AppendElement()->AssignASCII("page");
        extraValues.EmplaceBack(page.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (userPrefs) {
        extraKeys.AppendElement()->AssignASCII("user_prefs");
        extraValues.AppendElement()->AppendInt(userPrefs.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#SEARCH.
   */
  constexpr impl::EventMetric<EventSearchExtra> event_search(513);

  /**
   * generated from activity_stream.event_search_edit_add
   */
  struct EventSearchEditAddExtra {
    mozilla::Maybe<uint32_t> actionPosition;
    mozilla::Maybe<nsCString> addonVersion;
    mozilla::Maybe<nsCString> page;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<uint32_t> userPrefs;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (actionPosition) {
        extraKeys.AppendElement()->AssignASCII("action_position");
        extraValues.AppendElement()->AppendInt(actionPosition.value());
      }
      if (addonVersion) {
        extraKeys.AppendElement()->AssignASCII("addon_version");
        extraValues.EmplaceBack(addonVersion.value());
      }
      if (page) {
        extraKeys.AppendElement()->AssignASCII("page");
        extraValues.EmplaceBack(page.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (userPrefs) {
        extraKeys.AppendElement()->AssignASCII("user_prefs");
        extraValues.AppendElement()->AppendInt(userPrefs.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#SEARCH_EDIT_ADD.
   */
  constexpr impl::EventMetric<EventSearchEditAddExtra> event_search_edit_add(514);

  /**
   * generated from activity_stream.event_search_edit_close
   */
  struct EventSearchEditCloseExtra {
    mozilla::Maybe<uint32_t> actionPosition;
    mozilla::Maybe<nsCString> addonVersion;
    mozilla::Maybe<nsCString> page;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<uint32_t> userPrefs;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (actionPosition) {
        extraKeys.AppendElement()->AssignASCII("action_position");
        extraValues.AppendElement()->AppendInt(actionPosition.value());
      }
      if (addonVersion) {
        extraKeys.AppendElement()->AssignASCII("addon_version");
        extraValues.EmplaceBack(addonVersion.value());
      }
      if (page) {
        extraKeys.AppendElement()->AssignASCII("page");
        extraValues.EmplaceBack(page.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (userPrefs) {
        extraKeys.AppendElement()->AssignASCII("user_prefs");
        extraValues.AppendElement()->AppendInt(userPrefs.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#SEARCH_EDIT_CLOSE.
   */
  constexpr impl::EventMetric<EventSearchEditCloseExtra> event_search_edit_close(515);

  /**
   * generated from activity_stream.event_search_edit_delete
   */
  struct EventSearchEditDeleteExtra {
    mozilla::Maybe<uint32_t> actionPosition;
    mozilla::Maybe<nsCString> addonVersion;
    mozilla::Maybe<nsCString> page;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<uint32_t> userPrefs;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (actionPosition) {
        extraKeys.AppendElement()->AssignASCII("action_position");
        extraValues.AppendElement()->AppendInt(actionPosition.value());
      }
      if (addonVersion) {
        extraKeys.AppendElement()->AssignASCII("addon_version");
        extraValues.EmplaceBack(addonVersion.value());
      }
      if (page) {
        extraKeys.AppendElement()->AssignASCII("page");
        extraValues.EmplaceBack(page.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (userPrefs) {
        extraKeys.AppendElement()->AssignASCII("user_prefs");
        extraValues.AppendElement()->AppendInt(userPrefs.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#SEARCH_EDIT_DELETE.
   */
  constexpr impl::EventMetric<EventSearchEditDeleteExtra> event_search_edit_delete(516);

  /**
   * generated from activity_stream.event_search_handoff
   */
  struct EventSearchHandoffExtra {
    mozilla::Maybe<uint32_t> actionPosition;
    mozilla::Maybe<nsCString> addonVersion;
    mozilla::Maybe<nsCString> page;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<uint32_t> userPrefs;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (actionPosition) {
        extraKeys.AppendElement()->AssignASCII("action_position");
        extraValues.AppendElement()->AppendInt(actionPosition.value());
      }
      if (addonVersion) {
        extraKeys.AppendElement()->AssignASCII("addon_version");
        extraValues.EmplaceBack(addonVersion.value());
      }
      if (page) {
        extraKeys.AppendElement()->AssignASCII("page");
        extraValues.EmplaceBack(page.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (userPrefs) {
        extraKeys.AppendElement()->AssignASCII("user_prefs");
        extraValues.AppendElement()->AppendInt(userPrefs.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#SEARCH_HANDOFF.
   */
  constexpr impl::EventMetric<EventSearchHandoffExtra> event_search_handoff(517);

  /**
   * generated from activity_stream.event_show_personalize
   */
  struct EventShowPersonalizeExtra {
    mozilla::Maybe<uint32_t> actionPosition;
    mozilla::Maybe<nsCString> addonVersion;
    mozilla::Maybe<nsCString> page;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<uint32_t> userPrefs;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (actionPosition) {
        extraKeys.AppendElement()->AssignASCII("action_position");
        extraValues.AppendElement()->AppendInt(actionPosition.value());
      }
      if (addonVersion) {
        extraKeys.AppendElement()->AssignASCII("addon_version");
        extraValues.EmplaceBack(addonVersion.value());
      }
      if (page) {
        extraKeys.AppendElement()->AssignASCII("page");
        extraValues.EmplaceBack(page.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (userPrefs) {
        extraKeys.AppendElement()->AssignASCII("user_prefs");
        extraValues.AppendElement()->AppendInt(userPrefs.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#SHOW_PERSONALIZE.
   */
  constexpr impl::EventMetric<EventShowPersonalizeExtra> event_show_personalize(518);

  /**
   * generated from activity_stream.event_show_privacy_info
   */
  struct EventShowPrivacyInfoExtra {
    mozilla::Maybe<uint32_t> actionPosition;
    mozilla::Maybe<nsCString> addonVersion;
    mozilla::Maybe<nsCString> page;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<uint32_t> userPrefs;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (actionPosition) {
        extraKeys.AppendElement()->AssignASCII("action_position");
        extraValues.AppendElement()->AppendInt(actionPosition.value());
      }
      if (addonVersion) {
        extraKeys.AppendElement()->AssignASCII("addon_version");
        extraValues.EmplaceBack(addonVersion.value());
      }
      if (page) {
        extraKeys.AppendElement()->AssignASCII("page");
        extraValues.EmplaceBack(page.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (userPrefs) {
        extraKeys.AppendElement()->AssignASCII("user_prefs");
        extraValues.AppendElement()->AppendInt(userPrefs.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#SHOW_PRIVACY_INFO.
   */
  constexpr impl::EventMetric<EventShowPrivacyInfoExtra> event_show_privacy_info(519);

  /**
   * generated from activity_stream.event_skipped_signin
   */
  struct EventSkippedSigninExtra {
    mozilla::Maybe<uint32_t> actionPosition;
    mozilla::Maybe<nsCString> addonVersion;
    mozilla::Maybe<nsCString> page;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<uint32_t> userPrefs;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (actionPosition) {
        extraKeys.AppendElement()->AssignASCII("action_position");
        extraValues.AppendElement()->AppendInt(actionPosition.value());
      }
      if (addonVersion) {
        extraKeys.AppendElement()->AssignASCII("addon_version");
        extraValues.EmplaceBack(addonVersion.value());
      }
      if (page) {
        extraKeys.AppendElement()->AssignASCII("page");
        extraValues.EmplaceBack(page.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (userPrefs) {
        extraKeys.AppendElement()->AssignASCII("user_prefs");
        extraValues.AppendElement()->AppendInt(userPrefs.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#SKIPPED_SIGNIN.
   */
  constexpr impl::EventMetric<EventSkippedSigninExtra> event_skipped_signin(520);

  /**
   * generated from activity_stream.event_submit_email
   */
  struct EventSubmitEmailExtra {
    mozilla::Maybe<uint32_t> actionPosition;
    mozilla::Maybe<nsCString> addonVersion;
    mozilla::Maybe<nsCString> page;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<uint32_t> userPrefs;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (actionPosition) {
        extraKeys.AppendElement()->AssignASCII("action_position");
        extraValues.AppendElement()->AppendInt(actionPosition.value());
      }
      if (addonVersion) {
        extraKeys.AppendElement()->AssignASCII("addon_version");
        extraValues.EmplaceBack(addonVersion.value());
      }
      if (page) {
        extraKeys.AppendElement()->AssignASCII("page");
        extraValues.EmplaceBack(page.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (userPrefs) {
        extraKeys.AppendElement()->AssignASCII("user_prefs");
        extraValues.AppendElement()->AppendInt(userPrefs.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#SUBMIT_EMAIL.
   */
  constexpr impl::EventMetric<EventSubmitEmailExtra> event_submit_email(521);

  /**
   * generated from activity_stream.event_top_sites_edit
   */
  struct EventTopSitesEditExtra {
    mozilla::Maybe<uint32_t> actionPosition;
    mozilla::Maybe<nsCString> addonVersion;
    mozilla::Maybe<nsCString> page;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<uint32_t> userPrefs;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (actionPosition) {
        extraKeys.AppendElement()->AssignASCII("action_position");
        extraValues.AppendElement()->AppendInt(actionPosition.value());
      }
      if (addonVersion) {
        extraKeys.AppendElement()->AssignASCII("addon_version");
        extraValues.EmplaceBack(addonVersion.value());
      }
      if (page) {
        extraKeys.AppendElement()->AssignASCII("page");
        extraValues.EmplaceBack(page.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (userPrefs) {
        extraKeys.AppendElement()->AssignASCII("user_prefs");
        extraValues.AppendElement()->AppendInt(userPrefs.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#TOP_SITES_EDIT.
   */
  constexpr impl::EventMetric<EventTopSitesEditExtra> event_top_sites_edit(522);

  /**
   * generated from activity_stream.event_top_sites_edit_close
   */
  struct EventTopSitesEditCloseExtra {
    mozilla::Maybe<uint32_t> actionPosition;
    mozilla::Maybe<nsCString> addonVersion;
    mozilla::Maybe<nsCString> page;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<uint32_t> userPrefs;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (actionPosition) {
        extraKeys.AppendElement()->AssignASCII("action_position");
        extraValues.AppendElement()->AppendInt(actionPosition.value());
      }
      if (addonVersion) {
        extraKeys.AppendElement()->AssignASCII("addon_version");
        extraValues.EmplaceBack(addonVersion.value());
      }
      if (page) {
        extraKeys.AppendElement()->AssignASCII("page");
        extraValues.EmplaceBack(page.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (userPrefs) {
        extraKeys.AppendElement()->AssignASCII("user_prefs");
        extraValues.AppendElement()->AppendInt(userPrefs.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#TOP_SITES_EDIT_CLOSE.
   */
  constexpr impl::EventMetric<EventTopSitesEditCloseExtra> event_top_sites_edit_close(523);

  /**
   * generated from activity_stream.event_topsite_sponsor_info
   */
  struct EventTopsiteSponsorInfoExtra {
    mozilla::Maybe<uint32_t> actionPosition;
    mozilla::Maybe<nsCString> addonVersion;
    mozilla::Maybe<nsCString> page;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<uint32_t> userPrefs;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (actionPosition) {
        extraKeys.AppendElement()->AssignASCII("action_position");
        extraValues.AppendElement()->AppendInt(actionPosition.value());
      }
      if (addonVersion) {
        extraKeys.AppendElement()->AssignASCII("addon_version");
        extraValues.EmplaceBack(addonVersion.value());
      }
      if (page) {
        extraKeys.AppendElement()->AssignASCII("page");
        extraValues.EmplaceBack(page.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (userPrefs) {
        extraKeys.AppendElement()->AssignASCII("user_prefs");
        extraValues.AppendElement()->AppendInt(userPrefs.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#TOPSITE_SPONSOR_INFO.
   */
  constexpr impl::EventMetric<EventTopsiteSponsorInfoExtra> event_topsite_sponsor_info(524);

  /**
   * generated from activity_stream.event_unpin
   */
  struct EventUnpinExtra {
    mozilla::Maybe<uint32_t> actionPosition;
    mozilla::Maybe<nsCString> addonVersion;
    mozilla::Maybe<nsCString> page;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<uint32_t> userPrefs;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (actionPosition) {
        extraKeys.AppendElement()->AssignASCII("action_position");
        extraValues.AppendElement()->AppendInt(actionPosition.value());
      }
      if (addonVersion) {
        extraKeys.AppendElement()->AssignASCII("addon_version");
        extraValues.EmplaceBack(addonVersion.value());
      }
      if (page) {
        extraKeys.AppendElement()->AssignASCII("page");
        extraValues.EmplaceBack(page.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (userPrefs) {
        extraKeys.AppendElement()->AssignASCII("user_prefs");
        extraValues.AppendElement()->AppendInt(userPrefs.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded with every user interaction on Activity Stream elements. This event was generated to correspond to the Legacy Telemetry event activity_stream.event#UNPIN.
   */
  constexpr impl::EventMetric<EventUnpinExtra> event_unpin(525);
}

namespace contextual_services_topsites {
  /**
   * generated from contextual.services.topsites.click
   * A keyed uint recording how many times the user has clicked on the sponsored TopSites on the newtab page. The key is a combination of the source and the placement of the TopSites tile (1-based). such as 'urlbar_1', 'newtab_2'. This metric was generated to correspond to the Legacy Telemetry scalar contextual.services.topsites.click.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> click(526);

  /**
   * generated from contextual.services.topsites.impression
   * A keyed uint recording how many times the user has viewed the sponsored TopSites on the newtab page. The key is a combination of the source and the placement of the TopSites tile (1-based). such as 'urlbar_1', 'newtab_2'. This metric was generated to correspond to the Legacy Telemetry scalar contextual.services.topsites.impression.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> impression(527);
}

namespace deletion_request {
  /**
   * generated from deletion.request.context_id
   * An identifier to identify users for Contextual Services user interaction pings. This metric was generated to correspond to the Legacy Telemetry scalar deletion.request.context_id.
   */
  constexpr impl::StringMetric context_id(528);

  /**
   * generated from deletion.request.impression_id
   * An identifier used by user interaction pings in Pocket/newtab and Messaging System. This metric was generated to correspond to the Legacy Telemetry scalar deletion.request.impression_id.
   */
  constexpr impl::StringMetric impression_id(529);
}

namespace newtab {
  /**
   * generated from newtab.abouthome_cache_construction
   * The length of time (in milliseconds) that it takes for the cache worker to generate the cache and return it to the main thread
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_ABOUTHOME_CACHE_CONSTRUCTION.
   */
  constexpr impl::TimingDistributionMetric abouthome_cache_construction(531);

  /**
   * generated from newtab.activity_stream_ctor_success
   * Records technical data about whether Activity Stream construction completed successfully
   */
  constexpr impl::BooleanMetric activity_stream_ctor_success(532);

  /**
   * generated from newtab.addon_ready_success
   * Records technical data about whether waiting for the newtab built-in addon readyPromise succeeded.
   */
  constexpr impl::BooleanMetric addon_ready_success(533);

  /**
   * generated from newtab.blocked_sponsors
   * The advertiser names that have been dismissed by the user.
   */
  constexpr impl::StringListMetric blocked_sponsors(534);

  /**
   * generated from newtab.closed
   */
  struct ClosedExtra {
    mozilla::Maybe<nsCString> newtabVisitId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (newtabVisitId) {
        extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
        extraValues.EmplaceBack(newtabVisitId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when newtab UI is closed by * navigation * closing the tab
   * Doesn't mean that the newtab was ever visible to a user.
   */
  constexpr impl::EventMetric<ClosedExtra> closed(535);

  /**
   * generated from newtab.fakespot_about_click
   */
  struct FakespotAboutClickExtra {
    mozilla::Maybe<nsCString> newtabVisitId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (newtabVisitId) {
        extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
        extraValues.EmplaceBack(newtabVisitId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a user the 'About Fakespot' link in TBR fakespot feed context menu
   */
  constexpr impl::EventMetric<FakespotAboutClickExtra> fakespot_about_click(536);

  /**
   * generated from newtab.fakespot_category
   */
  struct FakespotCategoryExtra {
    mozilla::Maybe<nsCString> category;
    mozilla::Maybe<nsCString> newtabVisitId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (category) {
        extraKeys.AppendElement()->AssignASCII("category");
        extraValues.EmplaceBack(category.value());
      }
      if (newtabVisitId) {
        extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
        extraValues.EmplaceBack(newtabVisitId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a user changes the category in TBR fakespot feed
   */
  constexpr impl::EventMetric<FakespotCategoryExtra> fakespot_category(537);

  /**
   * generated from newtab.fakespot_click
   */
  struct FakespotClickExtra {
    mozilla::Maybe<nsCString> category;
    mozilla::Maybe<nsCString> newtabVisitId;
    mozilla::Maybe<nsCString> productId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (category) {
        extraKeys.AppendElement()->AssignASCII("category");
        extraValues.EmplaceBack(category.value());
      }
      if (newtabVisitId) {
        extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
        extraValues.EmplaceBack(newtabVisitId.value());
      }
      if (productId) {
        extraKeys.AppendElement()->AssignASCII("product_id");
        extraValues.EmplaceBack(productId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a user clicks on a card in TBR fakespot feed
   */
  constexpr impl::EventMetric<FakespotClickExtra> fakespot_click(538);

  /**
   * generated from newtab.fakespot_cta_click
   */
  struct FakespotCtaClickExtra {
    mozilla::Maybe<nsCString> newtabVisitId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (newtabVisitId) {
        extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
        extraValues.EmplaceBack(newtabVisitId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a user clicks on the CTA in TBR fakespot feed
   */
  constexpr impl::EventMetric<FakespotCtaClickExtra> fakespot_cta_click(539);

  /**
   * generated from newtab.fakespot_dismiss
   */
  struct FakespotDismissExtra {
    mozilla::Maybe<nsCString> newtabVisitId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (newtabVisitId) {
        extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
        extraValues.EmplaceBack(newtabVisitId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a user dissmisses TBR fakespot feed
   */
  constexpr impl::EventMetric<FakespotDismissExtra> fakespot_dismiss(540);

  /**
   * generated from newtab.fakespot_product_impression
   */
  struct FakespotProductImpressionExtra {
    mozilla::Maybe<nsCString> category;
    mozilla::Maybe<nsCString> newtabVisitId;
    mozilla::Maybe<nsCString> productId;
    mozilla::Maybe<nsCString> productTitle;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (category) {
        extraKeys.AppendElement()->AssignASCII("category");
        extraValues.EmplaceBack(category.value());
      }
      if (newtabVisitId) {
        extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
        extraValues.EmplaceBack(newtabVisitId.value());
      }
      if (productId) {
        extraKeys.AppendElement()->AssignASCII("product_id");
        extraValues.EmplaceBack(productId.value());
      }
      if (productTitle) {
        extraKeys.AppendElement()->AssignASCII("product_title");
        extraValues.EmplaceBack(productTitle.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a user triggers an impression on a card in TBR fakespot feed
   */
  constexpr impl::EventMetric<FakespotProductImpressionExtra> fakespot_product_impression(541);

  /**
   * generated from newtab.homepage_category
   * The current setting of the home page. One of ["enabled", "disabled", "extension"] or any value from SiteClassifier like "known-hijacker" or "social-media". Similar to Activity Stream's PAGE_TAKEOVER_DATA event's `home_url_category`. Sampled once after newtab init.
   */
  constexpr impl::StringMetric homepage_category(542);

  /**
   * generated from newtab.inline_selection_click
   */
  struct InlineSelectionClickExtra {
    mozilla::Maybe<bool> isFollowed;
    mozilla::Maybe<nsCString> newtabVisitId;
    mozilla::Maybe<nsCString> sectionPosition;
    mozilla::Maybe<nsCString> topic;
    mozilla::Maybe<nsCString> topicPosition;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (isFollowed) {
        extraKeys.AppendElement()->AssignASCII("is_followed");
        extraValues.AppendElement()->AssignASCII(isFollowed.value() ? "true" : "false");
      }
      if (newtabVisitId) {
        extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
        extraValues.EmplaceBack(newtabVisitId.value());
      }
      if (sectionPosition) {
        extraKeys.AppendElement()->AssignASCII("section_position");
        extraValues.EmplaceBack(sectionPosition.value());
      }
      if (topic) {
        extraKeys.AppendElement()->AssignASCII("topic");
        extraValues.EmplaceBack(topic.value());
      }
      if (topicPosition) {
        extraKeys.AppendElement()->AssignASCII("topic_position");
        extraValues.EmplaceBack(topicPosition.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when there is a click on the inline selection component
   */
  constexpr impl::EventMetric<InlineSelectionClickExtra> inline_selection_click(543);

  /**
   * generated from newtab.inline_selection_impression
   */
  struct InlineSelectionImpressionExtra {
    mozilla::Maybe<nsCString> newtabVisitId;
    mozilla::Maybe<nsCString> sectionPosition;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (newtabVisitId) {
        extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
        extraValues.EmplaceBack(newtabVisitId.value());
      }
      if (sectionPosition) {
        extraKeys.AppendElement()->AssignASCII("section_position");
        extraValues.EmplaceBack(sectionPosition.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when there is an impression on the inline selection component
   */
  constexpr impl::EventMetric<InlineSelectionImpressionExtra> inline_selection_impression(544);

  /**
   * generated from newtab.locale
   * The application's locale as of when newtab's TelemetryFeed was init. Comes from `Services.local.appLocaleAsBCP47`. Looks like `en-US`.
   */
  constexpr impl::StringMetric locale(545);

  /**
   * generated from newtab.metric_registered
   * Records technical data about whether the metric registration at runtime succeeded
   */
  constexpr impl::Labeled<impl::BooleanMetric, DynamicLabel> metric_registered(546);

  /**
   * generated from newtab.newtab_category
   * The current setting of the newtab page. One of ["enabled", "disabled", "extension"] or any value from SiteClassifier like "known-hijacker" or "social-media". Similar to Activity Stream's PAGE_TAKEOVER_DATA event's `newtab_url_category`. Sampled once after newtab init.
   */
  constexpr impl::StringMetric newtab_category(547);

  /**
   * generated from newtab.opened
   */
  struct OpenedExtra {
    mozilla::Maybe<nsCString> newtabVisitId;
    mozilla::Maybe<nsCString> source;
    mozilla::Maybe<nsCString> windowInnerHeight;
    mozilla::Maybe<nsCString> windowInnerWidth;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (newtabVisitId) {
        extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
        extraValues.EmplaceBack(newtabVisitId.value());
      }
      if (source) {
        extraKeys.AppendElement()->AssignASCII("source");
        extraValues.EmplaceBack(source.value());
      }
      if (windowInnerHeight) {
        extraKeys.AppendElement()->AssignASCII("window_inner_height");
        extraValues.EmplaceBack(windowInnerHeight.value());
      }
      if (windowInnerWidth) {
        extraKeys.AppendElement()->AssignASCII("window_inner_width");
        extraValues.EmplaceBack(windowInnerWidth.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when newtab UI is opened via `about:newtab` or `about:home` or `about:welcome` and has been made visible (see `visibility_event_rcvd_ts` in [detect-user-session-start.js](https://searchfox.org/mozilla-central/source/browser/components/newtab/content-src/lib/detect-user-session-start.js)).
   */
  constexpr impl::EventMetric<OpenedExtra> opened(548);

  /**
   * generated from newtab.ping_registered
   * Records technical data about whether the ping registration at runtime succeeded
   */
  constexpr impl::Labeled<impl::BooleanMetric, DynamicLabel> ping_registered(549);

  /**
   * generated from newtab.report_content_open
   */
  struct ReportContentOpenExtra {
    mozilla::Maybe<nsCString> newtabVisitId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (newtabVisitId) {
        extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
        extraValues.EmplaceBack(newtabVisitId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when content reporting is opened from context menu
   */
  constexpr impl::EventMetric<ReportContentOpenExtra> report_content_open(550);

  /**
   * generated from newtab.report_content_submit
   */
  struct ReportContentSubmitExtra {
    mozilla::Maybe<nsCString> cardType;
    mozilla::Maybe<nsCString> corpusItemId;
    mozilla::Maybe<bool> isSectionFollowed;
    mozilla::Maybe<nsCString> newtabVisitId;
    mozilla::Maybe<uint32_t> receivedRank;
    mozilla::Maybe<uint32_t> recommendedAt;
    mozilla::Maybe<nsCString> reportReason;
    mozilla::Maybe<nsCString> scheduledCorpusItemId;
    mozilla::Maybe<nsCString> section;
    mozilla::Maybe<nsCString> sectionPosition;
    mozilla::Maybe<nsCString> title;
    mozilla::Maybe<nsCString> topic;
    mozilla::Maybe<nsCString> url;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (cardType) {
        extraKeys.AppendElement()->AssignASCII("card_type");
        extraValues.EmplaceBack(cardType.value());
      }
      if (corpusItemId) {
        extraKeys.AppendElement()->AssignASCII("corpus_item_id");
        extraValues.EmplaceBack(corpusItemId.value());
      }
      if (isSectionFollowed) {
        extraKeys.AppendElement()->AssignASCII("is_section_followed");
        extraValues.AppendElement()->AssignASCII(isSectionFollowed.value() ? "true" : "false");
      }
      if (newtabVisitId) {
        extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
        extraValues.EmplaceBack(newtabVisitId.value());
      }
      if (receivedRank) {
        extraKeys.AppendElement()->AssignASCII("received_rank");
        extraValues.AppendElement()->AppendInt(receivedRank.value());
      }
      if (recommendedAt) {
        extraKeys.AppendElement()->AssignASCII("recommended_at");
        extraValues.AppendElement()->AppendInt(recommendedAt.value());
      }
      if (reportReason) {
        extraKeys.AppendElement()->AssignASCII("report_reason");
        extraValues.EmplaceBack(reportReason.value());
      }
      if (scheduledCorpusItemId) {
        extraKeys.AppendElement()->AssignASCII("scheduled_corpus_item_id");
        extraValues.EmplaceBack(scheduledCorpusItemId.value());
      }
      if (section) {
        extraKeys.AppendElement()->AssignASCII("section");
        extraValues.EmplaceBack(section.value());
      }
      if (sectionPosition) {
        extraKeys.AppendElement()->AssignASCII("section_position");
        extraValues.EmplaceBack(sectionPosition.value());
      }
      if (title) {
        extraKeys.AppendElement()->AssignASCII("title");
        extraValues.EmplaceBack(title.value());
      }
      if (topic) {
        extraKeys.AppendElement()->AssignASCII("topic");
        extraValues.EmplaceBack(topic.value());
      }
      if (url) {
        extraKeys.AppendElement()->AssignASCII("url");
        extraValues.EmplaceBack(url.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when content reporting has been submitted
   */
  constexpr impl::EventMetric<ReportContentSubmitExtra> report_content_submit(551);

  /**
   * generated from newtab.sections_block_section
   */
  struct SectionsBlockSectionExtra {
    mozilla::Maybe<nsCString> eventSource;
    mozilla::Maybe<nsCString> newtabVisitId;
    mozilla::Maybe<nsCString> section;
    mozilla::Maybe<nsCString> sectionPosition;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (eventSource) {
        extraKeys.AppendElement()->AssignASCII("event_source");
        extraValues.EmplaceBack(eventSource.value());
      }
      if (newtabVisitId) {
        extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
        extraValues.EmplaceBack(newtabVisitId.value());
      }
      if (section) {
        extraKeys.AppendElement()->AssignASCII("section");
        extraValues.EmplaceBack(section.value());
      }
      if (sectionPosition) {
        extraKeys.AppendElement()->AssignASCII("section_position");
        extraValues.EmplaceBack(sectionPosition.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a section is blocked
   */
  constexpr impl::EventMetric<SectionsBlockSectionExtra> sections_block_section(552);

  /**
   * generated from newtab.sections_follow_section
   */
  struct SectionsFollowSectionExtra {
    mozilla::Maybe<nsCString> eventSource;
    mozilla::Maybe<nsCString> newtabVisitId;
    mozilla::Maybe<nsCString> section;
    mozilla::Maybe<nsCString> sectionPosition;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (eventSource) {
        extraKeys.AppendElement()->AssignASCII("event_source");
        extraValues.EmplaceBack(eventSource.value());
      }
      if (newtabVisitId) {
        extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
        extraValues.EmplaceBack(newtabVisitId.value());
      }
      if (section) {
        extraKeys.AppendElement()->AssignASCII("section");
        extraValues.EmplaceBack(section.value());
      }
      if (sectionPosition) {
        extraKeys.AppendElement()->AssignASCII("section_position");
        extraValues.EmplaceBack(sectionPosition.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a section is followed
   */
  constexpr impl::EventMetric<SectionsFollowSectionExtra> sections_follow_section(553);

  /**
   * generated from newtab.sections_impression
   */
  struct SectionsImpressionExtra {
    mozilla::Maybe<bool> isSectionFollowed;
    mozilla::Maybe<nsCString> newtabVisitId;
    mozilla::Maybe<nsCString> section;
    mozilla::Maybe<nsCString> sectionPosition;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (isSectionFollowed) {
        extraKeys.AppendElement()->AssignASCII("is_section_followed");
        extraValues.AppendElement()->AssignASCII(isSectionFollowed.value() ? "true" : "false");
      }
      if (newtabVisitId) {
        extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
        extraValues.EmplaceBack(newtabVisitId.value());
      }
      if (section) {
        extraKeys.AppendElement()->AssignASCII("section");
        extraValues.EmplaceBack(section.value());
      }
      if (sectionPosition) {
        extraKeys.AppendElement()->AssignASCII("section_position");
        extraValues.EmplaceBack(sectionPosition.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a section is viewport and triggers an impression event
   */
  constexpr impl::EventMetric<SectionsImpressionExtra> sections_impression(554);

  /**
   * generated from newtab.sections_unblock_section
   */
  struct SectionsUnblockSectionExtra {
    mozilla::Maybe<nsCString> eventSource;
    mozilla::Maybe<nsCString> newtabVisitId;
    mozilla::Maybe<nsCString> section;
    mozilla::Maybe<nsCString> sectionPosition;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (eventSource) {
        extraKeys.AppendElement()->AssignASCII("event_source");
        extraValues.EmplaceBack(eventSource.value());
      }
      if (newtabVisitId) {
        extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
        extraValues.EmplaceBack(newtabVisitId.value());
      }
      if (section) {
        extraKeys.AppendElement()->AssignASCII("section");
        extraValues.EmplaceBack(section.value());
      }
      if (sectionPosition) {
        extraKeys.AppendElement()->AssignASCII("section_position");
        extraValues.EmplaceBack(sectionPosition.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a section is unblocked
   */
  constexpr impl::EventMetric<SectionsUnblockSectionExtra> sections_unblock_section(555);

  /**
   * generated from newtab.sections_unfollow_section
   */
  struct SectionsUnfollowSectionExtra {
    mozilla::Maybe<nsCString> eventSource;
    mozilla::Maybe<nsCString> newtabVisitId;
    mozilla::Maybe<nsCString> section;
    mozilla::Maybe<nsCString> sectionPosition;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (eventSource) {
        extraKeys.AppendElement()->AssignASCII("event_source");
        extraValues.EmplaceBack(eventSource.value());
      }
      if (newtabVisitId) {
        extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
        extraValues.EmplaceBack(newtabVisitId.value());
      }
      if (section) {
        extraKeys.AppendElement()->AssignASCII("section");
        extraValues.EmplaceBack(section.value());
      }
      if (sectionPosition) {
        extraKeys.AppendElement()->AssignASCII("section_position");
        extraValues.EmplaceBack(sectionPosition.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a section is unfollowed
   */
  constexpr impl::EventMetric<SectionsUnfollowSectionExtra> sections_unfollow_section(556);

  /**
   * generated from newtab.selected_topics
   * The list of topics the user selected
   */
  constexpr impl::StringListMetric selected_topics(557);

  /**
   * generated from newtab.sov_allocation
   * The partner group assignment for sov
   */
  constexpr impl::StringListMetric sov_allocation(558);

  /**
   * generated from newtab.tooltip_click
   */
  struct TooltipClickExtra {
    mozilla::Maybe<nsCString> feature;
    mozilla::Maybe<nsCString> newtabVisitId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (feature) {
        extraKeys.AppendElement()->AssignASCII("feature");
        extraValues.EmplaceBack(feature.value());
      }
      if (newtabVisitId) {
        extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
        extraValues.EmplaceBack(newtabVisitId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a feature highlight tooltip is opened.
   */
  constexpr impl::EventMetric<TooltipClickExtra> tooltip_click(559);

  /**
   * generated from newtab.topic_selection_dismiss
   */
  struct TopicSelectionDismissExtra {
    mozilla::Maybe<nsCString> newtabVisitId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (newtabVisitId) {
        extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
        extraValues.EmplaceBack(newtabVisitId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the topic selection modal is dismissed (topics are not saved)
   */
  constexpr impl::EventMetric<TopicSelectionDismissExtra> topic_selection_dismiss(560);

  /**
   * generated from newtab.topic_selection_open
   */
  struct TopicSelectionOpenExtra {
    mozilla::Maybe<nsCString> newtabVisitId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (newtabVisitId) {
        extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
        extraValues.EmplaceBack(newtabVisitId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the topic selection modal is opened
   */
  constexpr impl::EventMetric<TopicSelectionOpenExtra> topic_selection_open(561);

  /**
   * generated from newtab.topic_selection_topics_saved
   */
  struct TopicSelectionTopicsSavedExtra {
    mozilla::Maybe<bool> firstSave;
    mozilla::Maybe<nsCString> newtabVisitId;
    mozilla::Maybe<nsCString> previousTopics;
    mozilla::Maybe<nsCString> topics;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (firstSave) {
        extraKeys.AppendElement()->AssignASCII("first_save");
        extraValues.AppendElement()->AssignASCII(firstSave.value() ? "true" : "false");
      }
      if (newtabVisitId) {
        extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
        extraValues.EmplaceBack(newtabVisitId.value());
      }
      if (previousTopics) {
        extraKeys.AppendElement()->AssignASCII("previous_topics");
        extraValues.EmplaceBack(previousTopics.value());
      }
      if (topics) {
        extraKeys.AppendElement()->AssignASCII("topics");
        extraValues.EmplaceBack(topics.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when topics are saved from the topics selection modal
   */
  constexpr impl::EventMetric<TopicSelectionTopicsSavedExtra> topic_selection_topics_saved(562);

  /**
   * generated from newtab.wallpaper_category_click
   */
  struct WallpaperCategoryClickExtra {
    mozilla::Maybe<nsCString> newtabVisitId;
    mozilla::Maybe<nsCString> selectedCategory;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (newtabVisitId) {
        extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
        extraValues.EmplaceBack(newtabVisitId.value());
      }
      if (selectedCategory) {
        extraKeys.AppendElement()->AssignASCII("selected_category");
        extraValues.EmplaceBack(selectedCategory.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a user clicks a wallpaper category option
   */
  constexpr impl::EventMetric<WallpaperCategoryClickExtra> wallpaper_category_click(563);

  /**
   * generated from newtab.wallpaper_click
   */
  struct WallpaperClickExtra {
    mozilla::Maybe<bool> hadPreviousWallpaper;
    mozilla::Maybe<bool> hadUploadedPreviously;
    mozilla::Maybe<nsCString> newtabVisitId;
    mozilla::Maybe<nsCString> selectedWallpaper;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (hadPreviousWallpaper) {
        extraKeys.AppendElement()->AssignASCII("had_previous_wallpaper");
        extraValues.AppendElement()->AssignASCII(hadPreviousWallpaper.value() ? "true" : "false");
      }
      if (hadUploadedPreviously) {
        extraKeys.AppendElement()->AssignASCII("had_uploaded_previously");
        extraValues.AppendElement()->AssignASCII(hadUploadedPreviously.value() ? "true" : "false");
      }
      if (newtabVisitId) {
        extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
        extraValues.EmplaceBack(newtabVisitId.value());
      }
      if (selectedWallpaper) {
        extraKeys.AppendElement()->AssignASCII("selected_wallpaper");
        extraValues.EmplaceBack(selectedWallpaper.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a user clicks on a wallpaper option
   */
  constexpr impl::EventMetric<WallpaperClickExtra> wallpaper_click(564);

  /**
   * generated from newtab.wallpaper_highlight_cta_click
   */
  struct WallpaperHighlightCtaClickExtra {
    mozilla::Maybe<nsCString> newtabVisitId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (newtabVisitId) {
        extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
        extraValues.EmplaceBack(newtabVisitId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a user clicks the CTA on the wallpaper feature highlight
   */
  constexpr impl::EventMetric<WallpaperHighlightCtaClickExtra> wallpaper_highlight_cta_click(565);

  /**
   * generated from newtab.wallpaper_highlight_dismissed
   */
  struct WallpaperHighlightDismissedExtra {
    mozilla::Maybe<nsCString> newtabVisitId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (newtabVisitId) {
        extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
        extraValues.EmplaceBack(newtabVisitId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a user dismisses the wallpaper feature highlight
   */
  constexpr impl::EventMetric<WallpaperHighlightDismissedExtra> wallpaper_highlight_dismissed(566);

  /**
   * generated from newtab.weather_change_display
   */
  struct WeatherChangeDisplayExtra {
    mozilla::Maybe<nsCString> newtabVisitId;
    mozilla::Maybe<nsCString> weatherDisplayMode;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (newtabVisitId) {
        extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
        extraValues.EmplaceBack(newtabVisitId.value());
      }
      if (weatherDisplayMode) {
        extraKeys.AppendElement()->AssignASCII("weather_display_mode");
        extraValues.EmplaceBack(weatherDisplayMode.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a user changes the weather display.
   */
  constexpr impl::EventMetric<WeatherChangeDisplayExtra> weather_change_display(567);

  /**
   * generated from newtab.weather_enabled
   * Whether the weather widget is enabled on the newtab. Corresponds to the value of the `browser.newtabpage.activity-stream.showWeather` pref.
   */
  constexpr impl::BooleanMetric weather_enabled(568);

  /**
   * generated from newtab.weather_impression
   */
  struct WeatherImpressionExtra {
    mozilla::Maybe<nsCString> newtabVisitId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (newtabVisitId) {
        extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
        extraValues.EmplaceBack(newtabVisitId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the weather widget is viewed
   */
  constexpr impl::EventMetric<WeatherImpressionExtra> weather_impression(569);

  /**
   * generated from newtab.weather_load_error
   */
  struct WeatherLoadErrorExtra {
    mozilla::Maybe<nsCString> newtabVisitId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (newtabVisitId) {
        extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
        extraValues.EmplaceBack(newtabVisitId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the weather widget is not available
   */
  constexpr impl::EventMetric<WeatherLoadErrorExtra> weather_load_error(570);

  /**
   * generated from newtab.weather_location_selected
   */
  struct WeatherLocationSelectedExtra {
    mozilla::Maybe<nsCString> newtabVisitId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (newtabVisitId) {
        extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
        extraValues.EmplaceBack(newtabVisitId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a user selects a location for weather widget
   */
  constexpr impl::EventMetric<WeatherLocationSelectedExtra> weather_location_selected(571);

  /**
   * generated from newtab.weather_open_provider_url
   */
  struct WeatherOpenProviderUrlExtra {
    mozilla::Maybe<nsCString> newtabVisitId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (newtabVisitId) {
        extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
        extraValues.EmplaceBack(newtabVisitId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a user opens a link to the Weather provider website.
   */
  constexpr impl::EventMetric<WeatherOpenProviderUrlExtra> weather_open_provider_url(572);
}

namespace newtab_handoff_preference {
  /**
   * generated from newtab.handoff_preference.enabled
   * Records whether the browser.newtabpage.activity-stream.improvesearch.handoffToAwesomebar preference is enabled or disabled
   */
  constexpr impl::BooleanMetric enabled(573);
}

namespace newtab_search {
  /**
   * generated from newtab.search.enabled
   * Whether the search input is enabled on the newtab. Corresponds to the value of the `browser.newtabpage.activity-stream.showSearch` pref.
   */
  constexpr impl::BooleanMetric enabled(574);
}

namespace newtab_content {
  /**
   * generated from newtab_content.click
   */
  struct ClickExtra {
    mozilla::Maybe<nsCString> corpusItemId;
    mozilla::Maybe<nsCString> format;
    mozilla::Maybe<bool> isListCard;
    mozilla::Maybe<bool> isSectionFollowed;
    mozilla::Maybe<bool> isSponsored;
    mozilla::Maybe<nsCString> matchesSelectedTopic;
    mozilla::Maybe<uint32_t> position;
    mozilla::Maybe<uint32_t> receivedRank;
    mozilla::Maybe<nsCString> recommendationId;
    mozilla::Maybe<uint32_t> recommendedAt;
    mozilla::Maybe<nsCString> scheduledCorpusItemId;
    mozilla::Maybe<nsCString> section;
    mozilla::Maybe<nsCString> sectionPosition;
    mozilla::Maybe<nsCString> selectedTopics;
    mozilla::Maybe<uint32_t> tileId;
    mozilla::Maybe<nsCString> topic;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (corpusItemId) {
        extraKeys.AppendElement()->AssignASCII("corpus_item_id");
        extraValues.EmplaceBack(corpusItemId.value());
      }
      if (format) {
        extraKeys.AppendElement()->AssignASCII("format");
        extraValues.EmplaceBack(format.value());
      }
      if (isListCard) {
        extraKeys.AppendElement()->AssignASCII("is_list_card");
        extraValues.AppendElement()->AssignASCII(isListCard.value() ? "true" : "false");
      }
      if (isSectionFollowed) {
        extraKeys.AppendElement()->AssignASCII("is_section_followed");
        extraValues.AppendElement()->AssignASCII(isSectionFollowed.value() ? "true" : "false");
      }
      if (isSponsored) {
        extraKeys.AppendElement()->AssignASCII("is_sponsored");
        extraValues.AppendElement()->AssignASCII(isSponsored.value() ? "true" : "false");
      }
      if (matchesSelectedTopic) {
        extraKeys.AppendElement()->AssignASCII("matches_selected_topic");
        extraValues.EmplaceBack(matchesSelectedTopic.value());
      }
      if (position) {
        extraKeys.AppendElement()->AssignASCII("position");
        extraValues.AppendElement()->AppendInt(position.value());
      }
      if (receivedRank) {
        extraKeys.AppendElement()->AssignASCII("received_rank");
        extraValues.AppendElement()->AppendInt(receivedRank.value());
      }
      if (recommendationId) {
        extraKeys.AppendElement()->AssignASCII("recommendation_id");
        extraValues.EmplaceBack(recommendationId.value());
      }
      if (recommendedAt) {
        extraKeys.AppendElement()->AssignASCII("recommended_at");
        extraValues.AppendElement()->AppendInt(recommendedAt.value());
      }
      if (scheduledCorpusItemId) {
        extraKeys.AppendElement()->AssignASCII("scheduled_corpus_item_id");
        extraValues.EmplaceBack(scheduledCorpusItemId.value());
      }
      if (section) {
        extraKeys.AppendElement()->AssignASCII("section");
        extraValues.EmplaceBack(section.value());
      }
      if (sectionPosition) {
        extraKeys.AppendElement()->AssignASCII("section_position");
        extraValues.EmplaceBack(sectionPosition.value());
      }
      if (selectedTopics) {
        extraKeys.AppendElement()->AssignASCII("selected_topics");
        extraValues.EmplaceBack(selectedTopics.value());
      }
      if (tileId) {
        extraKeys.AppendElement()->AssignASCII("tile_id");
        extraValues.AppendElement()->AppendInt(tileId.value());
      }
      if (topic) {
        extraKeys.AppendElement()->AssignASCII("topic");
        extraValues.EmplaceBack(topic.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a pocket tile is clicked. Only happens on click. Not on middle-click. Not on "Open in new Tab"-like options in the context menu.
   */
  constexpr impl::EventMetric<ClickExtra> click(576);

  /**
   * generated from newtab_content.coarse_os
   * The name of the operating system. Possible values: Android, iOS, Linux, Windows, or macOS
   */
  constexpr impl::StringMetric coarse_os(577);

  /**
   * generated from newtab_content.country
   * Records the detected home region of the user. This is the general region of the user's machine.
   * If a machine moves location, there is a minimum 2-week delay before this will be updated.
   * See the [Region documentation](https://firefox-source-docs.mozilla.org/toolkit/modules/toolkit_modules/Region.html) for more information about updates.
   */
  constexpr impl::StringMetric country(578);

  /**
   * generated from newtab_content.dismiss
   */
  struct DismissExtra {
    mozilla::Maybe<nsCString> corpusItemId;
    mozilla::Maybe<nsCString> format;
    mozilla::Maybe<bool> isSectionFollowed;
    mozilla::Maybe<bool> isSponsored;
    mozilla::Maybe<uint32_t> position;
    mozilla::Maybe<uint32_t> receivedRank;
    mozilla::Maybe<nsCString> recommendationId;
    mozilla::Maybe<uint32_t> recommendedAt;
    mozilla::Maybe<nsCString> scheduledCorpusItemId;
    mozilla::Maybe<nsCString> section;
    mozilla::Maybe<nsCString> sectionPosition;
    mozilla::Maybe<uint32_t> tileId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (corpusItemId) {
        extraKeys.AppendElement()->AssignASCII("corpus_item_id");
        extraValues.EmplaceBack(corpusItemId.value());
      }
      if (format) {
        extraKeys.AppendElement()->AssignASCII("format");
        extraValues.EmplaceBack(format.value());
      }
      if (isSectionFollowed) {
        extraKeys.AppendElement()->AssignASCII("is_section_followed");
        extraValues.AppendElement()->AssignASCII(isSectionFollowed.value() ? "true" : "false");
      }
      if (isSponsored) {
        extraKeys.AppendElement()->AssignASCII("is_sponsored");
        extraValues.AppendElement()->AssignASCII(isSponsored.value() ? "true" : "false");
      }
      if (position) {
        extraKeys.AppendElement()->AssignASCII("position");
        extraValues.AppendElement()->AppendInt(position.value());
      }
      if (receivedRank) {
        extraKeys.AppendElement()->AssignASCII("received_rank");
        extraValues.AppendElement()->AppendInt(receivedRank.value());
      }
      if (recommendationId) {
        extraKeys.AppendElement()->AssignASCII("recommendation_id");
        extraValues.EmplaceBack(recommendationId.value());
      }
      if (recommendedAt) {
        extraKeys.AppendElement()->AssignASCII("recommended_at");
        extraValues.AppendElement()->AppendInt(recommendedAt.value());
      }
      if (scheduledCorpusItemId) {
        extraKeys.AppendElement()->AssignASCII("scheduled_corpus_item_id");
        extraValues.EmplaceBack(scheduledCorpusItemId.value());
      }
      if (section) {
        extraKeys.AppendElement()->AssignASCII("section");
        extraValues.EmplaceBack(section.value());
      }
      if (sectionPosition) {
        extraKeys.AppendElement()->AssignASCII("section_position");
        extraValues.EmplaceBack(sectionPosition.value());
      }
      if (tileId) {
        extraKeys.AppendElement()->AssignASCII("tile_id");
        extraValues.AppendElement()->AppendInt(tileId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a pocket tile is dismissed.
   */
  constexpr impl::EventMetric<DismissExtra> dismiss(579);

  /**
   * generated from newtab_content.experiment_branch
   * The branch of the primary new tab content experiment. We don't include all experiments to prevent user fingerprinting.
   */
  constexpr impl::StringMetric experiment_branch(580);

  /**
   * generated from newtab_content.experiment_name
   * The name of the primary new tab content experiment. We don't include all experiments to prevent user fingerprinting.
   */
  constexpr impl::StringMetric experiment_name(581);

  /**
   * generated from newtab_content.followed_sections
   * Optional metric: section ids followed by user in alphabetical order, if possible, ordered by most recently followed. Max 2 sections
   */
  constexpr impl::StringListMetric followed_sections(582);

  /**
   * generated from newtab_content.impression
   */
  struct ImpressionExtra {
    mozilla::Maybe<nsCString> corpusItemId;
    mozilla::Maybe<nsCString> format;
    mozilla::Maybe<bool> isListCard;
    mozilla::Maybe<bool> isSectionFollowed;
    mozilla::Maybe<bool> isSponsored;
    mozilla::Maybe<uint32_t> position;
    mozilla::Maybe<uint32_t> receivedRank;
    mozilla::Maybe<nsCString> recommendationId;
    mozilla::Maybe<uint32_t> recommendedAt;
    mozilla::Maybe<nsCString> scheduledCorpusItemId;
    mozilla::Maybe<nsCString> section;
    mozilla::Maybe<nsCString> sectionPosition;
    mozilla::Maybe<nsCString> selectedTopics;
    mozilla::Maybe<uint32_t> tileId;
    mozilla::Maybe<nsCString> topic;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (corpusItemId) {
        extraKeys.AppendElement()->AssignASCII("corpus_item_id");
        extraValues.EmplaceBack(corpusItemId.value());
      }
      if (format) {
        extraKeys.AppendElement()->AssignASCII("format");
        extraValues.EmplaceBack(format.value());
      }
      if (isListCard) {
        extraKeys.AppendElement()->AssignASCII("is_list_card");
        extraValues.AppendElement()->AssignASCII(isListCard.value() ? "true" : "false");
      }
      if (isSectionFollowed) {
        extraKeys.AppendElement()->AssignASCII("is_section_followed");
        extraValues.AppendElement()->AssignASCII(isSectionFollowed.value() ? "true" : "false");
      }
      if (isSponsored) {
        extraKeys.AppendElement()->AssignASCII("is_sponsored");
        extraValues.AppendElement()->AssignASCII(isSponsored.value() ? "true" : "false");
      }
      if (position) {
        extraKeys.AppendElement()->AssignASCII("position");
        extraValues.AppendElement()->AppendInt(position.value());
      }
      if (receivedRank) {
        extraKeys.AppendElement()->AssignASCII("received_rank");
        extraValues.AppendElement()->AppendInt(receivedRank.value());
      }
      if (recommendationId) {
        extraKeys.AppendElement()->AssignASCII("recommendation_id");
        extraValues.EmplaceBack(recommendationId.value());
      }
      if (recommendedAt) {
        extraKeys.AppendElement()->AssignASCII("recommended_at");
        extraValues.AppendElement()->AppendInt(recommendedAt.value());
      }
      if (scheduledCorpusItemId) {
        extraKeys.AppendElement()->AssignASCII("scheduled_corpus_item_id");
        extraValues.EmplaceBack(scheduledCorpusItemId.value());
      }
      if (section) {
        extraKeys.AppendElement()->AssignASCII("section");
        extraValues.EmplaceBack(section.value());
      }
      if (sectionPosition) {
        extraKeys.AppendElement()->AssignASCII("section_position");
        extraValues.EmplaceBack(sectionPosition.value());
      }
      if (selectedTopics) {
        extraKeys.AppendElement()->AssignASCII("selected_topics");
        extraValues.EmplaceBack(selectedTopics.value());
      }
      if (tileId) {
        extraKeys.AppendElement()->AssignASCII("tile_id");
        extraValues.AppendElement()->AppendInt(tileId.value());
      }
      if (topic) {
        extraKeys.AppendElement()->AssignASCII("topic");
        extraValues.EmplaceBack(topic.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a pocket tile is visible to the user.
   */
  constexpr impl::EventMetric<ImpressionExtra> impression(583);


  /**
   * generated from newtab_content.sections_block_section
   */
  struct SectionsBlockSectionExtra {
    mozilla::Maybe<nsCString> eventSource;
    mozilla::Maybe<nsCString> section;
    mozilla::Maybe<nsCString> sectionPosition;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (eventSource) {
        extraKeys.AppendElement()->AssignASCII("event_source");
        extraValues.EmplaceBack(eventSource.value());
      }
      if (section) {
        extraKeys.AppendElement()->AssignASCII("section");
        extraValues.EmplaceBack(section.value());
      }
      if (sectionPosition) {
        extraKeys.AppendElement()->AssignASCII("section_position");
        extraValues.EmplaceBack(sectionPosition.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a section is blocked
   */
  constexpr impl::EventMetric<SectionsBlockSectionExtra> sections_block_section(585);

  /**
   * generated from newtab_content.sections_follow_section
   */
  struct SectionsFollowSectionExtra {
    mozilla::Maybe<nsCString> eventSource;
    mozilla::Maybe<nsCString> section;
    mozilla::Maybe<nsCString> sectionPosition;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (eventSource) {
        extraKeys.AppendElement()->AssignASCII("event_source");
        extraValues.EmplaceBack(eventSource.value());
      }
      if (section) {
        extraKeys.AppendElement()->AssignASCII("section");
        extraValues.EmplaceBack(section.value());
      }
      if (sectionPosition) {
        extraKeys.AppendElement()->AssignASCII("section_position");
        extraValues.EmplaceBack(sectionPosition.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a section is followed
   */
  constexpr impl::EventMetric<SectionsFollowSectionExtra> sections_follow_section(586);

  /**
   * generated from newtab_content.sections_impression
   */
  struct SectionsImpressionExtra {
    mozilla::Maybe<bool> isSectionFollowed;
    mozilla::Maybe<nsCString> section;
    mozilla::Maybe<nsCString> sectionPosition;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (isSectionFollowed) {
        extraKeys.AppendElement()->AssignASCII("is_section_followed");
        extraValues.AppendElement()->AssignASCII(isSectionFollowed.value() ? "true" : "false");
      }
      if (section) {
        extraKeys.AppendElement()->AssignASCII("section");
        extraValues.EmplaceBack(section.value());
      }
      if (sectionPosition) {
        extraKeys.AppendElement()->AssignASCII("section_position");
        extraValues.EmplaceBack(sectionPosition.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a section is viewport and triggers an impression event
   */
  constexpr impl::EventMetric<SectionsImpressionExtra> sections_impression(587);

  /**
   * generated from newtab_content.sections_unblock_section
   */
  struct SectionsUnblockSectionExtra {
    mozilla::Maybe<nsCString> eventSource;
    mozilla::Maybe<nsCString> section;
    mozilla::Maybe<nsCString> sectionPosition;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (eventSource) {
        extraKeys.AppendElement()->AssignASCII("event_source");
        extraValues.EmplaceBack(eventSource.value());
      }
      if (section) {
        extraKeys.AppendElement()->AssignASCII("section");
        extraValues.EmplaceBack(section.value());
      }
      if (sectionPosition) {
        extraKeys.AppendElement()->AssignASCII("section_position");
        extraValues.EmplaceBack(sectionPosition.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a section is unblocked
   */
  constexpr impl::EventMetric<SectionsUnblockSectionExtra> sections_unblock_section(588);

  /**
   * generated from newtab_content.sections_unfollow_section
   */
  struct SectionsUnfollowSectionExtra {
    mozilla::Maybe<nsCString> eventSource;
    mozilla::Maybe<nsCString> section;
    mozilla::Maybe<nsCString> sectionPosition;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (eventSource) {
        extraKeys.AppendElement()->AssignASCII("event_source");
        extraValues.EmplaceBack(eventSource.value());
      }
      if (section) {
        extraKeys.AppendElement()->AssignASCII("section");
        extraValues.EmplaceBack(section.value());
      }
      if (sectionPosition) {
        extraKeys.AppendElement()->AssignASCII("section_position");
        extraValues.EmplaceBack(sectionPosition.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a section is unfollowed
   */
  constexpr impl::EventMetric<SectionsUnfollowSectionExtra> sections_unfollow_section(589);

  /**
   * generated from newtab_content.surface_id
   * Surface id sent to the client from merino api
   */
  constexpr impl::StringMetric surface_id(590);

  /**
   * generated from newtab_content.thumb_voting_interaction
   */
  struct ThumbVotingInteractionExtra {
    mozilla::Maybe<nsCString> corpusItemId;
    mozilla::Maybe<bool> isListCard;
    mozilla::Maybe<bool> isSectionFollowed;
    mozilla::Maybe<uint32_t> receivedRank;
    mozilla::Maybe<nsCString> recommendationId;
    mozilla::Maybe<uint32_t> recommendedAt;
    mozilla::Maybe<nsCString> scheduledCorpusItemId;
    mozilla::Maybe<nsCString> section;
    mozilla::Maybe<nsCString> sectionPosition;
    mozilla::Maybe<bool> thumbsDown;
    mozilla::Maybe<bool> thumbsUp;
    mozilla::Maybe<uint32_t> tileId;
    mozilla::Maybe<nsCString> topic;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (corpusItemId) {
        extraKeys.AppendElement()->AssignASCII("corpus_item_id");
        extraValues.EmplaceBack(corpusItemId.value());
      }
      if (isListCard) {
        extraKeys.AppendElement()->AssignASCII("is_list_card");
        extraValues.AppendElement()->AssignASCII(isListCard.value() ? "true" : "false");
      }
      if (isSectionFollowed) {
        extraKeys.AppendElement()->AssignASCII("is_section_followed");
        extraValues.AppendElement()->AssignASCII(isSectionFollowed.value() ? "true" : "false");
      }
      if (receivedRank) {
        extraKeys.AppendElement()->AssignASCII("received_rank");
        extraValues.AppendElement()->AppendInt(receivedRank.value());
      }
      if (recommendationId) {
        extraKeys.AppendElement()->AssignASCII("recommendation_id");
        extraValues.EmplaceBack(recommendationId.value());
      }
      if (recommendedAt) {
        extraKeys.AppendElement()->AssignASCII("recommended_at");
        extraValues.AppendElement()->AppendInt(recommendedAt.value());
      }
      if (scheduledCorpusItemId) {
        extraKeys.AppendElement()->AssignASCII("scheduled_corpus_item_id");
        extraValues.EmplaceBack(scheduledCorpusItemId.value());
      }
      if (section) {
        extraKeys.AppendElement()->AssignASCII("section");
        extraValues.EmplaceBack(section.value());
      }
      if (sectionPosition) {
        extraKeys.AppendElement()->AssignASCII("section_position");
        extraValues.EmplaceBack(sectionPosition.value());
      }
      if (thumbsDown) {
        extraKeys.AppendElement()->AssignASCII("thumbs_down");
        extraValues.AppendElement()->AssignASCII(thumbsDown.value() ? "true" : "false");
      }
      if (thumbsUp) {
        extraKeys.AppendElement()->AssignASCII("thumbs_up");
        extraValues.AppendElement()->AssignASCII(thumbsUp.value() ? "true" : "false");
      }
      if (tileId) {
        extraKeys.AppendElement()->AssignASCII("tile_id");
        extraValues.AppendElement()->AppendInt(tileId.value());
      }
      if (topic) {
        extraKeys.AppendElement()->AssignASCII("topic");
        extraValues.EmplaceBack(topic.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a thumbs up/down on a tile is clicked. Only happens on click. Not on middle-click. Not on "Open in new Tab"-like options in the context menu.
   */
  constexpr impl::EventMetric<ThumbVotingInteractionExtra> thumb_voting_interaction(591);

  /**
   * generated from newtab_content.utc_offset
   * <0-24> positive UTC offset, rounded to the nearest integer number greater than 0. (If less than 0, then add 24.). The value may be clamped by expected time zone ranges for a surface.
   */
  constexpr impl::QuantityMetric utc_offset(592);
}

namespace pocket {
  /**
   * generated from pocket.click
   */
  struct ClickExtra {
    mozilla::Maybe<nsCString> corpusItemId;
    mozilla::Maybe<nsCString> eventSource;
    mozilla::Maybe<nsCString> format;
    mozilla::Maybe<bool> isListCard;
    mozilla::Maybe<bool> isSectionFollowed;
    mozilla::Maybe<bool> isSponsored;
    mozilla::Maybe<nsCString> matchesSelectedTopic;
    mozilla::Maybe<nsCString> newtabVisitId;
    mozilla::Maybe<uint32_t> position;
    mozilla::Maybe<uint32_t> receivedRank;
    mozilla::Maybe<nsCString> recommendationId;
    mozilla::Maybe<uint32_t> recommendedAt;
    mozilla::Maybe<nsCString> scheduledCorpusItemId;
    mozilla::Maybe<nsCString> section;
    mozilla::Maybe<nsCString> sectionPosition;
    mozilla::Maybe<nsCString> selectedTopics;
    mozilla::Maybe<uint32_t> tileId;
    mozilla::Maybe<nsCString> topic;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (corpusItemId) {
        extraKeys.AppendElement()->AssignASCII("corpus_item_id");
        extraValues.EmplaceBack(corpusItemId.value());
      }
      if (eventSource) {
        extraKeys.AppendElement()->AssignASCII("event_source");
        extraValues.EmplaceBack(eventSource.value());
      }
      if (format) {
        extraKeys.AppendElement()->AssignASCII("format");
        extraValues.EmplaceBack(format.value());
      }
      if (isListCard) {
        extraKeys.AppendElement()->AssignASCII("is_list_card");
        extraValues.AppendElement()->AssignASCII(isListCard.value() ? "true" : "false");
      }
      if (isSectionFollowed) {
        extraKeys.AppendElement()->AssignASCII("is_section_followed");
        extraValues.AppendElement()->AssignASCII(isSectionFollowed.value() ? "true" : "false");
      }
      if (isSponsored) {
        extraKeys.AppendElement()->AssignASCII("is_sponsored");
        extraValues.AppendElement()->AssignASCII(isSponsored.value() ? "true" : "false");
      }
      if (matchesSelectedTopic) {
        extraKeys.AppendElement()->AssignASCII("matches_selected_topic");
        extraValues.EmplaceBack(matchesSelectedTopic.value());
      }
      if (newtabVisitId) {
        extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
        extraValues.EmplaceBack(newtabVisitId.value());
      }
      if (position) {
        extraKeys.AppendElement()->AssignASCII("position");
        extraValues.AppendElement()->AppendInt(position.value());
      }
      if (receivedRank) {
        extraKeys.AppendElement()->AssignASCII("received_rank");
        extraValues.AppendElement()->AppendInt(receivedRank.value());
      }
      if (recommendationId) {
        extraKeys.AppendElement()->AssignASCII("recommendation_id");
        extraValues.EmplaceBack(recommendationId.value());
      }
      if (recommendedAt) {
        extraKeys.AppendElement()->AssignASCII("recommended_at");
        extraValues.AppendElement()->AppendInt(recommendedAt.value());
      }
      if (scheduledCorpusItemId) {
        extraKeys.AppendElement()->AssignASCII("scheduled_corpus_item_id");
        extraValues.EmplaceBack(scheduledCorpusItemId.value());
      }
      if (section) {
        extraKeys.AppendElement()->AssignASCII("section");
        extraValues.EmplaceBack(section.value());
      }
      if (sectionPosition) {
        extraKeys.AppendElement()->AssignASCII("section_position");
        extraValues.EmplaceBack(sectionPosition.value());
      }
      if (selectedTopics) {
        extraKeys.AppendElement()->AssignASCII("selected_topics");
        extraValues.EmplaceBack(selectedTopics.value());
      }
      if (tileId) {
        extraKeys.AppendElement()->AssignASCII("tile_id");
        extraValues.AppendElement()->AppendInt(tileId.value());
      }
      if (topic) {
        extraKeys.AppendElement()->AssignASCII("topic");
        extraValues.EmplaceBack(topic.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a pocket tile is clicked. Only happens on click. Not on middle-click. Not on "Open in new Tab"-like options in the context menu.
   */
  constexpr impl::EventMetric<ClickExtra> click(593);

  /**
   * generated from pocket.dismiss
   */
  struct DismissExtra {
    mozilla::Maybe<nsCString> corpusItemId;
    mozilla::Maybe<nsCString> format;
    mozilla::Maybe<bool> isListCard;
    mozilla::Maybe<bool> isSectionFollowed;
    mozilla::Maybe<bool> isSponsored;
    mozilla::Maybe<nsCString> newtabVisitId;
    mozilla::Maybe<uint32_t> position;
    mozilla::Maybe<uint32_t> receivedRank;
    mozilla::Maybe<nsCString> recommendationId;
    mozilla::Maybe<uint32_t> recommendedAt;
    mozilla::Maybe<nsCString> scheduledCorpusItemId;
    mozilla::Maybe<nsCString> section;
    mozilla::Maybe<nsCString> sectionPosition;
    mozilla::Maybe<uint32_t> tileId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (corpusItemId) {
        extraKeys.AppendElement()->AssignASCII("corpus_item_id");
        extraValues.EmplaceBack(corpusItemId.value());
      }
      if (format) {
        extraKeys.AppendElement()->AssignASCII("format");
        extraValues.EmplaceBack(format.value());
      }
      if (isListCard) {
        extraKeys.AppendElement()->AssignASCII("is_list_card");
        extraValues.AppendElement()->AssignASCII(isListCard.value() ? "true" : "false");
      }
      if (isSectionFollowed) {
        extraKeys.AppendElement()->AssignASCII("is_section_followed");
        extraValues.AppendElement()->AssignASCII(isSectionFollowed.value() ? "true" : "false");
      }
      if (isSponsored) {
        extraKeys.AppendElement()->AssignASCII("is_sponsored");
        extraValues.AppendElement()->AssignASCII(isSponsored.value() ? "true" : "false");
      }
      if (newtabVisitId) {
        extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
        extraValues.EmplaceBack(newtabVisitId.value());
      }
      if (position) {
        extraKeys.AppendElement()->AssignASCII("position");
        extraValues.AppendElement()->AppendInt(position.value());
      }
      if (receivedRank) {
        extraKeys.AppendElement()->AssignASCII("received_rank");
        extraValues.AppendElement()->AppendInt(receivedRank.value());
      }
      if (recommendationId) {
        extraKeys.AppendElement()->AssignASCII("recommendation_id");
        extraValues.EmplaceBack(recommendationId.value());
      }
      if (recommendedAt) {
        extraKeys.AppendElement()->AssignASCII("recommended_at");
        extraValues.AppendElement()->AppendInt(recommendedAt.value());
      }
      if (scheduledCorpusItemId) {
        extraKeys.AppendElement()->AssignASCII("scheduled_corpus_item_id");
        extraValues.EmplaceBack(scheduledCorpusItemId.value());
      }
      if (section) {
        extraKeys.AppendElement()->AssignASCII("section");
        extraValues.EmplaceBack(section.value());
      }
      if (sectionPosition) {
        extraKeys.AppendElement()->AssignASCII("section_position");
        extraValues.EmplaceBack(sectionPosition.value());
      }
      if (tileId) {
        extraKeys.AppendElement()->AssignASCII("tile_id");
        extraValues.AppendElement()->AppendInt(tileId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a pocket tile is dismissed.
   */
  constexpr impl::EventMetric<DismissExtra> dismiss(594);

  /**
   * generated from pocket.enabled
   * Whether Pocket is enabled on the newtab. AKA the "Recommended by Pocket" section. Corresponds to the value of the `browser.newtabpage.activity-stream.feeds.section.topstories` pref.
   */
  constexpr impl::BooleanMetric enabled(595);

  /**
   * generated from pocket.fetch_timestamp
   * Timestamp of when the spoc was fetched by the client
   */
  constexpr impl::DatetimeMetric fetch_timestamp(596);

  /**
   * generated from pocket.impression
   */
  struct ImpressionExtra {
    mozilla::Maybe<nsCString> corpusItemId;
    mozilla::Maybe<nsCString> format;
    mozilla::Maybe<bool> isListCard;
    mozilla::Maybe<bool> isSectionFollowed;
    mozilla::Maybe<bool> isSponsored;
    mozilla::Maybe<nsCString> newtabVisitId;
    mozilla::Maybe<uint32_t> position;
    mozilla::Maybe<uint32_t> receivedRank;
    mozilla::Maybe<nsCString> recommendationId;
    mozilla::Maybe<uint32_t> recommendedAt;
    mozilla::Maybe<nsCString> scheduledCorpusItemId;
    mozilla::Maybe<nsCString> section;
    mozilla::Maybe<nsCString> sectionPosition;
    mozilla::Maybe<nsCString> selectedTopics;
    mozilla::Maybe<uint32_t> tileId;
    mozilla::Maybe<nsCString> topic;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (corpusItemId) {
        extraKeys.AppendElement()->AssignASCII("corpus_item_id");
        extraValues.EmplaceBack(corpusItemId.value());
      }
      if (format) {
        extraKeys.AppendElement()->AssignASCII("format");
        extraValues.EmplaceBack(format.value());
      }
      if (isListCard) {
        extraKeys.AppendElement()->AssignASCII("is_list_card");
        extraValues.AppendElement()->AssignASCII(isListCard.value() ? "true" : "false");
      }
      if (isSectionFollowed) {
        extraKeys.AppendElement()->AssignASCII("is_section_followed");
        extraValues.AppendElement()->AssignASCII(isSectionFollowed.value() ? "true" : "false");
      }
      if (isSponsored) {
        extraKeys.AppendElement()->AssignASCII("is_sponsored");
        extraValues.AppendElement()->AssignASCII(isSponsored.value() ? "true" : "false");
      }
      if (newtabVisitId) {
        extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
        extraValues.EmplaceBack(newtabVisitId.value());
      }
      if (position) {
        extraKeys.AppendElement()->AssignASCII("position");
        extraValues.AppendElement()->AppendInt(position.value());
      }
      if (receivedRank) {
        extraKeys.AppendElement()->AssignASCII("received_rank");
        extraValues.AppendElement()->AppendInt(receivedRank.value());
      }
      if (recommendationId) {
        extraKeys.AppendElement()->AssignASCII("recommendation_id");
        extraValues.EmplaceBack(recommendationId.value());
      }
      if (recommendedAt) {
        extraKeys.AppendElement()->AssignASCII("recommended_at");
        extraValues.AppendElement()->AppendInt(recommendedAt.value());
      }
      if (scheduledCorpusItemId) {
        extraKeys.AppendElement()->AssignASCII("scheduled_corpus_item_id");
        extraValues.EmplaceBack(scheduledCorpusItemId.value());
      }
      if (section) {
        extraKeys.AppendElement()->AssignASCII("section");
        extraValues.EmplaceBack(section.value());
      }
      if (sectionPosition) {
        extraKeys.AppendElement()->AssignASCII("section_position");
        extraValues.EmplaceBack(sectionPosition.value());
      }
      if (selectedTopics) {
        extraKeys.AppendElement()->AssignASCII("selected_topics");
        extraValues.EmplaceBack(selectedTopics.value());
      }
      if (tileId) {
        extraKeys.AppendElement()->AssignASCII("tile_id");
        extraValues.AppendElement()->AppendInt(tileId.value());
      }
      if (topic) {
        extraKeys.AppendElement()->AssignASCII("topic");
        extraValues.EmplaceBack(topic.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a pocket tile is visible to the user.
   */
  constexpr impl::EventMetric<ImpressionExtra> impression(597);

  /**
   * generated from pocket.is_signed_in
   * Whether the Firefox user is signed in to Pocket. Does not correspond to a pref, so its value is resampled at newtab's component init and whenever there is a Discovery Stream user event.
   */
  constexpr impl::BooleanMetric is_signed_in(598);

  /**
   * generated from pocket.newtab_creation_timestamp
   * Timestamp of when this instance of the newtab was first visible to the user.
   */
  constexpr impl::DatetimeMetric newtab_creation_timestamp(599);

  /**
   * generated from pocket.save
   */
  struct SaveExtra {
    mozilla::Maybe<nsCString> corpusItemId;
    mozilla::Maybe<nsCString> format;
    mozilla::Maybe<bool> isListCard;
    mozilla::Maybe<bool> isSectionFollowed;
    mozilla::Maybe<bool> isSponsored;
    mozilla::Maybe<nsCString> matchesSelectedTopic;
    mozilla::Maybe<nsCString> newtabVisitId;
    mozilla::Maybe<uint32_t> position;
    mozilla::Maybe<uint32_t> receivedRank;
    mozilla::Maybe<nsCString> recommendationId;
    mozilla::Maybe<uint32_t> recommendedAt;
    mozilla::Maybe<nsCString> scheduledCorpusItemId;
    mozilla::Maybe<nsCString> section;
    mozilla::Maybe<nsCString> sectionPosition;
    mozilla::Maybe<nsCString> selectedTopics;
    mozilla::Maybe<uint32_t> tileId;
    mozilla::Maybe<nsCString> topic;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (corpusItemId) {
        extraKeys.AppendElement()->AssignASCII("corpus_item_id");
        extraValues.EmplaceBack(corpusItemId.value());
      }
      if (format) {
        extraKeys.AppendElement()->AssignASCII("format");
        extraValues.EmplaceBack(format.value());
      }
      if (isListCard) {
        extraKeys.AppendElement()->AssignASCII("is_list_card");
        extraValues.AppendElement()->AssignASCII(isListCard.value() ? "true" : "false");
      }
      if (isSectionFollowed) {
        extraKeys.AppendElement()->AssignASCII("is_section_followed");
        extraValues.AppendElement()->AssignASCII(isSectionFollowed.value() ? "true" : "false");
      }
      if (isSponsored) {
        extraKeys.AppendElement()->AssignASCII("is_sponsored");
        extraValues.AppendElement()->AssignASCII(isSponsored.value() ? "true" : "false");
      }
      if (matchesSelectedTopic) {
        extraKeys.AppendElement()->AssignASCII("matches_selected_topic");
        extraValues.EmplaceBack(matchesSelectedTopic.value());
      }
      if (newtabVisitId) {
        extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
        extraValues.EmplaceBack(newtabVisitId.value());
      }
      if (position) {
        extraKeys.AppendElement()->AssignASCII("position");
        extraValues.AppendElement()->AppendInt(position.value());
      }
      if (receivedRank) {
        extraKeys.AppendElement()->AssignASCII("received_rank");
        extraValues.AppendElement()->AppendInt(receivedRank.value());
      }
      if (recommendationId) {
        extraKeys.AppendElement()->AssignASCII("recommendation_id");
        extraValues.EmplaceBack(recommendationId.value());
      }
      if (recommendedAt) {
        extraKeys.AppendElement()->AssignASCII("recommended_at");
        extraValues.AppendElement()->AppendInt(recommendedAt.value());
      }
      if (scheduledCorpusItemId) {
        extraKeys.AppendElement()->AssignASCII("scheduled_corpus_item_id");
        extraValues.EmplaceBack(scheduledCorpusItemId.value());
      }
      if (section) {
        extraKeys.AppendElement()->AssignASCII("section");
        extraValues.EmplaceBack(section.value());
      }
      if (sectionPosition) {
        extraKeys.AppendElement()->AssignASCII("section_position");
        extraValues.EmplaceBack(sectionPosition.value());
      }
      if (selectedTopics) {
        extraKeys.AppendElement()->AssignASCII("selected_topics");
        extraValues.EmplaceBack(selectedTopics.value());
      }
      if (tileId) {
        extraKeys.AppendElement()->AssignASCII("tile_id");
        extraValues.AppendElement()->AppendInt(tileId.value());
      }
      if (topic) {
        extraKeys.AppendElement()->AssignASCII("topic");
        extraValues.EmplaceBack(topic.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a user decides to save a pocket tile. Does not mean it ends up successfully saved. Just that the user clicked on "Save to Pocket" in the little pocket tile menu.
   */
  constexpr impl::EventMetric<SaveExtra> save(600);

  /**
   * generated from pocket.shim
   * Opaque partner identifier for a given ad impression or engagement action,
   * unique per market and region.
   * Pocket
   * [proxies requests to ad partners](https://github.com/Pocket/proxy-server/)
   * and provides them solely with market, region, and action to generate these
   * shims. Thus, though the contents of this field are obscure, they cannot
   * identify clients.
   * At time of writing this information is a comma-separated trio.
   * The first item is an index into the proxy server's list of acceptable http
   * endpoints for contacting the ad service. The second item is a
   * several-hundred-byte base64-encoded JSON-encoded struct with fields for,
   * amongst other things, market and region. The third is unknown, but appears
   * to be a signature or checksum.
   * This shim should not be sent with the client_id.
   */
  constexpr impl::TextMetric shim(601);

  /**
   * generated from pocket.sponsored_stories_enabled
   * Whether Pocket sponsored stories are enabled on the newtab. Corresponds to the value of the `browser.newtabpage.activity-stream.showSponsored` pref. Can be `true` even if pocket.enabled is `false`.
   */
  constexpr impl::BooleanMetric sponsored_stories_enabled(602);

  /**
   * generated from pocket.thumb_voting_interaction
   */
  struct ThumbVotingInteractionExtra {
    mozilla::Maybe<nsCString> corpusItemId;
    mozilla::Maybe<nsCString> format;
    mozilla::Maybe<bool> isListCard;
    mozilla::Maybe<bool> isSectionFollowed;
    mozilla::Maybe<nsCString> newtabVisitId;
    mozilla::Maybe<uint32_t> receivedRank;
    mozilla::Maybe<nsCString> recommendationId;
    mozilla::Maybe<uint32_t> recommendedAt;
    mozilla::Maybe<nsCString> scheduledCorpusItemId;
    mozilla::Maybe<nsCString> section;
    mozilla::Maybe<nsCString> sectionPosition;
    mozilla::Maybe<bool> thumbsDown;
    mozilla::Maybe<bool> thumbsUp;
    mozilla::Maybe<uint32_t> tileId;
    mozilla::Maybe<nsCString> topic;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (corpusItemId) {
        extraKeys.AppendElement()->AssignASCII("corpus_item_id");
        extraValues.EmplaceBack(corpusItemId.value());
      }
      if (format) {
        extraKeys.AppendElement()->AssignASCII("format");
        extraValues.EmplaceBack(format.value());
      }
      if (isListCard) {
        extraKeys.AppendElement()->AssignASCII("is_list_card");
        extraValues.AppendElement()->AssignASCII(isListCard.value() ? "true" : "false");
      }
      if (isSectionFollowed) {
        extraKeys.AppendElement()->AssignASCII("is_section_followed");
        extraValues.AppendElement()->AssignASCII(isSectionFollowed.value() ? "true" : "false");
      }
      if (newtabVisitId) {
        extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
        extraValues.EmplaceBack(newtabVisitId.value());
      }
      if (receivedRank) {
        extraKeys.AppendElement()->AssignASCII("received_rank");
        extraValues.AppendElement()->AppendInt(receivedRank.value());
      }
      if (recommendationId) {
        extraKeys.AppendElement()->AssignASCII("recommendation_id");
        extraValues.EmplaceBack(recommendationId.value());
      }
      if (recommendedAt) {
        extraKeys.AppendElement()->AssignASCII("recommended_at");
        extraValues.AppendElement()->AppendInt(recommendedAt.value());
      }
      if (scheduledCorpusItemId) {
        extraKeys.AppendElement()->AssignASCII("scheduled_corpus_item_id");
        extraValues.EmplaceBack(scheduledCorpusItemId.value());
      }
      if (section) {
        extraKeys.AppendElement()->AssignASCII("section");
        extraValues.EmplaceBack(section.value());
      }
      if (sectionPosition) {
        extraKeys.AppendElement()->AssignASCII("section_position");
        extraValues.EmplaceBack(sectionPosition.value());
      }
      if (thumbsDown) {
        extraKeys.AppendElement()->AssignASCII("thumbs_down");
        extraValues.AppendElement()->AssignASCII(thumbsDown.value() ? "true" : "false");
      }
      if (thumbsUp) {
        extraKeys.AppendElement()->AssignASCII("thumbs_up");
        extraValues.AppendElement()->AssignASCII(thumbsUp.value() ? "true" : "false");
      }
      if (tileId) {
        extraKeys.AppendElement()->AssignASCII("tile_id");
        extraValues.AppendElement()->AppendInt(tileId.value());
      }
      if (topic) {
        extraKeys.AppendElement()->AssignASCII("topic");
        extraValues.EmplaceBack(topic.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a thumbs up/down on a tile is clicked. Only happens on click. Not on middle-click. Not on "Open in new Tab"-like options in the context menu.
   */
  constexpr impl::EventMetric<ThumbVotingInteractionExtra> thumb_voting_interaction(603);

  /**
   * generated from pocket.topic_click
   */
  struct TopicClickExtra {
    mozilla::Maybe<nsCString> newtabVisitId;
    mozilla::Maybe<nsCString> topic;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (newtabVisitId) {
        extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
        extraValues.EmplaceBack(newtabVisitId.value());
      }
      if (topic) {
        extraKeys.AppendElement()->AssignASCII("topic");
        extraValues.EmplaceBack(topic.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a pocket "Popular Topic" is clicked. Only happens on click. Not on middle-click. Not on "Open in new Tab"-like options in the context menu.
   */
  constexpr impl::EventMetric<TopicClickExtra> topic_click(604);
}

namespace top_sites {
  /**
   * generated from top_sites.advertiser
   * The name of the advertiser providing the sponsored TopSite.
   */
  constexpr impl::StringMetric advertiser(605);

  /**
   * generated from top_sites.context_id
   * An identifier to identify users for Contextual Services user interaction pings.
   */
  constexpr impl::UuidMetric context_id(606);

  /**
   * generated from top_sites.ping_type
   * The ping's type. In other situations might be designated by an event's name or an interaction field. E.g. "topsites-impression", "topsites-click".
   */
  constexpr impl::StringMetric ping_type(607);

  /**
   * generated from top_sites.position
   * The position (1-based) of the topsites item being interatcted with.
   */
  constexpr impl::QuantityMetric position(608);

  /**
   * generated from top_sites.reporting_url
   * The url to report this interaction to.
   */
  constexpr impl::UrlMetric reporting_url(609);

  /**
   * generated from top_sites.source
   * The source of the interaction. Always set to "newtab".
   */
  constexpr impl::StringMetric source(610);

  /**
   * generated from top_sites.tile_id
   * String-encoded number for the tile's sponsored tile id.
   */
  constexpr impl::StringMetric tile_id(611);
}

namespace topsites {
  /**
   * generated from topsites.click
   */
  struct ClickExtra {
    mozilla::Maybe<nsCString> advertiserName;
    mozilla::Maybe<bool> isSponsored;
    mozilla::Maybe<nsCString> newtabVisitId;
    mozilla::Maybe<uint32_t> position;
    mozilla::Maybe<uint32_t> tileId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (advertiserName) {
        extraKeys.AppendElement()->AssignASCII("advertiser_name");
        extraValues.EmplaceBack(advertiserName.value());
      }
      if (isSponsored) {
        extraKeys.AppendElement()->AssignASCII("is_sponsored");
        extraValues.AppendElement()->AssignASCII(isSponsored.value() ? "true" : "false");
      }
      if (newtabVisitId) {
        extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
        extraValues.EmplaceBack(newtabVisitId.value());
      }
      if (position) {
        extraKeys.AppendElement()->AssignASCII("position");
        extraValues.AppendElement()->AppendInt(position.value());
      }
      if (tileId) {
        extraKeys.AppendElement()->AssignASCII("tile_id");
        extraValues.AppendElement()->AppendInt(tileId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a topsite tile is clicked. Only happens on click. Not on middle-click. Not on "Open in new Tab"-like options in the context menu.
   */
  constexpr impl::EventMetric<ClickExtra> click(612);

  /**
   * generated from topsites.dismiss
   */
  struct DismissExtra {
    mozilla::Maybe<nsCString> advertiserName;
    mozilla::Maybe<bool> isSponsored;
    mozilla::Maybe<nsCString> newtabVisitId;
    mozilla::Maybe<uint32_t> position;
    mozilla::Maybe<uint32_t> tileId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (advertiserName) {
        extraKeys.AppendElement()->AssignASCII("advertiser_name");
        extraValues.EmplaceBack(advertiserName.value());
      }
      if (isSponsored) {
        extraKeys.AppendElement()->AssignASCII("is_sponsored");
        extraValues.AppendElement()->AssignASCII(isSponsored.value() ? "true" : "false");
      }
      if (newtabVisitId) {
        extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
        extraValues.EmplaceBack(newtabVisitId.value());
      }
      if (position) {
        extraKeys.AppendElement()->AssignASCII("position");
        extraValues.AppendElement()->AppendInt(position.value());
      }
      if (tileId) {
        extraKeys.AppendElement()->AssignASCII("tile_id");
        extraValues.AppendElement()->AppendInt(tileId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the "Dismiss" menu item in the three-dots menu of a topsite is clicked. Corresponds to the receipt of a dispatched `BLOCK_URL` action by `TelemetryFeed`. Applies to both sponsored and non-sponsored topsites. `advertiser_name` is only provided for sponsored topsites.
   */
  constexpr impl::EventMetric<DismissExtra> dismiss(613);

  /**
   * generated from topsites.enabled
   * Whether "topsites" is enabled on the newtab. AKA the "Shortcuts" section. Corresponds to the value of the `browser.newtabpage.activity-stream.feeds.topsites` pref.
   */
  constexpr impl::BooleanMetric enabled(614);

  /**
   * generated from topsites.impression
   */
  struct ImpressionExtra {
    mozilla::Maybe<nsCString> advertiserName;
    mozilla::Maybe<bool> isSponsored;
    mozilla::Maybe<nsCString> newtabVisitId;
    mozilla::Maybe<uint32_t> position;
    mozilla::Maybe<uint32_t> tileId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (advertiserName) {
        extraKeys.AppendElement()->AssignASCII("advertiser_name");
        extraValues.EmplaceBack(advertiserName.value());
      }
      if (isSponsored) {
        extraKeys.AppendElement()->AssignASCII("is_sponsored");
        extraValues.AppendElement()->AssignASCII(isSponsored.value() ? "true" : "false");
      }
      if (newtabVisitId) {
        extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
        extraValues.EmplaceBack(newtabVisitId.value());
      }
      if (position) {
        extraKeys.AppendElement()->AssignASCII("position");
        extraValues.AppendElement()->AppendInt(position.value());
      }
      if (tileId) {
        extraKeys.AppendElement()->AssignASCII("tile_id");
        extraValues.AppendElement()->AppendInt(tileId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when topsite tiles are loaded.
   */
  constexpr impl::EventMetric<ImpressionExtra> impression(615);

  /**
   * generated from topsites.pref_changed
   */
  struct PrefChangedExtra {
    mozilla::Maybe<bool> newValue;
    mozilla::Maybe<nsCString> prefName;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (newValue) {
        extraKeys.AppendElement()->AssignASCII("new_value");
        extraValues.AppendElement()->AssignASCII(newValue.value() ? "true" : "false");
      }
      if (prefName) {
        extraKeys.AppendElement()->AssignASCII("pref_name");
        extraValues.EmplaceBack(prefName.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when specific topsites prefs have changed.
   * The list of possible prefs is presently:
   *  * browser.newtabpage.activity-stream.feeds.topsites
   *  * browser.newtabpage.activity-stream.showSponsoredTopSites
   */
  constexpr impl::EventMetric<PrefChangedExtra> pref_changed(616);

  /**
   * generated from topsites.rows
   * The number of topsite tile rows configured to be shown on the newtab page. Corresponds to the value of the `browser.newtabpage.activity-stream.topSitesRows` pref. This is not the number of rows actually seen by the user: if the browser window is partially off-screen, or isn't wide enough to accommodate eight tiles per row, the actual number of rows may be different.
   */
  constexpr impl::QuantityMetric rows(617);

  /**
   * generated from topsites.show_privacy_click
   */
  struct ShowPrivacyClickExtra {
    mozilla::Maybe<nsCString> advertiserName;
    mozilla::Maybe<nsCString> newtabVisitId;
    mozilla::Maybe<uint32_t> position;
    mozilla::Maybe<uint32_t> tileId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (advertiserName) {
        extraKeys.AppendElement()->AssignASCII("advertiser_name");
        extraValues.EmplaceBack(advertiserName.value());
      }
      if (newtabVisitId) {
        extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
        extraValues.EmplaceBack(newtabVisitId.value());
      }
      if (position) {
        extraKeys.AppendElement()->AssignASCII("position");
        extraValues.AppendElement()->AppendInt(position.value());
      }
      if (tileId) {
        extraKeys.AppendElement()->AssignASCII("tile_id");
        extraValues.AppendElement()->AppendInt(tileId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the "Our Sponsors and Your Privacy" menu item in the three- dots menu of a sponsored topsite is clicked. Corresponds to the receipt of a dispatched `ABOUT_SPONSORED_TOP_SITES` action by `TelemetryFeed`.
   */
  constexpr impl::EventMetric<ShowPrivacyClickExtra> show_privacy_click(618);

  /**
   * generated from topsites.sponsored_enabled
   * Whether sponsored topsites are enabled on the newtab. AKA the "Sponsored Shortcuts" section. Corresponds to the value of the `browser.newtabpage.activity-stream.showSponsoredTopSites` pref. Can be `true` even if topsites.enabled is `false`.
   */
  constexpr impl::BooleanMetric sponsored_enabled(619);

  /**
   * generated from topsites.sponsored_tiles_configured
   * The number of topsite tiles configured to be shown on newtab.
   */
  constexpr impl::QuantityMetric sponsored_tiles_configured(620);

  /**
   * generated from topsites.sponsored_tiles_received
   * The stringified JSON of tiles processed for display (array of objects). Includes tiles not displayed and reason for not displaying. Fields included: advertiser, provider, display_position, display_fail_reason.
   */
  constexpr impl::TextMetric sponsored_tiles_received(621);
}

} // namespace mozilla::glean

#endif // mozilla_GleanNewtabMetrics_h
