// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanDevtoolsClientAccessibilityMetrics_h
#define mozilla_GleanDevtoolsClientAccessibilityMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace devtools_accessibility {
  /**
   * generated from devtools.accessibility.accessible_context_menu_item_activated
   * Number of times a context menu item for an accessible object was activated (with mouse or keyboard) from the context menu opened in the accessibility tree. Keyed by the id of the context menu item. This metric was generated to correspond to the Legacy Telemetry scalar devtools.accessibility.accessible_context_menu_item_activated.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DynamicLabel> accessible_context_menu_item_activated(1079);

  /**
   * generated from devtools.accessibility.accessible_context_menu_opened
   * Number of times a context menu was opened for an accessible object in the accessibility tree. This metric was generated to correspond to the Legacy Telemetry scalar devtools.accessibility.accessible_context_menu_opened.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> accessible_context_menu_opened(1080);

  /**
   * generated from devtools.accessibility.audit_activated
   * Number of times accessibility audit was activated (with mouse or keyboard) from the accessibility panel's toolbar. Keyed by the audit filter type (e.g. "CONTRAST"). This metric was generated to correspond to the Legacy Telemetry scalar devtools.accessibility.audit_activated.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DynamicLabel> audit_activated(1081);

  /**
   * generated from devtools.accessibility.node_inspected_count
   * Number of times a DOM node was inspected from within the Accessibility tool. This metric was generated to correspond to the Legacy Telemetry scalar devtools.accessibility.node_inspected_count.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> node_inspected_count(1082);

  /**
   * generated from devtools.accessibility.select_accessible_for_node
   * Number of times an accessible object was inspected from outside the Accessibility tool (navigation to Accessibility panel). Keyed by the source of user action (inspector context menu, browser context menu, etc). This metric was generated to correspond to the Legacy Telemetry scalar devtools.accessibility.select_accessible_for_node.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DynamicLabel> select_accessible_for_node(1083);

  /**
   * generated from devtools.accessibility.simulation_activated
   * Number of times accessibility simulation was activated (with mouse or keyboard) from the accessibility panel's toolbar. Keyed by the simulation type (e.g. "DEUTERANOPIA"). This metric was generated to correspond to the Legacy Telemetry scalar devtools.accessibility.simulation_activated.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DynamicLabel> simulation_activated(1084);
}

} // namespace mozilla::glean

#endif // mozilla_GleanDevtoolsClientAccessibilityMetrics_h
