/* Any copyright is dedicated to the Public Domain.
   http://creativecommons.org/publicdomain/zero/1.0/ */
/* eslint-disable mozilla/no-arbitrary-setTimeout */

const tabState = {
  entries: [
    {
      url: "about:robots",
      triggeringPrincipal_base64,
      children: [{ url: "about:mozilla", triggeringPrincipal_base64 }],
    },
  ],
};

const blankState = {
  windows: [
    {
      tabs: [
        {
          entries: [{ url: "about:blank", triggeringPrincipal_base64 }],
        },
      ],
    },
  ],
};

add_task(async function test() {
  Services.prefs.setIntPref("browser.sessionstore.interval", 4000);
  registerCleanupFunction(function () {
    Services.prefs.clearUserPref("browser.sessionstore.interval");
  });

  let tab = BrowserTestUtils.addTab(gBrowser, "about:blank");
  let browser = tab.linkedBrowser;
  await BrowserTestUtils.browserLoaded(browser, false, "about:blank");

  await promiseTabState(tab, tabState);
  let sessionHistory = browser.browsingContext.sessionHistory;
  let entry = sessionHistory.getEntryAtIndex(0);

  await whenChildCount(entry, 1);

  // Create a dynamic subframe.
  let doc = browser.contentDocument;
  let iframe = doc.createElement("iframe");
  iframe.setAttribute("src", "about:mozilla");
  doc.body.appendChild(iframe);

  await whenChildCount(entry, 2);

  // Force reload the browser to discard the subframes.
  browser.reloadWithFlags(Ci.nsIWebNavigation.LOAD_FLAGS_BYPASS_CACHE);

  await BrowserTestUtils.browserLoaded(browser, false, "about:robots");
  await TabStateFlusher.flush(browser);

  let { entries } = JSON.parse(ss.getTabState(tab));
  is(entries.length, 1, "tab has one history entry");
  ok(!entries[0].children, "history entry has no subframes");

  // Make sure that we reset the state.
  waitForBrowserState(blankState, finish);
});

function whenChildCount(aEntry, aChildCount) {
  return TestUtils.waitForCondition(
    () => aEntry.childCount == aChildCount,
    "wait for child count"
  );
}
