/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim: set ts=8 sts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_Components_h
#define mozilla_Components_h

#include "nsCOMPtr.h"

struct nsID;

#define NS_IMPL_COMPONENT_FACTORY(iface) \
  template <>                            \
  already_AddRefed<nsISupports> mozCreateComponent<iface>()

template <typename T>
already_AddRefed<nsISupports> mozCreateComponent();

namespace mozilla {
namespace xpcom {

enum class ModuleID : uint16_t {
  Anonymous175,
  Anonymous179,
  Anonymous355,
  Anonymous098,
  Anonymous432,
  Anonymous174,
  Anonymous074,
  Anonymous185,
  Anonymous003,
  Anonymous246,
  Anonymous419,
  Anonymous195,
  Anonymous434,
  Anonymous139,
  Anonymous032,
  Anonymous029,
  UrlClassifierUtils,
  Anonymous435,
  Anonymous453,
  Anonymous075,
  Anonymous286,
  Anonymous372,
  ChromeRegistry,
  Anonymous150,
  Anonymous212,
  Anonymous135,
  Anonymous090,
  Anonymous458,
  Anonymous261,
  Anonymous272,
  Anonymous000,
  Anonymous409,
  UUIDGenerator,
  Anonymous317,
  History,
  Anonymous243,
  Anonymous374,
  IO,
  Anonymous059,
  Anonymous114,
  Anonymous332,
  Anonymous023,
  Prefetch,
  Anonymous313,
  Anonymous060,
  Anonymous016,
  Anonymous420,
  Anonymous259,
  Anonymous280,
  Anonymous231,
  Anonymous363,
  Anonymous202,
  Alerts,
  Anonymous397,
  Anonymous204,
  Anonymous071,
  Anonymous436,
  Anonymous445,
  Anonymous265,
  Anonymous371,
  Anonymous314,
  Anonymous302,
  Anonymous116,
  Anonymous037,
  Anonymous013,
  Observer,
  Anonymous449,
  Anonymous274,
  Anonymous289,
  ApplicationReputation,
  Anonymous373,
  Anonymous118,
  Anonymous260,
  Anonymous047,
  Anonymous022,
  Anonymous028,
  Anonymous362,
  Anonymous017,
  Anonymous222,
  Anonymous102,
  Anonymous451,
  Anonymous337,
  Anonymous054,
  Anonymous106,
  Anonymous105,
  Anonymous197,
  Anonymous220,
  Anonymous354,
  Anonymous287,
  TypeAheadFind,
  Anonymous331,
  Anonymous288,
  Anonymous444,
  Anonymous323,
  Anonymous263,
  Anonymous011,
  Anonymous162,
  Anonymous388,
  Anonymous293,
  Anonymous338,
  Anonymous307,
  Anonymous439,
  Anonymous081,
  Anonymous172,
  Anonymous368,
  Anonymous161,
  Anonymous282,
  Anonymous251,
  DownloadPlatform,
  Anonymous312,
  Anonymous006,
  Anonymous097,
  Anonymous300,
  AsyncShutdown,
  Anonymous110,
  Anonymous005,
  Anonymous275,
  Anonymous167,
  Anonymous352,
  Anonymous151,
  Anonymous078,
  Anonymous176,
  Anonymous203,
  Anonymous447,
  Anonymous264,
  Anonymous079,
  Anonymous411,
  Anonymous035,
  Anonymous020,
  Anonymous122,
  Anonymous064,
  Anonymous438,
  Anonymous140,
  Anonymous031,
  Anonymous089,
  Anonymous417,
  Anonymous183,
  Directory,
  Anonymous377,
  Anonymous303,
  Anonymous039,
  Anonymous194,
  Anonymous413,
  Anonymous107,
  Anonymous429,
  Anonymous132,
  Anonymous144,
  Anonymous126,
  Anonymous271,
  Anonymous315,
  Anonymous283,
  Anonymous268,
  Anonymous091,
  Anonymous321,
  Anonymous330,
  Anonymous340,
  Anonymous201,
  Anonymous216,
  Anonymous350,
  Anonymous427,
  Anonymous333,
  Anonymous252,
  Anonymous146,
  Anonymous235,
  Anonymous349,
  Anonymous278,
  Anonymous386,
  Anonymous042,
  Anonymous129,
  Anonymous169,
  Anonymous431,
  Anonymous168,
  Anonymous153,
  Anonymous123,
  Anonymous147,
  Anonymous191,
  Anonymous240,
  Anonymous043,
  Anonymous115,
  Anonymous356,
  Anonymous380,
  Anonymous015,
  Anonymous094,
  Anonymous381,
  Anonymous200,
  Anonymous361,
  Anonymous072,
  Anonymous100,
  Anonymous149,
  Anonymous077,
  Anonymous036,
  Anonymous329,
  GfxInfo,
  HttpActivityDistributor,
  Anonymous351,
  Anonymous227,
  Anonymous298,
  Anonymous111,
  Anonymous281,
  Anonymous121,
  CacheStorage,
  Anonymous389,
  Anonymous124,
  Anonymous067,
  Anonymous099,
  Anonymous292,
  Anonymous063,
  Anonymous219,
  Anonymous310,
  Anonymous076,
  Anonymous019,
  SocketTransport,
  PermissionManager,
  Anonymous141,
  Anonymous199,
  Anonymous376,
  Anonymous430,
  Anonymous324,
  Anonymous401,
  Anonymous306,
  Anonymous068,
  Anonymous030,
  Anonymous109,
  Anonymous319,
  Anonymous410,
  IdentityCredentialPromptService,
  Anonymous048,
  Anonymous258,
  Anonymous133,
  Anonymous256,
  Anonymous393,
  Anonymous069,
  Anonymous404,
  Anonymous229,
  Anonymous311,
  Anonymous405,
  Anonymous061,
  Anonymous215,
  Anonymous295,
  Anonymous188,
  Anonymous177,
  Anonymous026,
  Anonymous418,
  Anonymous395,
  AddonContentPolicy,
  Anonymous210,
  Anonymous382,
  DNS,
  Anonymous267,
  Anonymous407,
  Anonymous421,
  Anonymous056,
  StringBundle,
  Anonymous025,
  Anonymous198,
  Anonymous234,
  Anonymous358,
  Anonymous342,
  Anonymous137,
  Anonymous159,
  Anonymous446,
  Anonymous052,
  Anonymous244,
  Anonymous440,
  Anonymous085,
  Anonymous242,
  XULRuntime,
  Anonymous034,
  Anonymous181,
  Anonymous134,
  Anonymous164,
  Anonymous189,
  Preferences,
  Anonymous400,
  Anonymous001,
  Anonymous112,
  Anonymous369,
  Anonymous171,
  Anonymous266,
  Anonymous095,
  Anonymous424,
  Anonymous459,
  Anonymous379,
  FindService,
  UrlClassifierStreamUpdater,
  Anonymous367,
  ThirdPartyUtil,
  Anonymous208,
  Anonymous344,
  Anonymous230,
  Anonymous253,
  Anonymous239,
  Anonymous316,
  Anonymous250,
  Anonymous187,
  Anonymous009,
  Anonymous248,
  Anonymous004,
  Anonymous073,
  Anonymous209,
  Anonymous322,
  Anonymous224,
  Anonymous045,
  Anonymous320,
  Anonymous394,
  Anonymous412,
  Anonymous341,
  Anonymous437,
  Anonymous070,
  Anonymous119,
  Anonymous058,
  Anonymous318,
  UrlClassifierPrefixSet,
  Anonymous391,
  Anonymous441,
  Anonymous127,
  Anonymous093,
  Anonymous245,
  Anonymous214,
  Anonymous050,
  Anonymous345,
  Anonymous113,
  Anonymous370,
  Anonymous364,
  Anonymous270,
  Anonymous092,
  Anonymous233,
  Anonymous096,
  Anonymous213,
  Anonymous305,
  Anonymous384,
  Anonymous196,
  Anonymous205,
  Anonymous136,
  Anonymous416,
  Anonymous108,
  Anonymous257,
  Anonymous236,
  Anonymous008,
  Anonymous291,
  Anonymous046,
  Anonymous262,
  Anonymous255,
  Anonymous125,
  Anonymous087,
  Anonymous365,
  Anonymous385,
  Anonymous403,
  Anonymous353,
  Anonymous309,
  Anonymous294,
  Anonymous276,
  Anonymous158,
  LoginReputation,
  Anonymous103,
  UrlClassifierDB,
  Anonymous062,
  Anonymous221,
  Anonymous007,
  Anonymous396,
  Anonymous218,
  Anonymous044,
  Anonymous211,
  Anonymous131,
  Anonymous101,
  Anonymous066,
  Anonymous378,
  Anonymous010,
  Anonymous145,
  Anonymous241,
  Anonymous327,
  Anonymous012,
  Anonymous051,
  Anonymous166,
  Anonymous325,
  AppStartup,
  Anonymous027,
  Anonymous422,
  Anonymous297,
  Anonymous415,
  Anonymous455,
  Anonymous390,
  DocLoader,
  Anonymous173,
  Anonymous178,
  Anonymous024,
  Anonymous249,
  Anonymous334,
  Anonymous308,
  Anonymous452,
  Anonymous160,
  StreamTransport,
  Anonymous142,
  Anonymous138,
  Anonymous104,
  Anonymous120,
  Anonymous360,
  Anonymous226,
  Anonymous375,
  Anonymous088,
  Anonymous180,
  Anonymous277,
  Anonymous296,
  Anonymous301,
  Anonymous460,
  Anonymous190,
  Anonymous128,
  Anonymous021,
  Anonymous254,
  Anonymous049,
  Anonymous406,
  Anonymous157,
  Anonymous186,
  Anonymous148,
  Anonymous423,
  Anonymous383,
  URIFixup,
  Anonymous454,
  Anonymous170,
  Anonymous269,
  Anonymous033,
  Anonymous232,
  AlertNotification,
  Anonymous247,
  Anonymous357,
  Anonymous163,
  Anonymous359,
  Anonymous193,
  Anonymous448,
  Anonymous082,
  Anonymous326,
  Anonymous084,
  Anonymous002,
  Anonymous279,
  Anonymous290,
  Anonymous228,
  Anonymous225,
  Anonymous055,
  Anonymous083,
  ServiceWorkerManager,
  Anonymous223,
  Anonymous284,
  Anonymous428,
  Anonymous165,
  Anonymous053,
  Anonymous038,
  Anonymous366,
  Anonymous086,
  IdentityCredentialStorageService,
  ExternalProtocolHandler,
  Anonymous335,
  Anonymous237,
  Anonymous117,
  Anonymous130,
  Anonymous273,
  Anonymous343,
  Anonymous457,
  Anonymous328,
  Anonymous182,
  Anonymous065,
  Anonymous040,
  Anonymous184,
  Anonymous018,
  Anonymous392,
  Anonymous207,
  Anonymous080,
  ExtensionPolicy,
  Anonymous346,
  URILoader,
  Anonymous152,
  Anonymous336,
  Anonymous299,
  Anonymous304,
  Anonymous399,
  Anonymous442,
  Anonymous156,
  Anonymous425,
  Anonymous339,
  Anonymous154,
  CookieBannerService,
  Anonymous433,
  Anonymous456,
  Anonymous285,
  Anonymous206,
  Anonymous398,
  Anonymous414,
  Anonymous155,
  Anonymous143,
  Anonymous057,
  Anonymous347,
  Anonymous443,
  Anonymous348,
  Anonymous014,
  Anonymous450,
  Anonymous387,
  Anonymous238,
  Anonymous426,
  Anonymous402,
  URLQueryStringStripper,
  Anonymous217,
  Anonymous408,
  Anonymous041,
  Anonymous192,

};

// May be added as a friend function to allow constructing services via
// private constructors and init methods.
nsresult CreateInstanceImpl(ModuleID aID, const nsIID& aIID, void** aResult);

class MOZ_STACK_CLASS StaticModuleHelper : public nsCOMPtr_helper {
 public:
  StaticModuleHelper(ModuleID aId, nsresult* aErrorPtr)
      : mId(aId), mErrorPtr(aErrorPtr) {}

 protected:
  nsresult SetResult(nsresult aRv) const {
    if (mErrorPtr) {
      *mErrorPtr = aRv;
    }
    return aRv;
  }

  ModuleID mId;
  nsresult* mErrorPtr;
};

class MOZ_STACK_CLASS GetServiceHelper final : public StaticModuleHelper {
 public:
  using StaticModuleHelper::StaticModuleHelper;

  nsresult NS_FASTCALL operator()(const nsIID& aIID,
                                  void** aResult) const override;
};

class MOZ_STACK_CLASS CreateInstanceHelper final : public StaticModuleHelper {
 public:
  using StaticModuleHelper::StaticModuleHelper;

  nsresult NS_FASTCALL operator()(const nsIID& aIID,
                                  void** aResult) const override;
};

class Components final {
 public:
  static const nsID& GetCID(ModuleID aID);
};

}  // namespace xpcom

namespace components {

namespace AddonContentPolicy {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::AddonContentPolicy);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AddonContentPolicy, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AddonContentPolicy, aRv};
}
}  // namespace AddonContentPolicy

namespace AlertNotification {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::AlertNotification);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AlertNotification, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AlertNotification, aRv};
}
}  // namespace AlertNotification

namespace Alerts {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Alerts);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Alerts, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Alerts, aRv};
}
}  // namespace Alerts

namespace AppStartup {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::AppStartup);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AppStartup, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AppStartup, aRv};
}
}  // namespace AppStartup

namespace ApplicationReputation {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ApplicationReputation);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ApplicationReputation, aRv};
}
}  // namespace ApplicationReputation

namespace AsyncShutdown {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::AsyncShutdown);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AsyncShutdown, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AsyncShutdown, aRv};
}
}  // namespace AsyncShutdown

namespace CacheStorage {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::CacheStorage);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::CacheStorage, aRv};
}
}  // namespace CacheStorage

namespace ChromeRegistry {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ChromeRegistry);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ChromeRegistry, aRv};
}
}  // namespace ChromeRegistry

namespace CookieBannerService {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::CookieBannerService);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::CookieBannerService, aRv};
}
}  // namespace CookieBannerService

namespace DNS {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::DNS);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::DNS, aRv};
}
}  // namespace DNS

namespace Directory {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Directory);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Directory, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Directory, aRv};
}
}  // namespace Directory

namespace DocLoader {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::DocLoader);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::DocLoader, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::DocLoader, aRv};
}
}  // namespace DocLoader

namespace DownloadPlatform {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::DownloadPlatform);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::DownloadPlatform, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::DownloadPlatform, aRv};
}
}  // namespace DownloadPlatform

namespace ExtensionPolicy {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ExtensionPolicy);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ExtensionPolicy, aRv};
}
}  // namespace ExtensionPolicy

namespace ExternalProtocolHandler {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ExternalProtocolHandler);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ExternalProtocolHandler, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ExternalProtocolHandler, aRv};
}
}  // namespace ExternalProtocolHandler

namespace FindService {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::FindService);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::FindService, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::FindService, aRv};
}
}  // namespace FindService

namespace GfxInfo {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::GfxInfo);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::GfxInfo, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::GfxInfo, aRv};
}
}  // namespace GfxInfo

namespace History {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::History);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::History, aRv};
}
}  // namespace History

namespace HttpActivityDistributor {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::HttpActivityDistributor);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::HttpActivityDistributor, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::HttpActivityDistributor, aRv};
}
}  // namespace HttpActivityDistributor

namespace IO {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::IO);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::IO, aRv};
}
}  // namespace IO

namespace IdentityCredentialPromptService {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::IdentityCredentialPromptService);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::IdentityCredentialPromptService, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::IdentityCredentialPromptService, aRv};
}
}  // namespace IdentityCredentialPromptService

namespace IdentityCredentialStorageService {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::IdentityCredentialStorageService);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::IdentityCredentialStorageService, aRv};
}
}  // namespace IdentityCredentialStorageService

namespace LoginReputation {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::LoginReputation);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::LoginReputation, aRv};
}
}  // namespace LoginReputation

namespace Observer {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Observer);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Observer, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Observer, aRv};
}
}  // namespace Observer

namespace PermissionManager {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::PermissionManager);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::PermissionManager, aRv};
}
}  // namespace PermissionManager

namespace Preferences {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Preferences);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Preferences, aRv};
}
}  // namespace Preferences

namespace Prefetch {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Prefetch);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Prefetch, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Prefetch, aRv};
}
}  // namespace Prefetch

namespace ServiceWorkerManager {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ServiceWorkerManager);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ServiceWorkerManager, aRv};
}
}  // namespace ServiceWorkerManager

namespace SocketTransport {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::SocketTransport);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::SocketTransport, aRv};
}
}  // namespace SocketTransport

namespace StreamTransport {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::StreamTransport);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::StreamTransport, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::StreamTransport, aRv};
}
}  // namespace StreamTransport

namespace StringBundle {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::StringBundle);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::StringBundle, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::StringBundle, aRv};
}
}  // namespace StringBundle

namespace ThirdPartyUtil {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ThirdPartyUtil);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ThirdPartyUtil, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ThirdPartyUtil, aRv};
}
}  // namespace ThirdPartyUtil

namespace TypeAheadFind {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::TypeAheadFind);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::TypeAheadFind, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::TypeAheadFind, aRv};
}
}  // namespace TypeAheadFind

namespace URIFixup {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::URIFixup);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::URIFixup, aRv};
}
}  // namespace URIFixup

namespace URILoader {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::URILoader);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::URILoader, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::URILoader, aRv};
}
}  // namespace URILoader

namespace URLQueryStringStripper {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::URLQueryStringStripper);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::URLQueryStringStripper, aRv};
}
}  // namespace URLQueryStringStripper

namespace UUIDGenerator {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::UUIDGenerator);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UUIDGenerator, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UUIDGenerator, aRv};
}
}  // namespace UUIDGenerator

namespace UrlClassifierDB {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::UrlClassifierDB);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierDB, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierDB, aRv};
}
}  // namespace UrlClassifierDB

namespace UrlClassifierPrefixSet {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::UrlClassifierPrefixSet);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierPrefixSet, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierPrefixSet, aRv};
}
}  // namespace UrlClassifierPrefixSet

namespace UrlClassifierStreamUpdater {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::UrlClassifierStreamUpdater);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierStreamUpdater, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierStreamUpdater, aRv};
}
}  // namespace UrlClassifierStreamUpdater

namespace UrlClassifierUtils {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::UrlClassifierUtils);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierUtils, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierUtils, aRv};
}
}  // namespace UrlClassifierUtils

namespace XULRuntime {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::XULRuntime);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::XULRuntime, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::XULRuntime, aRv};
}
}  // namespace XULRuntime

}  // namespace components

}  // namespace mozilla

#endif
