/* THIS FILE IS AUTOGENERATED FROM WebTaskScheduling.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_WebTaskSchedulingBinding_h
#define mozilla_dom_WebTaskSchedulingBinding_h

#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/Span.h"
#include "mozilla/dom/AbortSignal.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/CallbackFunction.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/ToJSValue.h"

namespace mozilla {
namespace dom {

class AbortSignal;
struct NativePropertyHooks;
class ProtoAndIfaceCache;
class SchedulerPostTaskCallback;
struct SchedulerPostTaskOptionsAtoms;
struct TaskControllerInitAtoms;
class TaskSignal;
class WebTaskController;
class WebTaskScheduler;

} // namespace dom
} // namespace mozilla

namespace mozilla::dom {

enum class TaskPriority : uint8_t {
  User_blocking,
  User_visible,
  Background,
  EndGuard_
};

namespace TaskPriorityValues {
extern const EnumEntry strings[4];

static constexpr size_t Count = 3;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(TaskPriority::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(TaskPriority stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace TaskPriorityValues

bool
ToJSValue(JSContext* aCx, TaskPriority aArgument, JS::MutableHandle<JS::Value> aValue);


class SchedulerPostTaskCallback : public CallbackFunction
{
public:
  explicit inline SchedulerPostTaskCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aCallbackGlobal, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCx, aCallback, aCallbackGlobal, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline SchedulerPostTaskCallback(JSObject* aCallback, JSObject* aCallbackGlobal, const FastCallbackConstructor& )
    : CallbackFunction(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline SchedulerPostTaskCallback(JSObject* aCallback, JSObject* aCallbackGlobal, JSObject* aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aCallbackGlobal, aAsyncStack, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline SchedulerPostTaskCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline void
  Call(const T& thisVal, JS::MutableHandle<JS::Value> aRetVal, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "SchedulerPostTaskCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetCallContext(), thisValJS, aRetVal, aRv);
  }

  MOZ_CAN_RUN_SCRIPT inline void
  Call(JS::MutableHandle<JS::Value> aRetVal, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "SchedulerPostTaskCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    return Call(s.GetCallContext(), JS::UndefinedHandleValue, aRetVal, aRv);
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline void
  Call(const T& thisVal, JS::MutableHandle<JS::Value> aRetVal, const char* aExecutionReason = nullptr)
  {
    return Call(thisVal, aRetVal, IgnoreErrors(), aExecutionReason);
  }

  MOZ_CAN_RUN_SCRIPT inline void
  Call(JS::MutableHandle<JS::Value> aRetVal, const char* aExecutionReason = nullptr)
  {
    return Call(aRetVal, IgnoreErrors(), aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const SchedulerPostTaskCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  MOZ_CAN_RUN_SCRIPT void Call(BindingCallContext& cx, JS::Handle<JS::Value> aThisVal, JS::MutableHandle<JS::Value> aRetVal, ErrorResult& aRv);
};


namespace binding_detail {
class FastSchedulerPostTaskCallback : public SchedulerPostTaskCallback
{
public:
  explicit inline FastSchedulerPostTaskCallback(JSObject* aCallback, JSObject* aCallbackGlobal)
    : SchedulerPostTaskCallback(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    SchedulerPostTaskCallback::Trace(aTracer);
  }

  inline void
  FinishSlowJSInitIfMoreThanOneOwner(JSContext* aCx)
  {
    SchedulerPostTaskCallback::FinishSlowJSInitIfMoreThanOneOwner(aCx);
  }
};
} // namespace binding_detail


struct SchedulerPostTaskOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR uint64_t mDelay;
  MOZ_INIT_OUTSIDE_CTOR Optional<TaskPriority> mPriority;
  MOZ_INIT_OUTSIDE_CTOR Optional<OwningNonNull<mozilla::dom::AbortSignal>> mSignal;

  SchedulerPostTaskOptions();

  explicit inline SchedulerPostTaskOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  SchedulerPostTaskOptions(SchedulerPostTaskOptions&& aOther) = default;

  explicit inline SchedulerPostTaskOptions(const SchedulerPostTaskOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mSignal, "mSignal", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mSignal);
  }

  SchedulerPostTaskOptions&
  operator=(const SchedulerPostTaskOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, SchedulerPostTaskOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastSchedulerPostTaskOptions : public SchedulerPostTaskOptions
{
  inline FastSchedulerPostTaskOptions()
    : SchedulerPostTaskOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct TaskControllerInit : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR TaskPriority mPriority;

  TaskControllerInit();

  explicit inline TaskControllerInit(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  TaskControllerInit(TaskControllerInit&& aOther) = default;

  explicit inline TaskControllerInit(const TaskControllerInit& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  TaskControllerInit&
  operator=(const TaskControllerInit& aOther);

private:
  static bool
  InitIds(JSContext* cx, TaskControllerInitAtoms* atomsCache);
};

namespace binding_detail {
struct FastTaskControllerInit : public TaskControllerInit
{
  inline FastTaskControllerInit()
    : TaskControllerInit(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace Scheduler_Binding {

  typedef mozilla::dom::WebTaskScheduler NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::WebTaskScheduler* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::Scheduler,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::Scheduler,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::Scheduler,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace Scheduler_Binding



namespace TaskController_Binding {

  typedef mozilla::dom::WebTaskController NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::WebTaskController* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::TaskController,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::TaskController,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::TaskController,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace TaskController_Binding



namespace TaskSignal_Binding {

  typedef mozilla::dom::TaskSignal NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::TaskSignal* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::TaskSignal,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::TaskSignal,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::TaskSignal,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace TaskSignal_Binding



} // namespace mozilla::dom

#endif // mozilla_dom_WebTaskSchedulingBinding_h
