/* THIS FILE IS AUTOGENERATED FROM FetchObserver.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_FetchObserverBinding_h
#define mozilla_dom_FetchObserverBinding_h

#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/CallbackInterface.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/ToJSValue.h"

namespace mozilla {
namespace dom {

class FetchObserver;
struct NativePropertyHooks;
class ObserverCallback;
struct ObserverCallbackAtoms;
class ProtoAndIfaceCache;

} // namespace dom
} // namespace mozilla

namespace mozilla::dom {

enum class FetchState : uint8_t {
  Requesting,
  Responding,
  Aborted,
  Errored,
  Complete,
  EndGuard_
};

namespace FetchStateValues {
extern const EnumEntry strings[6];

static constexpr size_t Count = 5;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(FetchState::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(FetchState stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace FetchStateValues

bool
ToJSValue(JSContext* aCx, FetchState aArgument, JS::MutableHandle<JS::Value> aValue);


namespace FetchObserver_Binding {

  typedef mozilla::dom::FetchObserver NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::FetchObserver* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::FetchObserver,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::FetchObserver,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::FetchObserver,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace FetchObserver_Binding



class ObserverCallback : public CallbackInterface
{
public:
  explicit inline ObserverCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aCallbackGlobal, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCx, aCallback, aCallbackGlobal, aIncumbentGlobal)
  {
  }

  explicit inline ObserverCallback(JSObject* aCallback, JSObject* aCallbackGlobal, const FastCallbackConstructor& )
    : CallbackInterface(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
  }

  explicit inline ObserverCallback(JSObject* aCallback, JSObject* aCallbackGlobal, JSObject* aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCallback, aCallbackGlobal, aAsyncStack, aIncumbentGlobal)
  {
  }

  template <typename T>
  inline void
  HandleEvent(const T& thisVal, FetchObserver& observer, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "ObserverCallback.handleEvent";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return HandleEvent(s.GetCallContext(), thisValJS, observer, aRv);
  }

  inline void
  HandleEvent(FetchObserver& observer, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "ObserverCallback.handleEvent";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    return HandleEvent(s.GetCallContext(), JS::UndefinedHandleValue, observer, aRv);
  }

  template <typename T>
  inline void
  HandleEvent(const T& thisVal, FetchObserver& observer, const char* aExecutionReason = nullptr)
  {
    return HandleEvent(thisVal, observer, IgnoreErrors(), aExecutionReason);
  }

  inline void
  HandleEvent(FetchObserver& observer, const char* aExecutionReason = nullptr)
  {
    return HandleEvent(observer, IgnoreErrors(), aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const ObserverCallback& aOther) const
  {
    return CallbackInterface::operator==(aOther);
  }

private:
  void HandleEvent(BindingCallContext& cx, JS::Handle<JS::Value> aThisVal, FetchObserver& observer, ErrorResult& aRv);

  static bool
  InitIds(JSContext* cx, ObserverCallbackAtoms* atomsCache);
};


namespace binding_detail {
class FastObserverCallback : public ObserverCallback
{
public:
  explicit inline FastObserverCallback(JSObject* aCallback, JSObject* aCallbackGlobal)
    : ObserverCallback(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    ObserverCallback::Trace(aTracer);
  }

  inline void
  FinishSlowJSInitIfMoreThanOneOwner(JSContext* aCx)
  {
    ObserverCallback::FinishSlowJSInitIfMoreThanOneOwner(aCx);
  }
};
} // namespace binding_detail


} // namespace mozilla::dom

#endif // mozilla_dom_FetchObserverBinding_h
